/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import java.io.PrintStream;

public class KMLGenerator {
    static final String firstLine = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    static final String secondLine = "<kml xmlns=\"http://www.opengis.net/kml/2.2\">";

    public static String startTag(String s) {
        return "<" + s + ">";
    }

    public static String endTag(String s) {
        return "</" + s + ">";
    }

    public static void printlnStartTag(PrintStream PS, String s) {
        PS.println(KMLGenerator.startTag(s));
    }

    public static void printlnEndTag(PrintStream PS, String s) {
        PS.println(KMLGenerator.endTag(s));
    }

    public static void printInitialLines(PrintStream PS) {
        PS.println(firstLine);
        PS.println(secondLine);
        KMLGenerator.printlnStartTag(PS, "Document");
    }

    public static void printFinalLines(PrintStream PS) {
        KMLGenerator.printlnEndTag(PS, "Document");
        KMLGenerator.printlnEndTag(PS, "kml");
    }

    public static void printTextTag(PrintStream PS, String tagName, String text) {
        KMLGenerator.printlnStartTag(PS, tagName);
        PS.println(text);
        KMLGenerator.printlnEndTag(PS, tagName);
    }

    public static String textTag(String tagName, String text) {
        return KMLGenerator.startTag(tagName) + text + KMLGenerator.endTag(tagName);
    }

    public static void printName(PrintStream PS, String name) {
        KMLGenerator.printTextTag(PS, "name", name);
    }

    public static void printDescription(PrintStream PS, String description) {
        KMLGenerator.printTextTag(PS, "description", description);
    }

    public static void printLookAt(PrintStream PS, double latitude, double longitude, double altitude) {
        String tagName = "LookAt";
        KMLGenerator.printlnStartTag(PS, tagName);
        PS.println(KMLGenerator.textTag("longitude", Double.toString(longitude)));
        PS.println(KMLGenerator.textTag("latitude", Double.toString(latitude)));
        PS.println(KMLGenerator.textTag("altitude", Double.toString(altitude)));
        KMLGenerator.printlnEndTag(PS, tagName);
    }

    public static void printPlacemarkStart(PrintStream PS) {
        KMLGenerator.printlnStartTag(PS, "Placemark");
    }

    public static void printPlacemarkStart(PrintStream PS, String name, String description) {
        KMLGenerator.printlnStartTag(PS, "Placemark");
        KMLGenerator.printTextTag(PS, "name", name);
        KMLGenerator.printTextTag(PS, "description", description);
    }

    public static void printPlacemarkEnd(PrintStream PS) {
        KMLGenerator.printlnEndTag(PS, "Placemark");
    }

    public static void printPlacemarkPoint(PrintStream PS, String name, String description, double latitude, double longitude) {
        KMLGenerator.printPlacemarkStart(PS, name, description);
        KMLGenerator.printPoint(PS, latitude, longitude);
        KMLGenerator.printPlacemarkEnd(PS);
    }

    public static void printPoint(PrintStream PS, double latitude, double longitude) {
        String tagName = "Point";
        KMLGenerator.printlnStartTag(PS, tagName);
        KMLGenerator.printCoordinates(PS, latitude, longitude);
        KMLGenerator.printlnEndTag(PS, tagName);
    }

    public static String coordinateString(double latitude, double longitude) {
        return longitude + ", " + latitude + ", 0";
    }

    public static void printCoordinates(PrintStream PS, double latitude, double longitude) {
        String tagName = "coordinates";
        PS.println(KMLGenerator.startTag(tagName) + KMLGenerator.coordinateString(latitude, longitude) + KMLGenerator.endTag(tagName));
    }

    public static void printCoordinates(PrintStream PS, double latitude1, double longitude1, double latitude2, double longitude2) {
        String tagName = "coordinates";
        KMLGenerator.printlnStartTag(PS, tagName);
        PS.println(KMLGenerator.coordinateString(latitude1, longitude1));
        PS.println(KMLGenerator.coordinateString(latitude2, longitude2));
        KMLGenerator.printlnEndTag(PS, tagName);
    }

    public static void printCoordinates(PrintStream PS, double[] latitude, double[] longitude) {
        String tagName = "coordinates";
        KMLGenerator.printlnStartTag(PS, tagName);
        for (int c = 0; c < latitude.length; ++c) {
            PS.println(KMLGenerator.coordinateString(latitude[c], longitude[c]));
        }
        KMLGenerator.printlnEndTag(PS, tagName);
    }

    public static void printPlacemarkLine(PrintStream PS, boolean tesselateOn, String name, String description, double latitude1, double longitude1, double latitude2, double longitude2) {
        KMLGenerator.printPlacemarkStart(PS, name, description);
        String tagName = "LineString";
        KMLGenerator.printlnStartTag(PS, tagName);
        PS.println(KMLGenerator.startTag("tessellate") + (tesselateOn ? 1 : 0) + KMLGenerator.endTag("tessellate"));
        KMLGenerator.printCoordinates(PS, latitude1, longitude1, latitude2, longitude2);
        KMLGenerator.printlnEndTag(PS, tagName);
        KMLGenerator.printPlacemarkEnd(PS);
    }
}

