/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import java.awt.Color;
import java.io.PrintStream;

public class JavaColours {
    static final int NUMBERSHADES = 6;
    static final int MAXDEVIATION = 204;
    static final Color[] FIXEDCOLOUR = new Color[]{Color.WHITE, Color.RED, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.CYAN, Color.PINK, Color.ORANGE, Color.YELLOW, Color.GRAY, Color.DARK_GRAY, Color.LIGHT_GRAY, Color.BLACK};
    static final Color DARKRED = new Color(96, 0, 0);
    static final Color DARKGREEN = new Color(0, 96, 0);
    static final Color DARKBLUE = new Color(0, 0, 96);
    static final Color X11DARKORANGE = new Color(255, 140, 0);
    static final Color X11PURPLE = new Color(128, 0, 128);
    static final Color OLIVE = new Color(102, 102, 0);
    static final Color X11DARKGOLDENROD = new Color(184, 134, 11);
    static final Color X11PINK = new Color(155, 192, 203);
    static final Color[] TIMCOLOUR = new Color[]{Color.WHITE, Color.RED, Color.GREEN, Color.BLUE, Color.CYAN, Color.MAGENTA, Color.YELLOW, DARKRED, DARKGREEN, DARKBLUE, X11DARKORANGE, X11PURPLE, OLIVE, X11DARKGOLDENROD, X11PINK, Color.DARK_GRAY, Color.LIGHT_GRAY, Color.BLACK};
    private final int numberColours;
    private final int shadeScale;
    public Color[] javaColour;

    public JavaColours() {
        this.numberColours = TIMCOLOUR.length - 1;
        this.shadeScale = -1;
        this.javaColour = new Color[this.numberColours + 1];
        System.arraycopy(TIMCOLOUR, 0, this.javaColour, 0, TIMCOLOUR.length);
    }

    public JavaColours(int nc, boolean fixed) {
        if (fixed && nc < TIMCOLOUR.length) {
            this.shadeScale = -1;
            this.numberColours = nc;
            this.javaColour = new Color[this.numberColours + 1];
            this.javaColour[0] = Color.WHITE;
            this.javaColour[this.numberColours] = Color.BLACK;
            System.arraycopy(TIMCOLOUR, 1, this.javaColour, 1, this.numberColours - 1);
        } else {
            this.numberColours = nc >= 1224 ? 1224 : nc;
            if (this.numberColours - 2 < 6) {
                this.shadeScale = 0;
            } else {
                int divisions = (this.numberColours - 2) / 6;
                this.shadeScale = Math.round(204.0f / (float)divisions);
            }
            this.setColours();
        }
    }

    public int getNumberColours() {
        return this.numberColours;
    }

    public Color getColour(int c) {
        if (c < 0) {
            return this.javaColour[0];
        }
        if (c >= this.numberColours) {
            return this.javaColour[this.numberColours];
        }
        return this.javaColour[c];
    }

    private void setColours() {
        this.javaColour = new Color[this.numberColours + 1];
        this.javaColour[0] = Color.WHITE;
        this.javaColour[this.numberColours] = Color.BLACK;
        for (int c = 1; c < this.numberColours; ++c) {
            this.javaColour[c] = this.selectColour(c);
        }
    }

    public Color selectColour(int c) {
        if (c >= this.numberColours) {
            return Color.BLACK;
        }
        if (c <= 0) {
            return Color.WHITE;
        }
        int s = 255 - (c - 1) / 6 * this.shadeScale;
        Color nc = Color.BLACK;
        switch ((c - 1) % 6) {
            case 0: {
                nc = new Color(s, 0, 0);
                break;
            }
            case 1: {
                nc = new Color(0, s, 0);
                break;
            }
            case 2: {
                nc = new Color(0, 0, s);
                break;
            }
            case 3: {
                nc = new Color(s, s, 0);
                break;
            }
            case 4: {
                nc = new Color(0, s, s);
                break;
            }
            case 5: {
                nc = new Color(s, 0, s);
                break;
            }
            case 6: {
                nc = s < 255 ? new Color(s, s, s) : Color.BLACK;
            }
        }
        return nc;
    }

    public String RGB(int c) {
        Color nc = this.javaColour[c % this.javaColour.length];
        return JavaColours.RGB(nc);
    }

    public static String RGB(Color nc) {
        int red = nc.getRed();
        int green = nc.getGreen();
        int blue = nc.getBlue();
        String s = String.format("%02x%02x%02x", red, green, blue);
        return s;
    }

    public Color getFixedColour(int c) {
        if (c >= FIXEDCOLOUR.length || c >= this.numberColours) {
            return Color.BLACK;
        }
        if (c <= 0) {
            return Color.WHITE;
        }
        return FIXEDCOLOUR[c];
    }

    public Color getTimColour(int c) {
        if (c >= TIMCOLOUR.length || c >= this.numberColours) {
            return Color.BLACK;
        }
        if (c <= 0) {
            return Color.WHITE;
        }
        return TIMCOLOUR[c];
    }

    public void printColourInfo(PrintStream PS) {
        PS.println("Number of Colours " + this.numberColours + ", using " + (this.shadeScale < 0 ? "fixed" : "variable") + " colour scheme");
    }

    public void printColour(PrintStream PS, int c) {
        Color nc = this.javaColour[c];
        PS.println("Colour " + c + ", R=" + nc.getRed() + ", G=" + nc.getGreen() + ", B=" + nc.getBlue() + ", RGB=" + this.RGB(c));
    }

    public void printAllColours(PrintStream PS) {
        for (int c = 0; c <= this.numberColours; ++c) {
            this.printColour(PS, c);
        }
    }
}

