/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import java.io.PrintStream;

public class GeneralMode {
    private int uniqueNameLength = 3;
    private int number = 0;
    public String[] name;
    String[] longName;

    public GeneralMode() {
    }

    public GeneralMode(String[] newName, String[] newLongName) {
        this.setUp(newName, newLongName, 0);
    }

    public GeneralMode(String[] newName, String[] newLongName, int newNumber) {
        this.setUp(newName, newLongName, newNumber);
    }

    public GeneralMode(GeneralMode old) {
        this.name = old.name;
        this.longName = old.longName;
        this.uniqueNameLength = old.uniqueNameLength;
        this.set(old.number);
    }

    protected void setUp(String[] newName, String[] newLongName, int n) {
        this.name = newName;
        this.longName = newLongName;
        if (this.name.length != this.longName.length) {
            throw new IllegalArgumentException("name and longName have different lengths" + this.name.length + " != " + this.longName.length);
        }
        this.set(n);
    }

    protected void setUp(String[] newName, String[] newLongName, String mode) {
        this.name = newName;
        this.longName = newLongName;
        if (this.name.length != this.longName.length) {
            throw new IllegalArgumentException("name and longName have different lengths" + this.name.length + " != " + this.longName.length);
        }
        this.setFromName(mode);
    }

    public void set(double newNumber) {
        this.set(Math.round(newNumber));
    }

    public void set(int newNumber) {
        if (!this.testModeNumber(newNumber)) {
            throw new IllegalArgumentException("Mode number must be between 0 and " + this.getNumberModes());
        }
        this.number = newNumber;
    }

    public void setFromDouble(String newNumber) {
        this.set(Double.parseDouble(newNumber));
    }

    public void setFromName(String name) {
        this.set(this.getIndex(name));
    }

    public boolean setFromExactName(String name) {
        int n = this.getIndexFromExactName(name);
        if (n < 0) {
            return false;
        }
        this.set(n);
        return true;
    }

    public boolean testModeNumber(int m) {
        return m >= 0 && m < this.name.length;
    }

    public int getNumber() {
        return this.number;
    }

    public int getIndex(String input) {
        String s = input.substring(0, this.uniqueNameLength);
        for (int v = 0; v < this.name.length; ++v) {
            if (!this.name[v].startsWith(s)) continue;
            return v;
        }
        return -1;
    }

    public static int getIndex(String input, String[] list, int uniqueNameLength) {
        String s = input.substring(0, uniqueNameLength);
        for (int v = 0; v < list.length; ++v) {
            if (!list[v].startsWith(s)) continue;
            return v;
        }
        return -1;
    }

    public int getIndexFromExactName(String input) {
        for (int v = 0; v < this.name.length; ++v) {
            if (!this.name[v].equalsIgnoreCase(input)) continue;
            return v;
        }
        return -1;
    }

    public void setUniqueNameLength(int l) {
        this.uniqueNameLength = l;
    }

    public boolean isMode(String input) {
        int m = this.getIndex(input);
        return this.number == m;
    }

    public void print(PrintStream PS, String cc) {
        PS.println(cc + " Output mode is " + this.getNumber());
    }

    public String toString() {
        return this.name[this.number];
    }

    public String toLongString() {
        return this.longName[this.number];
    }

    public void listAll(PrintStream PS, String cc, String sep) {
        for (int m = 0; m < this.name.length; ++m) {
            PS.println(cc + this.longName[m] + " (" + this.name[m] + ")");
        }
    }

    public String listAllShort(String sep1, String sep2) {
        String s = this.name[0] + sep1 + "0";
        for (int m = 1; m < this.name.length; ++m) {
            s = s + sep2 + this.name[m] + sep1 + m;
        }
        return s;
    }

    public String getString(int m) {
        return this.name[m];
    }

    public String getLongString(int m) {
        return this.longName[m];
    }

    public int getNumberModes() {
        return this.name.length;
    }
}

