/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities.FileUtilities;

import TimUtilities.TimMessage;
import java.io.File;
import java.io.FilenameFilter;

public class FindFile {
    int infolevel = 1;
    public String[] filelist;
    public String[] filenamerootlist;
    TimMessage message = new TimMessage(2);

    public void getFileList(String dirname, String nameroot, String ext) {
        boolean infoOn = false;
        if (this.infolevel > 0) {
            infoOn = true;
        }
        this.getFileList(dirname, nameroot, ext, infoOn);
    }

    public void getFileList(String dirname, String nameroot, String ext, boolean infoOn) {
        File dir = new File(dirname);
        if (!dir.isDirectory()) {
            this.message.printERROR(dirname + " not a directory");
            return;
        }
        if (infoOn) {
            System.out.println("Looking at directory " + dirname);
        }
        OnlyOneParamSet only = new OnlyOneParamSet(nameroot, ext);
        this.filelist = dir.list(only);
        if (infoOn) {
            System.out.println("Found  " + this.filelist.length + " files with name root " + nameroot + " and extension " + ext);
        }
        this.filenamerootlist = new String[this.filelist.length];
        for (int i = 0; i < this.filelist.length; ++i) {
            this.filenamerootlist[i] = this.getFileNameRoot(this.filelist[i], ext);
            if (!infoOn) continue;
            System.out.println(this.filelist[i] + "\t " + this.filenamerootlist[i]);
        }
    }

    public String getFileNameRoot(String filename, String ext) {
        int i = filename.lastIndexOf(ext);
        if (i < 0) {
            return null;
        }
        return filename.substring(0, i);
    }

    public String getFileName(int f) {
        if (f < 0 || f >= this.filelist.length) {
            return "";
        }
        return this.filelist[f];
    }

    public class OnlyOneParamSet
    implements FilenameFilter {
        String ext;
        String header;

        public OnlyOneParamSet(String header, String ext) {
            this.ext = ext;
            this.header = header;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext) & name.startsWith(this.header);
        }
    }
}

