/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities.FileUtilities;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class FileOutput {
    public static void printCollection(PrintStream PS, Collection C) {
        for (Object e : C) {
            PS.println(e);
        }
    }

    public static void FileOutputCollection(String fullfilename, Collection C, boolean messagesOn) {
        if (messagesOn) {
            System.out.println("Writing list of objects from a collection to " + fullfilename);
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullfilename);
            PrintStream PS = new PrintStream(fout);
            for (Object e : C) {
                PS.println(e);
            }
            if (messagesOn) {
                System.out.println("Finished writing list of " + C.size() + " objects from a collection to " + fullfilename);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + fullfilename + ", " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fullfilename + ", " + e.getMessage());
            return;
        }
    }

    public static void FileOutputMap(String fullfilename, String sep, Map M, boolean messagesOn) {
        if (messagesOn) {
            System.out.println("Writing list of keys and values of a map to " + fullfilename);
        }
        try {
            FileOutputStream fout = new FileOutputStream(fullfilename);
            PrintStream PS = new PrintStream(fout);
            Set keys = M.keySet();
            for (Object k : keys) {
                PS.println(k + sep + M.get(k));
            }
            if (messagesOn) {
                System.out.println("Finished writing list of " + M.size() + " keys and values of a map to " + fullfilename);
            }
            try {
                fout.close();
            }
            catch (IOException e) {
                System.err.println("*** File Error with " + fullfilename + ", " + e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("*** Error opening output file " + fullfilename + ", " + e.getMessage());
            return;
        }
    }

    public static void printMapStringString(PrintStream PS, String sep, Map<String, String> map) {
        Set<String> keys = map.keySet();
        for (String k : keys) {
            PS.println(k + sep + map.get(k));
        }
    }
}

