/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities.FileUtilities;

import TimUtilities.FileUtilities.FileUtilities;
import java.io.File;

public class FileNameSequence {
    private String directoryroot;
    private String directoryend;
    private String nameroot;
    private String nameend;

    public FileNameSequence(FileNameSequence fns) {
        this.setFileName(fns);
    }

    public FileNameSequence(String d, String n, String r) {
        this.setFileName(d, n, r);
    }

    public FileNameSequence(String dr, String de, String n, String r) {
        this.setFileName(dr, de, n, r);
    }

    public void setFileName(FileNameSequence fns) {
        this.setFileName(fns.getDirectoryRoot(), fns.getDirectoryEnd(), fns.getNameRoot(), fns.getNameRoot());
    }

    public void setFileName(String dr, String n, String r) {
        this.setDirectoryRoot(dr);
        this.directoryend = "";
        this.nameroot = n;
        this.nameend = r;
    }

    public void setFileName(String dr, String de, String n, String r) {
        this.setDirectoryRoot(dr);
        this.setDirectoryEnd(de);
        this.nameroot = n;
        this.nameend = r;
    }

    public boolean setFullFileName(String n, String[] ending) {
        String[] name = FileUtilities.slashSplit(n);
        for (int e = 0; e < ending.length; ++e) {
            if (!name[0].endsWith(ending[e])) continue;
            int l = name[0].length() - ending[e].length();
            this.nameroot = name[0].substring(0, l);
            this.nameend = ending[e];
            if (name.length > 1) {
                this.setDirectory(name[1]);
            }
            return true;
        }
        return false;
    }

    public boolean setFullFileNameNoEnding(String n) {
        String[] name = FileUtilities.slashSplit(n);
        this.nameroot = name[0];
        if (name.length > 1) {
            this.setDirectory(name[1]);
        }
        return true;
    }

    public String getDirectoryFull() {
        return this.directoryroot + this.directoryend;
    }

    public String getDirectoryRoot() {
        return this.directoryroot;
    }

    public String getDirectoryEnd() {
        return this.directoryend;
    }

    public String getNameRoot() {
        return this.nameroot;
    }

    public String getNameEnd() {
        return this.nameend;
    }

    public String getNameRootFullPath() {
        return this.directoryroot + this.directoryend + this.nameroot;
    }

    public String getFullFileName() {
        return this.directoryroot + this.directoryend + this.nameroot + this.nameend;
    }

    public String setDirectoryRoot(String dr) {
        this.directoryroot = FileNameSequence.makeDirectory(dr);
        return this.directoryroot;
    }

    public String setDirectoryEnd(String de) {
        this.directoryend = FileNameSequence.makeDirectory(de);
        return this.directoryroot;
    }

    public String setDirectory(String df) {
        String[] dname;
        int ld = df.length();
        if (ld < 1) {
            return df;
        }
        if (df.charAt(ld - 1) == '/' || df.charAt(ld - 1) == '\\') {
            --ld;
        }
        if ((dname = FileUtilities.slashSplit(df.substring(0, ld))).length > 0) {
            return this.setDirectory(dname[1], dname[0]);
        }
        return this.setDirectory("", dname[0]);
    }

    public String setDirectory(String dr, String de) {
        this.setDirectoryRoot(dr);
        this.setDirectoryEnd(de);
        return this.directoryroot + this.directoryend;
    }

    public static String makeDirectory(String d) {
        int ld = d.length();
        if (ld < 1) {
            return d;
        }
        if (!d.substring(ld - 1, ld).equals("/")) {
            d = d + "/";
        }
        return d;
    }

    public static boolean makeDirectory(String d, boolean create) {
        String dnew = FileNameSequence.makeDirectory(d);
        if (create) {
            return true;
        }
        File f = new File(dnew);
        return f.mkdirs();
    }

    public boolean makeDirectories() {
        File f = new File(this.getDirectoryFull());
        return f.mkdirs();
    }

    public void setNameRoot(String nr) {
        this.nameroot = nr;
    }

    public void appendToNameRoot(String nr) {
        this.nameroot = this.nameroot + nr;
    }

    public void setNameEnd(String ne) {
        this.nameend = ne;
    }

    public boolean testDirectoryRoot() {
        File dir = new File(this.directoryroot);
        return dir.isDirectory();
    }

    public boolean testDirectoryFull() {
        File dir = new File(this.directoryroot + this.directoryend);
        return dir.isDirectory();
    }

    public boolean testFullFileName() {
        File f = new File(this.getFullFileName());
        return f.exists();
    }
}

