/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class FileChooser
extends JPanel
implements ActionListener {
    private static final String newline = "\n";
    JButton openButton;
    JTextArea log = new JTextArea(5, 20);
    JFileChooser fc;

    public FileChooser() {
        super(new BorderLayout());
        this.log.setMargin(new Insets(5, 5, 5, 5));
        this.log.setEditable(false);
        JScrollPane logScrollPane = new JScrollPane(this.log);
        this.fc = new JFileChooser();
        this.openButton = new JButton("Open a File...", FileChooser.createImageIcon("images/Open16.gif"));
        this.openButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.openButton);
        this.add((Component)buttonPanel, "First");
        this.add((Component)logScrollPane, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.openButton) {
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.fc.getSelectedFile();
                this.log.append("Opening: " + file.getName() + "." + newline);
            } else {
                this.log.append("Open command cancelled by user.\n");
            }
            this.log.setCaretPosition(this.log.getDocument().getLength());
        }
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = FileChooser.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("FileChooserDemo");
        frame.setDefaultCloseOperation(3);
        FileChooser newContentPane = new FileChooser();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileChooser.createAndShowGUI();
            }
        });
    }
}

