/*
 * Decompiled with CFR 0.152.
 */
package TimUtilities;

import TimUtilities.GeneralMode;

public class BinaryMode
extends GeneralMode {
    private int number = 0;
    private int[] bit;

    public BinaryMode(String[] newName, String[] newLongName) {
        this.setUp(newName, newLongName, 0);
    }

    public BinaryMode(String[] newName, String[] newLongName, int newNumber) {
        this.setUp(newName, newLongName, newNumber);
    }

    public BinaryMode(BinaryMode old) {
        this.set(old.number);
    }

    @Override
    protected void setUp(String[] newName, String[] newLongName, int n) {
        this.longName = newLongName;
        if (this.name.length != this.longName.length) {
            throw new IllegalArgumentException("name and longName have different lengths" + this.name.length + " != " + this.longName.length);
        }
        this.bit[0] = 1;
        for (int m = 1; m < this.name.length; ++m) {
            this.bit[m] = this.bit[m - 1] << 1;
        }
        this.set(n);
    }

    public void setAllOn(String[] name) {
        this.number = (1 << name.length) - 1;
    }

    public void setAllOff() {
        this.number = 0;
    }

    public void setModeOn(String s) {
        this.setModeOn(this.getIndex(s));
    }

    public void setModeOn(int m) {
        if (this.testModeNumber(m)) {
            this.number |= this.bit[m];
        }
    }

    public void setModeOff(String s) {
        this.setModeOff(this.getIndex(s));
    }

    public void setModeOff(int m) {
        if (this.testModeNumber(m)) {
            this.number -= this.number & this.bit[m];
        }
    }

    public boolean isSet(int m) {
        if (m < 0 || m >= this.name.length) {
            return false;
        }
        return (this.bit[m] & this.number) > 0;
    }

    public String toString(String sep) {
        String s = "";
        for (int m = 0; m < this.name.length; ++m) {
            if (!this.isSet(m)) continue;
            s = s + this.name[m] + sep;
        }
        return s;
    }
}

