/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import IslandNetworks.islandNetwork;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberVertexValue;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.utils.TypedVertexGenerator;
import java.util.Set;

public class JungConverter {
    static final String JCVERSION = "JA060825";
    public DirectedSparseGraph g = new DirectedSparseGraph();
    public static final String VID_key = "IN_VIDKey";
    public static final String EID_key = "IN_EIDKey";
    public static final String X_key = "IN_XKey";
    public static final String Y_key = "IN_YKey";
    islandNetwork inet;

    public JungConverter(islandNetwork inetInput) {
        this.inet = inetInput;
        TypedVertexGenerator vg = new TypedVertexGenerator(this.g.getVertexConstraints());
        StringLabeller sl = StringLabeller.getLabeller((Graph)this.g);
        UserDatumNumberVertexValue vID = new UserDatumNumberVertexValue((Object)VID_key);
        UserDatumNumberVertexValue xCoord = new UserDatumNumberVertexValue((Object)X_key);
        UserDatumNumberVertexValue yCoord = new UserDatumNumberVertexValue((Object)Y_key);
        int numSites = this.inet.siteSet.getNumberSites();
        for (int i = 0; i < numSites; ++i) {
            Vertex v = vg.create();
            vID.setNumber((ArchetypeVertex)v, (Number)i);
            xCoord.setNumber((ArchetypeVertex)v, (Number)this.inet.siteSet.getX(i));
            yCoord.setNumber((ArchetypeVertex)v, (Number)this.inet.siteSet.getY(i));
            try {
                this.g.addVertex(v);
                sl.setLabel(v, this.inet.siteSet.getName(i));
                continue;
            }
            catch (StringLabeller.UniqueLabelException e) {
                System.out.println("Error in JungConverter: name conflict. Skipping another vertex with name: \"" + this.inet.siteSet.getName(i) + "\"");
            }
        }
        this.addAllEdges();
    }

    private void addAllEdges() {
        UserDatumNumberEdgeValue vEdgeID = new UserDatumNumberEdgeValue((Object)EID_key);
        for (int i = 0; i < this.inet.siteSet.getNumberSites(); ++i) {
            for (int j = 0; j < this.inet.siteSet.getNumberSites(); ++j) {
                if (this.inet.edgeSet.displayZeroEdgeWeight > this.inet.edgeSet.getDisplayVariable(i, j)) continue;
                Vertex v1 = this.getVertexWithID(i);
                Vertex v2 = this.getVertexWithID(j);
                DirectedSparseEdge e = new DirectedSparseEdge(v1, v2);
                vEdgeID.setNumber((ArchetypeEdge)e, (Number)this.inet.edgeSet.getIndex(i, j));
                this.g.addEdge((Edge)e);
            }
        }
    }

    public void replaceAllEdges() {
        this.g.removeAllEdges();
        this.addAllEdges();
    }

    public int getNumberEdges() {
        return this.g.numEdges();
    }

    public Vertex getVertexWithID(int i) {
        for (Vertex next : this.g.getVertices()) {
            if (!next.getUserDatum((Object)VID_key).equals(i)) continue;
            return next;
        }
        return null;
    }

    public islandNetwork getIslandNetwork() {
        return this.inet;
    }

    public Graph getGraph() {
        return this.g;
    }

    public Set getEdges() {
        return this.g.getEdges();
    }

    public Set getVertices() {
        return this.g.getVertices();
    }

    public String getXCoordKey() {
        return X_key;
    }

    public String getYCoordKey() {
        return Y_key;
    }
}

