/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import IslandNetworks.Edge.IslandEdgeSet;
import IslandNetworks.Vertex.IslandSiteSet;
import TimUtilities.NumbersToString;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ToolTipFunction;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberVertexValue;
import java.awt.event.MouseEvent;

public class GraphToolTip
implements ToolTipFunction {
    IslandSiteSet sites;
    IslandEdgeSet edges;
    UserDatumNumberVertexValue siteKey;
    UserDatumNumberEdgeValue edgeKey;
    static final NumbersToString num2String = new NumbersToString();

    public GraphToolTip(UserDatumNumberVertexValue siteID, IslandSiteSet inputSites, UserDatumNumberEdgeValue edgeID, IslandEdgeSet inputEdges) {
        this.sites = inputSites;
        this.siteKey = siteID;
        this.edges = inputEdges;
        this.edgeKey = edgeID;
    }

    public String getToolTipText(Vertex v) {
        int siteID = this.siteKey.getNumber((ArchetypeVertex)v).intValue();
        return this.sites.getName(siteID) + " " + NumbersToString.toString((double)this.sites.getWeight(siteID), (int)3);
    }

    public String getToolTipText(Edge e) {
        int edgeID = this.edgeKey.getNumber((ArchetypeEdge)e).intValue();
        return this.edges.toGraphToolTipString(edgeID, ": ", ", ", 3);
    }

    public String getToolTipText(MouseEvent event) {
        return null;
    }
}

