/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import IslandNetworks.ClusteringWindow;
import IslandNetworks.islandNetwork;
import IslandNetworks.jungInterfaces.JungConverter;
import TimGraph.Coordinate;
import TimGraph.io.GraphMLGenerator;
import TimUtilities.JavaColours;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Set;

public class GraphML {
    public static void FileOutputGMLNetwork(String filenamecomplete, JungConverter jc, VisualizationViewer vv, boolean noPercolationRemovedEdges, boolean messagesOn) {
        if (messagesOn) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            GraphML.output(PS, filenamecomplete, jc, vv, noPercolationRemovedEdges);
            try {
                fout.close();
                if (messagesOn) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.err.println("File Error " + e);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error opening output file " + filenamecomplete + ": " + e);
            return;
        }
    }

    public static void output(PrintStream PS, String gname, JungConverter jc, VisualizationViewer vv, boolean noPercolationRemovedEdges) {
        GraphMLGenerator gml = new GraphMLGenerator();
        gml.printInitialLines(PS, gname, true);
        Layout layout = vv.getGraphLayout();
        PluggableRenderer pr = (PluggableRenderer)vv.getRenderer();
        VertexPaintFunction vpf = pr.getVertexPaintFunction();
        VertexShapeFunction vsf = pr.getVertexShapeFunction();
        islandNetwork inet = jc.getIslandNetwork();
        String nodeShape = GraphMLGenerator.DEFAULT_SHAPE;
        Set vertexSet = jc.getVertices();
        int numberVertices = vertexSet.size();
        for (Object vo : vertexSet) {
            Vertex v = (Vertex)vo;
            Point2D position = layout.getLocation((ArchetypeVertex)v);
            int nodeNumber = (Integer)v.getUserDatum((Object)"IN_VIDKey");
            Color c = (Color)vpf.getFillPaint(v);
            Rectangle rect = vsf.getShape(v).getBounds();
            double w = rect.width;
            double h = rect.height;
            String vname = inet.siteSet.getName(nodeNumber);
            gml.printNodeColoured(PS, nodeNumber, numberVertices, position.getX(), position.getY(), w, h, vname, JavaColours.RGB((Color)c), nodeShape);
        }
        Set edgeSet = jc.getEdges();
        EdgePaintFunction epf = pr.getEdgePaintFunction();
        EdgeStrokeFunction esf = pr.getEdgeStrokeFunction();
        double arcFactor = 0.1;
        boolean targetArrowsOn = true;
        String ename = "";
        for (Object eo : edgeSet) {
            Edge e = (Edge)eo;
            Color ec = (Color)epf.getDrawPaint(e);
            if (noPercolationRemovedEdges && ec == ClusteringWindow.PERCREMOVEDCOLOUR) continue;
            int edgeNumber = (Integer)e.getUserDatum((Object)"IN_EIDKey");
            int source = inet.edgeSet.getSource(edgeNumber);
            int target = inet.edgeSet.getTarget(edgeNumber);
            Coordinate sourceCoordinate = new Coordinate(inet.siteSet.getSite((int)target).X, inet.siteSet.getSite((int)target).Y);
            Coordinate targetCoordinate = new Coordinate(inet.siteSet.getSite((int)target).X, inet.siteSet.getSite((int)target).Y);
            BasicStroke es = (BasicStroke)esf.getStroke(e);
            float width = es.getLineWidth();
            gml.printArcEdge(PS, edgeNumber, source, target, sourceCoordinate, targetCoordinate, arcFactor, ename, (double)width, targetArrowsOn, ename);
        }
        gml.printFinalLines(PS);
    }
}

