/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Decorator;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.UserData;
import java.util.ArrayList;
import java.util.List;

public class EdgePercolationRanker
extends AbstractRanker {
    public static final String EDGEWEIGHT = "IN_EWKey";

    public EdgePercolationRanker(Graph g) {
        this.initialize(g, true, true);
    }

    public EdgePercolationRanker(Graph g, boolean rankNodes) {
        this.initialize(g, rankNodes, true);
    }

    public EdgePercolationRanker(Graph g, boolean rankNodes, boolean rankEdges) {
        this.initialize(g, rankNodes, rankEdges);
    }

    private void initializeData(Graph g, BetweennessDataDecorator decorator) {
        for (Vertex vertex : g.getVertices()) {
            if (vertex.getUserDatum((Object)EDGEWEIGHT) == null) {
                vertex.addUserDatum((Object)EDGEWEIGHT, (Object)new MutableDouble(), UserData.SHARED);
            }
            decorator.setData(new BetweennessData(), (Element)vertex);
        }
        for (Edge e : g.getEdges()) {
            if (e.getUserDatum((Object)EDGEWEIGHT) != null) continue;
            e.addUserDatum((Object)EDGEWEIGHT, (Object)new MutableDouble(), UserData.SHARED);
        }
    }

    public String getRankScoreKey() {
        return EDGEWEIGHT;
    }

    protected double evaluateIteration() {
        return 0.0;
    }

    class BetweennessData {
        double distance = -1.0;
        double numSPs = 0.0;
        List predecessors = new ArrayList();
        double dependency = 0.0;

        BetweennessData() {
        }
    }

    class BetweennessDataDecorator
    extends Decorator {
        public BetweennessDataDecorator() {
            super((Object)"EDGEWEIGHT.BetwennessData", UserData.REMOVE);
        }

        public BetweennessData data(Element udc) {
            return (BetweennessData)udc.getUserDatum(this.getKey());
        }

        public void setData(BetweennessData value, Element udc) {
            udc.setUserDatum(this.getKey(), (Object)value, this.getCopyAction());
        }
    }
}

