/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import IslandNetworks.Edge.IslandEdgeSet;
import IslandNetworks.islandNetwork;
import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberEdgeValue;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;

public class EdgePercolationClusterer {
    private int mNumEdgesToRemove;
    private ListOrderedSet mEdgesRemoved;
    private Graph graph;
    int edgeVariableIndex = 0;
    IslandEdgeSet edgeSet;

    public EdgePercolationClusterer(ArchetypeGraph g, islandNetwork inet) {
        if (!(g instanceof Graph)) {
            throw new IllegalArgumentException("Argument must be of type Graph.");
        }
        this.graph = (Graph)g;
        this.edgeSet = inet.edgeSet;
        this.edgeVariableIndex = this.edgeSet.DisplayEdgeType.getValueIndex();
    }

    public ClusterSet extract(double minedgeWeight) {
        UserDatumNumberEdgeValue vEdgeID = new UserDatumNumberEdgeValue((Object)"IN_EIDKey");
        this.mEdgesRemoved = new ListOrderedSet();
        for (Edge e : this.graph.getEdges()) {
            if (!(this.edgeSet.getVariable(vEdgeID.getNumber((ArchetypeEdge)e).intValue(), this.edgeVariableIndex) < minedgeWeight)) continue;
            this.mEdgesRemoved.add((Object)e);
        }
        GraphUtils.removeEdges((Graph)this.graph, (Set)this.mEdgesRemoved);
        WeakComponentClusterer wcSearch = new WeakComponentClusterer();
        ClusterSet clusterSet = wcSearch.extract((ArchetypeGraph)this.graph);
        GraphUtils.addEdges((Graph)this.graph, (Set)this.mEdgesRemoved);
        return clusterSet;
    }

    public ClusterSet extractByRank(double fraction) {
        WeakComponentClusterer wcSearch = new WeakComponentClusterer();
        ClusterSet clusterSet = wcSearch.extract((ArchetypeGraph)this.graph);
        return clusterSet;
    }

    public List getEdgesRemoved() {
        return this.mEdgesRemoved.asList();
    }
}

