/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import IslandNetworks.jungInterfaces.JungConverter;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.sourceforge.jlibeps.epsgraphics.EpsGraphics2D;

public class EPSNetwork {
    public static void FileOutputEPSNetwork(String fileName, JungConverter jc, VisualizationViewer vv, boolean noPercolationRemovedEdges, boolean messagesOn) {
        String filenamecomplete = fileName + ".eps";
        if (messagesOn) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            EPSNetwork.outputEPS(PS, vv);
            try {
                fout.close();
                if (messagesOn) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.err.println("File Error " + e);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error opening output file " + filenamecomplete + ": " + e);
            return;
        }
    }

    public static void outputEPS(PrintStream PS, VisualizationViewer vv) {
        EpsGraphics2D g = new EpsGraphics2D();
        Dimension d = vv.getSize();
        System.out.println("outputEPS size=" + d.width + " x " + d.height);
        vv.setDoubleBuffered(false);
        vv.paint((Graphics)g);
        String output = g.toString();
        PS.print(output);
        g.dispose();
        vv.setDoubleBuffered(true);
    }
}

