/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import IslandNetworks.islandNetwork;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.AbstractVertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexAspectRatioFunction;
import edu.uci.ics.jung.graph.decorators.VertexSizeFunction;
import java.awt.Shape;

public final class AriadneVertexShapeSizeAspect
extends AbstractVertexShapeFunction
implements VertexSizeFunction,
VertexAspectRatioFunction {
    protected boolean stretch = false;
    protected boolean scale = true;
    protected boolean funny_shapes = false;
    protected double vertexScaling;
    private final islandNetwork INET;

    public AriadneVertexShapeSizeAspect(islandNetwork inet, int vertexScaling) {
        this.INET = inet;
        this.setScaling(vertexScaling);
        this.setSizeFunction(this);
        this.setAspectRatioFunction(this);
    }

    public void setScaling(double vertexScaling) {
        if (vertexScaling > 0.0) {
            this.vertexScaling = vertexScaling;
            this.setScaling(true);
        } else {
            this.setScaling(false);
        }
    }

    public void setStretching(boolean stretch) {
        this.stretch = stretch;
    }

    public void setScaling(boolean scale) {
        this.scale = scale;
    }

    public void useFunnyShapes(boolean use) {
        this.funny_shapes = use;
    }

    public int getSize(Vertex v) {
        if (!this.scale) {
            return 8;
        }
        Integer s = (Integer)v.getUserDatum((Object)"IN_VIDKey");
        int vs = (int)(this.INET.siteSet.getDisplaySize(s) + 0.5);
        if (vs < 0) {
            return 0;
        }
        return vs;
    }

    public float getAspectRatio(Vertex v) {
        if (this.stretch) {
            return (float)(v.inDegree() + 1) / (float)(v.outDegree() + 1);
        }
        return 1.0f;
    }

    public Shape getShape(Vertex v) {
        if (this.funny_shapes) {
            if (v.degree() < 5) {
                int sides = Math.max(v.degree(), 3);
                return this.factory.getRegularPolygon(v, sides);
            }
            return this.factory.getRegularStar(v, v.degree());
        }
        return this.factory.getEllipse(v);
    }
}

