/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import IslandNetworks.islandNetwork;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

public class AriadneEdgeStrokeFunction
implements EdgeStrokeFunction {
    private final islandNetwork INET;
    private final Object ISLANDCLUSTERKEY;
    private final Color PERCREMOVEDCOLOUR;
    protected Stroke THIN;
    protected Stroke THICK;
    private Float minEdgeDisplaySize = Float.valueOf(0.0f);
    private Float maxEdgeDisplaySize = Float.valueOf(10.0f);

    public AriadneEdgeStrokeFunction(islandNetwork inet, Object islandClusterKey, Color percRemovedColour, Float minSize, Float maxSize) {
        this.INET = inet;
        this.ISLANDCLUSTERKEY = islandClusterKey;
        this.PERCREMOVEDCOLOUR = percRemovedColour;
        this.setEdgeSizes(minSize, maxSize);
    }

    public void setEdgeSizes(Float minSize, Float maxSize) {
        this.THIN = minSize.floatValue() < 0.0f || minSize.floatValue() > maxSize.floatValue() ? new BasicStroke(1.0f) : new BasicStroke(minSize.floatValue());
        this.maxEdgeDisplaySize = this.maxEdgeDisplaySize.floatValue() < 0.0f ? Float.valueOf(1.0f) : maxSize;
        this.THICK = new BasicStroke(this.maxEdgeDisplaySize.floatValue());
    }

    public Stroke getStroke(Edge e) {
        Integer edgeID = (Integer)e.getUserDatum((Object)"IN_EIDKey");
        double edgeDisplayValue = this.INET.edgeSet.getEdgeDisplaySize(edgeID);
        Color c = (Color)e.getUserDatum(this.ISLANDCLUSTERKEY);
        if (c == this.PERCREMOVEDCOLOUR) {
            return this.THIN;
        }
        if (edgeDisplayValue < this.INET.edgeSet.minColourFrac) {
            return this.THIN;
        }
        return new BasicStroke((float)(edgeDisplayValue * (double)this.maxEdgeDisplaySize.floatValue()));
    }
}

