/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.CalculationParameters;
import IslandNetworks.Edge.DistanceMetric;
import IslandNetworks.Edge.EdgeTypeSelection;
import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.Edge.IslandEdgeSet;
import IslandNetworks.ExecuteMode;
import IslandNetworks.GlobalProperties;
import IslandNetworks.IslandArguments;
import IslandNetworks.IslandCulture;
import IslandNetworks.IslandHamiltonian;
import IslandNetworks.IslandTransferMatrix;
import IslandNetworks.ModelNumber;
import IslandNetworks.MonteCarloHistory;
import IslandNetworks.NetworkGenerator;
import IslandNetworks.NetworkWindow;
import IslandNetworks.OutputMode;
import IslandNetworks.PajekColours;
import IslandNetworks.SiteWindowMode;
import IslandNetworks.UpdateMode;
import IslandNetworks.Vertex.IslandSite;
import IslandNetworks.Vertex.IslandSiteSet;
import IslandNetworks.Vertex.VertexMode;
import IslandNetworks.Vertex.VertexTypeSelection;
import IslandNetworks.io.FileLocation;
import JavaNotes.TextReader;
import TimUtilities.Distances;
import TimUtilities.GeneralMode;
import TimUtilities.JavaColours;
import TimUtilities.KMLGenerator;
import TimUtilities.Permutation;
import TimUtilities.StatisticalQuantity;
import TimUtilities.TimCounting;
import TimUtilities.TimMessage;
import TimUtilities.TimSort;
import TimUtilities.TimTime;
import TimUtilities.UpdateRecord;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Random;

public class islandNetwork {
    public static final String iNVERSION = "iN110401";
    static final TimTime timTime = new TimTime();
    static final int MAXSITENUMBER = 200;
    static final String SEPSTRING = "\t";
    static final String GENELABEL = "!";
    static final String COMMENT = "#";
    static final String STARTSECTION = "*";
    public static final String inputFileEnding = "_input";
    public static final String NETWORKDATAFILEEXT = "anf";
    static final double MAXH = 1000000.0;
    static final double MINDOUBLE = 1.0E-10;
    boolean MChistory = false;
    boolean inputGUI = false;
    boolean dataread = false;
    OutputMode outputMode;
    public FileLocation inputFile;
    public FileLocation outputFile;
    boolean autoSetOutputFileName;
    IslandArguments commandLine = new IslandArguments();
    double jiggleScale = 0.0;
    int numberSites = 200;
    public IslandEdgeSet edgeSet;
    public IslandSiteSet siteSet;
    public double betaInitial = 0.001;
    IslandHamiltonian Hamiltonian;
    StatisticalQuantity siteRankStats;
    StatisticalQuantity siteInfluenceStats;
    double[] inSiteStrengthWeight;
    double[] outSiteStrengthWeight;
    double[] inSiteStrengthValue;
    double[] outSiteStrengthValue;
    GlobalProperties globalProperties;
    StatisticalQuantity siteDistanceStats;
    IslandCulture networkCulture;
    double culturePSiteCopy = 0.45;
    double culturePCopy = 0.45;
    double culturePInnovate = 0.05;
    double cultureTimeScale = 10000.0;
    public IslandTransferMatrix transferMatrix;
    double influenceProb = 0.5;
    UpdateRecord edgeUR = new UpdateRecord();
    UpdateRecord vertexUR = new UpdateRecord();
    public TimMessage message = new TimMessage(0);
    CalculationParameters calcParam;
    public ExecuteMode executeMode;
    UpdateMode updateMode;
    VertexMode vertexMode;
    ModelNumber modelNumber;
    final String[] mcsmsh = new String[]{"Hot", "Cold", "Old"};
    final String[] mcsmlg = new String[]{"Hot start, random values", "Cold start, all equal weight", "Old or existing configuration"};
    public GeneralMode monteCarloStartMode = new GeneralMode(this.mcsmsh, this.mcsmlg, 0);
    int MCsweeps = 100;
    int siteWeightFactor = 20;
    int edgeWidthFactor = 10;
    double DisplayMaxVertexScale = 8.0;
    public VertexTypeSelection DisplayVertexType;
    SiteWindowMode siteWindowMode = new SiteWindowMode(1);
    JavaColours javaColour;
    static PajekColours pajekColour = new PajekColours();
    int visualisationWidth = 760;
    int visualisationHeight = 760;
    static Random rnd;
    int generateNumber = -1;
    int generateType = 0;

    public islandNetwork(int ns) {
        this.inputGUI = true;
        this.executeMode = new ExecuteMode();
        this.outputMode = new OutputMode(15);
        this.numberSites = ns;
        this.initialiseArrays(-1.0);
        this.setColours();
        String ariadneDirectory = System.getProperty("user.dir");
        this.inputFile = new FileLocation(ariadneDirectory + "/input/", "", "aegean39S1L3a", "", inputFileEnding, "dat");
        this.outputFile = new FileLocation(ariadneDirectory + "/output/", "", "aegean39S1L3a", "", 0, "", "dat");
        this.autoSetOutputFileName = true;
        this.Hamiltonian = new IslandHamiltonian();
        this.modelNumber = new ModelNumber(1.3);
        this.updateMode = new UpdateMode("MC");
        this.vertexMode = new VertexMode(5.0);
        this.DisplayVertexType = new VertexTypeSelection();
        rnd = new Random();
    }

    public islandNetwork(islandNetwork islnetinput) {
        this.numberSites = islnetinput.numberSites;
        this.inputGUI = islnetinput.inputGUI;
        this.dataread = islnetinput.dataread;
        this.inputFile = new FileLocation(islnetinput.inputFile);
        this.outputFile = new FileLocation(islnetinput.outputFile);
        if (this.message.getInformationLevel() > -2) {
            System.out.println("Creating new Island Network, input name = " + this.inputFile.getFullFileRoot());
        }
        this.siteSet = new IslandSiteSet(islnetinput.siteSet);
        this.edgeSet = new IslandEdgeSet(islnetinput.edgeSet);
        this.copyGeneralParameters(islnetinput);
        this.Hamiltonian = islnetinput.Hamiltonian;
        this.copyDisplayParameters(islnetinput);
        this.networkCulture = islnetinput.networkCulture == null ? null : new IslandCulture(islnetinput.networkCulture);
        this.globalProperties = new GlobalProperties(islnetinput.globalProperties);
        this.influenceProb = islnetinput.influenceProb;
    }

    public islandNetwork(File ifl, islandNetwork inparam) {
        TextReader data;
        this.inputFile = inparam.inputFile;
        this.outputFile = new FileLocation(ifl);
        this.copyGeneralParameters(inparam);
        this.Hamiltonian = new IslandHamiltonian(inparam.Hamiltonian);
        this.copyDisplayParameters(inparam);
        this.setColours();
        String filename = this.outputFile.getFullLocationFileName("", NETWORKDATAFILEEXT);
        System.out.println("Starting to read islandNetwork from " + filename);
        String tempstring = "";
        String datatype = "Unknown";
        int linenumber = 0;
        int nargs = 0;
        int MAXPARAMETERS = 100;
        double[] darray = new double[100];
        String[] parameterString = new String[100];
        String[] labelString = new String[100];
        try {
            data = new TextReader(new FileReader(filename));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Can't find file " + filename + ", message " + e);
        }
        try {
            int i;
            int pnumber;
            while (!data.eof()) {
                ++linenumber;
                datatype = data.getWord();
                if (datatype.startsWith(COMMENT)) {
                    tempstring = datatype + data.getln();
                    System.out.println("Comment: " + tempstring);
                    continue;
                }
                if (datatype.startsWith("*param")) {
                    while (!data.eoln()) {
                        parameterString[nargs++] = data.getWord();
                    }
                    System.out.print("Parameter string: ");
                    for (int iii = 0; iii < nargs; ++iii) {
                        System.out.print(SEPSTRING + parameterString[iii]);
                    }
                    System.out.println();
                    continue;
                }
                if (!datatype.startsWith("*sites") && !datatype.startsWith("*edges")) continue;
            }
            if (parameterString.length > 0) {
                this.Parse(parameterString);
            }
            if (!datatype.startsWith("*sites")) {
                throw new RuntimeException("*** ERROR - next line should start with *sites");
            }
            this.numberSites = Integer.parseInt(data.getWord());
            this.initialiseArrays(-1.0);
            ++linenumber;
            nargs = 0;
            do {
                labelString[nargs++] = data.getWord();
            } while (!data.eoln());
            for (pnumber = 0; pnumber < nargs && !labelString[pnumber].startsWith(GENELABEL); ++pnumber) {
            }
            int[] index = new int[pnumber];
            for (i = 0; i < pnumber; ++i) {
                index[i] = IslandSite.getIndex(labelString[i]);
            }
            for (i = pnumber; i < nargs; ++i) {
                this.siteSet.addGene(labelString[i].substring(GENELABEL.length()));
            }
            for (int s = 0; s < this.numberSites; ++s) {
                int i2;
                ++linenumber;
                for (i2 = 0; i2 < pnumber; ++i2) {
                    tempstring = data.getWord();
                    this.siteSet.setVariable(s, index[i2], tempstring);
                }
                for (i2 = pnumber; i2 < nargs; ++i2) {
                    tempstring = data.getWord();
                    this.siteSet.setGeneValue(s, i2 - pnumber, tempstring);
                }
            }
            ++linenumber;
            datatype = data.getWord();
            if (datatype.startsWith("*edges")) {
                ++linenumber;
                nargs = 0;
                do {
                    labelString[nargs++] = data.getWord();
                } while (!data.eoln());
                index = new int[nargs];
                for (i = 0; i < nargs; ++i) {
                    index[i] = IslandEdge.getIndex(labelString[i]);
                    if (IslandEdge.checkIndex(index[i])) continue;
                    System.err.println("!!! Input Warning: line number " + linenumber + ", column " + (i + 1) + " edge variable name " + labelString[i] + " not recognised");
                }
                int id = 0;
                boolean columnsOK = true;
                while (!data.eof()) {
                    ++linenumber;
                    int i3 = 0;
                    while (!data.eoln()) {
                        if (i3 < index.length) {
                            int indexNumber = index[i3++];
                            String s = data.getWord();
                            if (!IslandEdge.checkIndex(indexNumber)) continue;
                            this.edgeSet.setVariable(id, indexNumber, Double.parseDouble(s));
                            continue;
                        }
                        if (!columnsOK) continue;
                        columnsOK = false;
                        System.err.println("!!! Input Warning: line number " + linenumber + ", has too many columns, wanted " + index.length + " found " + (i3 + 1));
                    }
                    ++id;
                }
                if (id != this.numberSites * this.numberSites) {
                    throw new RuntimeException("Error: line number " + linenumber + " end of file reached but only read " + id + " edges");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Input Error: line number " + linenumber + ".  Error = " + e.getMessage());
        }
        finally {
            data.close();
        }
        System.out.println("Finished reading from " + filename + " last line studied was " + linenumber);
    }

    public void copyGeneralParameters(islandNetwork islnetinput) {
        this.executeMode = new ExecuteMode(islnetinput.executeMode);
        this.updateMode = new UpdateMode(islnetinput.updateMode.getNumber());
        this.vertexMode = new VertexMode(islnetinput.vertexMode);
        this.modelNumber = new ModelNumber(islnetinput.modelNumber);
        this.outputMode = new OutputMode(islnetinput.outputMode);
        this.monteCarloStartMode = new GeneralMode(islnetinput.monteCarloStartMode);
    }

    public void copyDisplayParameters(islandNetwork islnetinput) {
        this.siteWeightFactor = islnetinput.siteWeightFactor;
        this.edgeWidthFactor = islnetinput.edgeWidthFactor;
        this.DisplayMaxVertexScale = islnetinput.DisplayMaxVertexScale;
        this.DisplayVertexType = new VertexTypeSelection(islnetinput.DisplayVertexType);
        this.siteWindowMode = islnetinput.siteWindowMode;
    }

    public void initialiseArrays(double edgeValueMax) {
        this.siteSet = new IslandSiteSet(this.numberSites);
        this.edgeSet = new IslandEdgeSet(this.numberSites, edgeValueMax);
        this.globalProperties = new GlobalProperties();
    }

    public int Parse(String[] ArgList) {
        block27: for (int i = 0; i < ArgList.length && ArgList[i] != null; ++i) {
            if (ArgList[i].length() < 2) {
                System.out.println("\n*** Argument " + i + ", " + ArgList[i] + ", is too short");
                return 1;
            }
            if (ArgList[i].charAt(0) != '-') {
                System.out.println("\n*** Argument " + i + ", " + ArgList[i] + ", does not start with -");
                return 2;
            }
            switch (ArgList[i].charAt(1)) {
                case 'a': {
                    this.Hamiltonian.alpha = Double.parseDouble(ArgList[i].substring(2));
                    continue block27;
                }
                case 'b': {
                    if (ArgList[i].charAt(2) == 't') {
                        this.betaInitial = Double.parseDouble(ArgList[i].substring(3));
                    }
                    if (ArgList[i].charAt(2) != 's') continue block27;
                    this.Hamiltonian.setb(Double.parseDouble(ArgList[i].substring(3)));
                    continue block27;
                }
                case 'c': {
                    if (ArgList[i].charAt(2) == 'c') {
                        this.culturePCopy = Double.parseDouble(ArgList[i].substring(3));
                    }
                    if (ArgList[i].charAt(2) == 's') {
                        this.culturePSiteCopy = Double.parseDouble(ArgList[i].substring(3));
                    }
                    if (ArgList[i].charAt(2) == 'i') {
                        this.culturePInnovate = Double.parseDouble(ArgList[i].substring(3));
                    }
                    if (ArgList[i].charAt(2) != 't') continue block27;
                    this.cultureTimeScale = Double.parseDouble(ArgList[i].substring(3));
                    continue block27;
                }
                case 'd': {
                    if (ArgList[i].charAt(2) == 'l') {
                        this.Hamiltonian.distanceScale = Double.parseDouble(ArgList[i].substring(3));
                    }
                    if (ArgList[i].charAt(2) == 'm') {
                        this.edgeSet.metric.set(ArgList[i].substring(3));
                    }
                    if (ArgList[i].charAt(2) != 's') continue block27;
                    this.Hamiltonian.shortDistanceScale = Double.parseDouble(ArgList[i].substring(3));
                    continue block27;
                }
                case 'e': {
                    this.edgeSet.edgeMode.setEdgeMode(Double.parseDouble(ArgList[i].substring(2)));
                    continue block27;
                }
                case 'f': {
                    if (ArgList[i].charAt(2) == 'i') {
                        if (ArgList[i].charAt(3) == 'j') {
                            this.jiggleScale = Double.parseDouble(ArgList[i].substring(3));
                        } else {
                            this.inputFile.set(ArgList[i].substring(3));
                        }
                    }
                    if (ArgList[i].charAt(2) != 'o') continue block27;
                    if (ArgList[i].charAt(3) == 'a') {
                        this.autoSetOutputFileName = true;
                        continue block27;
                    }
                    if (ArgList[i].charAt(3) == 'A') {
                        this.autoSetOutputFileName = false;
                        continue block27;
                    }
                    this.outputFile.set(ArgList[i].substring(3));
                    continue block27;
                }
                case 'g': {
                    this.Hamiltonian.gamma = Double.parseDouble(ArgList[i].substring(2));
                    continue block27;
                }
                case 'i': {
                    this.message.setInformationLevel(Integer.parseInt(ArgList[i].substring(2)));
                    continue block27;
                }
                case 'j': {
                    this.Hamiltonian.vertexSource = Double.parseDouble(ArgList[i].substring(2));
                    continue block27;
                }
                case 'k': {
                    this.Hamiltonian.kappa = Double.parseDouble(ArgList[i].substring(2));
                    continue block27;
                }
                case 'l': {
                    this.Hamiltonian.lambda = Double.parseDouble(ArgList[i].substring(2));
                    continue block27;
                }
                case 'm': {
                    this.Hamiltonian.edgeSource = Double.parseDouble(ArgList[i].substring(2));
                    continue block27;
                }
                case 'o': {
                    this.outputMode.set(Integer.parseInt(ArgList[i].substring(2)));
                    continue block27;
                }
                case 'u': {
                    this.updateMode.set(Integer.parseInt(ArgList[i].substring(2)));
                    continue block27;
                }
                case 'v': {
                    this.modelNumber.set(Double.parseDouble(ArgList[i].substring(2)));
                    continue block27;
                }
                case 'w': {
                    this.inputGUI = true;
                    if (!ArgList[i].substring(2, 3).equals("n")) continue block27;
                    this.inputGUI = false;
                    continue block27;
                }
                case 'x': {
                    if (ArgList[i].charAt(2) == 'v') {
                        this.vertexMode.setMaxValueModeOn(Double.parseDouble(ArgList[i].substring(3)));
                    }
                    if (ArgList[i].charAt(2) != 'w') continue block27;
                    this.vertexMode.setConstantWeightModeOn(Double.parseDouble(ArgList[i].substring(3)));
                    continue block27;
                }
                case 'C': {
                    if (ArgList[i].charAt(2) == 'c') {
                        this.monteCarloStartMode.setFromName("Cold");
                    }
                    if (ArgList[i].charAt(2) == 'h') {
                        this.monteCarloStartMode.setFromName("Hot");
                    }
                    if (ArgList[i].charAt(2) != 'o') continue block27;
                    this.monteCarloStartMode.setFromName("Old");
                    continue block27;
                }
                case 'D': {
                    if (ArgList[i].charAt(2) == 'v') {
                        if (ArgList[i].charAt(3) == 's') {
                            this.DisplayMaxVertexScale = Double.parseDouble(ArgList[i].substring(4));
                        }
                        if (ArgList[i].charAt(3) == 't') {
                            this.DisplayVertexType.setValue(Integer.parseInt(ArgList[i].substring(4)));
                        }
                    }
                    if (ArgList[i].charAt(2) == 'e') {
                        if (ArgList[i].charAt(3) == 's') {
                            this.edgeSet.DisplayMaxEdgeScale = Double.parseDouble(ArgList[i].substring(4));
                        }
                        if (ArgList[i].charAt(3) == 't') {
                            this.edgeSet.DisplayEdgeType.setValue(Integer.parseInt(ArgList[i].substring(4)));
                        }
                    }
                    if (ArgList[i].charAt(2) == 'z') {
                        this.edgeSet.zeroColourFrac = Double.parseDouble(ArgList[i].substring(3));
                    }
                    if (ArgList[i].charAt(2) == 'n') {
                        this.edgeSet.minColourFrac = Double.parseDouble(ArgList[i].substring(3));
                    }
                    if (ArgList[i].charAt(2) == 'x') {
                        this.visualisationWidth = Integer.parseInt(ArgList[i].substring(3));
                    }
                    if (ArgList[i].charAt(2) != 'y') continue block27;
                    this.visualisationHeight = Integer.parseInt(ArgList[i].substring(3));
                    continue block27;
                }
                case 'E': {
                    this.executeMode.setMode(ArgList[i].substring(2));
                    continue block27;
                }
                case 'Z': {
                    if (ArgList[i].charAt(2) == 'n') {
                        this.generateNumber = Integer.parseInt(ArgList[i].substring(3));
                    }
                    if (ArgList[i].charAt(2) != 't') continue block27;
                    this.generateType = Integer.parseInt(ArgList[i].substring(3));
                    continue block27;
                }
                case 'X': {
                    System.err.println(" *** ERROR, agrument -X deprecated, use -x?ddd ");
                    return 5;
                }
                case 'F': {
                    if (ArgList[i].charAt(2) == 'i') {
                        this.inputFile.setRootDirectory(ArgList[i].substring(3));
                    }
                    if (ArgList[i].charAt(2) != 'o') continue block27;
                    this.outputFile.setRootDirectory(ArgList[i].substring(3));
                    continue block27;
                }
                case 'S': {
                    if (ArgList[i].charAt(2) == 'i') {
                        this.inputFile.setSubDirectory(ArgList[i].substring(3));
                    }
                    if (ArgList[i].charAt(2) != 'o') continue block27;
                    this.outputFile.setSubDirectory(ArgList[i].substring(3));
                    continue block27;
                }
                case '?': {
                    this.Usage();
                    return 4;
                }
                default: {
                    System.out.println("\n*** Argument " + i + ", " + ArgList[i] + ", not known, usage:");
                    this.Usage();
                    return 3;
                }
            }
        }
        this.setOutputFileName();
        if (this.vertexMode.constantWeightOn) {
            this.Hamiltonian.vertexSource = this.vertexMode.totalWeight / (double)this.numberSites;
        }
        return 0;
    }

    public void Usage() {
        int t;
        islandNetwork i = new islandNetwork(1);
        System.out.println("...............................................................................");
        System.out.println("Ariadne, iNVERSION iN110401 usage: ");
        System.out.println("aegean <options> ");
        System.out.println(" where options are -<char><value> separated by space as follows ");
        System.out.println("  -a<alpha>    Sets alpha, short distance power in edge potential, default " + i.Hamiltonian.alpha);
        System.out.println("  -bs<b>       Sets b, power used for site terms, default " + i.Hamiltonian.getb());
        System.out.println("  -bt<betaInitial>    Sets initial beta, inverse temperature, default " + i.betaInitial);
        System.out.println("                Also number of edges per site in PPA mode");
        System.out.println("  -cc<culturePCopy>     probability that will copy culture of neighbour, default " + i.culturePCopy);
        System.out.println("  -cc<culturePSiteCopy> probability that will copy culture within site, default " + i.culturePSiteCopy);
        System.out.println("  -cc<culturePInnovate> probability that will innovate new culture keeping existing culture, default " + i.culturePInnovate);
        System.out.println("  -cc<cultureTimeScale> time scale in units of tau_2, default " + i.cultureTimeScale);
        System.out.println("  -dl<distanceScale> Sets distance scale, " + i.Hamiltonian.distanceScale);
        System.out.println("  -dm<metricNumber>  Sets metric for Dijkstra calculations, default " + i.Hamiltonian.shortDistanceScale);
        DistanceMetric.listAll(System.out, "                     ", ": ");
        System.out.println("  -ds<shortdistanceScale> Sets short distance scale, default " + i.Hamiltonian.shortDistanceScale);
        System.out.println("  -e<edgeMode>      Sets edge max edge value or binary (0 or 1) if 0,");
        System.out.println("                    Negative indicates maximum strength, default " + i.edgeSet.edgeMode.edgeModeValue());
        System.out.println("  -fa          Sets the output file name to AUTO,");
        System.out.println("                    i.e. automatic format as noted above");
        System.out.println("                            default " + i.inputFile.getFullFileRoot());
        System.out.println("  -fij<jiggleScale>  Sets scale to jiggle input site locations, default " + i.jiggleScale);
        System.out.println("  -fi?<string>  Sets input file names and directories where ? given below");
        System.out.println("  -foa        Sets filename to automatic based on parameters, default " + i.autoSetOutputFileName);
        System.out.println("  -foA        No automatic file name");
        System.out.println("  -fo?<string> Sets input file names and directories where ? given below");
        System.out.println("               ? is a character taken from:-");
        this.inputFile.printSetStrings(System.out, "              ");
        System.out.println("  -g<gamma>         Sets gamma, short distance power in edge potential,");
        System.out.println("                            default " + i.Hamiltonian.gamma);
        System.out.println("  -i<message.getInformationLevel()>     Sets information level, 0 lowest, default " + i.message.getInformationLevel());
        System.out.println("  -j<j>        Sets j, sum over all vertex weights, default " + i.Hamiltonian.vertexSource);
        System.out.println("  -k<kappa>         Sets kappa, coefficient of vertex potential, default " + i.Hamiltonian.lambda);
        System.out.println("  -l<lambda>        Sets lambda, coefficient of edge potential, default " + i.Hamiltonian.lambda);
        System.out.println("  -m<mu>       Sets mu, sum over all edge weights, default " + i.Hamiltonian.edgeSource);
        System.out.println("  -o<outputMode>    Sets output mode by bits 1 (0)= on (off):, default " + i.outputMode.getNumber());
        this.outputMode.listAll(System.out, "                    ", " = ");
        System.out.println("  -u<updateMode>    Sets update mode: " + i.updateMode.listAllShort(" ", ", ") + ". Default " + i.updateMode.getNumber());
        System.out.println("  -v<modelNumber>   Sets model number to use, default " + i.modelNumber.major + "_" + i.modelNumber.minor);
        System.out.println("  -w[y|n]      Sets window mode on -wy or off -wn, default " + i.inputGUI);
        System.out.println("  -xv<vertexMaximum>  Sets vertices to have a maximum value");
        System.out.println("  -xw<constantWeight> Sets total weight of vertices to be constant");
        System.out.println("                      Vertex mode and value defaults are " + i.vertexMode.descriptionValue(", value="));
        System.out.println("  -C<name> sets MC calculation starting configuration");
        for (t = 0; t < this.monteCarloStartMode.getNumberModes(); ++t) {
            System.out.println("  -C" + this.monteCarloStartMode.getString(t) + " = " + this.monteCarloStartMode.getLongString(t));
        }
        System.out.println("  -Des<DisplayMaxEdgeScale> Sets size of edge weight (s[i]v[i]e[i][j]) for maximum");
        System.out.println("                              colour in display (absolute),");
        System.out.println("                              if 0 then largest value actual value used (relative),");
        System.out.println("                               default " + i.edgeSet.DisplayMaxEdgeScale);
        System.out.println("  -Det<DisplayEdgeType> Sets type of edge displayed,");
        for (t = 0; t < EdgeTypeSelection.numberTypes; ++t) {
            System.out.println("                             " + t + " = " + EdgeTypeSelection.name[t]);
        }
        System.out.println("                          default " + i.edgeSet.DisplayEdgeType.getCurrentTypeString());
        System.out.println("  -Dn<minColourFrac> Sets fraction of largest colour which is to be");
        System.out.println("                       represented as colour value 1 (next to minimum),");
        System.out.println("                         default " + i.edgeSet.minColourFrac);
        System.out.println("  -Dvt<DisplayVertexType> Sets type of vertex displayed,");
        for (t = 0; t < VertexTypeSelection.numberTypes; ++t) {
            System.out.println("                             " + t + " = " + VertexTypeSelection.name[t]);
        }
        System.out.println("                          default " + i.DisplayVertexType.getCurrentTypeString());
        System.out.println("  -Dvs<DisplayMaxVertexScale> Sets size of vertex weight (s[i]v[i]) for");
        System.out.println("                              maximum colour in display (absolute),");
        System.out.println("                              if 0 then largest value actual value used (relative),");
        System.out.println("                               default " + i.edgeSet.DisplayMaxEdgeScale);
        System.out.println("  -Dx<visualisationWidth>  Sets preferred width for windows in pixels, default " + i.visualisationWidth);
        System.out.println("  -Dy<visualisationHeight> Sets preferred height for windows in pixels, default " + i.visualisationHeight);
        System.out.println("  -Dz<zeroColourFrac> Sets fraction of largest colour which is to be");
        System.out.println("                       represented as zero colour, default " + i.edgeSet.zeroColourFrac);
        System.out.println("  -E<String> sets operational mode to be that of given name, default " + i.executeMode.toString());
        System.out.println("             Options are: " + i.executeMode.allOptionsString(", ") + ".");
        System.out.println("  -Zn<n> Generates network of n sites");
        System.out.println("  -Zt<t> Generates network of type t");
        NetworkGenerator ng = new NetworkGenerator();
        for (int t2 = 0; t2 < ng.NUMBERTYPES; ++t2) {
            System.out.println("           Type " + t2 + ":" + ng.networkName(t2));
        }
        System.out.println();
        System.out.println("  -???      This usage screen. Also try ariadne.html for help.");
        System.out.println("...............................................................................");
    }

    public void setUpdateMode(String name) {
        this.updateMode.setFromName(name);
    }

    public void setOutputFileName() {
        if (this.autoSetOutputFileName) {
            this.outputFile.setRootDirectory("output/");
            String sb = this.inputFile.getBasicRoot();
            this.outputFile.setBasicRoot(sb);
            String sp = this.getParameterString("");
            this.outputFile.setSubDirectory(sb + sp);
            this.outputFile.setParameterName(sp);
            this.outputFile.setEnding("");
            this.outputFile.setExtension(NETWORKDATAFILEEXT);
            this.outputFile.setFirstFreeSequenceNumber();
            if (!this.outputFile.isFullLocationDirectory() && !this.outputFile.mkDirs()) {
                System.err.println("*** ERROR creating directory " + this.outputFile.getFullLocation());
            }
        }
    }

    public String getNameString(String sep) {
        return this.inputFile.getBasicRoot() + sep + this.getParameterString(sep);
    }

    public String getParameterString(String sep) {
        String sp = this.updateMode.toString();
        switch (this.updateMode.getNumber()) {
            case 0: {
                sp = sp + sep + "beta" + String.format("%06.3g", this.betaInitial);
                break;
            }
            case 1: {
                sp = sp + sep + "v" + this.modelNumber.major + "_" + this.modelNumber.minor + sep + "e" + this.edgeSet.edgeMode.edgeModeValue() + sep + this.Hamiltonian.parameterString(sep, 3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                sp = sp + sep + "D" + String.format("%06.3f", this.Hamiltonian.distanceScale);
                break;
            }
            case 5: {
                sp = sp + sep + "D" + String.format("%06.3f", this.Hamiltonian.distanceScale) + sep + "beta" + String.format("%06.3g", this.betaInitial);
                break;
            }
            case 6: {
                sp = sp + sep + "D" + String.format("%06.3f", this.Hamiltonian.distanceScale);
                break;
            }
        }
        return sp;
    }

    public void showDistanceValues(String cc, int dec) {
        this.showDistanceValues(System.out, cc, dec);
    }

    public void showDistanceValues(PrintStream PS, String cc, int dec) {
        int i;
        PS.println(cc + "*** Fixed DISTANCE VALUES, scale = " + SEPSTRING + this.Hamiltonian.distanceScale + SEPSTRING + " short scale=" + SEPSTRING + this.Hamiltonian.shortDistanceScale + SEPSTRING + "***************** ");
        for (i = 0; i < this.numberSites; ++i) {
            PS.print(SEPSTRING + this.siteSet.getName(i));
        }
        PS.println();
        for (i = 0; i < this.numberSites; ++i) {
            PS.print(this.siteSet.getName(i));
            for (int j = 0; j < this.numberSites; ++j) {
                PS.print(SEPSTRING + this.TruncDec(this.edgeSet.getEdgeDistance(i, j), dec));
            }
            PS.println();
        }
    }

    public void FileOutputDistanceValues(String cc, int dec) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_distvalues", "dat");
        if (this.message.getInformationLevel() > -2) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printiNVERSION(cc, PS);
            this.showDistanceValues(PS, cc, dec);
            try {
                fout.close();
                if (this.message.getInformationLevel() > -2) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void showScaledDistanceValues(PrintStream PS, String cc, int dec) {
        double sdv = 0.0;
        PS.println(cc + "--- SCALED DISTANCES in units of " + this.TruncDec(this.Hamiltonian.distanceScale, dec) + " -------------");
        for (int i = 0; i < this.numberSites; ++i) {
            PS.print(SEPSTRING + this.siteSet.getName(i));
            for (int j = 0; j < this.numberSites; ++j) {
                sdv = this.TruncDec(this.edgeSet.getEdgeDistance(i, j) / this.Hamiltonian.distanceScale, dec);
                PS.print(SEPSTRING + sdv);
            }
            PS.println();
        }
    }

    public void showScaledDistanceValues(String cc, int dec) {
        this.showScaledDistanceValues(System.out, cc, dec);
    }

    public void showPotentialDistanceValues(String cc, int dec) {
        this.showPotentialDistanceValues(System.out, cc, dec);
    }

    public void showPotentialDistanceValues(PrintStream PS, String cc, int dec) {
        double sdv = 0.0;
        PS.println("--- POTENTIAL SCALE (edge value 1.0) ------");
        for (int i = 0; i < this.numberSites; ++i) {
            PS.print(SEPSTRING + this.siteSet.getName(i));
            for (int j = 0; j < this.numberSites; ++j) {
                sdv = this.TruncDec(this.edgeSet.getEdgePotential1(i, j), dec);
                PS.print(SEPSTRING + sdv);
            }
            PS.println();
        }
    }

    public void showdHValues(double ev) {
        int dec = 3;
        double sdv = 0.0;
        System.out.println("--- dH Values for edge value 1.0 ------");
        for (int i = 0; i < this.numberSites; ++i) {
            System.out.print(SEPSTRING + this.siteSet.getName(i));
            for (int j = 0; j < this.numberSites; ++j) {
                sdv = this.TruncDec(this.deltaEdgeHamiltonian(i, j, ev), dec);
                System.out.print(SEPSTRING + sdv);
            }
            System.out.println();
        }
    }

    public void FileOutputEdgeVariableFullTable(String cc, int dec, String type) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_edgetableM" + this.edgeSet.metric.getNumber(), "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printiNVERSION(cc, PS);
            PS.println(cc + "Number of Sites" + SEPSTRING + this.numberSites);
            this.edgeSet.printEdgeFullTable(cc, PS, SEPSTRING, dec, "value", this.siteSet);
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void showEdgeValueFullTable(String cc, int dec) {
        this.edgeSet.printEdgeFullTable(cc, System.out, SEPSTRING, dec, "value", this.siteSet);
    }

    public void FileOutputEdgeValueFullTable(String cc, int dec) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_edgetableM" + this.edgeSet.metric.getNumber(), "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printiNVERSION(cc, PS);
            PS.println(cc + "Number of Sites" + SEPSTRING + this.numberSites);
            this.edgeSet.printEdgeFullTable(cc, PS, SEPSTRING, dec, "value", this.siteSet);
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void FileOutputEdgeList(String cc, int dec) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_edgelist", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.edgeSet.printList(PS, cc, SEPSTRING, dec, true);
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void FileOutputGeneCorrelation(String cc, int dec) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_edgegenesep", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.edgeSet.printEdgeFullTable(cc, PS, SEPSTRING, dec, "geneCorrelation", this.siteSet);
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public String breakString(String bs, int n, String sep) {
        String s = "";
        for (int i = 0; i < n; ++i) {
            s = s + bs + sep;
        }
        return s;
    }

    public void showEdgeList(String cc, PrintStream PS, int dec) {
        this.edgeSet.metric.set(4);
        this.edgeSet.doDijkstra(this.siteSet.getSiteArray(), this.Hamiltonian.shortDistanceScale);
        PS.println(cc + "number" + SEPSTRING + "source" + SEPSTRING + "target" + SEPSTRING + IslandEdge.toStringLabel(SEPSTRING) + " M" + this.edgeSet.metric.getNumber() + SEPSTRING + this.iNVERSIONString(SEPSTRING));
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                if (i == j) continue;
                PS.println(i * this.numberSites + j + SEPSTRING + i + SEPSTRING + j + SEPSTRING + this.edgeSet.getEdgeString(i, j, SEPSTRING, dec));
            }
        }
    }

    public void showEdgeWeights(String cc, PrintStream PS, int dec) {
        double[][] weights = new double[this.numberSites][this.numberSites];
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                weights[i][j] = this.siteSet.getWeight(i) * this.edgeSet.getEdgeValue(i, j);
            }
        }
        this.showTable("Weights", weights, cc, PS, dec);
    }

    public void showTable(String dataName, double[][] data, String cc, PrintStream PS, int dec) {
        double[] inData = new double[this.numberSites];
        PS.println(cc + dataName + this.breakString("***", this.numberSites, SEPSTRING));
        PS.print(cc + "Name");
        for (int i = 0; i < this.numberSites; ++i) {
            PS.print(SEPSTRING + this.siteSet.getName(i));
            inData[i] = 0.0;
        }
        PS.println("\tTot.OUT." + dataName);
        double outTotal = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            PS.print(this.siteSet.getName(i));
            for (int j = 0; j < this.numberSites; ++j) {
                outTotal += data[i][j];
                PS.print(SEPSTRING + this.TruncDec(data[i][j], dec));
            }
            PS.println(SEPSTRING + this.TruncDec(outTotal, dec) + SEPSTRING + this.siteSet.getName(i));
        }
        PS.println();
        double total = 0.0;
        PS.print("Tot.In " + dataName);
        for (int i = 0; i < this.numberSites; ++i) {
            total += inData[i];
            PS.print(SEPSTRING + this.TruncDec(inData[i], dec));
        }
        PS.println(SEPSTRING + total);
    }

    public void showColourValues(String cc, int dec) {
        this.showColourValues(cc, System.out, dec);
    }

    public void FileOutputColourValues(String cc, int dec) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_colour.dat", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printiNVERSION(cc, PS);
            PS.println(cc + "Number of Sites" + SEPSTRING + this.numberSites);
            this.showColourValues(cc, PS, dec);
            try {
                fout.close();
                System.out.println("Finished writing to " + filenamecomplete);
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void showColourValues(String cc, PrintStream PS, int dec) {
        int i;
        PS.println(cc + "--- Colour Values ------------------------------");
        PS.print("From/to");
        for (i = 0; i < this.numberSites; ++i) {
            PS.print(SEPSTRING + this.siteSet.getName(i));
        }
        PS.println();
        PS.print("S.Col.");
        this.siteSet.printDisplaySizes(PS, SEPSTRING, 3);
        PS.print("\n\nFrom/to");
        for (i = 0; i < this.numberSites; ++i) {
            PS.print(SEPSTRING + this.siteSet.getName(i));
        }
        PS.println();
        for (i = 0; i < this.numberSites; ++i) {
            PS.print(this.siteSet.getName(i));
            for (int j = 0; j < this.numberSites; ++j) {
                PS.print(SEPSTRING + this.TruncDec(this.edgeSet.getEdgeColour(i, j), 3));
            }
            PS.println();
        }
    }

    public void showFixedSiteVariables(PrintStream PS, String cc, int dec) {
        this.siteSet.printFixedSiteVariables(PS, cc, SEPSTRING);
        PS.println(cc + SEPSTRING + "MIN" + SEPSTRING + " " + SEPSTRING + this.siteSet.minX + SEPSTRING + this.siteSet.minY + SEPSTRING + " ");
        PS.println(cc + SEPSTRING + "MAX" + SEPSTRING + " " + SEPSTRING + this.siteSet.maxX + SEPSTRING + this.siteSet.maxY + SEPSTRING + " ");
    }

    public void showFixedSiteVariables(String cc, int dec) {
        this.showFixedSiteVariables(System.out, cc, dec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDistanceData() {
        TextReader data;
        String filename = this.inputFile.getFullFileName("_dist", "dat");
        System.out.println("Starting to read distance data from " + filename);
        try {
            data = new TextReader(new FileReader(filename));
        }
        catch (FileNotFoundException e) {
            System.out.println("Can't find file " + filename);
            return 1;
        }
        try {
            String[] nametemp = new String[200];
            int numberCt = 0;
            while (!data.eoln()) {
                nametemp[numberCt] = data.getWord();
                ++numberCt;
            }
            this.numberSites = numberCt;
            this.siteSet = new IslandSiteSet(this.numberSites);
            for (int i = 0; i < this.numberSites; ++i) {
                this.siteSet.setName(i, nametemp[i]);
            }
            double dist = -97531.2468;
            int siteFrom = 0;
            while (!data.eof()) {
                int siteTo = 0;
                data.getWord();
                while (!data.eoln()) {
                    dist = data.getDouble();
                    this.edgeSet.setEdgeDistance(siteFrom, siteTo, dist);
                    if (++siteTo == this.numberSites) continue;
                    System.out.println("Wrong number of distances to in site " + siteFrom);
                }
                ++siteFrom;
            }
            if (siteFrom != this.numberSites) {
                System.out.println("Wrong number of distances from in " + filename);
            }
            System.out.println("Finished reading from " + filename);
        }
        catch (TextReader.Error e) {
            System.out.println("Input Error: " + e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Too many numbers in data file" + filename);
            System.out.println("Processing has been aborted.");
        }
        finally {
            data.close();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int getSiteData() {
        filename = this.inputFile.getFullLocationSimpleFileName("_input", "dat");
        System.out.println("getSiteData() Starting to read site values and position data from " + filename);
        datatype = "RUBBISH";
        sarray = new String[200];
        tempsite = new IslandSite();
        tabletype = 0;
        temptable = new double[200][200];
        try {
            data = new TextReader(new FileReader(filename));
        }
        catch (FileNotFoundException e) {
            System.out.println("Can't find file " + filename);
            return -100;
        }
        try {
            sitedata = true;
            linenumber = 0;
            this.numberSites = 0;
            while (sitedata && !data.eof()) {
                ++linenumber;
                datatype = data.getWord();
                this.message.println(1, "first word is " + datatype);
                if (datatype.startsWith("#")) {
                    tempstring = datatype + data.getln();
                    this.message.println(1, "Line " + linenumber + ", Comment: " + tempstring);
                    continue;
                }
                if (datatype.startsWith("*")) {
                    tempstring = datatype + data.getln();
                    if (this.message.testInformationLevel(1)) {
                        System.out.println("Line " + linenumber + ", Table Start: " + tempstring);
                    }
                    sitedata = false;
                    continue;
                }
                if (datatype.startsWith("!")) {
                    if (datatype.length() < 2) {
                        System.err.println("ERROR line " + linenumber + ": no Gene name in  - " + datatype);
                        continue;
                    }
                    geneNumber = this.siteSet.addGene(datatype.substring(1));
                    this.message.println(1, "Line " + linenumber + ", Gene: " + datatype.substring(1));
                    numberCt = 0;
                    while (!data.eoln()) {
                        sarray[numberCt++] = data.getWord();
                    }
                    if (this.numberSites <= 0) {
                        this.numberSites = numberCt;
                        this.initialiseArrays(-1.0);
                    } else if (this.numberSites != numberCt) {
                        System.out.println("WARNING line " + linenumber + ": found  " + numberCt + " columns expected " + this.numberSites);
                        continue;
                    }
                    if ((col = -this.siteSet.setGeneValues(geneNumber, sarray)) <= 0) continue;
                    System.out.println("WARNING line " + linenumber + ": gene number " + geneNumber + ", wrong type of input in column " + col + " - line ignored");
                    continue;
                }
                v = tempsite.dataNameNumber(datatype, 4);
                if (v < 0) {
                    System.out.println("WARNING line " + linenumber + ": unknown first word " + datatype + " - line ignored");
                    continue;
                }
                this.message.println(1, "Line " + linenumber + ", General Data Type: " + datatype);
                numberCt = 0;
                while (!data.eoln()) {
                    sarray[numberCt++] = data.getWord();
                }
                if (this.numberSites <= 0) {
                    this.numberSites = numberCt;
                    this.initialiseArrays(-1.0);
                } else if (this.numberSites != numberCt) {
                    System.out.println("WARNING line " + linenumber + ": found  " + numberCt + " columns expected " + this.numberSites);
                    continue;
                }
                if ((col = -this.siteSet.setValues(v, sarray)) <= 0) continue;
                System.out.println("WARNING line " + linenumber + ": wrong type of input in column " + col + ", line ignored");
            }
            if (this.siteSet.isLatLongSet() && !this.siteSet.isXYSet()) {
                this.siteSet.setXYFromLatLong();
            } else {
                this.siteSet.rescaleXY();
            }
            if (datatype.substring(0, 3).equalsIgnoreCase("*Di")) {
                tabletype = 1;
            }
            if (datatype.substring(0, 3).equalsIgnoreCase("*Pe")) {
                tabletype = 2;
            }
            if (!data.eof()) {
                siteFrom = 0;
                while (!data.eof()) {
                    ++linenumber;
                    siteTo = 0;
                    data.getWord();
                    while (!data.eoln()) {
                        temptable[siteFrom][siteTo] = data.getDouble();
                        ++siteTo;
                    }
                    if (siteTo != this.numberSites) {
                        System.out.println("WARNING line " + linenumber + ": Wrong number (" + siteTo + ") of distances from site " + siteFrom);
                    }
                    if (siteTo < this.numberSites) {
                        tabletype = -3;
                    }
                    ++siteFrom;
                }
                if (siteFrom != this.numberSites) {
                    System.out.println("WARNING line " + linenumber + ": Wrong number (" + siteFrom + ") of distance entries in table in " + filename);
                }
                if (siteFrom < this.numberSites) {
                    tabletype = -2;
                }
            }
            switch (tabletype) {
                case 0: {
                    this.message.println(0, "Finished reading from " + filename + " - No table found");
                    ** break;
lbl104:
                    // 1 sources

                    break;
                }
                case 1: {
                    this.message.println(0, "Finished reading from " + filename + " - Distances read");
                    ** break;
lbl108:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.message.println(0, "Finished reading from " + filename + " - Penalties read");
                    ** break;
lbl112:
                    // 1 sources

                    break;
                }
                default: {
                    this.message.printERROR("Finished reading from " + filename + " *** Unknown Table Type or error in reading it");
                    tabletype = -10 + tabletype;
                    break;
                }
            }
        }
        catch (TextReader.Error e) {
            System.out.println("Problem reading the data from the input file. Error: " + e.getMessage());
            tabletype = -20 + tabletype;
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Too many numbers in data file" + filename);
            System.out.println("Processing has been aborted.");
            tabletype = -30 + tabletype;
        }
        finally {
            data.close();
        }
        if (this.jiggleScale > 0.0) {
            this.jiggleSiteData(this.Hamiltonian.distanceScale * this.jiggleScale);
        }
        this.siteSet.setShortNames();
        if (tabletype >= 0) {
            dist = -99.753;
            for (i = 0; i < this.numberSites; ++i) {
                for (j = 0; j < this.numberSites; ++j) {
                    switch (tabletype) {
                        case 0: {
                            if (this.siteSet.isLatLongSet()) {
                                dist = this.siteSet.sphericalDistance(i, j);
                                break;
                            }
                            dist = this.siteSet.euclideanDistance(i, j);
                            break;
                        }
                        case 1: {
                            dist = temptable[i][j];
                            break;
                        }
                        case 2: {
                            dist = this.siteSet.isLatLongSet() != false ? this.siteSet.sphericalDistance(i, j) : this.siteSet.euclideanDistance(i, j);
                            dist *= temptable[i][j];
                            break;
                        }
                        default: {
                            System.out.println("*** Unknown Table Type or error in reading it");
                            tabletype = -40;
                        }
                    }
                    this.edgeSet.setEdgeDistance(i, j, dist);
                }
            }
        }
        if (this.siteSet.isGenetic()) {
            this.edgeSet.setGeneCorrelations(this.siteSet);
            if (this.outputMode.isSet(OutputMode.GeneSeparationIndex)) {
                this.FileOutputGeneCorrelation("#", 3);
            }
        }
        this.siteSet.calcAlphabeticalOrder();
        if (this.numberSites > 0) {
            this.edgeSet.zeroColourFrac = 1.0 / (double)this.numberSites;
        }
        return tabletype;
    }

    public void jiggleSiteData(double scale) {
        double theta = -1.0;
        double r = -1.0;
        double dscale = -1.0;
        double newX = 0.0;
        double newY = 0.0;
        double newdist = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            theta = Math.PI * 2 * rnd.nextDouble();
            r = (2.0 * rnd.nextDouble() - 1.0) * scale;
            newX = this.siteSet.getX(i) + r * Math.sin(theta);
            newY = this.siteSet.getY(i) + r * Math.cos(theta);
            for (int j = 0; j < this.numberSites; ++j) {
                dscale = this.edgeSet.getEdgeDistance(i, j) / this.siteSet.euclideanDistance(i, j);
                newdist = Distances.euclideanDistance((double)newX, (double)newY, (double)this.siteSet.getX(j), (double)this.siteSet.getY(j)) * dscale;
                this.edgeSet.setEdgeDistance(i, j, newdist);
                this.edgeSet.setEdgeDistance(j, i, newdist);
            }
            this.siteSet.setXY(i, newX, newY);
        }
        this.siteSet.setMinMaxXY();
    }

    public void FileOutputCultureStatistics(String cc, int dec) {
        if (this.networkCulture == null) {
            return;
        }
        String filenamecomplete = this.outputFile.getFullLocationFileName("_culture.dat", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printiNVERSION(cc, PS);
            PS.println(cc + "Number of Sites" + SEPSTRING + this.numberSites);
            this.networkCulture.print(PS, cc, SEPSTRING, dec);
            try {
                fout.close();
                System.out.println("Finished writing to " + filenamecomplete);
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    void FileOutputSiteDistance(String cc) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_svpdist", "dat");
        System.out.println("Attempting to write to " + filenamecomplete);
        try {
            int i;
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            PS.print("Name");
            for (i = 0; i < this.numberSites; ++i) {
                PS.print(SEPSTRING + this.siteSet.getName(i));
            }
            PS.println();
            PS.print("Size");
            for (i = 0; i < this.numberSites; ++i) {
                PS.print(SEPSTRING + this.siteSet.getSize(i));
            }
            PS.println();
            if (this.siteSet.isXYSet()) {
                PS.print("XPos");
                for (i = 0; i < this.numberSites; ++i) {
                    PS.print(this.siteSet.getX(i) + SEPSTRING);
                }
                PS.println();
                PS.print("YPos");
                for (i = 0; i < this.numberSites; ++i) {
                    PS.print(this.siteSet.getY(i) + SEPSTRING);
                }
                PS.println();
            }
            if (this.siteSet.isLatLongSet()) {
                PS.print("Lat");
                for (i = 0; i < this.numberSites; ++i) {
                    PS.print(this.siteSet.getLatitude(i) + SEPSTRING);
                }
                PS.println();
                PS.print("Long");
                for (i = 0; i < this.numberSites; ++i) {
                    PS.print(this.siteSet.getLongitude(i) + SEPSTRING);
                }
                PS.println();
            }
            for (i = 0; i < this.numberSites; ++i) {
                PS.print(this.siteSet.getName(i));
                for (int j = 0; j < this.numberSites; ++j) {
                    PS.print(SEPSTRING + this.edgeSet.getEdgeDistance(i, j));
                }
                PS.println();
            }
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void FileOutputNetworkParam(String cc, int dec) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_param", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printiNVERSION(cc, PS);
            PS.println("Number of Sites\t" + this.numberSites);
            this.showHamiltonianParameters(PS);
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void FileOutputNetworkStatistics(String cc, int dec) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_info", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printiNVERSION(cc, PS);
            PS.println("Number of Sites\t" + this.numberSites);
            this.showHamiltonianParameters(PS);
            this.showNetworkStatistics(cc, PS, dec);
            if (this.edgeSet.isSet(IslandEdge.distanceINDEX, 1)) {
                this.showDistanceValues(PS, cc, dec);
            }
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void printiNVERSION(String cc) {
        this.printiNVERSION(cc, System.out);
    }

    public void printiNVERSION(String cc, PrintStream PS) {
        PS.println(cc + SEPSTRING + " --- ARIADNE" + SEPSTRING + " iNVERSION " + SEPSTRING + this.iNVERSIONString(SEPSTRING) + SEPSTRING + " ---");
    }

    public String iNVERSIONString(String sep) {
        return iNVERSION + sep + timTime.fullString(sep);
    }

    public void showHamiltonianParameters() {
        this.showHamiltonianParameters(System.out);
    }

    public void showHamiltonianParameters(PrintStream PS) {
        PS.println("--- Parameters for Hamiltonian Model number\t" + this.modelNumber.major + "_" + this.modelNumber.minor);
        PS.println("    " + this.modelNumber.majorString + " " + this.modelNumber.minorString);
        this.Hamiltonian.printParameters(PS, SEPSTRING);
        PS.println("      metric number \t" + this.edgeSet.metric.getNumber());
        PS.println("           edgeMode \t" + this.edgeSet.edgeMode.edgeModeValue() + SEPSTRING + this.edgeSet.edgeMode.description());
        PS.println("         vertexMode \t" + this.vertexMode.descriptionValue(SEPSTRING));
    }

    public void showInputParameters(PrintStream PS) {
        PS.println("Model\t" + this.modelNumber.majorString + SEPSTRING + this.modelNumber.minorString);
        this.Hamiltonian.printParameters(PS, SEPSTRING);
        PS.println("Metric\t" + this.edgeSet.metric.getNumber());
        PS.println("edgeMode\t" + this.edgeSet.edgeMode.edgeModeValue());
    }

    public void printNetworkStatistics(String cc, int dec) {
        this.showNetworkStatistics(cc, System.out, dec);
    }

    public void FileOutputKMLNetwork(String cc, int dec) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("", "kml");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.showKMLNetwork(PS, cc, dec);
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    private void showKMLNetwork(PrintStream PS, String cc, int dec) {
        int s;
        KMLGenerator.printInitialLines((PrintStream)PS);
        KMLGenerator.printName((PrintStream)PS, (String)("Ariadne Network " + this.iNVERSIONString(" ")));
        KMLGenerator.printDescription((PrintStream)PS, (String)("-v" + this.modelNumber.number + "-u" + this.updateMode.getNumber() + " " + this.vertexMode.modeString() + "\n" + this.Hamiltonian.inputParametersString(" ")));
        KMLGenerator.printLookAt((PrintStream)PS, (double)this.siteSet.getLatitude(0), (double)this.siteSet.getLongitude(0), (double)800000.0);
        for (s = 0; s < this.numberSites; ++s) {
            KMLGenerator.printPlacemarkPoint((PrintStream)PS, (String)this.siteSet.getName(s), (String)this.siteSet.toString(s, ": ", "\n", 4), (double)this.siteSet.getLatitude(s), (double)this.siteSet.getLongitude(s));
        }
        for (s = 0; s < this.numberSites; ++s) {
            double slat = this.siteSet.getLatitude(s);
            double slong = this.siteSet.getLongitude(s);
            for (int t = 0; t < this.numberSites; ++t) {
                if (this.edgeSet.getEdgeDisplaySize(s, t) < this.edgeSet.zeroColourFrac) continue;
                double tlat = this.siteSet.getLatitude(t);
                double tlong = this.siteSet.getLongitude(t);
                String name = s + " - " + t;
                String description = "From " + this.siteSet.getName(s) + " to " + this.siteSet.getName(t) + "\n" + this.edgeSet.toString(s * this.numberSites + t, ": ", "\n", 5);
                KMLGenerator.printPlacemarkLine((PrintStream)PS, (boolean)false, (String)name, (String)description, (double)slat, (double)slong, (double)tlat, (double)tlong);
            }
        }
        KMLGenerator.printFinalLines((PrintStream)PS);
    }

    public void FileOutputNetworkForData(String cc, int dec) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("", NETWORKDATAFILEEXT);
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.showNetworkForData(PS, cc, dec);
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void printNetworkForData(String cc, int dec) {
        this.showNetworkForData(System.out, cc, dec);
    }

    private void showNetworkForData(PrintStream PS, String cc, int dec) {
        this.printiNVERSION(cc, PS);
        PS.print("*param");
        PS.print("\t-v" + this.modelNumber.number);
        PS.print("\t-u" + this.updateMode.getNumber());
        PS.println(SEPSTRING + this.vertexMode.modeString());
        PS.println("*param\t" + this.Hamiltonian.inputParametersString(SEPSTRING));
        PS.println("*sites\t" + this.numberSites);
        PS.println(IslandSite.parameterStringNames(SEPSTRING) + this.siteSet.geneNameString("\t!"));
        this.siteSet.printSiteParameters(PS, cc, SEPSTRING);
        PS.println("*edges");
        this.edgeSet.printParameterList(PS, "", SEPSTRING, dec, true);
    }

    public void showNetworkStatistics(String cc, PrintStream PS, int dec) {
        int i;
        this.globalProperties.print(PS, SEPSTRING);
        PS.println(cc + " ***" + SEPSTRING + "Site Weights and Values" + this.breakString("***", this.numberSites, SEPSTRING));
        this.siteSet.printSiteVariables(PS, cc, SEPSTRING);
        this.edgeSet.printEdgeFullTable(cc, PS, SEPSTRING, dec, "value", this.siteSet);
        this.edgeSet.printEdgeFullTable(cc, PS, SEPSTRING, dec, "weight", this.siteSet);
        PS.println(cc + " ***" + SEPSTRING + " Influence");
        PS.println(cc + " Influence Prob. " + this.influenceProb);
        PS.print(cc + "Name");
        for (i = 0; i < this.numberSites; ++i) {
            PS.print(SEPSTRING + this.siteSet.getName(i));
        }
        PS.println();
        PS.print("Infl.Rank");
        this.siteSet.printValues(PS, cc, SEPSTRING, "InfluenceRank");
        PS.println("\tInfl.Rank");
        this.showInfluenceMatrix(cc, PS, dec);
        if (this.networkCulture != null) {
            PS.println(cc + " ***" + SEPSTRING + "Culture" + SEPSTRING + "(column j's culture at site row i) ***** ");
            PS.print(cc + " Culture Probabilities  " + this.networkCulture.eProb.toString(SEPSTRING));
            PS.print(cc + "Name" + SEPSTRING + SEPSTRING);
            for (i = 0; i < this.numberSites; ++i) {
                PS.print(SEPSTRING + this.siteSet.getName(i));
            }
            PS.println();
            this.networkCulture.print(PS, cc, SEPSTRING, 3);
        }
        PS.println(cc + "*** SCALES *******************");
        PS.println(cc + "Single Edge Max Value        " + SEPSTRING + this.TruncDec(this.siteSet.siteValueStats.maximum, dec) + SEPSTRING + " at vertex " + this.siteSet.maxSiteValueIndex);
        PS.println(cc + "Single Edge Max Weight       " + SEPSTRING + this.TruncDec(this.edgeSet.edgeStats[IslandEdge.weightINDEX].maximum, dec) + SEPSTRING + " from vertex " + this.edgeSet.maxEdgeWeightSource + " to " + this.edgeSet.maxEdgeWeightTarget);
        PS.println(cc + "Single Site Max Weight       " + SEPSTRING + this.TruncDec(this.siteSet.siteWeightStats.maximum, dec) + SEPSTRING + " at vertex " + this.siteSet.maxSiteWeightIndex);
        PS.println(cc + "Single Site Max out Strength " + SEPSTRING + this.TruncDec(this.siteSet.siteStrengthOutStats.maximum, dec) + SEPSTRING + " at vertex " + this.siteSet.maxOutSiteStrengthIndex);
        PS.println(cc + "*** TOTALS *******************");
        PS.println(cc + "Total Vertex Value and Weight " + SEPSTRING + this.TruncDec(this.siteSet.siteValueStats.getTotal(), dec) + SEPSTRING + this.TruncDec(this.siteSet.siteWeightStats.getTotal(), dec));
        PS.println(cc + "  Total Edge Value and Weight " + SEPSTRING + this.TruncDec(this.edgeSet.edgeStats[IslandEdge.valueINDEX].getTotal(), dec) + SEPSTRING + this.TruncDec(this.edgeSet.edgeStats[IslandEdge.weightINDEX].getTotal(), dec));
        PS.println(cc + "--- Display Factors --------------------------------");
        PS.println(cc + "Zero, Minimum Fraction for coloured edges = " + SEPSTRING + this.edgeSet.zeroColourFrac + SEPSTRING + this.edgeSet.minColourFrac);
        PS.println(cc + "Max Site and Edge Size = " + SEPSTRING + this.siteWeightFactor + SEPSTRING + this.edgeWidthFactor);
    }

    public void printPajekSiteFiles(String cc, PrintStream PS, int dec, int variableNumber) {
        this.siteSet.printValueVector(PS, variableNumber);
    }

    public void saveFiles(String cc, int dec) {
        this.setOutputFileName();
        this.calcNetworkStats();
        if (this.outputMode.isSet(OutputMode.KMLIndex)) {
            this.FileOutputKMLNetwork(COMMENT, 5);
        }
        if (this.outputMode.isSet(OutputMode.AriadneNetworkFileIndex)) {
            this.FileOutputNetworkForData(COMMENT, 5);
        }
        if (this.outputMode.isSet(OutputMode.InfoIndex)) {
            this.FileOutputNetworkStatistics(COMMENT, 3);
        }
        if (this.outputMode.isSet(OutputMode.EdgeListIndex)) {
            this.FileOutputEdgeList(COMMENT, 5);
        }
        if (this.outputMode.isSet(OutputMode.PajekIndex)) {
            String[] pn = new String[]{"Value", "Weight", "Ranking", "Strength", "StrengthIn", "StrengthOut"};
            for (int i = 0; i < pn.length; ++i) {
                this.FileOutputPajekSiteFiles(pn[i]);
            }
            this.FileOutputNetwork(COMMENT, this.siteWeightFactor, this.edgeWidthFactor, this.edgeSet.minColourFrac, this.edgeSet.zeroColourFrac, 0);
        }
    }

    public void showNetwork(String cc, int dec) {
        this.setOutputFileName();
        System.out.println("\n --- Displaying Network --------------------------------------");
        System.out.println("Output mode " + this.outputMode.getNumber() + " " + this.outputMode.toString(SEPSTRING));
        System.out.println("Scale for largest vertices in .net file= " + this.DisplayMaxVertexScale);
        System.out.println("Scale for maximum edges in .net file = " + this.edgeSet.DisplayMaxEdgeScale);
        System.out.println("Minimum Fraction for coloured edge in .net file = " + this.edgeSet.minColourFrac);
        System.out.println("Zero Fraction for coloured edge = " + this.edgeSet.zeroColourFrac);
        this.saveFiles(cc, dec);
        this.message.println(0, "showNetwork inputFile " + this.inputFile.getFullLocationFileRoot());
        NetworkWindow PW = new NetworkWindow(this);
        this.message.println(0, "showNetwork PW.islnet.inputnameroot " + PW.islnet.inputFile.getFullFileRoot());
        PW.drawNetworkWindow();
        this.message.println(0, "In showNetwork finished call to PW.drawNetworkWindow()");
    }

    public void showDijkstraValues(String cc, int dec) {
        this.showDijkstraValues(cc, System.out, dec);
    }

    public void FileOutputDijkstraStatistics(String cc, int dec) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_dijkdistM" + this.edgeSet.metric.getNumber(), "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printiNVERSION(cc, PS);
            PS.println(cc + "Number of Sites" + SEPSTRING + this.numberSites);
            this.showDijkstraValues(cc, PS, dec);
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void showDijkstraValues(String cc, PrintStream PS, int dec) {
        int i;
        PS.println("--- Dijkstra Results for metric " + this.edgeSet.metric.toString() + ", metric number" + this.edgeSet.metric.getNumber());
        if (this.edgeSet.DijkstraMaxSep < IslandEdgeSet.MAXSEPARATION) {
            PS.println("Connected, max distance " + this.TruncDec(this.edgeSet.DijkstraMaxSep, dec));
        } else {
            PS.println("DISCONNECTED");
        }
        double totaldistance = 0.0;
        PS.print("From/To");
        for (i = 0; i < this.numberSites; ++i) {
            PS.print(SEPSTRING + this.siteSet.getName(i));
        }
        PS.println();
        for (i = 0; i < this.numberSites; ++i) {
            PS.print(this.siteSet.getName(i));
            for (int j = 0; j < this.numberSites; ++j) {
                if (this.edgeSet.getEdgeSeparation(i, j) == IslandEdgeSet.MAXSEPARATION) {
                    PS.print("\t x ");
                    continue;
                }
                totaldistance += this.edgeSet.getEdgeSeparation(i, j);
                PS.print(SEPSTRING + this.TruncDec(this.edgeSet.getEdgeSeparation(i, j), dec));
            }
            PS.println();
        }
        PS.println("\n Total Distance (excl. x) " + totaldistance);
        for (i = 0; i < this.numberSites; ++i) {
            PS.println("...\t");
        }
    }

    public void calcNetworkSeparations() {
        this.siteDistanceStats = new StatisticalQuantity(IslandEdgeSet.MAXSEPARATION, -1.0);
        this.edgeSet.doDijkstra(this.siteSet.getSiteArray(), this.Hamiltonian.shortDistanceScale);
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                double d = this.edgeSet.getEdgeSeparation(i, j);
                if (!(d < IslandEdgeSet.MAXSEPARATION)) continue;
                this.siteDistanceStats.add(this.edgeSet.getEdgeSeparation(i, j));
            }
        }
    }

    public void calcNetworkStats() {
        this.siteSet.calcBasicStatistics(this.edgeSet);
        this.edgeSet.calcStats(this.siteSet);
        this.message.println(2, "*** in calcNetworkStats about to calculate ranking ");
        this.calcRanking(1);
        this.message.println(2, "*** in calcNetworkStats about to calculate influence ");
        this.calcInfluence(this.influenceProb);
        this.message.println(2, "*** in calcNetworkStats finished calculating influence ");
        double mvw = -1.0;
        mvw = this.DisplayMaxVertexScale > 0.0 ? this.DisplayMaxVertexScale : this.siteSet.siteWeightStats.maximum;
        if (this.DisplayVertexType.getValue() == 1) {
            mvw = 1.0;
        }
        this.siteSet.setAllDisplaySizes(this.DisplayVertexType.getValueIndex(), (double)PajekColours.numberColours / mvw);
        this.edgeSet.setUpEdgeDisplayValues(this.siteSet, PajekColours.numberColours);
        this.globalProperties.calculateAll(this);
    }

    void calcCulture() {
        double[] siteWeight = new double[this.numberSites];
        double[][] edgeValue = new double[this.numberSites][this.numberSites];
        for (int s = 0; s < this.numberSites; ++s) {
            siteWeight[s] = this.siteSet.getWeight(s);
            for (int t = 0; t < this.numberSites; ++t) {
                edgeValue[s][t] = this.edgeSet.getEdgeValue(s, t);
            }
        }
        int indPerSite = 20;
        int numberInd = this.numberSites * indPerSite;
        double pr = 1.0 / (double)indPerSite;
        double fracinnovate = 0.5;
        this.culturePInnovate = pr * fracinnovate;
        double fraccopy = 1.0 - 1.0 / (double)this.numberSites;
        this.culturePSiteCopy = (1.0 - pr) * fraccopy;
        this.culturePCopy = (1.0 - pr) * (1.0 - fraccopy);
        this.networkCulture = new IslandCulture(this.culturePSiteCopy, this.culturePCopy, this.culturePInnovate);
        this.networkCulture.setup(siteWeight, edgeValue, numberInd, 1);
        int tau2 = (int)(0.5 - 1.0 / Math.log(1.0 - 2.0 * this.culturePSiteCopy / (double)this.numberSites));
        this.networkCulture.message.setInformationLevel(this.message.getInformationLevel());
        this.networkCulture.evolve((int)((double)tau2 * this.cultureTimeScale + 0.5));
        this.networkCulture.calcAllStats();
    }

    void setColours() {
        this.javaColour = new JavaColours(PajekColours.numberColours, true);
    }

    public String getJavaColour(int c) {
        return this.javaColour.RGB(c);
    }

    public void calcTransferMatrix(int transferMatrixType, int edgeType) {
        this.transferMatrix = new IslandTransferMatrix(transferMatrixType, this.numberSites, this.siteSet, this.edgeSet, edgeType);
    }

    public void calcRanking(int transferMatrixType) {
        this.message.println(-1, "*** in calcRanking about to calculate TransferMatrix");
        this.transferMatrix = new IslandTransferMatrix(transferMatrixType, this.numberSites, this.siteSet, this.edgeSet, IslandEdge.valueINDEX);
        this.siteSet.calcRanking(this.transferMatrix);
    }

    public void calcInfluence(double influenceProb) {
        this.siteSet.calcInfluence(this.transferMatrix, influenceProb);
        this.edgeSet.setInfluenceWeight(this.siteSet, this.transferMatrix);
    }

    public void calcInfluence(int transferMatrixType, double influenceProb, int index) {
        this.transferMatrix = new IslandTransferMatrix(transferMatrixType, this.numberSites, this.siteSet, this.edgeSet, index);
        this.calcInfluence(influenceProb);
    }

    public double getInfluenceProbability() {
        return this.transferMatrix.getInfluenceProbability();
    }

    public double getInfluenceMatrix(int i, int j) {
        return this.transferMatrix.getInfluence(i, j);
    }

    public void FileOutputTransferMatrix(String cc, int dec) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_transmat.dat", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printiNVERSION(cc, PS);
            PS.println(cc + "Number of Sites" + SEPSTRING + this.numberSites);
            this.showTransferMatrix(cc, PS, dec);
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void showTransferMatrix(String cc, PrintStream PS, int dec) {
        this.transferMatrix.printTransferMatrix(cc, SEPSTRING, PS, dec, true);
    }

    public void showTransferMatrix(String cc, int dec) {
        this.showTransferMatrix(cc, System.out, dec);
    }

    public void FileOutputInfluenceMatrix(String cc, int dec) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_inflmat.dat", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printiNVERSION(cc, PS);
            PS.println(cc + "Number of Sites" + SEPSTRING + this.numberSites);
            this.showInfluenceMatrix(cc, PS, dec);
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public void showInfluenceMatrix(String cc, PrintStream PS, int dec) {
        this.transferMatrix.printInfluenceMatrix(cc, SEPSTRING, PS, dec, true);
    }

    public void showInfluenceMatrix(String cc, int dec) {
        this.showInfluenceMatrix(cc, System.out, dec);
    }

    void FileOutputBareNetwork(String cc) {
        String filenamecomplete = this.outputFile.getFullLocationFileName("_BareNet", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write to " + filenamecomplete);
        }
        try {
            int i;
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printiNVERSION(cc, PS);
            PS.println(cc + "Line 0" + SEPSTRING + "Number Sites," + SEPSTRING + "Line 1" + SEPSTRING + "Site Size," + SEPSTRING + "Line 2" + SEPSTRING + "Vertex Values," + SEPSTRING + "Line >=3" + SEPSTRING + "Edge Values Value");
            PS.println(this.numberSites);
            for (i = 0; i < this.numberSites; ++i) {
                PS.print(this.siteSet.getSize(i) + SEPSTRING);
            }
            PS.println();
            for (i = 0; i < this.numberSites; ++i) {
                PS.print(this.siteSet.getValue(i) + SEPSTRING);
            }
            PS.println();
            for (i = 0; i < this.numberSites; ++i) {
                for (int j = 0; j < this.numberSites; ++j) {
                    PS.print(this.edgeSet.getEdgeValue(i, j) + SEPSTRING);
                }
                PS.println();
            }
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    void FileOutputNetwork(String cc, int siteWeightFactor, int edgeWidthFactor, double minColourFrac, double zeroColourFrac, int fileType) {
        String filenamecomplete;
        switch (fileType) {
            case 1: {
                filenamecomplete = this.outputFile.getFullLocationFileName("BW", "net");
                break;
            }
            case 2: {
                filenamecomplete = this.outputFile.getFullLocationFileName("C", "net");
                break;
            }
            case 3: {
                filenamecomplete = this.outputFile.getFullLocationFileName("Infl", "net");
                break;
            }
            case 4: {
                filenamecomplete = this.outputFile.getFullLocationFileName("CultCorr", "net");
                break;
            }
            default: {
                filenamecomplete = this.outputFile.getFullLocationFileName("PLAINV", "net");
            }
        }
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write to " + filenamecomplete);
        }
        try {
            int j;
            int i;
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.siteSet.printPajekNetFormat(PS, minColourFrac, zeroColourFrac, fileType);
            switch (fileType) {
                case 3: 
                case 4: {
                    PS.println("*Arcs    " + this.numberSites * this.numberSites);
                    break;
                }
                default: {
                    int arcCount = 0;
                    for (i = 0; i < this.numberSites; ++i) {
                        for (j = 0; j < this.numberSites; ++j) {
                            if (!(this.edgeSet.getEdgeColour(i, j) > (double)PajekColours.numberColours * zeroColourFrac)) continue;
                            ++arcCount;
                        }
                    }
                    PS.println("*Arcs    " + arcCount);
                }
            }
            for (i = 0; i < this.numberSites; ++i) {
                double vw = this.siteSet.getWeight(i);
                block20: for (j = 0; j < this.numberSites; ++j) {
                    if (fileType == 3) {
                        PS.println(i + 1 + "  " + (j + 1) + "   " + this.transferMatrix.getInfluence(i, j) + " w " + vw * this.edgeSet.getEdgeValue(i, j));
                        continue;
                    }
                    if (fileType == 4) {
                        if (i == j || this.networkCulture == null) continue;
                        PS.println(i + 1 + "  " + (j + 1) + "   " + this.networkCulture.cultureCorrelation[i][j] + " w " + vw * this.edgeSet.getEdgeValue(i, j));
                        continue;
                    }
                    int ec = (int)(0.499999 + this.edgeSet.getEdgeColour(i, j));
                    if (i == j || (double)ec <= zeroColourFrac * (double)PajekColours.numberColours) continue;
                    if (ec > PajekColours.numberColours) {
                        ec = PajekColours.numberColours;
                    }
                    if ((double)ec < minColourFrac * (double)PajekColours.numberColours) {
                        ec = 1;
                    }
                    double ew = this.updateMode.isPPA() ? (double)ec / (double)PajekColours.numberColours : vw * this.edgeSet.getEdgeValue(i, j);
                    int width = edgeWidthFactor * ec / PajekColours.numberColours;
                    PS.print(i + 1 + "  " + (j + 1) + "   " + ew + " w " + width);
                    switch (fileType) {
                        case 1: {
                            PS.println("  c " + PajekColours.getGrey(ec));
                            continue block20;
                        }
                        case 2: {
                            PS.println("  c " + PajekColours.colours[ec]);
                            continue block20;
                        }
                        default: {
                            PS.println();
                        }
                    }
                }
            }
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public boolean FileOutputPajekSiteFiles(String variableName) {
        return this.FileOutputPajekSiteFiles(IslandSite.getIndex(variableName));
    }

    public boolean FileOutputPajekSiteFiles(int variableNumber) {
        String ext = "No Such File";
        if (IslandSite.isInt(variableNumber)) {
            ext = "clu";
        } else if (IslandSite.isDouble(variableNumber)) {
            ext = "vec";
        } else {
            return false;
        }
        String filenamecomplete = this.outputFile.getFullLocationFileName(IslandSite.dataName(variableNumber), ext);
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write to " + filenamecomplete);
        }
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            PS.println("*Vertices " + this.numberSites);
            for (int i = 0; i < this.numberSites; ++i) {
                PS.println(this.siteSet.getVariable(i, variableNumber));
            }
            try {
                fout.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.out.println("File Error");
                return false;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return false;
        }
        return true;
    }

    public String testDirectory(String dirname) {
        String mess = "";
        File dir = new File(dirname);
        if (!dir.isDirectory()) {
            mess = dirname + " not a directory";
            this.message.printERROR(mess);
        } else {
            mess = "Looking at directory " + dirname;
            this.message.println(0, mess);
        }
        return mess;
    }

    public String getFileList(String ext, String dirname, String[] filenamelist) {
        String mess = "";
        File dir = new File(dirname);
        if (!dir.isDirectory()) {
            mess = dirname + " not a directory";
            this.message.printERROR(mess);
            return mess;
        }
        this.message.println(0, "Looking at directory " + dirname);
        OnlyExtensionSet only = new OnlyExtensionSet(ext);
        String[] filelist = dir.list(only);
        mess = "Found  " + filelist.length + " files with extension " + ext + " in directory " + dirname;
        this.message.println(0, mess);
        filelist = new String[filelist.length];
        for (int i = 0; i < filelist.length; ++i) {
            filenamelist[i] = this.getFileNameRoot(filelist[i], ext);
            this.message.println(0, filelist[i] + SEPSTRING + filenamelist[i]);
        }
        return mess;
    }

    public String getFileNameRoot(String filename, String ext) {
        int i = filename.lastIndexOf(ext);
        if (i < 0) {
            return null;
        }
        return filename.substring(0, i);
    }

    public void calcEntropies() {
        this.globalProperties.calcEntropies(this);
    }

    public void calcEnergy() {
        this.globalProperties.calcEnergy(this);
    }

    public double deltaEdgeHamiltonian(int i, int j, double newValue) {
        double dH = 0.0;
        double de = 0.0;
        switch (this.modelNumber.major) {
            case 5: {
                int k;
                double oldedge = this.edgeSet.getEdgeValue(i, j);
                de = newValue - oldedge;
                dH = this.Hamiltonian.edgeSource * this.siteSet.getSize(i) * de;
                double outstrengthi = this.edgeSet.getOutEdgeStrength(i);
                double sizei = this.siteSet.getSize(i);
                double valuei = this.siteSet.getValue(i);
                dH += this.Hamiltonian.vertexPotential5(sizei, valuei + outstrengthi) - this.Hamiltonian.vertexPotential5(sizei, valuei + outstrengthi + de);
                double demandj = this.modelNumber.bit1 ? this.siteSet.getSize(j) * (this.siteSet.getValue(j) + this.edgeSet.getOutEdgeStrength(j)) : 1.0;
                double dp = this.edgeSet.getEdgePotential1(i, j);
                double oldsupply = this.modelNumber.bit0 ? sizei * (valuei + outstrengthi) : 1.0;
                double newsupply = this.modelNumber.bit0 ? sizei * (valuei + outstrengthi + de) : 1.0;
                dH += oldsupply * dp * oldedge * demandj;
                dH += -newsupply * dp * newValue * demandj;
                if (this.modelNumber.bit0) {
                    for (k = 0; k < this.numberSites; ++k) {
                        if (k == i || k == j) continue;
                        dH += -sizei * de * (this.modelNumber.bit1 ? this.siteSet.getSize(k) * (this.siteSet.getValue(k) + this.edgeSet.getOutEdgeStrength(k)) : 1.0) * this.edgeSet.getEdgePotential1(i, k) * this.edgeSet.getEdgeValue(i, k);
                    }
                }
                if (!this.modelNumber.bit1) break;
                for (k = 0; k < this.numberSites; ++k) {
                    if (k == i) continue;
                    dH += -sizei * de * (this.modelNumber.bit0 ? this.siteSet.getSize(k) * (this.siteSet.getValue(k) + this.edgeSet.getOutEdgeStrength(k)) : 1.0) * this.edgeSet.getEdgePotential1(k, i) * this.edgeSet.getEdgeValue(k, i);
                }
                break;
            }
            case 4: {
                de = newValue - this.edgeSet.getEdgeValue(i, j);
                dH = this.Hamiltonian.edgeSource * this.siteSet.getWeight(i) * de;
                dH += this.Hamiltonian.lambda * de * this.edgeSet.getEdgeDistance(i, j);
                double ki = this.edgeSet.getOutEdgeStrength(i);
                double kinew = ki + de;
                if (ki <= this.Hamiltonian.alpha) {
                    dH -= (1.0 + this.Hamiltonian.alpha - ki) * 1000000.0;
                }
                if (!(kinew <= this.Hamiltonian.alpha)) break;
                dH += (1.0 + this.Hamiltonian.alpha - kinew) * 1000000.0;
                break;
            }
            case 3: {
                dH = this.Hamiltonian.edgeSource * (this.modelNumber.bit0 ? this.siteSet.getWeight(i) : 1.0) * (this.modelNumber.bit1 ? this.siteSet.getWeight(j) : 1.0) * (newValue - this.edgeSet.getEdgeValue(i, j));
                dH += this.edgePotentialTotal3();
                double oldValue = this.edgeSet.getEdgeValue(i, j);
                this.edgeSet.setEdgeValueBounded(i, j, newValue);
                dH -= this.edgePotentialTotal3();
                this.edgeSet.setEdgeValueBounded(i, j, oldValue);
                break;
            }
            case 2: {
                double ci = this.calcConsumption(i);
                double deltaci = (newValue - this.edgeSet.getEdgeValue(i, j)) * this.siteSet.getValue(i) * this.Hamiltonian.consumptioncoeff;
                double cj = this.calcConsumption(j);
                double oi = this.calcOutput(this.siteSet.getValue(i), this.siteSet.getSize(i));
                double oj = this.calcOutput(this.siteSet.getValue(j), this.siteSet.getSize(j));
                double dvj = this.siteSet.getWeight(j) * (oj - cj);
                dH = -(oi - ci) * dvj * this.edgeSet.getEdgePotential1(i, j) * this.siteSet.getValue(i) * this.edgeSet.getEdgeValue(i, j);
                dH += (oi - (ci + deltaci)) * dvj * this.edgeSet.getEdgePotential1(i, j) * this.siteSet.getValue(i) * newValue;
                dH += this.Hamiltonian.kappa * deltaci + this.Hamiltonian.edgeSource * this.siteSet.getWeight(i) * (newValue - this.edgeSet.getEdgeValue(i, j));
                break;
            }
            case 1: {
                dH = (this.modelNumber.bit0 ? this.siteSet.getWeight(i) : 1.0) * (this.modelNumber.bit1 ? this.siteSet.getWeight(j) : 1.0) * this.edgeSet.getEdgePotential1(i, j) * (-newValue + this.edgeSet.getEdgeValue(i, j)) + this.Hamiltonian.edgeSource * this.siteSet.getWeight(i) * (newValue - this.edgeSet.getEdgeValue(i, j));
                break;
            }
        }
        return dH;
    }

    public double calcOutput(double vertexValue, double siteSize) {
        return (1.0 + this.Hamiltonian.outputcoeff) * siteSize * (1.0 - this.Hamiltonian.outputcoeff / (this.Hamiltonian.outputcoeff + vertexValue));
    }

    public double calcConsumption(int i) {
        double w = 0.0;
        for (int j = 0; j < this.numberSites; ++j) {
            w += this.edgeSet.getEdgeValue(i, j);
        }
        return (this.siteSet.getValue(i) + w) * this.siteSet.getSize(i) * this.Hamiltonian.consumptioncoeff;
    }

    public double edgePotentialTotal3() {
        double potl = 0.0;
        this.edgeSet.doDijkstra(this.siteSet.getSiteArray(), this.Hamiltonian.shortDistanceScale);
        for (int i = 0; i < this.numberSites; ++i) {
            double c = this.modelNumber.bit0 ? this.siteSet.getWeight(i) : 1.0;
            for (int j = 0; j < this.numberSites; ++j) {
                if (i == j || this.edgeSet.getEdgeSeparation(i, j) == 0.0 || this.edgeSet.getEdgeValue(i, j) == 0.0) continue;
                potl += c * (this.modelNumber.bit2 ? this.edgeSet.getEdgeSeparation(i, j) : this.edgeSet.getEdgePotentialSeparation1(i, j, this.Hamiltonian)) * (this.modelNumber.bit1 ? this.siteSet.getWeight(j) : 1.0);
            }
        }
        return potl;
    }

    public double deltaVertexHamiltonian(int i, double newValue) {
        double dH = 0.0;
        switch (this.modelNumber.major) {
            case 4: {
                double dv = newValue - this.siteSet.getValue(i);
                dH = dv * this.siteSet.getSize(i) * this.Hamiltonian.vertexSource - this.Hamiltonian.vertexPotential1(this.siteSet.getSize(i), newValue) + this.Hamiltonian.vertexPotential1(this.siteSet.getSize(i), this.siteSet.getValue(i));
            }
            case 2: {
                double ci = this.calcConsumption(i);
                double deltaci = (newValue - this.siteSet.getValue(i)) * this.siteSet.getSize(i) * this.Hamiltonian.consumptioncoeff;
                double oi = this.calcOutput(this.siteSet.getValue(i), this.siteSet.getSize(i));
                double deltaoi = this.calcOutput(newValue, this.siteSet.getSize(i)) - oi;
                dH = this.Hamiltonian.kappa * (deltaci - deltaoi);
                dH += (newValue - this.siteSet.getValue(i)) * this.siteSet.getSize(i) * this.Hamiltonian.vertexSource;
                for (int j = 0; j < this.numberSites; ++j) {
                    if (i == j) continue;
                    dH += (deltaoi - deltaci) * (this.calcOutput(this.siteSet.getValue(j), this.siteSet.getSize(j)) - this.calcConsumption(j)) * this.edgeSet.getEdgePotential1(i, j) * (this.siteSet.getValue(i) * this.edgeSet.getEdgeValue(i, j) + this.siteSet.getValue(j) * this.edgeSet.getEdgeValue(j, i));
                }
                break;
            }
            case 5: {
                double currentSiteValue = this.siteSet.getValue(i);
                double currentSiteSize = this.siteSet.getSize(i);
                double dv = newValue - currentSiteValue;
                double dw = dv * currentSiteSize;
                double currentOutEdgeStrength = this.edgeSet.getOutEdgeStrength(i);
                dH = this.Hamiltonian.vertexSource * dw;
                dH += -this.Hamiltonian.vertexPotential5(currentSiteSize, newValue + currentOutEdgeStrength) + this.Hamiltonian.vertexPotential5(currentSiteSize, currentSiteValue + currentOutEdgeStrength);
                for (int j = 0; j < this.numberSites; ++j) {
                    if (i == j) continue;
                    if (this.modelNumber.bit0) {
                        dH += -dw * this.edgeSet.getEdgePotential1(i, j) * currentSiteSize * this.edgeSet.getEdgeValue(i, j) * (this.modelNumber.bit1 ? this.siteSet.getSize(j) * (this.siteSet.getValue(j) + this.edgeSet.getOutEdgeStrength(j)) : 1.0);
                    }
                    if (!this.modelNumber.bit1) continue;
                    dH += -(this.modelNumber.bit0 ? this.siteSet.getSize(j) * (this.siteSet.getValue(j) + this.edgeSet.getOutEdgeStrength(j)) : 1.0) * this.edgeSet.getEdgePotential1(j, i) * this.siteSet.getSize(j) * this.edgeSet.getEdgeValue(j, i) * dw;
                }
                break;
            }
            case 1: 
            case 3: {
                double dv = newValue - this.siteSet.getValue(i);
                double dw = dv * this.siteSet.getSize(i);
                dH = this.Hamiltonian.vertexSource * dw;
                dH += -this.Hamiltonian.vertexPotential1(this.siteSet.getSize(i), newValue) + this.Hamiltonian.vertexPotential1(this.siteSet.getSize(i), this.siteSet.getValue(i));
                for (int j = 0; j < this.numberSites; ++j) {
                    if (i == j) continue;
                    dH += this.Hamiltonian.edgeSource * dw * this.edgeSet.getEdgeValue(i, j);
                    if (this.modelNumber.bit0) {
                        dH += -dw * (this.modelNumber.bit1 ? this.siteSet.getWeight(j) : 1.0) * this.edgeSet.getEdgePotential1(i, j) * this.edgeSet.getEdgeValue(i, j);
                    }
                    if (!this.modelNumber.bit1) continue;
                    dH += -dw * (this.modelNumber.bit0 ? this.siteSet.getWeight(j) : 1.0) * this.edgeSet.getEdgePotential1(j, i) * this.edgeSet.getEdgeValue(j, i);
                }
                break;
            }
        }
        return dH;
    }

    public double deltaVertexHamiltonian(int i, int i2, double changeWeight) {
        double dH = 0.0;
        switch (this.modelNumber.major) {
            case 1: 
            case 3: {
                double newValue = this.siteSet.getValue(i) - changeWeight / this.siteSet.getSize(i);
                if (!this.vertexMode.testValue(newValue)) {
                    return 9.9E21;
                }
                double newValue2 = this.siteSet.getValue(i2) + changeWeight / this.siteSet.getSize(i2);
                if (!this.vertexMode.testValue(newValue2)) {
                    return 8.8E21;
                }
                dH += -this.Hamiltonian.vertexPotential1(this.siteSet.getSize(i), newValue) + this.Hamiltonian.vertexPotential1(this.siteSet.getSize(i), this.siteSet.getValue(i));
                dH += -this.Hamiltonian.vertexPotential1(this.siteSet.getSize(i2), newValue2) + this.Hamiltonian.vertexPotential1(this.siteSet.getSize(i2), this.siteSet.getValue(i2));
                dH -= this.Hamiltonian.edgeSource * changeWeight * this.edgeSet.getOutEdgeStrength(i);
                dH += this.Hamiltonian.edgeSource * changeWeight * this.edgeSet.getOutEdgeStrength(i2);
                for (int j = 0; j < this.numberSites; ++j) {
                    if (i2 == j) {
                        dH += (this.modelNumber.bit0 ? this.siteSet.getWeight(i) : 1.0) * this.edgeSet.getEdgePotential1(i, i2) * this.edgeSet.getEdgeValue(i, i2) * (this.modelNumber.bit1 ? this.siteSet.getWeight(i2) : 1.0) - (this.modelNumber.bit0 ? this.siteSet.getWeight(i) - changeWeight : 1.0) * this.edgeSet.getEdgePotential1(i, i2) * this.edgeSet.getEdgeValue(i, i2) * (this.modelNumber.bit1 ? this.siteSet.getWeight(i2) + changeWeight : 1.0);
                        continue;
                    }
                    if (i == j) {
                        dH += (this.modelNumber.bit0 ? this.siteSet.getWeight(i2) : 1.0) * this.edgeSet.getEdgePotential1(i2, i) * this.edgeSet.getEdgeValue(i2, i) * (this.modelNumber.bit1 ? this.siteSet.getWeight(i) : 1.0) - (this.modelNumber.bit0 ? this.siteSet.getWeight(i2) + changeWeight : 1.0) * this.edgeSet.getEdgePotential1(i2, i) * this.edgeSet.getEdgeValue(i2, i) * (this.modelNumber.bit1 ? this.siteSet.getWeight(i) - changeWeight : 1.0);
                        continue;
                    }
                    if (this.modelNumber.bit0) {
                        dH += changeWeight * this.edgeSet.getEdgePotential1(i, j) * this.edgeSet.getEdgeValue(i, j) * (this.modelNumber.bit1 ? this.siteSet.getWeight(j) : 1.0);
                    }
                    if (this.modelNumber.bit1) {
                        dH += (this.modelNumber.bit0 ? this.siteSet.getWeight(j) : 1.0) * this.edgeSet.getEdgePotential1(j, i) * this.edgeSet.getEdgeValue(j, i) * changeWeight;
                    }
                    if (this.modelNumber.bit0) {
                        dH -= changeWeight * this.edgeSet.getEdgePotential1(i2, j) * this.edgeSet.getEdgeValue(i2, j) * (this.modelNumber.bit1 ? this.siteSet.getWeight(j) : 1.0);
                    }
                    if (!this.modelNumber.bit1) continue;
                    dH -= (this.modelNumber.bit0 ? this.siteSet.getWeight(j) : 1.0) * this.edgeSet.getEdgePotential1(j, i2) * this.edgeSet.getEdgeValue(j, i2) * changeWeight;
                }
                break;
            }
        }
        return dH;
    }

    public void edgeSweep() {
        double dH = -9.87654321E7;
        double newEdgeValue = 0.0;
        double otherOutStrength = -1.0;
        int i = -1;
        int j = -1;
        int updateTried = 0;
        int updateMade = 0;
        Permutation sourcePerm = new Permutation(this.numberSites);
        double strErrLimit = this.edgeSet.edgeMode.maximumValue * 1.01;
        for (int ip = 0; ip < this.numberSites; ++ip) {
            i = sourcePerm.next();
            Permutation targetPerm = new Permutation(this.numberSites);
            for (int jp = 0; jp < this.numberSites; ++jp) {
                j = targetPerm.next();
                if (i == j || this.edgeSet.getEdgeDistance(i, j) < this.Hamiltonian.shortDistanceScale) continue;
                ++updateTried;
                if (this.edgeSet.edgeMode.outStrengthLimitOn) {
                    otherOutStrength = this.edgeSet.getOutEdgeStrength(i) - this.edgeSet.getEdgeValue(i, j);
                    if (otherOutStrength + (newEdgeValue = (this.edgeSet.edgeMode.maximumValue - otherOutStrength) * rnd.nextDouble()) > strErrLimit) {
                        System.out.println(otherOutStrength + newEdgeValue + " = newOutStrength >1 ");
                        return;
                    }
                } else if (this.edgeSet.edgeMode.maxValueModeOn) {
                    newEdgeValue = rnd.nextDouble() * this.edgeSet.edgeMode.maximumValue;
                } else {
                    double d = newEdgeValue = rnd.nextBoolean() ? 1.0 : 0.0;
                }
                if (newEdgeValue < -1.0E-6) {
                    System.err.println("ERROR: newEdgeValue = " + newEdgeValue + " <0 ");
                    return;
                }
                if (newEdgeValue < 0.0) {
                    this.message.printWarning(1, " newEdgeValue  -1e-6 < " + newEdgeValue + " <0, continuing");
                }
                if (!((dH = this.deltaEdgeHamiltonian(i, j, newEdgeValue)) < 0.0) && !(rnd.nextDouble() < Math.exp(-this.Hamiltonian.beta * dH))) continue;
                this.edgeSet.setEdgeValueBounded(i, j, newEdgeValue);
                ++updateMade;
            }
        }
        this.edgeUR.update(updateTried, updateMade);
    }

    public void vertexSweep() {
        int updateTried = 0;
        int updateMade = 0;
        Permutation sitePerm = new Permutation(this.numberSites);
        int ip = 0;
        if (this.vertexMode.maxValueModeOn) {
            for (ip = 0; ip < this.numberSites; ++ip) {
                if (!this.vertexUpdate(sitePerm.next())) continue;
                ++updateMade;
            }
        }
        if (this.vertexMode.constantWeightOn) {
            for (ip = 0; ip < this.numberSites; ++ip) {
                if (!this.vertexPairUpdate(sitePerm.next())) continue;
                ++updateMade;
            }
        }
        this.vertexUR.update(updateTried += ip, updateMade);
    }

    public boolean vertexUpdate(int i) {
        double newVertexValue = rnd.nextDouble() * this.vertexMode.maximumValue;
        double dH = this.deltaVertexHamiltonian(i, newVertexValue);
        if (dH < 0.0 || rnd.nextDouble() < Math.exp(-this.Hamiltonian.beta * dH)) {
            this.siteSet.setValue(i, newVertexValue);
            return true;
        }
        return false;
    }

    public boolean vertexPairUpdate(int i) {
        double dH;
        double w;
        double dw;
        int i2 = rnd.nextInt(this.numberSites - 1);
        if (i2 >= i) {
            ++i2;
        }
        if ((dw = (w = this.siteSet.getWeight(i)) / 10.0) < 0.001) {
            dw = 0.001;
        }
        if ((dw *= (double)(1 + rnd.nextInt(10))) > w) {
            dw = w;
        }
        if ((dH = this.deltaVertexHamiltonian(i, i2, dw)) > 1.0E20) {
            return false;
        }
        if (dH < 0.0 || rnd.nextDouble() < Math.exp(-this.Hamiltonian.beta * dH)) {
            this.siteSet.setValue(i, (w - dw) / this.siteSet.getSize(i));
            this.siteSet.setValue(i2, (this.siteSet.getWeight(i2) + dw) / this.siteSet.getSize(i2));
            return true;
        }
        return false;
    }

    public void doDP() {
        this.siteSet.setValues(1.0);
        this.siteSet.setWeights();
        this.Hamiltonian.lambda = 1.0;
        this.edgeSet.edgeMode.setMaxValueModeOn(this.numberSites);
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        double ev = -1.0;
        double[] str = new double[this.numberSites];
        double maxstr = -9.87654321;
        for (int i = 0; i < this.numberSites; ++i) {
            str[i] = 0.0;
            for (int j = 0; j < this.numberSites; ++j) {
                ev = i == j ? 0.0 : 1.0 / (1.0 + this.edgeSet.getEdgeDistance(i, j) / this.Hamiltonian.distanceScale);
                int n = i;
                str[n] = str[n] + ev;
                this.edgeSet.setEdgeValueBounded(i, j, ev);
            }
            if (!(maxstr < str[i])) continue;
            maxstr = str[i];
        }
        this.calcNetworkStats();
        this.siteSet.setAllDisplaySizes(this.DisplayVertexType.getValueIndex(), this.DisplayMaxVertexScale);
        if (this.message.getInformationLevel() >= 1) {
            this.printNetworkStatistics(COMMENT, 3);
        }
    }

    public void doVP() {
        this.siteSet.setValues(1.0);
        this.siteSet.setWeights();
        this.Hamiltonian.lambda = 1.0;
        this.edgeSet.edgeMode.setMaxValueModeOn(this.numberSites);
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        double ev = -1.0;
        double[] str = new double[this.numberSites];
        double maxstr = -9.87654321;
        for (int i = 0; i < this.numberSites; ++i) {
            str[i] = 0.0;
            for (int j = 0; j < this.numberSites; ++j) {
                ev = i == j ? 0.0 : this.Hamiltonian.edgePotential1Bare(this.edgeSet.getEdgeDistance(i, j));
                int n = i;
                str[n] = str[n] + ev;
                this.edgeSet.setEdgeValueNoBounds(i, j, ev);
            }
            if (!(maxstr < str[i])) continue;
            maxstr = str[i];
        }
        this.calcNetworkStats();
        this.siteSet.setAllDisplaySizes(this.DisplayVertexType.getValueIndex(), this.DisplayMaxVertexScale);
        if (this.message.getInformationLevel() >= 1) {
            this.printNetworkStatistics(COMMENT, 3);
        }
    }

    public void doPPAOld() {
        int j;
        int i;
        int numEdgesPerSite = (int)(this.betaInitial + 0.5);
        if (numEdgesPerSite < 0) {
            numEdgesPerSite = 3;
        }
        if (numEdgesPerSite >= this.numberSites) {
            numEdgesPerSite = this.numberSites - 1;
        }
        int[] edgeOrder = new int[this.numberSites + 1];
        double[][] darr = new double[this.numberSites][this.numberSites];
        if (this.modelNumber.major == 3) {
            this.edgeSet.doDijkstra(this.siteSet.getSiteArray(), this.Hamiltonian.shortDistanceScale);
        }
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        this.siteSet.initialiseSet(1.0, 1.0, 1.0);
        for (i = 0; i < this.numberSites; ++i) {
            for (j = 0; j < this.numberSites; ++j) {
                this.edgeSet.setEdgeValueBounded(i, j, 1.0);
                darr[i][j] = this.modelNumber.major == 3 ? this.edgeSet.getEdgeSeparation(i, j) : this.edgeSet.getEdgeDistance(i, j);
            }
        }
        double dnc = PajekColours.numberColours;
        for (i = 0; i < this.numberSites; ++i) {
            int k;
            int ef = 0;
            for (j = 0; j < this.numberSites; ++j) {
                this.edgeSet.setEdgeValueBounded(i, j, 0.0);
                if (i == j) continue;
                for (k = 0; k < ef && !(darr[i][j] < darr[i][edgeOrder[k]]); ++k) {
                }
                for (int l = ef; l > k; --l) {
                    edgeOrder[l] = edgeOrder[l - 1];
                }
                edgeOrder[k] = j;
                ++ef;
            }
            double newvalue = 0.0;
            double newcolour = 0.0;
            for (k = 0; k < numEdgesPerSite; ++k) {
                int ec = PajekColours.numberColours - k;
                newcolour = ec > 0 ? (double)ec : 1.0;
                this.edgeSet.setEdgeColour(i, edgeOrder[k], newcolour);
                newvalue = k < PajekColours.numberColours ? (double)ec / dnc : 1.0 / dnc;
                this.edgeSet.setEdgeValueBounded(i, edgeOrder[k], newvalue);
            }
        }
        int[] inDegree = new int[this.numberSites];
        int maxInDegree = 0;
        for (i = 0; i < this.numberSites; ++i) {
            int ind;
            inDegree[i] = ind = this.edgeSet.getInDegree(i);
            if (ind <= maxInDegree) continue;
            maxInDegree = ind;
        }
        for (i = 0; i < this.numberSites; ++i) {
            int ind = inDegree[i];
            int vc = (int)(0.5 + dnc * (double)ind / (double)maxInDegree);
            this.siteSet.setValue(i, (double)ind / (double)maxInDegree);
        }
        this.calcNetworkStats();
        this.siteSet.setAllDisplaySizes(this.DisplayVertexType.getValueIndex(), this.DisplayMaxVertexScale);
        if (this.message.getInformationLevel() >= 0) {
            this.printNetworkStatistics(COMMENT, 3);
        }
    }

    public void doPPA() {
        this.siteSet.setValues(1.0);
        this.siteSet.setWeights();
        this.Hamiltonian.lambda = 1.0;
        double[] darr = new double[this.numberSites];
        if (this.modelNumber.major == 3) {
            this.edgeSet.doDijkstra(this.siteSet.getSiteArray(), this.Hamiltonian.shortDistanceScale);
        }
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        this.siteSet.initialiseSet(1.0, 1.0, 1.0);
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                this.edgeSet.setEdgeValueBounded(i, j, 1.0);
            }
        }
        for (int s = 0; s < this.numberSites; ++s) {
            for (int t = 0; t < this.numberSites; ++t) {
                darr[t] = s == t ? 1.2345678E99 : this.edgeSet.getEdgeDistance(s, t);
            }
            TimSort ts = new TimSort(darr);
            this.edgeSet.setEdgeValueBounded(s, s, 0.0);
            for (int r = 0; r < this.numberSites; ++r) {
                int t = ts.getIndex(r);
                if (t == s) continue;
                double v = 1.0 - (double)r / (double)this.numberSites;
                this.edgeSet.setEdgeValueNoBounds(s, t, v);
            }
        }
        this.siteSet.setWeights();
        this.calcNetworkStats();
        this.siteSet.setAllDisplaySizes(this.DisplayVertexType.getValueIndex(), this.DisplayMaxVertexScale);
        if (this.message.getInformationLevel() >= 0) {
            this.printNetworkStatistics(COMMENT, 3);
        }
    }

    public void doSimpleGM() {
        this.siteSet.setValues(1.0);
        this.siteSet.setWeights();
        this.Hamiltonian.lambda = 1.0;
        this.edgeSet.edgeMode.setMaxValueModeOn(this.numberSites);
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        double ev = -1.0;
        double[] str = new double[this.numberSites];
        double maxstr = -9.87654321;
        for (int i = 0; i < this.numberSites; ++i) {
            str[i] = 0.0;
            for (int j = 0; j < this.numberSites; ++j) {
                ev = i == j ? 0.0 : this.siteSet.getSize(j) * this.Hamiltonian.edgePotential1Bare(this.edgeSet.getEdgeDistance(i, j));
                int n = i;
                str[n] = str[n] + ev;
                this.edgeSet.setEdgeValueNoBounds(i, j, ev);
            }
            if (!(maxstr < str[i])) continue;
            maxstr = str[i];
        }
        this.calcNetworkStats();
        this.siteSet.setAllDisplaySizes(this.DisplayVertexType.getValueIndex(), this.DisplayMaxVertexScale);
        if (this.message.getInformationLevel() >= 1) {
            this.printNetworkStatistics(COMMENT, 3);
        }
    }

    public void doGMOLD() {
        this.siteSet.setValuesRandom(rnd, 1.0);
        this.siteSet.setInValuesRandom(rnd, 1.0);
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        double maxValue = 1.0E10;
        double maxInverseValue = 1.0E-10;
        int CMAX = 1000;
        boolean messagesOn = this.message.testInformationLevel(0);
        double finalFraction = 0.999999;
        TimCounting tc = new TimCounting(1000, messagesOn);
        double inputCos = 1.0;
        double outputCos = 1.0;
        this.message.println(-1, "\n--- Starting Gravity model");
        while (!tc.isFinished()) {
            double d = 0.0;
            double oldL = 0.0;
            double newL = 0.0;
            double newValue = 1.0E10;
            for (int s = 0; s < this.numberSites; ++s) {
                double output = 0.0;
                for (int t = 0; t < this.numberSites; ++t) {
                    if (s == t) continue;
                    output += this.siteSet.getInSize(t) * this.siteSet.getInValue(t) * this.edgeSet.getEdgePotential1(s, t);
                }
                newValue = output > 1.0E-10 ? 1.0 / output : 1.0E10;
                d += newValue * this.siteSet.getValue(s);
                oldL += this.siteSet.getValue(s) * this.siteSet.getValue(s);
                newL += newValue * newValue;
                this.siteSet.setValue(s, newValue);
            }
            outputCos = 1.0;
            if (oldL > 1.0E-6 && newL > 1.0E-6) {
                outputCos = d / (Math.sqrt(oldL) * Math.sqrt(newL));
            }
            d = 0.0;
            newL = 0.0;
            oldL = 0.0;
            double newInValue = 1.0E10;
            for (int t = 0; t < this.numberSites; ++t) {
                double input = 0.0;
                for (int s = 0; s < this.numberSites; ++s) {
                    if (s == t) continue;
                    input += this.siteSet.getValue(s) * this.siteSet.getSize(s) * this.edgeSet.getEdgePotential1(s, t);
                }
                newInValue = input > 1.0E-10 ? 1.0 / input : 1.0E10;
                d += newInValue * this.siteSet.getInValue(t);
                oldL += this.siteSet.getInValue(t) * this.siteSet.getInValue(t);
                newL += newInValue * newInValue;
                this.siteSet.setInValue(t, newInValue);
            }
            inputCos = 1.0;
            if (oldL > 1.0E-6 && newL > 1.0E-6) {
                inputCos = d / (Math.sqrt(oldL) * Math.sqrt(newL));
            }
            if (outputCos > 0.999999 && inputCos > 0.999999) break;
            System.out.println(tc.getCount() + ": " + String.format("%12.6g", outputCos) + " " + String.format("%12.6g", inputCos));
            this.message.println(-1, "initial cosines " + String.format("%12.6g", outputCos) + " " + String.format("%12.6g", inputCos));
            if (messagesOn && tc.isEndOfLine()) {
                System.out.println(": " + String.format("%12.6g", outputCos) + " " + String.format("%12.6g", inputCos));
            }
            tc.increment();
        }
        this.message.println(-1, "\n Finished Gravity model using " + tc.getCount() + " iterations, cosines " + String.format("%12.6g", outputCos) + " " + String.format("%12.6g", inputCos));
        for (int s = 0; s < this.numberSites; ++s) {
            for (int t = 0; t < this.numberSites; ++t) {
                if (s == t) {
                    this.edgeSet.setEdgeValueNoBounds(s, t, 0.0);
                    continue;
                }
                double ev = this.siteSet.getInValue(t) * this.siteSet.getInSize(t) * this.edgeSet.getEdgePotential1(s, t);
                this.edgeSet.setEdgeValueNoBounds(s, t, ev);
            }
        }
        this.setOutputFileName();
        this.siteSet.setWeights();
        this.calcNetworkStats();
    }

    public void doGM() {
        this.doGM(1000, false);
    }

    public void doGM(int maxIterations, boolean initialInValuesRandom) {
        int s;
        this.siteSet.setValues(1.0);
        this.siteSet.setWeights();
        this.Hamiltonian.lambda = 1.0;
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        double maxValue = 1.0E10;
        double maxInverseValue = 1.0E-10;
        int CMAX = maxIterations;
        boolean messagesOn = this.message.testInformationLevel(1);
        double finalFraction = 1.0E-6;
        TimCounting tc = new TimCounting(CMAX, messagesOn);
        double aconv = 1.0;
        double bconv = 1.0;
        double newL = 0.0;
        double newA = 1.0E10;
        double newB = 1.0E10;
        double[] avec = new double[this.numberSites];
        double[] bvec = new double[this.numberSites];
        for (s = 0; s < this.numberSites; ++s) {
            bvec[s] = (initialInValuesRandom ? rnd.nextDouble() : 1.0) * this.siteSet.getSize(s);
        }
        this.message.println(-1, "\n--- Starting Gravity model");
        while (!tc.isFinished()) {
            aconv = 0.0;
            newL = 0.0;
            newA = 1.0E10;
            for (s = 0; s < this.numberSites; ++s) {
                double output = 0.0;
                for (int t = 0; t < this.numberSites; ++t) {
                    if (s == t) continue;
                    output += this.siteSet.getSize(t) * bvec[t] * this.edgeSet.getEdgePotential1(s, t);
                }
                newA = output > 1.0E-10 ? 1.0 / output : 1.0E10;
                aconv += Math.abs(newA - avec[s]);
                newL += Math.abs(newA);
                avec[s] = newA;
            }
            if (newL > 1.0E-6) {
                aconv /= newL;
            }
            bconv = 0.0;
            newL = 0.0;
            newB = 1.0E10;
            for (int t = 0; t < this.numberSites; ++t) {
                double input = 0.0;
                for (int s2 = 0; s2 < this.numberSites; ++s2) {
                    if (s2 == t) continue;
                    input += this.siteSet.getSize(s2) * avec[s2] * this.edgeSet.getEdgePotential1(s2, t);
                }
                newB = input > 1.0E-10 ? 1.0 / input : 1.0E10;
                bconv += Math.abs(newB - bvec[t]);
                newL += Math.abs(newB);
                bvec[t] = newB;
            }
            if (newL > 1.0E-6) {
                bconv /= newL;
            }
            if (messagesOn && tc.isEndOfLine()) {
                System.out.println(": " + String.format("%12.6g", aconv) + " " + String.format("%12.6g", bconv));
            }
            if (aconv < 1.0E-6 && bconv < 1.0E-6) break;
            tc.increment();
        }
        this.message.println(-1, "\n Finished Gravity model using " + tc.getCount() + " iterations, convergence factors " + String.format("%12.6g", aconv) + " " + String.format("%12.6g", bconv));
        for (s = 0; s < this.numberSites; ++s) {
            for (int t = 0; t < this.numberSites; ++t) {
                if (s == t) {
                    this.edgeSet.setEdgeValueNoBounds(s, t, 0.0);
                    continue;
                }
                double ev = avec[s] * bvec[t] * this.siteSet.getSize(t) * this.edgeSet.getEdgePotential1(s, t);
                this.edgeSet.setEdgeValueNoBounds(s, t, ev);
            }
        }
        this.setOutputFileName();
        this.calcNetworkStats();
    }

    public void doRW() {
        this.doRW(1000, false);
    }

    public void doRW(int maxIterations, boolean initialInValuesRandom) {
        int s;
        this.Hamiltonian.lambda = 1.0;
        this.Hamiltonian.beta = this.betaInitial;
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        double maxValue = 9.8765432E10;
        double maxInverseValue = 1.0125000010125E-11;
        int CMAX = maxIterations;
        boolean messagesOn = this.message.testInformationLevel(2);
        double finalFraction = 1.0E-6;
        TimCounting tc = new TimCounting(CMAX, messagesOn);
        double wconv = 1.0;
        double aconv = 1.0;
        this.message.println(-1, "\n--- Starting RW Gravity model with " + (initialInValuesRandom ? "random" : "fixed") + " initial in flow and max iterations " + maxIterations + ", beta = " + this.betaInitial);
        double newL = 0.0;
        double newA = 9.8765432E10;
        double newW = 9.8765432E10;
        double[] avec = new double[this.numberSites];
        double[] wvec = new double[this.numberSites];
        for (s = 0; s < this.numberSites; ++s) {
            wvec[s] = (initialInValuesRandom ? rnd.nextDouble() : 1.0) * this.siteSet.getSize(s);
        }
        System.out.println();
        while (!tc.isFinished()) {
            aconv = 0.0;
            newL = 0.0;
            newA = 9.8765432E10;
            for (s = 0; s < this.numberSites; ++s) {
                double input = 0.0;
                for (int t = 0; t < this.numberSites; ++t) {
                    if (s == t) continue;
                    input += Math.pow(wvec[t], this.Hamiltonian.beta) * this.edgeSet.getEdgePotential1(s, t);
                }
                newA = input > 1.0125000010125E-11 ? 1.0 / input : 9.8765432E10;
                aconv += Math.abs(newA - avec[s]);
                newL += Math.abs(newA);
                avec[s] = newA;
            }
            if (newL > 1.0E-6) {
                aconv /= newL;
            }
            wconv = 0.0;
            newL = 0.0;
            newW = 9.8765432E10;
            for (int t = 0; t < this.numberSites; ++t) {
                double output = 0.0;
                for (int s2 = 0; s2 < this.numberSites; ++s2) {
                    if (s2 == t) continue;
                    output += this.siteSet.getSize(s2) * avec[s2] * this.edgeSet.getEdgePotential1(s2, t);
                }
                newW = Math.pow(wvec[t], this.Hamiltonian.beta) * output;
                wconv += Math.abs(newW - wvec[t]);
                newL += Math.abs(newW);
                wvec[t] = newW;
            }
            if (newL > 1.0E-6) {
                wconv /= newL;
            }
            if (tc.isEndOfLine()) {
                this.message.println(-1, tc.getCount() + ": " + String.format("%12.6g", aconv) + " " + String.format("%12.6g", wconv));
            }
            if (messagesOn && tc.isEndOfLine()) {
                System.out.println(": " + String.format("%12.6g", aconv) + " " + String.format("%12.6g", wconv));
            }
            if (wconv < 1.0E-6 && aconv < 1.0E-6) break;
            tc.increment();
        }
        this.message.println(-1, "\n Finished Rihll-Wilson Gravity model using " + tc.getCount() + " iterations, convergence factors " + String.format("%6.3g", aconv) + " " + String.format("%6.3g", wconv));
        this.siteSet.setValues(1.0);
        for (s = 0; s < this.numberSites; ++s) {
            for (int t = 0; t < this.numberSites; ++t) {
                if (s == t) {
                    this.edgeSet.setEdgeValueNoBounds(s, t, 0.0);
                    continue;
                }
                double ev = avec[s] * Math.pow(wvec[t], this.Hamiltonian.beta) * this.edgeSet.getEdgePotential1(s, t);
                this.edgeSet.setEdgeValueNoBounds(s, t, ev);
            }
        }
        this.setOutputFileName();
        this.siteSet.setWeights();
        this.calcNetworkStats();
    }

    public void doMC() {
        double beta;
        int i;
        MonteCarloHistory mch = new MonteCarloHistory(1000);
        int dotInterval = 10;
        boolean energyTest = false;
        int eqtest = 0;
        double betamin = this.betaInitial;
        double betamax = 1.0E20;
        double betafactor = 2.0;
        int betainc = -1;
        if (this.monteCarloStartMode.isMode("Cold")) {
            double v = 0.0;
            if (!this.vertexMode.maxValueModeOn) {
                double St = 0.0;
                for (int i2 = 0; i2 < this.numberSites; ++i2) {
                    St += this.siteSet.getSize(i2);
                }
                v = this.vertexMode.totalWeight / St;
            }
            for (int i3 = 0; i3 < this.numberSites; ++i3) {
                this.siteSet.setValue(i3, v);
            }
            this.edgeSet.setEdgeValues(0.0);
        }
        if (this.monteCarloStartMode.isMode("Hot")) {
            if (this.vertexMode.maxValueModeOn) {
                for (int i4 = 0; i4 < this.numberSites; ++i4) {
                    this.siteSet.setValue(i4, rnd.nextDouble() * this.vertexMode.maximumValue);
                }
            } else {
                for (int i5 = 0; i5 < this.numberSites; ++i5) {
                    this.siteSet.setValue(i5, this.vertexMode.totalWeight / (double)this.numberSites);
                }
                Permutation perm = new Permutation(this.numberSites);
                for (i = 0; i < this.numberSites; ++i) {
                    int s = perm.next();
                    int t = rnd.nextInt(this.numberSites - 1);
                    if (t >= s) {
                        ++t;
                    }
                    double dw = this.siteSet.getWeight(s) * rnd.nextDouble();
                    double vt = this.siteSet.getValue(t) + dw / this.siteSet.getSize(t);
                    if (!this.vertexMode.testValue(vt)) continue;
                    this.siteSet.setValue(t, vt);
                    this.siteSet.setValue(s, dw / this.siteSet.getSize(s));
                }
            }
            this.edgeSet.setRandomEdgeValues(rnd);
        }
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        this.siteSet.calcBasicStatistics(this.edgeSet);
        double sinav = this.siteSet.siteStrengthInStats.getAverage();
        double soutav = this.siteSet.siteStrengthOutStats.getAverage();
        this.message.println(0, "Average Strength IN/OUT " + sinav + "  " + soutav);
        long initialtime = System.currentTimeMillis();
        if (this.modelNumber.major == 3) {
            this.edgeSet.doDijkstra(this.siteSet.getSiteArray(), this.Hamiltonian.shortDistanceScale);
        }
        StatisticalQuantity enewsq = new StatisticalQuantity();
        StatisticalQuantity elastsq = null;
        eqtest = 0;
        for (beta = betamin; beta <= betamax; beta *= betafactor) {
            this.Hamiltonian.beta = beta;
            this.vertexUR.reset();
            this.edgeUR.reset();
            for (int s = 0; s < this.MCsweeps; ++s) {
                if (this.vertexUR.getFractionMade() < 0.9) {
                    this.vertexSweep();
                }
                if (this.edgeUR.getFractionMade() < 0.9) {
                    this.edgeSweep();
                }
                if (!energyTest) continue;
                this.calcEnergy();
                enewsq.add(this.globalProperties.getEnergy());
            }
            if (energyTest && elastsq != null) {
                eqtest = Math.abs(enewsq.getAverage() - elastsq.getAverage()) < Math.abs(enewsq.getError()) + Math.abs(elastsq.getError()) ? ++eqtest : 0;
            }
            if (this.MChistory) {
                this.calcEnergy();
                mch.add(beta, this.globalProperties.getEnergy(), this.vertexUR.getMade(), this.edgeUR.getMade());
            }
            if (this.message.testInformationLevel(0)) {
                if (++betainc % 10 == 0) {
                    this.calcEnergy();
                    islandNetwork.printEllapsedTime(initialtime);
                    System.out.println(" beta=" + beta + ", energy=" + this.globalProperties.getEnergy() + ",  stable for last " + eqtest + " runs. \n  E: " + this.edgeUR.toString() + "\n  V: " + this.vertexUR.toString());
                } else if (this.vertexUR.getFractionMade() > 0.9) {
                    System.out.print(STARTSECTION);
                } else if (this.edgeUR.getFractionMade() > 0.9) {
                    System.out.print(":");
                } else {
                    System.out.print(".");
                }
            }
            if (this.vertexUR.getTotalFractionMade() < 0.01 && this.edgeUR.getTotalFractionMade() < 0.01) break;
            if (!energyTest) continue;
            elastsq = new StatisticalQuantity(enewsq);
            enewsq = new StatisticalQuantity();
        }
        this.calcEnergy();
        String s = "Final beta " + beta + ", energy=" + this.globalProperties.getEnergy();
        if (energyTest) {
            s = s + ",  stable for last " + eqtest + " runs.";
        }
        this.message.println(-1, "\n " + s + "\n Edge stats: " + this.edgeUR.toString() + ". Vertex stats: " + this.vertexUR.toString());
        this.setOutputFileName();
        if (this.MChistory) {
            mch.FileOutputMonteCarloHistory(this.outputFile.getFullLocationFileName("_MChistory", "dat"));
        }
        this.siteSet.setWeights();
        this.message.println(-1, "... end of doMC() just before calcNetworkStats");
        this.calcNetworkStats();
        this.message.println(-1, "*** end of doMC() after calcNetworkStats *************************************************************************");
        for (i = 0; i < this.numberSites; ++i) {
            if (!this.testEnergyVertex()) {
                System.err.println("*** ERROR failed vertex test " + i);
            }
            if (this.testEnergyEdge()) continue;
            System.err.println("*** ERROR failed Edge test " + i);
        }
    }

    public void setEdgePotentials() {
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
    }

    public boolean testVertexValues() {
        for (int s = 0; s < this.numberSites; ++s) {
            if (this.vertexMode.testValue(this.siteSet.getValue(s))) continue;
            return false;
        }
        return true;
    }

    public boolean testVertexWeights() {
        for (int s = 0; s < this.numberSites; ++s) {
            double sw;
            double sv;
            double ss = this.siteSet.getSize(s);
            if (!(Math.abs(ss * (sv = this.siteSet.getValue(s)) - (sw = this.siteSet.getWeight(s))) > 1.0E-10)) continue;
            return false;
        }
        return true;
    }

    public boolean testEnergyVertex() {
        if (this.vertexMode.maxValueModeOn) {
            return this.testEnergyVertexSingle();
        }
        return this.testEnergyVertexPair();
    }

    public boolean testEnergyVertexSingle() {
        int i = rnd.nextInt(this.numberSites);
        double newv = rnd.nextDouble() * this.siteSet.siteWeightStats.maximum;
        double oldv = this.siteSet.getValue(i);
        this.calcEnergy();
        double oldEnergy = this.globalProperties.getEnergy();
        double dH = this.deltaVertexHamiltonian(i, newv);
        this.siteSet.setValue(i, newv);
        this.calcEnergy();
        double newEnergy = this.globalProperties.getEnergy();
        this.siteSet.setValue(i, oldv);
        if (Math.abs(newEnergy - oldEnergy - dH) > 1.0E-6) {
            System.err.println("*** ERROR testEnergyVertex(), complete dH=" + (newEnergy - oldEnergy) + ", direct dH=" + dH);
            return false;
        }
        return true;
    }

    public boolean testEnergyVertexPair() {
        int i = rnd.nextInt(this.numberSites);
        double oldv = this.siteSet.getValue(i);
        double newv = rnd.nextDouble() * oldv;
        double dw = (oldv - newv) * this.siteSet.getSize(i);
        int i2 = rnd.nextInt(this.numberSites - 1);
        if (i2 >= i) {
            ++i2;
        }
        double oldv2 = this.siteSet.getValue(i2);
        double newv2 = oldv2 + dw / this.siteSet.getSize(i2);
        this.calcEnergy();
        double oldEnergy = this.globalProperties.getEnergy();
        double dH = this.deltaVertexHamiltonian(i, i2, dw);
        this.siteSet.setValue(i, newv);
        this.siteSet.setValue(i2, newv2);
        this.calcEnergy();
        double newEnergy = this.globalProperties.getEnergy();
        this.siteSet.setValue(i, oldv);
        this.siteSet.setValue(i2, oldv2);
        if (Math.abs(newEnergy - oldEnergy - dH) > 1.0E-6) {
            System.err.println("*** ERROR testEnergyVertexPair(), complete dH=" + (newEnergy - oldEnergy) + ", direct dH=" + dH);
            return false;
        }
        return true;
    }

    public boolean testEnergyEdge() {
        int s = rnd.nextInt(this.numberSites);
        int t = rnd.nextInt(this.numberSites - 1);
        if (t >= s) {
            ++t;
        }
        double strErrLimit = this.edgeSet.edgeMode.maximumValue * 1.01;
        double oldEdgeValue = this.edgeSet.getEdgeValue(s, t);
        double newEdgeValue = -1.0;
        if (this.edgeSet.edgeMode.outStrengthLimitOn) {
            double otherOutStrength = this.edgeSet.getOutEdgeStrength(s) - this.edgeSet.getEdgeValue(s, t);
            if (otherOutStrength + (newEdgeValue = (this.edgeSet.edgeMode.maximumValue - otherOutStrength) * rnd.nextDouble()) > strErrLimit) {
                System.out.println(otherOutStrength + newEdgeValue + " = newOutStrength >1 ");
                return false;
            }
        } else if (this.edgeSet.edgeMode.maxValueModeOn) {
            newEdgeValue = rnd.nextDouble() * this.edgeSet.edgeMode.maximumValue;
        } else {
            double d = newEdgeValue = rnd.nextBoolean() ? 1.0 : 0.0;
        }
        if (newEdgeValue < 0.0) {
            System.out.println(newEdgeValue + " = newEdgeValue <0 ");
            return false;
        }
        this.calcEnergy();
        double oldEnergy = this.globalProperties.getEnergy();
        double dH = this.deltaEdgeHamiltonian(s, t, newEdgeValue);
        this.edgeSet.setEdgeValueBounded(s, t, newEdgeValue);
        this.calcEnergy();
        double newEnergy = this.globalProperties.getEnergy();
        this.edgeSet.setEdgeValueBounded(s, t, oldEdgeValue);
        if (Math.abs(newEnergy - oldEnergy - dH) > 1.0E-6) {
            System.err.println("*** ERROR testEnergyEdge(), complete dH=" + (newEnergy - oldEnergy) + ", direct dH=" + dH);
            return false;
        }
        return true;
    }

    public int getNumberSites() {
        return this.numberSites;
    }

    public String getMinorModelString() {
        String s = "unknown";
        switch (this.modelNumber.minor & 3) {
            case 0: {
                s = "no site terms in trade term";
                break;
            }
            case 1: {
                s = "Supply Side (source site in trade term)";
                break;
            }
            case 2: {
                s = "Demand Side (target site in trade term)";
                break;
            }
            case 3: {
                s = "Gravity (source and target site in trade term)";
            }
        }
        if (this.modelNumber.major == 3) {
            switch (this.modelNumber.minor & 4) {
                case 0: {
                    s = s + "physical distance used in potential";
                    break;
                }
                case 4: {
                    s = s + "edge potential used in potential";
                }
            }
        }
        return s;
    }

    public int getOutDegree(int i) {
        int d = 0;
        for (int j = 0; j < this.numberSites; ++j) {
            if (!(this.edgeSet.getEdgeValue(i, j) > 0.0)) continue;
            ++d;
        }
        return d;
    }

    public void setEdgesTest1() {
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                if (i == j) continue;
                if (i == j + 1) {
                    this.edgeSet.setEdgeValueBounded(i, j, 1.0);
                    continue;
                }
                this.edgeSet.setEdgeValueBounded(i, j, 0.0);
            }
        }
    }

    public void calcVectorOrder(double[] valueVector, int[] orderVector) {
        int i;
        int n = valueVector.length;
        for (i = 0; i < n; ++i) {
            orderVector[i] = i;
        }
        for (i = 0; i < n; ++i) {
            double best = valueVector[orderVector[i]];
            for (int j = i + 1; j < n; ++j) {
                double newbest = valueVector[orderVector[j]];
                if (!(best < newbest)) continue;
                best = newbest;
                int temp = orderVector[j];
                orderVector[j] = orderVector[i];
                orderVector[i] = temp;
            }
        }
    }

    public void calcVectorRankOrder(double[] valueVector, int[] orderVector, int[] rankVector) {
        this.calcVectorOrder(valueVector, orderVector);
        for (int i = 0; i < valueVector.length; ++i) {
            rankVector[orderVector[i]] = i;
        }
    }

    public void calcSiteOrder(int valueNumber, int[] orderVector, int n) {
    }

    public void calcSiteRankOrder(int valueNumber, int[] orderVector, int rankNumber) {
    }

    public int getInformationLevel() {
        return this.message.getInformationLevel();
    }

    public void setInfomationLevel(int i) {
        this.message.setInformationLevel(i);
    }

    public double TruncDec(double value, int dec) {
        double shift = Math.pow(10.0, dec);
        return (double)((int)(value * shift + 0.5)) / shift;
    }

    public String TruncDecString(double value, int dec) {
        double shift = Math.pow(10.0, dec);
        Double d = (double)((int)(value * shift + 0.5)) / shift;
        return d.toString();
    }

    public String getStartString(String s, int numberCharacters) {
        if (s.length() < numberCharacters) {
            return s;
        }
        return s.substring(0, numberCharacters);
    }

    public String getPaddedStartString(String s, int numberCharacters) {
        String sss = "";
        for (int i = 0; i < numberCharacters; ++i) {
            sss = i < s.length() ? sss + s.substring(i, i + 1) : sss + " ";
        }
        return sss;
    }

    public double euclideanDistance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    private double sphericalDistance(double lat1, double lon1, double lat2, double lon2) {
        double theta = lon1 - lon2;
        double dist = Math.sin(this.deg2rad(lat1)) * Math.sin(this.deg2rad(lat2)) + Math.cos(this.deg2rad(lat1)) * Math.cos(this.deg2rad(lat2)) * Math.cos(this.deg2rad(theta));
        dist = Math.acos(dist);
        dist = this.rad2deg(dist);
        dist = dist * 60.0 * 1.1515;
        return dist *= 1.609344;
    }

    private double deg2rad(double deg) {
        return deg * Math.PI / 180.0;
    }

    private double rad2deg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    public static void printEllapsedTime(long initialtime) {
        long finaltime = System.currentTimeMillis();
        long time = finaltime - initialtime;
        long ms = time % 1000L;
        long sec = (time /= 1000L) % 60L;
        long minutes = (time /= 60L) % 60L;
        long hours = (time /= 60L) % 24L;
        long days = time / 24L;
        if (days > 0L) {
            System.out.print(days + " day");
        }
        if (days > 1L) {
            System.out.print("s ");
        }
        if (hours > 0L) {
            System.out.print(hours + " hour");
        }
        if (hours > 1L) {
            System.out.print("s ");
        }
        if (minutes > 0L) {
            System.out.print(minutes + " minute");
        }
        if (minutes > 1L) {
            System.out.print("s ");
        }
        System.out.print(sec + " sec");
        if (sec > 1L) {
            System.out.print("s ");
        }
        System.out.println();
    }

    public class OnlyExtensionSet
    implements FilenameFilter {
        String ext;

        public OnlyExtensionSet(String ext) {
            this.ext = ext;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext);
        }
    }
}

