/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.io;

import java.io.File;
import java.io.PrintStream;

public class FileLocation {
    private File rootDirectory;
    private File fullDirectory;
    private String basicRoot;
    private String parameterName;
    private String ending;
    private String extension;
    private static final int NOSEQNO = -24680;
    public int sequenceNumber = -24680;
    private static final String SEQIND = "_r";

    public FileLocation(String dr, String d, String br, String pn, int seqno, String ending, String ext) {
        this.setAll(dr, d, br, pn, seqno, ending, ext);
    }

    public FileLocation(String dr, String d, String br, String pn, String ending, String ext) {
        this.setAll(dr, d, br, pn, -24680, ending, ext);
    }

    public FileLocation(String dr, String d, String nr) {
        this.setNamesLocations(dr, d, nr);
        this.sequenceNumber = -24680;
    }

    public FileLocation(String s) {
        this.setFileLocationName(s);
    }

    public FileLocation(File f) {
        if (!f.isFile()) {
            System.out.println("*** ERROR " + f.getPath() + " is not a file in FileLocation");
            return;
        }
        this.setFileLocationName(f.getPath());
    }

    public FileLocation(String dr, String d, String nr, int n) {
        this.setNamesLocations(dr, d, nr);
        this.sequenceNumber = n;
    }

    public FileLocation(FileLocation fl) {
        this.rootDirectory = fl.rootDirectory;
        this.fullDirectory = fl.fullDirectory;
        this.basicRoot = fl.basicRoot;
        this.parameterName = fl.parameterName;
        this.sequenceNumber = fl.sequenceNumber;
        this.ending = fl.ending;
        this.extension = fl.extension;
    }

    public String getRootDirectoryPath() {
        return this.rootDirectory.getPath();
    }

    public String getSubDirectoryName() {
        return this.fullDirectory.getName();
    }

    public String getSubDirectoryPath() {
        return this.fullDirectory.getPath();
    }

    public String getFullLocation() {
        return this.fullDirectory.getPath();
    }

    public String getNameRoot() {
        return this.basicRoot + this.getParameterName();
    }

    public String getFullFileRoot() {
        return this.getNameRoot() + this.sequenceString();
    }

    public String getFullFileName() {
        return this.getNameRoot() + this.sequenceString() + this.ending + "." + this.extension;
    }

    public String getFullFileName(String ending, String ext) {
        this.ending = ending;
        this.extension = ext;
        return this.getFullFileName();
    }

    public String getFullLocationFileRoot() {
        return this.fullDirectory.getPath() + File.separator + this.getRootName();
    }

    public String getFullLocationFileRootSN() {
        return this.fullDirectory.getPath() + File.separator + this.getRootName() + this.sequenceString();
    }

    public String getFullLocationFileName() {
        return this.fullDirectory.getPath() + File.separator + this.getFullFileName();
    }

    public String getFullLocationSimpleFileName() {
        return this.fullDirectory.getPath() + File.separator + this.basicRoot + this.ending + "." + this.extension;
    }

    public String getFullLocationSimpleFileName(String ending, String ext) {
        this.ending = ending;
        this.extension = ext;
        return this.getFullLocationSimpleFileName();
    }

    public File getFullLocationFile() {
        return new File(this.getFullLocationFileName());
    }

    public String getFullLocationFileName(String ending, String ext) {
        this.ending = ending;
        this.extension = ext;
        return this.getFullLocationFileName();
    }

    public String getBasicRoot() {
        return this.basicRoot;
    }

    public String getEnding() {
        return this.ending;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getRootName() {
        return this.basicRoot + this.getParameterName();
    }

    public String getRootLocationSimpleFileName(String ending, String ext) {
        this.ending = ending;
        this.extension = ext;
        return this.getRootLocationSimpleFileName();
    }

    public String getRootLocationSimpleFileName() {
        return this.rootDirectory.getPath() + File.separator + this.basicRoot + this.ending + "." + this.extension;
    }

    public String getParameterName() {
        if (this.parameterName.length() > 0) {
            return "_" + this.parameterName;
        }
        return "";
    }

    public boolean mkDirs() {
        return this.fullDirectory.mkdirs();
    }

    public void setNamesLocations(String dr, String d, String nr) {
        this.setRootDirectory(dr);
        this.setSubDirectory(d);
        this.setNameRoot(nr);
    }

    public void setNamesLocations(String dr, String d, String br, String pn) {
        this.setRootDirectory(dr);
        this.setSubDirectory(d);
        this.basicRoot = br;
        this.parameterName = pn;
    }

    public void setAll(String dr, String d, String nr, int seqno, String ending, String ext) {
        this.setNamesLocations(dr, d, nr);
        this.sequenceNumber = seqno;
        this.ending = ending;
        this.extension = ext;
    }

    public void setAll(String dr, String d, String br, String pn, int seqno, String ending, String ext) {
        this.setNamesLocations(dr, d, br, pn);
        this.sequenceNumber = seqno;
        this.ending = ending;
        this.extension = ext;
    }

    public void setRootDirectory(String dr) {
        this.rootDirectory = new File(dr);
    }

    public void setSubDirectory(String d) {
        this.fullDirectory = new File(this.rootDirectory.getPath() + File.separator + d);
    }

    public void setNextExistingSequenceNumber() {
        ++this.sequenceNumber;
        if (!this.isFullFile()) {
            this.sequenceNumber = 0;
        }
    }

    public void setFirstFreeSequenceNumber(int sn) {
        int n = this.sequenceNumber = sn > 0 ? sn : 0;
        while (this.getFullLocationFile().isFile()) {
            ++this.sequenceNumber;
        }
    }

    public void setFirstFreeSequenceNumber() {
        this.sequenceNumber = 0;
        while (this.getFullLocationFile().isFile()) {
            ++this.sequenceNumber;
        }
    }

    public void setNoSequence() {
        this.sequenceNumber = -24680;
    }

    public String sequenceString() {
        if (this.sequenceNumber == -24680) {
            return "";
        }
        return SEQIND + this.sequenceNumber;
    }

    public void setFileLocationName(String s) {
        this.setAll("NOROOTDIR", "NOSUBDIR", "NONAMEROOT", -24680, "NOENDING", "NOEXT");
        try {
            File fullLocationName = new File(s);
            if (fullLocationName.isDirectory()) {
                this.rootDirectory = fullLocationName.getParentFile();
                this.fullDirectory = fullLocationName;
                return;
            }
            String name = fullLocationName.getName();
            this.fullDirectory = fullLocationName.getParentFile();
            this.rootDirectory = this.fullDirectory.getParentFile();
            this.setFileName(name);
        }
        catch (RuntimeException e) {
            System.out.println(e);
        }
    }

    public void setFileLocationName(File fullLocationName) {
        this.setAll("NOROOTDIR", "NOSUBDIR", "NONAMEROOT", -24680, "NOENDING", "NOEXT");
        try {
            if (fullLocationName.isDirectory()) {
                this.rootDirectory = fullLocationName.getParentFile();
                this.fullDirectory = fullLocationName;
                return;
            }
            String name = fullLocationName.getName();
            this.fullDirectory = fullLocationName.getParentFile();
            this.rootDirectory = this.fullDirectory.getParentFile();
            if (fullLocationName.isFile()) {
                this.setFileName(name);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void setFileLocationSimpleName(File fullLocationName) {
        this.setAll("NOROOTDIR", "NOSUBDIR", "NONAMEROOT", -24680, "NOENDING", "NOEXT");
        try {
            if (fullLocationName.isDirectory()) {
                this.rootDirectory = fullLocationName.getParentFile();
                this.fullDirectory = fullLocationName;
                return;
            }
            String name = fullLocationName.getName();
            this.fullDirectory = fullLocationName.getParentFile();
            this.rootDirectory = this.fullDirectory.getParentFile();
            if (fullLocationName.isFile()) {
                this.setSimpleFileName(name);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void setFileName(String name) {
        try {
            int from;
            int dot = name.lastIndexOf(46);
            if (dot < 0) {
                dot = name.length();
            } else {
                this.extension = name.substring(dot + 1);
            }
            int seq = name.indexOf(SEQIND);
            if (seq < 0) {
                this.setNameRoot(name);
                return;
            }
            this.setNameRoot(name.substring(0, seq));
            int to = from = seq + SEQIND.length();
            if (name.charAt(to) == '-') {
                ++to;
            }
            while (name.codePointAt(to) > 47 && name.codePointAt(to) < 58) {
                ++to;
            }
            this.sequenceNumber = Integer.parseInt(name.substring(from, to));
            this.ending = name.substring(to, dot);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void setNameRoot(String name) {
        int u = name.indexOf(95);
        if (u < 0 || u + 1 >= name.length()) {
            this.basicRoot = name;
            this.parameterName = "";
        } else {
            this.basicRoot = name.substring(0, u);
            this.parameterName = name.substring(u + 1);
        }
    }

    public void setSimpleFileName(String s) {
        this.basicRoot = s;
        this.ending = "";
        int u = s.indexOf(95);
        if (u < 0 || u + 1 >= s.length()) {
            return;
        }
        this.basicRoot = s.substring(0, u);
        this.ending = s.substring(u + 1);
    }

    public boolean setParameterName(String s) {
        this.parameterName = s;
        return true;
    }

    public boolean setBasicRoot(String s) {
        if (s.length() > 0 && s.indexOf(95) > -1) {
            return false;
        }
        this.basicRoot = s;
        return true;
    }

    public boolean setEnding(String s) {
        if (s.length() > 1 && s.indexOf(SEQIND) > -1) {
            return false;
        }
        this.ending = s;
        return true;
    }

    public boolean setExtension(String s) {
        if (s.length() > 0 && s.indexOf(46) > -1) {
            return false;
        }
        this.extension = s;
        return true;
    }

    public boolean set(String s) {
        try {
            switch (s.charAt(0)) {
                case 'r': {
                    this.setRootDirectory(s.substring(1));
                    return true;
                }
                case 's': {
                    this.setSubDirectory(s.substring(1));
                    return true;
                }
                case 'b': {
                    return this.setBasicRoot(s.substring(1));
                }
                case 'p': {
                    return this.setParameterName(s.substring(1));
                }
                case 'n': {
                    this.sequenceNumber = Integer.parseInt(s.substring(1));
                    return true;
                }
                case 't': {
                    return this.setEnding(s.substring(1));
                }
                case 'e': {
                    return this.setExtension(s.substring(1));
                }
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public String setString(char i) {
        String s = "";
        switch (i) {
            case 'r': {
                s = "'r' = root directory path";
                break;
            }
            case 's': {
                s = "'s' = sub directory name (relative to root)";
                break;
            }
            case 'b': {
                s = "'b' = basic root of file names (no '_')";
                break;
            }
            case 'p': {
                s = "'p' = parameter string (will have '_' at start added when needed)";
                break;
            }
            case 'n': {
                s = "'n' = sequence or run number (integer)";
                break;
            }
            case 't': {
                s = "'t' = terminating or ending string (no '_r' allowed)";
                break;
            }
            case 'e': {
                s = "'e' = extension (no '.' allowed)";
                break;
            }
            default: {
                s = i + " is unknown";
            }
        }
        return s;
    }

    public void printSetStrings(PrintStream PS, String header) {
        String p = "rsbpnte";
        for (int c = 0; c < p.length(); ++c) {
            PS.println(header + this.setString(p.charAt(c)));
        }
    }

    private int getInt(String s, int from) {
        int res = -888888;
        int to = from;
        if (s.charAt(to) == '-') {
            ++to;
        }
        while (s.codePointAt(to) > 47 && s.codePointAt(to) < 58) {
            ++to;
        }
        try {
            res = Integer.parseInt(s.substring(from, to));
        }
        catch (RuntimeException e) {
            return -9999999;
        }
        return res;
    }

    public boolean isRootLocationDirectory() {
        return this.rootDirectory.isDirectory();
    }

    public boolean isFullLocationDirectory() {
        return this.fullDirectory.isDirectory();
    }

    public boolean isFullFile() {
        return this.getFullLocationFile().isFile();
    }
}

