/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.Vertex;

import TimUtilities.NumbersToString;

public class VertexMode {
    static final double UNSET = -9753.1;
    public boolean maxValueModeOn;
    public boolean constantWeightOn;
    public double totalWeight = -9753.1;
    public double maximumValue = -9753.1;
    static NumbersToString n2s = new NumbersToString(1);

    public VertexMode(double VertexMode2) {
        this.setVertexMode(VertexMode2);
    }

    public VertexMode(VertexMode em) {
        this.maxValueModeOn = em.maxValueModeOn;
        this.constantWeightOn = em.constantWeightOn;
        this.maximumValue = em.maximumValue;
        this.totalWeight = em.maximumValue;
    }

    public void setVertexMode(double VertexMode2) {
        if (VertexMode2 > 0.0) {
            this.setMaxValueModeOn(VertexMode2);
        } else {
            this.setConstantWeightModeOn(VertexMode2);
        }
    }

    public void setMaxValueModeOn(double value) {
        this.maxValueModeOn = true;
        this.constantWeightOn = false;
        this.maximumValue = Math.abs(value);
        this.totalWeight = -9753.1;
    }

    public void setConstantWeightModeOn(double value) {
        this.maxValueModeOn = false;
        this.constantWeightOn = true;
        this.totalWeight = Math.abs(value);
        this.maximumValue = -9753.1;
    }

    public String description() {
        String s = "*** UNKNOWN ***";
        if (this.maxValueModeOn) {
            s = "Maximum Vertex Value ";
        }
        if (this.constantWeightOn) {
            s = "Total Weight Constant ";
        }
        return s;
    }

    public String descriptionValue(String sep) {
        String s = "*** UNKNOWN ***";
        if (this.maxValueModeOn) {
            s = this.description() + sep + this.maximumValue;
        }
        if (this.constantWeightOn) {
            s = this.description() + sep + this.totalWeight;
        }
        return s;
    }

    public String modeString() {
        if (this.maxValueModeOn) {
            return "-xv" + n2s.toString(this.maximumValue);
        }
        if (this.constantWeightOn) {
            return "-xw" + n2s.toString(this.totalWeight);
        }
        return "*** UNKNOWN ***";
    }

    public double getValue() {
        double VertexModeValue = -9753.1;
        if (this.maxValueModeOn) {
            VertexModeValue = this.maximumValue;
        }
        if (this.constantWeightOn) {
            VertexModeValue = this.totalWeight;
        }
        return VertexModeValue;
    }

    public double getModeValue() {
        double VertexModeValue = -9753.1;
        if (this.maxValueModeOn) {
            VertexModeValue = this.maximumValue;
        }
        if (this.constantWeightOn) {
            VertexModeValue = -this.totalWeight;
        }
        return VertexModeValue;
    }

    public boolean testValue(double v) {
        if (this.maxValueModeOn && v > this.maximumValue) {
            return false;
        }
        return !(v < 0.0);
    }
}

