/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.Vertex;

import IslandNetworks.Edge.IslandEdgeSet;
import IslandNetworks.IslandTransferMatrix;
import IslandNetworks.PajekColours;
import IslandNetworks.Vertex.IslandSite;
import TimUtilities.Distances;
import TimUtilities.NumbersToString;
import TimUtilities.StatisticalQuantity;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Random;

public class IslandSiteSet {
    private int numberSites;
    private IslandSite[] siteArray;
    public int[] siteAlphabeticalOrder;
    public int[] siteWeightOrder;
    public StatisticalQuantity siteValueStats;
    public StatisticalQuantity siteWeightStats;
    public StatisticalQuantity siteStrengthOutStats;
    public StatisticalQuantity siteStrengthInStats;
    public int maxSiteValueIndex = -1;
    public int maxSiteWeightIndex = -1;
    public int maxOutSiteStrengthIndex = -1;
    public int maxInSiteStrengthIndex = -1;
    public double minX = -987.0;
    public double maxX = -987.0;
    public double minY = -987.0;
    public double maxY = -987.0;
    public double XYScale = -1.0;
    public double siteSizeNormalisation = -1.0;
    public StatisticalQuantity siteRankStats;
    public StatisticalQuantity siteInfluenceStats;
    static final int[] statisticsList = new int[]{IslandSite.valueIndex, IslandSite.weightIndex, IslandSite.strengthInIndex, IslandSite.strengthOutIndex, IslandSite.rankingIndex, IslandSite.influenceIndex};
    public double siteRankOverWeightMax = -1.0;
    public int[] siteRankOrder;
    public int[] siteRankOverWeightOrder;
    public int[] siteInfluenceOrder;
    int displayIndex = -1;
    NumbersToString n2s = new NumbersToString(3);
    ArrayList<String> geneName;

    public IslandSiteSet(int ns) {
        this.numberSites = ns;
        this.siteArray = new IslandSite[this.numberSites];
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i] = new IslandSite();
        }
        this.initialiseSet(-1.0, -1.0, -1.0);
        this.setMinMaxXY();
        this.geneName = new ArrayList();
        this.siteAlphabeticalOrder = new int[this.numberSites];
        this.siteWeightOrder = new int[this.numberSites];
        this.siteRankOrder = new int[this.numberSites];
        this.siteRankOverWeightOrder = new int[this.numberSites];
        this.siteInfluenceOrder = new int[this.numberSites];
    }

    public IslandSiteSet(IslandSiteSet iniss) {
        int i;
        this.numberSites = iniss.numberSites;
        this.siteArray = new IslandSite[this.numberSites];
        for (i = 0; i < this.numberSites; ++i) {
            this.siteArray[i] = new IslandSite(iniss.siteArray[i]);
        }
        if (iniss.siteAlphabeticalOrder != null) {
            this.siteAlphabeticalOrder = new int[this.numberSites];
            for (i = 0; i < this.numberSites; ++i) {
                this.siteAlphabeticalOrder[i] = iniss.siteAlphabeticalOrder[i];
            }
        }
        if (iniss.siteWeightOrder != null) {
            this.siteWeightOrder = new int[this.numberSites];
            for (i = 0; i < this.numberSites; ++i) {
                this.siteWeightOrder[i] = iniss.siteWeightOrder[i];
            }
        }
        this.siteValueStats = new StatisticalQuantity(iniss.siteValueStats);
        this.siteWeightStats = new StatisticalQuantity(iniss.siteWeightStats);
        this.siteStrengthOutStats = new StatisticalQuantity(iniss.siteStrengthOutStats);
        this.siteStrengthInStats = new StatisticalQuantity(iniss.siteStrengthInStats);
        this.maxSiteValueIndex = iniss.maxSiteValueIndex;
        this.maxSiteWeightIndex = iniss.maxSiteWeightIndex;
        this.maxOutSiteStrengthIndex = iniss.maxOutSiteStrengthIndex;
        this.geneName = new ArrayList();
        for (i = 0; i < iniss.geneName.size(); ++i) {
            this.geneName.add(iniss.geneName.get(i));
        }
        this.minX = iniss.minX;
        this.maxX = iniss.maxX;
        this.minY = iniss.minY;
        this.maxY = iniss.maxY;
        this.XYScale = iniss.XYScale;
        this.siteSizeNormalisation = iniss.siteSizeNormalisation;
        this.siteRankStats = new StatisticalQuantity(iniss.siteRankStats);
        this.siteInfluenceStats = new StatisticalQuantity(iniss.siteInfluenceStats);
        this.siteRankOverWeightMax = iniss.siteRankOverWeightMax;
        this.siteRankOrder = new int[this.numberSites];
        this.siteRankOverWeightOrder = new int[this.numberSites];
        this.siteInfluenceOrder = new int[this.numberSites];
        for (i = 0; i < this.numberSites; ++i) {
            this.siteRankOrder[i] = iniss.siteRankOrder[i];
            this.siteRankOverWeightOrder[i] = iniss.siteRankOverWeightOrder[i];
            this.siteInfluenceOrder[i] = iniss.siteInfluenceOrder[i];
        }
    }

    public boolean isRegionSet() {
        return this.siteArray[0].isRegionSet();
    }

    public boolean isXYSet() {
        return this.siteArray[0].isXYSet();
    }

    public boolean isLatLongSet() {
        return this.siteArray[0].isLatLongSet();
    }

    public boolean isGenetic() {
        return this.geneName.size() > 0;
    }

    public boolean hasStatistics(int index) {
        for (int iii = 0; iii < statisticsList.length; ++iii) {
            if (index != statisticsList[iii]) continue;
            return true;
        }
        return false;
    }

    public int getNumberSites() {
        return this.numberSites;
    }

    public IslandSite[] getSiteArray() {
        return this.siteArray;
    }

    public String getName(int s) {
        return this.siteArray[s].name;
    }

    public String getRegion(int s) {
        return this.siteArray[s].region;
    }

    public double getX(int i) {
        return this.siteArray[i].getX();
    }

    public double getY(int i) {
        return this.siteArray[i].getY();
    }

    public double getLatitude(int i) {
        return this.siteArray[i].latitude;
    }

    public double getLongitude(int i) {
        return this.siteArray[i].longitude;
    }

    public double getValue(int i) {
        return this.siteArray[i].getValue();
    }

    public double getInValue(int i) {
        return this.siteArray[i].getInValue();
    }

    public double getSize(int i) {
        return this.siteArray[i].size;
    }

    public double getInSize(int i) {
        return this.siteArray[i].size;
    }

    public double getWeight(int i) {
        return this.siteArray[i].getWeight();
    }

    public double getInWeight(int i) {
        return this.siteArray[i].getInWeight();
    }

    public double getStrength(int i) {
        return this.siteArray[i].strength;
    }

    public double getStrengthIn(int i) {
        return this.siteArray[i].strengthIn;
    }

    public double getStrengthOut(int i) {
        return this.siteArray[i].strengthOut;
    }

    public double getDisplaySize(int s) {
        return this.siteArray[s].displaySize;
    }

    public double getRanking(int s) {
        return this.siteArray[s].ranking;
    }

    public int getRankingRank(int s) {
        return this.siteArray[s].rankingRank;
    }

    public double getTotalInfluenceWeight(int i) {
        return this.siteArray[i].influence;
    }

    public int getInfluenceRank(int s) {
        return this.siteArray[s].influenceRank;
    }

    public double getVariable(int i, int v) {
        return this.siteArray[i].getVariable(v);
    }

    public double getVariable(int i, String s) {
        return this.siteArray[i].getVariable(s);
    }

    public void setValue(int i, double v) {
        this.siteArray[i].value = v;
    }

    public void setInValue(int i, double u) {
        this.siteArray[i].inValue = u;
    }

    public void setSize(int i, double v) {
        this.siteArray[i].size = v;
    }

    public void setName(int s, String name) {
        this.siteArray[s].setName(name);
    }

    private void setDisplaySize(int i, double v) {
        this.siteArray[i].displaySize = v;
    }

    public void setXY(int i, double x, double y) {
        this.siteArray[i].X = x;
        this.siteArray[i].Y = y;
    }

    public void setVariable(int i, String vname, String value) {
        this.siteArray[i].setVariable(vname, value);
    }

    public void setVariable(int i, int vindex, String value) {
        this.siteArray[i].setVariable(vindex, value);
    }

    public void setWeights() {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].setWeight();
        }
    }

    public void initialiseSet(double v, double S, double ds) {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].value = v;
            this.siteArray[i].size = S;
            this.siteArray[i].setWeight();
            this.siteArray[i].displaySize = ds;
        }
    }

    public int addGene(String name) {
        this.geneName.add(name);
        int g = this.geneName.size();
        for (int s = 0; s < this.numberSites; ++s) {
            this.siteArray[s].addGeneValue();
        }
        return g - 1;
    }

    public int setGeneValues(int g, String[] str) {
        int r = 0;
        for (int s = 0; s < this.numberSites; ++s) {
            r = Math.min(r, this.setGeneValue(s, g, str[s]));
        }
        return r;
    }

    public int setGeneValue(int s, int g, String str) {
        int r = 0;
        try {
            this.siteArray[s].setGeneValue(g, str);
        }
        catch (RuntimeException e) {
            return -1 - s;
        }
        return r;
    }

    public void setGeneLengths() {
        for (int s = 0; s < this.numberSites; ++s) {
            this.siteArray[s].setGeneLength();
        }
    }

    public double getGeneLength(int s) {
        return this.siteArray[s].getGeneLength();
    }

    public double getGeneValue(int s, int g) {
        return this.siteArray[s].getGeneValue(g);
    }

    public double getGeneCorrelation(int s, int t) {
        double dist = 0.0;
        double norm = this.getGeneLength(s) * this.getGeneLength(t);
        if (norm <= 1.0E-6) {
            return 0.0;
        }
        for (int g = 0; g < this.geneName.size(); ++g) {
            dist += this.getGeneValue(s, g) * this.getGeneValue(t, g);
        }
        return dist / norm;
    }

    private int setValue(int s, int v, String str) {
        return this.siteArray[s].setVariable(v, str);
    }

    public int setValues(int v, String[] str) {
        int r = 0;
        for (int s = 0; s < this.numberSites; ++s) {
            if (this.siteArray[s].setVariable(v, str[s]) >= 0) continue;
            r = -1 - s;
        }
        return r;
    }

    public void setValues(double v) {
        for (int s = 0; s < this.numberSites; ++s) {
            this.siteArray[s].setValue(v);
        }
    }

    public void setValuesRandom(Random rnd, double scale) {
        for (int s = 0; s < this.numberSites; ++s) {
            this.siteArray[s].setValue(scale * rnd.nextDouble());
        }
    }

    public void setInValuesRandom(Random rnd, double scale) {
        for (int s = 0; s < this.numberSites; ++s) {
            this.siteArray[s].setInValue(scale * rnd.nextDouble());
        }
    }

    public void setInValues(double v) {
        for (int s = 0; s < this.numberSites; ++s) {
            this.siteArray[s].setInValue(v);
        }
    }

    public void setXYFromLatLong() {
        for (int s = 0; s < this.numberSites; ++s) {
            this.siteArray[s].Y = -this.siteArray[s].latitude;
            this.siteArray[s].X = this.siteArray[s].longitude;
        }
        this.rescaleXY();
    }

    public void setMinMaxXY() {
        this.minX = this.siteArray[0].X;
        this.maxX = this.siteArray[0].X;
        this.minY = this.siteArray[0].Y;
        this.maxY = this.siteArray[0].Y;
        for (int i = 1; i < this.numberSites; ++i) {
            if (this.siteArray[i].X > this.maxX) {
                this.maxX = this.siteArray[i].X;
            }
            if (this.siteArray[i].X < this.minX) {
                this.minX = this.siteArray[i].X;
            }
            if (this.siteArray[i].Y > this.maxY) {
                this.maxY = this.siteArray[i].Y;
            }
            if (!(this.siteArray[i].Y < this.minY)) continue;
            this.minY = this.siteArray[i].Y;
        }
    }

    public void rescaleXY() {
        this.setMinMaxXY();
        double XOffset = (this.maxX + this.minX) / 2.0;
        double YOffset = (this.maxY + this.minY) / 2.0;
        double XScale = (this.maxX - this.minX) / 0.8;
        double YScale = (this.maxY - this.minY) / 0.8;
        this.XYScale = XScale > YScale ? XScale : YScale;
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].X = (this.siteArray[i].X - XOffset) / this.XYScale + 0.5;
            this.siteArray[i].Y = (this.siteArray[i].Y - YOffset) / this.XYScale + 0.5;
        }
    }

    public void normaliseSiteSizes() {
        int s;
        this.siteSizeNormalisation = 0.0;
        for (s = 0; s < this.numberSites; ++s) {
            this.siteSizeNormalisation += this.siteArray[s].size;
        }
        for (s = 0; s < this.numberSites; ++s) {
            this.siteArray[s].size = this.siteArray[s].size * (double)this.numberSites / this.siteSizeNormalisation;
        }
    }

    public void setShortNames() {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].setShortName();
        }
    }

    public double sphericalDistance(int i, int j) {
        return Distances.sphericalDistance((double)this.siteArray[i].latitude, (double)this.siteArray[i].longitude, (double)this.siteArray[j].latitude, (double)this.siteArray[j].longitude);
    }

    public double euclideanDistance(int i, int j) {
        return Distances.euclideanDistance((double)this.siteArray[i].X, (double)this.siteArray[i].Y, (double)this.siteArray[j].X, (double)this.siteArray[j].Y);
    }

    public void calcAlphabeticalOrder() {
        this.calcSiteOrder(1, this.siteAlphabeticalOrder, this.numberSites);
    }

    public void calcBasicStatistics(IslandEdgeSet edgeSet) {
        int i;
        this.siteValueStats = new StatisticalQuantity(1.2345E97, -1.0);
        this.siteWeightStats = new StatisticalQuantity(1.2345E97, -1.0);
        this.siteStrengthOutStats = new StatisticalQuantity(1.2345E97, -1.0);
        this.siteStrengthInStats = new StatisticalQuantity(1.2345E97, -1.0);
        for (int i2 = 0; i2 < this.numberSites; ++i2) {
            this.siteArray[i2].strength = 0.0;
            this.siteArray[i2].strengthIn = 0.0;
            this.siteArray[i2].strengthOut = 0.0;
            this.siteArray[i2].strengthSquaredIn = 0.0;
            this.siteArray[i2].strengthSquaredOut = 0.0;
        }
        for (i = 0; i < this.numberSites; ++i) {
            double vV = this.siteArray[i].getValue();
            double vw = this.siteArray[i].getWeight();
            if (this.siteValueStats.maximum <= vV) {
                this.maxSiteValueIndex = i;
            }
            if (this.siteWeightStats.maximum <= vw) {
                this.maxSiteWeightIndex = i;
            }
            this.siteValueStats.add(vV);
            this.siteWeightStats.add(vw);
            for (int j = 0; j < this.numberSites; ++j) {
                double eV = edgeSet.getEdgeValue(i, j);
                double eV2 = eV * eV;
                double ew = vw * eV;
                double ew2 = ew * ew;
                this.siteArray[i].strengthOut += ew;
                this.siteArray[i].strengthSquaredOut += ew2;
                this.siteArray[j].strengthIn += ew;
                this.siteArray[j].strengthSquaredIn += ew2;
                this.siteArray[j].strength += ew;
            }
            if (this.siteStrengthOutStats.maximum <= this.siteArray[i].strengthOut) {
                this.maxOutSiteStrengthIndex = i;
            }
            this.siteStrengthOutStats.add(this.siteArray[i].strengthOut);
        }
        for (i = 0; i < this.numberSites; ++i) {
            double sin = this.siteArray[i].strengthIn;
            this.siteStrengthInStats.add(sin);
            if (!(this.siteStrengthInStats.maximum <= sin)) continue;
            this.maxInSiteStrengthIndex = i;
        }
        this.calcSiteWeightOrder();
        for (i = 0; i < this.numberSites; ++i) {
            if (!(this.siteRankOverWeightMax < this.siteArray[i].rankOverWeight)) continue;
            this.siteRankOverWeightMax = this.siteArray[i].rankOverWeight;
        }
    }

    public void calcRanking(IslandTransferMatrix transferMatrix) {
        int i;
        int m = transferMatrix.checkMarkovian(0.001);
        if (m >= 0) {
            System.out.println(" !!! transferMatrix failed Markovian test at column " + m);
        } else {
            System.out.println("... Transfer Matrix is Markovian");
        }
        int e = transferMatrix.checkNonNegative();
        if (e >= 0) {
            System.err.println("*** Transfer Matrix is negative at row " + (double)e / transferMatrix.getDimension() + " column " + (double)e % transferMatrix.getDimension());
        } else {
            System.out.println("... Transfer Matrix is non-negative");
        }
        double evmax = transferMatrix.getAbsEigenValue(0);
        if (evmax < 0.99) {
            System.out.println("!!! WARNING in calcRanking largest absolute eigenvalue of transfer matrix has value " + evmax);
        }
        double[] evectorMax = new double[this.numberSites];
        evectorMax = transferMatrix.getEigenVector(0);
        double norm = 0.0;
        for (i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].ranking = Math.abs(evectorMax[i]);
            norm += this.siteArray[i].ranking;
        }
        if (norm > 0.0) {
            for (i = 0; i < this.numberSites; ++i) {
                this.siteArray[i].ranking /= norm;
            }
        }
        for (i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].rankOverWeight = this.siteArray[i].getWeight() > 0.0 ? this.siteArray[i].ranking / this.siteArray[i].getWeight() : 0.0;
        }
        this.calcSiteRankOrder(9, this.siteRankOrder, 10);
        this.calcSiteRankOrder(19, this.siteRankOverWeightOrder, 20);
        this.siteRankStats = new StatisticalQuantity(99999.0, -1.0);
        for (int s = 0; s < this.numberSites; ++s) {
            this.siteRankStats.add(this.siteArray[s].ranking);
        }
    }

    public void calcInfluence(IslandTransferMatrix transferMatrix, double influenceProb) {
        int s;
        transferMatrix.calcInfluenceMatrix(influenceProb);
        double[] totalInfluenceWeight = new double[this.numberSites];
        for (s = 0; s < this.numberSites; ++s) {
            totalInfluenceWeight[s] = 0.0;
            double sourceWeight = this.siteArray[s].getWeight();
            for (int t = 0; t < this.numberSites; ++t) {
                int n = s;
                totalInfluenceWeight[n] = totalInfluenceWeight[n] + this.siteArray[t].getWeight() * transferMatrix.getInfluence(t, s) * sourceWeight;
            }
        }
        for (s = 0; s < this.numberSites; ++s) {
            this.siteArray[s].influence = totalInfluenceWeight[s];
        }
        this.calcSiteRankOrder(11, this.siteInfluenceOrder, 13);
        this.siteInfluenceStats = new StatisticalQuantity(99999.0, -1.0);
        for (s = 0; s < this.numberSites; ++s) {
            this.siteInfluenceStats.add(this.siteArray[s].influence);
        }
    }

    public void setAllDisplaySizes(int siteVariableIndex, double displayScale) {
        double scale;
        this.displayIndex = siteVariableIndex;
        double scaleSize = 1.0;
        boolean variableSizes = false;
        if (IslandSite.isIndex(this.displayIndex) && IslandSite.isNumerical(this.displayIndex)) {
            variableSizes = true;
            if (this.hasStatistics(this.displayIndex) && displayScale < 0.0) {
                if (this.displayIndex == IslandSite.valueIndex) {
                    scaleSize = this.siteValueStats.maximum;
                }
                if (this.displayIndex == IslandSite.weightIndex) {
                    scaleSize = this.siteWeightStats.maximum;
                }
                if (this.displayIndex == IslandSite.strengthInIndex) {
                    scaleSize = this.siteStrengthInStats.maximum;
                }
                if (this.displayIndex == IslandSite.strengthOutIndex) {
                    scaleSize = this.siteStrengthOutStats.maximum;
                }
                if (this.displayIndex == IslandSite.rankingIndex) {
                    scaleSize = this.siteRankStats.maximum;
                }
                if (this.displayIndex == IslandSite.influenceIndex) {
                    scaleSize = this.siteInfluenceStats.maximum;
                }
            }
            if (scaleSize < 1.0E-6) {
                scaleSize = 1.0;
            }
        }
        double avSize = 0.0;
        double ns = scale = Math.abs(displayScale);
        for (int i = 0; i < this.numberSites; ++i) {
            if (variableSizes) {
                ns = scale * this.siteArray[i].getVariable(this.displayIndex) / scaleSize;
            }
            avSize += ns;
            this.siteArray[i].displaySize = ns;
            if (this.siteArray[i].displaySize < 0.0) {
                this.siteArray[i].displaySize = 0.0;
            }
            this.siteArray[i].Z = this.siteArray[i].displaySize;
        }
        System.out.println("IslandSite: Site Display of " + IslandSite.dataName(this.displayIndex) + "  scale, scaleSize, average " + scale + "  " + scaleSize + "  " + avSize / (double)this.numberSites);
    }

    public void printDisplaySizes(PrintStream PS, String sep, int dec) {
        for (int i = 0; i < this.numberSites; ++i) {
            PS.print(sep + NumbersToString.toString((double)this.siteArray[i].displaySize, (int)dec));
        }
    }

    public void printFixedSiteVariables(PrintStream PS, String cc, String sep) {
        PS.println(cc + sep + this.siteArray[0].fixedDataNameString(sep));
        for (int i = 0; i < this.numberSites; ++i) {
            PS.println(i + sep + this.siteArray[i].fixedDataString(sep));
        }
    }

    public void printSiteVariables(PrintStream PS, String cc, String sep) {
        for (int v = 0; v < IslandSite.numberVariables; ++v) {
            this.printValues(PS, cc, sep, v);
        }
        this.printGenes(PS, cc, sep);
    }

    public void printSiteParameters(PrintStream PS, String cc, String sep) {
        for (int s = 0; s < this.numberSites; ++s) {
            PS.println(this.siteArray[s].parameterStringValues(sep, 5));
        }
    }

    public void printValues(PrintStream PS, String cc, String sep, int v) {
        if (this.siteArray[0].isSet(v)) {
            this.printValuesAlways(PS, cc, sep, v);
        }
    }

    public void printValuesAlways(PrintStream PS, String cc, String sep, int v) {
        PS.print(cc + IslandSite.dataName(v));
        for (int i = 0; i < this.numberSites; ++i) {
            PS.print(sep + this.siteArray[i].toString(v));
        }
        PS.println();
    }

    public void printValues(PrintStream PS, String cc, String sep, String name) {
        int v = IslandSite.getIndex(name);
        if (v < 0) {
            PS.println("Variable " + name + " is unknown");
        } else {
            this.printValues(PS, cc, sep, v);
        }
    }

    public void printValueVector(PrintStream PS, String name) {
        int v = IslandSite.getIndex(name);
        if (v < 0) {
            PS.println("Variable " + name + " is unknown");
        } else {
            this.printValueVector(PS, v);
        }
    }

    public void printValueVector(PrintStream PS, int v) {
        for (int i = 0; i < this.numberSites; ++i) {
            PS.println(this.siteArray[i].toString(v));
        }
    }

    public void printGenes(PrintStream PS, String cc, String sep) {
        for (int g = 0; g < this.geneName.size(); ++g) {
            PS.print(this.geneName.get(g));
            for (int i = 0; i < this.numberSites; ++i) {
                PS.print(sep + this.siteArray[i].getGeneValue(g));
            }
            PS.println();
        }
    }

    public String geneNameString(String sep) {
        String s = "";
        if (this.geneName.size() > 0) {
            for (int g = 0; g < this.geneName.size(); ++g) {
                s = s + sep + this.geneName.get(g);
            }
        }
        return s;
    }

    public String toString(int index, String sep1, String sep2, int dec) {
        String s = "";
        for (int i = 0; i < IslandSite.numberVariables; ++i) {
            if (!this.siteArray[index].isSet(i)) continue;
            s = s + IslandSite.dataName(i) + sep1 + this.siteArray[index].toShortDoubleString(i, dec) + sep2;
        }
        for (int g = 0; g < this.geneName.size(); ++g) {
            s = s + this.geneName.get(g) + sep1 + this.siteArray[index].geneToShortDoubleString(g, dec) + sep2;
        }
        return s;
    }

    public IslandSite getSite(int index) {
        return this.siteArray[index];
    }

    public void printPajekNetFormat(PrintStream PS, double minColourFrac, double zeroColourFrac, int fileType) {
        int numberColours = PajekColours.numberColours;
        PS.println("*Vertices      " + this.numberSites);
        block7: for (int i = 0; i < this.numberSites; ++i) {
            int sc = (int)(0.499999 + this.siteArray[i].displaySize);
            if (sc > numberColours) {
                sc = numberColours;
            }
            if ((double)sc < minColourFrac * (double)numberColours) {
                sc = 1;
            }
            if ((double)sc < zeroColourFrac * (double)numberColours) {
                sc = 0;
            }
            PS.print(i + 1 + "  \"" + this.getName(i) + "\" " + this.siteArray[i].X + " " + this.siteArray[i].Y + " ");
            switch (fileType) {
                case 1: 
                case 2: {
                    PS.print(this.siteArray[i].Z + " s_size 1 " + " x_fact " + this.n2s.TruncDecimal(this.siteArray[i].displaySize, 2) + " y_fact " + this.n2s.TruncDecimal(this.siteArray[i].displaySize, 2));
                    break;
                }
                default: {
                    PS.print("  " + this.siteArray[i].getWeight());
                }
            }
            switch (fileType) {
                case 1: {
                    PS.println(" ic " + PajekColours.getGrey(sc) + "   bc " + PajekColours.getGrey(sc));
                    continue block7;
                }
                case 2: {
                    PS.println(" ic " + PajekColours.colours[sc] + "   bc " + PajekColours.colours[numberColours]);
                    continue block7;
                }
                default: {
                    PS.println();
                }
            }
        }
    }

    public void calcSiteWeightOrder() {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].setWeight();
        }
        this.calcSiteRankOrder(7, this.siteWeightOrder, 8);
    }

    private void calcSiteOrder(int valueNumber, int[] orderVector, int n) {
        int i;
        boolean alpha = IslandSite.isAlpha(valueNumber);
        for (i = 0; i < n; ++i) {
            orderVector[i] = i;
        }
        for (i = 0; i < n; ++i) {
            int best = orderVector[i];
            for (int j = i + 1; j < n; ++j) {
                int newbest = orderVector[j];
                if ((!alpha || this.siteArray[best].toString(valueNumber).compareToIgnoreCase(this.siteArray[newbest].toString(valueNumber)) <= 0) && (alpha || !(this.siteArray[best].getVariable(valueNumber) < this.siteArray[newbest].getVariable(valueNumber)))) continue;
                best = newbest;
                orderVector[j] = orderVector[i];
                orderVector[i] = best;
            }
        }
    }

    public void calcSiteRankOrder(int valueNumber, int[] orderVector, int rankNumber) {
        int n = orderVector.length;
        this.calcSiteOrder(valueNumber, orderVector, n);
        for (int i = 0; i < n; ++i) {
            this.siteArray[orderVector[i]].setInt(rankNumber, i);
        }
        n = 0;
    }
}

