/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.Vertex;

import TimUtilities.NumbersToString;
import java.util.ArrayList;

public class IslandSite {
    static final double DUNSET = -76543.2;
    static final int IUNSET = -654321;
    static final double GUNSET = -54321.0987;
    static final String AUNSET = "?!!!!!";
    static final int SSDEFAULTLENGTH = 3;
    static final String SAUNSET = "?!!!!!".substring(0, 3);
    public String name = "?!!!!!";
    public String shortName = SAUNSET;
    public double X = -76543.2;
    public double Y = -76543.2;
    public double Z = -76543.2;
    public double size = -76543.2;
    public double value = -76543.2;
    private double weight = -76543.2;
    public int weightRank = -654321;
    public double ranking = -76543.2;
    public int rankingRank = -654321;
    public double influence = -76543.2;
    private int influenceInt = -654321;
    public int influenceRank = -654321;
    public double displaySize = -654321.0;
    public double strength = -654321.0;
    public double strengthIn = -654321.0;
    public double strengthOut = -654321.0;
    public int number = -654321;
    public double rankOverWeight = 0.0;
    public int rankOverWeightRank = -654321;
    public double cultureMax = -654321.0;
    public int cultureSite = -654321;
    public double strengthSquaredIn = -654321.0;
    public double strengthSquaredOut = -654321.0;
    public double latitude = -76543.2;
    public double longitude = -76543.2;
    public String region = "?!!!!!";
    public double inValue = -76543.2;
    public double inWeight = -76543.2;
    private ArrayList<Double> geneList = new ArrayList();
    double geneLength = -76543.2;
    private static NumbersToString n2s = new NumbersToString(3);
    static final String[] parameterNames = new String[]{"ShortName", "Name", "XPos", "YPos", "ZPos", "Size", "Value", "Weight", "WeightRank", "Ranking", "RankingRank", "Influence", "InfluenceInt", "InfluenceRank", "DisplaySize", "Strength", "StrengthIn", "StrengthOut", "Number", "Ranking/Weight", "Ranking/Weight rank", "CultureMax", "CultureSite", "StrengthInSquared", "StrengthOutSquared", "Latitude", "Longitude", "Region", "ValueIn", "WeightIn"};
    public static final int numberVariables = parameterNames.length;
    public static final int valueIndex = IslandSite.getIndex("Value");
    public static final int weightIndex = IslandSite.getIndex("Weight");
    public static final int strengthInIndex = IslandSite.getIndex("StrengthIn");
    public static final int strengthOutIndex = IslandSite.getIndex("StrengthOut");
    public static final int rankingIndex = IslandSite.getIndex("Ranking");
    public static final int influenceIndex = IslandSite.getIndex("Influence");
    static final char INTCHAR = 'i';
    static final char DOUBLECHAR = 'd';
    static final char ALPHACHAR = 'a';
    static final char DLISTCHAR = 'l';
    static final char[] typeList = new char[]{'a', 'a', 'd', 'd', 'd', 'd', 'd', 'd', 'i', 'd', 'i', 'd', 'i', 'i', 'd', 'd', 'd', 'd', 'i', 'd', 'i', 'd', 'i', 'd', 'd', 'd', 'd', 'a', 'd', 'd'};
    static final int[] parameterFileList = new int[]{18, 1, 27, 2, 3, 4, 25, 26, 5, 6, 28, 29};
    static final int[] fixedParameterList = new int[]{1, 2, 3, 4, 5, 18, 25, 26, 27};

    public IslandSite() {
    }

    public IslandSite(int siteNumber) {
        this.number = siteNumber;
        this.name = Integer.toString(siteNumber);
    }

    public IslandSite(IslandSite s) {
        this.name = s.name;
        this.shortName = s.shortName;
        this.number = s.number;
        this.X = s.X;
        this.Y = s.Y;
        this.Z = s.Z;
        this.size = s.size;
        this.value = s.value;
        this.weight = s.weight;
        this.weightRank = s.weightRank;
        this.ranking = s.ranking;
        this.rankingRank = s.rankingRank;
        this.influence = s.influence;
        this.influenceInt = s.influenceInt;
        this.influenceRank = s.influenceRank;
        this.displaySize = s.displaySize;
        this.strength = s.strength;
        this.strengthIn = s.strengthIn;
        this.strengthOut = s.strengthOut;
        this.rankOverWeight = s.rankOverWeight;
        this.rankOverWeightRank = s.rankOverWeightRank;
        this.cultureMax = s.cultureMax;
        this.cultureSite = s.cultureSite;
        this.strengthSquaredIn = s.strengthSquaredIn;
        this.strengthSquaredOut = s.strengthSquaredOut;
        this.latitude = s.latitude;
        this.longitude = s.longitude;
        this.region = s.region;
        this.inValue = s.inValue;
        this.inWeight = s.inWeight;
        for (int g = 0; g < s.geneList.size(); ++g) {
            this.geneList.add(s.geneList.get(g));
        }
    }

    public String toString(String SEP) {
        String s = "";
        for (int i = 0; i < numberVariables; ++i) {
            s = s + this.toString(i) + SEP;
        }
        for (int g = 0; g < this.geneList.size(); ++g) {
            s = s + this.geneList.get(g).toString() + SEP;
        }
        return s;
    }

    public void setWeight() {
        this.weight = this.value * this.size;
    }

    public void setValue(double v) {
        this.value = v;
    }

    public void setInValue(double v) {
        this.inValue = v;
    }

    public void setInWeight() {
        this.inWeight = this.inValue * this.size;
    }

    public String setName(String s) {
        int numberCharacters = 2;
        this.shortName = this.name = s;
        if (this.name.length() < numberCharacters) {
            return this.name;
        }
        this.shortName = this.name.substring(0, numberCharacters);
        return this.name;
    }

    public String setName(String shorts, String s) {
        this.shortName = shorts;
        this.name = s;
        return s;
    }

    public void setShortName() {
        if (this.shortName.equals(SAUNSET)) {
            this.shortName = this.name.length() > 2 ? this.name.substring(0, 3) : this.name;
        }
    }

    public int setInt(int index, int value) {
        int res = 0;
        switch (index) {
            case 8: {
                this.weightRank = value;
                break;
            }
            case 10: {
                this.rankingRank = value;
                break;
            }
            case 12: {
                this.influenceInt = value;
                break;
            }
            case 13: {
                this.influenceRank = value;
                break;
            }
            case 18: {
                this.number = value;
                break;
            }
            case 20: {
                this.rankOverWeightRank = value;
                break;
            }
            case 22: {
                this.cultureSite = value;
                break;
            }
            default: {
                res = -97531;
            }
        }
        return res;
    }

    public double getWeight() {
        this.setWeight();
        return this.weight;
    }

    public double getOutWeight() {
        this.setWeight();
        return this.weight;
    }

    public double getInWeight() {
        this.setInWeight();
        return this.inWeight;
    }

    public int getNumberVariables() {
        return numberVariables;
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public double getDisplaySize() {
        return this.displaySize;
    }

    public double getValue() {
        return this.value;
    }

    public double getInValue() {
        return this.inValue;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList getGene() {
        return this.geneList;
    }

    public double getGeneLength() {
        return this.geneLength;
    }

    public double setGeneLength() {
        double v = 0.0;
        double l2 = 0.0;
        for (int g = 0; g < this.geneList.size(); ++g) {
            v = this.geneList.get(g);
            l2 += v * v;
        }
        this.geneLength = Math.sqrt(l2);
        return this.geneLength;
    }

    public Object getObject(int index) {
        switch (index) {
            case 0: {
                return this.shortName;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.X;
            }
            case 3: {
                return this.Y;
            }
            case 4: {
                return this.Z;
            }
            case 5: {
                return this.size;
            }
            case 6: {
                return this.value;
            }
            case 7: {
                return this.weight;
            }
            case 8: {
                return this.weightRank;
            }
            case 9: {
                return this.ranking;
            }
            case 10: {
                return this.rankingRank;
            }
            case 11: {
                return this.influence;
            }
            case 12: {
                return this.influenceInt;
            }
            case 13: {
                return this.influenceRank;
            }
            case 14: {
                return this.displaySize;
            }
            case 15: {
                return this.strength;
            }
            case 16: {
                return this.strengthIn;
            }
            case 17: {
                return this.strengthOut;
            }
            case 18: {
                return this.number;
            }
            case 19: {
                return this.rankOverWeight;
            }
            case 20: {
                return this.rankOverWeightRank;
            }
            case 21: {
                return this.cultureMax;
            }
            case 22: {
                return this.cultureSite;
            }
            case 23: {
                return this.strengthSquaredIn;
            }
            case 24: {
                return this.strengthSquaredOut;
            }
            case 25: {
                return this.latitude;
            }
            case 26: {
                return this.longitude;
            }
            case 27: {
                return this.region;
            }
            case 28: {
                return this.inValue;
            }
            case 29: {
                return this.inWeight;
            }
        }
        return AUNSET;
    }

    public double getVariable(String name) {
        return this.getVariable(IslandSite.getIndex(name));
    }

    public double getVariable(int index) {
        double s = -76543.2;
        switch (index) {
            case 0: {
                s = this.shortName.codePointAt(0);
                break;
            }
            case 1: {
                s = this.name.codePointAt(0);
                break;
            }
            case 2: {
                s = this.X;
                break;
            }
            case 3: {
                s = this.Y;
                break;
            }
            case 4: {
                s = this.Z;
                break;
            }
            case 5: {
                s = this.size;
                break;
            }
            case 6: {
                s = this.value;
                break;
            }
            case 7: {
                s = this.weight;
                break;
            }
            case 8: {
                s = this.weightRank;
                break;
            }
            case 9: {
                s = this.ranking;
                break;
            }
            case 10: {
                s = this.rankingRank;
                break;
            }
            case 11: {
                s = this.influence;
                break;
            }
            case 12: {
                s = this.influenceInt;
                break;
            }
            case 13: {
                s = this.influenceRank;
                break;
            }
            case 14: {
                s = this.displaySize;
                break;
            }
            case 15: {
                s = this.strength;
                break;
            }
            case 16: {
                s = this.strengthIn;
                break;
            }
            case 17: {
                s = this.strengthOut;
                break;
            }
            case 18: {
                s = this.number;
                break;
            }
            case 19: {
                s = this.rankOverWeight;
                break;
            }
            case 20: {
                s = this.rankOverWeightRank;
                break;
            }
            case 21: {
                s = this.cultureMax;
                break;
            }
            case 22: {
                s = this.cultureSite;
                break;
            }
            case 23: {
                s = this.strengthSquaredIn;
                break;
            }
            case 24: {
                s = this.strengthSquaredOut;
                break;
            }
            case 25: {
                s = this.latitude;
                break;
            }
            case 26: {
                s = this.longitude;
                break;
            }
            case 27: {
                s = this.region.codePointAt(0);
                break;
            }
            case 28: {
                s = this.inValue;
                break;
            }
            case 29: {
                s = this.inWeight;
            }
        }
        return s;
    }

    public String parameterStringValues(String sep, int dec) {
        String s = "";
        for (int i = 0; i < parameterFileList.length; ++i) {
            s = s + (i == 0 ? "" : sep);
            int p = parameterFileList[i];
            s = p == 1 ? s + this.toString(p) : s + this.toShortString(parameterFileList[i], dec);
        }
        return s + this.geneStringValues(sep, dec);
    }

    public String geneStringValues(String sep, int dec) {
        if (this.geneList.size() == 0) {
            return "";
        }
        String s = "";
        for (int g = 0; g < this.geneList.size(); ++g) {
            s = s + sep + n2s.TruncDecimal(this.geneList.get(g).doubleValue(), dec);
        }
        return s;
    }

    public static String parameterStringNames(String sep) {
        String s = "";
        for (int i = 0; i < parameterFileList.length; ++i) {
            s = s + (i == 0 ? "" : sep) + IslandSite.dataName(parameterFileList[i]);
        }
        return s;
    }

    public String toShortString(int index, int dec) {
        String s = "value unknown";
        if (IslandSite.isAlpha(index)) {
            s = this.toString(index);
            if (s.length() > dec) {
                s = s.substring(0, dec);
            }
        } else {
            s = IslandSite.isDouble(index) ? NumbersToString.toString((double)this.getVariable(index), (int)dec) : this.toString(index);
        }
        return s;
    }

    public String toShortDoubleString(int index, int dec) {
        String s = "index " + index + " unknown";
        s = IslandSite.isAlpha(index) ? this.toString(index) : NumbersToString.toString((double)this.getVariable(index), (int)dec);
        return s;
    }

    public String geneToShortDoubleString(int index, int dec) {
        String s = NumbersToString.toString((double)this.getGeneValue(index), (int)dec);
        return s;
    }

    public String toString(int index) {
        String s = "value unknown";
        switch (index) {
            case 0: {
                s = this.shortName;
                break;
            }
            case 1: {
                s = this.name;
                break;
            }
            case 2: {
                s = Double.toString(this.X);
                break;
            }
            case 3: {
                s = Double.toString(this.Y);
                break;
            }
            case 4: {
                s = Double.toString(this.Z);
                break;
            }
            case 5: {
                s = Double.toString(this.size);
                break;
            }
            case 6: {
                s = Double.toString(this.value);
                break;
            }
            case 7: {
                s = Double.toString(this.weight);
                break;
            }
            case 8: {
                s = Integer.toString(this.weightRank);
                break;
            }
            case 9: {
                s = Double.toString(this.ranking);
                break;
            }
            case 10: {
                s = Integer.toString(this.rankingRank);
                break;
            }
            case 11: {
                s = Double.toString(this.influence);
                break;
            }
            case 12: {
                s = Integer.toString(this.influenceInt);
                break;
            }
            case 13: {
                s = Integer.toString(this.influenceRank);
                break;
            }
            case 14: {
                s = Double.toString(this.displaySize);
                break;
            }
            case 15: {
                s = Double.toString(this.strength);
                break;
            }
            case 16: {
                s = Double.toString(this.strengthIn);
                break;
            }
            case 17: {
                s = Double.toString(this.strengthOut);
                break;
            }
            case 18: {
                s = Integer.toString(this.number);
                break;
            }
            case 19: {
                s = Double.toString(this.strengthOut);
                break;
            }
            case 20: {
                s = Integer.toString(this.rankOverWeightRank);
                break;
            }
            case 21: {
                s = Double.toString(this.cultureMax);
                break;
            }
            case 22: {
                s = Integer.toString(this.cultureSite);
                break;
            }
            case 23: {
                s = Double.toString(this.strengthSquaredIn);
                break;
            }
            case 24: {
                s = Double.toString(this.strengthSquaredOut);
                break;
            }
            case 25: {
                s = Double.toString(this.latitude);
                break;
            }
            case 26: {
                s = Double.toString(this.longitude);
                break;
            }
            case 27: {
                s = this.region;
                break;
            }
            case 28: {
                s = Double.toString(this.inValue);
                break;
            }
            case 29: {
                s = Double.toString(this.inWeight);
            }
        }
        return s;
    }

    public int setVariable(String name, String s) {
        int res = 0;
        try {
            int i = IslandSite.getIndex(name);
            this.setVariable(i, s);
        }
        catch (NumberFormatException e) {
            System.out.println("Problem in Site.setValue: " + e);
            res = -1;
        }
        return res;
    }

    public int setVariable(int index, String s) {
        int res = 0;
        try {
            switch (index) {
                case 0: {
                    this.shortName = s;
                    break;
                }
                case 1: {
                    this.name = s;
                    break;
                }
                case 2: {
                    this.X = new Double(s);
                    break;
                }
                case 3: {
                    this.Y = new Double(s);
                    break;
                }
                case 4: {
                    this.Z = new Double(s);
                    break;
                }
                case 5: {
                    this.size = new Double(s);
                    break;
                }
                case 6: {
                    this.value = new Double(s);
                    break;
                }
                case 7: {
                    this.weight = new Double(s);
                    break;
                }
                case 8: {
                    this.weightRank = new Integer(s);
                    break;
                }
                case 9: {
                    this.ranking = new Double(s);
                    break;
                }
                case 10: {
                    this.rankingRank = new Integer(s);
                    break;
                }
                case 11: {
                    this.influence = new Double(s);
                    break;
                }
                case 12: {
                    this.influenceInt = new Integer(s);
                    break;
                }
                case 13: {
                    this.influenceRank = new Integer(s);
                    break;
                }
                case 14: {
                    this.displaySize = new Double(s);
                    break;
                }
                case 15: {
                    this.strength = new Double(s);
                    break;
                }
                case 16: {
                    this.strengthIn = new Double(s);
                    break;
                }
                case 17: {
                    this.strengthOut = new Double(s);
                    break;
                }
                case 18: {
                    this.number = new Integer(s);
                    break;
                }
                case 19: {
                    this.rankOverWeight = new Double(s);
                    break;
                }
                case 20: {
                    this.rankOverWeightRank = new Integer(s);
                    break;
                }
                case 21: {
                    this.cultureMax = new Double(s);
                    break;
                }
                case 22: {
                    this.cultureSite = new Integer(s);
                    break;
                }
                case 23: {
                    this.strengthSquaredIn = new Double(s);
                    break;
                }
                case 24: {
                    this.strengthSquaredOut = new Double(s);
                    break;
                }
                case 25: {
                    this.latitude = new Double(s);
                    break;
                }
                case 26: {
                    this.longitude = new Double(s);
                    break;
                }
                case 27: {
                    this.region = s;
                    break;
                }
                case 28: {
                    this.inValue = new Double(s);
                    break;
                }
                case 29: {
                    this.inWeight = new Double(s);
                }
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Problem in Site.setValue: " + e);
            res = -1;
        }
        return res;
    }

    public double getGeneValue(int g) {
        return this.geneList.get(g);
    }

    public void addGeneValue() {
        this.geneList.add(-54321.0987);
    }

    public void setGeneValue(int g, String str) {
        this.geneList.set(g, Double.parseDouble(str));
    }

    public void setGeneValue(int g, Double value) {
        this.geneList.set(g, value);
    }

    public String fixedDataNameString(String SEP) {
        String s = IslandSite.dataName(0);
        for (int i = 1; i < fixedParameterList.length; ++i) {
            s = s + SEP + IslandSite.dataName(fixedParameterList[i]);
        }
        return s;
    }

    public String fixedDataString(String SEP) {
        String s = this.toString(0);
        for (int i = 1; i < fixedParameterList.length; ++i) {
            s = s + SEP + this.toString(fixedParameterList[i]);
        }
        return s;
    }

    public static String dataNameString(String SEP) {
        String s = IslandSite.dataName(0);
        for (int i = 1; i < numberVariables; ++i) {
            s = s + SEP + IslandSite.dataName(i);
        }
        return s;
    }

    public static String dataName(int index) {
        if (index < 0 || index >= parameterNames.length) {
            return "value unknown";
        }
        return parameterNames[index];
    }

    public int dataNameNumber(String input, int length) {
        if (input.length() < length) {
            return -2;
        }
        int res = -1;
        String s = input.substring(0, length);
        for (int v = 0; v < numberVariables; ++v) {
            if (IslandSite.dataName(v).length() < length || !s.equalsIgnoreCase(IslandSite.dataName(v).substring(0, length))) continue;
            res = v;
            break;
        }
        return res;
    }

    public static int getIndex(String input) {
        int res = -1;
        for (int v = 0; v < numberVariables; ++v) {
            if (IslandSite.dataName(v).length() < input.length() || !input.equalsIgnoreCase(IslandSite.dataName(v).substring(0, input.length()))) continue;
            res = v;
            break;
        }
        return res;
    }

    public boolean isLatLongSet() {
        return this.latitude != -76543.2 && this.longitude != -76543.2;
    }

    public boolean isXYSet() {
        return this.X != -76543.2 && this.Y != -76543.2;
    }

    public boolean isXYZSet() {
        return this.X != -76543.2 && this.Y != -76543.2 && this.Z != -76543.2;
    }

    public boolean isRegionSet() {
        return !this.region.equals(AUNSET);
    }

    public static boolean isIndex(int index) {
        return index >= 0 && index < numberVariables;
    }

    public static boolean isInt(int index) {
        return typeList[index] == 'i';
    }

    public static boolean isDouble(int index) {
        return typeList[index] == 'd';
    }

    public static boolean isNumerical(int index) {
        return typeList[index] == 'd' || typeList[index] == 'i';
    }

    public static boolean isAlpha(int index) {
        return typeList[index] == 'a';
    }

    public boolean isSet(String s) {
        return this.isSet(IslandSite.getIndex(s));
    }

    public boolean isSet(int index) {
        switch (index) {
            case 0: {
                return !this.shortName.equals(SAUNSET);
            }
            case 1: {
                return !this.name.equals(AUNSET);
            }
            case 2: {
                return -76543.2 != this.X;
            }
            case 3: {
                return -76543.2 != this.Y;
            }
            case 4: {
                return -76543.2 != this.Z;
            }
            case 5: {
                return -76543.2 != this.size;
            }
            case 6: {
                return -76543.2 != this.value;
            }
            case 7: {
                return -76543.2 != this.weight;
            }
            case 8: {
                return -654321 != this.weightRank;
            }
            case 9: {
                return -76543.2 != this.ranking;
            }
            case 10: {
                return -654321 != this.rankingRank;
            }
            case 11: {
                return -76543.2 != this.influence;
            }
            case 12: {
                return -654321 != this.influenceInt;
            }
            case 13: {
                return -654321 != this.influenceRank;
            }
            case 14: {
                return -76543.2 != this.displaySize;
            }
            case 15: {
                return -76543.2 != this.strength;
            }
            case 16: {
                return -76543.2 != this.strengthIn;
            }
            case 17: {
                return -76543.2 != this.strengthOut;
            }
            case 18: {
                return -654321 != this.number;
            }
            case 19: {
                return -76543.2 != this.rankOverWeight;
            }
            case 20: {
                return -654321 != this.rankOverWeightRank;
            }
            case 21: {
                return -76543.2 != this.cultureMax;
            }
            case 22: {
                return -654321 != this.cultureSite;
            }
            case 23: {
                return -76543.2 != this.strengthSquaredIn;
            }
            case 24: {
                return -76543.2 != this.strengthSquaredOut;
            }
            case 25: {
                return -76543.2 != this.latitude;
            }
            case 26: {
                return -76543.2 != this.longitude;
            }
            case 27: {
                return !this.region.equals(AUNSET);
            }
            case 28: {
                return -76543.2 != this.inValue;
            }
            case 29: {
                return -76543.2 != this.inValue;
            }
        }
        return false;
    }
}

