/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.LouvainCommunity;
import IslandNetworks.NetworkGenerator;
import IslandNetworks.io.FileLocation;
import IslandNetworks.islandNetwork;
import java.io.File;
import java.util.Date;

public class TestAegean {
    String SEP = "\t";

    public static void main(String[] args) {
        Date date = new Date();
        System.out.println(date);
        islandNetwork a = new islandNetwork(1);
        a.inputGUI = true;
        String rootString = "aegean39S1L3a";
        String ariadneDirectory = System.getProperty("user.dir");
        a.inputFile = new FileLocation(ariadneDirectory + "/input/", "", rootString, "", "_input", "dat");
        a.outputFile = new FileLocation(ariadneDirectory + "/output/", "", rootString, "", 0, "", "dat");
        int res = a.Parse(args);
        if (res > 0) {
            System.out.println("Command line argument failure - return code " + res);
            return;
        }
        if (a.inputGUI) {
            TestAegean.testGUIDirect(a);
        } else {
            if (a.generateNumber >= 0) {
                NetworkGenerator ng = new NetworkGenerator(a.generateType, a.generateNumber, a.Hamiltonian.distanceScale);
                ng.FileOutputSite(2);
                return;
            }
            TestAegean.testLouvain(a, args);
        }
    }

    public static void testLouvain(islandNetwork a, String[] args) {
        File ifl;
        System.out.println("\n *** testLouvain ***");
        a.inputFile.setAll("input/", "", "testaegean5", "", 0, "_input", "dat");
        if (args.length > 0) {
            a.Parse(args);
            ifl = new File(a.outputFile.getFullLocationFileName("", "anf"));
        } else {
            a.setOutputFileName();
            a.outputFile.sequenceNumber = 0;
            ifl = new File(a.outputFile.getFullLocationFileName("", "anf"));
        }
        System.out.println("Trying to read from " + ifl.getPath());
        islandNetwork firstData = new islandNetwork(ifl, a);
        firstData.calcNetworkStats();
        firstData.calcTransferMatrix(0, IslandEdge.valueINDEX);
        LouvainCommunity lc = new LouvainCommunity(firstData);
        lc.calcCommunity(0.5);
        lc.printCommunities(System.out, "", " | ");
    }

    public static void testGUIDirect(islandNetwork a) {
        a.outputMode.setAllOn();
        a.inputFile.setNameRoot("aegean39S1L3a");
        a.updateMode.setFromName("RW");
        a.betaInitial = 1.04;
        a.Hamiltonian.lambda = 1.0;
        a.Hamiltonian.distanceScale = 100.0;
        a.getSiteData();
        a.dataread = true;
        a.outputFile.setBasicRoot(a.inputFile.getBasicRoot());
        a.setOutputFileName();
        System.out.println("in TestAegean testGUIDirect before doMC");
        a.doRW();
        System.out.println("in TestAegean testGUIDirect before showNetwork");
        a.showNetwork("#", 3);
    }

    public static boolean testFileDecomposition() {
        FileLocation fl = new FileLocation("dirroot/", "subdir/", "nameroot", "paramname", 29, "eee", "ext");
        String f = fl.getFullLocationFileName();
        FileLocation fl2 = new FileLocation(f);
        System.out.println(fl2.getFullLocationFileName());
        return true;
    }

    public static void test5(islandNetwork a) {
        double beta;
        double zeroColourFrac = 0.35;
        double minColourFrac = 0.65;
        int siteSizeFactor = 10;
        int edgeWidthFactor = 5;
        a.DisplayMaxVertexScale = 1.0;
        a.edgeSet.DisplayMaxEdgeScale = 1.0;
        System.out.println("--- test5 routine: cooling MC, vertex and edge updates");
        a.showHamiltonianParameters();
        int estot = 10;
        int vstot = estot * a.numberSites;
        double betamin = 1000.0;
        double betamax = 1000000.0;
        double betafactor = 2.0;
        double updatefrac = 0.0;
        int betainc = 0;
        long initialtime = System.currentTimeMillis();
        for (beta = betamin; beta <= betamax; beta *= betafactor) {
            int i;
            a.vertexUR.reset();
            for (i = 0; i < vstot; ++i) {
                a.Hamiltonian.beta = beta;
                a.vertexSweep();
            }
            if (a.getInformationLevel() > 1) {
                System.out.println("b=" + beta + " : ");
            }
            a.edgeUR.reset();
            for (i = 0; i < estot; ++i) {
                a.Hamiltonian.beta = beta;
                a.edgeSweep();
            }
            if (++betainc % 10 == 0) {
                TestAegean.printEllapsedTime(initialtime);
                System.out.println(" b=" + beta + "\n  E: " + a.edgeUR.toString() + "\n  V: " + a.vertexUR.toString());
            } else {
                System.out.print(".");
            }
            if (a.vertexUR.getTotalFractionMade() < 0.001 && a.edgeUR.getTotalFractionMade() < 0.01) break;
        }
        System.out.println("\nFinal beta " + beta);
        System.out.println("**********************************************");
        a.showNetworkStatistics("#", System.out, 3);
        a.edgeSet.minColourFrac = 0.0;
        System.out.println("Minimum Fraction for coloured edge = " + minColourFrac);
        a.calcNetworkStats();
        a.showColourValues("#", 3);
        System.out.println("  Edge stats: " + a.edgeUR.toString());
        System.out.println("Vertex stats: " + a.vertexUR.toString());
        a.edgeSet.doDijkstra(a.siteSet.getSiteArray(), a.Hamiltonian.shortDistanceScale);
        a.showDijkstraValues("#", 3);
        a.edgeSet.minColourFrac = 0.0;
        a.edgeSet.zeroColourFrac = 0.1;
        System.out.println("Scale for largest vertices in .net file= " + a.DisplayMaxVertexScale);
        System.out.println("Scale for maximum edges in .net file = " + a.edgeSet.DisplayMaxEdgeScale);
        System.out.println("Minimum Fraction for coloured edge in .net file = " + minColourFrac);
        a.calcNetworkStats();
        a.FileOutputNetwork("#", siteSizeFactor, edgeWidthFactor, minColourFrac, zeroColourFrac, 0);
        a.FileOutputNetwork("#", siteSizeFactor, edgeWidthFactor, minColourFrac, zeroColourFrac, 1);
        a.FileOutputNetwork("#", siteSizeFactor, edgeWidthFactor, minColourFrac, zeroColourFrac, 2);
        a.FileOutputBareNetwork("#");
        a.FileOutputNetworkStatistics("#", 3);
    }

    public static void test4(islandNetwork a) {
        double zeroColourFrac = 0.1;
        double minColourFrac = 0.5;
        int siteSizeFactor = 10;
        int edgeWidthFactor = 10;
        System.out.println("--- test4 routine: cooling MC, vertex updates only");
        a.showHamiltonianParameters();
        int estot = 1000;
        double betamin = 0.01;
        double betamax = 100000.0;
        double betafactor = 1.2;
        double updatefrac = 0.0;
        for (double beta = betamin; beta <= betamax; beta *= betafactor) {
            a.vertexUR.reset();
            for (int i = 0; i < estot; ++i) {
                a.Hamiltonian.beta = beta;
                a.vertexSweep();
            }
            if (a.getInformationLevel() > 1) {
                System.out.println("b=" + beta + " : " + a.vertexUR.toString());
            }
            if (a.vertexUR.getTotalFractionMade() < 0.001) break;
        }
        System.out.println("**********************************************");
        a.showNetworkStatistics("#", System.out, 3);
        System.out.println("Minimum Fraction for coloured edge = " + minColourFrac);
        a.calcNetworkStats();
        a.showColourValues("#", 3);
        System.out.println(a.vertexUR.toString());
        minColourFrac = 0.5;
        System.out.println("Minimum Fraction for coloured edge in .net file = " + minColourFrac);
        a.FileOutputNetwork("#", siteSizeFactor, edgeWidthFactor, minColourFrac, zeroColourFrac, 1);
        a.FileOutputNetwork("#", siteSizeFactor, edgeWidthFactor, minColourFrac, zeroColourFrac, 2);
    }

    public static void test3(islandNetwork a) {
        double zeroColourFrac = 0.1;
        double minColourFrac = 0.0;
        int siteSizeFactor = 5;
        int edgeWidthFactor = 5;
        System.out.println("--- test3 routine: cooling MC, edge updates only");
        a.showHamiltonianParameters();
        int estot = 100;
        double betamin = 0.01;
        double betamax = 100000.0;
        double betafactor = 1.2;
        double updatefrac = 0.0;
        for (double beta = betamin; beta <= betamax; beta *= betafactor) {
            a.edgeUR.reset();
            for (int i = 0; i < estot; ++i) {
                a.Hamiltonian.beta = beta;
                a.edgeSweep();
            }
            System.out.println("b=" + beta + " : " + a.edgeUR.toString());
            if (a.edgeUR.getTotalFractionMade() < 0.01) break;
        }
        System.out.println("**********************************************");
        a.showNetworkStatistics("#", System.out, 3);
        a.edgeSet.minColourFrac = 0.0;
        minColourFrac = 0.0;
        System.out.println("Minimum Fraction for coloured edge = " + minColourFrac);
        a.calcNetworkStats();
        a.showColourValues("#", 3);
        System.out.println(a.edgeUR.toString());
        minColourFrac = 0.5;
        System.out.println("Minimum Fraction for coloured edge in .net file = " + minColourFrac);
        a.FileOutputNetwork("#", siteSizeFactor, edgeWidthFactor, minColourFrac, zeroColourFrac, 1);
        a.FileOutputNetwork("#", siteSizeFactor, edgeWidthFactor, minColourFrac, zeroColourFrac, 2);
    }

    public static void test2(islandNetwork a) {
        double zeroColourFrac = 0.1;
        double minColourFrac = 0.0;
        int siteSizeFactor = 5;
        int edgeWidthFactor = 5;
        a.showHamiltonianParameters();
        int estot = 100;
        for (int i = 0; i < estot; ++i) {
            a.edgeSweep();
        }
        System.out.println("Finished " + estot + " edge sweeps ");
        a.showNetworkStatistics("#", System.out, 3);
        System.out.println(a.edgeUR.toString());
        a.FileOutputNetwork("#", siteSizeFactor, edgeWidthFactor, minColourFrac, zeroColourFrac, 1);
        a.FileOutputNetwork("#", siteSizeFactor, edgeWidthFactor, minColourFrac, zeroColourFrac, 2);
    }

    public static void testPPA(islandNetwork a) {
        double zeroColourFrac = 0.1;
        double minColourFrac = 0.0;
        int siteSizeFactor = 5;
        int edgeWidthFactor = 5;
        System.out.println("Testing PPA mode");
        a.showHamiltonianParameters();
        a.doPPA();
        System.out.println("Finished PPA");
        a.edgeSet.doDijkstra(a.siteSet.getSiteArray(), a.Hamiltonian.shortDistanceScale);
        a.showDijkstraValues("#", 3);
        a.FileOutputNetwork("#", siteSizeFactor, edgeWidthFactor, minColourFrac, zeroColourFrac, 1);
        a.FileOutputNetwork("#", siteSizeFactor, edgeWidthFactor, minColourFrac, zeroColourFrac, 2);
    }

    public static void testDijkstra(islandNetwork a) {
        System.out.println("Testing Dijkstra");
        a.doPPA();
        a.edgeSet.doDijkstra(a.siteSet.getSiteArray(), a.Hamiltonian.shortDistanceScale);
        a.showDijkstraValues("#", 3);
    }

    public static void testModel4(islandNetwork a) {
        a.setEdgesTest1();
        int i = 0;
        int j = 5;
        double dh = a.deltaEdgeHamiltonian(i, j, 1.0);
        System.out.println("i,j,dH = " + i + " , " + j + " , " + dh);
    }

    public static void test1(islandNetwork a) {
    }

    public static void printEllapsedTime(long initialtime) {
        long finaltime = System.currentTimeMillis();
        long time = finaltime - initialtime;
        long ms = time % 1000L;
        long sec = (time /= 1000L) % 60L;
        long minutes = (time /= 60L) % 60L;
        long hours = (time /= 60L) % 24L;
        long days = time / 24L;
        if (days > 0L) {
            System.out.print(days + " day");
        }
        if (days > 1L) {
            System.out.print("s ");
        }
        if (hours > 0L) {
            System.out.print(hours + " hour");
        }
        if (hours > 1L) {
            System.out.print("s ");
        }
        if (minutes > 0L) {
            System.out.print(minutes + " minute");
        }
        if (minutes > 1L) {
            System.out.print("s ");
        }
        System.out.print(sec + " sec");
        if (sec > 1L) {
            System.out.print("s ");
        }
        System.out.println();
    }
}

