/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.SiteWindowMode;
import IslandNetworks.Vertex.IslandSiteSet;
import IslandNetworks.islandNetwork;
import TimUtilities.NumbersToString;
import TimUtilities.TimMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SitePanel
extends JPanel {
    final String inputFileNameRoot;
    static int smallC = 90;
    static int largeC = 210;
    static Color WEIGHTCOLOR = new Color(largeC, smallC, smallC);
    static Color RANKCOLOR = new Color(smallC, smallC, largeC);
    static Color INFLCOLOR = new Color(smallC, largeC, smallC);
    static NumbersToString n2s = new NumbersToString(3);
    int windowSize = 500;
    TimMessage message = new TimMessage(-2);
    IslandSiteSet siteSet;
    int numberSites;
    SiteWindowMode siteWindowMode;
    JCheckBox weightCB;
    JCheckBox rankCB;
    JCheckBox inflCB;

    public SitePanel(islandNetwork in) {
        this.inputFileNameRoot = in.inputFile.getNameRoot();
        this.numberSites = in.numberSites;
        this.siteSet = in.siteSet;
        this.siteWindowMode = in.siteWindowMode;
        this.message.println(2, "Finished SiteWindow constructor");
    }

    public Component createComponents() {
        SitePicture siteHistogram = new SitePicture(this.windowSize);
        siteHistogram.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        JScrollPane pane = new JScrollPane(siteHistogram, 20, 31);
        pane.setPreferredSize(new Dimension(400, 400));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.add((Component)pane, "Center");
        JPanel cp = this.sitePanelControl();
        panel.add((Component)cp, "East");
        return panel;
    }

    private JPanel sitePanelControl() {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(100, 200));
        JPanel keyPanel = new JPanel(new GridLayout(4, 1));
        keyPanel.add(new JLabel("Key (On?)", 0));
        this.weightCB = new JCheckBox("Weight", true);
        this.weightCB.setForeground(WEIGHTCOLOR);
        this.weightCB.setToolTipText("Weight Values Displayed");
        keyPanel.add(this.weightCB);
        this.rankCB = new JCheckBox("Rank", true);
        this.rankCB.setForeground(RANKCOLOR);
        this.rankCB.setToolTipText("Weight Values Displayed");
        keyPanel.add(this.rankCB);
        this.inflCB = new JCheckBox("Influence", false);
        this.inflCB.setForeground(INFLCOLOR);
        this.inflCB.setToolTipText("Weight Values Displayed");
        keyPanel.add(this.inflCB);
        final JComboBox<String> orderChooser = new JComboBox<String>();
        orderChooser.setToolTipText("Choose Order of Sites");
        for (int i = 0; i < SiteWindowMode.numberTypes; ++i) {
            orderChooser.addItem(this.siteWindowMode.getString(i));
        }
        orderChooser.setSelectedIndex(this.siteWindowMode.value);
        orderChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SitePanel.this.siteWindowMode.value = orderChooser.getSelectedIndex();
            }
        });
        panel.add(keyPanel);
        panel.add(orderChooser);
        return panel;
    }

    public class SitePicture
    extends JPanel {
        double windowScale;

        public SitePicture() {
            this.setMinimumSize(new Dimension(100, 100));
            this.setPreferredSize(new Dimension(400, 40 * SitePanel.this.numberSites));
        }

        public SitePicture(int xsize) {
            this.setOpaque(true);
            this.setMinimumSize(new Dimension(100, 100));
            this.setPreferredSize(new Dimension(xsize, 40 * SitePanel.this.numberSites));
        }

        public void init() {
            this.setSize(new Dimension(800, 400));
        }

        protected void paintComponent(Graphics ginput) {
            Graphics2D g = (Graphics2D)ginput;
            super.paintComponent(g);
            int borderSize = 50;
            double dns = SitePanel.this.numberSites;
            Dimension d = this.getSize();
            int textWidth = d.width / 5;
            double wsx = (double)(d.height - borderSize - borderSize) / dns;
            double wsWeight = (double)(d.width - borderSize - borderSize - textWidth) / SitePanel.this.siteSet.siteWeightStats.maximum;
            double wsInfl = (double)(d.width - borderSize - borderSize - textWidth) / SitePanel.this.siteSet.siteInfluenceStats.maximum;
            double wsRank = (double)(d.width - borderSize - borderSize - textWidth) / SitePanel.this.siteSet.siteRankStats.maximum;
            SitePanel.this.message.println(2, "Site Window scales " + wsx + "," + wsWeight + "," + wsRank + ", window = " + d.width + "," + d.height);
            SitePanel.this.message.println(2, " max site weight =" + SitePanel.this.siteSet.siteWeightStats.maximum + " max site rank=" + SitePanel.this.siteSet.siteRankStats.maximum);
            Font f = g.getFont();
            SitePanel.this.message.println(2, "Site Window Mode " + SitePanel.this.siteWindowMode.getCurrentTypeString() + ", font " + f.getName() + " " + f.getSize() + " " + f.getStyle());
            double numberBars = 0.0;
            if (SitePanel.this.weightCB.isSelected()) {
                numberBars += 1.0;
            }
            if (SitePanel.this.rankCB.isSelected()) {
                numberBars += 1.0;
            }
            if (SitePanel.this.inflCB.isSelected()) {
                numberBars += 1.0;
            }
            if (numberBars < 1.0) {
                numberBars = 1.0;
            }
            int width = (int)(wsx / numberBars) - 2;
            for (int iii = 0; iii < SitePanel.this.numberSites; ++iii) {
                String s;
                int w;
                int i = iii;
                switch (SitePanel.this.siteWindowMode.value) {
                    case 5: {
                        i = SitePanel.this.siteSet.siteInfluenceOrder[iii];
                        break;
                    }
                    case 4: {
                        i = SitePanel.this.siteSet.siteRankOverWeightOrder[iii];
                        break;
                    }
                    case 3: {
                        i = SitePanel.this.siteSet.siteAlphabeticalOrder[iii];
                        break;
                    }
                    case 2: {
                        i = SitePanel.this.siteSet.siteRankOrder[iii];
                        break;
                    }
                    case 1: {
                        i = SitePanel.this.siteSet.siteWeightOrder[iii];
                        break;
                    }
                    default: {
                        i = iii;
                    }
                }
                if (width < 1) {
                    width = 1;
                }
                int y = borderSize + (int)((double)iii * wsx) + 1;
                int x = borderSize + textWidth;
                int h = width;
                if (SitePanel.this.weightCB.isSelected()) {
                    w = (int)(wsWeight * SitePanel.this.siteSet.getWeight(i));
                    g.setColor(WEIGHTCOLOR);
                    g.fill(new Rectangle2D.Double(x, y, w, h));
                    s = String.format("%6.3f", SitePanel.this.siteSet.getWeight(i));
                    g.drawString(s, x + w, y + width / 2);
                    SitePanel.this.message.println(2, "Site " + i + " Rank " + SitePanel.this.siteSet.getRanking(i) + ", Rank rank " + SitePanel.this.siteSet.getRankingRank(i));
                    SitePanel.this.message.println(2, "Site " + i + " at (" + x + "," + y + ") width " + w + ", height " + h + " ");
                }
                if (SitePanel.this.rankCB.isSelected()) {
                    w = (int)(wsRank * SitePanel.this.siteSet.getRanking(i));
                    g.setColor(RANKCOLOR);
                    g.fill(new Rectangle2D.Double(x, y += width, w, h));
                    s = String.format("%6.3f", SitePanel.this.siteSet.getRanking(i));
                    g.drawString(s, x + w, y + width / 2);
                    SitePanel.this.message.println(2, "Site " + i + "=" + " at (" + x + "," + y + ") width " + w + ", height " + h + " ");
                }
                if (SitePanel.this.inflCB.isSelected()) {
                    w = (int)(wsInfl * SitePanel.this.siteSet.getTotalInfluenceWeight(i));
                    g.setColor(INFLCOLOR);
                    SitePanel.this.message.println(2, "Site " + i + "=" + " at (" + x + "," + (y += width) + ") width " + w + ", height " + h + " ");
                    g.fill(new Rectangle2D.Double(x, y, w, h));
                    s = String.format("%6.3f", SitePanel.this.siteSet.getTotalInfluenceWeight(i));
                    g.drawString(s, x + w, y + width / 2);
                }
                g.setColor(Color.black);
                g.drawString(String.format("%12s [%4.2f]", SitePanel.this.siteSet.getName(i), SitePanel.this.siteSet.getSize(i)), borderSize + 50, y + width);
                if (!SitePanel.this.siteSet.isRegionSet()) continue;
                g.setColor(Color.black);
                s = SitePanel.this.siteSet.getRegion(i);
                if (s.length() > 5) {
                    s = s.substring(0, 5);
                }
                g.drawString(" (" + s + ")", borderSize, y + width);
            }
        }
    }
}

