/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

public class ProbabilityDistance {
    static final double MAXDISTANCE = 1000000.0;
    static final double MAXPROBABILITY = 0.999999000001;
    static final double INFINITEDISTANCE = 2000000.0;
    static final double BADPROBABILITY = -1234.56789;
    static final double BADDISTANCE = -98765.4321;

    public static double probabilityToDistance(double p) {
        if (p < 0.0 || p > 1.0) {
            return -1234.56789;
        }
        if (p > 0.999999000001) {
            return 2000000.0;
        }
        return 1.0 / (1.0 - p);
    }

    public static String probabilityToDistanceString(double p) {
        return ProbabilityDistance.distanceString(ProbabilityDistance.probabilityToDistance(p));
    }

    public static double distanceToProbability(double d) {
        if (d < 0.0) {
            return -98765.4321;
        }
        return d / (1.0 + d);
    }

    public static String distanceString(double d) {
        if (d < 0.0) {
            return "Negative Distance";
        }
        if (d > 1000000.0) {
            return "Infinite Distance";
        }
        return Double.toString(d);
    }

    public static String probabilityString(double p) {
        if (p < 0.0) {
            return "Negative Probability";
        }
        if (p > 1.0) {
            return "Probability >1";
        }
        return Double.toString(p);
    }
}

