/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import java.io.PrintStream;

public class OutputMode {
    static final int UNIQUENAME = 3;
    private int number = 0;
    public static final String[] name = new String[]{"info", "pajek", "elist", "ematrix", "gsep", "anf", "KML"};
    static final String[] longName = new String[]{"general information", "pajek files", "edges as vector", "edges as matrix", "gene separation", "ariadne network file", "Google Earth KML network file"};
    static final int KMLIndex = OutputMode.getIndex("KML");
    static final int PajekIndex = OutputMode.getIndex("pajek");
    static final int EdgeListIndex = OutputMode.getIndex("elist");
    static final int EdgeMatrixIndex = OutputMode.getIndex("ematrix");
    static final int InfoIndex = OutputMode.getIndex("info");
    static final int GeneSeparationIndex = OutputMode.getIndex("gsep");
    static final int AriadneNetworkFileIndex = OutputMode.getIndex("anf");
    private int[] bit = new int[name.length];

    public OutputMode() {
        this.setUp(0);
    }

    public OutputMode(int newNumber) {
        this.setUp(newNumber);
    }

    public OutputMode(OutputMode old) {
        this.setUp(old.number);
    }

    private void setUp(int n) {
        this.bit[0] = 1;
        for (int m = 1; m < name.length; ++m) {
            this.bit[m] = this.bit[m - 1] << 1;
        }
        this.set(n);
    }

    public void set(double newNumber) {
        this.set(Math.round(newNumber));
    }

    public void set(int newNumber) {
        this.number = newNumber;
    }

    public void set(String newNumber) {
        this.set(Double.parseDouble(newNumber));
    }

    public void setAllOn() {
        this.number = (1 << name.length) - 1;
    }

    public void setAllOff() {
        this.number = 0;
    }

    public void setModeOn(String s) {
        this.setModeOn(OutputMode.getIndex(s));
    }

    public void setModeOn(int m) {
        if (this.testModeNumber(m)) {
            this.number |= this.bit[m];
        }
    }

    public void setModeOff(String s) {
        this.setModeOff(OutputMode.getIndex(s));
    }

    public void setModeOff(int m) {
        if (this.testModeNumber(m)) {
            this.number -= this.number & this.bit[m];
        }
    }

    private boolean testModeNumber(int m) {
        return m >= 0 && m < name.length;
    }

    public boolean isSet(int m) {
        if (m < 0 || m >= name.length) {
            return false;
        }
        return (this.bit[m] & this.number) > 0;
    }

    public int getNumber() {
        return this.number;
    }

    public static int getIndex(String input) {
        String s = input.substring(0, 3);
        for (int v = 0; v < name.length; ++v) {
            if (!name[v].startsWith(s)) continue;
            return v;
        }
        return -1;
    }

    public void print(PrintStream PS, String cc) {
        PS.println(cc + " Output mode is " + this.getNumber());
    }

    public String toString(String sep) {
        String s = "";
        for (int m = 0; m < name.length; ++m) {
            if (!this.isSet(m)) continue;
            s = s + name[m] + sep;
        }
        return s;
    }

    public void listAll(PrintStream PS, String cc, String sep) {
        for (int m = 0; m < name.length; ++m) {
            PS.println(cc + this.bit[m] + sep + longName[m] + " (" + name[m] + ")");
        }
    }

    public String longString(int m) {
        return longName[m];
    }
}

