/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.AriadneIcon;
import IslandNetworks.ClusteringWindow;
import IslandNetworks.InputParameterFrame;
import IslandNetworks.IslandParameterWindow;
import IslandNetworks.OutputMode;
import IslandNetworks.SitePanel;
import IslandNetworks.islandNetwork;
import IslandNetworks.licence;
import TimUtilities.FileUtilities.FileUtilities;
import TimUtilities.FileUtilities.GeneralExtensionFilter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Calendar;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class NetworkWindow {
    private final String CLUSTERBUTTONTYPE = "CB_";
    private final String LAYOUTBUTTONTYPE = "LB_";
    private final String ARIADNENETWORKFILEEXTENSION = "anf";
    FileUtilities fileUtilities = new FileUtilities();
    JFrame frame;
    islandNetwork islnet;
    Dimension windowSize = new Dimension(900, 700);

    public NetworkWindow(islandNetwork islnetinput) {
        this.islnet = new islandNetwork(islnetinput);
        this.islnet.message.println(2, "Finished NetworkWindow constructor, root of file names " + this.islnet.inputFile.getNameRoot());
    }

    public void drawNetworkWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NetworkWindow.this.createAndShowNetWin();
            }
        });
    }

    private void createAndShowNetWin() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.islnet.message.println(0, " Ariadne Network Display " + this.windowSize);
        Calendar cal = Calendar.getInstance();
        String time = cal.get(10) + ":" + cal.get(12) + ":" + cal.get(13) + "." + cal.get(14);
        this.frame = new JFrame("Network " + this.islnet.getNameString(" ") + " " + time);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setIconImage(new AriadneIcon().getPotGreen16());
        this.frame.setSize(new Dimension(this.islnet.visualisationWidth, this.islnet.visualisationHeight));
        this.frame.setJMenuBar(this.createMenuBar());
        JTabbedPane tabbedPane = new JTabbedPane();
        ClusteringWindow cw = new ClusteringWindow(this.islnet, this.frame.getSize());
        tabbedPane.addTab("Network", NetworkWindow.createImageIcon("images/network.gif"), cw, "Shows Network");
        tabbedPane.setSelectedIndex(0);
        SitePanel sp = new SitePanel(this.islnet);
        tabbedPane.addTab("Sites", NetworkWindow.createImageIcon("images/rsplat.gif"), sp.createComponents(), "Shows Site Information");
        JPanel tabParam = new JPanel();
        tabParam.setLayout(new BoxLayout(tabParam, 1));
        IslandParameterWindow IPW = new IslandParameterWindow(this.islnet);
        tabParam.add(IPW.getBasicSettingsPanel());
        tabParam.add(IPW.getInputVariablesPanel());
        tabParam.add(IPW.getOutputMeasuresPanel(3));
        tabbedPane.addTab("Parameters", NetworkWindow.createImageIcon("images/ysplat.gif"), tabParam, "Shows Parameters");
        this.frame.getContentPane().add(tabbedPane);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private JMenuBar createMenuBar() {
        MenuListener menuLister = new MenuListener();
        OutputCheckBoxMenuListener outputCheckBoxMenuListener = new OutputCheckBoxMenuListener();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.getAccessibleContext().setAccessibleDescription("Manipulate the network File");
        menuBar.add(fileMenu);
        JMenuItem openFileItem = new JMenuItem("Open", 79);
        openFileItem.getAccessibleContext().setAccessibleDescription("Opens a Network File");
        openFileItem.addActionListener(menuLister);
        fileMenu.add(openFileItem);
        JMenuItem nextFileItem = new JMenuItem("Next", 78);
        nextFileItem.getAccessibleContext().setAccessibleDescription("Gets next network file in sequence");
        nextFileItem.addActionListener(menuLister);
        fileMenu.add(nextFileItem);
        fileMenu.addSeparator();
        JCheckBoxMenuItem[] cbMenuItem = new JCheckBoxMenuItem[OutputMode.name.length];
        for (int i = 0; i < OutputMode.name.length; ++i) {
            cbMenuItem[i] = new JCheckBoxMenuItem(OutputMode.name[i], this.islnet.outputMode.isSet(i));
            cbMenuItem[i].setToolTipText(OutputMode.longName[i]);
            cbMenuItem[i].addActionListener(outputCheckBoxMenuListener);
            fileMenu.add(cbMenuItem[i]);
        }
        JMenu menu = new JMenu("Network View");
        menu.getAccessibleContext().setAccessibleDescription("The only menu in this program that has menu items");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("A text-only menu item");
        menuItem.getAccessibleContext().setAccessibleDescription("This doesn't really do anything");
        menu.add(menuItem);
        ImageIcon icon = NetworkWindow.createImageIcon("images/middle.gif");
        menuItem = new JMenuItem("Both text and icon", icon);
        menuItem.setMnemonic(66);
        menu.add(menuItem);
        menuItem = new JMenuItem(icon);
        menuItem.setMnemonic(68);
        menu.add(menuItem);
        menu.addSeparator();
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem("A radio button menu item");
        rbMenuItem.setSelected(true);
        rbMenuItem.setMnemonic(82);
        group.add(rbMenuItem);
        menu.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem("Another one");
        rbMenuItem.setMnemonic(79);
        group.add(rbMenuItem);
        menu.add(rbMenuItem);
        menu.addSeparator();
        JMenu submenu = new JMenu("A submenu");
        menuItem = new JMenuItem("An item in the submenu");
        submenu.add(menuItem);
        menuItem = new JMenuItem("Another item");
        submenu.add(menuItem);
        menu.add(submenu);
        menu = new JMenu("Another Menu");
        menu.getAccessibleContext().setAccessibleDescription("This menu does nothing");
        menuBar.add(menu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        helpMenu.getAccessibleContext().setAccessibleDescription("Help on Ariadne");
        menuBar.add(helpMenu);
        JMenuItem aboutHelpItem = new JMenuItem("About", 65);
        aboutHelpItem.getAccessibleContext().setAccessibleDescription("About Ariadne");
        aboutHelpItem.addActionListener(menuLister);
        helpMenu.add(aboutHelpItem);
        JMenuItem helpHelpItem = new JMenuItem("Help", 72);
        helpHelpItem.getAccessibleContext().setAccessibleDescription("Help for Ariadne");
        helpHelpItem.addActionListener(menuLister);
        helpMenu.add(helpHelpItem);
        return menuBar;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = NetworkWindow.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    class MenuListener
    implements ActionListener {
        MenuListener() {
        }

        public void actionPerformed(ActionEvent event) {
            try {
                String command = event.getActionCommand();
                if (command.equals("Open")) {
                    JFileChooser fc = new JFileChooser(".");
                    fc.addChoosableFileFilter((FileFilter)new GeneralExtensionFilter("anf"));
                    fc.setAcceptAllFileFilterUsed(false);
                    fc.setDialogTitle("Open Ariadne Network File");
                    int returnVal = fc.showOpenDialog(NetworkWindow.this.frame);
                    if (returnVal == 0) {
                        File fl = fc.getSelectedFile();
                        NetworkWindow.this.islnet = new islandNetwork(fl, NetworkWindow.this.islnet);
                        NetworkWindow.this.islnet.calcNetworkStats();
                        NetworkWindow.this.createAndShowNetWin();
                    }
                }
                if (command.equals("Next")) {
                    NetworkWindow.this.islnet.outputFile.setNextExistingSequenceNumber();
                    NetworkWindow.this.islnet = new islandNetwork(NetworkWindow.this.islnet.outputFile.getFullLocationFile(), NetworkWindow.this.islnet);
                    NetworkWindow.this.islnet.calcNetworkStats();
                    NetworkWindow.this.createAndShowNetWin();
                }
                if (command.equals("New")) {
                    islandNetwork islnetnew = new islandNetwork(NetworkWindow.this.islnet);
                    InputParameterFrame ipf = new InputParameterFrame(islnetnew);
                }
                if (command.equals("About")) {
                    licence.showCiteMessageDialog(NetworkWindow.this.frame);
                }
                if (command.equals("Help")) {
                    JOptionPane.showMessageDialog(NetworkWindow.this.frame, "<html>Look in the <tt>ariadne/docs</tt> folder.</html>", "Help", 1);
                }
            }
            catch (Exception e) {
                String resMessage = "Ariadne Error: " + event;
                JOptionPane.showMessageDialog(NetworkWindow.this.frame, resMessage, "Open File Error", 0);
            }
        }
    }

    class OutputCheckBoxMenuListener
    implements ActionListener {
        OutputCheckBoxMenuListener() {
        }

        public void actionPerformed(ActionEvent event) {
            try {
                String command = event.getActionCommand();
                JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)event.getSource();
                if (toggle.isSelected()) {
                    NetworkWindow.this.islnet.outputMode.setModeOn(command);
                } else {
                    NetworkWindow.this.islnet.outputMode.setModeOff(command);
                }
            }
            catch (Exception e) {
                String resMessage = "Ariadne Error in OutputCheckBoxMenuListener of NetworkWindow: " + event;
                JOptionPane.showMessageDialog(NetworkWindow.this.frame, resMessage, " some sort of error", 0);
            }
        }
    }
}

