/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.islandNetwork;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class NetworkGenerator {
    String SEP = "\t";
    String dirname = "/PRG/networks/aegean/output/";
    String nameroot = "test";
    int NUMBERTYPES = 5;
    int numberSites;
    double scale;
    double[] Xpos;
    double[] Ypos;
    double[][] dist;
    String[] name;
    String[] shortname;
    int networkType = 0;
    double sizex = 1.0;
    double sizey = 1.0;

    public NetworkGenerator() {
    }

    public NetworkGenerator(islandNetwork a) {
        this.create(a.generateType, a.generateNumber, a.Hamiltonian.distanceScale);
    }

    public NetworkGenerator(int inputType, int number, double inputscale) {
        this.create(inputType, number, inputscale);
    }

    public void create(int inputType, int number, double inputscale) {
        this.networkType = inputType;
        this.scale = inputscale;
        System.out.println("Generating type " + this.networkName() + ", number of sites " + number + ", nearest neighbour distance " + this.scale);
        switch (this.networkType) {
            case 4: {
                this.makeCircleSiteData(number, this.scale);
                break;
            }
            case 2: 
            case 3: {
                this.makeLineSiteData(number, this.scale);
                break;
            }
            default: {
                this.makeLatticeSiteData(number, number, this.scale);
            }
        }
        this.calcDistanceData();
    }

    public void makeLatticeSiteData(int xnumber, int ynumber, double scale) {
        this.sizex = scale * (double)xnumber;
        this.sizey = scale * (double)ynumber;
        int ns = xnumber * ynumber;
        this.Xpos = new double[ns];
        this.Ypos = new double[ns];
        this.name = new String[ns];
        this.shortname = new String[ns];
        this.nameroot = this.networkName() + "_" + xnumber + "_" + ynumber + "_" + this.TruncDec(scale, 2) + "_";
        this.numberSites = 0;
        for (int x = 0; x < xnumber; ++x) {
            for (int y = 0; y < ynumber; ++y) {
                this.name[this.numberSites] = "(" + x + "," + y + ")";
                this.shortname[this.numberSites] = Integer.toString(x * ynumber + y);
                this.Xpos[this.numberSites] = (double)x * scale;
                this.Ypos[this.numberSites] = (double)y * scale;
                ++this.numberSites;
            }
        }
    }

    public void makeLineSiteData(int xnumber, double scale) {
        this.sizex = scale * (double)xnumber;
        int ns = xnumber;
        this.Xpos = new double[ns];
        this.Ypos = new double[ns];
        this.name = new String[ns];
        this.shortname = new String[ns];
        this.nameroot = this.networkName() + "_" + xnumber + "_" + this.TruncDec(scale, 2) + "_";
        this.numberSites = 0;
        for (int x = 0; x < xnumber; ++x) {
            this.name[this.numberSites] = "(" + x + ")";
            this.shortname[this.numberSites] = Integer.toString(x);
            this.Xpos[this.numberSites] = (double)x * scale;
            this.Ypos[this.numberSites] = scale / 2.0;
            ++this.numberSites;
        }
    }

    public void makeCircleSiteData(int number, double scale) {
        int ns = number;
        this.Xpos = new double[ns];
        this.Ypos = new double[ns];
        this.name = new String[ns];
        this.shortname = new String[ns];
        double theta = Math.PI * 2 / (double)number;
        double radius = scale / Math.tan(theta / 2.0);
        this.nameroot = this.networkName() + "_" + number + "_" + this.TruncDec(scale, 2);
        this.numberSites = 0;
        for (int x = 0; x < number; ++x) {
            this.name[this.numberSites] = "(" + x + ")";
            this.shortname[this.numberSites] = Integer.toString(x);
            this.Xpos[this.numberSites] = radius * Math.sin(theta * (double)x);
            this.Ypos[this.numberSites] = radius * Math.cos(theta * (double)x);
            ++this.numberSites;
        }
    }

    public void calcDistanceData() {
        this.dist = new double[this.numberSites][this.numberSites];
        for (int i = 0; i < this.numberSites; ++i) {
            block4: for (int j = 0; j < this.numberSites; ++j) {
                switch (this.networkType) {
                    case 1: 
                    case 3: {
                        this.dist[i][j] = this.torusDistance(this.Xpos[i], this.Ypos[i], this.Xpos[j], this.Ypos[j]);
                        continue block4;
                    }
                    default: {
                        this.dist[i][j] = this.euclideanDistance(this.Xpos[i], this.Ypos[i], this.Xpos[j], this.Ypos[j]);
                    }
                }
            }
        }
    }

    public double euclideanDistance(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double torusDistance(double x1, double y1, double x2, double y2) {
        double dx = Math.min(Math.abs(x1 - x2), this.sizex - Math.abs(x1 - x2));
        double dy = Math.min(Math.abs(y1 - y2), this.sizey - Math.abs(y1 - y2));
        return Math.sqrt(dx * dx + dy * dy);
    }

    public void FileOutputSite(int dec) {
        String cc = "# ";
        String filenamecomplete = this.dirname + this.nameroot + "_input.dat";
        System.out.println("Attempting to write general information to " + filenamecomplete);
        try {
            int i;
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            PS.println("# " + this.SEP + this.networkName() + this.SEP + "Scale" + this.SEP + this.scale);
            PS.print("Name");
            for (i = 0; i < this.numberSites; ++i) {
                PS.print(this.SEP + this.name[i]);
            }
            PS.println();
            PS.print("ShortName");
            for (i = 0; i < this.numberSites; ++i) {
                PS.print(this.SEP + this.shortname[i]);
            }
            PS.println();
            PS.print("Size");
            for (i = 0; i < this.numberSites; ++i) {
                PS.print(this.SEP + "1");
            }
            PS.println();
            PS.print("XPos");
            for (i = 0; i < this.numberSites; ++i) {
                PS.print(this.SEP + this.Xpos[i]);
            }
            PS.println();
            PS.print("YPos");
            for (i = 0; i < this.numberSites; ++i) {
                PS.print(this.SEP + this.Ypos[i]);
            }
            PS.println();
            PS.println("*Distances");
            for (i = 0; i < this.numberSites; ++i) {
                PS.print(this.name[i]);
                for (int j = 0; j < this.numberSites; ++j) {
                    PS.print(this.SEP + this.dist[i][j]);
                }
                PS.println();
            }
            try {
                fout.close();
                System.out.println("Finished writing to " + filenamecomplete);
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    public String networkName() {
        return this.networkName(this.networkType);
    }

    public String networkName(int type) {
        String s = "Unknown";
        switch (type) {
            case 4: {
                s = "circle";
                break;
            }
            case 3: {
                s = "torus1D";
                break;
            }
            case 2: {
                s = "line";
                break;
            }
            case 1: {
                s = "torus2D";
                break;
            }
            default: {
                s = "lattice";
            }
        }
        return s;
    }

    public double TruncDec(double value, int dec) {
        double shift = Math.pow(10.0, dec);
        return (double)((int)(value * shift + 0.5)) / shift;
    }
}

