/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.ClusteringWindow;
import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.io.FileLocation;
import IslandNetworks.islandNetwork;
import JavaNotes.TextReader;
import TimUtilities.Range;
import TimUtilities.StatisticalQuantity;
import TimUtilities.TimTime;
import TimUtilities.TimTiming;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;

public class MultipleAnalysis {
    static String MAVERSION = "MA080429";
    static String SEP = "\t";
    static int NRUNS = 100;
    int nentries;
    int noprentries;
    static int nfixedparameters = 5;
    static int nsingleouputparameters = 1;
    final int noutputvariables;
    static int[] metricList = new int[]{1, 2, 3, 4};
    String endingMAStats;
    double[][] results;
    String firstLine = "";
    String[] parameterString = new String[100];
    int nargs = 0;
    Range j;
    Range mu;
    Range kappa;
    Range lambda;
    Range distScale;
    int repeat;
    int runOffset;
    boolean fileOutputStatisticsStarted = false;

    public MultipleAnalysis() {
        islandNetwork in = new islandNetwork(1);
        this.noutputvariables = 5 + metricList.length;
        this.j = new Range(in.Hamiltonian.vertexSource);
        this.mu = new Range(in.Hamiltonian.edgeSource);
        this.kappa = new Range(in.Hamiltonian.kappa);
        this.lambda = new Range(in.Hamiltonian.lambda);
        this.distScale = new Range(in.Hamiltonian.distanceScale);
        this.repeat = 1;
        this.runOffset = in.outputFile.sequenceNumber;
        this.noprentries = nfixedparameters + nsingleouputparameters + 4 * this.noutputvariables;
        this.nentries = nfixedparameters + 5 * (nsingleouputparameters + this.noutputvariables);
        TimTime time = new TimTime("_");
        this.endingMAStats = "_MAstats" + time.fullString("_");
        this.fileOutputStatisticsStarted = false;
    }

    public static void main(String[] args) {
        islandNetwork a = new islandNetwork(1);
        a.inputFile.setNameRoot("aegean39S1L3a");
        a.outputFile.setNameRoot("aegean39S1L3a");
        a.outputMode.setAllOff();
        int res = a.Parse(args);
        if (res > 0) {
            System.out.println("Command line argument failure - return code " + res);
            return;
        }
        res = a.getSiteData();
        System.out.println("Data reading OK, number of sites is " + a.numberSites);
        a.setInfomationLevel(-1);
        MultipleAnalysis ma = new MultipleAnalysis();
        ma.readVariableRanges(a.inputFile.getFullLocationFileRoot());
        a.outputFile.setParameterName("v" + a.modelNumber.major + "_" + a.modelNumber.minor);
        ma.calcRange(a);
    }

    public void calcRange(islandNetwork a) {
        System.out.println("\n###  Multiple Analysis version " + MAVERSION + " using islandNetwork " + "iN110401");
        if (this.nargs > 0) {
            String[] argList = new String[this.nargs];
            for (int iii = 0; iii < this.nargs; ++iii) {
                argList[iii] = this.parameterString[iii];
            }
            if (a.Parse(argList) != 0) {
                System.out.println("\n***  Error in parameter parsing");
                return;
            }
        }
        this.runOffset = a.outputFile.sequenceNumber;
        System.out.println(" Using  " + nfixedparameters + " fixed parameters, " + this.noutputvariables + " output variables");
        int nrunsmax = this.j.count() * this.mu.count() * this.kappa.count() * this.lambda.count() * this.distScale.count() + 1;
        System.out.println(" Doing " + nrunsmax + " different data sets, each repeated " + this.repeat + " times");
        System.out.println("Variable" + SEP + "min" + SEP + "max" + SEP + "step" + SEP + "value" + SEP + "Type" + SEP + "count");
        System.out.println("j" + SEP + this.j.toString(SEP));
        System.out.println("mu" + SEP + this.mu.toString(SEP));
        System.out.println("kappa" + SEP + this.kappa.toString(SEP));
        System.out.println("lambda" + SEP + this.lambda.toString(SEP));
        System.out.println("distance scale" + SEP + this.distScale.toString(SEP));
        this.results = new double[NRUNS][this.nentries];
        int nruns = 0;
        int noutputs = 0;
        this.setLabelLine();
        a.autoSetOutputFileName = true;
        TimTiming timeEllapsed = new TimTiming();
        this.j.value = this.j.min;
        while (this.j.value <= this.j.max) {
            a.Hamiltonian.vertexSource = this.j.value;
            this.mu.value = this.mu.min;
            while (this.mu.value <= this.mu.max) {
                a.Hamiltonian.edgeSource = this.mu.value;
                this.kappa.value = this.kappa.min;
                while (this.kappa.value <= this.kappa.max) {
                    a.Hamiltonian.kappa = this.kappa.value;
                    this.lambda.value = this.lambda.min;
                    while (this.lambda.value <= this.lambda.max) {
                        a.Hamiltonian.lambda = this.lambda.value;
                        this.distScale.value = this.distScale.min;
                        while (this.distScale.value <= this.distScale.max) {
                            a.Hamiltonian.distanceScale = this.distScale.value;
                            int setNumber = nruns + noutputs * NRUNS;
                            double frac = ((double)nruns + (double)(noutputs * NRUNS)) / (double)nrunsmax;
                            System.out.println("\n #####################################################");
                            System.out.println("--- Starting data set #" + setNumber + ", fraction completed " + Math.round(frac * 100.0) + "% , time remaining " + timeEllapsed.estimateRemainingTimeString(frac));
                            if (nruns >= NRUNS) {
                                this.j.value = this.j.max;
                                this.mu.value = this.mu.max;
                                this.kappa.value = this.kappa.max;
                                this.lambda.value = this.lambda.max;
                                this.distScale.value = this.distScale.max;
                                System.out.println(" Reached limit of number of runs");
                                break;
                            }
                            a.showHamiltonianParameters();
                            a.outputFile.setFirstFreeSequenceNumber(this.runOffset);
                            try {
                                double[] resArray = this.calcOneParameterSet(a, this.repeat);
                                for (int i = 0; i < resArray.length; ++i) {
                                    this.results[nruns][i] = resArray[i];
                                }
                            }
                            catch (Exception e) {
                                System.err.println("ERROR " + e + SEP + " run number " + nruns);
                            }
                            System.out.println("--- Finished data for data set #" + nruns);
                            if (++nruns == NRUNS) {
                                this.FileOutputStatistics(a.outputFile, nruns);
                                nruns = 0;
                                ++noutputs;
                            }
                            this.distScale.nextValue();
                        }
                        this.lambda.nextValue();
                    }
                    this.kappa.nextValue();
                }
                this.mu.nextValue();
            }
            this.j.nextValue();
        }
        if (nruns % NRUNS != 0) {
            this.FileOutputStatistics(a.outputFile, nruns);
        }
    }

    public String getLabelLine() {
        this.setLabelLine();
        return this.firstLine;
    }

    public void setLabelLine() {
        this.firstLine = "j" + SEP + "mu" + SEP + "kappa" + SEP + "lambda" + SEP + "dist.scale";
        this.firstLine = this.firstLine + this.variableLabel("En", SEP);
        this.firstLine = this.firstLine + this.variableLabel("SV", SEP);
        this.firstLine = this.firstLine + this.variableLabel("SW", SEP);
        this.firstLine = this.firstLine + this.variableLabel("SS", SEP);
        this.firstLine = this.firstLine + this.variableLabel("EV", SEP);
        this.firstLine = this.firstLine + this.variableLabel("EW", SEP);
        for (int m = 0; m < metricList.length; ++m) {
            this.firstLine = this.firstLine + this.variableLabel("D" + metricList[m], SEP);
        }
        this.firstLine = this.firstLine + SEP + "Version" + SEP + MAVERSION + "iN Version" + SEP + "iN110401";
    }

    public double[] calcOneParameterSet(islandNetwork a, int numberRuns) {
        int iii;
        int m;
        double betaInitial = a.Hamiltonian.beta;
        StatisticalQuantity[] oneParameterResults = new StatisticalQuantity[this.noprentries];
        for (int i = 0; i < this.noprentries; ++i) {
            oneParameterResults[i] = new StatisticalQuantity();
        }
        for (int r = 0; r < numberRuns; ++r) {
            System.out.println("--- Run #" + r);
            a.Hamiltonian.beta = betaInitial;
            a.setOutputFileName();
            try {
                a.doMC();
                int entry = 0;
                oneParameterResults[entry++].add(a.Hamiltonian.vertexSource);
                oneParameterResults[entry++].add(a.Hamiltonian.edgeSource);
                oneParameterResults[entry++].add(a.Hamiltonian.kappa);
                oneParameterResults[entry++].add(a.Hamiltonian.lambda);
                oneParameterResults[entry++].add(a.Hamiltonian.distanceScale);
                if (entry != nfixedparameters) {
                    System.out.println(" *** ERROR had " + entry + " parameters when expected " + nfixedparameters);
                    return null;
                }
                oneParameterResults[entry++].add(a.globalProperties.getEnergy());
                this.addToStatisticalQuantityArray(oneParameterResults, entry, a.siteSet.siteValueStats);
                this.addToStatisticalQuantityArray(oneParameterResults, entry, a.siteSet.siteWeightStats);
                this.addToStatisticalQuantityArray(oneParameterResults, entry, a.siteSet.siteStrengthInStats);
                this.addToStatisticalQuantityArray(oneParameterResults, entry, a.edgeSet.edgeStats[IslandEdge.valueINDEX]);
                this.addToStatisticalQuantityArray(oneParameterResults, entry, a.edgeSet.edgeStats[IslandEdge.weightINDEX]);
                a.setEdgePotentials();
                for (m = 0; m < metricList.length; ++m) {
                    a.edgeSet.metric.set(metricList[m]);
                    a.calcNetworkSeparations();
                    this.addToStatisticalQuantityArray(oneParameterResults, entry, a.siteDistanceStats);
                }
            }
            catch (Exception e) {
                System.out.println("*** Problem with run " + r + " - exception " + e);
            }
            try {
                if (r == 0) {
                    this.oneNetworkFileOutput(r, a, true);
                    continue;
                }
                this.oneNetworkFileOutput(r, a, false);
                continue;
            }
            catch (Exception e) {
                System.out.println("*** Problem with general network file outputs, run " + r + " - exception " + e);
            }
        }
        double[] oneResultSet = new double[this.nentries];
        int entry = 0;
        int oprentry = 0;
        for (iii = 0; iii < nfixedparameters; ++iii) {
            try {
                oneResultSet[entry++] = oneParameterResults[oprentry++].getAverage();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("ERROR: " + entry + " " + oprentry);
            }
        }
        oneResultSet[entry++] = oneParameterResults[oprentry].minimum;
        oneResultSet[entry++] = oneParameterResults[oprentry].maximum;
        oneResultSet[entry++] = oneParameterResults[oprentry].getAverage();
        oneResultSet[entry++] = oneParameterResults[oprentry].getError();
        oneResultSet[entry++] = oneParameterResults[oprentry++].getSigma();
        for (iii = 1; iii < 5; ++iii) {
            oneResultSet[entry++] = oneParameterResults[oprentry++].getAverage();
            oneResultSet[entry++] = oneParameterResults[oprentry++].getAverage();
            oneResultSet[entry++] = oneParameterResults[oprentry].getAverage();
            oneResultSet[entry++] = oneParameterResults[oprentry++].getError();
            oneResultSet[entry++] = oneParameterResults[oprentry++].getAverage();
        }
        for (m = 0; m < metricList.length; ++m) {
            a.edgeSet.metric.set(metricList[m]);
            a.calcNetworkSeparations();
            oneResultSet[entry++] = oneParameterResults[oprentry++].getAverage();
            oneResultSet[entry++] = oneParameterResults[oprentry++].getAverage();
            oneResultSet[entry++] = oneParameterResults[oprentry].getAverage();
            oneResultSet[entry++] = oneParameterResults[oprentry++].getError();
            oneResultSet[entry++] = oneParameterResults[oprentry++].getAverage();
        }
        this.nentries = entry;
        return oneResultSet;
    }

    private int addToStatisticalQuantityArray(StatisticalQuantity[] oneParameterResults, int entry, StatisticalQuantity sq) {
        oneParameterResults[entry++].add(sq.minimum);
        oneParameterResults[entry++].add(sq.maximum);
        oneParameterResults[entry++].add(sq.getAverage());
        oneParameterResults[entry++].add(sq.getSigma());
        return entry;
    }

    public void FileOutputStatistics(FileLocation fl, int count) {
        String filenamecomplete = fl.getRootLocationSimpleFileName(this.endingMAStats, "dat");
        System.out.println("Attempting to write general information to " + filenamecomplete);
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete, this.fileOutputStatisticsStarted);
            PrintStream PS = new PrintStream(fout);
            if (!this.fileOutputStatisticsStarted) {
                PS.println(this.firstLine);
            }
            this.printStatistics(PS, count);
            try {
                fout.close();
                System.out.println("Finished writing to " + filenamecomplete);
            }
            catch (IOException e) {
                System.out.println("File Error" + e);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete + "  Error" + e);
            return;
        }
        this.fileOutputStatisticsStarted = true;
    }

    public void printStatistics(PrintStream PS, int count) {
        for (int i = 0; i < count; ++i) {
            for (int i2 = 0; i2 < this.nentries; ++i2) {
                PS.print((float)this.results[i][i2] + SEP);
            }
            PS.println();
        }
    }

    public void printOneParameterStatistics(PrintStream PS, String sep, double[] results) {
        PS.println(this.getLabelLine());
        for (int i2 = 0; i2 < results.length; ++i2) {
            PS.print((float)results[i2] + sep);
        }
        PS.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readVariableRanges(String nameroot) {
        TextReader data;
        String filename = new String();
        filename = nameroot + "_maranges.dat";
        System.out.println("Starting to read ranges of parameters data from " + filename);
        String tempstring = "";
        String datatype = "Unknown";
        int linenumber = 0;
        double[] darray = new double[100];
        try {
            data = new TextReader(new FileReader(filename));
        }
        catch (FileNotFoundException e) {
            System.out.println("Can't find file " + filename);
            return 1;
        }
        try {
            while (!data.eof()) {
                ++linenumber;
                datatype = data.getWord();
                if (datatype.startsWith("#")) {
                    tempstring = datatype + data.getln();
                    System.out.println("Comment: " + tempstring);
                    continue;
                }
                if (datatype.startsWith("*param")) {
                    this.nargs = 0;
                    while (!data.eoln()) {
                        this.parameterString[this.nargs++] = data.getWord();
                    }
                    System.out.print("Parameter string: ");
                    for (int iii = 0; iii < this.nargs; ++iii) {
                        System.out.print(SEP + this.parameterString[iii]);
                    }
                    System.out.println();
                    continue;
                }
                if (datatype.startsWith("*rep")) {
                    this.repeat = data.getlnInt();
                    System.out.println("Repeating " + this.repeat + " times");
                    continue;
                }
                Range r = new Range();
                r.min = data.getDouble();
                r.max = data.getDouble();
                r.step = data.getDouble();
                r.type = data.getInt();
                if (r.min > r.max || r.step < 0.0) {
                    double v = r.min;
                    r = new Range(v);
                }
                if (datatype.startsWith("*j")) {
                    this.j = new Range(r);
                }
                if (datatype.startsWith("*mu")) {
                    this.mu = new Range(r);
                }
                if (datatype.startsWith("*kap")) {
                    this.kappa = new Range(r);
                }
                if (datatype.startsWith("*lam")) {
                    this.lambda = new Range(r);
                }
                if (!datatype.startsWith("*dist")) continue;
                this.distScale = new Range(r);
            }
            System.out.println("Finished reading from " + filename);
        }
        catch (TextReader.Error e) {
            System.out.println("Input Error: " + e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Too many numbers in data file" + filename);
            System.out.println("Processing has been aborted.");
        }
        finally {
            data.close();
        }
        return 0;
    }

    public void oneNetworkFileOutput(int run, islandNetwork in, boolean infoFileOutput) {
        if (infoFileOutput) {
            System.out.println("Attempting to write general information to " + in.outputFile.getNameRoot());
            in.FileOutputNetworkParam(SEP, run);
        }
        int siteWeightFactor = 20;
        int edgeWidthFactor = 10;
        double minColourFrac = 0.2;
        double zeroColourFrac = 0.1;
        boolean fileType = false;
        System.out.println("Attempting to write basic network to " + in.outputFile.getFullFileRoot());
        in.FileOutputNetworkForData("#", 5);
        in.FileOutputNetwork("#", siteWeightFactor, edgeWidthFactor, minColourFrac, zeroColourFrac, 0);
        String[] pn = new String[]{"Value", "Weight", "Ranking", "Strength", "StrengthIn", "StrengthOut"};
        for (int i = 0; i < pn.length; ++i) {
            in.FileOutputPajekSiteFiles(pn[i]);
        }
    }

    public void oneNetworkJpegOutput(int run, islandNetwork in) {
        ClusteringWindow cw = new ClusteringWindow();
        cw.initialiseClusteringWindow(in, 600);
        cw.setUpPrintableView(600, 600);
        cw.writeJPEGImage();
    }

    private String variableLabel(String name, String SEP) {
        return SEP + name + " min" + SEP + name + " max" + SEP + name + " av" + SEP + name + " av +/-" + SEP + name + " sigma";
    }
}

