/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class MonteCarloHistory {
    DoubleArrayList beta;
    DoubleArrayList energy;
    DoubleArrayList vupdates;
    DoubleArrayList eupdates;

    public MonteCarloHistory(int n) {
        this.beta = new DoubleArrayList(n);
        this.energy = new DoubleArrayList(n);
        this.vupdates = new DoubleArrayList(n);
        this.eupdates = new DoubleArrayList(n);
    }

    public void add(double betavalue, double energyvalue, double vertexupdates, double edgeupdates) {
        this.beta.add(betavalue);
        this.energy.add(energyvalue);
        this.vupdates.add(vertexupdates);
        this.eupdates.add(edgeupdates);
    }

    public void printTimeEvolution(PrintStream PS, String sep) {
        double energymax = this.getMax(this.energy);
        double vmax = this.getMax(this.vupdates);
        double emax = this.getMax(this.eupdates);
        PS.println("sweep" + sep + "beta" + sep + "energy" + sep + "V.updates" + sep + "E.updates" + sep + "energy/max" + sep + "V.up.frac" + sep + "E.up.frac");
        for (int t = 0; t < this.beta.size(); ++t) {
            PS.println(t + sep + this.beta.getQuick(t) + sep + this.energy.getQuick(t) + sep + this.vupdates.getQuick(t) + sep + this.eupdates.getQuick(t) + sep + this.energy.getQuick(t) / energymax + sep + this.vupdates.getQuick(t) / vmax + sep + this.eupdates.getQuick(t) / emax);
        }
    }

    public double getMax(DoubleArrayList list) {
        double max = list.get(0);
        for (int t = 0; t < this.beta.size(); ++t) {
            if (!(max < list.get(t))) continue;
            max = list.get(t);
        }
        return max;
    }

    public int getMax(IntArrayList list) {
        int max = list.get(0);
        for (int t = 0; t < this.beta.size(); ++t) {
            if (max >= list.get(t)) continue;
            max = list.get(t);
        }
        return max;
    }

    public void FileOutputMonteCarloHistory(String filenamecomplete) {
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.printTimeEvolution(PS, "\t");
            try {
                fout.close();
                System.out.println("Finished writing to " + filenamecomplete);
            }
            catch (IOException e) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening output file " + filenamecomplete);
            return;
        }
    }
}

