/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.islandNetwork;
import TimUtilities.Permutation;
import TimUtilities.UpdateRecord;
import java.io.PrintStream;

public class LouvainCommunity {
    private static int TEMPCOMMUNITYLABEL = -97531;
    private static int MAXSWEEPS = 5;
    private islandNetwork in;
    private double[] outVector;
    private double[] inVector;
    private double outNormalisation;
    private double inNormalisation;
    private double[][] influenceQ;
    private int[] communityOfSite;
    private int[] numberInCommunity;
    private int numberOfCommunities;
    private Permutation perm;
    private UpdateRecord updateRecord;

    public LouvainCommunity(islandNetwork inputIn) {
        this.in = inputIn;
        this.inVector = new double[this.in.numberSites];
        this.outVector = new double[this.in.numberSites];
        this.communityOfSite = new int[this.in.numberSites];
        this.numberInCommunity = new int[this.in.numberSites];
        for (int s = 0; s < this.in.numberSites; ++s) {
            this.outVector[s] = this.in.siteSet.getWeight(s);
            this.inVector[s] = this.in.siteSet.getStrengthIn(s);
            this.communityOfSite[s] = s;
            this.numberInCommunity[s] = 1;
        }
        this.numberOfCommunities = this.in.numberSites;
        this.inNormalisation = this.normalise(this.inVector);
        this.outNormalisation = this.normalise(this.outVector);
    }

    private double normalise(double[] vector) {
        int i;
        double norm = 0.0;
        for (i = 0; i < vector.length; ++i) {
            norm += vector[i];
        }
        if (Math.abs(norm) > 1.0E-10) {
            for (i = 0; i < vector.length; ++i) {
                vector[i] = vector[i] / norm;
            }
        }
        return norm;
    }

    public void calcCommunity(double prob) {
        int test;
        int nni;
        this.in.transferMatrix.calcInfluenceMatrix(prob);
        int smi = this.in.transferMatrix.checkInfluenceSubMarkovian(1.0E-6);
        if (smi >= 0) {
            System.err.println("!!! Influence is no subMarkovian in column " + smi);
        }
        if ((nni = this.in.transferMatrix.checkInfluenceNonNegative(1.0E-6)) >= 0) {
            System.err.println("!!! Influence is no subMarkovian in row*dimension+ column " + nni);
        }
        if ((test = this.in.transferMatrix.checkDecomposition(0.001)) < 0) {
            System.err.println("*** in calcCommunity, transfer matrix decomposition check failed, result =" + test);
        }
        this.in.transferMatrix.printEigenValueList("", "   ", System.out, 4, true);
        this.in.transferMatrix.printTransferMatrix("", "   ", System.out, 4, true);
        this.in.transferMatrix.printInfluenceMatrix("", "   ", System.out, 4, true);
        this.influenceQ = new double[this.in.numberSites][this.in.numberSites];
        for (int s = 0; s < this.in.numberSites; ++s) {
            for (int t = 0; t < this.in.numberSites; ++t) {
                this.influenceQ[s][t] = this.in.transferMatrix.getInfluence(s, t) * this.outVector[t];
            }
        }
        this.perm = new Permutation(this.in.numberSites);
        this.updateRecord = new UpdateRecord();
        System.out.println("Initial Quality " + this.calcQuality() + ", number of communities " + this.numberOfCommunities);
        for (int n = 0; n < MAXSWEEPS; ++n) {
            double totalQualityChange = this.oneSweep();
            System.out.println("Quality " + this.calcQuality() + ", number of communities " + this.numberOfCommunities + ", Quality change " + totalQualityChange + ", " + this.updateRecord.toString());
            if (this.updateRecord.getMade() == 0) break;
        }
    }

    private double oneSweep() {
        double totalQualityChange = 0.0;
        int updateTried = 0;
        int updateMade = 0;
        double deltaQremove = 0.0;
        int oldCommunity = -1;
        this.perm.newPermutation();
        int s = -1;
        double deltaQadd = 0.0;
        double deltaQaddmax = 0.0;
        int cmax = -1;
        for (int i = 0; i < this.in.numberSites; ++i) {
            s = this.perm.next();
            int n = oldCommunity = this.communityOfSite[s];
            this.numberInCommunity[n] = this.numberInCommunity[n] - 1;
            int n2 = this.numberInCommunity[n];
            if (n2 == 0) {
                --this.numberOfCommunities;
            }
            this.communityOfSite[s] = TEMPCOMMUNITYLABEL;
            deltaQremove = -this.deltaQuality(s, oldCommunity);
            deltaQaddmax = -deltaQremove;
            cmax = deltaQremove > 0.0 ? this.in.numberSites : TEMPCOMMUNITYLABEL;
            for (int c = 0; c < this.numberInCommunity.length; ++c) {
                if (this.numberInCommunity[c] == 0 || c == oldCommunity || (deltaQadd = this.deltaQuality(s, c)) < deltaQaddmax) continue;
                cmax = c;
                deltaQaddmax = deltaQadd;
            }
            ++updateTried;
            if (cmax > 0) {
                totalQualityChange += deltaQremove;
                if (cmax == this.in.numberSites) {
                    cmax = this.getEmptyCommunity();
                } else {
                    totalQualityChange += deltaQadd;
                }
                this.communityOfSite[s] = cmax;
                int n3 = cmax;
                this.numberInCommunity[n3] = this.numberInCommunity[n3] + 1;
                if (this.numberInCommunity[cmax] == 1) {
                    ++this.numberOfCommunities;
                }
                ++updateMade;
                continue;
            }
            this.communityOfSite[s] = oldCommunity;
            int n4 = oldCommunity;
            this.numberInCommunity[n4] = this.numberInCommunity[n4] + 1;
        }
        this.updateRecord.update(updateTried, updateMade);
        return totalQualityChange;
    }

    public double deltaQuality(int s, int c) {
        double deltaQ = 0.0;
        for (int t = 0; t < this.in.numberSites; ++t) {
            if (this.communityOfSite[t] != c || s == t) continue;
            deltaQ += this.influenceQ[s][t] - this.inVector[s] * this.outVector[t];
            deltaQ += this.influenceQ[t][s] - this.inVector[t] * this.outVector[s];
        }
        return deltaQ;
    }

    public double calcQuality() {
        double Q = 0.0;
        for (int s = 0; s < this.in.numberSites; ++s) {
            int c = this.communityOfSite[s];
            for (int t = 0; t < this.in.numberSites; ++t) {
                if (this.communityOfSite[t] != c || s == t) continue;
                Q += this.influenceQ[s][t] - this.inVector[s] * this.outVector[t];
            }
        }
        return Q;
    }

    private int getEmptyCommunity() {
        for (int c = 0; c < this.numberInCommunity.length; ++c) {
            if (this.numberInCommunity[c] != 0) continue;
            return c;
        }
        return -1;
    }

    public void printCommunities(PrintStream PS, String cc, String sep) {
        PS.println(cc + "Number of Communities" + sep + this.numberOfCommunities);
        int count = this.numberOfCommunities;
        PS.println(cc + "Count" + sep + "Label" + sep + " Number");
        for (int c = 0; c < this.numberInCommunity.length; ++c) {
            if (this.numberInCommunity[c] <= 0) continue;
            PS.println(cc + count-- + sep + c + sep + this.numberInCommunity[c]);
        }
        PS.println(cc + "Site" + sep + "Label");
        for (int s = 0; s < this.in.numberSites; ++s) {
            PS.println(cc + s + sep + this.communityOfSite[s]);
        }
    }
}

