/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.Edge.IslandEdgeSet;
import IslandNetworks.Vertex.IslandSiteSet;
import TimUtilities.NumbersToString;
import TimUtilities.TimSort;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.io.PrintStream;

public class IslandTransferMatrix {
    static final double DUNSET = -97531.0;
    static final int IUNSET = -86420;
    private int modeNumber = 0;
    int edgeVariableIndex = IslandEdge.weightINDEX;
    int dimension = -86420;
    Algebra alg = new Algebra();
    DenseDoubleMatrix2D transferMatrix;
    double[] restartVector;
    boolean restartVectorRandomSites = false;
    boolean evcalc = false;
    boolean evCalcFailed = false;
    EigenvalueDecomposition tMED;
    DoubleMatrix2D Vmatrix;
    DoubleMatrix2D Dmatrix;
    private double[] absevalues;
    TimSort evOrder;
    double tolerance = -97531.0;
    boolean inflcalc = false;
    private double influenceProbability = -97531.0;
    double influenceSteps = -97531.0;
    DoubleMatrix2D influenceMatrix;
    DoubleMatrix2D Vinverse;
    double[] influenceValueIn;
    double[] influenceStrengthIn;
    double[] influenceValueOut;

    public IslandTransferMatrix(int mode, int numberSites, IslandSiteSet siteSet, IslandEdgeSet edgeSet, int edgeVariableIndexInput) {
        this.edgeVariableIndex = edgeVariableIndexInput;
        this.calcTransferMatrix(mode, numberSites, siteSet, edgeSet);
    }

    public IslandTransferMatrix(IslandTransferMatrix old) {
        this.modeNumber = old.modeNumber;
        this.edgeVariableIndex = old.edgeVariableIndex;
        this.dimension = old.dimension;
        this.transferMatrix = (DenseDoubleMatrix2D)old.transferMatrix.copy();
        this.restartVector = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.restartVector[i] = old.restartVector[i];
        }
        if (old.evcalc) {
            this.calcEigenvalueDecomposition(old.tolerance);
            if (old.inflcalc) {
                this.calcInfluenceMatrix(old.influenceProbability);
            }
        }
    }

    private void calcTransferMatrix(int mode, int numberSites, IslandSiteSet siteSet, IslandEdgeSet edgeSet) {
        this.modeNumber = mode;
        this.dimension = numberSites;
        this.restartVector = new double[this.dimension];
        this.calcRestartVector(siteSet);
        this.transferMatrix = new DenseDoubleMatrix2D(this.dimension, this.dimension);
        this.calcTransferMatrix(edgeSet);
    }

    private void calcTransferMatrix(IslandEdgeSet edgeSet) {
        double outEdges = -99.0;
        double outEdgeDeficit = -876.0;
        int j = -345;
        block6: for (int i = 0; i < this.dimension; ++i) {
            outEdges = 0.0;
            if (this.modeNumber > 0) {
                for (j = 0; j < this.dimension; ++j) {
                    if (i == j) continue;
                    outEdges += edgeSet.getVariable(i, j, this.edgeVariableIndex);
                }
            }
            outEdgeDeficit = 1.0 - outEdges;
            this.transferMatrix.set(i, i, 0.0);
            switch (this.modeNumber) {
                case 3: {
                    for (j = 0; j < this.dimension; ++j) {
                        this.transferMatrix.set(j, i, (i == j ? 0.0 : edgeSet.getVariable(i, j, this.edgeVariableIndex)) + this.restartVector[j] * outEdgeDeficit);
                    }
                    continue block6;
                }
                case 2: {
                    for (j = 0; j < this.dimension; ++j) {
                        if (i == j) continue;
                        this.transferMatrix.set(j, i, edgeSet.getVariable(i, j, this.edgeVariableIndex));
                    }
                    this.transferMatrix.set(i, i, outEdgeDeficit);
                    continue block6;
                }
                case 1: {
                    if (outEdges > 1.0E-6) {
                        for (j = 0; j < this.dimension; ++j) {
                            if (i == j) continue;
                            this.transferMatrix.set(j, i, edgeSet.getVariable(i, j, this.edgeVariableIndex) / outEdges);
                        }
                        continue block6;
                    }
                    for (j = 0; j < this.dimension; ++j) {
                        this.transferMatrix.set(j, i, this.restartVector[j]);
                    }
                    continue block6;
                }
                case 0: {
                    for (j = 0; j < this.dimension; ++j) {
                        if (i == j) continue;
                        this.transferMatrix.set(j, i, edgeSet.getVariable(i, j, this.edgeVariableIndex));
                    }
                    continue block6;
                }
            }
        }
        double connectivityFraction = 1.0 / (double)(this.dimension * this.dimension);
        double edgeFactor = 1.0 - connectivityFraction;
        double connectivityFactor = connectivityFraction / (double)this.dimension;
        for (int i = 0; i < this.dimension; ++i) {
            for (j = 0; j < this.dimension; ++j) {
                this.transferMatrix.set(i, j, this.transferMatrix.getQuick(i, j) * edgeFactor + connectivityFactor);
            }
        }
        int e = this.checkNonNegative();
        if (e >= 0) {
            System.err.println("*** Transfer Matrix is negative at row " + e / this.dimension + " column " + e % this.dimension);
        } else {
            System.out.println("... Transfer Matrix is non-negative");
        }
    }

    private void calcRestartVector(IslandSiteSet siteSet, boolean randomSite) {
        int i;
        this.restartVectorRandomSites = randomSite;
        double normSite = 0.0;
        if (!randomSite) {
            for (i = 0; i < this.dimension; ++i) {
                normSite += siteSet.getWeight(i);
            }
        }
        for (i = 0; i < this.dimension; ++i) {
            this.restartVector[i] = normSite > 0.0 ? siteSet.getWeight(i) / normSite : 1.0 / (double)this.dimension;
        }
    }

    private void calcRestartVector(IslandSiteSet siteSet) {
        this.calcRestartVector(siteSet, false);
    }

    private int calcEigenvalueDecomposition(double tol) {
        this.inflcalc = false;
        this.Vinverse = null;
        this.Dmatrix = null;
        this.absevalues = null;
        this.tolerance = -88.888888;
        this.absevalues = new double[this.dimension];
        try {
            this.tMED = new EigenvalueDecomposition((DoubleMatrix2D)this.transferMatrix);
        }
        catch (RuntimeException e) {
            System.err.println("*** EigenvalueDecomposition has failed, " + e);
            this.evcalc = false;
            this.evCalcFailed = true;
            return -this.dimension - 2;
        }
        this.Vmatrix = this.tMED.getV();
        this.Dmatrix = this.tMED.getD();
        int result = 0;
        double im = -987.654321;
        double re = -654.321987;
        for (int i = 0; i < this.dimension; ++i) {
            im = this.tMED.getImagEigenvalues().get(i);
            re = this.tMED.getRealEigenvalues().get(i);
            if (Math.abs(im) > tol) {
                result = -1 - i;
            }
            this.absevalues[i] = Math.sqrt(re * re + im * im);
        }
        this.evOrder = new TimSort(this.absevalues, false);
        this.evcalc = true;
        this.tolerance = tol;
        this.evCalcFailed = false;
        return result;
    }

    private int calcVinverse() {
        try {
            this.Vinverse = this.alg.inverse(this.Vmatrix);
        }
        catch (RuntimeException err) {
            System.out.println("*** ERROR " + err + "in calcInfluenceMatrix ");
            return -1;
        }
        return 0;
    }

    public int calcInfluenceMatrix(double inflProb) {
        if (inflProb > 1.0 || inflProb < 0.0) {
            return -2;
        }
        this.influenceProbability = inflProb;
        double pbar = 1.0 - this.influenceProbability;
        if (!this.evcalc) {
            this.calcEigenvalueDecomposition(0.001);
        }
        if (this.evCalcFailed) {
            return -2;
        }
        if (this.Vinverse == null && this.calcVinverse() < 0) {
            return -1;
        }
        SparseDoubleMatrix2D inflD = new SparseDoubleMatrix2D(this.dimension, this.dimension);
        int dimensionMinusOne = this.dimension - 1;
        for (int i = 0; i < this.dimension; ++i) {
            double lbar = 1.0 - this.influenceProbability * this.Dmatrix.get(i, i);
            if (Math.abs(lbar) > 1.0E-6) {
                double mu;
                double d = mu = i == dimensionMinusOne ? 0.0 : this.influenceProbability * this.Dmatrix.get(i, i + 1);
                if (mu == 0.0) {
                    inflD.set(i, i, pbar / lbar);
                    continue;
                }
                double norm = lbar * lbar + mu * mu;
                double diag = pbar * lbar / norm;
                double offdiag = pbar * mu / norm;
                inflD.set(i, i, diag);
                inflD.set(i, i + 1, offdiag);
                inflD.set(i + 1, i, -offdiag);
                inflD.set(i + 1, i + 1, diag);
                ++i;
                continue;
            }
            inflD.set(i, i, 1.0);
        }
        DoubleMatrix2D temp2 = this.alg.mult(this.Vmatrix, (DoubleMatrix2D)inflD);
        this.influenceMatrix = this.alg.mult(temp2, this.Vinverse);
        this.inflcalc = true;
        this.influenceSteps = this.influenceProbability / (1.0 - this.influenceProbability);
        this.influenceValueIn = new double[this.dimension];
        this.influenceValueOut = new double[this.dimension];
        this.influenceStrengthIn = null;
        for (int i = 0; i < this.dimension; ++i) {
            this.influenceValueIn[i] = 0.0;
            this.influenceValueOut[i] = 0.0;
            for (int j = 0; j < this.dimension; ++j) {
                int n = i;
                this.influenceValueIn[n] = this.influenceValueIn[n] + this.influenceMatrix.get(i, j);
                int n2 = i;
                this.influenceValueOut[n2] = this.influenceValueOut[n2] + this.influenceMatrix.get(j, i);
            }
        }
        return 0;
    }

    public double getInfluenceProbability() {
        return this.influenceProbability;
    }

    public double getDimension() {
        return this.dimension;
    }

    public double get(int i, int j) {
        double entry = -2.0;
        if (i < 0 || i >= this.dimension) {
            return -1.0;
        }
        if (j < 0 || j >= this.dimension) {
            return -1.1;
        }
        try {
            entry = this.transferMatrix.get(i, j);
        }
        catch (ArithmeticException e) {
            entry = -3.0;
        }
        return entry;
    }

    public double getInfluence(int t, int s) {
        if (s < 0 || s >= this.dimension) {
            return -1.0;
        }
        if (t < 0 || t >= this.dimension) {
            return -1.1;
        }
        if (this.inflcalc) {
            return this.influenceMatrix.get(t, s);
        }
        return -97531.0;
    }

    public double getAbsEigenValue(int n) {
        if (!this.evcalc) {
            this.calcEigenvalueDecomposition(0.001);
        }
        int i = this.evOrder.getIndex(n);
        return this.absevalues[i];
    }

    public double getRealPartEigenValue(int n) {
        if (!this.evcalc) {
            this.calcEigenvalueDecomposition(0.001);
        }
        int i = this.evOrder.getIndex(n);
        return this.tMED.getRealEigenvalues().get(i);
    }

    public double getImaginaryPartEigenValue(int n) {
        if (!this.evcalc) {
            this.calcEigenvalueDecomposition(0.001);
        }
        int i = this.evOrder.getIndex(n);
        return this.tMED.getImagEigenvalues().get(i);
    }

    public double[] getEigenVector(int n) {
        if (!this.evcalc) {
            this.calcEigenvalueDecomposition(0.001);
        }
        int i = this.evOrder.getIndex(n);
        DoubleMatrix1D ev = this.Vmatrix.viewColumn(i);
        return ev.toArray();
    }

    public void printEigenValueList(String cc, String SepString, PrintStream PS, int dec, boolean headersOn) {
        this.printEigenValueList(cc, SepString, PS, dec, headersOn, true, true);
    }

    public void printEigenValueList(String cc, String SepString, PrintStream PS, int dec, boolean headersOn, boolean absValues, boolean reimValues) {
        NumbersToString n2s = new NumbersToString();
        if (headersOn) {
            PS.println("Eigenvalues for transfer matrix  type " + SepString + this.modeNumber);
            PS.print("Rank");
            if (absValues) {
                PS.print(SepString + "Abs");
            }
            if (reimValues) {
                PS.print(SepString + "Re" + SepString + "Im");
            }
            PS.println();
        }
        for (int i = 0; i < this.dimension; ++i) {
            PS.print(i);
            if (absValues) {
                PS.print(SepString + NumbersToString.toString((double)this.getAbsEigenValue(i), (int)dec));
            }
            if (reimValues) {
                PS.print(SepString + NumbersToString.toString((double)this.getRealPartEigenValue(i), (int)dec) + SepString + NumbersToString.toString((double)this.getImaginaryPartEigenValue(i), (int)dec));
            }
            PS.println();
        }
    }

    public void printTransferMatrix(String cc, String SepString, PrintStream PS, int dec, boolean headersOn) {
        int i;
        NumbersToString n2s = new NumbersToString();
        if (headersOn) {
            PS.println("Transfer Matrix  type " + SepString + this.modeNumber);
            PS.print("To/From" + SepString);
            for (i = 0; i < this.dimension; ++i) {
                PS.print(i + SepString);
            }
            PS.println();
        }
        for (i = 0; i < this.dimension; ++i) {
            if (headersOn) {
                PS.print(i + SepString);
            }
            for (int j = 0; j < this.dimension; ++j) {
                PS.print(NumbersToString.toString((double)this.transferMatrix.get(i, j), (int)dec) + SepString);
            }
            PS.println();
        }
    }

    public void printInfluenceMatrix(String cc, String SepString, PrintStream PS, int dec, boolean headersOn) {
        int i;
        if (!this.inflcalc) {
            if (headersOn) {
                PS.println("Influence Matrix not calculated.");
            }
            return;
        }
        NumbersToString n2s = new NumbersToString();
        if (headersOn) {
            PS.println("Influence Matrix probability " + SepString + this.influenceProbability + SepString + ", steps " + SepString + this.influenceSteps + SepString + " from transfer matrix type " + this.modeNumber);
            PS.print("To/From" + SepString);
            for (i = 0; i < this.dimension; ++i) {
                PS.print(i + SepString);
            }
            PS.println();
        }
        for (i = 0; i < this.dimension; ++i) {
            if (headersOn) {
                PS.print(i + SepString);
            }
            for (int j = 0; j < this.dimension; ++j) {
                PS.print(NumbersToString.toString((double)this.influenceMatrix.get(i, j), (int)dec) + SepString);
            }
            PS.println();
        }
    }

    public String typeString() {
        String s = "Unset";
        switch (this.modeNumber) {
            case 3: {
                s = "Raw edge values plus normalised restart vector to ensure markovian.";
                break;
            }
            case 2: {
                s = "Raw edge values, tadpoles equal to remaining deficit so markovian.";
                break;
            }
            case 1: {
                s = "Normalised edge values (restart vector if deadend), no tadpoles but markovian.";
                break;
            }
            case 0: {
                s = "Raw edge values, no tadpoles, non-markovian.";
                break;
            }
            default: {
                s = "Unknown.";
            }
        }
        return s;
    }

    public int checkDecomposition(double tol) {
        DoubleMatrix2D test;
        if (tol < 0.0) {
            return -4;
        }
        if (!this.evcalc) {
            this.calcEigenvalueDecomposition(0.001);
        }
        if (this.Vinverse == null && this.calcVinverse() < 0) {
            return -1;
        }
        try {
            test = this.alg.mult(this.alg.mult(this.Vmatrix, this.Dmatrix), this.Vinverse);
        }
        catch (RuntimeException err) {
            System.out.println("*** ERROR " + err + "in checkDecomposition ");
            return -2;
        }
        int r = 0;
        double[][] dif = new double[this.dimension][this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                dif[i][j] = Math.abs(test.get(i, j) - this.transferMatrix.get(i, j));
                if (!(dif[i][j] > tol)) continue;
                r = -3;
            }
        }
        return r;
    }

    public int checkMarkovian(double tol) {
        double colTotal = -99.0;
        for (int j = 0; j < this.dimension; ++j) {
            colTotal = this.transferMatrix.viewColumn(j).zSum();
            if (!(Math.abs(colTotal - 1.0) > tol)) continue;
            return j;
        }
        return -1;
    }

    public int checkNonNegative() {
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                if (!(this.transferMatrix.getQuick(i, j) < 0.0)) continue;
                return i * this.dimension + j;
            }
        }
        return -1;
    }

    public int checkInfluenceSubMarkovian(double tol) {
        double colTotal = -99.0;
        for (int j = 0; j < this.dimension; ++j) {
            colTotal = this.influenceMatrix.viewColumn(j).zSum();
            if (!(colTotal - 1.0 > tol) && !(colTotal < -tol)) continue;
            return j;
        }
        return -1;
    }

    public int checkInfluenceNonNegative(double tol) {
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                if (!(this.influenceMatrix.get(i, j) < -tol)) continue;
                return i * this.dimension + j;
            }
        }
        return -1;
    }
}

