/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.islandNetwork;
import TimGraph.VertexLabel;
import TimGraph.timgraph;
import TimUtilities.TimMessage;
import java.util.Random;

public class IslandTimGraph {
    timgraph tg;
    int[] siteLastVertex;
    Random rnd = new Random();
    TimMessage message = new TimMessage(0);
    String SEP = "\t";

    public void NetworkToTimGraph(int numberVertices, int numberInternalSiteEdges, int numberExternalSiteEdges, islandNetwork inet) {
        double indVertexWeight = inet.siteSet.siteWeightStats.maximum / (double)numberVertices;
        double intEdgeWeight = inet.edgeSet.edgeStats[IslandEdge.weightINDEX].maximum / (double)numberInternalSiteEdges;
        int maxVertices = 2 * inet.numberSites + numberVertices;
        int maxEdges = numberInternalSiteEdges + numberExternalSiteEdges + 2 * inet.numberSites;
        String dname = "";
        boolean makeDirected = true;
        boolean makeLabelled = true;
        boolean makeWeighted = false;
        boolean makeVertexEdgeList = true;
        this.tg = new timgraph(inet.outputFile.getNameRoot(), dname, 0, 0, makeDirected, makeLabelled, makeWeighted, makeVertexEdgeList, maxVertices, maxEdges);
        this.siteLastVertex = new int[inet.numberSites];
        for (int s = 0; s < inet.numberSites; ++s) {
            int n = (int)(inet.siteSet.getWeight(s) / indVertexWeight + 0.5);
            for (int v = 0; v < n; ++v) {
                this.tg.addVertex(new VertexLabel(Integer.valueOf(s)));
            }
            this.siteLastVertex[s] = this.tg.getNumberVertices();
        }
        int minSource = 0;
        int minTarget = 0;
        for (int s = 0; s < inet.numberSites; ++s) {
            double weight = inet.siteSet.getWeight(s);
            int intEdges = (int)(weight / intEdgeWeight + 0.5);
            int nsv = this.siteLastVertex[s] - minSource;
            this.message.println(0, inet.siteSet.getName(s) + this.SEP + s + this.SEP + nsv + this.SEP + intEdges);
            for (int e = 0; e < intEdges; ++e) {
                this.tg.addEdge(minSource + this.rnd.nextInt(nsv), minSource + this.rnd.nextInt(nsv));
            }
            minTarget = 0;
            for (int t = 0; t < inet.numberSites; ++t) {
                int ntv = this.siteLastVertex[t] - minTarget;
                if (s == t) continue;
                int extEdges = (int)(inet.edgeSet.getEdgeValue(s, t) * weight / intEdgeWeight + 0.5);
                for (int e = 0; e < extEdges; ++e) {
                    this.tg.addEdge(minSource + this.rnd.nextInt(nsv), minTarget + this.rnd.nextInt(ntv));
                }
                minTarget = this.siteLastVertex[t];
            }
            minSource = this.siteLastVertex[s];
        }
    }
}

