/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.islandNetwork;
import TimUtilities.NumbersToString;
import TimUtilities.StatisticalQuantity;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IslandParameterWindow {
    private islandNetwork islnet;

    public IslandParameterWindow(islandNetwork inputIslandNetwork) {
        this.islnet = new islandNetwork(inputIslandNetwork);
    }

    public Box getParameterBox() {
        Box pb = Box.createVerticalBox();
        pb.add(this.getBasicSettingsPanel());
        pb.add(this.getInputVariablesPanel());
        return pb;
    }

    public JPanel getParameterPanel() {
        JPanel pb = new JPanel();
        pb.add(this.getBasicSettingsPanel());
        pb.add(this.getInputVariablesPanel());
        return pb;
    }

    public JPanel getBasicSettingsPanel() {
        JPanel topBox = new JPanel();
        topBox.setLayout(new GridLayout(7, 2));
        this.addValuePair(topBox, "Input file : ", this.islnet.inputFile.getNameRoot());
        this.addValuePair(topBox, "Output files : ", this.islnet.outputFile.getNameRoot());
        this.addValuePair(topBox, "Model : ", this.islnet.modelNumber.major + "_" + this.islnet.modelNumber.minor + ",  " + this.islnet.modelNumber.majorString + "+" + this.islnet.modelNumber.minorString);
        String s = this.islnet.updateMode.toLongString();
        if (this.islnet.updateMode.isMode("MC")) {
            s = s + ", " + this.islnet.monteCarloStartMode.toLongString();
        }
        s = s + " (" + this.islnet.updateMode.getNumber() + ")";
        this.addValuePair(topBox, "Calculational Mode : ", s);
        this.addValuePair(topBox, "Edge Update Mode : ", this.islnet.edgeSet.edgeMode.description());
        this.addValuePair(topBox, "Vertex Update Mode : ", this.islnet.vertexMode.descriptionValue(", value="));
        return topBox;
    }

    public JPanel getInputVariablesPanel() {
        JPanel inputBox = new JPanel();
        inputBox.setLayout(new GridLayout(5, 4));
        this.addValuePair(inputBox, "kappa", this.islnet.Hamiltonian.kappa);
        this.addValuePair(inputBox, "lambda", this.islnet.Hamiltonian.lambda);
        this.addValuePair(inputBox, "j", this.islnet.Hamiltonian.vertexSource);
        this.addValuePair(inputBox, "mu", this.islnet.Hamiltonian.edgeSource);
        this.addValuePair(inputBox, "distance scale", this.islnet.Hamiltonian.distanceScale);
        this.addValuePair(inputBox, "short distance scale", this.islnet.Hamiltonian.shortDistanceScale);
        this.addValuePair(inputBox, "b", this.islnet.Hamiltonian.getb());
        this.addValuePair(inputBox, "metric number ", this.islnet.Hamiltonian.shortDistanceScale);
        this.addValuePair(inputBox, "initial beta ", this.islnet.betaInitial);
        JPanel jp = new JPanel();
        jp.add(inputBox);
        return jp;
    }

    public JPanel getOutputMeasuresPanel(int decPoints) {
        NumbersToString n2s = new NumbersToString(decPoints);
        JPanel infoBox = new JPanel();
        infoBox.setLayout(new GridLayout(7, 5));
        infoBox.setToolTipText("These are different measures of the output for this network.");
        infoBox.add(new JLabel("Quantity/Value :", 4));
        infoBox.add(new JLabel("Average", 0));
        infoBox.add(new JLabel("Sigma", 0));
        infoBox.add(new JLabel("Minimum", 0));
        infoBox.add(new JLabel("Maximum", 0));
        infoBox.add(this.makeRightLabelWithToolTip("Site Value :", "Fractional population of one site relative to sites fixed value (v_i)"));
        this.addStatsValues(infoBox, "Site value", this.islnet.siteSet.siteValueStats, decPoints);
        infoBox.add(this.makeRightLabelWithToolTip("Site Weight :", "Population of one site, fixed value * variable fraction (S_i v_i)"));
        this.addStatsValues(infoBox, "Site weight", this.islnet.siteSet.siteWeightStats, decPoints);
        infoBox.add(this.makeRightLabelWithToolTip("Site Out W.Strength :", "Total outgoing trade from one site (sum_j S_i v_i e_(ij) )"));
        this.addStatsValues(infoBox, "Site out w.strength", this.islnet.siteSet.siteStrengthOutStats, decPoints);
        infoBox.add(this.makeRightLabelWithToolTip("Site In W.Strength :", "Total incoming trade from one site (sum_j S_j v_j e_(ij) )"));
        this.addStatsValues(infoBox, "Site in w.strength", this.islnet.siteSet.siteStrengthInStats, decPoints);
        infoBox.add(this.makeRightLabelWithToolTip("Edge Weight :", "Total trade along one edge, (S_i v_i e_(ij) )"));
        this.addStatsValues(infoBox, "Edge weight", this.islnet.edgeSet.edgeStats[IslandEdge.weightINDEX], decPoints);
        infoBox.add(this.makeRightLabelWithToolTip("Edge Value :", "Fraction of trade along one edge, e_(ij) "));
        this.addStatsValues(infoBox, "Edge value", this.islnet.edgeSet.edgeStats[IslandEdge.valueINDEX], decPoints);
        JPanel infoPanel = new JPanel();
        infoPanel.add(infoBox);
        infoPanel.add(this.islnet.globalProperties.getPanel());
        return infoPanel;
    }

    private void addStatsValues(JPanel label, String s, StatisticalQuantity stats, int decPoints) {
        NumbersToString n2s = new NumbersToString(decPoints);
        label.add(this.makeCenterLabelWithToolTip(n2s.toString(stats.getAverage()), s + " average"));
        label.add(this.makeCenterLabelWithToolTip(n2s.toString(stats.getSigma()), s + " sigma"));
        label.add(this.makeCenterLabelWithToolTip(n2s.toString(stats.minimum), s + " min"));
        label.add(this.makeCenterLabelWithToolTip(n2s.toString(stats.maximum), s + " max"));
    }

    private void addValuePair(JPanel label, String s, double value) {
        label.add(new JLabel(s, 4));
        String sv = ": " + value;
        label.add(new JLabel(sv, 2));
    }

    private void addValuePair(JPanel label, String s, double value, int dec) {
        label.add(new JLabel(s, 4));
        String fstring = "%12.6g";
        if (dec > 0) {
            fstring = "%" + (dec + 6) + "." + dec;
        }
        String sv = ": " + String.format(fstring, value);
        label.add(new JLabel(sv, 0));
    }

    private void addValuePair(JPanel label, String s, double value, String tooltip) {
        label.add(new JLabel(s, 4));
        String sv = ": " + value;
        JLabel l = new JLabel(": " + value, 2);
        l.setToolTipText(tooltip);
        label.add(l);
    }

    private void addValuePair(JPanel label, String sleft, String sright) {
        label.add(new JLabel(sleft, 4));
        label.add(new JLabel(sright, 2));
    }

    private void addValuePair(JPanel label, String sleft, String sright, String tooltip) {
        label.add(new JLabel(sleft, 4));
        JLabel l = new JLabel(sright, 2);
        l.setToolTipText(tooltip);
        label.add(l);
    }

    private JLabel makeRightLabelWithToolTip(String s, String tooltip) {
        JLabel l = new JLabel(s, 4);
        l.setToolTipText(tooltip);
        return l;
    }

    private JLabel makeCenterLabelWithToolTip(String s, String tooltip) {
        JLabel l = new JLabel(s, 0);
        l.setToolTipText(tooltip);
        return l;
    }
}

