/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import TimUtilities.NumbersToString;
import java.io.PrintStream;

public class IslandHamiltonian {
    static final String IHVERSION = "iN060727";
    public static final double SHORTDISTANCEPOTENTIAL = -9.18273645E8;
    static NumbersToString n2s = new NumbersToString();
    double edgeSource;
    double vertexSource;
    double alpha;
    double beta;
    double gamma;
    double kappa;
    private double kappaZ;
    double lambda;
    double distanceScale;
    double shortDistanceScale;
    private double b;
    double outputcoeff;
    double consumptioncoeff;

    public IslandHamiltonian() {
        this.edgeSource = 0.5;
        this.vertexSource = 0.0;
        this.beta = 0.001;
        this.alpha = 4.0;
        this.gamma = 1.0;
        this.kappa = 1.0;
        this.lambda = 4.0;
        this.distanceScale = 100.0;
        this.shortDistanceScale = this.distanceScale / 20.0;
        this.setb(1.2);
        this.outputcoeff = 1.0;
        this.consumptioncoeff = 2.0 * this.outputcoeff;
    }

    public IslandHamiltonian(IslandHamiltonian H) {
        this.edgeSource = H.edgeSource;
        this.vertexSource = H.vertexSource;
        this.beta = H.beta;
        this.alpha = H.alpha;
        this.gamma = H.gamma;
        this.kappa = H.kappa;
        this.lambda = H.lambda;
        this.distanceScale = H.distanceScale;
        this.shortDistanceScale = H.shortDistanceScale;
        this.setb(H.getb());
        this.outputcoeff = H.outputcoeff;
        this.consumptioncoeff = H.consumptioncoeff;
    }

    public double getb() {
        return this.b;
    }

    public double setb(double newb) {
        this.b = newb;
        this.kappaZ = Math.pow(this.b, this.b / (this.b - 1.0)) * (this.b - 1.0);
        return this.b;
    }

    public void setHamiltonianParameters(double j, double mu, double bt, double bs, double a, double k, double g, double l, double ds, double ss) {
        this.edgeSource = mu;
        this.vertexSource = j;
        this.beta = bt;
        this.setb(bs);
        this.alpha = a;
        this.gamma = g;
        this.kappa = k;
        this.lambda = l;
        this.distanceScale = ds;
        this.shortDistanceScale = ss;
    }

    public void printParameters(PrintStream PS, String SepString) {
        PS.println("   vertexSource (j) " + SepString + this.vertexSource);
        PS.println("     edgeSource (mu)" + SepString + this.edgeSource);
        PS.println("              kappa " + SepString + this.kappa);
        PS.println("             lambda " + SepString + this.lambda);
        PS.println("          distScale " + SepString + this.distanceScale);
        PS.println("     shortDistScale " + SepString + this.shortDistanceScale);
        PS.println("               beta " + SepString + String.format("%12.6g", this.beta));
        PS.println("                  b " + SepString + this.b);
        PS.println("              alpha " + SepString + this.alpha);
        PS.println("              gamma " + SepString + this.gamma);
    }

    public void printParametersForData(PrintStream PS, String SepString) {
        PS.println("j" + SepString + this.vertexSource);
        PS.println("mu" + SepString + this.edgeSource);
        PS.println("kappa" + SepString + this.kappa);
        PS.println("lambda " + SepString + this.lambda);
        PS.println("distScale" + SepString + this.distanceScale);
        PS.println("shortDistScale" + SepString + this.shortDistanceScale);
        PS.println("beta" + SepString + this.beta);
        PS.println("b" + SepString + this.b);
        PS.println("alpha" + SepString + this.alpha);
        PS.println("gamma" + SepString + this.gamma);
    }

    public String inputParametersString(String SepString) {
        String s = "";
        s = s + SepString + "-j" + this.vertexSource;
        s = s + SepString + "-m" + this.edgeSource;
        s = s + SepString + "-k" + this.kappa;
        s = s + SepString + "-l" + this.lambda;
        s = s + SepString + "-dl" + this.distanceScale;
        s = s + SepString + "-ds" + this.shortDistanceScale;
        s = s + SepString + "-bt" + this.beta;
        s = s + SepString + "-bs" + this.b;
        s = s + SepString + "-a" + this.alpha;
        s = s + SepString + "-g" + this.gamma;
        return s;
    }

    public String inputParametersString(String firstItem, String SepString, int dec) {
        n2s.setDecimalPlaces(dec);
        String s = "";
        if (firstItem.length() > 0) {
            s = firstItem + SepString;
        }
        s = s + "-j" + n2s.toString(this.vertexSource);
        s = s + SepString + "-m" + n2s.toString(this.edgeSource);
        s = s + SepString + "-k" + n2s.toString(this.kappa);
        s = s + SepString + "-l" + n2s.toString(this.lambda);
        s = s + SepString + "-dl" + n2s.toString(this.distanceScale);
        s = s + SepString + "-ds" + n2s.toString(this.shortDistanceScale);
        s = s + SepString + "-bt" + n2s.toString(this.beta);
        s = s + SepString + "-bs" + n2s.toString(this.b);
        s = s + SepString + "-a" + n2s.toString(this.alpha);
        s = s + SepString + "-g" + n2s.toString(this.gamma);
        return s;
    }

    public String parameterString(String SepString) {
        String s = "j" + this.vertexSource + SepString + "m" + this.edgeSource + SepString + "k" + this.kappa + SepString + "l" + this.lambda + SepString + "b" + this.b + SepString + "D" + this.distanceScale;
        return s;
    }

    public String parameterString(String SepString, int dp) {
        String fs = "%0" + (dp + 3) + "." + dp + "g";
        String s = "j" + String.format(fs, this.vertexSource) + SepString + "m" + String.format(fs, this.edgeSource) + SepString + "k" + String.format(fs, this.kappa) + SepString + "l" + String.format(fs, this.lambda) + SepString + "b" + String.format(fs, this.b) + SepString + "D" + String.format(fs, this.distanceScale);
        return s;
    }

    public double vertexPotential1(double size, double value) {
        return this.kappa * 4.0 * value * (1.0 - value) * size;
    }

    public double vertexPotential5(double size, double value) {
        return this.kappa * this.kappaZ * size * (value - Math.pow(value, this.b));
    }

    public double edgePotential1(double distance, double linearWeighting) {
        return linearWeighting * this.lambda * this.edgePotential1Bare(distance);
    }

    public double edgePotential1MC(double distance) {
        return distance < this.shortDistanceScale ? -9.18273645E8 : this.lambda * this.edgePotential1Bare(distance);
    }

    public double edgePotential1Bare(double distance) {
        return Math.pow(Math.pow(distance / this.distanceScale, this.alpha) + 1.0, -this.gamma);
    }
}

