/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import TimUtilities.NumbersToString;
import TimUtilities.TimMessage;
import TimUtilities.TimTiming;
import java.io.PrintStream;
import java.util.Random;

public class IslandCulture {
    public TimMessage message = new TimMessage(0);
    int numberSites = 0;
    EventProbability eProb;
    private int numberInd = 0;
    private double totalWeight;
    private int[] indArray;
    private int[] indSite;
    private int[] firstInd;
    private int[] nIndAtSite;
    private int[] nArtifact;
    private EventProbability[] neighbourProb;
    private Random Rnd = new Random();
    double[][] siteCultureVector;
    double[] siteCultureF2;
    double[] cultureF2;
    double[] maxCulture;
    int[] maxCultureSite;
    double[][] cultureCorrelation;

    public IslandCulture(double pSiteCopy, double pCopy, double pInnovate) {
        this.eProb = new EventProbability(4);
        this.eProb.addProbability(pSiteCopy);
        this.eProb.addProbability(pCopy);
        this.eProb.addProbability(pInnovate);
        this.eProb.addProbability(1.0 - pSiteCopy - pCopy - pInnovate);
    }

    public IslandCulture(IslandCulture ic) {
        this.numberSites = ic.numberSites;
        this.siteCultureVector = new double[this.numberSites][this.numberSites];
        this.cultureCorrelation = new double[this.numberSites][this.numberSites];
        this.siteCultureF2 = new double[this.numberSites];
        this.cultureF2 = new double[this.numberSites];
        for (int s = 0; s < this.numberSites; ++s) {
            this.cultureF2[s] = ic.cultureF2[s];
            this.siteCultureF2[s] = ic.siteCultureF2[s];
            for (int t = 0; t < this.numberSites; ++t) {
                this.siteCultureVector[s][t] = ic.siteCultureVector[s][t];
            }
        }
        this.eProb = new EventProbability(ic.eProb);
    }

    public void setup(double[] siteWeight, double[][] edgeValue, int nInd, int mode) {
        int s;
        this.numberSites = siteWeight.length;
        this.totalWeight = 0.0;
        for (int s2 = 0; s2 < this.numberSites; ++s2) {
            this.totalWeight += siteWeight[s2];
        }
        double weightPerInd = this.totalWeight / (double)nInd;
        this.indArray = new int[nInd + this.numberSites];
        this.indSite = new int[nInd + this.numberSites];
        this.firstInd = new int[this.numberSites + 1];
        this.nIndAtSite = new int[this.numberSites];
        this.nArtifact = new int[this.numberSites];
        this.neighbourProb = new EventProbability[this.numberSites];
        this.numberInd = 0;
        for (s = 0; s < this.numberSites; ++s) {
            this.nIndAtSite[s] = (int)(0.5 + siteWeight[s] / weightPerInd);
            if (this.nIndAtSite[s] < 1) {
                this.nIndAtSite[s] = 1;
            }
            this.firstInd[s] = this.numberInd;
            for (int i = 0; i < this.nIndAtSite[s]; ++i) {
                this.indArray[i + this.numberInd] = s + (mode == 0 ? 0 : i * this.numberSites);
                this.indSite[i + this.numberInd] = s;
            }
            this.nArtifact[s] = mode == 0 ? 1 : this.numberSites;
            this.numberInd += this.nIndAtSite[s];
        }
        this.firstInd[this.numberSites] = this.numberInd;
        for (s = 0; s < this.numberSites; ++s) {
            int t;
            this.neighbourProb[s] = new EventProbability(this.numberSites);
            double strength = 0.0;
            for (t = 0; t < this.numberSites; ++t) {
                if (s == t) continue;
                strength += siteWeight[s] * edgeValue[s][t] + siteWeight[t] * edgeValue[t][s];
            }
            if (strength > 0.0) {
                for (t = 0; t < this.numberSites; ++t) {
                    if (s == t) {
                        this.neighbourProb[s].addProbability(1.0 - strength);
                        continue;
                    }
                    this.neighbourProb[s].addProbability((siteWeight[s] * edgeValue[s][t] + siteWeight[t] * edgeValue[t][s]) / strength);
                }
                continue;
            }
            for (t = 0; t < this.numberSites; ++t) {
                if (s == t) {
                    this.neighbourProb[s].addProbability(1.0);
                    continue;
                }
                this.neighbourProb[s].addProbability(0.0);
            }
        }
    }

    public void evolve(int nevents) {
        int eventnote;
        int eventnotetemp = nevents + 1;
        int tendotcounter = 10;
        double eventnotefactor = 0.01;
        if (eventnotefactor > 0.0) {
            eventnotetemp = (int)((double)nevents * eventnotefactor);
        }
        if (eventnotetemp < 1) {
            eventnotetemp = 1;
        }
        int dotcounter = eventnote = eventnotetemp;
        TimTiming timing = new TimTiming();
        int sourceInd = -1;
        int targetInd = -1;
        int sourceSite = -1;
        int targetSite = -1;
        int sourceCulture = -1;
        int targetCulture = -1;
        int newCulture = -1;
        int e = -1;
        timing.setInitialTime();
        this.message.println(0, " /// Starting Culture Evolution /// ");
        for (int t = 0; t < nevents; ++t) {
            sourceInd = this.Rnd.nextInt(this.numberInd);
            sourceSite = this.indSite[sourceInd];
            e = this.eProb.getEvent(this.Rnd.nextDouble());
            switch (e) {
                case 0: {
                    targetInd = this.firstInd[sourceSite] + this.Rnd.nextInt(this.nIndAtSite[sourceSite]);
                    newCulture = this.indArray[sourceInd];
                    break;
                }
                case 1: {
                    targetSite = this.neighbourProb[sourceSite].getEvent(this.Rnd.nextDouble());
                    targetInd = this.firstInd[targetSite] + this.Rnd.nextInt(this.nIndAtSite[targetSite]);
                    newCulture = this.indArray[sourceInd];
                    break;
                }
                case 2: {
                    targetInd = sourceInd;
                    sourceCulture = this.indArray[sourceSite] % this.numberSites;
                    newCulture = this.nArtifact[sourceCulture] * this.numberSites + sourceCulture;
                    int n = sourceCulture;
                    this.nArtifact[n] = this.nArtifact[n] + 1;
                    break;
                }
                case 3: {
                    targetInd = sourceInd;
                    newCulture = this.nArtifact[sourceSite] * this.numberSites + sourceSite;
                    int n = sourceSite;
                    this.nArtifact[n] = this.nArtifact[n] + 1;
                }
            }
            this.indArray[targetInd] = newCulture;
            if (!this.message.testInformationLevel(1) || 0 != --dotcounter) continue;
            System.out.print(".");
            dotcounter = eventnote;
            if (0 != --tendotcounter) continue;
            System.out.println(" " + timing.runTimeString());
            tendotcounter = 10;
        }
    }

    public double calcHomogeneity(int firstInd, int lastp1Ind) {
        int same = 0;
        for (int i = firstInd; i < lastp1Ind; ++i) {
            for (int j = i + 1; j < lastp1Ind; ++j) {
                if (this.indArray[i] != this.indArray[j]) continue;
                ++same;
            }
        }
        double numberInd = lastp1Ind - firstInd;
        double F2 = (double)same * 2.0 / (numberInd * (numberInd - 1.0));
        return F2;
    }

    public double calcSiteHomogeneity(int firstInd, int lastp1Ind) {
        int same = 0;
        for (int i = firstInd; i < lastp1Ind; ++i) {
            for (int j = i + 1; j < lastp1Ind; ++j) {
                if (this.indArray[i] % this.numberSites != this.indArray[j] % this.numberSites) continue;
                ++same;
            }
        }
        double numberInd = lastp1Ind - firstInd;
        double F2 = (double)same * 2.0 / (numberInd * (numberInd - 1.0));
        return F2;
    }

    public void calcHomogeneity() {
        this.cultureF2 = new double[this.numberSites];
        this.siteCultureF2 = new double[this.numberSites];
        boolean same = false;
        for (int s = 0; s < this.numberSites; ++s) {
            this.siteCultureF2[s] = this.calcSiteHomogeneity(this.firstInd[s], this.firstInd[s + 1]);
            this.cultureF2[s] = this.calcHomogeneity(this.firstInd[s], this.firstInd[s + 1]);
        }
    }

    public void calcCultureVectors() {
        this.siteCultureVector = new double[this.numberSites][this.numberSites];
        this.maxCulture = new double[this.numberSites];
        this.maxCultureSite = new int[this.numberSites];
        boolean same = false;
        double d = -1.0;
        for (int s = 0; s < this.numberSites; ++s) {
            for (int t = 0; t < this.numberSites; ++t) {
                this.siteCultureVector[s][t] = 0.0;
            }
            double oneInd = 1.0 / (double)this.nIndAtSite[s];
            for (int i = this.firstInd[s]; i < this.firstInd[s + 1]; ++i) {
                double[] dArray = this.siteCultureVector[s];
                int n = this.indArray[i] % this.numberSites;
                dArray[n] = dArray[n] + oneInd;
            }
            this.maxCulture[s] = 0.0;
            this.maxCultureSite[s] = -1;
            for (int t = 0; t < this.numberSites; ++t) {
                d = this.siteCultureVector[s][t];
                if (!(d > this.maxCulture[s]) && (d != this.maxCulture[s] || !this.Rnd.nextBoolean())) continue;
                this.maxCulture[s] = d;
                this.maxCultureSite[s] = t;
            }
        }
    }

    public double calcCorrelation(int s, int t) {
        double prod = 0.0;
        double norms = 0.0;
        double normt = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            prod += this.siteCultureVector[s][i] * this.siteCultureVector[t][i];
            norms += this.siteCultureVector[s][i] * this.siteCultureVector[s][i];
            normt += this.siteCultureVector[t][i] * this.siteCultureVector[t][i];
        }
        if (norms > 0.0 && normt > 0.0) {
            prod /= Math.sqrt(norms * normt);
        }
        return prod;
    }

    public void calcCorrelation() {
        this.cultureCorrelation = new double[this.numberSites][this.numberSites];
        for (int s = 0; s < this.numberSites; ++s) {
            for (int t = 0; t < this.numberSites; ++t) {
                this.cultureCorrelation[s][t] = this.calcCorrelation(s, t);
            }
        }
    }

    public void calcAllStats() {
        this.calcCultureVectors();
        this.calcHomogeneity();
        this.calcCorrelation();
    }

    public void print(PrintStream PS, String cc, String sep, int dec) {
        PS.println(this.label(cc, sep));
        for (int s = 0; s < this.numberSites; ++s) {
            PS.println(this.toString(s, cc, sep, dec));
        }
    }

    public String label(String cc, String sep) {
        int s;
        String sss = "";
        sss = cc + sep + "#Ind" + sep + "Max.Cult.Site" + sep + "Max.Cult." + sep + "#Art" + sep + "F2" + sep + "F2Site" + sep;
        for (s = 0; s < this.numberSites; ++s) {
            sss = sss + "Cult." + s + "AT row" + sep;
        }
        sss = sss + "cos(theta)" + sep;
        for (s = 0; s < this.numberSites; ++s) {
            sss = sss + s + sep;
        }
        return sss;
    }

    public String toString(int s, String cc, String sep, int dec) {
        int t;
        NumbersToString n2s = new NumbersToString();
        String sss = "";
        sss = s + sep + this.nIndAtSite[s] + sep + this.maxCultureSite[s] + sep + NumbersToString.toString((double)this.maxCulture[s], (int)dec) + sep + NumbersToString.toString((double)this.nArtifact[s], (int)dec) + sep + NumbersToString.toString((double)this.cultureF2[s], (int)dec) + sep + NumbersToString.toString((double)this.siteCultureF2[s], (int)dec);
        for (t = 0; t < this.numberSites; ++t) {
            sss = sss + sep + NumbersToString.toString((double)this.siteCultureVector[s][t], (int)dec);
        }
        sss = sss + sep + "   ";
        for (t = 0; t < this.numberSites; ++t) {
            sss = sss + sep + NumbersToString.toString((double)this.cultureCorrelation[s][t], (int)dec);
        }
        return sss;
    }

    public class EventProbability {
        double[] prob;
        double[] cummulativeProb;
        int numberProb = -1;

        public EventProbability(int nProb) {
            this.prob = new double[nProb];
            this.cummulativeProb = new double[nProb];
            this.numberProb = 0;
        }

        public EventProbability(EventProbability p) {
            this.numberProb = p.numberProb;
            this.prob = new double[this.numberProb];
            this.cummulativeProb = new double[this.numberProb];
            this.numberProb = 0;
            for (int i = 0; i < this.numberProb; ++i) {
                this.addProbability(p.prob[i]);
            }
        }

        public boolean addProbability(double p) {
            if (this.test(p)) {
                return true;
            }
            this.prob[this.numberProb] = p;
            this.cummulativeProb[this.numberProb] = this.numberProb > 0 ? p + this.cummulativeProb[this.numberProb - 1] : p;
            if (this.test(this.cummulativeProb[this.numberProb])) {
                return true;
            }
            ++this.numberProb;
            return this.test();
        }

        public int getEvent(double r) {
            int e = 0;
            while (r > this.cummulativeProb[e]) {
                ++e;
            }
            return e;
        }

        public boolean test() {
            return !(this.cummulativeProb[this.numberProb - 1] > 1.000001);
        }

        public boolean test(double p) {
            return p > 1.000001 || p < 0.0;
        }

        public String label(String Sep) {
            String s = "";
            for (int i = 0; i < this.numberProb; ++i) {
                s = s + "prob[i]" + Sep;
            }
            return s;
        }

        public String toString(String Sep) {
            String s = "";
            for (int i = 0; i < this.numberProb; ++i) {
                s = s + this.prob[i] + Sep;
            }
            return s;
        }
    }
}

