/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.AriadneIcon;
import IslandNetworks.Edge.EdgeTypeSelection;
import IslandNetworks.Vertex.VertexTypeSelection;
import IslandNetworks.islandNetwork;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class InputParameterFrame
implements ActionListener {
    JFrame inputFrame;
    JPanel buttonPanel;
    JPanel inputPanel;
    JPanel displayPanel;
    JPanel modelNumberPanel;
    JPanel modePanel;
    JPanel DVTPanel;
    JTextField fileOutputValue;
    JTextField runnameValue;
    JTextField muValue;
    JTextField jValue;
    JTextField kappaValue;
    JTextField lambdaValue;
    JTextField distScaleValue;
    JTextField reldistScaleValue;
    JTextField alphaValue;
    JTextField betaValue;
    JTextField bValue;
    JTextField gammaValue;
    JTextField updateModeValue;
    JTextField maxVertexValue;
    JTextField edgeModeValue;
    JTextField majorModelNumberValue;
    JTextField minorModelNumberValue;
    JLabel fileInputValue;
    JLabel fileInputMessage;
    JLabel fileOutputMessage;
    JLabel runnameMessage;
    JLabel muMessage;
    JLabel jMessage;
    JLabel kappaMessage;
    JLabel lambdaMessage;
    JLabel distScaleMessage;
    JLabel reldistScaleMessage;
    JLabel alphaMessage;
    JLabel betaMessage;
    JLabel bMessage;
    JLabel gammaMessage;
    JLabel updateModeMessage;
    JLabel maxVertexMessage;
    JLabel edgeModeMessage;
    JLabel modelNumberMessage;
    JLabel notInPPAlabel = new JLabel("Not used in PPA", 4);
    JTextField sSFValue;
    JTextField eWFValue;
    JTextField mCFValue;
    JTextField zCFValue;
    JTextField DMVSValue;
    JTextField DMESValue;
    JTextField ipValue;
    JTextField ctsValue;
    JLabel sSFMessage;
    JLabel eWFMessage;
    JLabel mCFMessage;
    JLabel zCFMessage;
    JLabel DMVSMessage;
    JLabel DMESMessage;
    JLabel DVTMessage;
    JLabel ipMessage;
    JLabel ctsMessage;
    JRadioButton InfluenceMode;
    JRadioButton RankMode;
    JRadioButton SizeMode;
    JLabel SWMMessage;
    JPanel SWMPanel1;
    JPanel SWMPanel2;
    ButtonGroup SWMGroup;
    JRadioButton alphaMode;
    JRadioButton weightMode;
    JRadioButton rankMode;
    JRadioButton rankOverWeightMode;
    JLabel messageLabel;
    JLabel drawMessageLabel;
    JButton calcButton;
    JButton drawButton;
    JCheckBox mcHotStartCB;
    JCheckBox autonameCB;
    JComboBox calcModeChooser;
    JComboBox mcStartChooser;
    String resMessage = "OK";
    private islandNetwork inet;
    private static final double betaInitialMCnew = 3.0;
    private static final double betaInitialRWGM = 1.1;
    private String betaInitialText = "UNSET";
    private String betaInitialTextTip = "NOT YET SET";
    private double betaInitialValue = 3.0;

    public InputParameterFrame(islandNetwork inetinput) {
        this.inet = inetinput;
        Calendar cal = Calendar.getInstance();
        String time = cal.get(10) + ":" + cal.get(12) + ":" + cal.get(13) + "." + cal.get(14);
        this.inputFrame = new JFrame("Parameters for " + this.inet.inputFile.getNameRoot() + " " + time);
        this.inputFrame.setDefaultCloseOperation(2);
        this.inputFrame.setSize(new Dimension(400, 400));
        this.inputFrame.setIconImage(new AriadneIcon().getPotBlue16());
        this.buttonPanel = new JPanel(new GridLayout(1, 2));
        this.inputPanel = new JPanel(new GridLayout(16, 2));
        this.displayPanel = new JPanel(new GridLayout(13, 2));
        this.addWidgets();
        this.inputFrame.getRootPane().setDefaultButton(this.calcButton);
        this.calcButton = new JButton("CALCULATE");
        this.buttonPanel.add(this.calcButton);
        this.calcButton.addActionListener(this);
        this.drawButton = new JButton("REDRAW");
        this.buttonPanel.add(this.drawButton);
        this.drawButton.addActionListener(this);
        this.inputFrame.getContentPane().add((Component)this.inputPanel, "West");
        this.inputFrame.getContentPane().add((Component)this.displayPanel, "East");
        this.inputFrame.getContentPane().add((Component)this.buttonPanel, "South");
        this.inputFrame.pack();
        this.inputFrame.setVisible(true);
    }

    private void addWidgets() {
        int m;
        islandNetwork i = this.inet;
        this.fileInputMessage = new JLabel("Basic Input File Name ", 4);
        this.fileInputValue = new JLabel(this.inet.inputFile.getFullFileRoot(), 0);
        this.inputPanel.add(this.fileInputMessage);
        this.inputPanel.add(this.fileInputValue);
        this.calcModeChooser = new JComboBox();
        this.mcStartChooser = new JComboBox();
        this.autonameCB = new JCheckBox("Automatic Output File Names");
        this.autonameCB.setSelected(true);
        String edgeModeInitial = "" + i.edgeSet.edgeMode.edgeModeValue();
        this.edgeModeValue = new JTextField(edgeModeInitial, 4);
        this.edgeModeMessage = new JLabel("Maximum Edge Value ", 4);
        this.setToolTipText(this.edgeModeValue, this.edgeModeMessage, "Maximum value to allow for edge");
        String maxVertexInitial = "" + i.vertexMode.getModeValue();
        this.maxVertexValue = new JTextField(maxVertexInitial, 4);
        this.maxVertexMessage = new JLabel("Vertex Mode Value ", 4);
        this.setToolTipText(this.maxVertexValue, this.maxVertexMessage, "Max. vertex value if positive, minus the max weight if negative");
        this.modelNumberPanel = new JPanel(new GridLayout(1, 3));
        String majorInitial = i.modelNumber.major + " ";
        String minorInitial = i.modelNumber.minor + " ";
        this.majorModelNumberValue = new JTextField(majorInitial, 1);
        this.minorModelNumberValue = new JTextField(minorInitial, 1);
        this.modelNumberPanel.add(this.majorModelNumberValue);
        this.modelNumberPanel.add(new JLabel("."));
        this.modelNumberPanel.add(this.minorModelNumberValue);
        this.modelNumberMessage = new JLabel("Model Number ", 4);
        this.modelNumberMessage.setToolTipText("Model numbers are used to choose different MC Hamiltonians");
        this.fileOutputValue = new JTextField(this.inet.outputFile.getBasicRoot(), 16);
        this.fileOutputMessage = new JLabel("Basic Root for Output Files ", 4);
        this.setToolTipText(this.fileOutputValue, this.fileOutputMessage, "Output files will start with this string");
        this.runnameValue = new JTextField("" + this.inet.outputFile.sequenceNumber, 16);
        this.runnameMessage = new JLabel("Run Number ", 4);
        this.setToolTipText(this.runnameValue, this.runnameMessage, "Number used to distinguish different runs with same parameters");
        String jInitial = "" + i.Hamiltonian.vertexSource;
        this.jValue = new JTextField(jInitial, 4);
        this.jMessage = new JLabel("j ", 4);
        this.setToolTipText(this.jValue, this.jMessage, "Value of j parameter in Hamiltonian");
        String muInitial = "" + i.Hamiltonian.edgeSource;
        this.muValue = new JTextField(muInitial, 4);
        this.muMessage = new JLabel("mu ", 4);
        this.setToolTipText(this.muValue, this.muMessage, "Value of mu parameter in Hamiltonian");
        String kappaInitial = "" + i.Hamiltonian.kappa;
        this.kappaValue = new JTextField(kappaInitial, 4);
        this.kappaMessage = new JLabel("kappa ", 4);
        this.setToolTipText(this.kappaValue, this.kappaMessage, "Value of kappa parameter in Hamiltonian");
        String lambdaInitial = "" + i.Hamiltonian.lambda;
        this.lambdaValue = new JTextField(lambdaInitial, 4);
        this.lambdaMessage = new JLabel("lambda ", 4);
        this.setToolTipText(this.lambdaValue, this.lambdaMessage, "Value of lambda parameter in Hamiltonian");
        String distScaleInitial = "" + i.Hamiltonian.distanceScale;
        this.distScaleValue = new JTextField(distScaleInitial, 4);
        this.distScaleMessage = new JLabel("Distance Scale ", 4);
        this.setToolTipText(this.distScaleValue, this.distScaleMessage, "Value of distance scale used in all models");
        String reldistScaleInitial = "" + i.Hamiltonian.shortDistanceScale;
        this.reldistScaleValue = new JTextField(reldistScaleInitial, 4);
        this.reldistScaleMessage = new JLabel("Short Distance ", 4);
        this.setToolTipText(this.reldistScaleValue, this.reldistScaleMessage, "Value of short distance scale used only in MC");
        String betaInitial = "" + this.betaInitialValue;
        this.betaValue = new JTextField(betaInitial, 4);
        this.betaMessage = new JLabel(this.betaInitialText, 4);
        String bInitial = "" + i.Hamiltonian.getb();
        this.bValue = new JTextField(bInitial, 4);
        this.bMessage = new JLabel("b ", 4);
        this.bValue.setEnabled(false);
        this.setToolTipText(this.bValue, this.bMessage, "Non linear site parameter used in old MC models");
        this.calcModeChooser.setToolTipText("Choose calculational mode");
        for (m = 0; m < i.updateMode.getNumberModes(); ++m) {
            this.calcModeChooser.addItem(i.updateMode.getString(m));
        }
        this.calcModeChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((InputParameterFrame)InputParameterFrame.this).inet.updateMode.set(InputParameterFrame.this.calcModeChooser.getSelectedIndex());
                InputParameterFrame.this.mcStartChooser.setEnabled(((InputParameterFrame)InputParameterFrame.this).inet.updateMode.isMC());
                InputParameterFrame.this.edgeModeValue.setEnabled(((InputParameterFrame)InputParameterFrame.this).inet.updateMode.isMC());
                InputParameterFrame.this.maxVertexValue.setEnabled(((InputParameterFrame)InputParameterFrame.this).inet.updateMode.isMC());
                InputParameterFrame.this.majorModelNumberValue.setEnabled(((InputParameterFrame)InputParameterFrame.this).inet.updateMode.isMC());
                InputParameterFrame.this.minorModelNumberValue.setEnabled(((InputParameterFrame)InputParameterFrame.this).inet.updateMode.isMC());
                InputParameterFrame.this.jValue.setEnabled(((InputParameterFrame)InputParameterFrame.this).inet.updateMode.isMC());
                InputParameterFrame.this.muValue.setEnabled(((InputParameterFrame)InputParameterFrame.this).inet.updateMode.isMC());
                InputParameterFrame.this.kappaValue.setEnabled(((InputParameterFrame)InputParameterFrame.this).inet.updateMode.isMC());
                InputParameterFrame.this.lambdaValue.setEnabled(((InputParameterFrame)InputParameterFrame.this).inet.updateMode.isMC());
                InputParameterFrame.this.distScaleValue.setEnabled(!((InputParameterFrame)InputParameterFrame.this).inet.updateMode.isPPA());
                InputParameterFrame.this.reldistScaleValue.setEnabled(((InputParameterFrame)InputParameterFrame.this).inet.updateMode.isMC());
                InputParameterFrame.this.setBetaStuff(InputParameterFrame.this.inet);
                InputParameterFrame.this.betaValue.setText("" + InputParameterFrame.this.betaInitialValue);
                InputParameterFrame.this.betaMessage.setText(InputParameterFrame.this.betaInitialText);
                InputParameterFrame.this.betaValue.setToolTipText(InputParameterFrame.this.betaInitialTextTip);
                InputParameterFrame.this.betaMessage.setToolTipText(InputParameterFrame.this.betaInitialTextTip);
            }
        });
        this.calcModeChooser.setSelectedIndex(i.updateMode.getNumber());
        this.inputPanel.add(this.calcModeChooser);
        this.mcStartChooser.setToolTipText("Choose Monte Carlo starting configuration");
        for (m = 0; m < i.monteCarloStartMode.getNumberModes(); ++m) {
            this.mcStartChooser.addItem(i.monteCarloStartMode.getString(m));
        }
        this.mcStartChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((InputParameterFrame)InputParameterFrame.this).inet.monteCarloStartMode.set(InputParameterFrame.this.mcStartChooser.getSelectedIndex());
            }
        });
        this.mcStartChooser.setEnabled(this.inet.updateMode.isMC());
        this.mcStartChooser.setSelectedIndex(i.monteCarloStartMode.getNumber());
        this.inputPanel.add(this.mcStartChooser);
        this.inputPanel.add(this.autonameCB);
        this.inputPanel.add(new JLabel());
        this.inputPanel.add(this.edgeModeMessage);
        this.inputPanel.add(this.edgeModeValue);
        this.inputPanel.add(this.maxVertexMessage);
        this.inputPanel.add(this.maxVertexValue);
        this.inputPanel.add(this.modelNumberMessage);
        this.inputPanel.add(this.modelNumberPanel);
        this.inputPanel.add(this.fileOutputMessage);
        this.inputPanel.add(this.fileOutputValue);
        this.inputPanel.add(this.runnameMessage);
        this.inputPanel.add(this.runnameValue);
        this.inputPanel.add(this.jMessage);
        this.inputPanel.add(this.jValue);
        this.inputPanel.add(this.muMessage);
        this.inputPanel.add(this.muValue);
        this.inputPanel.add(this.kappaMessage);
        this.inputPanel.add(this.kappaValue);
        this.inputPanel.add(this.lambdaMessage);
        this.inputPanel.add(this.lambdaValue);
        this.inputPanel.add(this.distScaleMessage);
        this.inputPanel.add(this.distScaleValue);
        this.inputPanel.add(this.reldistScaleMessage);
        this.inputPanel.add(this.reldistScaleValue);
        if (this.inet.updateMode.isPPA()) {
            i.Hamiltonian.beta = 3.0;
        }
        this.setBetaStuff(i);
        this.inputPanel.add(this.betaMessage);
        this.inputPanel.add(this.betaValue);
        this.displayPanel.add(new JLabel("<html><em>Display Variables</em></html>", 0));
        this.displayPanel.add(new JLabel("<html><em>Values</em>", 2));
        String sSFInitial = "" + i.siteWeightFactor;
        this.sSFValue = new JTextField(sSFInitial, 4);
        this.sSFMessage = new JLabel("<html>Maximum Site Size </html>", 4);
        this.displayPanel.add(this.sSFMessage);
        this.displayPanel.add(this.sSFValue);
        String eWFInitial = "" + i.edgeWidthFactor;
        this.eWFValue = new JTextField(eWFInitial, 4);
        this.eWFMessage = new JLabel("<html>Maximum Edge Width </html>", 4);
        this.displayPanel.add(this.eWFMessage);
        this.displayPanel.add(this.eWFValue);
        String zCFInitial = String.format("%6.4f", i.edgeSet.zeroColourFrac);
        this.zCFValue = new JTextField(zCFInitial, 4);
        this.zCFMessage = new JLabel("<html>Edge Minimum Fraction (grey) </html>", 4);
        this.zCFMessage.setToolTipText("Minimum edge weight before edge shown at all.\nIf not in colour, this edge will be light grey and of minimum thickness.");
        this.displayPanel.add(this.zCFMessage);
        this.displayPanel.add(this.zCFValue);
        String mCFInitial = String.format("%6.4f", i.edgeSet.minColourFrac);
        this.mCFValue = new JTextField(mCFInitial, 4);
        this.mCFMessage = new JLabel("<html>Edge Minimum Fraction (colour) </html>", 4);
        this.mCFMessage.setToolTipText("Minimum edge weight before edge shown in colour, given as a fraction of maximum value.");
        this.displayPanel.add(this.mCFMessage);
        this.displayPanel.add(this.mCFValue);
        String DMVSInitial = "" + i.DisplayMaxVertexScale;
        this.DMVSValue = new JTextField(DMVSInitial, 4);
        this.DMVSMessage = new JLabel("<html>Max. Vertex Size </html>", 4);
        this.displayPanel.add(this.DMVSMessage);
        this.displayPanel.add(this.DMVSValue);
        String DMESInitial = "" + i.edgeSet.DisplayMaxEdgeScale;
        this.DMESValue = new JTextField(DMESInitial, 4);
        this.DMESMessage = new JLabel("<html>Max. Edge Size </html>", 4);
        this.displayPanel.add(this.DMESMessage);
        this.displayPanel.add(this.DMESValue);
        String ipInitial = "" + i.influenceProb;
        this.ipValue = new JTextField(ipInitial, 4);
        this.ipMessage = new JLabel("<html>Influence Prob.</html>", 4);
        this.displayPanel.add(this.ipMessage);
        this.displayPanel.add(this.ipValue);
        String ctsInitial = "" + i.cultureTimeScale;
        this.ctsValue = new JTextField(ctsInitial, 4);
        this.ctsMessage = new JLabel("<html>Culture Time</html>", 4);
        this.displayPanel.add(this.ctsMessage);
        this.displayPanel.add(this.ctsValue);
        final JComboBox<String> vertexChooser = new JComboBox<String>();
        vertexChooser.setToolTipText("Choose type of vertex to display");
        for (int t = 0; t < VertexTypeSelection.numberTypes; ++t) {
            vertexChooser.addItem(VertexTypeSelection.name[t]);
        }
        vertexChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((InputParameterFrame)InputParameterFrame.this).inet.DisplayVertexType.setValue(vertexChooser.getSelectedIndex());
            }
        });
        this.DVTMessage = new JLabel("<html>Display vertices by</html>", 4);
        this.displayPanel.add(this.DVTMessage);
        this.displayPanel.add(vertexChooser);
        final JComboBox<String> edgeTypeChooser = new JComboBox<String>();
        edgeTypeChooser.setToolTipText("Choose type of edge to display");
        for (int t = 0; t < EdgeTypeSelection.numberTypes; ++t) {
            edgeTypeChooser.addItem(EdgeTypeSelection.name[t]);
        }
        vertexChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((InputParameterFrame)InputParameterFrame.this).inet.edgeSet.DisplayEdgeType.setValue(edgeTypeChooser.getSelectedIndex());
            }
        });
        this.DVTMessage = new JLabel("<html>Display edges by</html>", 4);
        this.displayPanel.add(this.DVTMessage);
        this.displayPanel.add(edgeTypeChooser);
        this.SWMGroup = new ButtonGroup();
        JRadioButton numMode = new JRadioButton("Num.");
        numMode.setActionCommand("SWNum");
        this.alphaMode = new JRadioButton("Alph.");
        this.alphaMode.setActionCommand("SWAlpha");
        this.weightMode = new JRadioButton("Weight");
        this.weightMode.setActionCommand("SWWeight");
        this.rankMode = new JRadioButton("Rank");
        this.rankMode.setActionCommand("SWRank");
        this.rankOverWeightMode = new JRadioButton("Rank/Weight");
        this.rankOverWeightMode.setActionCommand("SWRankOverWeight");
        this.SWMGroup.add(numMode);
        this.SWMGroup.add(this.alphaMode);
        this.SWMGroup.add(this.weightMode);
        this.SWMGroup.add(this.rankMode);
        this.SWMGroup.add(this.rankOverWeightMode);
        this.SWMPanel1 = new JPanel(new GridLayout(1, 3));
        this.SWMPanel1.add(numMode);
        this.SWMPanel1.add(this.alphaMode);
        this.SWMPanel1.add(this.weightMode);
        this.SWMPanel2 = new JPanel(new GridLayout(1, 3));
        this.SWMPanel2.add(this.rankMode);
        this.SWMPanel2.add(this.rankOverWeightMode);
        switch (this.inet.siteWindowMode.value) {
            case 4: {
                this.rankOverWeightMode.setSelected(true);
                break;
            }
            case 2: {
                this.rankMode.setSelected(true);
                break;
            }
            case 1: {
                this.weightMode.setSelected(true);
                break;
            }
            case 0: {
                numMode.setSelected(true);
                break;
            }
            default: {
                this.alphaMode.setSelected(true);
            }
        }
        this.SWMMessage = new JLabel("Site Window by", 4);
        this.displayPanel.add(this.SWMMessage);
        this.displayPanel.add(this.SWMPanel1);
        this.displayPanel.add(new JLabel(" "));
        this.displayPanel.add(this.SWMPanel2);
        RadioListener modeListener = new RadioListener();
        numMode.addActionListener(modeListener);
        this.alphaMode.addActionListener(modeListener);
        this.weightMode.addActionListener(modeListener);
        this.rankMode.addActionListener(modeListener);
        this.rankOverWeightMode.addActionListener(modeListener);
    }

    private void setToolTipText(JTextField tf, JLabel jl, String ttt) {
        tf.setToolTipText(ttt);
        jl.setToolTipText(ttt);
    }

    private void setBetaStuff(islandNetwork i) {
        this.betaValue.setEnabled(false);
        if (this.inet.updateMode.isMC()) {
            if (this.inet.monteCarloStartMode.isMode("Old")) {
                this.betaInitialValue = i.Hamiltonian.beta;
            }
            this.betaValue.setEnabled(true);
        } else {
            this.betaInitialValue = 3.0;
        }
        if (this.inet.updateMode.isRWGM()) {
            this.betaValue.setEnabled(true);
            this.betaInitialValue = 1.1;
            this.betaInitialText = "Power of W ";
            this.betaInitialTextTip = "Power to raise W (site inputs)";
        } else {
            this.betaInitialText = "Initial beta ";
            this.betaInitialTextTip = "Initial value of inverse temperature for Monte Carlo";
        }
        this.betaValue.setText(Double.toString(this.betaInitialValue));
        this.betaMessage.setText(this.betaInitialText);
        this.betaValue.setToolTipText(this.betaInitialTextTip);
        this.betaMessage.setToolTipText(this.betaInitialTextTip);
    }

    public void actionPerformed(ActionEvent event) {
        block13: {
            int res = 0;
            try {
                double j;
                double mu;
                String command = event.getActionCommand();
                this.inet.inputFile.setNameRoot(this.fileInputValue.getText());
                this.inet.outputFile.setNameRoot(this.fileOutputValue.getText());
                this.inet.outputFile.sequenceNumber = Integer.parseInt(this.runnameValue.getText());
                this.inet.autoSetOutputFileName = this.autonameCB.isSelected();
                this.inet.edgeSet.edgeMode.setEdgeMode(Double.parseDouble(this.edgeModeValue.getText()));
                this.inet.vertexMode.setVertexMode(Double.parseDouble(this.maxVertexValue.getText()));
                this.inet.Hamiltonian.edgeSource = mu = Double.parseDouble(this.muValue.getText());
                this.inet.Hamiltonian.vertexSource = j = Double.parseDouble(this.jValue.getText());
                this.inet.Hamiltonian.kappa = Double.parseDouble(this.kappaValue.getText());
                this.inet.Hamiltonian.lambda = Double.parseDouble(this.lambdaValue.getText());
                this.inet.Hamiltonian.distanceScale = Double.parseDouble(this.distScaleValue.getText());
                this.inet.Hamiltonian.shortDistanceScale = Double.parseDouble(this.reldistScaleValue.getText());
                this.inet.betaInitial = Double.parseDouble(this.betaValue.getText());
                this.inet.Hamiltonian.setb(Double.parseDouble(this.bValue.getText()));
                double nmn = Double.parseDouble(this.minorModelNumberValue.getText());
                double jmn = Double.parseDouble(this.majorModelNumberValue.getText());
                this.inet.modelNumber.set(jmn, nmn);
                this.inet.siteWeightFactor = (int)(Double.parseDouble(this.sSFValue.getText()) + 0.5);
                this.inet.edgeWidthFactor = (int)(Double.parseDouble(this.eWFValue.getText()) + 0.5);
                this.inet.edgeSet.zeroColourFrac = Double.parseDouble(this.zCFValue.getText());
                this.inet.edgeSet.minColourFrac = Double.parseDouble(this.mCFValue.getText());
                this.inet.DisplayMaxVertexScale = Double.parseDouble(this.DMVSValue.getText());
                this.inet.edgeSet.DisplayMaxEdgeScale = Double.parseDouble(this.DMESValue.getText());
                this.inet.influenceProb = Double.parseDouble(this.ipValue.getText());
                this.inet.cultureTimeScale = Double.parseDouble(this.ctsValue.getText());
                this.inet.setOutputFileName();
                if (command.equals("CALCULATE")) {
                    if (this.inet.message.getInformationLevel() > 0) {
                        this.inet.printNetworkForData("#", 3);
                    }
                    System.out.println("Calculating using " + this.inet.updateMode.toLongString());
                    switch (this.inet.updateMode.getNumber()) {
                        case 0: {
                            this.inet.doPPA();
                            break;
                        }
                        case 1: {
                            this.inet.doMC();
                            break;
                        }
                        case 2: {
                            this.inet.doDP();
                            break;
                        }
                        case 3: {
                            this.inet.doVP();
                            break;
                        }
                        case 4: {
                            this.inet.doGM();
                            break;
                        }
                        case 5: {
                            this.inet.doRW();
                            break;
                        }
                        case 6: {
                            this.inet.doSimpleGM();
                            break;
                        }
                        default: {
                            System.err.println("Unknown calculational mode in InputParameterFrame " + this.inet.monteCarloStartMode.getNumber());
                        }
                    }
                }
                this.inet.showNetwork("#", 3);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                res = 10;
                this.resMessage = "Input Window actionPerformed error: " + e;
                this.inet.message.println(-2, this.resMessage);
                if (this.inet.message.getInformationLevel() < -2) break block13;
                JOptionPane.showMessageDialog(this.inputFrame, this.resMessage, "Input Parameter Window Error", 0);
            }
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("SWNum")) {
                ((InputParameterFrame)InputParameterFrame.this).inet.siteWindowMode.value = 0;
            }
            if (command.equals("SWAlpha")) {
                ((InputParameterFrame)InputParameterFrame.this).inet.siteWindowMode.value = 3;
            }
            if (command.equals("SWWeight")) {
                ((InputParameterFrame)InputParameterFrame.this).inet.siteWindowMode.value = 1;
            }
            if (command.equals("SWRank")) {
                ((InputParameterFrame)InputParameterFrame.this).inet.siteWindowMode.value = 2;
            }
            if (command.equals("SWRankOverWeight")) {
                ((InputParameterFrame)InputParameterFrame.this).inet.siteWindowMode.value = 4;
            }
        }
    }
}

