/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.AriadneIcon;
import IslandNetworks.InputParameterFrame;
import IslandNetworks.islandNetwork;
import IslandNetworks.licence;
import TimUtilities.FileUtilities.GeneralEndingFilter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class InputDataFrame
extends JPanel
implements ActionListener {
    islandNetwork inet;
    JFrame infileFrame;
    Box contentBox;
    JPanel infilePanel;
    JPanel inputPanel;
    JPanel jigglePanel;
    JPanel buttonPanel;
    JTextField fileInputValue;
    JTextField jiggleScaleInputValue;
    JLabel fileInputMessage;
    JLabel messageLabel;
    JLabel jiggleMessage;
    JButton openButton;
    JButton readButton;
    String resMessage = "OK";
    JFileChooser fc;

    public InputDataFrame(islandNetwork inetinput) {
        this.inet = inetinput;
    }

    public void drawFrame() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InputDataFrame.this.createAndShowIDF();
            }
        });
    }

    protected static Image getFDImage(String name) {
        URL imgURL = InputDataFrame.class.getResource(name);
        if (imgURL != null) {
            return new ImageIcon(imgURL).getImage();
        }
        return null;
    }

    private void createAndShowIDF() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.infileFrame = new JFrame("Input File Name - Ariadne iN110401");
        this.infileFrame.setDefaultCloseOperation(3);
        this.infileFrame.setSize(new Dimension(800, 800));
        this.infileFrame.setIconImage(new AriadneIcon().getPot16());
        this.contentBox = Box.createVerticalBox();
        this.infilePanel = new JPanel(new GridLayout(2, 2));
        this.infilePanel.add(new JLabel("Basic Input File Name", 0));
        this.fileInputValue = new JTextField(this.inet.inputFile.getFullFileRoot(), 24);
        this.infilePanel.add(this.fileInputValue);
        this.infilePanel.add(new JLabel("Jiggle Scale ", 0));
        this.jiggleScaleInputValue = new JTextField(Double.toString(this.inet.jiggleScale), 4);
        this.infilePanel.add(this.jiggleScaleInputValue);
        this.contentBox.add(this.infilePanel);
        this.buttonPanel = new JPanel(new GridLayout(1, 2));
        this.fc = new JFileChooser(".");
        this.fc.addChoosableFileFilter((FileFilter)new GeneralEndingFilter("_input"));
        this.fc.setAcceptAllFileFilterUsed(false);
        this.fc.setDialogTitle("Open Ariadne Input File");
        this.openButton = new JButton("BROWSE");
        this.buttonPanel.add(this.openButton);
        this.openButton.addActionListener(this);
        this.readButton = new JButton("READ");
        this.buttonPanel.add(this.readButton);
        this.readButton.addActionListener(this);
        this.infileFrame.getRootPane().setDefaultButton(this.readButton);
        this.contentBox.add(this.buttonPanel);
        licence.showCiteMessageDialog(this.infileFrame);
        this.infileFrame.getContentPane().add(this.contentBox);
        this.infileFrame.pack();
        this.infileFrame.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        int res = 0;
        try {
            String command = event.getActionCommand();
            if (this.inet.message.getInformationLevel() > 2) {
                System.out.println(command);
            }
            boolean tryToReadData = false;
            if (event.getSource() == this.openButton) {
                int returnVal = this.fc.showOpenDialog(this);
                if (returnVal == 0) {
                    tryToReadData = true;
                    File file = this.fc.getSelectedFile();
                    this.inet.inputFile.setFileLocationSimpleName(file);
                } else {
                    this.inet.message.infoWarningBox(-1, this.infileFrame, "Can not find file " + this.inet.inputFile.getNameRoot(), "Input File Warning");
                }
            }
            if (command.equals("READ")) {
                tryToReadData = true;
                this.inet.inputFile.setNameRoot(this.fileInputValue.getText());
            }
            if (tryToReadData) {
                this.inet.jiggleScale = Double.parseDouble(this.jiggleScaleInputValue.getText());
                if (this.inet.message.getInformationLevel() > 2) {
                    System.out.println(this.inet.inputFile.getFullFileRoot());
                }
                if ((res = this.inet.getSiteData()) < 0) {
                    this.resMessage = "Simple Site Data reading failed - return code " + res + " trying full distance data read";
                    this.inet.message.println(0, this.resMessage);
                    this.inet.message.infoMessageBox(0, this.infileFrame, this.resMessage + ", file " + this.inet.inputFile.getNameRoot());
                } else {
                    this.inet.dataread = true;
                    this.inet.outputFile.setBasicRoot(this.inet.inputFile.getBasicRoot());
                    if (this.inet.message.testInformationLevel(1)) {
                        this.inet.showFixedSiteVariables("#", 3);
                        this.inet.showDistanceValues("#", 3);
                    }
                    this.resMessage = "Data reading OK,  number of sites is " + this.inet.numberSites;
                    this.inet.message.println(0, this.resMessage);
                    this.inet.message.infoMessageBox(-1, this.infileFrame, this.resMessage + ", file " + this.inet.inputFile.getNameRoot());
                }
                InputParameterFrame iw = new InputParameterFrame(this.inet);
            }
        }
        catch (Exception e) {
            res = 10;
            this.inet.dataread = false;
            this.resMessage = "Ariadne Error: " + e;
            this.inet.message.println(-1, this.resMessage);
            this.inet.message.infoMessageBox(-1, this.infileFrame, this.resMessage + ", file " + this.inet.inputFile.getNameRoot());
        }
    }

    private class ariadnePicture
    extends JPanel {
        Image img;

        public ariadnePicture() {
            this.setMinimumSize(new Dimension(100, 100));
            this.setPreferredSize(new Dimension(400, 400));
        }

        public void init() {
            this.img = Toolkit.getDefaultToolkit().getImage("images/ariadneanddionysos.jpg");
        }

        public void paint(Graphics g) {
            g.drawImage(this.img, 0, 0, this);
        }
    }
}

