/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.islandNetwork;
import java.awt.GridLayout;
import java.io.PrintStream;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GlobalProperties {
    static final double DUNSET = -1.3579E24;
    private double[] value;
    static final int UNIQUENAMELENGTH = 6;
    public static final String[] name = new String[]{"Energy", "TEWeight", "InSSEntropy", "OutSSEntropy", "EWEntropy", "EWMInformation", "EWMIDistance"};
    static final String[] longName = new String[]{"Energy", "Total Edge Weight", "In Site Strength Entropy", "Out Site Strength Entropy", "Edge Weight Entropy", "Edge Weight Mutual Information ", "Edge Weight M.I. Distance"};
    static final int EnergINDEX = GlobalProperties.getIndex("Energy");
    static final int TEWeiINDEX = GlobalProperties.getIndex("TEWeight");
    static final int InSSEINDEX = GlobalProperties.getIndex("InSSEntropy");
    static final int OutSSINDEX = GlobalProperties.getIndex("OutSSEntropy");
    static final int EWEntINDEX = GlobalProperties.getIndex("EWEntropy");
    static final int EWMInINDEX = GlobalProperties.getIndex("EWMInformation");
    static final int EWMIDINDEX = GlobalProperties.getIndex("EWMIDistance");

    public GlobalProperties() {
        this.initialise();
    }

    public GlobalProperties(GlobalProperties old) {
        this.initialise();
        for (int i = 0; i < name.length; ++i) {
            this.value[i] = old.getValue(i);
        }
    }

    private void initialise() {
        this.value = new double[name.length];
        for (int i = 0; i < name.length; ++i) {
            this.value[i] = -1.3579E24;
        }
    }

    public double getValue(int i) {
        return this.value[i];
    }

    public String getValueString(int i) {
        double v = this.getValue(i);
        if (v == -1.3579E24) {
            return "UNSET";
        }
        return String.format("%12.6g", v);
    }

    public double getEnergy() {
        return this.value[EnergINDEX];
    }

    public double getTotalEdgeWeight() {
        return this.value[TEWeiINDEX];
    }

    public double getInSiteStrengthEntropy() {
        return this.value[InSSEINDEX];
    }

    public double getOutSiteStrengthEntropy() {
        return this.value[OutSSINDEX];
    }

    public double getMutualInformation() {
        return this.value[EWMInINDEX];
    }

    public double getMutualInformationDistance() {
        return this.value[EWMIDINDEX];
    }

    public void calculateAll(islandNetwork inet) {
        this.calcEnergy(inet);
        this.calcEntropies(inet);
    }

    public void calcEnergy(islandNetwork inet) {
        double energy = 0.0;
        double supply = 1.0;
        double demand = 1.0;
        double sourceWeight = -1.0;
        switch (inet.modelNumber.major) {
            case 1: {
                for (int s = 0; s < inet.numberSites; ++s) {
                    sourceWeight = inet.siteSet.getWeight(s);
                    supply = inet.modelNumber.bit0 ? sourceWeight : 1.0;
                    energy += inet.Hamiltonian.vertexSource * sourceWeight;
                    energy -= inet.Hamiltonian.vertexPotential1(inet.siteSet.getSize(s), inet.siteSet.getValue(s));
                    for (int t = 0; t < inet.numberSites; ++t) {
                        demand = inet.modelNumber.bit1 ? inet.siteSet.getWeight(t) : 1.0;
                        energy -= inet.edgeSet.getEdgePotential1(s, t) * inet.edgeSet.getEdgeValue(s, t) * demand * supply;
                        energy += inet.Hamiltonian.edgeSource * sourceWeight * inet.edgeSet.getEdgeValue(s, t);
                    }
                }
                break;
            }
        }
        this.value[GlobalProperties.EnergINDEX] = energy;
    }

    public void calcEntropies(islandNetwork inet) {
        double mutualInformation = 0.0;
        double totalEdgeWeight = 0.0;
        double inSiteStrengthEntropy = 0.0;
        double outSiteStrengthEntropy = 0.0;
        double edgeWeightEntropy = 0.0;
        for (int s = 0; s < inet.numberSites; ++s) {
            totalEdgeWeight += inet.siteSet.getStrengthIn(s);
        }
        this.value[GlobalProperties.TEWeiINDEX] = totalEdgeWeight;
        double ps = -1.0;
        double pt = -1.0;
        if (totalEdgeWeight > 1.0E-10) {
            for (int s = 0; s < inet.numberSites; ++s) {
                ps = inet.siteSet.getStrengthOut(s) / totalEdgeWeight;
                if (ps > 1.0E-10) {
                    outSiteStrengthEntropy -= ps * Math.log(ps);
                }
                for (int t = 0; t < inet.numberSites; ++t) {
                    double few;
                    pt = inet.siteSet.getStrengthIn(t) / totalEdgeWeight;
                    if (pt > 1.0E-10) {
                        inSiteStrengthEntropy -= pt * Math.log(pt);
                    }
                    if ((few = inet.edgeSet.getEdgeWeight(s, t) / totalEdgeWeight) > 1.0E-10) {
                        edgeWeightEntropy -= few * Math.log(few);
                    }
                    if (few < 1.0E-10 || ps < 1.0E-10 || pt < 1.0E-10) continue;
                    mutualInformation += few * Math.log(few / (ps * pt));
                }
            }
        }
        double miDistance = 0.0;
        if (edgeWeightEntropy > 1.0E-10) {
            miDistance = 1.0 - mutualInformation / edgeWeightEntropy;
        }
        this.value[GlobalProperties.InSSEINDEX] = inSiteStrengthEntropy;
        this.value[GlobalProperties.OutSSINDEX] = outSiteStrengthEntropy;
        this.value[GlobalProperties.EWEntINDEX] = edgeWeightEntropy;
        this.value[GlobalProperties.EWMInINDEX] = mutualInformation;
        this.value[GlobalProperties.EWMIDINDEX] = miDistance;
    }

    public static int getIndex(String input) {
        String s = input.substring(0, 6);
        for (int v = 0; v < name.length; ++v) {
            if (!name[v].startsWith(s)) continue;
            return v;
        }
        return -1;
    }

    public void print(PrintStream PS, String sep) {
        for (int i = 0; i < name.length; ++i) {
            PS.println(longName[i] + sep + this.getValueString(i));
        }
    }

    public JPanel getPanel() {
        JPanel globalBox = new JPanel();
        globalBox.setLayout(new GridLayout(name.length + 1, 2));
        globalBox.add(new JLabel("Quantity:", 4));
        globalBox.add(new JLabel("Value", 0));
        for (int i = 0; i < name.length; ++i) {
            globalBox.add(new JLabel(longName[i] + ":", 4));
            globalBox.add(new JLabel(this.getValueString(i), 0));
        }
        return globalBox;
    }
}

