/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.Edge;

import IslandNetworks.Edge.DistanceMetric;
import IslandNetworks.Edge.EdgeTypeSelection;
import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.IslandHamiltonian;
import IslandNetworks.IslandTransferMatrix;
import IslandNetworks.Vertex.IslandSite;
import IslandNetworks.Vertex.IslandSiteSet;
import TimUtilities.NumbersToString;
import TimUtilities.Permutation;
import TimUtilities.StatisticalQuantity;
import java.io.PrintStream;
import java.util.Random;

public class IslandEdgeSet {
    static final String IESVERSION = "IES080412";
    static final int STRUPDATE = 1000;
    public static double MAXSEPARATION = 8.8E22;
    static NumbersToString n2s = new NumbersToString(3);
    private int numberSites;
    private int numberEdges = -1;
    public EdgeMode edgeMode;
    private IslandEdge[][] edge;
    private int[] edgeWeightRankList;
    private double[] outEdgeStrength;
    private double[] inEdgeStrength;
    private int[] strengthInCount;
    private int[] strengthOutCount;
    public StatisticalQuantity[] edgeStats;
    public int maxEdgeWeightSource = -1;
    public int maxEdgeWeightTarget = -1;
    public DistanceMetric metric;
    public static int numberMetrics = 6;
    public double DijkstraMaxSep;
    public EdgeTypeSelection DisplayEdgeType;
    public double zeroColourFrac = 0.03;
    public double minColourFrac = 0.1;
    public double DisplayMaxEdgeScale = 1.0;
    public double displayMaximumEdgeWeight;
    public double displayMinimumEdgeWeight;
    public double displayZeroEdgeWeight;
    private double distanceDiameter = -1.0;
    private double separationDiameter = -1.0;

    public IslandEdgeSet(int ns, double edgeModeValue) {
        this.numberSites = ns;
        this.outEdgeStrength = new double[this.numberSites];
        this.inEdgeStrength = new double[this.numberSites];
        this.strengthInCount = new int[this.numberSites];
        this.strengthOutCount = new int[this.numberSites];
        this.edge = new IslandEdge[this.numberSites][this.numberSites];
        this.edgeMode = new EdgeMode(edgeModeValue);
        for (int i = 0; i < this.numberSites; ++i) {
            this.outEdgeStrength[i] = 0.0;
            this.inEdgeStrength[i] = 0.0;
            this.strengthInCount[i] = 1000;
            this.strengthOutCount[i] = 1000;
            for (int j = 0; j < this.numberSites; ++j) {
                this.edge[i][j] = new IslandEdge();
            }
        }
        this.metric = new DistanceMetric(0);
        this.DijkstraMaxSep = MAXSEPARATION;
        this.DisplayEdgeType = new EdgeTypeSelection();
    }

    public IslandEdgeSet(IslandEdgeSet es) {
        int i;
        this.numberSites = es.numberSites;
        this.outEdgeStrength = new double[this.numberSites];
        this.inEdgeStrength = new double[this.numberSites];
        this.strengthInCount = new int[this.numberSites];
        this.strengthOutCount = new int[this.numberSites];
        this.edge = new IslandEdge[this.numberSites][this.numberSites];
        this.edgeMode = new EdgeMode(es.edgeMode);
        for (i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                this.edge[i][j] = new IslandEdge(es.edge[i][j]);
            }
        }
        for (i = 0; i < this.numberSites; ++i) {
            this.calcInStrength(i);
            this.calcOutStrength(i);
        }
        this.DisplayEdgeType = new EdgeTypeSelection(es.DisplayEdgeType);
        this.edgeStats = new StatisticalQuantity[IslandEdge.numberVariables];
        for (int v = 0; v < IslandEdge.numberVariables; ++v) {
            this.edgeStats[v] = new StatisticalQuantity(es.edgeStats[v]);
        }
        this.maxEdgeWeightSource = es.maxEdgeWeightSource;
        this.maxEdgeWeightTarget = es.maxEdgeWeightTarget;
        this.metric = new DistanceMetric(es.metric);
        this.DijkstraMaxSep = es.DijkstraMaxSep;
        this.zeroColourFrac = es.zeroColourFrac;
        this.minColourFrac = es.minColourFrac;
        this.DisplayMaxEdgeScale = es.DisplayMaxEdgeScale;
        this.displayMaximumEdgeWeight = es.displayMaximumEdgeWeight;
        this.displayMinimumEdgeWeight = es.displayMinimumEdgeWeight;
        this.displayZeroEdgeWeight = es.displayZeroEdgeWeight;
    }

    public int getNumberSites() {
        return this.numberSites;
    }

    public int getIndex(int i, int j) {
        return i * this.numberSites + j;
    }

    public IslandEdge getEdge(int i, int j) {
        return this.edge[i][j];
    }

    public IslandEdge getEdge(int id) {
        return this.edge[id / this.numberSites][id % this.numberSites];
    }

    public int getSource(int id) {
        return id / this.numberSites;
    }

    public int getTarget(int id) {
        return id % this.numberSites;
    }

    public double getVariable(int id, int index) {
        return this.getEdge(id).getVariable(index);
    }

    public double getVariable(int i, int j, int index) {
        return this.edge[i][j].getVariable(index);
    }

    public double getVariable(int i, int j, String name) {
        return this.edge[i][j].getVariable(name);
    }

    public double getDisplayVariable(int id) {
        return this.getEdge(id).getVariable(this.DisplayEdgeType.getValueIndex());
    }

    public double getDisplayVariable(int s, int t) {
        return this.getEdge(s, t).getVariable(this.DisplayEdgeType.getValueIndex());
    }

    public double getEdgeDisplaySize(int id) {
        return this.getEdgeDisplaySize(this.getDisplayVariable(id) / this.displayMaximumEdgeWeight);
    }

    public double getEdgeDisplaySize(int s, int t) {
        return this.getEdgeDisplaySize(this.getDisplayVariable(s, t) / this.displayMaximumEdgeWeight);
    }

    private double getEdgeDisplaySize(double v) {
        if (v < this.minColourFrac) {
            v = v < this.zeroColourFrac ? 0.0 : this.zeroColourFrac;
        } else if (v > 1.0) {
            v = 1.0;
        }
        return v;
    }

    public double getAverage(int index) {
        return this.edgeStats[index].getAverage();
    }

    public double getMaximum(int index) {
        return this.edgeStats[index].maximum;
    }

    public double getDisplayMaximum() {
        return this.edgeStats[this.DisplayEdgeType.getValueIndex()].maximum;
    }

    public double getEdgeValue(int i, int j) {
        return this.edge[i][j].getValue();
    }

    public double getEdgeWeight(int i, int j) {
        return this.edge[i][j].getWeight();
    }

    public double getEdgeValueSquared(int i, int j) {
        double v = this.edge[i][j].getValue();
        return v * v;
    }

    public double getEdgeColour(int i, int j) {
        return this.edge[i][j].getColour();
    }

    public double getEdgeDistance(int i, int j) {
        return this.edge[i][j].getDistance();
    }

    public double getDistanceDiameter() {
        if (this.distanceDiameter < 0.0) {
            for (int i = 0; i < this.numberSites; ++i) {
                for (int j = 0; j < this.numberSites; ++j) {
                    if (!(this.distanceDiameter < this.edge[i][j].getDistance())) continue;
                    this.distanceDiameter = this.edge[i][j].getDistance();
                }
            }
        }
        return this.distanceDiameter;
    }

    public double getSeparationDiameter() {
        if (this.separationDiameter < 0.0) {
            for (int i = 0; i < this.numberSites; ++i) {
                for (int j = 0; j < this.numberSites; ++j) {
                    if (!(this.separationDiameter < this.edge[i][j].getSeparation())) continue;
                    this.separationDiameter = this.edge[i][j].getSeparation();
                }
            }
        }
        return this.separationDiameter;
    }

    public double getEdgePotential1(int i, int j) {
        return this.edge[i][j].getEdgePotential1();
    }

    public double getEdgePotentialSeparation1(int i, int j, IslandHamiltonian H) {
        return this.edge[i][j].getEdgePotentialSeparation1(H);
    }

    public double getEdgeSeparation(int i, int j) {
        return this.edge[i][j].getSeparation();
    }

    public double getGeneCorrelation(int i, int j) {
        return this.edge[i][j].getGeneCorrelation();
    }

    public int getInDegree(int i) {
        int d = 0;
        for (int j = 0; j < this.numberSites; ++j) {
            if (!(this.edge[j][i].getValue() > 0.0)) continue;
            ++d;
        }
        return d;
    }

    public int getOutDegree(int i) {
        int d = 0;
        for (int j = 0; j < this.numberSites; ++j) {
            if (!(this.edge[i][j].getValue() > 0.0)) continue;
            ++d;
        }
        return d;
    }

    public double getOutEdgeStrength(int i) {
        return this.outEdgeStrength[i];
    }

    public double getInEdgeStrength(int i) {
        return this.inEdgeStrength[i];
    }

    public double setEdgeValueBounded(int i, int j, double value) {
        double dv = value - this.edge[i][j].getValue();
        if (this.edgeMode.maxValueModeOn && value > this.edgeMode.maximumValue) {
            value = this.edgeMode.maximumValue;
            dv = value - this.edge[i][j].getValue();
        }
        if (this.edgeMode.outStrengthLimitOn && this.outEdgeStrength[i] + dv > this.edgeMode.maximumValue) {
            dv = this.edgeMode.maximumValue - this.outEdgeStrength[i];
            value = dv + this.edge[i][j].getValue();
        }
        if (value < 0.0) {
            value = 0.0;
            dv = value - this.edge[i][j].getValue();
        }
        this.edge[i][j].setValue(value);
        int n = j;
        this.strengthInCount[n] = this.strengthInCount[n] - 1;
        if (this.strengthInCount[n] < 0) {
            this.calcInStrength(j);
        } else {
            int n2 = j;
            this.inEdgeStrength[n2] = this.inEdgeStrength[n2] + dv;
        }
        int n3 = i;
        this.strengthOutCount[n3] = this.strengthOutCount[n3] - 1;
        if (this.strengthOutCount[n3] < 0) {
            this.calcOutStrength(i);
        } else {
            int n4 = i;
            this.outEdgeStrength[n4] = this.outEdgeStrength[n4] + dv;
        }
        return value;
    }

    public double setEdgeValueNoBounds(int i, int j, double value) {
        double dv = value - this.edge[i][j].getValue();
        this.edge[i][j].setValue(value);
        int n = j;
        this.strengthInCount[n] = this.strengthInCount[n] - 1;
        if (this.strengthInCount[n] < 0) {
            this.calcInStrength(j);
        } else {
            int n2 = j;
            this.inEdgeStrength[n2] = this.inEdgeStrength[n2] + dv;
        }
        int n3 = i;
        this.strengthOutCount[n3] = this.strengthOutCount[n3] - 1;
        if (this.strengthOutCount[n3] < 0) {
            this.calcOutStrength(i);
        } else {
            int n4 = i;
            this.outEdgeStrength[n4] = this.outEdgeStrength[n4] + dv;
        }
        return value;
    }

    public void setVariable(int s, int t, int index, double value) {
        this.edge[s][t].setVariable(index, value);
    }

    public void setVariable(int id, int index, double value) {
        this.edge[id / this.numberSites][id % this.numberSites].setVariable(index, value);
    }

    public double setEdgeValue(int i, int j, double value, double maxInStrength, double maxOutStrength) {
        double currentValue = this.edge[i][j].getValue();
        double dv = value - currentValue;
        if (this.outEdgeStrength[i] + dv > maxOutStrength) {
            return currentValue;
        }
        if (this.inEdgeStrength[j] + dv > maxInStrength) {
            return currentValue;
        }
        return this.setEdgeValueBounded(i, j, value);
    }

    public double setEdgeColour(int i, int j, double value) {
        this.edge[i][j].setColour(value);
        return value;
    }

    public double setEdgeDistance(int i, int j, double value) {
        this.edge[i][j].setDistance(value);
        return value;
    }

    public double setGeneCorrelation(int i, int j, double weighting) {
        this.edge[i][j].setGeneCorrelation(weighting);
        return weighting;
    }

    public void setGeneCorrelations(IslandSiteSet siteSet) {
        siteSet.setGeneLengths();
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                this.setGeneCorrelation(i, j, siteSet.getGeneCorrelation(i, j));
            }
        }
    }

    public double setEdgeSeparation(int i, int j, double value) {
        this.separationDiameter = -1.0;
        this.edge[i][j].setSeparation(value);
        return value;
    }

    public void setEdgeValues(double value) {
        this.setEdgeValuesZero();
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                if (i == j || !(this.getEdgeDistance(i, j) > -9.18273645E8)) continue;
                this.setEdgeValueBounded(i, j, value);
            }
        }
    }

    public void setEdgeValuesZero() {
        for (int i = 0; i < this.numberSites; ++i) {
            this.outEdgeStrength[i] = 0.0;
            this.inEdgeStrength[i] = 0.0;
            this.strengthInCount[i] = 1000;
            this.strengthOutCount[i] = 1000;
            for (int j = 0; j < this.numberSites; ++j) {
                this.edge[i][j].setValue(0.0);
            }
        }
    }

    public void setRandomEdgeValues(Random rnd) {
        if (this.edgeMode.binary) {
            this.setRandomBinaryEdgeValues(rnd);
            return;
        }
        this.setEdgeValuesZero();
        int i = -1;
        int j = -1;
        Permutation sourcePerm = new Permutation(this.numberSites);
        for (int ip = 0; ip < this.numberSites; ++ip) {
            double x = this.edgeMode.maximumValue;
            i = sourcePerm.next();
            Permutation targetPerm = new Permutation(this.numberSites);
            for (int jp = 0; jp < this.numberSites; ++jp) {
                j = targetPerm.next();
                if (i != j && this.getEdgeDistance(i, j) > -9.18273645E8) {
                    this.setEdgeValueBounded(i, j, x * rnd.nextDouble());
                }
                if (!this.edgeMode.outStrengthLimitOn) continue;
                x = this.edgeMode.maximumValue - this.outEdgeStrength[i];
            }
        }
    }

    private void setRandomBinaryEdgeValues(Random rnd) {
        this.setEdgeValuesZero();
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                if (i == j || !(this.getEdgeDistance(i, j) > -9.18273645E8)) continue;
                this.setEdgeValueBounded(i, j, rnd.nextBoolean() ? 1.0 : 0.0);
            }
        }
    }

    private double calcInStrength(int n) {
        this.strengthInCount[n] = 1000;
        double v = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            v += this.getEdgeValue(i, n);
        }
        return v;
    }

    private double calcOutStrength(int n) {
        this.strengthOutCount[n] = 1000;
        double v = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            v += this.getEdgeValue(n, i);
        }
        this.outEdgeStrength[n] = v;
        return v;
    }

    public double getInStrengthSquared(int n) {
        double v = 0.0;
        double ev = -1.0;
        for (int i = 0; i < this.numberSites; ++i) {
            ev = this.getEdgeValue(i, n);
            v += ev * ev;
        }
        return v;
    }

    public double getOutStrengthSquared(int n) {
        double v = 0.0;
        double ev = -1.0;
        for (int i = 0; i < this.numberSites; ++i) {
            ev = this.getEdgeValue(n, i);
            v += ev * ev;
        }
        return v;
    }

    public void setEdgePotential1(IslandHamiltonian H) {
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                this.edge[i][j].setEdgePotential1(H);
            }
        }
    }

    public void setUpEdgeDisplayValues(IslandSiteSet siteSet) {
        int v = this.DisplayEdgeType.getValueIndex();
        this.calcStats(siteSet, v);
        double amew = -1.0;
        amew = this.DisplayMaxEdgeScale > 0.0 ? this.DisplayMaxEdgeScale : this.edgeStats[v].maximum;
        this.displayZeroEdgeWeight = amew * this.zeroColourFrac;
        this.displayMinimumEdgeWeight = amew * this.minColourFrac;
        this.displayMaximumEdgeWeight = amew;
    }

    public void setUpEdgeDisplayValues(IslandSiteSet siteSet, double numberColours) {
        this.setUpEdgeDisplayValues(siteSet);
        int v = this.DisplayEdgeType.getValueIndex();
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                this.setEdgeColour(i, j, numberColours * this.getVariable(i, j, v) / this.displayMaximumEdgeWeight);
                if (this.getEdgeColour(i, j) > numberColours) {
                    this.setEdgeColour(i, j, numberColours);
                }
                if (!(this.getEdgeColour(i, j) < numberColours * this.minColourFrac)) continue;
                if (this.getEdgeColour(i, j) < numberColours * this.zeroColourFrac) {
                    this.setEdgeColour(i, j, 0.0);
                    continue;
                }
                this.setEdgeColour(i, j, numberColours * this.zeroColourFrac);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDijkstra(IslandSite[] siteArray, double shortDistanceScale) {
        double superMaxSep = MAXSEPARATION * 1.0001;
        this.DijkstraMaxSep = 0.0;
        for (int v = 0; v < this.numberSites; ++v) {
            int mdv = v;
            double minseparation = MAXSEPARATION;
            boolean[] notVisited = new boolean[this.numberSites];
            for (int i = 0; i < this.numberSites; ++i) {
                this.setEdgeSeparation(v, i, MAXSEPARATION);
                notVisited[i] = true;
            }
            this.setEdgeSeparation(v, v, 0.0);
            for (int n = 0; n < this.numberSites; ++n) {
                int j;
                minseparation = MAXSEPARATION;
                for (j = 0; j < this.numberSites; ++j) {
                    if (!notVisited[j] || !(this.getEdgeSeparation(v, j) < minseparation)) continue;
                    minseparation = this.getEdgeSeparation(v, j);
                    mdv = j;
                }
                if (minseparation == MAXSEPARATION) break;
                notVisited[mdv] = false;
                for (j = 0; j < this.numberSites; ++j) {
                    if (!notVisited[j]) continue;
                    double eee = this.getEdgeValue(mdv, j);
                    double newsep = superMaxSep;
                    switch (this.metric.getNumber()) {
                        case 5: {
                            double d = this.getEdgeDistance(mdv, j);
                            if (d <= shortDistanceScale) {
                                newsep = minseparation + this.getEdgeDistance(mdv, j);
                                break;
                            }
                            newsep = minseparation + d / this.getEdgePotential1(mdv, j);
                            break;
                        }
                        case 4: {
                            newsep = minseparation + 1.0 / (siteArray[mdv].getWeight() * eee);
                            break;
                        }
                        case 3: {
                            double d = this.getEdgeDistance(mdv, j);
                            if (d <= shortDistanceScale) {
                                newsep = minseparation + d / siteArray[mdv].getWeight();
                                break;
                            }
                            newsep = minseparation + d / (this.getEdgePotential1(mdv, j) * (siteArray[mdv].getWeight() * eee));
                            break;
                        }
                        case 2: {
                            newsep = minseparation + 1.0 / eee;
                            break;
                        }
                        case 1: {
                            double d = this.getEdgeDistance(mdv, j);
                            if (d <= shortDistanceScale) {
                                newsep = minseparation + d;
                                break;
                            }
                            newsep = minseparation + d / (this.getEdgePotential1(mdv, j) * eee);
                            break;
                        }
                        default: {
                            newsep = minseparation + this.getEdgeDistance(mdv, j);
                        }
                    }
                    if (!(this.getEdgeSeparation(v, j) > newsep)) continue;
                    this.setEdgeSeparation(v, j, newsep);
                    continue;
                }
            }
            if (!(this.DijkstraMaxSep < minseparation)) continue;
            this.DijkstraMaxSep = minseparation;
        }
    }

    public int getEdgeGivenValueRank(int rank) {
        if (this.numberEdges < 0) {
            this.calcEdgeValueOrder();
        }
        return this.edgeWeightRankList[rank];
    }

    public void setEdgeWeights(IslandSiteSet siteSet) {
        for (int i = 0; i < this.numberSites; ++i) {
            double vw = siteSet.getWeight(i);
            for (int j = 0; j < this.numberSites; ++j) {
                this.edge[i][j].setWeight(this.getEdgeValue(i, j) * vw);
            }
        }
    }

    public void calcStats(IslandSiteSet siteSet) {
        this.edgeStats = new StatisticalQuantity[IslandEdge.numberVariables];
        for (int v = 0; v < IslandEdge.numberVariables; ++v) {
            this.calcStats(siteSet, v);
        }
    }

    public void calcStats(IslandSiteSet siteSet, int v) {
        if (v == IslandEdge.weightINDEX) {
            this.setEdgeWeights(siteSet);
        }
        this.calcStats(v);
    }

    public void calcStats(int v) {
        if (this.edgeStats == null) {
            this.edgeStats = new StatisticalQuantity[IslandEdge.numberVariables];
        }
        if (!this.isSet(1, v)) {
            return;
        }
        this.edgeStats[v] = new StatisticalQuantity(1.23E34, -1.0);
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                double eV = this.getVariable(i, j, v);
                if (v == IslandEdge.weightINDEX && eV > this.edgeStats[v].maximum) {
                    this.maxEdgeWeightSource = i;
                    this.maxEdgeWeightTarget = j;
                }
                this.edgeStats[v].add(eV);
            }
        }
    }

    public boolean isSet(int id, int i) {
        return this.getEdge(id).isSet(i);
    }

    public void setInfluenceWeight(IslandSiteSet ss, IslandTransferMatrix tm) {
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                this.edge[i][j].setInfluenceWeight(tm.getInfluence(j, i) * ss.getWeight(i));
            }
        }
        this.calcStats(IslandEdge.influenceWeightINDEX);
    }

    public String displaySizeString(String sep1, String sep2) {
        return "ew zero" + sep1 + this.displayZeroEdgeWeight + sep2 + "ew min" + sep1 + this.displayMinimumEdgeWeight + sep2 + "ew max" + sep1 + this.displayMaximumEdgeWeight;
    }

    public String toGraphToolTipString(int id, String sep1, String sep2, int dec) {
        String s = "Source" + sep1 + this.getSource(id) + sep2 + "Target" + sep1 + this.getTarget(id);
        int i = this.DisplayEdgeType.getValueIndex();
        if (this.getEdge(id).isSet(i)) {
            s = s + sep2 + IslandEdge.name[i] + sep1 + n2s.TruncDecimal(this.getVariable(id, i), dec);
        }
        return s;
    }

    public String toString(int id, String sep1, String sep2, int dec) {
        String s = "Source/Target" + sep1 + this.getSource(id) + " " + this.getTarget(id) + sep2;
        for (int i = 0; i < IslandEdge.numberVariables; ++i) {
            if (!this.getEdge(id).isSet(i)) continue;
            s = s + IslandEdge.name[i] + sep1 + this.getVariable(id, i) + sep2;
        }
        return s;
    }

    public String getEdgeString(int source, int target, String sep, int dec) {
        return this.edge[source][target].toString(sep, dec);
    }

    public void printList(PrintStream PS, String cc, String sep, int dec, boolean headerOn) {
        if (headerOn) {
            PS.println(cc + "source" + sep + "Target" + sep + IslandEdge.toStringLabel(sep));
        }
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                PS.println(i + sep + j + sep + this.edge[i][j].toString(sep, dec));
            }
        }
    }

    public void printParameterList(PrintStream PS, String cc, String sep, int dec, boolean headerOn) {
        if (headerOn) {
            PS.println(cc + IslandEdge.parameterNames(sep));
        }
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                PS.println(this.edge[i][j].parameterString(sep, dec));
            }
        }
    }

    public void printParameterNames(PrintStream PS, String sep) {
        PS.println(IslandEdge.parameterNames(sep));
    }

    public void printValueBareTable(PrintStream PS, String sep, int dec) {
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                PS.print(this.edge[i][j].getValue() + sep);
            }
            PS.println();
        }
    }

    public void printDistanceBareTable(PrintStream PS, String sep, int dec) {
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                PS.print(this.edge[i][j].getDistance() + sep);
            }
            PS.println();
        }
    }

    public void printEdgeFullTable(String cc, PrintStream PS, String sep, int dec, String type, IslandSiteSet siteSet) {
        int i;
        int i2;
        double[] toedgecount = new double[this.numberSites];
        String s = "";
        double[] inTotal = new double[this.numberSites];
        double[] inTotal2 = new double[this.numberSites];
        for (i2 = 0; i2 < this.numberSites; ++i2) {
            s = s + "---" + sep;
        }
        PS.println(cc + "EDGE " + type + s);
        PS.print("From/to");
        for (i2 = 0; i2 < this.numberSites; ++i2) {
            toedgecount[i2] = 0.0;
        }
        for (i2 = 0; i2 < this.numberSites; ++i2) {
            PS.print(sep + siteSet.getName(i2));
        }
        PS.println(sep + "Total Out" + sep + "Total^2 Out");
        for (i2 = 0; i2 < this.numberSites; ++i2) {
            double outTotal = 0.0;
            double outTotal2 = 0.0;
            PS.print(siteSet.getName(i2));
            int j = 0;
            while (j < this.numberSites) {
                if (i2 == 0) {
                    inTotal[j] = 0.0;
                    inTotal2[j] = 0.0;
                }
                double v = this.getVariable(i2, j, type);
                outTotal += v;
                outTotal2 += v * v;
                int n = j;
                inTotal[n] = inTotal[n] + v;
                int n2 = j++;
                inTotal2[n2] = inTotal2[n2] + v * v;
                PS.print(sep + n2s.TruncDecimal(v, dec));
            }
            PS.println(sep + n2s.TruncDecimal(outTotal, dec) + sep + n2s.TruncDecimal(outTotal2, dec));
        }
        PS.print("Total In");
        double total = 0.0;
        for (i = 0; i < this.numberSites; ++i) {
            total += inTotal[i];
            PS.print(sep + n2s.TruncDecimal(inTotal[i], dec));
        }
        PS.println(sep + n2s.TruncDecimal(total, dec));
        PS.print("Total^2 In");
        total = 0.0;
        for (i = 0; i < this.numberSites; ++i) {
            total += inTotal2[i];
            PS.print(sep + n2s.TruncDecimal(inTotal2[i], dec));
        }
        PS.println(sep + n2s.TruncDecimal(total, dec));
    }

    public void printGeneCorrelationFullTable(String cc, PrintStream PS, String sep, int dec, IslandSiteSet siteSet) {
        int i;
        double[] toedgecount = new double[this.numberSites];
        String s = "";
        for (i = 0; i < this.numberSites; ++i) {
            s = s + "---" + sep;
        }
        PS.println(cc + "EDGE GENE CORRELATIONS" + s);
        PS.print("From/to");
        for (i = 0; i < this.numberSites; ++i) {
            toedgecount[i] = 0.0;
        }
        for (i = 0; i < this.numberSites; ++i) {
            PS.print(sep + siteSet.getName(i));
        }
        PS.println();
        for (i = 0; i < this.numberSites; ++i) {
            PS.print(siteSet.getName(i));
            for (int j = 0; j < this.numberSites; ++j) {
                PS.print(sep + n2s.TruncDecimal(this.getGeneCorrelation(i, j), dec));
            }
            PS.println();
        }
    }

    public void calcEdgeValueOrder() {
        Random Rnd = new Random();
        this.numberEdges = this.numberSites * this.numberSites;
        this.edgeWeightRankList = new int[this.numberEdges];
        for (int e = 0; e < this.numberEdges; ++e) {
            this.edgeWeightRankList[e] = e;
        }
        for (int e = 0; e < this.numberEdges; ++e) {
            int e2 = Rnd.nextInt(this.numberEdges);
            if (e2 == e) continue;
            int eb = this.edgeWeightRankList[e2];
            this.edgeWeightRankList[e2] = this.edgeWeightRankList[e];
            this.edgeWeightRankList[e] = eb;
        }
        this.QuickSort(this.edgeWeightRankList, 0, this.numberEdges - 1);
    }

    private void QuickSort(int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int midindex = (lo0 + hi0) / 2;
            double mid = this.edge[midindex / this.numberSites][midindex % this.numberSites].getValue();
            while (lo <= hi) {
                while (lo < hi0 && this.edge[a[lo] / this.numberSites][a[lo] % this.numberSites].getValue() < mid) {
                    ++lo;
                }
                while (hi > lo0 && this.edge[a[hi] / this.numberSites][a[hi] % this.numberSites].getValue() > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                int T = a[lo];
                a[lo] = a[hi];
                a[hi] = T;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.QuickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.QuickSort(a, lo, hi0);
            }
        }
    }

    public class EdgeMode {
        public boolean binary;
        public boolean maxValueModeOn;
        public boolean outStrengthLimitOn;
        public double maximumValue;

        public EdgeMode(double edgeMode) {
            this.setEdgeMode(edgeMode);
        }

        public EdgeMode(EdgeMode em) {
            this.binary = em.binary;
            this.maxValueModeOn = em.maxValueModeOn;
            this.outStrengthLimitOn = em.outStrengthLimitOn;
            this.maximumValue = em.maximumValue;
        }

        public void setEdgeMode(double edgeMode) {
            if (edgeMode == 0.0) {
                this.setBinaryModeOn();
            } else if (edgeMode > 0.0) {
                this.setMaxValueModeOn(edgeMode);
            } else {
                this.setMaxOutStrengthModeOn(edgeMode);
            }
        }

        public void setBinaryModeOn() {
            this.binary = true;
            this.maxValueModeOn = false;
            this.outStrengthLimitOn = false;
            this.maximumValue = 1.0;
        }

        public void setMaxValueModeOn(double value) {
            this.binary = false;
            this.maxValueModeOn = true;
            this.outStrengthLimitOn = false;
            this.maximumValue = Math.abs(value);
        }

        public void setMaxOutStrengthModeOn(double value) {
            this.binary = false;
            this.maxValueModeOn = false;
            this.outStrengthLimitOn = true;
            this.maximumValue = Math.abs(value);
        }

        public String description() {
            String s = "";
            if (this.binary) {
                s = s + "Binary Edge Values";
            }
            if (this.maxValueModeOn) {
                s = s + "Maximum Edge Value " + this.maximumValue;
            }
            if (this.outStrengthLimitOn) {
                s = s + "Limits on Out Strength " + this.maximumValue;
            }
            return s;
        }

        public double edgeModeValue() {
            double edgeModeValue = -9.87654321E8;
            if (this.binary) {
                edgeModeValue = 0.0;
            }
            if (this.maxValueModeOn) {
                edgeModeValue = this.maximumValue;
            }
            if (this.outStrengthLimitOn) {
                edgeModeValue = -this.maximumValue;
            }
            return edgeModeValue;
        }
    }
}

