/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.Edge;

import IslandNetworks.IslandHamiltonian;
import TimUtilities.NumbersToString;

public class IslandEdge {
    static final String IEVERSION = "IE060728";
    static final double DUNSET = -9.7531E92;
    static final int IUNSET = -97531;
    static final double MAXDISTANCE = 99999.0;
    static final int UNIQUENAME = 3;
    static final String[] name = new String[]{"value", "weight", "distance", "potential1", "geneCorrelation", "separation", "influenceWeight"};
    static final int numberVariables = name.length;
    public double[] valueArray = new double[name.length];
    public static final int valueINDEX = IslandEdge.getIndex("value");
    public static final int weightINDEX = IslandEdge.getIndex("weight");
    public static final int distanceINDEX = IslandEdge.getIndex("distance");
    public static final int potential1INDEX = IslandEdge.getIndex("potential1");
    public static final int geneCorrelationINDEX = IslandEdge.getIndex("geneCorrelation");
    public static final int influenceWeightINDEX = IslandEdge.getIndex("influenceWeight");
    public static final int separationINDEX = IslandEdge.getIndex("separation");
    static final String[] parameterName = new String[]{"value", "distance", "geneCorrelation"};

    public IslandEdge() {
        for (int v = 0; v < numberVariables; ++v) {
            this.valueArray[v] = -9.7531E92;
        }
    }

    public IslandEdge(IslandEdge e) {
        for (int v = 0; v < numberVariables; ++v) {
            this.valueArray[v] = e.valueArray[v];
        }
    }

    public boolean isGeneCorrelationSet() {
        return this.valueArray[geneCorrelationINDEX] != -9.7531E92;
    }

    public boolean isSet(int i) {
        return this.valueArray[i] != -9.7531E92;
    }

    public double getVariable(String type) {
        return this.getVariable(IslandEdge.getIndex(type));
    }

    public double getVariable(int index) {
        return this.valueArray[index];
    }

    public static int getIndex(String input) {
        String s = input.substring(0, 3);
        for (int v = 0; v < numberVariables; ++v) {
            if (!name[v].startsWith(s)) continue;
            return v;
        }
        return -1;
    }

    public double getValue() {
        return this.valueArray[valueINDEX];
    }

    public double getWeight() {
        return this.valueArray[weightINDEX];
    }

    public double getColour() {
        return -9.7531E92;
    }

    public double getDistance() {
        return this.valueArray[distanceINDEX];
    }

    public double getGeneCorrelation() {
        return this.isGeneCorrelationSet() ? this.valueArray[geneCorrelationINDEX] : 1.0;
    }

    public double getSeparation() {
        return this.valueArray[separationINDEX];
    }

    public void setValue(double d) {
        this.valueArray[IslandEdge.valueINDEX] = d;
    }

    public void setWeight(double d) {
        this.valueArray[IslandEdge.weightINDEX] = d;
    }

    public void setColour(double d) {
    }

    public void setDistance(double d) {
        this.valueArray[IslandEdge.distanceINDEX] = d;
    }

    public void setGeneCorrelation(double d) {
        this.valueArray[IslandEdge.geneCorrelationINDEX] = d;
    }

    public void setSeparation(double d) {
        this.valueArray[IslandEdge.separationINDEX] = d;
    }

    public void setInfluenceWeight(double d) {
        this.valueArray[IslandEdge.influenceWeightINDEX] = d;
    }

    public void setVariable(int index, double value) {
        this.valueArray[index] = value;
    }

    public static boolean checkIndex(int index) {
        return index >= 0 && index < name.length;
    }

    public double getEdgePotentialSeparation1(IslandHamiltonian H) {
        return H.edgePotential1(this.valueArray[separationINDEX], this.valueArray[geneCorrelationINDEX]);
    }

    public double getEdgePotential1() {
        return this.valueArray[potential1INDEX];
    }

    public double setEdgePotential1(IslandHamiltonian H) {
        this.valueArray[IslandEdge.potential1INDEX] = this.isGeneCorrelationSet() ? H.edgePotential1(this.valueArray[distanceINDEX], this.valueArray[geneCorrelationINDEX]) : H.edgePotential1(this.valueArray[distanceINDEX], 1.0);
        return this.valueArray[potential1INDEX];
    }

    public static String dataName(int index) {
        if (index < 0 || index >= name.length) {
            return "value unknown";
        }
        return name[index];
    }

    public static String parameterName(int index) {
        if (index < 0 || index >= parameterName.length) {
            return "value unknown";
        }
        return parameterName[index];
    }

    public static String dataNameInformation(int index) {
        if (index < 0 || index >= name.length) {
            return "value unknown";
        }
        String s = name[index] + ": ";
        if (index == valueINDEX) {
            return s + "edge value derived from modelling";
        }
        if (index == weightINDEX) {
            return s + "edge weight (edge * source site) derived from modelling";
        }
        if (index == distanceINDEX) {
            return s + "geographical distance, may be in units of time";
        }
        if (index == potential1INDEX) {
            return s + "geographical distance potential term used in model one, includes lambda etc.";
        }
        if (index == geneCorrelationINDEX) {
            return s + "correlation between genes of source/target sites";
        }
        if (index == separationINDEX) {
            return s + "effective distance set for instance by Dijstra routines";
        }
        if (index == influenceWeightINDEX) {
            return s + "influence weight I_{ij}S_jv_j";
        }
        return s + " valid but no information given";
    }

    public String toString(String sep, int dec) {
        NumbersToString ns = new NumbersToString(dec);
        String s = "";
        for (int i = 0; i < name.length; ++i) {
            s = s + ns.toString(this.getVariable(name[i])) + sep;
        }
        return s;
    }

    public static String toStringLabel(String sep) {
        String s = "";
        for (int i = 0; i < name.length; ++i) {
            s = s + name[i] + sep;
        }
        return s;
    }

    public String parameterString(String sep, int dec) {
        NumbersToString ns = new NumbersToString(dec);
        String s = "";
        for (int i = 0; i < parameterName.length; ++i) {
            s = s + ns.toString(this.getVariable(parameterName[i])) + sep;
        }
        return s;
    }

    public static String parameterNames(String sep) {
        String s = "";
        for (int i = 0; i < parameterName.length; ++i) {
            s = s + parameterName[i] + sep;
        }
        return s;
    }
}

