/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.Edge;

import java.io.PrintStream;

public class DistanceMetric {
    static final int UNIQUENAME = 3;
    private int number;
    public static final String[] name = new String[]{"plain", "d/(e*V)", "1/e", "d/(Sve*V)", "1/(Sve)", "d/V"};
    public static final String[] longName = new String[]{"plain physical distance", "sum of individual physical distance/potential using edge values", "inverse edge value", "sum of individual physical distance/potential using edge weights", "inverse edge weight", "sum of physical distance/potential (but no edge values)"};

    public DistanceMetric() {
        this.set(0);
    }

    public DistanceMetric(int m) {
        this.set(0);
        this.set(m);
    }

    public DistanceMetric(DistanceMetric m) {
        this.set(0);
        this.set(m.getNumber());
    }

    public int getNumber() {
        return this.number;
    }

    public static int getIndex(String input) {
        String s = input.substring(0, 3);
        for (int v = 0; v < name.length; ++v) {
            if (!name[v].startsWith(s)) continue;
            return v;
        }
        return -1;
    }

    public void set(double newNumber) {
        this.set(Math.round(newNumber));
    }

    public int set(int newNumber) {
        if (this.number < 0 || this.number >= name.length) {
            return -1;
        }
        this.number = newNumber;
        return this.number;
    }

    public void set(String newNumber) {
        this.set(Double.parseDouble(newNumber));
    }

    public void print(PrintStream PS, String cc) {
        PS.println(cc + " Output mode is " + this.getNumber());
    }

    public static void listAll(PrintStream PS, String cc, String sep) {
        for (int m = 0; m < name.length; ++m) {
            PS.println(cc + m + sep + longName[m] + " (" + name[m] + ")");
        }
    }
}

