/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import java.io.PrintStream;

public class Correlation {
    int dimInd = -1;
    int dimArt = -1;
    final int dimType = 2;
    double[][] valueVector;
    double[][] valueNorm;
    boolean correlationCalculated = false;
    double[][][] correlationVector;

    public Correlation(int dimIndividual, int dimArtifact, double[][] valueVector) {
        this.dimInd = dimIndividual;
        this.dimArt = dimArtifact;
        this.valueVector = new double[this.dimInd][this.dimArt];
        this.correlationVector = new double[this.dimInd][this.dimInd][2];
        this.valueNorm = new double[this.dimInd][2];
        double v = -1.0;
        for (int i = 0; i < this.dimInd; ++i) {
            for (int n = 0; n < this.dimInd; ++n) {
                this.valueNorm[i][n] = 0.0;
            }
            for (int a = 0; a < this.dimArt; ++a) {
                this.valueVector[i][a] = v = valueVector[i][a];
                double[] dArray = this.valueNorm[i];
                dArray[0] = dArray[0] + v;
                double[] dArray2 = this.valueNorm[i];
                dArray2[1] = dArray2[1] + v * v;
            }
            this.valueNorm[i][1] = Math.sqrt(this.valueNorm[i][1]);
            for (int j = 0; j < this.dimInd; ++j) {
                for (int n = 0; n < this.dimInd; ++n) {
                    this.correlationVector[i][j][n] = i == j ? 1.0 : 0.0;
                }
            }
        }
        this.correlationCalculated = false;
    }

    public double getCorrelation(int i, int j, int n) {
        if (!this.correlationCalculated) {
            this.calcCorrelations();
        }
        return this.correlationVector[i][j][n];
    }

    public void calcCorrelations() {
        double c = -99.0;
        for (int i = 0; i < this.dimInd; ++i) {
            for (int j = 0; j < this.dimInd; ++j) {
                c = this.calcCorrelation(i, j);
                block6: for (int n = 0; n < this.dimInd; ++n) {
                    switch (n) {
                        case 0: {
                            this.correlationVector[i][j][0] = c / (this.valueNorm[i][0] * this.valueNorm[j][0]);
                            continue block6;
                        }
                        case 1: {
                            this.correlationVector[i][j][1] = Math.acos(c / (this.valueNorm[i][1] * this.valueNorm[j][1]));
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    public String correlationTypeString(PrintStream PS) {
        String s = "Unknown type";
        block4: for (int n = 0; n < this.dimInd; ++n) {
            switch (n) {
                case 0: {
                    s = "Probability style";
                    continue block4;
                }
                case 1: {
                    s = "Angle in artifact space";
                    continue block4;
                }
            }
        }
        return s;
    }

    private double calcCorrelation(int i, int j) {
        double c = 0.0;
        for (int a = 0; a < this.dimArt; ++a) {
            c += this.valueVector[i][a] * this.valueVector[j][a];
        }
        return c;
    }
}

