/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.Edge.EdgeTypeSelection;
import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.InputParameterFrame;
import IslandNetworks.ProbabilityDistance;
import IslandNetworks.Vertex.VertexTypeSelection;
import IslandNetworks.islandNetwork;
import IslandNetworks.jungInterfaces.AriadneEdgePaintFunction;
import IslandNetworks.jungInterfaces.AriadneEdgeStrokeFunction;
import IslandNetworks.jungInterfaces.AriadneVertexPaintFunction;
import IslandNetworks.jungInterfaces.AriadneVertexShapeSizeAspect;
import IslandNetworks.jungInterfaces.ClickableVertexListener;
import IslandNetworks.jungInterfaces.EPSNetwork;
import IslandNetworks.jungInterfaces.EdgePercolationClusterer;
import IslandNetworks.jungInterfaces.GeographicalLayout;
import IslandNetworks.jungInterfaces.GraphML;
import IslandNetworks.jungInterfaces.GraphToolTip;
import IslandNetworks.jungInterfaces.JpegNetwork;
import IslandNetworks.jungInterfaces.JungConverter;
import IslandNetworks.jungInterfaces.KKWeightedLayout;
import IslandNetworks.jungInterfaces.PrintableNetwork;
import TimUtilities.JavaColours;
import TimUtilities.NumbersToString;
import edu.uci.ics.jung.algorithms.cluster.EdgeBetweennessClusterer;
import edu.uci.ics.jung.algorithms.cluster.VertexClusterSet;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.ToolTipFunction;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberVertexValue;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.GraphMouseListener;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.MultiPickedState;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.contrib.CircleLayout;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.subLayout.CircularSubLayout;
import edu.uci.ics.jung.visualization.subLayout.SubLayout;
import edu.uci.ics.jung.visualization.subLayout.SubLayoutDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ClusteringWindow
extends JPanel {
    private static final Object ISLANDCLUSTERKEY = "ISLANDCLUSTERKEY";
    private static final int MAXSLIDERVALUE = 100;
    private static final double DMAXSLIDERVALUE = 100.0;
    static final NumbersToString n2s = new NumbersToString(3);
    private double defaultEdgeFraction = 0.5;
    private String edgeFractionSliderString = "NONE";
    private int sliderValue = 50;
    private int isliderValue = 50;
    private Float minEdgeDisplaySize = Float.valueOf(0.0f);
    private Float maxEdgeDisplaySize = Float.valueOf(10.0f);
    private static final float MAXEDGESTROKESIZE = 20.0f;
    private Integer maxVertexDisplaySize = 3;
    private static final int MAXVERTEXDISPLAYSIZE = 40;
    private ClusterType clusterType;
    private LayoutType layoutType;
    AriadneVertexShapeSizeAspect vShapeSizeAspect;
    AriadneVertexPaintFunction vertexPaintFunction;
    AriadneEdgePaintFunction edgePaintFunction;
    AriadneEdgeStrokeFunction edgeStrokeFunction;
    public static final Color BACKGROUNDCOLOUR = Color.WHITE;
    public static final Color PERCREMOVEDCOLOUR = Color.LIGHT_GRAY;
    public static final Color REMOVEDCOLOUR = new Color(255, 255, 255, 0);
    private VisualizationViewer vv;
    private JungConverter jc;
    private int jpegCount = 0;
    private int gmlCount = 0;
    private islandNetwork inet;
    JavaColours javaColours = new JavaColours();
    public static final Color[] similarColors = new Color[]{new Color(216, 134, 134), new Color(135, 137, 211), new Color(134, 206, 189), new Color(206, 176, 134), new Color(194, 204, 134), new Color(145, 214, 134), new Color(133, 178, 209), new Color(103, 148, 255), new Color(60, 220, 220), new Color(30, 250, 100), new Color(30, 100, 250), new Color(220, 220, 60), new Color(250, 100, 30), new Color(100, 250, 30), new Color(220, 60, 220), new Color(100, 30, 250), new Color(250, 30, 100)};

    public ClusteringWindow(islandNetwork inNetwork, Dimension size) {
        int squareSize = this.networkVisualisationSize(size.width, size.height);
        this.initialiseClusteringWindow(inNetwork, squareSize);
        this.setUpView(squareSize);
    }

    public ClusteringWindow() {
    }

    public void initialiseClusteringWindow(islandNetwork inetinput, int squareSize) {
        this.inet = inetinput;
        this.inet.calcNetworkStats();
        this.jc = new JungConverter(this.inet);
        this.vertexPaintFunction = new AriadneVertexPaintFunction((PickedState)new MultiPickedState(), ISLANDCLUSTERKEY);
        this.vShapeSizeAspect = new AriadneVertexShapeSizeAspect(this.inet, 1);
        this.edgePaintFunction = new AriadneEdgePaintFunction(this.inet, ISLANDCLUSTERKEY, PERCREMOVEDCOLOUR);
        this.edgeStrokeFunction = new AriadneEdgeStrokeFunction(this.inet, ISLANDCLUSTERKEY, PERCREMOVEDCOLOUR, this.minEdgeDisplaySize, this.maxEdgeDisplaySize);
        this.clusterType = new ClusterType();
        this.layoutType = new LayoutType(squareSize);
    }

    private Dimension networkVisualisationDimension() {
        int l = this.networkVisualisationSize(this.getWidth(), this.getHeight());
        return new Dimension(l, l);
    }

    private Dimension networkVisualisationDimension(Dimension d) {
        int l = this.networkVisualisationSize(d.width, d.height);
        return new Dimension(l, l);
    }

    private int networkVisualisationSize() {
        return this.networkVisualisationSize(this.getWidth(), this.getHeight());
    }

    private int networkVisualisationSize(int frameWidth, int frameHeight) {
        return Math.max(Math.min(frameWidth, frameHeight) - 100, 200);
    }

    public void start() {
        try {
            this.setUpView(this.networkVisualisationSize());
        }
        catch (Exception e) {
            System.out.println("Error " + e);
            e.printStackTrace();
        }
    }

    public void setUpPrintableView(int width, int height) {
        this.layoutType.setlayoutType("Geo");
        this.clusterType.setclusterType("Perc");
        this.defaultEdgeFraction = 3.0 / (double)this.inet.edgeSet.getNumberSites();
        this.setUpJungViewer(this.jc.getGraph(), new Dimension(width, height));
        this.vv.setSize(width, height);
    }

    public void setUpJungViewer(Graph graph, Dimension preferredDimension) {
        MultiPickedState ps = new MultiPickedState();
        PluggableRenderer pr = new PluggableRenderer();
        this.vertexPaintFunction.setPickedState((PickedState)ps);
        pr.setVertexPaintFunction((VertexPaintFunction)this.vertexPaintFunction);
        pr.setVertexShapeFunction((VertexShapeFunction)this.vShapeSizeAspect);
        pr.setEdgePaintFunction((EdgePaintFunction)this.edgePaintFunction);
        pr.setEdgeStrokeFunction((EdgeStrokeFunction)this.edgeStrokeFunction);
        this.vv = new VisualizationViewer((Layout)this.layoutType.getLayoutType(graph), (Renderer)pr, preferredDimension);
        this.vv.setBackground(BACKGROUNDCOLOUR);
        this.vv.setPickedState((PickedState)ps);
        this.vv.setSize(preferredDimension);
    }

    private void setUpView(int jungSize) {
        Dimension panelSizeDim = this.getSize();
        Dimension screenSizeDim = Toolkit.getDefaultToolkit().getScreenSize();
        System.out.println("--- jung VisualisationViewer size " + jungSize);
        Dimension jungDimension = new Dimension(jungSize, jungSize);
        this.setUpJungViewer(this.jc.getGraph(), jungDimension);
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        this.vv.setPickSupport((PickSupport)new ShapePickSupport());
        this.vv.addGraphMouseListener((GraphMouseListener)new ClickableVertexListener(new UserDatumNumberVertexValue((Object)"IN_VIDKey"), this.inet.siteSet));
        GraphToolTip gTTF = new GraphToolTip(new UserDatumNumberVertexValue((Object)"IN_VIDKey"), this.inet.siteSet, new UserDatumNumberEdgeValue((Object)"IN_EIDKey"), this.inet.edgeSet);
        this.vv.setToolTipFunction((ToolTipFunction)gTTF);
        JPanel parameterGrid = new JPanel(new GridLayout(5, 2));
        JLabel maximumVertexSizeLabel = new JLabel("Vertex Display Size", 4);
        final JTextField maximumVertexSizeText = new JTextField(Double.toString(this.inet.DisplayMaxVertexScale), 4);
        maximumVertexSizeLabel.setToolTipText("Display size of vertices of weight 1.0, unless negative when absolute value sets size of largest valued vertex.");
        maximumVertexSizeText.setToolTipText("Display size of vertices of weight 1.0, unless negative when absolute value sets size of largest valued vertex.");
        maximumVertexSizeText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((ClusteringWindow)ClusteringWindow.this).inet.DisplayMaxVertexScale = Double.parseDouble(maximumVertexSizeText.getText());
                ClusteringWindow.this.setVertexDisplaySizes();
            }
        });
        parameterGrid.add(maximumVertexSizeLabel);
        parameterGrid.add(maximumVertexSizeText);
        JLabel zeroEdgeWeightLabel = new JLabel("edge weight zero", 4);
        String outString = String.format("%8.6f", this.inet.edgeSet.displayZeroEdgeWeight);
        final JTextField zeroEdgeWeightText = new JTextField(outString, 4);
        zeroEdgeWeightLabel.setToolTipText("Minimum weight of edge shown in display");
        zeroEdgeWeightText.setToolTipText("Minimum weight of edge shown in display");
        zeroEdgeWeightText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayZeroEdgeWeight = Double.parseDouble(zeroEdgeWeightText.getText());
            }
        });
        parameterGrid.add(zeroEdgeWeightLabel);
        parameterGrid.add(zeroEdgeWeightText);
        JLabel minimumEdgeWeightLabel = new JLabel("edge weight min", 4);
        final JTextField minimumEdgeWeightText = new JTextField(Double.toString(this.inet.edgeSet.displayMinimumEdgeWeight), 4);
        minimumEdgeWeightLabel.setToolTipText("Maximum weight of any edges given the thinest displayed edge size");
        minimumEdgeWeightText.setToolTipText("Maximum weight of any edges given the thinest displayed edge size");
        minimumEdgeWeightText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayMinimumEdgeWeight = Double.parseDouble(minimumEdgeWeightText.getText());
            }
        });
        parameterGrid.add(minimumEdgeWeightLabel);
        parameterGrid.add(minimumEdgeWeightText);
        JLabel maximumEdgeWeightLabel = new JLabel("edge weight max", 4);
        final JTextField maximumEdgeWeightText = new JTextField(Double.toString(this.inet.edgeSet.displayMaximumEdgeWeight), 4);
        maximumEdgeWeightLabel.setToolTipText("Thickest lines associated with edges of this edge weight or greater");
        maximumEdgeWeightText.setToolTipText("Thickest lines associated with edges of this edge weight or greater");
        maximumEdgeWeightText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayMaximumEdgeWeight = Double.parseDouble(maximumEdgeWeightText.getText());
            }
        });
        parameterGrid.add(maximumEdgeWeightLabel);
        parameterGrid.add(maximumEdgeWeightText);
        JLabel maximumEdgeStrokeLabel = new JLabel("line width max", 4);
        maximumEdgeStrokeLabel.setToolTipText("Maximum width of lines when drawing edges");
        final JTextField maximumEdgeStrokeText = new JTextField(this.maxEdgeDisplaySize.toString(), 4);
        maximumEdgeStrokeLabel.setToolTipText("Maximum width of lines in display");
        maximumEdgeStrokeText.setToolTipText("Maximum width of lines in display");
        maximumEdgeStrokeText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClusteringWindow.this.setMaxEdgeStrokeSize(Float.valueOf(Float.parseFloat(maximumEdgeStrokeText.getText())));
            }
        });
        parameterGrid.add(maximumEdgeStrokeLabel);
        parameterGrid.add(maximumEdgeStrokeText);
        this.defaultEdgeFraction = 3.0 / (double)this.inet.edgeSet.getNumberSites();
        final JSlider edgeFractionSlider = this.makePercentageSlider(new Dimension(210, 50), "Sets the proportion of black edges used to cluster vertices", this.defaultEdgeFraction);
        final JPanel sliderPanel = new JPanel();
        sliderPanel.setOpaque(true);
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 1));
        sliderPanel.add(Box.createVerticalGlue());
        sliderPanel.add(edgeFractionSlider);
        final JToggleButton groupVertices = new JToggleButton("Group Clusters");
        groupVertices.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ClusteringWindow.this.clusterAndRecolor(ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()), edgeFractionSlider.getValue(), similarColors, e.getStateChange() == 1);
            }
        });
        groupVertices.setToolTipText("If button is depressed then network is coloured using clustering method");
        this.edgeFractionSliderString = "Clustering percentage: ";
        String eastSize = this.edgeFractionSliderString + edgeFractionSlider.getValue();
        final TitledBorder sliderBorder = BorderFactory.createTitledBorder(eastSize);
        sliderPanel.setBorder(sliderBorder);
        sliderPanel.add(Box.createVerticalGlue());
        edgeFractionSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    ClusteringWindow.this.sliderValue = source.getValue();
                    ClusteringWindow.this.clusterAndRecolor(ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()), ClusteringWindow.this.sliderValue, similarColors, groupVertices.isSelected());
                    sliderBorder.setTitle(ClusteringWindow.this.edgeFractionSliderString + ClusteringWindow.this.sliderValue);
                    sliderPanel.repaint();
                    ClusteringWindow.this.vv.validate();
                    ClusteringWindow.this.vv.repaint();
                }
            }
        });
        this.clusterAndRecolor(this.layoutType.getLayoutType(this.jc.getGraph()), edgeFractionSlider.getValue(), similarColors, groupVertices.isSelected());
        double defaultInfluenceProbability = 0.5;
        JSlider influenceProbabilitySlider = this.makePercentageSlider(new Dimension(210, 50), "Sets the inluence probability", defaultInfluenceProbability);
        final JPanel isliderPanel = new JPanel();
        isliderPanel.setOpaque(true);
        isliderPanel.setLayout(new BoxLayout(isliderPanel, 1));
        isliderPanel.add(Box.createVerticalGlue());
        isliderPanel.add(influenceProbabilitySlider);
        String iedgeFractionSliderString = "Influence probability percentage: ";
        String ieastSize = "Influence probability percentage: " + influenceProbabilitySlider.getValue() + " (distance=" + ProbabilityDistance.probabilityToDistanceString((double)this.isliderValue / 100.0) + ")";
        final TitledBorder isliderBorder = BorderFactory.createTitledBorder(ieastSize);
        isliderPanel.setBorder(isliderBorder);
        isliderPanel.add(Box.createVerticalGlue());
        influenceProbabilitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    ClusteringWindow.this.isliderValue = source.getValue();
                    ClusteringWindow.this.inet.calcInfluence((double)ClusteringWindow.this.isliderValue / 100.0);
                    System.out.println("!!! Average Influence Weight= " + ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getAverage(IslandEdge.influenceWeightINDEX) + ", prob =" + ClusteringWindow.this.inet.getInfluenceProbability() + " (distance=" + ProbabilityDistance.probabilityToDistanceString((double)ClusteringWindow.this.isliderValue / 100.0) + ")");
                    isliderBorder.setTitle("Influence probability percentage: " + ClusteringWindow.this.isliderValue + " (distance=" + ProbabilityDistance.probabilityToDistanceString((double)ClusteringWindow.this.isliderValue / 100.0) + ")");
                    isliderPanel.repaint();
                    ClusteringWindow.this.vv.validate();
                    ClusteringWindow.this.vv.repaint();
                }
            }
        });
        this.inet.calcInfluence((double)this.isliderValue / 100.0);
        final JComboBox<String> layoutChooser = new JComboBox<String>();
        layoutChooser.setToolTipText("Choose type of layout of network");
        for (int i = 0; i < this.layoutType.numberTypes; ++i) {
            layoutChooser.addItem(this.layoutType.getString(i));
        }
        layoutChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((ClusteringWindow)ClusteringWindow.this).layoutType.value = layoutChooser.getSelectedIndex();
                ClusteringWindow.this.vv.setGraphLayout((Layout)ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()));
                ClusteringWindow.this.vv.validate();
                ClusteringWindow.this.vv.repaint();
            }
        });
        layoutChooser.setSelectedIndex(this.layoutType.value);
        final JComboBox<String> clusterChooser = new JComboBox<String>();
        clusterChooser.setToolTipText("Choose Edge Selector");
        for (int i = 0; i < this.clusterType.numberTypes; ++i) {
            clusterChooser.addItem(this.clusterType.getString(i));
        }
        clusterChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((ClusteringWindow)ClusteringWindow.this).clusterType.value = clusterChooser.getSelectedIndex();
                ClusteringWindow.this.edgeFractionSliderString = ClusteringWindow.this.clusterType.getCurrentTypeString() + " clusterer percentage ";
                edgeFractionSlider.setEnabled(!ClusteringWindow.this.clusterType.noVariableClustering());
                ClusteringWindow.this.vv.restart();
            }
        });
        clusterChooser.setSelectedIndex(this.clusterType.value);
        edgeFractionSlider.setEnabled(!this.clusterType.noVariableClustering());
        final JComboBox<String> vertexChooser = new JComboBox<String>();
        vertexChooser.setToolTipText("Choose type of vertex to display");
        for (int i = 0; i < VertexTypeSelection.numberTypes; ++i) {
            vertexChooser.addItem(VertexTypeSelection.name[i]);
        }
        vertexChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((ClusteringWindow)ClusteringWindow.this).inet.DisplayVertexType.setValue(vertexChooser.getSelectedIndex());
                ClusteringWindow.this.setVertexDisplaySizes();
                ClusteringWindow.this.vv.restart();
            }
        });
        vertexChooser.setSelectedIndex(this.inet.DisplayVertexType.getValue());
        final JComboBox<String> edgeChooser = new JComboBox<String>();
        edgeChooser.setToolTipText("Choose type of edge to display");
        for (int i = 0; i < EdgeTypeSelection.numberTypes; ++i) {
            edgeChooser.addItem(EdgeTypeSelection.name[i]);
        }
        edgeChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.DisplayEdgeType.setValue(edgeChooser.getSelectedIndex());
                ClusteringWindow.this.jc.replaceAllEdges();
                ClusteringWindow.this.vv.restart();
            }
        });
        edgeChooser.setSelectedIndex(this.inet.edgeSet.DisplayEdgeType.getValue());
        JButton redrawButton = new JButton("Redraw");
        redrawButton.setToolTipText("Redraw network using current parameter values");
        redrawButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ClusteringWindow.this.setVertexDisplaySizes(Double.parseDouble(maximumVertexSizeText.getText()), vertexChooser.getSelectedIndex());
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayZeroEdgeWeight = Double.parseDouble(zeroEdgeWeightText.getText());
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayMinimumEdgeWeight = Double.parseDouble(minimumEdgeWeightText.getText());
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayMaximumEdgeWeight = Double.parseDouble(maximumEdgeWeightText.getText());
                ClusteringWindow.this.setMaxEdgeStrokeSize(Float.valueOf(Float.parseFloat(maximumEdgeStrokeText.getText())));
                ClusteringWindow.this.clusterAndRecolor(ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()), ClusteringWindow.this.sliderValue, similarColors, groupVertices.isSelected());
                ClusteringWindow.this.vv.setGraphLayout((Layout)ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()));
                ClusteringWindow.this.vv.restart();
                ClusteringWindow.this.vv.validate();
                ClusteringWindow.this.vv.repaint();
            }
        });
        JButton restartButton = new JButton("Restart");
        restartButton.setToolTipText("Restart network drawing routines current parameter values");
        restartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ClusteringWindow.this.setVertexDisplaySizes(Double.parseDouble(maximumVertexSizeText.getText()), vertexChooser.getSelectedIndex());
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayZeroEdgeWeight = Double.parseDouble(zeroEdgeWeightText.getText());
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayMinimumEdgeWeight = Double.parseDouble(minimumEdgeWeightText.getText());
                ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displayMaximumEdgeWeight = Double.parseDouble(maximumEdgeWeightText.getText());
                ClusteringWindow.this.setMaxEdgeStrokeSize(Float.valueOf(Float.parseFloat(maximumEdgeStrokeText.getText())));
                ClusteringWindow.this.jc.replaceAllEdges();
                ClusteringWindow.this.clusterAndRecolor(ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()), ClusteringWindow.this.sliderValue, similarColors, groupVertices.isSelected());
                ClusteringWindow.this.setUpJungViewer(ClusteringWindow.this.jc.getGraph(), ClusteringWindow.this.networkVisualisationDimension());
                ClusteringWindow.this.vv.setGraphLayout((Layout)ClusteringWindow.this.layoutType.getLayoutType(ClusteringWindow.this.jc.getGraph()));
                ClusteringWindow.this.vv.restart();
                ClusteringWindow.this.vv.validate();
                ClusteringWindow.this.vv.repaint();
                System.out.println("!!! Jung display has " + ClusteringWindow.this.jc.getNumberEdges() + " edges, width=" + ClusteringWindow.this.vv.getWidth() + ", height=" + ClusteringWindow.this.vv.getHeight());
            }
        });
        JButton reheatButton = new JButton("Reheat");
        reheatButton.setToolTipText("Monte Carlo network reheating starting from current layout");
        reheatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                islandNetwork reheatNet = new islandNetwork(ClusteringWindow.this.inet);
                reheatNet.message.setInformationLevel(2);
                reheatNet.updateMode.setFromName("MC");
                reheatNet.monteCarloStartMode.setFromName("Old");
                InputParameterFrame iw = new InputParameterFrame(reheatNet);
            }
        });
        JButton informationButton = new JButton("Info");
        informationButton.setToolTipText("Gives debugging information");
        informationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String s = ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.displaySizeString(": ", ", ") + ", max screen size:" + ClusteringWindow.this.maxEdgeDisplaySize + ",\n Clustering: " + ClusteringWindow.this.clusterType.getCurrentTypeString() + ", Layout: " + ClusteringWindow.this.layoutType.getCurrentTypeString();
                JOptionPane.showMessageDialog(null, s);
            }
        });
        JButton gmlButton = new JButton("GraphML");
        gmlButton.setToolTipText("Writes a GraphML file for Visone");
        gmlButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ClusteringWindow.this.writeGMLImage(ClusteringWindow.this.vv);
            }
        });
        JButton jpgButton = new JButton("JPEG");
        jpgButton.setToolTipText("Writes a jpeg file of network");
        jpgButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ClusteringWindow.this.writeJPEGImage();
            }
        });
        JButton epsButton = new JButton("EPS");
        epsButton.setToolTipText("Writes a eps file of network");
        epsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ClusteringWindow.this.writeEPSImage();
            }
        });
        JButton printButton = new JButton("Print");
        printButton.setToolTipText("Prints a jpeg file of network");
        printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PrintableNetwork pn = new PrintableNetwork(ClusteringWindow.this.vv, ClusteringWindow.this.inet.getNameString(", "));
                PrinterJob printJob = PrinterJob.getPrinterJob();
                printJob.setPrintable(pn);
                if (printJob.printDialog()) {
                    try {
                        printJob.print();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        JButton saveButton = new JButton("Save");
        saveButton.setToolTipText("Saves files for this network ");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ClusteringWindow.this.writeJPEGImage(ClusteringWindow.this.vv, ClusteringWindow.this.networkVisualisationDimension());
                ClusteringWindow.this.inet.saveFiles("#", 5);
            }
        });
        JPanel grid = new JPanel(new GridLayout(3, 3, 3, 3));
        grid.add(redrawButton);
        grid.add(restartButton);
        grid.add(reheatButton);
        grid.add(informationButton);
        grid.add(groupVertices);
        grid.add(jpgButton);
        grid.add(epsButton);
        grid.add(printButton);
        grid.add(saveButton);
        JPanel name = new JPanel(new GridLayout(4, 2));
        name.add(new JLabel("basic name:  ", 4));
        name.add(new JLabel(this.inet.outputFile.getBasicRoot(), 2));
        name.add(new JLabel("parameters:  ", 4));
        name.add(new JLabel(this.inet.outputFile.getParameterName(), 2));
        name.add(new JLabel("run:  ", 4));
        name.add(new JLabel("" + this.inet.outputFile.sequenceNumber, 2));
        name.add(new JLabel("energy:  ", 4));
        name.add(new JLabel(String.format("%10.4g", this.inet.globalProperties.getEnergy()), 2));
        JPanel inputValues = new JPanel(new GridLayout(2, 5));
        inputValues.add(new JLabel("mu", 0));
        inputValues.add(new JLabel("j", 0));
        inputValues.add(new JLabel("k", 0));
        inputValues.add(new JLabel("l", 0));
        inputValues.add(new JLabel("s", 0));
        inputValues.add(new JLabel(n2s.toString(this.inet.Hamiltonian.edgeSource), 0));
        inputValues.add(new JLabel(n2s.toString(this.inet.Hamiltonian.vertexSource), 0));
        inputValues.add(new JLabel(n2s.toString(this.inet.Hamiltonian.kappa), 0));
        inputValues.add(new JLabel(n2s.toString(this.inet.Hamiltonian.lambda), 0));
        inputValues.add(new JLabel(n2s.toString(this.inet.Hamiltonian.distanceScale), 0));
        JPanel outputValues = new JPanel(new GridLayout(2, 5));
        boolean saturated = false;
        if (this.inet.vertexMode.maxValueModeOn && this.inet.siteSet.siteWeightStats.maximum > this.inet.vertexMode.maximumValue * 0.95) {
            saturated = true;
        }
        outputValues.add(new JLabel("<Sv>", 0));
        outputValues.add(new JLabel("Sv.Max", 0));
        outputValues.add(new JLabel("<Str.In> ", 0));
        JLabel vmaxlabel = new JLabel("v.Max", 0);
        if (saturated) {
            vmaxlabel.setForeground(Color.RED);
            vmaxlabel.setBackground(Color.BLACK);
            vmaxlabel.setOpaque(true);
        }
        outputValues.add(vmaxlabel);
        outputValues.add(new JLabel("E", 0));
        outputValues.add(new JLabel(n2s.toString(this.inet.siteSet.siteWeightStats.getAverage()), 0));
        outputValues.add(new JLabel(n2s.toString(this.inet.siteSet.siteWeightStats.maximum), 0));
        outputValues.add(new JLabel(n2s.toString(this.inet.siteSet.siteStrengthInStats.getAverage()), 0));
        vmaxlabel = new JLabel(n2s.toString(this.inet.siteSet.siteValueStats.maximum), 0);
        if (saturated) {
            vmaxlabel.setForeground(Color.RED);
            vmaxlabel.setBackground(Color.BLACK);
            vmaxlabel.setOpaque(true);
        }
        outputValues.add(vmaxlabel);
        outputValues.add(new JLabel(String.format("%10.4g", this.inet.globalProperties.getEnergy()), 0));
        String outputNameRoot = this.inet.outputFile.getFullFileRoot();
        int w = Math.max(outputNameRoot.length() * 6, 90);
        Box controlBox = Box.createVerticalBox();
        Dimension cbPrefDim = new Dimension(Math.min(jungSize / 2, screenSizeDim.width - jungSize), jungSize);
        controlBox.setPreferredSize(cbPrefDim);
        controlBox.add(name);
        controlBox.add(inputValues);
        controlBox.add(outputValues);
        controlBox.add(grid);
        controlBox.add(sliderPanel);
        controlBox.add(isliderPanel);
        JPanel chooserGrid = new JPanel(new GridLayout(5, 2, 3, 3));
        this.addJComboBoxToGrid(chooserGrid, "Mouse Mode", gm.getModeComboBox());
        this.addJComboBoxToGrid(chooserGrid, "Clusterer", clusterChooser);
        this.addJComboBoxToGrid(chooserGrid, "Layout", layoutChooser);
        this.addJComboBoxToGrid(chooserGrid, "Vertex Type", vertexChooser);
        this.addJComboBoxToGrid(chooserGrid, "Edge Type", edgeChooser);
        controlBox.add(chooserGrid);
        controlBox.add(parameterGrid);
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        int netVisSize = this.networkVisualisationSize();
        gzsp.setSize(netVisSize, netVisSize);
        this.add((Component)gzsp);
        this.add(controlBox);
    }

    private void addJComboBoxToGrid(JPanel grid, String comboBoxName, JComboBox comboBox) {
        JLabel label = new JLabel(comboBoxName, 4);
        label.setToolTipText(comboBox.getToolTipText());
        grid.add(label);
        grid.add(comboBox);
    }

    private JSlider makePercentageSlider(Dimension d, String toolTipText, double defaultFraction) {
        JSlider edgeFractionSlider = new JSlider(0);
        edgeFractionSlider.setToolTipText(toolTipText);
        edgeFractionSlider.setBackground(Color.WHITE);
        edgeFractionSlider.setPreferredSize(d);
        edgeFractionSlider.setPaintTicks(true);
        edgeFractionSlider.setMaximum(100);
        edgeFractionSlider.setMinimum(0);
        this.sliderValue = (int)(100.0 * defaultFraction);
        edgeFractionSlider.setValue(this.sliderValue);
        edgeFractionSlider.setMinorTickSpacing(5);
        edgeFractionSlider.setMajorTickSpacing(20);
        edgeFractionSlider.setPaintLabels(true);
        edgeFractionSlider.setPaintTicks(true);
        return edgeFractionSlider;
    }

    private void setMaxEdgeStrokeSize(Float value) {
        this.maxEdgeDisplaySize = value;
        if (this.maxEdgeDisplaySize.floatValue() < 0.0f) {
            this.maxEdgeDisplaySize = Float.valueOf(0.0f);
        }
        if (this.maxEdgeDisplaySize.floatValue() > 20.0f) {
            this.maxEdgeDisplaySize = Float.valueOf(20.0f);
        }
    }

    private void setVertexDisplaySizes(double displayMaxVertexScale, int displayVertexTypeIndex) {
        this.inet.DisplayMaxVertexScale = displayMaxVertexScale;
        this.inet.DisplayVertexType.setValue(displayVertexTypeIndex);
        this.setVertexDisplaySizes();
    }

    private void setVertexDisplaySizes() {
        this.inet.siteSet.setAllDisplaySizes(this.inet.DisplayVertexType.getValueIndex(), this.inet.DisplayMaxVertexScale);
    }

    public void clusterAndRecolor(SubLayoutDecorator layout, int sliderValue, Color[] colors, boolean groupClusters) {
        List edges;
        VertexClusterSet clusterSet;
        Graph g = layout.getGraph();
        layout.removeAllSubLayouts();
        switch (this.clusterType.value) {
            case 2: {
                int numEdgesToRemove = (int)(0.5 + (double)(g.numEdges() * sliderValue) / 100.0);
                EdgeBetweennessClusterer clusterer = new EdgeBetweennessClusterer(numEdgesToRemove);
                clusterSet = clusterer.extract((ArchetypeGraph)g);
                edges = clusterer.getEdgesRemoved();
                break;
            }
            case 1: {
                EdgePercolationClusterer clusterer = new EdgePercolationClusterer((ArchetypeGraph)g, this.inet);
                double edgeMinWeight = this.inet.edgeSet.getDisplayMaximum() * 1.01010101 * (double)sliderValue / 100.0;
                clusterSet = clusterer.extract(edgeMinWeight);
                edges = clusterer.getEdgesRemoved();
                break;
            }
            default: {
                edges = new ArrayList();
                clusterSet = new VertexClusterSet((ArchetypeGraph)g);
                clusterSet.addCluster(g.getVertices());
            }
        }
        int i = 0;
        for (Set vertices : clusterSet) {
            Color c = colors[i % colors.length];
            this.colorCluster(vertices, c);
            if (groupClusters) {
                this.groupCluster(layout, vertices);
            }
            ++i;
        }
        for (Edge e : g.getEdges()) {
            if (edges.contains(e)) {
                e.setUserDatum(ISLANDCLUSTERKEY, (Object)PERCREMOVEDCOLOUR, UserData.REMOVE);
                continue;
            }
            e.setUserDatum(ISLANDCLUSTERKEY, (Object)Color.BLACK, UserData.REMOVE);
        }
    }

    private void colorCluster(Set vertices, Color c) {
        for (Vertex v : vertices) {
            v.setUserDatum(ISLANDCLUSTERKEY, (Object)c, UserData.REMOVE);
        }
    }

    private void groupCluster(SubLayoutDecorator layout, Set vertices) {
        if (vertices.size() < layout.getGraph().numVertices()) {
            Point2D center = layout.getLocation((ArchetypeVertex)vertices.iterator().next());
            CircularSubLayout subLayout = new CircularSubLayout((Collection)vertices, 20.0, center);
            layout.addSubLayout((SubLayout)subLayout);
        }
    }

    public void writeJPEGImage() {
        this.writeJPEGImage(this.vv, this.vv.getPreferredSize());
    }

    private void writeJPEGImage(VisualizationViewer vv, Dimension size) {
        String filenamecomplete = this.inet.outputFile.getFullLocationFileRootSN() + "_sl" + this.sliderValue + "_j" + this.jpegCount++;
        this.inet.message.println(-1, "Attempting to write jpg file to " + filenamecomplete);
        String label = this.inet.getNameString(", ");
        JpegNetwork.writeJPEGImage(filenamecomplete, label, vv, size.width, size.height);
        this.writeJPEGDescriptionFile(filenamecomplete);
    }

    public void writeEPSImage() {
        this.writeEPSImage(this.vv, this.vv.getPreferredSize());
    }

    private void writeEPSImage(VisualizationViewer vv, Dimension size) {
        String filenamecomplete = this.inet.outputFile.getFullLocationFileRootSN() + "_sl" + this.sliderValue + "_j" + this.jpegCount++;
        this.inet.message.println(-1, "Attempting to write eps file to " + filenamecomplete);
        String label = this.inet.getNameString(", ");
        boolean messageOn = true;
        EPSNetwork.FileOutputEPSNetwork(filenamecomplete, this.jc, vv, messageOn, messageOn);
        this.writeImageDescriptionFile(filenamecomplete, "eps");
    }

    private void writeJPEGDescriptionFile(String nameRoot) {
        this.writeImageDescriptionFile(nameRoot, "jpg");
    }

    private void writeImageDescriptionFile(String nameRoot, String type) {
        String filenamecomplete = nameRoot + "_" + type + "descr.dat";
        this.inet.message.println(-1, "Attempting to write description of " + type + " file to " + filenamecomplete);
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.inet.printiNVERSION("#", PS);
            this.inet.showHamiltonianParameters(PS);
            this.printDisplayVariables(PS, "\t");
            try {
                fout.close();
                if (this.inet.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.err.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    private void writeGMLImage(VisualizationViewer vv) {
        String filenameroot = this.inet.outputFile.getFullLocationFileRootSN() + "_sl" + this.sliderValue + "_g" + this.gmlCount++;
        GraphML.FileOutputGMLNetwork(filenameroot + ".graphml", this.jc, vv, true, true);
        this.writeGMLDescriptionFile(filenameroot);
    }

    private void writeGMLDescriptionFile(String nameRoot) {
        String filenamecomplete = nameRoot + "_gmldescr.dat";
        this.inet.message.println(-1, "Attempting to write description of graphMLfile to " + filenamecomplete);
        try {
            FileOutputStream fout = new FileOutputStream(filenamecomplete);
            PrintStream PS = new PrintStream(fout);
            this.inet.printiNVERSION("#", PS);
            this.inet.showHamiltonianParameters(PS);
            this.printDisplayVariables(PS, "\t");
            try {
                fout.close();
                if (this.inet.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + filenamecomplete);
                }
            }
            catch (IOException e) {
                System.err.println("File Error");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Error opening output file " + filenamecomplete);
            return;
        }
    }

    private void printDisplayVariables(PrintStream PS, String sep) {
        PS.println("         Slider value " + sep + this.sliderValue);
        PS.println("            Clusterer " + sep + this.clusterType.getCurrentTypeString());
        PS.println("               Layout " + sep + this.layoutType.getCurrentTypeString());
        PS.println("     Vertex Displayed " + sep + this.inet.DisplayVertexType.getCurrentTypeString());
        PS.println(" defaultEdgeFractiont " + sep + this.defaultEdgeFraction);
        PS.println("        maxEdgeWeight " + sep + this.inet.edgeSet.displayMinimumEdgeWeight);
        PS.println("        minEdgeWeight " + sep + this.inet.edgeSet.displayMinimumEdgeWeight);
        PS.println("   maxEdgeDisplaySize " + sep + this.maxEdgeDisplaySize);
        PS.println("DisplayMaxVertexScale " + sep + this.inet.DisplayMaxVertexScale);
        PS.println(" maxVertexDisplaySize " + sep + this.maxVertexDisplaySize);
    }

    private void writeJPEGImageOld(VisualizationViewer vv) {
        String filenamecomplete = this.inet.outputFile.getFullLocationFileRoot() + "sl" + this.sliderValue + "_" + this.jpegCount++ + ".jpg";
        System.out.println("Attempting to write jpg file to " + filenamecomplete);
        File file = new File(filenamecomplete);
        int width = vv.getWidth();
        int height = vv.getHeight();
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D graphics = bi.createGraphics();
        vv.paint((Graphics)graphics);
        graphics.setColor(Color.black);
        graphics.drawString(this.inet.Hamiltonian.inputParametersString(this.inet.outputFile.getBasicRoot(), ", ", 3), 2, height - 2);
        graphics.dispose();
        try {
            ImageIO.write((RenderedImage)bi, "jpeg", file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ClusterType {
        final String[] clusterTypeArray = new String[]{"Nothing", "Percolation", "Edge Betweenness"};
        public final int numberTypes = this.clusterTypeArray.length;
        public int value = 0;

        public void setclusterType(String s) {
            for (int i = 0; i < this.clusterTypeArray.length; ++i) {
                if (!this.clusterTypeArray[i].startsWith(s.substring(0, 1))) continue;
                this.value = i;
                return;
            }
            this.value = -1;
        }

        public String getString(int i) {
            if (i < 0 || i >= this.clusterTypeArray.length) {
                return "UNKNOWN";
            }
            return this.clusterTypeArray[i];
        }

        public String getCurrentTypeString() {
            return this.getString(this.value);
        }

        public boolean noVariableClustering() {
            return this.value == 0;
        }
    }

    private class LayoutType {
        final String[] layoutTypeArray = new String[]{"Geographical", "Circular", "KK Geographical", "KK Edge Value", "KK Edge Separation", "FR"};
        public final int numberTypes = this.layoutTypeArray.length;
        public int value = 0;
        public double scale = 1.0;

        public LayoutType(double scale) {
            this.scale = scale;
        }

        public void setlayoutType(String s) {
            for (int i = 0; i < this.layoutTypeArray.length; ++i) {
                if (!s.substring(0, 1).equals(this.layoutTypeArray[i].substring(0, 1))) continue;
                this.value = i;
                return;
            }
            this.value = -1;
        }

        public String getString(int i) {
            if (i < 0 || i >= this.layoutTypeArray.length) {
                return "UNKNOWN";
            }
            return this.layoutTypeArray[i];
        }

        public String getCurrentTypeString() {
            return this.getString(this.value);
        }

        private SubLayoutDecorator getLayoutType(Graph graph) {
            SubLayoutDecorator layout;
            double displayLengthFactor = 0.5;
            switch (this.value) {
                case 5: {
                    layout = new SubLayoutDecorator((Layout)new FRLayout(graph));
                    break;
                }
                case 4: {
                    int ns = ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getNumberSites();
                    double distanceScale = ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getSeparationDiameter();
                    double[][] distanceArray = new double[ns][ns];
                    double dMax = (1.0 + (double)ClusteringWindow.this.sliderValue) / 101.0;
                    for (int i = 0; i < ns; ++i) {
                        for (int j = 0; j < ns; ++j) {
                            double d = (((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getEdgeSeparation(i, j) + ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getEdgeSeparation(j, i)) / (2.0 * distanceScale);
                            distanceArray[i][j] = d > dMax ? 1.0 : d;
                        }
                    }
                    layout = new SubLayoutDecorator((Layout)new KKWeightedLayout(graph, distanceArray, displayLengthFactor));
                    break;
                }
                case 3: {
                    int ns = ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getNumberSites();
                    double evMin = (1.0 + (double)ClusteringWindow.this.sliderValue) / 101.0;
                    double[][] distanceArray = new double[ns][ns];
                    for (int i = 0; i < ns; ++i) {
                        for (int j = 0; j < ns; ++j) {
                            double ev = (((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getEdgeValue(i, j) + ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getEdgeValue(j, i)) / 2.0;
                            distanceArray[i][j] = ev < evMin ? 1.0 : evMin / ev;
                        }
                    }
                    layout = new SubLayoutDecorator((Layout)new KKWeightedLayout(graph, distanceArray, displayLengthFactor));
                    break;
                }
                case 2: {
                    int ns = ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getNumberSites();
                    double distanceScale = ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getDistanceDiameter();
                    double[][] distanceArray = new double[ns][ns];
                    double dMax = (1.0 + (double)ClusteringWindow.this.sliderValue) / 101.0;
                    double dMin = 0.009900990099009901;
                    for (int i = 0; i < ns; ++i) {
                        for (int j = 0; j < ns; ++j) {
                            double d = (((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getEdgeDistance(i, j) + ((ClusteringWindow)ClusteringWindow.this).inet.edgeSet.getEdgeDistance(j, i)) / (2.0 * distanceScale);
                            distanceArray[i][j] = d > dMax ? 1.0 : (d < dMin ? dMin : d);
                            if (!(d <= 0.0)) continue;
                            System.err.println("Distance from " + i + " to " + j + " is negative or zero");
                        }
                    }
                    layout = new SubLayoutDecorator((Layout)new KKWeightedLayout(graph, distanceArray, displayLengthFactor));
                    break;
                }
                case 1: {
                    layout = new SubLayoutDecorator((Layout)new CircleLayout(graph));
                    break;
                }
                default: {
                    layout = new SubLayoutDecorator((Layout)new GeographicalLayout(graph, ClusteringWindow.this.jc.getXCoordKey(), ClusteringWindow.this.jc.getYCoordKey(), this.scale * 0.8, this.scale * 0.1));
                }
            }
            return layout;
        }
    }
}

