/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.islandNetwork;
import IslandNetworks.jungInterfaces.EdgePercolationClusterer;
import IslandNetworks.jungInterfaces.JungConverter;
import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.MultiPickedState;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.contrib.CircleLayout;
import edu.uci.ics.jung.visualization.subLayout.CircularSubLayout;
import edu.uci.ics.jung.visualization.subLayout.SubLayout;
import edu.uci.ics.jung.visualization.subLayout.SubLayoutDecorator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CWTest
extends JPanel {
    private static final Object ISLANDCLUSTERKEY = "ISLANDCLUSTERKEY";
    private static final int MAXSLIDERVALUE = 100;
    private static final double maxEdgeValue = 1.0;
    private JungConverter jc;
    private islandNetwork inet;
    private int layoutType = 0;
    public final Color[] similarColors = new Color[]{new Color(216, 134, 134), new Color(135, 137, 211), new Color(134, 206, 189), new Color(206, 176, 134), new Color(194, 204, 134), new Color(145, 214, 134), new Color(133, 178, 209), new Color(103, 148, 255), new Color(60, 220, 220), new Color(30, 250, 100)};

    public CWTest(islandNetwork inetInput) {
        this.jc = new JungConverter(this.inet);
        this.inet = inetInput;
        this.layoutType = this.getLayoutType("circular");
        JTextField test = new JTextField("testing JLabel class CWTest constructor");
        this.add(test);
    }

    public void init() {
        JTextField test = new JTextField("testing init");
        this.add(test);
    }

    public void start() {
        JTextField test = new JTextField("testing start");
        this.add(test);
    }

    private void setUpView() {
        Graph graph = this.jc.getGraph();
        SubLayoutDecorator layout = new SubLayoutDecorator((Layout)new CircleLayout(graph));
        MultiPickedState ps = new MultiPickedState();
        PluggableRenderer pr = new PluggableRenderer();
        pr.setVertexPaintFunction(new VertexPaintFunction((PickedState)ps){
            final /* synthetic */ PickedState val$ps;
            {
                this.val$ps = pickedState;
            }

            public Paint getFillPaint(Vertex v) {
                Color k = (Color)v.getUserDatum(ISLANDCLUSTERKEY);
                if (k != null) {
                    return k;
                }
                return Color.white;
            }

            public Paint getDrawPaint(Vertex v) {
                if (this.val$ps.isPicked((ArchetypeVertex)v)) {
                    return Color.cyan;
                }
                return Color.BLACK;
            }
        });
        pr.setEdgePaintFunction(new EdgePaintFunction(){

            public Paint getDrawPaint(Edge e) {
                Color k = (Color)e.getUserDatum(ISLANDCLUSTERKEY);
                if (k != null) {
                    return k;
                }
                return Color.blue;
            }

            public Paint getFillPaint(Edge e) {
                return null;
            }
        });
        pr.setEdgeStrokeFunction(new EdgeStrokeFunction(){
            protected final Stroke THIN = new BasicStroke(1.0f);
            protected final Stroke THICK = new BasicStroke(2.0f);

            public Stroke getStroke(Edge e) {
                Color c = (Color)e.getUserDatum(ISLANDCLUSTERKEY);
                if (c == Color.LIGHT_GRAY) {
                    return this.THIN;
                }
                return this.THICK;
            }
        });
        VisualizationViewer vv = new VisualizationViewer((Layout)layout, (Renderer)pr, new Dimension(100, 100));
        vv.setBackground(Color.yellow);
        JTextField test = new JTextField("testing");
        this.add(test);
    }

    public void clusterAndRecolor(SubLayoutDecorator layout, int sliderValue, Color[] colors, boolean groupClusters) {
        Graph g = layout.getGraph();
        layout.removeAllSubLayouts();
        EdgePercolationClusterer clusterer = new EdgePercolationClusterer((ArchetypeGraph)g, this.inet);
        double edgeMinValue = 1.0 * (double)sliderValue / 100.0;
        ClusterSet clusterSet = clusterer.extract(edgeMinValue);
        List edges = clusterer.getEdgesRemoved();
        int i = 0;
        for (Set vertices : clusterSet) {
            Color c = colors[i % colors.length];
            this.colorCluster(vertices, c);
            if (groupClusters) {
                this.groupCluster(layout, vertices);
            }
            ++i;
        }
        for (Edge e : g.getEdges()) {
            if (edges.contains(e)) {
                e.setUserDatum(ISLANDCLUSTERKEY, (Object)Color.LIGHT_GRAY, UserData.REMOVE);
                continue;
            }
            e.setUserDatum(ISLANDCLUSTERKEY, (Object)Color.BLACK, UserData.REMOVE);
        }
    }

    private void colorCluster(Set vertices, Color c) {
        for (Vertex v : vertices) {
            v.setUserDatum(ISLANDCLUSTERKEY, (Object)c, UserData.REMOVE);
        }
    }

    private void groupCluster(SubLayoutDecorator layout, Set vertices) {
        if (vertices.size() < layout.getGraph().numVertices()) {
            Point2D center = layout.getLocation((ArchetypeVertex)vertices.iterator().next());
            CircularSubLayout subLayout = new CircularSubLayout((Collection)vertices, 20.0, center);
            layout.addSubLayout((SubLayout)subLayout);
        }
    }

    private int getLayoutType(String s) {
        if (s.substring(0, 1) == "g") {
            return 0;
        }
        if (s.substring(0, 1) == "c") {
            return 1;
        }
        if (s.substring(0, 1) == "f") {
            return 2;
        }
        return 0;
    }
}

