

/* This file contains routines that included just as an illustration
   of what one can do with the metric once it is found. Hence we have
   not commented this section as it has nothing to do with the process
   of actually finding the Kahler potential.

   An interested reader however, should be able to decode what is
   going on. 

   Basically the routines calcK1interp and calcK2interp calculate
   various goemetric quantities in the K1 and K2 patch as complex
   coordinate locations w,y or z1,z2 using interpolation.

   These are used by the following routines;

   calcRslice3d: Computes the contraction of the Riemann tensor
   (Kretschmann scalar) on a 3-dimensional slice (Re z2 = 0) in the
   z1,z2 coordinates. The data is stored in binary format in the file;
   calcRsqr3dslice
   
   calcEHcycle: Compute the induced Ricci scalar on the S^2 2-cycle
   sigma=0 in the K1 EH patch. stores data in binary file: EHcycle

   calcToruscycle: Compute the induced Ricci scalar on the S^2 2-cycle
   z2=0 in z1 coordinate. This requires interpolation using the K1 EH
   patch for values of sigma < MINSIG. stores data in binary file: Toruscycle

   calcEulerTrap: Computes the Euler number explicitly from the metric
   using Trapezoidal integration method. Analytic value is 24 for K3
   manifold.


 [ Note the routines to compute the derivatives of the
   Kahler potential use finite differencing imported from Mathematica,
   so appear rather complicated when embedded in the C file. ]

 */


double valarr[5] ;
double valarrint[3] ;

void calcK1interp(complex<double>,complex<double>) ;
void calcK2interp(complex<double>,complex<double>) ;

void calcKderiv1point(int,int,int,int) ;
void calcKderiv2point(int,int,int,int) ;

void calcRslice3d(void) ;
void calcEHcycle(void) ;
void calcToruscycle(void) ;
void calcEulerTrap(void) ;



void calcEulerTrap(void)
{
  int wre, wim, yre, yim ;
  int z1re, z1im, z2re, z2im ;
  double intR1, dintR1, intR2, dintR2, absz1, absz2 ;

  int ii ;

  intR1 = 0. ; intR2 = 0. ;

  cout << "Compute Euler using standard Trapezium rule:" << endl ;

  if(RES==1) cout << "WARNING: Expect very poor results for lowest resolution!" << endl ;

  for(wre=2;wre<NW1+2;wre++) {
    cout << "." ; cout.flush() ;
    for(wim=2;wim<NW1+2;wim++) {
      for(yre=2;yre<NY1+2;yre++) {
	for(yim=2;yim<NY1+2;yim++) {

  	  if( abs(coord_y1(yre,yim)) <= 1. && ( 2.*abs(coord_w1(wre,wim))*(1.+abs(coord_y1(yre,yim))*abs(coord_y1(yre,yim))) <= TRANSSIG ) )  {

	    
	    calcKderiv1point(wre,wim,yre,yim) ;
      
	    dintR1 = rootdetg*DW1*DW1*DY1*DY1*valarr[0] ;
	    
	    if(wre==2) dintR1 /= 2. ;
	    if(wim==2) dintR1 /= 2. ;
	    if(yre==2) dintR1 /= 2. ;
	    if(yim==2) dintR1 /= 2. ;
	    
	    intR1 += dintR1 ;
	  
	  }

	}
      }
    }
  }

  for(z1re=2;z1re<NZ+2;z1re++) {
    cout << "." ; cout.flush() ;
    for(z1im=2;z1im<NZ+2;z1im++) {
      for(z2re=2;z2re<NZ+2;z2re++) {
	for(z2im=2;z2im<NZ+2;z2im++) {

	  absz1 = abs(coord_z1(z1re,z1im)) ;
	  absz2 = abs(coord_z2(z2re,z2im)) ;

	  if( ( absz1*absz1 + absz2*absz2 ) >= TRANSSIG )  {

	    calcKderiv2point(z1re,z1im,z2re,z2im) ;

	    dintR2 = rootdetg*DZ*DZ*DZ*DZ*valarr[0] ;
	    
	    if(z1re==2) dintR2 /= 2. ;
	    if(z1im==2) dintR2 /= 2. ;
	    if(z2re==2) dintR2 /= 2. ;
	    if(z2im==2) dintR2 /= 2. ;
	    
	    if(z1re==NZ-1+2) dintR2 /= 2. ;
	    if(z1im==NZ-1+2) dintR2 /= 2. ;
	    if(z2re==NZ-1+2) dintR2 /= 2. ;
	    if(z2im==NZ-1+2) dintR2 /= 2. ;
	    
	    intR2 += dintR2 ;
	    
	  }

	}
      }
    }
  }

  cout << "Euler number = " << 16./(pow(3.14159,2))*(4.*intR1 + intR2) << endl ;  
  cout << "   (Should be 24 for K3 manifold)" << endl ;

}




void calcRslice3d(void)
{
  int z1re,z1im,z2re,z2im ;
  double val ;
  complex<double> z1, z2, w, y ;

  FILE *calcRsqr3d ;

  calcRsqr3d = fopen("calcRsqr3dslice","w") ; 
   
  cout << "Rsqr 3-slice z2re = 0" << endl ;

  for(z1re=2;z1re<NZ+2;z1re++) {
    cout << "." ; cout.flush() ;
    for(z1im=2;z1im<NZ+2;z1im++) {
      for(z2im=2;z2im<NZ+2;z2im++) {
	
	z2re = 2 ;
	
	z1 = coord_z1(z1re,z1im) ; z2 = coord_z2(z2re,z2im) ; 
	
	if( pow(abs(z1),2) + pow(abs(z2),2) >= TRANSSIG ) {
	  
	  calcKderiv2point(z1re,z1im,z2re,z2im) ;
	  
	  val = valarr[0] ;
	  
	} else {
	  
	  if( z1re==2 && z1im==2 && z2re==2 && z2im ==2 ) {

	    w = 0. ; y = 0. ;

	  } else {

	    if( abs(z1) >= abs(z2) ) {
	      
	      w = z1*z1/2. ;
	      y = z2/z1 ;
	      
	    } else {
	      
	      w = z2*z2/2. ;
	      y = z1/z2 ;
	      
	    }

	  }
	  
	  calcK1interp(w,y) ;

	  val = valarrint[0] ;

	}
	
	fwrite(&val,sizeof(val),1,calcRsqr3d) ;
	
      }
    }
  }
  
}



void calcEHcycle(void)
{
  int wre,wim,yre,yim ;
  double val ;

  FILE *EHcycle ;

  EHcycle = fopen("EHcycle","w") ; 

  cout << "EH intrinsic sphere geom" << endl ;

  for(yre=2;yre<NY1+2;yre++) {
    for(yim=2;yim<NY1+2;yim++) {

      wre = 2 ; wim = 2 ;

      if(abs(coord_y1(yre,yim))<=MAXY) {

	calcKderiv1point(wre,wim,yre,yim) ;
	val = valarr[1] ;

      } else {

	val = 0. ;

      }
      
      fwrite(&val,sizeof(val),1,EHcycle) ;
      
    }
  }
  
}





void calcToruscycle(void)
{
  int z1re,z1im,z2re,z2im ;
  complex<double> z1, z2, w, y ;
  double val ;

  FILE *Toruscycle ;

  Toruscycle = fopen("Toruscycle","w") ; 

  cout << "Torus intrinsic sphere geom" << endl ;

  for(z1re=2;z1re<NZ+2;z1re++) {
    for(z1im=2;z1im<NZ+2;z1im++) {

      z2re = 2 ; z2im = 2 ;

      z1 = coord_z1(z1re,z1im) ; z2 = coord_z2(z2re,z2im) ; 

      if( pow(abs(z1),2) + pow(abs(z2),2) >= TRANSSIG ) {
	
	calcKderiv2point(z1re,z1im,z2re,z2im) ;
	
	val = valarr[2] ;
	
      } else {

	/* Note: z2 = 0. so looking at w plane at y = 0. */

	  w = z1*z1/2. ;

	  y = 0. ;

	  calcK1interp(w,y) ;

	  val = valarrint[2] ;

      }

      fwrite(&val,sizeof(val),1,Toruscycle) ;
      
    }
  }
  
}





void calcK1interp(complex<double> w, complex<double> y)
{
  complex<double> latw, laty ;

  int wdashre, wdashim, ydashre, ydashim ;
  int tmpwre, tmpwim, tmpyre, tmpyim ;
  
  int i1, i2, i3, i4, k1 ;
  double val2 ;

  double x, frc[4], mult[4][4] ;


  latw = lat_w1(w,y) ;
  laty = lat_y1(w,y) ;

  wdashre = (int) floor(latw.real()) ;
  wdashim = (int) floor(latw.imag()) ;

  ydashre = (int) floor(laty.real()) ;
  ydashim = (int) floor(laty.imag()) ;

  frc[0] = latw.real() - ((double) wdashre) ;
  frc[1] = latw.imag() - ((double) wdashim) ;

  frc[2] = laty.real() - ((double) ydashre) ;
  frc[3] = laty.imag() - ((double) ydashim) ;

  for(i1=0;i1<4;i1++) {
 
    x = frc[i1] ;

    /* 1st Order */
    mult[i1][0] = 0. ;
    mult[i1][1] = 1.-x ;
    mult[i1][2] = x ;
    mult[i1][3] = 0 ;

  }

  for(k1=0;k1<3;k1++) valarrint[k1] = 0. ;
  
  for(i1=-1;i1<=2;i1++) {
    for(i2=-1;i2<=2;i2++) {
      for(i3=-1;i3<=2;i3++) {
	for(i4=-1;i4<=2;i4++) {

	  val2 = 1. ;
	  
	  switch(i1) {
	    
	  case(-1) : val2 *= mult[0][0] ; break ;
	    
	  case(0) : val2 *= mult[0][1] ; break ;
	    
	  case(1) : val2 *= mult[0][2] ; break ;
	    
	  case(2) : val2 *= mult[0][3] ; break ;

	  default : cout << "Terrible error!" << endl ; exit(1) ;

	  }

	  switch(i2) {
	    
	  case(-1) : val2 *= mult[1][0] ; break ;
	    
	  case(0) : val2 *= mult[1][1] ; break ;
	    
	  case(1) : val2 *= mult[1][2] ; break ;
	    
	  case(2) : val2 *= mult[1][3] ; break ;

	  default : cout << "Terrible error!" << endl ; exit(1) ;

	  }

	  switch(i3) {
	    
	  case(-1) : val2 *= mult[2][0] ; break ;
	    
	  case(0) : val2 *= mult[2][1] ; break ;
	    
	  case(1) : val2 *= mult[2][2] ; break ;
	    
	  case(2) : val2 *= mult[2][3] ; break ;

	  default : cout << "Terrible error!" << endl ; exit(1) ;

	  }

	  switch(i4) {
	    
	  case(-1) : val2 *= mult[3][0] ; break ;
	    
	  case(0) : val2 *= mult[3][1] ; break ;
	    
	  case(1) : val2 *= mult[3][2] ; break ;
	    
	  case(2) : val2 *= mult[3][3] ; break ;

	  default : cout << "Terrible error!" << endl ; exit(1) ;

	  }

	  tmpwre = wdashre+i1 ;
	  tmpwim = wdashim+i2 ;

	  tmpyre = ydashre+i3 ;
	  tmpyim = ydashim+i4 ;

	  iboundaryWY(&tmpwre,&tmpwim,&tmpyre,&tmpyim) ;

	  if(val2!=0.) {

	    calcKderiv1point(tmpwre,tmpwim,tmpyre,tmpyim) ;

	    for(k1=0;k1<3;k1++) valarrint[k1] += val2*valarr[k1] ;

	    if(tempK1[pos1(tmpwre,tmpwim,tmpyre,tmpyim)]==-1) {
	      cout << "Terrible error!" << endl ;
	    }

	  }

	}
      }
    }
  }
  

}


void calcK2interp(complex<double> z1, complex<double> z2)
{
  complex<double> latz1, latz2 ;
  
  int z1dashre, z1dashim, z2dashre, z2dashim ;
  int tmpz1re, tmpz1im, tmpz2re, tmpz2im ;

  int i1, i2, i3, i4, k1 ;
  double val2 ;

  double x, frc[4], mult[4][4] ;

  latz1 = lat_z1(z1) ;
  latz2 = lat_z2(z2) ;

  z1dashre = (int) floor(latz1.real()) ;
  z1dashim = (int) floor(latz1.imag()) ;

  z2dashre = (int) floor(latz2.real()) ;
  z2dashim = (int) floor(latz2.imag()) ;

  frc[0] = latz1.real() - ((double) z1dashre) ;
  frc[1] = latz1.imag() - ((double) z1dashim) ;

  frc[2] = latz2.real() - ((double) z2dashre) ;
  frc[3] = latz2.imag() - ((double) z2dashim) ;

  for(i1=0;i1<4;i1++) {
 
    x = frc[i1] ;

    /* 1st Order */
    mult[i1][0] = 0 ;
    mult[i1][1] = 1.-x ;
    mult[i1][2] = x ;
    mult[i1][3] = 0 ;

  }

  for(k1=0;k1<3;k1++) valarrint[k1] = 0. ;

  for(i1=-1;i1<=2;i1++) {
    for(i2=-1;i2<=2;i2++) {
      for(i3=-1;i3<=2;i3++) {
	for(i4=-1;i4<=2;i4++) {

	  val2 = 1. ;
	  
	  switch(i1) {
	  case(-1) : val2 *= mult[0][0] ; break ;
	  case(0) : val2 *= mult[0][1] ; break ;
	  case(1) : val2 *= mult[0][2] ; break ;
	  case(2) : val2 *= mult[0][3] ; break ;
	  }

	  switch(i2) {
	  case(-1) : val2 *= mult[1][0] ; break ;
	  case(0) : val2 *= mult[1][1] ; break ;
	  case(1) : val2 *= mult[1][2] ; break ;
	  case(2) : val2 *= mult[1][3] ; break ;
	  }

	  switch(i3) {
	  case(-1) : val2 *= mult[2][0] ; break ;
	  case(0) : val2 *= mult[2][1] ; break ;
	  case(1) : val2 *= mult[2][2] ; break ;
	  case(2) : val2 *= mult[2][3] ; break ;
	  }

	  switch(i4) {
	  case(-1) : val2 *= mult[3][0] ; break ;
	  case(0) : val2 *= mult[3][1] ; break ;
	  case(1) : val2 *= mult[3][2] ; break ;
	  case(2) : val2 *= mult[3][3] ; break ;
	  }
	  
	  tmpz1re = z1dashre+i1 ;
	  tmpz1im = z1dashim+i2 ;

	  tmpz2re = z2dashre+i3 ;
	  tmpz2im = z2dashim+i4 ;

	  iboundaryZ(&tmpz1re,&tmpz1im) ;
	  iboundaryZ(&tmpz2re,&tmpz2im) ;
	  reflectZ(&tmpz1re,&tmpz1im,&tmpz2re,&tmpz2im) ;

	  if(val2!=0.) {

	    calcKderiv2point(tmpz1re,tmpz1im,tmpz2re,tmpz2im) ;

	    for(k1=0;k1<3;k1++) valarrint[k1] += val2*valarr[k1] ;

	    if( tempK2[K2pos[pos2(tmpz1re,tmpz1im,tmpz2re)]+tmpz2im]==-1) {
	      cout << "Terrible error!" << endl ;
	    }

	  }
 
	}
      }
    }
  }
  

}



void calcKderiv1point(int wre, int wim, int yre, int yim)
{

  double val1100r, val0011r, val0110r, val1011r, val1110r, val1002r, val0012r, val2001r, val2100r ;
  double val1100i, val0011i, val0110i, val1011i, val1110i, val1002i, val0012i, val2001i, val2100i ;

  double val3001r, val3100r, val1003r, val0031r, val2200r, val0022r, val0220r, val2110r, val2101r, val1021r, val0121r, val2011r, val1120r, val1111r ;
  double val3001i, val3100i, val1003i, val0031i, val2200i, val0022i, val0220i, val2110i, val2101i, val1021i, val0121i, val2011i, val1120i, val1111i ;

  double DW = DW1, DY = DY1, DW2 = DW1*DW1, DY2 = DY1*DY1 ;

  complex<double> K1100, K0011, K0110, K1011, K1110, K1002, K0012, K2001, K2100 ;
  complex<double> K1100c, K0011c, K0110c, K1011c, K1110c, K1002c, K0012c, K2001c, K2100c ;
  complex<double> K3001, K3100, K1003, K0031, K2200, K0022, K0220, K2110, K2101, K1021, K0121, K2011, K1120, K1111 ;
  complex<double> K3001c, K3100c, K1003c, K0031c, K2200c, K0022c, K0220c, K2110c, K2101c, K1021c, K0121c, K2011c, K1120c, K1111c ;

  complex<double> Rww, Ryy, Rwy ;

  complex<double> Rwwww, Rwwwy, Rwwyw, Rwwyy, Rwyww, Rwywy, Rwyyw, Rwyyy, Rywww, Rywwy, Rywyw, Rywyy, Ryyww, Ryywy, Ryyyw, Ryyyy ;

  complex<double> Kretch ;

  complex<double> R2dyy, R2dww ;


  int i1,i2,i3,i4 ;
  


  if( abs(coord_y1(yre,yim)) > MAXY || ( 2.*abs(coord_w1(wre,wim))*(1.+abs(coord_y1(yre,yim))*abs(coord_y1(yre,yim))) > MAXSIG ) )  {
	    
	    val1100r = 0. ; 
	    val0011r = 0. ; 
	    val0110r = 0. ; 
	    val1011r = 0. ; 
	    val1110r = 0. ; 
	    val1002r = 0. ; 
	    val0012r = 0. ; 
	    val2001r = 0. ; 
	    val2100r = 0. ;
	    val3001r = 0. ; 
	    val3100r = 0. ; 
	    val1003r = 0. ; 
	    val0031r = 0. ; 
	    val2200r = 0. ; 
	    val0022r = 0. ; 
	    val0220r = 0. ; 
	    val2110r = 0. ; 
	    val2101r = 0. ; 
	    val1021r = 0. ; 
	    val0121r = 0. ; 
	    val2011r = 0. ; 
	    val1120r = 0. ; 
	    val1111r = 0. ;

	    val1100i = 0. ; 
	    val0011i = 0. ; 
	    val0110i = 0. ; 
	    val1011i = 0. ; 
	    val1110i = 0. ; 
	    val1002i = 0. ; 
	    val0012i = 0. ; 
	    val2001i = 0. ; 
	    val2100i = 0. ;
	    val3001i = 0. ; 
	    val3100i = 0. ; 
	    val1003i = 0. ; 
	    val0031i = 0. ; 
	    val2200i = 0. ; 
	    val0022i = 0. ; 
	    val0220i = 0. ; 
	    val2110i = 0. ; 
	    val2101i = 0. ; 
	    val1021i = 0. ; 
	    val0121i = 0. ; 
	    val2011i = 0. ; 
	    val1120i = 0. ; 
	    val1111i = 0. ;

	  } else {

	    for(i1=0;i1<5;i1++) {
	      for(i2=0;i2<5;i2++) {
		for(i3=0;i3<5;i3++) {
		  for(i4=0;i4<5;i4++) {
		
		    B[i1][i2][i3][i4] = getK1(wre+i1-2,wim+i2-2,yre+i3-2,yim+i4-2) ;
    
		  }
		}
	      }
	    }

	    val1100r = 1./(DW2)*(-B[0][2][2][2] + 16*B[1][2][2][2] - B[2][0][2][2] + 16*B[2][1][2][2] - 60*B[2][2][2][2] + 16*B[2][3][2][2] - B[2][4][2][2] + 16*B[3][2][2][2] - B[4][2][2][2])/48. ; 
	    val0011r = 1./(DY2)*(-B[2][2][0][2] + 16*B[2][2][1][2] - B[2][2][2][0] + 16*B[2][2][2][1] - 60*B[2][2][2][2] + 16*B[2][2][2][3] - B[2][2][2][4] + 16*B[2][2][3][2] - B[2][2][4][2])/48. ; 
	    val0110r = 1./(DW*DY)*(B[0][2][0][2] - 8*B[0][2][1][2] + 8*B[0][2][3][2] - B[0][2][4][2] - 8*B[1][2][0][2] + 64*B[1][2][1][2] - 64*B[1][2][3][2] + 8*B[1][2][4][2] + B[2][0][2][0] - 8*B[2][0][2][1] + 8*B[2][0][2][3] - 
     B[2][0][2][4] - 8*B[2][1][2][0] + 64*B[2][1][2][1] - 64*B[2][1][2][3] + 8*B[2][1][2][4] + 8*B[2][3][2][0] - 64*B[2][3][2][1] + 64*B[2][3][2][3] - 8*B[2][3][2][4] - B[2][4][2][0] + 
     8*B[2][4][2][1] - 8*B[2][4][2][3] + B[2][4][2][4] + 8*B[3][2][0][2] - 64*B[3][2][1][2] + 64*B[3][2][3][2] - 8*B[3][2][4][2] - B[4][2][0][2] + 8*B[4][2][1][2] - 8*B[4][2][3][2] + 
     B[4][2][4][2])/576. ; 
	    val1011r = 1./(DW*DY2)*(-B[0][2][0][2] + 16*B[0][2][1][2] - B[0][2][2][0] + 16*B[0][2][2][1] - 60*B[0][2][2][2] + 16*B[0][2][2][3] - B[0][2][2][4] + 16*B[0][2][3][2] - B[0][2][4][2] + 8*B[1][2][0][2] - 
     128*B[1][2][1][2] + 8*B[1][2][2][0] - 128*B[1][2][2][1] + 480*B[1][2][2][2] - 128*B[1][2][2][3] + 8*B[1][2][2][4] - 128*B[1][2][3][2] + 8*B[1][2][4][2] - 8*B[3][2][0][2] + 
     128*B[3][2][1][2] - 8*B[3][2][2][0] + 128*B[3][2][2][1] - 480*B[3][2][2][2] + 128*B[3][2][2][3] - 8*B[3][2][2][4] + 128*B[3][2][3][2] - 8*B[3][2][4][2] + B[4][2][0][2] - 
     16*B[4][2][1][2] + B[4][2][2][0] - 16*B[4][2][2][1] + 60*B[4][2][2][2] - 16*B[4][2][2][3] + B[4][2][2][4] - 16*B[4][2][3][2] + B[4][2][4][2])/1152. ; 
	    val1110r = 1./(DW2*DY)*(-B[0][2][0][2] + 8*B[0][2][1][2] - 8*B[0][2][3][2] + B[0][2][4][2] + 16*B[1][2][0][2] - 128*B[1][2][1][2] + 128*B[1][2][3][2] - 16*B[1][2][4][2] - B[2][0][0][2] + 8*B[2][0][1][2] - 
     8*B[2][0][3][2] + B[2][0][4][2] + 16*B[2][1][0][2] - 128*B[2][1][1][2] + 128*B[2][1][3][2] - 16*B[2][1][4][2] - 60*B[2][2][0][2] + 480*B[2][2][1][2] - 480*B[2][2][3][2] + 
     60*B[2][2][4][2] + 16*B[2][3][0][2] - 128*B[2][3][1][2] + 128*B[2][3][3][2] - 16*B[2][3][4][2] - B[2][4][0][2] + 8*B[2][4][1][2] - 8*B[2][4][3][2] + B[2][4][4][2] + 16*B[3][2][0][2] - 
     128*B[3][2][1][2] + 128*B[3][2][3][2] - 16*B[3][2][4][2] - B[4][2][0][2] + 8*B[4][2][1][2] - 8*B[4][2][3][2] + B[4][2][4][2])/1152. ; 
	    val1002r = 1./(DW*DY2)*(-6*B[0][2][0][2] + 96*B[0][2][1][2] + 6*B[0][2][2][0] - 96*B[0][2][2][1] - 96*B[0][2][2][3] + 6*B[0][2][2][4] + 96*B[0][2][3][2] - 6*B[0][2][4][2] + 48*B[1][2][0][2] - 768*B[1][2][1][2] - 
     48*B[1][2][2][0] + 768*B[1][2][2][1] + 768*B[1][2][2][3] - 48*B[1][2][2][4] - 768*B[1][2][3][2] + 48*B[1][2][4][2] + B[2][0][0][0] - 8*B[2][0][0][1] + 8*B[2][0][0][3] - B[2][0][0][4] - 
     8*B[2][0][1][0] + 64*B[2][0][1][1] - 64*B[2][0][1][3] + 8*B[2][0][1][4] + 8*B[2][0][3][0] - 64*B[2][0][3][1] + 64*B[2][0][3][3] - 8*B[2][0][3][4] - B[2][0][4][0] + 8*B[2][0][4][1] - 
     8*B[2][0][4][3] + B[2][0][4][4] - 8*B[2][1][0][0] + 64*B[2][1][0][1] - 64*B[2][1][0][3] + 8*B[2][1][0][4] + 64*B[2][1][1][0] - 512*B[2][1][1][1] + 512*B[2][1][1][3] - 64*B[2][1][1][4] - 
     64*B[2][1][3][0] + 512*B[2][1][3][1] - 512*B[2][1][3][3] + 64*B[2][1][3][4] + 8*B[2][1][4][0] - 64*B[2][1][4][1] + 64*B[2][1][4][3] - 8*B[2][1][4][4] + 8*B[2][3][0][0] - 
     64*B[2][3][0][1] + 64*B[2][3][0][3] - 8*B[2][3][0][4] - 64*B[2][3][1][0] + 512*B[2][3][1][1] - 512*B[2][3][1][3] + 64*B[2][3][1][4] + 64*B[2][3][3][0] - 512*B[2][3][3][1] + 
     512*B[2][3][3][3] - 64*B[2][3][3][4] - 8*B[2][3][4][0] + 64*B[2][3][4][1] - 64*B[2][3][4][3] + 8*B[2][3][4][4] - B[2][4][0][0] + 8*B[2][4][0][1] - 8*B[2][4][0][3] + B[2][4][0][4] + 
     8*B[2][4][1][0] - 64*B[2][4][1][1] + 64*B[2][4][1][3] - 8*B[2][4][1][4] - 8*B[2][4][3][0] + 64*B[2][4][3][1] - 64*B[2][4][3][3] + 8*B[2][4][3][4] + B[2][4][4][0] - 8*B[2][4][4][1] + 
     8*B[2][4][4][3] - B[2][4][4][4] - 6*(8*B[3][2][0][2] - 128*B[3][2][1][2] - 8*B[3][2][2][0] + 128*B[3][2][2][1] + 128*B[3][2][2][3] - 8*B[3][2][2][4] - 128*B[3][2][3][2] + 
        8*B[3][2][4][2] - B[4][2][0][2] + 16*B[4][2][1][2] + B[4][2][2][0] - 16*B[4][2][2][1] - 16*B[4][2][2][3] + B[4][2][2][4] + 16*B[4][2][3][2] - B[4][2][4][2]))/6912. ; 
	    val0012r = 1./(DY*DY2)*(-B[2][2][0][0] + 16*B[2][2][0][1] - 102*B[2][2][0][2] + 16*B[2][2][0][3] - B[2][2][0][4] + 8*B[2][2][1][0] - 128*B[2][2][1][1] + 384*B[2][2][1][2] - 128*B[2][2][1][3] + 8*B[2][2][1][4] - 
     8*B[2][2][3][0] + 128*B[2][2][3][1] - 384*B[2][2][3][2] + 128*B[2][2][3][3] - 8*B[2][2][3][4] + B[2][2][4][0] - 16*B[2][2][4][1] + 102*B[2][2][4][2] - 16*B[2][2][4][3] + B[2][2][4][4])/
   1152. ; 
	    val2001r = 1./(DW2*DY)*(B[0][0][2][0] - 8*B[0][0][2][1] + 8*B[0][0][2][3] - B[0][0][2][4] - 8*B[0][1][2][0] + 64*B[0][1][2][1] - 64*B[0][1][2][3] + 8*B[0][1][2][4] - 6*B[0][2][0][2] + 48*B[0][2][1][2] - 
     48*B[0][2][3][2] + 6*B[0][2][4][2] + 8*B[0][3][2][0] - 64*B[0][3][2][1] + 64*B[0][3][2][3] - 8*B[0][3][2][4] - B[0][4][2][0] + 8*B[0][4][2][1] - 8*B[0][4][2][3] + B[0][4][2][4] - 
     8*B[1][0][2][0] + 64*B[1][0][2][1] - 64*B[1][0][2][3] + 8*B[1][0][2][4] + 64*B[1][1][2][0] - 512*B[1][1][2][1] + 512*B[1][1][2][3] - 64*B[1][1][2][4] + 96*B[1][2][0][2] - 
     768*B[1][2][1][2] + 768*B[1][2][3][2] - 96*B[1][2][4][2] - 64*B[1][3][2][0] + 512*B[1][3][2][1] - 512*B[1][3][2][3] + 64*B[1][3][2][4] + 8*B[1][4][2][0] - 64*B[1][4][2][1] + 
     64*B[1][4][2][3] - 8*B[1][4][2][4] + 6*B[2][0][0][2] - 48*B[2][0][1][2] + 48*B[2][0][3][2] - 6*B[2][0][4][2] - 96*B[2][1][0][2] + 768*B[2][1][1][2] - 768*B[2][1][3][2] + 
     96*B[2][1][4][2] - 96*B[2][3][0][2] + 768*B[2][3][1][2] - 768*B[2][3][3][2] + 96*B[2][3][4][2] + 6*B[2][4][0][2] - 48*B[2][4][1][2] + 48*B[2][4][3][2] - 6*B[2][4][4][2] + 
     8*B[3][0][2][0] - 64*B[3][0][2][1] + 64*B[3][0][2][3] - 8*B[3][0][2][4] - 64*B[3][1][2][0] + 512*B[3][1][2][1] - 512*B[3][1][2][3] + 64*B[3][1][2][4] + 96*B[3][2][0][2] - 
     768*B[3][2][1][2] + 768*B[3][2][3][2] - 96*B[3][2][4][2] + 64*B[3][3][2][0] - 512*B[3][3][2][1] + 512*B[3][3][2][3] - 64*B[3][3][2][4] - 8*B[3][4][2][0] + 64*B[3][4][2][1] - 
     64*B[3][4][2][3] + 8*B[3][4][2][4] - B[4][0][2][0] + 8*B[4][0][2][1] - 8*B[4][0][2][3] + B[4][0][2][4] + 8*B[4][1][2][0] - 64*B[4][1][2][1] + 64*B[4][1][2][3] - 8*B[4][1][2][4] - 
     6*B[4][2][0][2] + 48*B[4][2][1][2] - 48*B[4][2][3][2] + 6*B[4][2][4][2] - 8*B[4][3][2][0] + 64*B[4][3][2][1] - 64*B[4][3][2][3] + 8*B[4][3][2][4] + B[4][4][2][0] - 8*B[4][4][2][1] + 
     8*B[4][4][2][3] - B[4][4][2][4])/6912. ; 
	    val2100r = 1./(DW2*DW)*(-B[0][0][2][2] + 16*B[0][1][2][2] - 102*B[0][2][2][2] + 16*B[0][3][2][2] - B[0][4][2][2] + 8*B[1][0][2][2] - 128*B[1][1][2][2] + 384*B[1][2][2][2] - 128*B[1][3][2][2] + 8*B[1][4][2][2] - 
     8*B[3][0][2][2] + 128*B[3][1][2][2] - 384*B[3][2][2][2] + 128*B[3][3][2][2] - 8*B[3][4][2][2] + B[4][0][2][2] - 16*B[4][1][2][2] + 102*B[4][2][2][2] - 16*B[4][3][2][2] + B[4][4][2][2])/
   1152. ;
	    val3001r = 1./(DW2*DW*DY)*(B[0][0][0][2] - 8*B[0][0][1][2] - B[0][0][2][0] + 8*B[0][0][2][1] - 8*B[0][0][2][3] + B[0][0][2][4] + 8*B[0][0][3][2] - B[0][0][4][2] - 16*B[0][1][0][2] + 128*B[0][1][1][2] + 8*B[0][1][2][0] - 
     64*B[0][1][2][1] + 64*B[0][1][2][3] - 8*B[0][1][2][4] - 128*B[0][1][3][2] + 16*B[0][1][4][2] + 6*B[0][2][0][2] - 48*B[0][2][1][2] + 48*B[0][2][3][2] - 6*B[0][2][4][2] - 
     16*B[0][3][0][2] + 128*B[0][3][1][2] - 8*B[0][3][2][0] + 64*B[0][3][2][1] - 64*B[0][3][2][3] + 8*B[0][3][2][4] - 128*B[0][3][3][2] + 16*B[0][3][4][2] + B[0][4][0][2] - 8*B[0][4][1][2] + 
     B[0][4][2][0] - 8*B[0][4][2][1] + 8*B[0][4][2][3] - B[0][4][2][4] + 8*B[0][4][3][2] - B[0][4][4][2] - 8*B[1][0][0][2] + 64*B[1][0][1][2] + 16*B[1][0][2][0] - 128*B[1][0][2][1] + 
     128*B[1][0][2][3] - 16*B[1][0][2][4] - 64*B[1][0][3][2] + 8*B[1][0][4][2] + 128*B[1][1][0][2] - 1024*B[1][1][1][2] - 128*B[1][1][2][0] + 1024*B[1][1][2][1] - 1024*B[1][1][2][3] + 
     128*B[1][1][2][4] + 1024*B[1][1][3][2] - 128*B[1][1][4][2] - 192*B[1][2][0][2] + 1536*B[1][2][1][2] - 1536*B[1][2][3][2] + 192*B[1][2][4][2] + 128*B[1][3][0][2] - 1024*B[1][3][1][2] + 
     128*B[1][3][2][0] - 1024*B[1][3][2][1] + 1024*B[1][3][2][3] - 128*B[1][3][2][4] + 1024*B[1][3][3][2] - 128*B[1][3][4][2] - 8*B[1][4][0][2] + 64*B[1][4][1][2] - 16*B[1][4][2][0] + 
     128*B[1][4][2][1] - 128*B[1][4][2][3] + 16*B[1][4][2][4] - 64*B[1][4][3][2] + 8*B[1][4][4][2] - 6*B[2][0][2][0] + 48*B[2][0][2][1] - 48*B[2][0][2][3] + 6*B[2][0][2][4] + 
     192*B[2][1][2][0] - 1536*B[2][1][2][1] + 1536*B[2][1][2][3] - 192*B[2][1][2][4] - 192*B[2][3][2][0] + 1536*B[2][3][2][1] - 1536*B[2][3][2][3] + 192*B[2][3][2][4] + 6*B[2][4][2][0] - 
     48*B[2][4][2][1] + 48*B[2][4][2][3] - 6*B[2][4][2][4] + 8*B[3][0][0][2] - 64*B[3][0][1][2] + 16*B[3][0][2][0] - 128*B[3][0][2][1] + 128*B[3][0][2][3] - 16*B[3][0][2][4] + 
     64*B[3][0][3][2] - 8*B[3][0][4][2] - 128*B[3][1][0][2] + 1024*B[3][1][1][2] - 128*B[3][1][2][0] + 1024*B[3][1][2][1] - 1024*B[3][1][2][3] + 128*B[3][1][2][4] - 1024*B[3][1][3][2] + 
     128*B[3][1][4][2] + 192*B[3][2][0][2] - 1536*B[3][2][1][2] + 1536*B[3][2][3][2] - 192*B[3][2][4][2] - 128*B[3][3][0][2] + 1024*B[3][3][1][2] + 128*B[3][3][2][0] - 1024*B[3][3][2][1] + 
     1024*B[3][3][2][3] - 128*B[3][3][2][4] - 1024*B[3][3][3][2] + 128*B[3][3][4][2] + 8*B[3][4][0][2] - 64*B[3][4][1][2] - 16*B[3][4][2][0] + 128*B[3][4][2][1] - 128*B[3][4][2][3] + 
     16*B[3][4][2][4] + 64*B[3][4][3][2] - 8*B[3][4][4][2] - B[4][0][0][2] + 8*B[4][0][1][2] - B[4][0][2][0] + 8*B[4][0][2][1] - 8*B[4][0][2][3] + B[4][0][2][4] - 8*B[4][0][3][2] + 
     B[4][0][4][2] + 16*B[4][1][0][2] - 128*B[4][1][1][2] + 8*B[4][1][2][0] - 64*B[4][1][2][1] + 64*B[4][1][2][3] - 8*B[4][1][2][4] + 128*B[4][1][3][2] - 16*B[4][1][4][2] - 6*B[4][2][0][2] + 
     48*B[4][2][1][2] - 48*B[4][2][3][2] + 6*B[4][2][4][2] + 16*B[4][3][0][2] - 128*B[4][3][1][2] - 8*B[4][3][2][0] + 64*B[4][3][2][1] - 64*B[4][3][2][3] + 8*B[4][3][2][4] + 
     128*B[4][3][3][2] - 16*B[4][3][4][2] - B[4][4][0][2] + 8*B[4][4][1][2] + B[4][4][2][0] - 8*B[4][4][2][1] + 8*B[4][4][2][3] - B[4][4][2][4] - 8*B[4][4][3][2] + B[4][4][4][2])/9216. ; 
	    val3100r = 1./(DW2*DW2)*(B[0][2][2][2] - 4*B[1][2][2][2] - B[2][0][2][2] + 4*B[2][1][2][2] + 4*B[2][3][2][2] - B[2][4][2][2] - 4*B[3][2][2][2] + B[4][2][2][2])/16. ; 
	    val1003r = 1./(DW*DY2*DY)*(B[0][2][0][0] - 16*B[0][2][0][1] + 6*B[0][2][0][2] - 16*B[0][2][0][3] + B[0][2][0][4] - 8*B[0][2][1][0] + 128*B[0][2][1][1] - 192*B[0][2][1][2] + 128*B[0][2][1][3] - 8*B[0][2][1][4] + 
     8*B[0][2][3][0] - 128*B[0][2][3][1] + 192*B[0][2][3][2] - 128*B[0][2][3][3] + 8*B[0][2][3][4] - B[0][2][4][0] + 16*B[0][2][4][1] - 6*B[0][2][4][2] + 16*B[0][2][4][3] - B[0][2][4][4] - 
     8*B[1][2][0][0] + 128*B[1][2][0][1] - 48*B[1][2][0][2] + 128*B[1][2][0][3] - 8*B[1][2][0][4] + 64*B[1][2][1][0] - 1024*B[1][2][1][1] + 1536*B[1][2][1][2] - 1024*B[1][2][1][3] + 
     64*B[1][2][1][4] - 64*B[1][2][3][0] + 1024*B[1][2][3][1] - 1536*B[1][2][3][2] + 1024*B[1][2][3][3] - 64*B[1][2][3][4] + 8*B[1][2][4][0] - 128*B[1][2][4][1] + 48*B[1][2][4][2] - 
     128*B[1][2][4][3] + 8*B[1][2][4][4] - B[2][0][0][0] + 8*B[2][0][0][1] - 8*B[2][0][0][3] + B[2][0][0][4] + 16*B[2][0][1][0] - 128*B[2][0][1][1] + 128*B[2][0][1][3] - 16*B[2][0][1][4] - 
     6*B[2][0][2][0] + 192*B[2][0][2][1] - 192*B[2][0][2][3] + 6*B[2][0][2][4] + 16*B[2][0][3][0] - 128*B[2][0][3][1] + 128*B[2][0][3][3] - 16*B[2][0][3][4] - B[2][0][4][0] + 
     8*B[2][0][4][1] - 8*B[2][0][4][3] + B[2][0][4][4] + 8*B[2][1][0][0] - 64*B[2][1][0][1] + 64*B[2][1][0][3] - 8*B[2][1][0][4] - 128*B[2][1][1][0] + 1024*B[2][1][1][1] - 
     1024*B[2][1][1][3] + 128*B[2][1][1][4] + 48*B[2][1][2][0] - 1536*B[2][1][2][1] + 1536*B[2][1][2][3] - 48*B[2][1][2][4] - 128*B[2][1][3][0] + 1024*B[2][1][3][1] - 1024*B[2][1][3][3] + 
     128*B[2][1][3][4] + 8*B[2][1][4][0] - 64*B[2][1][4][1] + 64*B[2][1][4][3] - 8*B[2][1][4][4] - 8*B[2][3][0][0] + 64*B[2][3][0][1] - 64*B[2][3][0][3] + 8*B[2][3][0][4] + 
     128*B[2][3][1][0] - 1024*B[2][3][1][1] + 1024*B[2][3][1][3] - 128*B[2][3][1][4] - 48*B[2][3][2][0] + 1536*B[2][3][2][1] - 1536*B[2][3][2][3] + 48*B[2][3][2][4] + 128*B[2][3][3][0] - 
     1024*B[2][3][3][1] + 1024*B[2][3][3][3] - 128*B[2][3][3][4] - 8*B[2][3][4][0] + 64*B[2][3][4][1] - 64*B[2][3][4][3] + 8*B[2][3][4][4] + B[2][4][0][0] - 8*B[2][4][0][1] + 
     8*B[2][4][0][3] - B[2][4][0][4] - 16*B[2][4][1][0] + 128*B[2][4][1][1] - 128*B[2][4][1][3] + 16*B[2][4][1][4] + 6*B[2][4][2][0] - 192*B[2][4][2][1] + 192*B[2][4][2][3] - 
     6*B[2][4][2][4] - 16*B[2][4][3][0] + 128*B[2][4][3][1] - 128*B[2][4][3][3] + 16*B[2][4][3][4] + B[2][4][4][0] - 8*B[2][4][4][1] + 8*B[2][4][4][3] - B[2][4][4][4] + 8*B[3][2][0][0] - 
     128*B[3][2][0][1] + 48*B[3][2][0][2] - 128*B[3][2][0][3] + 8*B[3][2][0][4] - 64*B[3][2][1][0] + 1024*B[3][2][1][1] - 1536*B[3][2][1][2] + 1024*B[3][2][1][3] - 64*B[3][2][1][4] + 
     64*B[3][2][3][0] - 1024*B[3][2][3][1] + 1536*B[3][2][3][2] - 1024*B[3][2][3][3] + 64*B[3][2][3][4] - 8*B[3][2][4][0] + 128*B[3][2][4][1] - 48*B[3][2][4][2] + 128*B[3][2][4][3] - 
     8*B[3][2][4][4] - B[4][2][0][0] + 16*B[4][2][0][1] - 6*B[4][2][0][2] + 16*B[4][2][0][3] - B[4][2][0][4] + 8*B[4][2][1][0] - 128*B[4][2][1][1] + 192*B[4][2][1][2] - 128*B[4][2][1][3] + 
     8*B[4][2][1][4] - 8*B[4][2][3][0] + 128*B[4][2][3][1] - 192*B[4][2][3][2] + 128*B[4][2][3][3] - 8*B[4][2][3][4] + B[4][2][4][0] - 16*B[4][2][4][1] + 6*B[4][2][4][2] - 16*B[4][2][4][3] + 
     B[4][2][4][4])/9216. ; 
	    val0031r = 1./(DY2*DY2)*(B[2][2][0][2] - 4*B[2][2][1][2] - B[2][2][2][0] + 4*B[2][2][2][1] + 4*B[2][2][2][3] - B[2][2][2][4] - 4*B[2][2][3][2] + B[2][2][4][2])/16. ; 
	    val2200r = 1./(DW2*DW2)*(B[0][0][2][2] - 16*B[0][1][2][2] + 102*B[0][2][2][2] - 16*B[0][3][2][2] + B[0][4][2][2] - 16*B[1][0][2][2] + 256*B[1][1][2][2] - 768*B[1][2][2][2] + 256*B[1][3][2][2] - 16*B[1][4][2][2] + 
     102*B[2][0][2][2] - 768*B[2][1][2][2] + 1764*B[2][2][2][2] - 768*B[2][3][2][2] + 102*B[2][4][2][2] - 16*B[3][0][2][2] + 256*B[3][1][2][2] - 768*B[3][2][2][2] + 256*B[3][3][2][2] - 
     16*B[3][4][2][2] + B[4][0][2][2] - 16*B[4][1][2][2] + 102*B[4][2][2][2] - 16*B[4][3][2][2] + B[4][4][2][2])/1152. ; 
	    val0022r = 1./(DY2*DY2)*(B[2][2][0][0] - 16*B[2][2][0][1] + 102*B[2][2][0][2] - 16*B[2][2][0][3] + B[2][2][0][4] - 16*B[2][2][1][0] + 256*B[2][2][1][1] - 768*B[2][2][1][2] + 256*B[2][2][1][3] - 16*B[2][2][1][4] + 
     102*B[2][2][2][0] - 768*B[2][2][2][1] + 1764*B[2][2][2][2] - 768*B[2][2][2][3] + 102*B[2][2][2][4] - 16*B[2][2][3][0] + 256*B[2][2][3][1] - 768*B[2][2][3][2] + 256*B[2][2][3][3] - 
     16*B[2][2][3][4] + B[2][2][4][0] - 16*B[2][2][4][1] + 102*B[2][2][4][2] - 16*B[2][2][4][3] + B[2][2][4][4])/1152. ; 
	    val0220r = 1./(DW2*DY2)*((B[0][0][0][0] - 8*B[0][0][0][1] + 8*B[0][0][0][3] - B[0][0][0][4] - 8*B[0][0][1][0] + 64*B[0][0][1][1] - 64*B[0][0][1][3] + 8*B[0][0][1][4] + 8*B[0][0][3][0] - 64*B[0][0][3][1] + 
     64*B[0][0][3][3] - 8*B[0][0][3][4] - B[0][0][4][0] + 8*B[0][0][4][1] - 8*B[0][0][4][3] + B[0][0][4][4] - 8*B[0][1][0][0] + 64*B[0][1][0][1] - 64*B[0][1][0][3] + 8*B[0][1][0][4] + 
     64*B[0][1][1][0] - 512*B[0][1][1][1] + 512*B[0][1][1][3] - 64*B[0][1][1][4] - 64*B[0][1][3][0] + 512*B[0][1][3][1] - 512*B[0][1][3][3] + 64*B[0][1][3][4] + 8*B[0][1][4][0] - 
     64*B[0][1][4][1] + 64*B[0][1][4][3] - 8*B[0][1][4][4] + 36*B[0][2][0][2] - 576*B[0][2][1][2] - 36*B[0][2][2][0] + 576*B[0][2][2][1] + 576*B[0][2][2][3] - 36*B[0][2][2][4] - 
     576*B[0][2][3][2] + 36*B[0][2][4][2] + 8*B[0][3][0][0] - 64*B[0][3][0][1] + 64*B[0][3][0][3] - 8*B[0][3][0][4] - 64*B[0][3][1][0] + 512*B[0][3][1][1] - 512*B[0][3][1][3] + 
     64*B[0][3][1][4] + 64*B[0][3][3][0] - 512*B[0][3][3][1] + 512*B[0][3][3][3] - 64*B[0][3][3][4] - 8*B[0][3][4][0] + 64*B[0][3][4][1] - 64*B[0][3][4][3] + 8*B[0][3][4][4] - B[0][4][0][0] + 
     8*B[0][4][0][1] - 8*B[0][4][0][3] + B[0][4][0][4] + 8*B[0][4][1][0] - 64*B[0][4][1][1] + 64*B[0][4][1][3] - 8*B[0][4][1][4] - 8*B[0][4][3][0] + 64*B[0][4][3][1] - 64*B[0][4][3][3] + 
     8*B[0][4][3][4] + B[0][4][4][0] - 8*B[0][4][4][1] + 8*B[0][4][4][3] - B[0][4][4][4] - 8*B[1][0][0][0] + 64*B[1][0][0][1] - 64*B[1][0][0][3] + 8*B[1][0][0][4] + 64*B[1][0][1][0] - 
     512*B[1][0][1][1] + 512*B[1][0][1][3] - 64*B[1][0][1][4] - 64*B[1][0][3][0] + 512*B[1][0][3][1] - 512*B[1][0][3][3] + 64*B[1][0][3][4] + 8*B[1][0][4][0] - 64*B[1][0][4][1] + 
     64*B[1][0][4][3] - 8*B[1][0][4][4] + 64*B[1][1][0][0] - 512*B[1][1][0][1] + 512*B[1][1][0][3] - 64*B[1][1][0][4] - 512*B[1][1][1][0] + 4096*B[1][1][1][1] - 4096*B[1][1][1][3] + 
     512*B[1][1][1][4] + 512*B[1][1][3][0] - 4096*B[1][1][3][1] + 4096*B[1][1][3][3] - 512*B[1][1][3][4] - 64*B[1][1][4][0] + 512*B[1][1][4][1] - 512*B[1][1][4][3] + 64*B[1][1][4][4] - 
     576*B[1][2][0][2] + 9216*B[1][2][1][2] + 576*B[1][2][2][0] - 9216*B[1][2][2][1] - 9216*B[1][2][2][3] + 576*B[1][2][2][4] + 9216*B[1][2][3][2] - 576*B[1][2][4][2] - 64*B[1][3][0][0] + 
     512*B[1][3][0][1] - 512*B[1][3][0][3] + 64*B[1][3][0][4] + 512*B[1][3][1][0] - 4096*B[1][3][1][1] + 4096*B[1][3][1][3] - 512*B[1][3][1][4] - 512*B[1][3][3][0] + 4096*B[1][3][3][1] - 
     4096*B[1][3][3][3] + 512*B[1][3][3][4] + 64*B[1][3][4][0] - 512*B[1][3][4][1] + 512*B[1][3][4][3] - 64*B[1][3][4][4] + 8*B[1][4][0][0] - 64*B[1][4][0][1] + 64*B[1][4][0][3] - 
     8*B[1][4][0][4] - 64*B[1][4][1][0] + 512*B[1][4][1][1] - 512*B[1][4][1][3] + 64*B[1][4][1][4] + 64*B[1][4][3][0] - 512*B[1][4][3][1] + 512*B[1][4][3][3] - 64*B[1][4][3][4] - 
     8*B[1][4][4][0] + 64*B[1][4][4][1] - 64*B[1][4][4][3] + 8*B[1][4][4][4] - 36*B[2][0][0][2] + 576*B[2][0][1][2] + 36*B[2][0][2][0] - 576*B[2][0][2][1] - 576*B[2][0][2][3] + 
     36*B[2][0][2][4] + 576*B[2][0][3][2] - 36*B[2][0][4][2] + 576*B[2][1][0][2] - 9216*B[2][1][1][2] - 576*B[2][1][2][0] + 9216*B[2][1][2][1] + 9216*B[2][1][2][3] - 576*B[2][1][2][4] - 
     9216*B[2][1][3][2] + 576*B[2][1][4][2] + 576*B[2][3][0][2] - 9216*B[2][3][1][2] - 576*B[2][3][2][0] + 9216*B[2][3][2][1] + 9216*B[2][3][2][3] - 576*B[2][3][2][4] - 
     9216*B[2][3][3][2] + 576*B[2][3][4][2] - 36*B[2][4][0][2] + 576*B[2][4][1][2] + 36*B[2][4][2][0] - 576*B[2][4][2][1] - 576*B[2][4][2][3] + 36*B[2][4][2][4] + 576*B[2][4][3][2] - 
     36*B[2][4][4][2] + 8*B[3][0][0][0] - 64*B[3][0][0][1] + 64*B[3][0][0][3] - 8*B[3][0][0][4] - 64*B[3][0][1][0] + 512*B[3][0][1][1] - 512*B[3][0][1][3] + 64*B[3][0][1][4] + 
     64*B[3][0][3][0] - 512*B[3][0][3][1] + 512*B[3][0][3][3] - 64*B[3][0][3][4] - 8*B[3][0][4][0] + 64*B[3][0][4][1] - 64*B[3][0][4][3] + 8*B[3][0][4][4] - 64*B[3][1][0][0] + 
     512*B[3][1][0][1] - 512*B[3][1][0][3] + 64*B[3][1][0][4] + 512*B[3][1][1][0] - 4096*B[3][1][1][1] + 4096*B[3][1][1][3] - 512*B[3][1][1][4] - 512*B[3][1][3][0] + 4096*B[3][1][3][1] - 
     4096*B[3][1][3][3] + 512*B[3][1][3][4] + 64*B[3][1][4][0] - 512*B[3][1][4][1] + 512*B[3][1][4][3] - 64*B[3][1][4][4] - 576*B[3][2][0][2] + 9216*B[3][2][1][2] + 576*B[3][2][2][0] - 
     9216*B[3][2][2][1] - 9216*B[3][2][2][3] + 576*B[3][2][2][4] + 9216*B[3][2][3][2] - 576*B[3][2][4][2] + 64*B[3][3][0][0] - 512*B[3][3][0][1] + 512*B[3][3][0][3] - 64*B[3][3][0][4] - 
     512*B[3][3][1][0] + 4096*B[3][3][1][1] - 4096*B[3][3][1][3] + 512*B[3][3][1][4] + 512*B[3][3][3][0] - 4096*B[3][3][3][1] + 4096*B[3][3][3][3] - 512*B[3][3][3][4] - 64*B[3][3][4][0] + 
     512*B[3][3][4][1] - 512*B[3][3][4][3] + 64*B[3][3][4][4] - 8*B[3][4][0][0] + 64*B[3][4][0][1] - 64*B[3][4][0][3] + 8*B[3][4][0][4] + 64*B[3][4][1][0] - 512*B[3][4][1][1] + 
     512*B[3][4][1][3] - 64*B[3][4][1][4] - 64*B[3][4][3][0] + 512*B[3][4][3][1] - 512*B[3][4][3][3] + 64*B[3][4][3][4] + 8*B[3][4][4][0] - 64*B[3][4][4][1] + 64*B[3][4][4][3] - 
     8*B[3][4][4][4] - B[4][0][0][0] + 8*B[4][0][0][1] - 8*B[4][0][0][3] + B[4][0][0][4] + 8*B[4][0][1][0] - 64*B[4][0][1][1] + 64*B[4][0][1][3] - 8*B[4][0][1][4] - 8*B[4][0][3][0] + 
     64*B[4][0][3][1] - 64*B[4][0][3][3] + 8*B[4][0][3][4] + B[4][0][4][0] - 8*B[4][0][4][1] + 8*B[4][0][4][3] - B[4][0][4][4] + 8*B[4][1][0][0] - 64*B[4][1][0][1] + 64*B[4][1][0][3] - 
     8*B[4][1][0][4] - 64*B[4][1][1][0] + 512*B[4][1][1][1] - 512*B[4][1][1][3] + 64*B[4][1][1][4] + 64*B[4][1][3][0] - 512*B[4][1][3][1] + 512*B[4][1][3][3] - 64*B[4][1][3][4] - 
     8*B[4][1][4][0] + 64*B[4][1][4][1] - 64*B[4][1][4][3] + 8*B[4][1][4][4] + 36*B[4][2][0][2] - 576*B[4][2][1][2] - 36*B[4][2][2][0] + 576*B[4][2][2][1] + 576*B[4][2][2][3] - 
     36*B[4][2][2][4] - 576*B[4][2][3][2] + 36*B[4][2][4][2] - 8*B[4][3][0][0] + 64*B[4][3][0][1] - 64*B[4][3][0][3] + 8*B[4][3][0][4] + 64*B[4][3][1][0] - 512*B[4][3][1][1] + 
     512*B[4][3][1][3] - 64*B[4][3][1][4] - 64*B[4][3][3][0] + 512*B[4][3][3][1] - 512*B[4][3][3][3] + 64*B[4][3][3][4] + 8*B[4][3][4][0] - 64*B[4][3][4][1] + 64*B[4][3][4][3] - 
     8*B[4][3][4][4] + B[4][4][0][0] - 8*B[4][4][0][1] + 8*B[4][4][0][3] - B[4][4][0][4] - 8*B[4][4][1][0] + 64*B[4][4][1][1] - 64*B[4][4][1][3] + 8*B[4][4][1][4] + 8*B[4][4][3][0] - 
     64*B[4][4][3][1] + 64*B[4][4][3][3] - 8*B[4][4][3][4] - B[4][4][4][0] + 8*B[4][4][4][1] - 8*B[4][4][4][3] + B[4][4][4][4])/82944.) ; 
	    val2110r = 1./(DW2*DW*DY)*(-B[0][0][0][2] + 8*B[0][0][1][2] + B[0][0][2][0] - 8*B[0][0][2][1] + 8*B[0][0][2][3] - B[0][0][2][4] - 8*B[0][0][3][2] + B[0][0][4][2] + 16*B[0][1][0][2] - 128*B[0][1][1][2] - 8*B[0][1][2][0] + 
     64*B[0][1][2][1] - 64*B[0][1][2][3] + 8*B[0][1][2][4] + 128*B[0][1][3][2] - 16*B[0][1][4][2] - 102*B[0][2][0][2] + 816*B[0][2][1][2] - 816*B[0][2][3][2] + 102*B[0][2][4][2] + 
     16*B[0][3][0][2] - 128*B[0][3][1][2] + 8*B[0][3][2][0] - 64*B[0][3][2][1] + 64*B[0][3][2][3] - 8*B[0][3][2][4] + 128*B[0][3][3][2] - 16*B[0][3][4][2] - B[0][4][0][2] + 8*B[0][4][1][2] - 
     B[0][4][2][0] + 8*B[0][4][2][1] - 8*B[0][4][2][3] + B[0][4][2][4] - 8*B[0][4][3][2] + B[0][4][4][2] + 8*B[1][0][0][2] - 64*B[1][0][1][2] - 16*B[1][0][2][0] + 128*B[1][0][2][1] - 
     128*B[1][0][2][3] + 16*B[1][0][2][4] + 64*B[1][0][3][2] - 8*B[1][0][4][2] - 128*B[1][1][0][2] + 1024*B[1][1][1][2] + 128*B[1][1][2][0] - 1024*B[1][1][2][1] + 1024*B[1][1][2][3] - 
     128*B[1][1][2][4] - 1024*B[1][1][3][2] + 128*B[1][1][4][2] + 384*B[1][2][0][2] - 3072*B[1][2][1][2] + 3072*B[1][2][3][2] - 384*B[1][2][4][2] - 128*B[1][3][0][2] + 1024*B[1][3][1][2] - 
     128*B[1][3][2][0] + 1024*B[1][3][2][1] - 1024*B[1][3][2][3] + 128*B[1][3][2][4] - 1024*B[1][3][3][2] + 128*B[1][3][4][2] + 8*B[1][4][0][2] - 64*B[1][4][1][2] + 16*B[1][4][2][0] - 
     128*B[1][4][2][1] + 128*B[1][4][2][3] - 16*B[1][4][2][4] + 64*B[1][4][3][2] - 8*B[1][4][4][2] + 102*B[2][0][2][0] - 816*B[2][0][2][1] + 816*B[2][0][2][3] - 102*B[2][0][2][4] - 
     384*B[2][1][2][0] + 3072*B[2][1][2][1] - 3072*B[2][1][2][3] + 384*B[2][1][2][4] + 384*B[2][3][2][0] - 3072*B[2][3][2][1] + 3072*B[2][3][2][3] - 384*B[2][3][2][4] - 102*B[2][4][2][0] + 
     816*B[2][4][2][1] - 816*B[2][4][2][3] + 102*B[2][4][2][4] - 8*B[3][0][0][2] + 64*B[3][0][1][2] - 16*B[3][0][2][0] + 128*B[3][0][2][1] - 128*B[3][0][2][3] + 16*B[3][0][2][4] - 
     64*B[3][0][3][2] + 8*B[3][0][4][2] + 128*B[3][1][0][2] - 1024*B[3][1][1][2] + 128*B[3][1][2][0] - 1024*B[3][1][2][1] + 1024*B[3][1][2][3] - 128*B[3][1][2][4] + 1024*B[3][1][3][2] - 
     128*B[3][1][4][2] - 384*B[3][2][0][2] + 3072*B[3][2][1][2] - 3072*B[3][2][3][2] + 384*B[3][2][4][2] + 128*B[3][3][0][2] - 1024*B[3][3][1][2] - 128*B[3][3][2][0] + 1024*B[3][3][2][1] - 
     1024*B[3][3][2][3] + 128*B[3][3][2][4] + 1024*B[3][3][3][2] - 128*B[3][3][4][2] - 8*B[3][4][0][2] + 64*B[3][4][1][2] + 16*B[3][4][2][0] - 128*B[3][4][2][1] + 128*B[3][4][2][3] - 
     16*B[3][4][2][4] - 64*B[3][4][3][2] + 8*B[3][4][4][2] + B[4][0][0][2] - 8*B[4][0][1][2] + B[4][0][2][0] - 8*B[4][0][2][1] + 8*B[4][0][2][3] - B[4][0][2][4] + 8*B[4][0][3][2] - 
     B[4][0][4][2] - 16*B[4][1][0][2] + 128*B[4][1][1][2] - 8*B[4][1][2][0] + 64*B[4][1][2][1] - 64*B[4][1][2][3] + 8*B[4][1][2][4] - 128*B[4][1][3][2] + 16*B[4][1][4][2] + 
     102*B[4][2][0][2] - 816*B[4][2][1][2] + 816*B[4][2][3][2] - 102*B[4][2][4][2] - 16*B[4][3][0][2] + 128*B[4][3][1][2] + 8*B[4][3][2][0] - 64*B[4][3][2][1] + 64*B[4][3][2][3] - 
     8*B[4][3][2][4] - 128*B[4][3][3][2] + 16*B[4][3][4][2] + B[4][4][0][2] - 8*B[4][4][1][2] - B[4][4][2][0] + 8*B[4][4][2][1] - 8*B[4][4][2][3] + B[4][4][2][4] + 8*B[4][4][3][2] - B[4][4][4][2]
     )/27648. ; 
	    val2101r = 1./(DW2*DW*DY)*(-B[0][0][0][2] + 8*B[0][0][1][2] - B[0][0][2][0] + 8*B[0][0][2][1] - 8*B[0][0][2][3] + B[0][0][2][4] - 8*B[0][0][3][2] + B[0][0][4][2] + 16*B[0][1][0][2] - 128*B[0][1][1][2] + 8*B[0][1][2][0] - 
     64*B[0][1][2][1] + 64*B[0][1][2][3] - 8*B[0][1][2][4] + 128*B[0][1][3][2] - 16*B[0][1][4][2] - 102*B[0][2][0][2] + 816*B[0][2][1][2] - 816*B[0][2][3][2] + 102*B[0][2][4][2] + 
     16*B[0][3][0][2] - 128*B[0][3][1][2] - 8*B[0][3][2][0] + 64*B[0][3][2][1] - 64*B[0][3][2][3] + 8*B[0][3][2][4] + 128*B[0][3][3][2] - 16*B[0][3][4][2] - B[0][4][0][2] + 8*B[0][4][1][2] + 
     B[0][4][2][0] - 8*B[0][4][2][1] + 8*B[0][4][2][3] - B[0][4][2][4] - 8*B[0][4][3][2] + B[0][4][4][2] + 8*B[1][0][0][2] - 64*B[1][0][1][2] + 16*B[1][0][2][0] - 128*B[1][0][2][1] + 
     128*B[1][0][2][3] - 16*B[1][0][2][4] + 64*B[1][0][3][2] - 8*B[1][0][4][2] - 128*B[1][1][0][2] + 1024*B[1][1][1][2] - 128*B[1][1][2][0] + 1024*B[1][1][2][1] - 1024*B[1][1][2][3] + 
     128*B[1][1][2][4] - 1024*B[1][1][3][2] + 128*B[1][1][4][2] + 384*B[1][2][0][2] - 3072*B[1][2][1][2] + 3072*B[1][2][3][2] - 384*B[1][2][4][2] - 128*B[1][3][0][2] + 1024*B[1][3][1][2] + 
     128*B[1][3][2][0] - 1024*B[1][3][2][1] + 1024*B[1][3][2][3] - 128*B[1][3][2][4] - 1024*B[1][3][3][2] + 128*B[1][3][4][2] + 8*B[1][4][0][2] - 64*B[1][4][1][2] - 16*B[1][4][2][0] + 
     128*B[1][4][2][1] - 128*B[1][4][2][3] + 16*B[1][4][2][4] + 64*B[1][4][3][2] - 8*B[1][4][4][2] - 102*B[2][0][2][0] + 816*B[2][0][2][1] - 816*B[2][0][2][3] + 102*B[2][0][2][4] + 
     384*B[2][1][2][0] - 3072*B[2][1][2][1] + 3072*B[2][1][2][3] - 384*B[2][1][2][4] - 384*B[2][3][2][0] + 3072*B[2][3][2][1] - 3072*B[2][3][2][3] + 384*B[2][3][2][4] + 102*B[2][4][2][0] - 
     816*B[2][4][2][1] + 816*B[2][4][2][3] - 102*B[2][4][2][4] - 8*B[3][0][0][2] + 64*B[3][0][1][2] + 16*B[3][0][2][0] - 128*B[3][0][2][1] + 128*B[3][0][2][3] - 16*B[3][0][2][4] - 
     64*B[3][0][3][2] + 8*B[3][0][4][2] + 128*B[3][1][0][2] - 1024*B[3][1][1][2] - 128*B[3][1][2][0] + 1024*B[3][1][2][1] - 1024*B[3][1][2][3] + 128*B[3][1][2][4] + 1024*B[3][1][3][2] - 
     128*B[3][1][4][2] - 384*B[3][2][0][2] + 3072*B[3][2][1][2] - 3072*B[3][2][3][2] + 384*B[3][2][4][2] + 128*B[3][3][0][2] - 1024*B[3][3][1][2] + 128*B[3][3][2][0] - 1024*B[3][3][2][1] + 
     1024*B[3][3][2][3] - 128*B[3][3][2][4] + 1024*B[3][3][3][2] - 128*B[3][3][4][2] - 8*B[3][4][0][2] + 64*B[3][4][1][2] - 16*B[3][4][2][0] + 128*B[3][4][2][1] - 128*B[3][4][2][3] + 
     16*B[3][4][2][4] - 64*B[3][4][3][2] + 8*B[3][4][4][2] + B[4][0][0][2] - 8*B[4][0][1][2] - B[4][0][2][0] + 8*B[4][0][2][1] - 8*B[4][0][2][3] + B[4][0][2][4] + 8*B[4][0][3][2] - 
     B[4][0][4][2] - 16*B[4][1][0][2] + 128*B[4][1][1][2] + 8*B[4][1][2][0] - 64*B[4][1][2][1] + 64*B[4][1][2][3] - 8*B[4][1][2][4] - 128*B[4][1][3][2] + 16*B[4][1][4][2] + 
     102*B[4][2][0][2] - 816*B[4][2][1][2] + 816*B[4][2][3][2] - 102*B[4][2][4][2] - 16*B[4][3][0][2] + 128*B[4][3][1][2] - 8*B[4][3][2][0] + 64*B[4][3][2][1] - 64*B[4][3][2][3] + 
     8*B[4][3][2][4] - 128*B[4][3][3][2] + 16*B[4][3][4][2] + B[4][4][0][2] - 8*B[4][4][1][2] + B[4][4][2][0] - 8*B[4][4][2][1] + 8*B[4][4][2][3] - B[4][4][2][4] + 8*B[4][4][3][2] - B[4][4][4][2]
     )/27648. ; 
	    val1021r = 1./(DW*DY2*DY)*(-B[0][2][0][0] + 16*B[0][2][0][1] - 102*B[0][2][0][2] + 16*B[0][2][0][3] - B[0][2][0][4] + 8*B[0][2][1][0] - 128*B[0][2][1][1] + 384*B[0][2][1][2] - 128*B[0][2][1][3] + 8*B[0][2][1][4] - 
     8*B[0][2][3][0] + 128*B[0][2][3][1] - 384*B[0][2][3][2] + 128*B[0][2][3][3] - 8*B[0][2][3][4] + B[0][2][4][0] - 16*B[0][2][4][1] + 102*B[0][2][4][2] - 16*B[0][2][4][3] + B[0][2][4][4] + 
     8*B[1][2][0][0] - 128*B[1][2][0][1] + 816*B[1][2][0][2] - 128*B[1][2][0][3] + 8*B[1][2][0][4] - 64*B[1][2][1][0] + 1024*B[1][2][1][1] - 3072*B[1][2][1][2] + 1024*B[1][2][1][3] - 
     64*B[1][2][1][4] + 64*B[1][2][3][0] - 1024*B[1][2][3][1] + 3072*B[1][2][3][2] - 1024*B[1][2][3][3] + 64*B[1][2][3][4] - 8*B[1][2][4][0] + 128*B[1][2][4][1] - 816*B[1][2][4][2] + 
     128*B[1][2][4][3] - 8*B[1][2][4][4] + B[2][0][0][0] - 8*B[2][0][0][1] + 8*B[2][0][0][3] - B[2][0][0][4] - 16*B[2][0][1][0] + 128*B[2][0][1][1] - 128*B[2][0][1][3] + 16*B[2][0][1][4] + 
     102*B[2][0][2][0] - 384*B[2][0][2][1] + 384*B[2][0][2][3] - 102*B[2][0][2][4] - 16*B[2][0][3][0] + 128*B[2][0][3][1] - 128*B[2][0][3][3] + 16*B[2][0][3][4] + B[2][0][4][0] - 
     8*B[2][0][4][1] + 8*B[2][0][4][3] - B[2][0][4][4] - 8*B[2][1][0][0] + 64*B[2][1][0][1] - 64*B[2][1][0][3] + 8*B[2][1][0][4] + 128*B[2][1][1][0] - 1024*B[2][1][1][1] + 
     1024*B[2][1][1][3] - 128*B[2][1][1][4] - 816*B[2][1][2][0] + 3072*B[2][1][2][1] - 3072*B[2][1][2][3] + 816*B[2][1][2][4] + 128*B[2][1][3][0] - 1024*B[2][1][3][1] + 
     1024*B[2][1][3][3] - 128*B[2][1][3][4] - 8*B[2][1][4][0] + 64*B[2][1][4][1] - 64*B[2][1][4][3] + 8*B[2][1][4][4] + 8*B[2][3][0][0] - 64*B[2][3][0][1] + 64*B[2][3][0][3] - 
     8*B[2][3][0][4] - 128*B[2][3][1][0] + 1024*B[2][3][1][1] - 1024*B[2][3][1][3] + 128*B[2][3][1][4] + 816*B[2][3][2][0] - 3072*B[2][3][2][1] + 3072*B[2][3][2][3] - 816*B[2][3][2][4] - 
     128*B[2][3][3][0] + 1024*B[2][3][3][1] - 1024*B[2][3][3][3] + 128*B[2][3][3][4] + 8*B[2][3][4][0] - 64*B[2][3][4][1] + 64*B[2][3][4][3] - 8*B[2][3][4][4] - B[2][4][0][0] + 
     8*B[2][4][0][1] - 8*B[2][4][0][3] + B[2][4][0][4] + 16*B[2][4][1][0] - 128*B[2][4][1][1] + 128*B[2][4][1][3] - 16*B[2][4][1][4] - 102*B[2][4][2][0] + 384*B[2][4][2][1] - 
     384*B[2][4][2][3] + 102*B[2][4][2][4] + 16*B[2][4][3][0] - 128*B[2][4][3][1] + 128*B[2][4][3][3] - 16*B[2][4][3][4] - B[2][4][4][0] + 8*B[2][4][4][1] - 8*B[2][4][4][3] + B[2][4][4][4] - 
     8*B[3][2][0][0] + 128*B[3][2][0][1] - 816*B[3][2][0][2] + 128*B[3][2][0][3] - 8*B[3][2][0][4] + 64*B[3][2][1][0] - 1024*B[3][2][1][1] + 3072*B[3][2][1][2] - 1024*B[3][2][1][3] + 
     64*B[3][2][1][4] - 64*B[3][2][3][0] + 1024*B[3][2][3][1] - 3072*B[3][2][3][2] + 1024*B[3][2][3][3] - 64*B[3][2][3][4] + 8*B[3][2][4][0] - 128*B[3][2][4][1] + 816*B[3][2][4][2] - 
     128*B[3][2][4][3] + 8*B[3][2][4][4] + B[4][2][0][0] - 16*B[4][2][0][1] + 102*B[4][2][0][2] - 16*B[4][2][0][3] + B[4][2][0][4] - 8*B[4][2][1][0] + 128*B[4][2][1][1] - 384*B[4][2][1][2] + 
     128*B[4][2][1][3] - 8*B[4][2][1][4] + 8*B[4][2][3][0] - 128*B[4][2][3][1] + 384*B[4][2][3][2] - 128*B[4][2][3][3] + 8*B[4][2][3][4] - B[4][2][4][0] + 16*B[4][2][4][1] - 
     102*B[4][2][4][2] + 16*B[4][2][4][3] - B[4][2][4][4])/27648. ; 
	    val0121r = 1./(DW*DY2*DY)*((-B[0][2][0][0] + 16*B[0][2][0][1] - 102*B[0][2][0][2] + 16*B[0][2][0][3] - B[0][2][0][4] + 8*B[0][2][1][0] - 128*B[0][2][1][1] + 384*B[0][2][1][2] - 128*B[0][2][1][3] + 8*B[0][2][1][4] - 
     8*B[0][2][3][0] + 128*B[0][2][3][1] - 384*B[0][2][3][2] + 128*B[0][2][3][3] - 8*B[0][2][3][4] + B[0][2][4][0] - 16*B[0][2][4][1] + 102*B[0][2][4][2] - 16*B[0][2][4][3] + B[0][2][4][4] + 
     8*B[1][2][0][0] - 128*B[1][2][0][1] + 816*B[1][2][0][2] - 128*B[1][2][0][3] + 8*B[1][2][0][4] - 64*B[1][2][1][0] + 1024*B[1][2][1][1] - 3072*B[1][2][1][2] + 1024*B[1][2][1][3] - 
     64*B[1][2][1][4] + 64*B[1][2][3][0] - 1024*B[1][2][3][1] + 3072*B[1][2][3][2] - 1024*B[1][2][3][3] + 64*B[1][2][3][4] - 8*B[1][2][4][0] + 128*B[1][2][4][1] - 816*B[1][2][4][2] + 
     128*B[1][2][4][3] - 8*B[1][2][4][4] - B[2][0][0][0] + 8*B[2][0][0][1] - 8*B[2][0][0][3] + B[2][0][0][4] + 16*B[2][0][1][0] - 128*B[2][0][1][1] + 128*B[2][0][1][3] - 16*B[2][0][1][4] - 
     102*B[2][0][2][0] + 384*B[2][0][2][1] - 384*B[2][0][2][3] + 102*B[2][0][2][4] + 16*B[2][0][3][0] - 128*B[2][0][3][1] + 128*B[2][0][3][3] - 16*B[2][0][3][4] - B[2][0][4][0] + 
     8*B[2][0][4][1] - 8*B[2][0][4][3] + B[2][0][4][4] + 8*B[2][1][0][0] - 64*B[2][1][0][1] + 64*B[2][1][0][3] - 8*B[2][1][0][4] - 128*B[2][1][1][0] + 1024*B[2][1][1][1] - 
     1024*B[2][1][1][3] + 128*B[2][1][1][4] + 816*B[2][1][2][0] - 3072*B[2][1][2][1] + 3072*B[2][1][2][3] - 816*B[2][1][2][4] - 128*B[2][1][3][0] + 1024*B[2][1][3][1] - 
     1024*B[2][1][3][3] + 128*B[2][1][3][4] + 8*B[2][1][4][0] - 64*B[2][1][4][1] + 64*B[2][1][4][3] - 8*B[2][1][4][4] - 8*B[2][3][0][0] + 64*B[2][3][0][1] - 64*B[2][3][0][3] + 
     8*B[2][3][0][4] + 128*B[2][3][1][0] - 1024*B[2][3][1][1] + 1024*B[2][3][1][3] - 128*B[2][3][1][4] - 816*B[2][3][2][0] + 3072*B[2][3][2][1] - 3072*B[2][3][2][3] + 816*B[2][3][2][4] + 
     128*B[2][3][3][0] - 1024*B[2][3][3][1] + 1024*B[2][3][3][3] - 128*B[2][3][3][4] - 8*B[2][3][4][0] + 64*B[2][3][4][1] - 64*B[2][3][4][3] + 8*B[2][3][4][4] + B[2][4][0][0] - 
     8*B[2][4][0][1] + 8*B[2][4][0][3] - B[2][4][0][4] - 16*B[2][4][1][0] + 128*B[2][4][1][1] - 128*B[2][4][1][3] + 16*B[2][4][1][4] + 102*B[2][4][2][0] - 384*B[2][4][2][1] + 
     384*B[2][4][2][3] - 102*B[2][4][2][4] - 16*B[2][4][3][0] + 128*B[2][4][3][1] - 128*B[2][4][3][3] + 16*B[2][4][3][4] + B[2][4][4][0] - 8*B[2][4][4][1] + 8*B[2][4][4][3] - B[2][4][4][4] - 
     8*B[3][2][0][0] + 128*B[3][2][0][1] - 816*B[3][2][0][2] + 128*B[3][2][0][3] - 8*B[3][2][0][4] + 64*B[3][2][1][0] - 1024*B[3][2][1][1] + 3072*B[3][2][1][2] - 1024*B[3][2][1][3] + 
     64*B[3][2][1][4] - 64*B[3][2][3][0] + 1024*B[3][2][3][1] - 3072*B[3][2][3][2] + 1024*B[3][2][3][3] - 64*B[3][2][3][4] + 8*B[3][2][4][0] - 128*B[3][2][4][1] + 816*B[3][2][4][2] - 
     128*B[3][2][4][3] + 8*B[3][2][4][4] + B[4][2][0][0] - 16*B[4][2][0][1] + 102*B[4][2][0][2] - 16*B[4][2][0][3] + B[4][2][0][4] - 8*B[4][2][1][0] + 128*B[4][2][1][1] - 384*B[4][2][1][2] + 
     128*B[4][2][1][3] - 8*B[4][2][1][4] + 8*B[4][2][3][0] - 128*B[4][2][3][1] + 384*B[4][2][3][2] - 128*B[4][2][3][3] + 8*B[4][2][3][4] - B[4][2][4][0] + 16*B[4][2][4][1] - 
     102*B[4][2][4][2] + 16*B[4][2][4][3] - B[4][2][4][4])/27648.) ; 
	    val2011r = 1./(DW2*DY2)*(B[0][2][0][2] - 16*B[0][2][1][2] + B[0][2][2][0] - 16*B[0][2][2][1] + 60*B[0][2][2][2] - 16*B[0][2][2][3] + B[0][2][2][4] - 16*B[0][2][3][2] + B[0][2][4][2] - 16*B[1][2][0][2] + 
     256*B[1][2][1][2] - 16*B[1][2][2][0] + 256*B[1][2][2][1] - 960*B[1][2][2][2] + 256*B[1][2][2][3] - 16*B[1][2][2][4] + 256*B[1][2][3][2] - 16*B[1][2][4][2] - B[2][0][0][2] + 
     16*B[2][0][1][2] - B[2][0][2][0] + 16*B[2][0][2][1] - 60*B[2][0][2][2] + 16*B[2][0][2][3] - B[2][0][2][4] + 16*B[2][0][3][2] - B[2][0][4][2] + 16*B[2][1][0][2] - 256*B[2][1][1][2] + 
     16*B[2][1][2][0] - 256*B[2][1][2][1] + 960*B[2][1][2][2] - 256*B[2][1][2][3] + 16*B[2][1][2][4] - 256*B[2][1][3][2] + 16*B[2][1][4][2] + 16*B[2][3][0][2] - 256*B[2][3][1][2] + 
     16*B[2][3][2][0] - 256*B[2][3][2][1] + 960*B[2][3][2][2] - 256*B[2][3][2][3] + 16*B[2][3][2][4] - 256*B[2][3][3][2] + 16*B[2][3][4][2] - B[2][4][0][2] + 16*B[2][4][1][2] - 
     B[2][4][2][0] + 16*B[2][4][2][1] - 60*B[2][4][2][2] + 16*B[2][4][2][3] - B[2][4][2][4] + 16*B[2][4][3][2] - B[2][4][4][2] - 16*B[3][2][0][2] + 256*B[3][2][1][2] - 16*B[3][2][2][0] + 
     256*B[3][2][2][1] - 960*B[3][2][2][2] + 256*B[3][2][2][3] - 16*B[3][2][2][4] + 256*B[3][2][3][2] - 16*B[3][2][4][2] + B[4][2][0][2] - 16*B[4][2][1][2] + B[4][2][2][0] - 
     16*B[4][2][2][1] + 60*B[4][2][2][2] - 16*B[4][2][2][3] + B[4][2][2][4] - 16*B[4][2][3][2] + B[4][2][4][2])/2304. ; 
	    val1120r = 1./(DW2*DY2)*(B[0][2][0][2] - 16*B[0][2][1][2] - B[0][2][2][0] + 16*B[0][2][2][1] + 16*B[0][2][2][3] - B[0][2][2][4] - 16*B[0][2][3][2] + B[0][2][4][2] - 16*B[1][2][0][2] + 256*B[1][2][1][2] + 
     16*B[1][2][2][0] - 256*B[1][2][2][1] - 256*B[1][2][2][3] + 16*B[1][2][2][4] + 256*B[1][2][3][2] - 16*B[1][2][4][2] + B[2][0][0][2] - 16*B[2][0][1][2] - B[2][0][2][0] + 16*B[2][0][2][1] + 
     16*B[2][0][2][3] - B[2][0][2][4] - 16*B[2][0][3][2] + B[2][0][4][2] - 16*B[2][1][0][2] + 256*B[2][1][1][2] + 16*B[2][1][2][0] - 256*B[2][1][2][1] - 256*B[2][1][2][3] + 16*B[2][1][2][4] + 
     256*B[2][1][3][2] - 16*B[2][1][4][2] + 60*B[2][2][0][2] - 960*B[2][2][1][2] - 60*B[2][2][2][0] + 960*B[2][2][2][1] + 960*B[2][2][2][3] - 60*B[2][2][2][4] - 960*B[2][2][3][2] + 
     60*B[2][2][4][2] - 16*B[2][3][0][2] + 256*B[2][3][1][2] + 16*B[2][3][2][0] - 256*B[2][3][2][1] - 256*B[2][3][2][3] + 16*B[2][3][2][4] + 256*B[2][3][3][2] - 16*B[2][3][4][2] + 
     B[2][4][0][2] - 16*B[2][4][1][2] - B[2][4][2][0] + 16*B[2][4][2][1] + 16*B[2][4][2][3] - B[2][4][2][4] - 16*B[2][4][3][2] + B[2][4][4][2] - 16*B[3][2][0][2] + 256*B[3][2][1][2] + 
     16*B[3][2][2][0] - 256*B[3][2][2][1] - 256*B[3][2][2][3] + 16*B[3][2][2][4] + 256*B[3][2][3][2] - 16*B[3][2][4][2] + B[4][2][0][2] - 16*B[4][2][1][2] - B[4][2][2][0] + 16*B[4][2][2][1] + 
     16*B[4][2][2][3] - B[4][2][2][4] - 16*B[4][2][3][2] + B[4][2][4][2])/2304. ; 
	    val1111r = 1./(DW2*DY2)*(B[0][2][0][2] - 16*B[0][2][1][2] + B[0][2][2][0] - 16*B[0][2][2][1] + 60*B[0][2][2][2] - 16*B[0][2][2][3] + B[0][2][2][4] - 16*B[0][2][3][2] + B[0][2][4][2] - 16*B[1][2][0][2] + 
     256*B[1][2][1][2] - 16*B[1][2][2][0] + 256*B[1][2][2][1] - 960*B[1][2][2][2] + 256*B[1][2][2][3] - 16*B[1][2][2][4] + 256*B[1][2][3][2] - 16*B[1][2][4][2] + B[2][0][0][2] - 
     16*B[2][0][1][2] + B[2][0][2][0] - 16*B[2][0][2][1] + 60*B[2][0][2][2] - 16*B[2][0][2][3] + B[2][0][2][4] - 16*B[2][0][3][2] + B[2][0][4][2] - 16*B[2][1][0][2] + 256*B[2][1][1][2] - 
     16*B[2][1][2][0] + 256*B[2][1][2][1] - 960*B[2][1][2][2] + 256*B[2][1][2][3] - 16*B[2][1][2][4] + 256*B[2][1][3][2] - 16*B[2][1][4][2] + 60*B[2][2][0][2] - 960*B[2][2][1][2] + 
     60*B[2][2][2][0] - 960*B[2][2][2][1] + 3600*B[2][2][2][2] - 960*B[2][2][2][3] + 60*B[2][2][2][4] - 960*B[2][2][3][2] + 60*B[2][2][4][2] - 16*B[2][3][0][2] + 256*B[2][3][1][2] - 
     16*B[2][3][2][0] + 256*B[2][3][2][1] - 960*B[2][3][2][2] + 256*B[2][3][2][3] - 16*B[2][3][2][4] + 256*B[2][3][3][2] - 16*B[2][3][4][2] + B[2][4][0][2] - 16*B[2][4][1][2] + 
     B[2][4][2][0] - 16*B[2][4][2][1] + 60*B[2][4][2][2] - 16*B[2][4][2][3] + B[2][4][2][4] - 16*B[2][4][3][2] + B[2][4][4][2] - 16*B[3][2][0][2] + 256*B[3][2][1][2] - 16*B[3][2][2][0] + 
     256*B[3][2][2][1] - 960*B[3][2][2][2] + 256*B[3][2][2][3] - 16*B[3][2][2][4] + 256*B[3][2][3][2] - 16*B[3][2][4][2] + B[4][2][0][2] - 16*B[4][2][1][2] + B[4][2][2][0] - 
     16*B[4][2][2][1] + 60*B[4][2][2][2] - 16*B[4][2][2][3] + B[4][2][2][4] - 16*B[4][2][3][2] + B[4][2][4][2])/2304. ;

	    val1100i = 0. ; 
	    val0011i = 0. ; 
	    val0110i = 1./(DW*DY)*(-B[0][2][2][0] + 8*B[0][2][2][1] - 8*B[0][2][2][3] + B[0][2][2][4] + 8*B[1][2][2][0] - 64*B[1][2][2][1] + 64*B[1][2][2][3] - 8*B[1][2][2][4] + B[2][0][0][2] - 8*B[2][0][1][2] + 
     8*B[2][0][3][2] - B[2][0][4][2] - 8*B[2][1][0][2] + 64*B[2][1][1][2] - 64*B[2][1][3][2] + 8*B[2][1][4][2] + 8*B[2][3][0][2] - 64*B[2][3][1][2] + 64*B[2][3][3][2] - 8*B[2][3][4][2] - 
     B[2][4][0][2] + 8*B[2][4][1][2] - 8*B[2][4][3][2] + B[2][4][4][2] - 8*B[3][2][2][0] + 64*B[3][2][2][1] - 64*B[3][2][2][3] + 8*B[3][2][2][4] + B[4][2][2][0] - 8*B[4][2][2][1] + 
     8*B[4][2][2][3] - B[4][2][2][4])/576. ; 
	    val1011i = 1./(DW*DY2)*(B[2][0][0][2] - 16*B[2][0][1][2] + B[2][0][2][0] - 16*B[2][0][2][1] + 60*B[2][0][2][2] - 16*B[2][0][2][3] + B[2][0][2][4] - 16*B[2][0][3][2] + B[2][0][4][2] - 8*B[2][1][0][2] + 
     128*B[2][1][1][2] - 8*B[2][1][2][0] + 128*B[2][1][2][1] - 480*B[2][1][2][2] + 128*B[2][1][2][3] - 8*B[2][1][2][4] + 128*B[2][1][3][2] - 8*B[2][1][4][2] + 8*B[2][3][0][2] - 
     128*B[2][3][1][2] + 8*B[2][3][2][0] - 128*B[2][3][2][1] + 480*B[2][3][2][2] - 128*B[2][3][2][3] + 8*B[2][3][2][4] - 128*B[2][3][3][2] + 8*B[2][3][4][2] - B[2][4][0][2] + 
     16*B[2][4][1][2] - B[2][4][2][0] + 16*B[2][4][2][1] - 60*B[2][4][2][2] + 16*B[2][4][2][3] - B[2][4][2][4] + 16*B[2][4][3][2] - B[2][4][4][2])/1152. ; 
	    val1110i = 1./(DW2*DY)*(B[0][2][2][0] - 8*B[0][2][2][1] + 8*B[0][2][2][3] - B[0][2][2][4] - 16*B[1][2][2][0] + 128*B[1][2][2][1] - 128*B[1][2][2][3] + 16*B[1][2][2][4] + B[2][0][2][0] - 8*B[2][0][2][1] + 
     8*B[2][0][2][3] - B[2][0][2][4] - 16*B[2][1][2][0] + 128*B[2][1][2][1] - 128*B[2][1][2][3] + 16*B[2][1][2][4] + 60*B[2][2][2][0] - 480*B[2][2][2][1] + 480*B[2][2][2][3] - 
     60*B[2][2][2][4] - 16*B[2][3][2][0] + 128*B[2][3][2][1] - 128*B[2][3][2][3] + 16*B[2][3][2][4] + B[2][4][2][0] - 8*B[2][4][2][1] + 8*B[2][4][2][3] - B[2][4][2][4] - 16*B[3][2][2][0] + 
     128*B[3][2][2][1] - 128*B[3][2][2][3] + 16*B[3][2][2][4] + B[4][2][2][0] - 8*B[4][2][2][1] + 8*B[4][2][2][3] - B[4][2][2][4])/1152. ; 
	    val1002i = 1./(DW*DY2)*(B[0][2][0][0] - 8*B[0][2][0][1] + 8*B[0][2][0][3] - B[0][2][0][4] - 8*B[0][2][1][0] + 64*B[0][2][1][1] - 64*B[0][2][1][3] + 8*B[0][2][1][4] + 8*B[0][2][3][0] - 64*B[0][2][3][1] + 
     64*B[0][2][3][3] - 8*B[0][2][3][4] - B[0][2][4][0] + 8*B[0][2][4][1] - 8*B[0][2][4][3] + B[0][2][4][4] - 8*B[1][2][0][0] + 64*B[1][2][0][1] - 64*B[1][2][0][3] + 8*B[1][2][0][4] + 
     64*B[1][2][1][0] - 512*B[1][2][1][1] + 512*B[1][2][1][3] - 64*B[1][2][1][4] - 64*B[1][2][3][0] + 512*B[1][2][3][1] - 512*B[1][2][3][3] + 64*B[1][2][3][4] + 8*B[1][2][4][0] - 
     64*B[1][2][4][1] + 64*B[1][2][4][3] - 8*B[1][2][4][4] + 6*B[2][0][0][2] - 96*B[2][0][1][2] - 6*B[2][0][2][0] + 96*B[2][0][2][1] + 96*B[2][0][2][3] - 6*B[2][0][2][4] - 96*B[2][0][3][2] + 
     6*B[2][0][4][2] - 48*B[2][1][0][2] + 768*B[2][1][1][2] + 48*B[2][1][2][0] - 768*B[2][1][2][1] - 768*B[2][1][2][3] + 48*B[2][1][2][4] + 768*B[2][1][3][2] - 48*B[2][1][4][2] + 
     48*B[2][3][0][2] - 768*B[2][3][1][2] - 48*B[2][3][2][0] + 768*B[2][3][2][1] + 768*B[2][3][2][3] - 48*B[2][3][2][4] - 768*B[2][3][3][2] + 48*B[2][3][4][2] - 6*B[2][4][0][2] + 
     96*B[2][4][1][2] + 6*B[2][4][2][0] - 96*B[2][4][2][1] - 96*B[2][4][2][3] + 6*B[2][4][2][4] + 96*B[2][4][3][2] - 6*B[2][4][4][2] + 8*B[3][2][0][0] - 64*B[3][2][0][1] + 64*B[3][2][0][3] - 
     8*B[3][2][0][4] - 64*B[3][2][1][0] + 512*B[3][2][1][1] - 512*B[3][2][1][3] + 64*B[3][2][1][4] + 64*B[3][2][3][0] - 512*B[3][2][3][1] + 512*B[3][2][3][3] - 64*B[3][2][3][4] - 
     8*B[3][2][4][0] + 64*B[3][2][4][1] - 64*B[3][2][4][3] + 8*B[3][2][4][4] - B[4][2][0][0] + 8*B[4][2][0][1] - 8*B[4][2][0][3] + B[4][2][0][4] + 8*B[4][2][1][0] - 64*B[4][2][1][1] + 
     64*B[4][2][1][3] - 8*B[4][2][1][4] - 8*B[4][2][3][0] + 64*B[4][2][3][1] - 64*B[4][2][3][3] + 8*B[4][2][3][4] + B[4][2][4][0] - 8*B[4][2][4][1] + 8*B[4][2][4][3] - B[4][2][4][4])/6912. ; 
	    val0012i = 1./(DY2*DY)*(-B[2][2][0][0] + 8*B[2][2][0][1] - 8*B[2][2][0][3] + B[2][2][0][4] + 16*B[2][2][1][0] - 128*B[2][2][1][1] + 128*B[2][2][1][3] - 16*B[2][2][1][4] - 102*B[2][2][2][0] + 384*B[2][2][2][1] - 
     384*B[2][2][2][3] + 102*B[2][2][2][4] + 16*B[2][2][3][0] - 128*B[2][2][3][1] + 128*B[2][2][3][3] - 16*B[2][2][3][4] - B[2][2][4][0] + 8*B[2][2][4][1] - 8*B[2][2][4][3] + B[2][2][4][4])/
   1152. ; 
	    val2001i = 1./(DW2*DY)*(-B[0][0][0][2] + 8*B[0][0][1][2] - 8*B[0][0][3][2] + B[0][0][4][2] + 8*B[0][1][0][2] - 64*B[0][1][1][2] + 64*B[0][1][3][2] - 8*B[0][1][4][2] - 6*B[0][2][2][0] + 48*B[0][2][2][1] - 
     48*B[0][2][2][3] + 6*B[0][2][2][4] - 8*B[0][3][0][2] + 64*B[0][3][1][2] - 64*B[0][3][3][2] + 8*B[0][3][4][2] + B[0][4][0][2] - 8*B[0][4][1][2] + 8*B[0][4][3][2] - B[0][4][4][2] + 
     8*B[1][0][0][2] - 64*B[1][0][1][2] + 64*B[1][0][3][2] - 8*B[1][0][4][2] - 64*B[1][1][0][2] + 512*B[1][1][1][2] - 512*B[1][1][3][2] + 64*B[1][1][4][2] + 96*B[1][2][2][0] - 
     768*B[1][2][2][1] + 768*B[1][2][2][3] - 96*B[1][2][2][4] + 64*B[1][3][0][2] - 512*B[1][3][1][2] + 512*B[1][3][3][2] - 64*B[1][3][4][2] - 8*B[1][4][0][2] + 64*B[1][4][1][2] - 
     64*B[1][4][3][2] + 8*B[1][4][4][2] + 6*B[2][0][2][0] - 48*B[2][0][2][1] + 48*B[2][0][2][3] - 6*B[2][0][2][4] - 96*B[2][1][2][0] + 768*B[2][1][2][1] - 768*B[2][1][2][3] + 
     96*B[2][1][2][4] - 96*B[2][3][2][0] + 768*B[2][3][2][1] - 768*B[2][3][2][3] + 96*B[2][3][2][4] + 6*B[2][4][2][0] - 48*B[2][4][2][1] + 48*B[2][4][2][3] - 6*B[2][4][2][4] - 
     8*B[3][0][0][2] + 64*B[3][0][1][2] - 64*B[3][0][3][2] + 8*B[3][0][4][2] + 64*B[3][1][0][2] - 512*B[3][1][1][2] + 512*B[3][1][3][2] - 64*B[3][1][4][2] + 96*B[3][2][2][0] - 
     768*B[3][2][2][1] + 768*B[3][2][2][3] - 96*B[3][2][2][4] - 64*B[3][3][0][2] + 512*B[3][3][1][2] - 512*B[3][3][3][2] + 64*B[3][3][4][2] + 8*B[3][4][0][2] - 64*B[3][4][1][2] + 
     64*B[3][4][3][2] - 8*B[3][4][4][2] + B[4][0][0][2] - 8*B[4][0][1][2] + 8*B[4][0][3][2] - B[4][0][4][2] - 8*B[4][1][0][2] + 64*B[4][1][1][2] - 64*B[4][1][3][2] + 8*B[4][1][4][2] - 
     6*B[4][2][2][0] + 48*B[4][2][2][1] - 48*B[4][2][2][3] + 6*B[4][2][2][4] + 8*B[4][3][0][2] - 64*B[4][3][1][2] + 64*B[4][3][3][2] - 8*B[4][3][4][2] - B[4][4][0][2] + 8*B[4][4][1][2] - 
     8*B[4][4][3][2] + B[4][4][4][2])/6912. ; 
	    val2100i = 1./(DW2*DW)*(B[0][0][2][2] - 8*B[0][1][2][2] + 8*B[0][3][2][2] - B[0][4][2][2] - 16*B[1][0][2][2] + 128*B[1][1][2][2] - 128*B[1][3][2][2] + 16*B[1][4][2][2] + 102*B[2][0][2][2] - 384*B[2][1][2][2] + 
     384*B[2][3][2][2] - 102*B[2][4][2][2] - 16*B[3][0][2][2] + 128*B[3][1][2][2] - 128*B[3][3][2][2] + 16*B[3][4][2][2] + B[4][0][2][2] - 8*B[4][1][2][2] + 8*B[4][3][2][2] - B[4][4][2][2])/
   1152. ;
	    val3001i = 1./(DW2*DW*DY)*(B[0][0][0][2] - 8*B[0][0][1][2] + B[0][0][2][0] - 8*B[0][0][2][1] + 8*B[0][0][2][3] - B[0][0][2][4] + 8*B[0][0][3][2] - B[0][0][4][2] - 8*B[0][1][0][2] + 64*B[0][1][1][2] - 16*B[0][1][2][0] + 
     128*B[0][1][2][1] - 128*B[0][1][2][3] + 16*B[0][1][2][4] - 64*B[0][1][3][2] + 8*B[0][1][4][2] + 6*B[0][2][2][0] - 48*B[0][2][2][1] + 48*B[0][2][2][3] - 6*B[0][2][2][4] + 
     8*B[0][3][0][2] - 64*B[0][3][1][2] - 16*B[0][3][2][0] + 128*B[0][3][2][1] - 128*B[0][3][2][3] + 16*B[0][3][2][4] + 64*B[0][3][3][2] - 8*B[0][3][4][2] - B[0][4][0][2] + 8*B[0][4][1][2] + 
     B[0][4][2][0] - 8*B[0][4][2][1] + 8*B[0][4][2][3] - B[0][4][2][4] - 8*B[0][4][3][2] + B[0][4][4][2] - 16*B[1][0][0][2] + 128*B[1][0][1][2] - 8*B[1][0][2][0] + 64*B[1][0][2][1] - 
     64*B[1][0][2][3] + 8*B[1][0][2][4] - 128*B[1][0][3][2] + 16*B[1][0][4][2] + 128*B[1][1][0][2] - 1024*B[1][1][1][2] + 128*B[1][1][2][0] - 1024*B[1][1][2][1] + 1024*B[1][1][2][3] - 
     128*B[1][1][2][4] + 1024*B[1][1][3][2] - 128*B[1][1][4][2] - 192*B[1][2][2][0] + 1536*B[1][2][2][1] - 1536*B[1][2][2][3] + 192*B[1][2][2][4] - 128*B[1][3][0][2] + 1024*B[1][3][1][2] + 
     128*B[1][3][2][0] - 1024*B[1][3][2][1] + 1024*B[1][3][2][3] - 128*B[1][3][2][4] - 1024*B[1][3][3][2] + 128*B[1][3][4][2] + 16*B[1][4][0][2] - 128*B[1][4][1][2] - 8*B[1][4][2][0] + 
     64*B[1][4][2][1] - 64*B[1][4][2][3] + 8*B[1][4][2][4] + 128*B[1][4][3][2] - 16*B[1][4][4][2] + 6*B[2][0][0][2] - 48*B[2][0][1][2] + 48*B[2][0][3][2] - 6*B[2][0][4][2] - 
     192*B[2][1][0][2] + 1536*B[2][1][1][2] - 1536*B[2][1][3][2] + 192*B[2][1][4][2] + 192*B[2][3][0][2] - 1536*B[2][3][1][2] + 1536*B[2][3][3][2] - 192*B[2][3][4][2] - 6*B[2][4][0][2] + 
     48*B[2][4][1][2] - 48*B[2][4][3][2] + 6*B[2][4][4][2] - 16*B[3][0][0][2] + 128*B[3][0][1][2] + 8*B[3][0][2][0] - 64*B[3][0][2][1] + 64*B[3][0][2][3] - 8*B[3][0][2][4] - 
     128*B[3][0][3][2] + 16*B[3][0][4][2] + 128*B[3][1][0][2] - 1024*B[3][1][1][2] - 128*B[3][1][2][0] + 1024*B[3][1][2][1] - 1024*B[3][1][2][3] + 128*B[3][1][2][4] + 1024*B[3][1][3][2] - 
     128*B[3][1][4][2] + 192*B[3][2][2][0] - 1536*B[3][2][2][1] + 1536*B[3][2][2][3] - 192*B[3][2][2][4] - 128*B[3][3][0][2] + 1024*B[3][3][1][2] - 128*B[3][3][2][0] + 1024*B[3][3][2][1] - 
     1024*B[3][3][2][3] + 128*B[3][3][2][4] - 1024*B[3][3][3][2] + 128*B[3][3][4][2] + 16*B[3][4][0][2] - 128*B[3][4][1][2] + 8*B[3][4][2][0] - 64*B[3][4][2][1] + 64*B[3][4][2][3] - 
     8*B[3][4][2][4] + 128*B[3][4][3][2] - 16*B[3][4][4][2] + B[4][0][0][2] - 8*B[4][0][1][2] - B[4][0][2][0] + 8*B[4][0][2][1] - 8*B[4][0][2][3] + B[4][0][2][4] + 8*B[4][0][3][2] - 
     B[4][0][4][2] - 8*B[4][1][0][2] + 64*B[4][1][1][2] + 16*B[4][1][2][0] - 128*B[4][1][2][1] + 128*B[4][1][2][3] - 16*B[4][1][2][4] - 64*B[4][1][3][2] + 8*B[4][1][4][2] - 6*B[4][2][2][0] + 
     48*B[4][2][2][1] - 48*B[4][2][2][3] + 6*B[4][2][2][4] + 8*B[4][3][0][2] - 64*B[4][3][1][2] + 16*B[4][3][2][0] - 128*B[4][3][2][1] + 128*B[4][3][2][3] - 16*B[4][3][2][4] + 
     64*B[4][3][3][2] - 8*B[4][3][4][2] - B[4][4][0][2] + 8*B[4][4][1][2] - B[4][4][2][0] + 8*B[4][4][2][1] - 8*B[4][4][2][3] + B[4][4][2][4] - 8*B[4][4][3][2] + B[4][4][4][2])/9216. ; 
	    val3100i = 1./(DW2*DW2)*(B[0][0][2][2] - 5*B[0][1][2][2] + 5*B[0][3][2][2] - B[0][4][2][2] - 5*B[1][0][2][2] + 16*B[1][1][2][2] - 16*B[1][3][2][2] + 5*B[1][4][2][2] + 5*B[3][0][2][2] - 16*B[3][1][2][2] + 
     16*B[3][3][2][2] - 5*B[3][4][2][2] - B[4][0][2][2] + 5*B[4][1][2][2] - 5*B[4][3][2][2] + B[4][4][2][2])/96. ; 
	    val1003i = 1./(DW*DY2*DY)*(-B[0][2][0][0] + 8*B[0][2][0][1] - 8*B[0][2][0][3] + B[0][2][0][4] + 16*B[0][2][1][0] - 128*B[0][2][1][1] + 128*B[0][2][1][3] - 16*B[0][2][1][4] - 6*B[0][2][2][0] + 192*B[0][2][2][1] - 
     192*B[0][2][2][3] + 6*B[0][2][2][4] + 16*B[0][2][3][0] - 128*B[0][2][3][1] + 128*B[0][2][3][3] - 16*B[0][2][3][4] - B[0][2][4][0] + 8*B[0][2][4][1] - 8*B[0][2][4][3] + B[0][2][4][4] + 
     8*B[1][2][0][0] - 64*B[1][2][0][1] + 64*B[1][2][0][3] - 8*B[1][2][0][4] - 128*B[1][2][1][0] + 1024*B[1][2][1][1] - 1024*B[1][2][1][3] + 128*B[1][2][1][4] + 48*B[1][2][2][0] - 
     1536*B[1][2][2][1] + 1536*B[1][2][2][3] - 48*B[1][2][2][4] - 128*B[1][2][3][0] + 1024*B[1][2][3][1] - 1024*B[1][2][3][3] + 128*B[1][2][3][4] + 8*B[1][2][4][0] - 64*B[1][2][4][1] + 
     64*B[1][2][4][3] - 8*B[1][2][4][4] - B[2][0][0][0] + 16*B[2][0][0][1] - 6*B[2][0][0][2] + 16*B[2][0][0][3] - B[2][0][0][4] + 8*B[2][0][1][0] - 128*B[2][0][1][1] + 192*B[2][0][1][2] - 
     128*B[2][0][1][3] + 8*B[2][0][1][4] - 8*B[2][0][3][0] + 128*B[2][0][3][1] - 192*B[2][0][3][2] + 128*B[2][0][3][3] - 8*B[2][0][3][4] + B[2][0][4][0] - 16*B[2][0][4][1] + 6*B[2][0][4][2] - 
     16*B[2][0][4][3] + B[2][0][4][4] + 8*B[2][1][0][0] - 128*B[2][1][0][1] + 48*B[2][1][0][2] - 128*B[2][1][0][3] + 8*B[2][1][0][4] - 64*B[2][1][1][0] + 1024*B[2][1][1][1] - 
     1536*B[2][1][1][2] + 1024*B[2][1][1][3] - 64*B[2][1][1][4] + 64*B[2][1][3][0] - 1024*B[2][1][3][1] + 1536*B[2][1][3][2] - 1024*B[2][1][3][3] + 64*B[2][1][3][4] - 8*B[2][1][4][0] + 
     128*B[2][1][4][1] - 48*B[2][1][4][2] + 128*B[2][1][4][3] - 8*B[2][1][4][4] - 8*B[2][3][0][0] + 128*B[2][3][0][1] - 48*B[2][3][0][2] + 128*B[2][3][0][3] - 8*B[2][3][0][4] + 
     64*B[2][3][1][0] - 1024*B[2][3][1][1] + 1536*B[2][3][1][2] - 1024*B[2][3][1][3] + 64*B[2][3][1][4] - 64*B[2][3][3][0] + 1024*B[2][3][3][1] - 1536*B[2][3][3][2] + 1024*B[2][3][3][3] - 
     64*B[2][3][3][4] + 8*B[2][3][4][0] - 128*B[2][3][4][1] + 48*B[2][3][4][2] - 128*B[2][3][4][3] + 8*B[2][3][4][4] + B[2][4][0][0] - 16*B[2][4][0][1] + 6*B[2][4][0][2] - 16*B[2][4][0][3] + 
     B[2][4][0][4] - 8*B[2][4][1][0] + 128*B[2][4][1][1] - 192*B[2][4][1][2] + 128*B[2][4][1][3] - 8*B[2][4][1][4] + 8*B[2][4][3][0] - 128*B[2][4][3][1] + 192*B[2][4][3][2] - 
     128*B[2][4][3][3] + 8*B[2][4][3][4] - B[2][4][4][0] + 16*B[2][4][4][1] - 6*B[2][4][4][2] + 16*B[2][4][4][3] - B[2][4][4][4] - 8*B[3][2][0][0] + 64*B[3][2][0][1] - 64*B[3][2][0][3] + 
     8*B[3][2][0][4] + 128*B[3][2][1][0] - 1024*B[3][2][1][1] + 1024*B[3][2][1][3] - 128*B[3][2][1][4] - 48*B[3][2][2][0] + 1536*B[3][2][2][1] - 1536*B[3][2][2][3] + 48*B[3][2][2][4] + 
     128*B[3][2][3][0] - 1024*B[3][2][3][1] + 1024*B[3][2][3][3] - 128*B[3][2][3][4] - 8*B[3][2][4][0] + 64*B[3][2][4][1] - 64*B[3][2][4][3] + 8*B[3][2][4][4] + B[4][2][0][0] - 
     8*B[4][2][0][1] + 8*B[4][2][0][3] - B[4][2][0][4] - 16*B[4][2][1][0] + 128*B[4][2][1][1] - 128*B[4][2][1][3] + 16*B[4][2][1][4] + 6*B[4][2][2][0] - 192*B[4][2][2][1] + 
     192*B[4][2][2][3] - 6*B[4][2][2][4] - 16*B[4][2][3][0] + 128*B[4][2][3][1] - 128*B[4][2][3][3] + 16*B[4][2][3][4] + B[4][2][4][0] - 8*B[4][2][4][1] + 8*B[4][2][4][3] - B[4][2][4][4])/
   9216. ; 
	    val0031i = 1./(DY2*DY2)*(B[2][2][0][0] - 5*B[2][2][0][1] + 5*B[2][2][0][3] - B[2][2][0][4] - 5*B[2][2][1][0] + 16*B[2][2][1][1] - 16*B[2][2][1][3] + 5*B[2][2][1][4] + 5*B[2][2][3][0] - 16*B[2][2][3][1] + 
     16*B[2][2][3][3] - 5*B[2][2][3][4] - B[2][2][4][0] + 5*B[2][2][4][1] - 5*B[2][2][4][3] + B[2][2][4][4])/96. ; 
	    val2200i = 0. ; 
	    val0022i = 0. ; 
	    val0220i = 1./(DW2*DY2)*((-B[0][0][0][2] + 16*B[0][0][1][2] + B[0][0][2][0] - 16*B[0][0][2][1] - 16*B[0][0][2][3] + B[0][0][2][4] + 16*B[0][0][3][2] - B[0][0][4][2] + 8*B[0][1][0][2] - 128*B[0][1][1][2] - 
     8*B[0][1][2][0] + 128*B[0][1][2][1] + 128*B[0][1][2][3] - 8*B[0][1][2][4] - 128*B[0][1][3][2] + 8*B[0][1][4][2] + B[0][2][0][0] - 8*B[0][2][0][1] + 8*B[0][2][0][3] - B[0][2][0][4] - 
     8*B[0][2][1][0] + 64*B[0][2][1][1] - 64*B[0][2][1][3] + 8*B[0][2][1][4] + 8*B[0][2][3][0] - 64*B[0][2][3][1] + 64*B[0][2][3][3] - 8*B[0][2][3][4] - B[0][2][4][0] + 8*B[0][2][4][1] - 
     8*B[0][2][4][3] + B[0][2][4][4] - 8*B[0][3][0][2] + 128*B[0][3][1][2] + 8*B[0][3][2][0] - 128*B[0][3][2][1] - 128*B[0][3][2][3] + 8*B[0][3][2][4] + 128*B[0][3][3][2] - 8*B[0][3][4][2] + 
     B[0][4][0][2] - 16*B[0][4][1][2] - B[0][4][2][0] + 16*B[0][4][2][1] + 16*B[0][4][2][3] - B[0][4][2][4] - 16*B[0][4][3][2] + B[0][4][4][2] + 8*B[1][0][0][2] - 128*B[1][0][1][2] - 
     8*B[1][0][2][0] + 128*B[1][0][2][1] + 128*B[1][0][2][3] - 8*B[1][0][2][4] - 128*B[1][0][3][2] + 8*B[1][0][4][2] - 64*B[1][1][0][2] + 1024*B[1][1][1][2] + 64*B[1][1][2][0] - 
     1024*B[1][1][2][1] - 1024*B[1][1][2][3] + 64*B[1][1][2][4] + 1024*B[1][1][3][2] - 64*B[1][1][4][2] - 16*B[1][2][0][0] + 128*B[1][2][0][1] - 128*B[1][2][0][3] + 16*B[1][2][0][4] + 
     128*B[1][2][1][0] - 1024*B[1][2][1][1] + 1024*B[1][2][1][3] - 128*B[1][2][1][4] - 128*B[1][2][3][0] + 1024*B[1][2][3][1] - 1024*B[1][2][3][3] + 128*B[1][2][3][4] + 16*B[1][2][4][0] - 
     128*B[1][2][4][1] + 128*B[1][2][4][3] - 16*B[1][2][4][4] + 64*B[1][3][0][2] - 1024*B[1][3][1][2] - 64*B[1][3][2][0] + 1024*B[1][3][2][1] + 1024*B[1][3][2][3] - 64*B[1][3][2][4] - 
     1024*B[1][3][3][2] + 64*B[1][3][4][2] - 8*B[1][4][0][2] + 128*B[1][4][1][2] + 8*B[1][4][2][0] - 128*B[1][4][2][1] - 128*B[1][4][2][3] + 8*B[1][4][2][4] + 128*B[1][4][3][2] - 
     8*B[1][4][4][2] - B[2][0][0][0] + 8*B[2][0][0][1] - 8*B[2][0][0][3] + B[2][0][0][4] + 8*B[2][0][1][0] - 64*B[2][0][1][1] + 64*B[2][0][1][3] - 8*B[2][0][1][4] - 8*B[2][0][3][0] + 
     64*B[2][0][3][1] - 64*B[2][0][3][3] + 8*B[2][0][3][4] + B[2][0][4][0] - 8*B[2][0][4][1] + 8*B[2][0][4][3] - B[2][0][4][4] + 16*B[2][1][0][0] - 128*B[2][1][0][1] + 128*B[2][1][0][3] - 
     16*B[2][1][0][4] - 128*B[2][1][1][0] + 1024*B[2][1][1][1] - 1024*B[2][1][1][3] + 128*B[2][1][1][4] + 128*B[2][1][3][0] - 1024*B[2][1][3][1] + 1024*B[2][1][3][3] - 128*B[2][1][3][4] - 
     16*B[2][1][4][0] + 128*B[2][1][4][1] - 128*B[2][1][4][3] + 16*B[2][1][4][4] + 16*B[2][3][0][0] - 128*B[2][3][0][1] + 128*B[2][3][0][3] - 16*B[2][3][0][4] - 128*B[2][3][1][0] + 
     1024*B[2][3][1][1] - 1024*B[2][3][1][3] + 128*B[2][3][1][4] + 128*B[2][3][3][0] - 1024*B[2][3][3][1] + 1024*B[2][3][3][3] - 128*B[2][3][3][4] - 16*B[2][3][4][0] + 128*B[2][3][4][1] - 
     128*B[2][3][4][3] + 16*B[2][3][4][4] - B[2][4][0][0] + 8*B[2][4][0][1] - 8*B[2][4][0][3] + B[2][4][0][4] + 8*B[2][4][1][0] - 64*B[2][4][1][1] + 64*B[2][4][1][3] - 8*B[2][4][1][4] - 
     8*B[2][4][3][0] + 64*B[2][4][3][1] - 64*B[2][4][3][3] + 8*B[2][4][3][4] + B[2][4][4][0] - 8*B[2][4][4][1] + 8*B[2][4][4][3] - B[2][4][4][4] - 8*B[3][0][0][2] + 128*B[3][0][1][2] + 
     8*B[3][0][2][0] - 128*B[3][0][2][1] - 128*B[3][0][2][3] + 8*B[3][0][2][4] + 128*B[3][0][3][2] - 8*B[3][0][4][2] + 64*B[3][1][0][2] - 1024*B[3][1][1][2] - 64*B[3][1][2][0] + 
     1024*B[3][1][2][1] + 1024*B[3][1][2][3] - 64*B[3][1][2][4] - 1024*B[3][1][3][2] + 64*B[3][1][4][2] - 16*B[3][2][0][0] + 128*B[3][2][0][1] - 128*B[3][2][0][3] + 16*B[3][2][0][4] + 
     128*B[3][2][1][0] - 1024*B[3][2][1][1] + 1024*B[3][2][1][3] - 128*B[3][2][1][4] - 128*B[3][2][3][0] + 1024*B[3][2][3][1] - 1024*B[3][2][3][3] + 128*B[3][2][3][4] + 16*B[3][2][4][0] - 
     128*B[3][2][4][1] + 128*B[3][2][4][3] - 16*B[3][2][4][4] - 64*B[3][3][0][2] + 1024*B[3][3][1][2] + 64*B[3][3][2][0] - 1024*B[3][3][2][1] - 1024*B[3][3][2][3] + 64*B[3][3][2][4] + 
     1024*B[3][3][3][2] - 64*B[3][3][4][2] + 8*B[3][4][0][2] - 128*B[3][4][1][2] - 8*B[3][4][2][0] + 128*B[3][4][2][1] + 128*B[3][4][2][3] - 8*B[3][4][2][4] - 128*B[3][4][3][2] + 
     8*B[3][4][4][2] + B[4][0][0][2] - 16*B[4][0][1][2] - B[4][0][2][0] + 16*B[4][0][2][1] + 16*B[4][0][2][3] - B[4][0][2][4] - 16*B[4][0][3][2] + B[4][0][4][2] - 8*B[4][1][0][2] + 
     128*B[4][1][1][2] + 8*B[4][1][2][0] - 128*B[4][1][2][1] - 128*B[4][1][2][3] + 8*B[4][1][2][4] + 128*B[4][1][3][2] - 8*B[4][1][4][2] + B[4][2][0][0] - 8*B[4][2][0][1] + 8*B[4][2][0][3] - 
     B[4][2][0][4] - 8*B[4][2][1][0] + 64*B[4][2][1][1] - 64*B[4][2][1][3] + 8*B[4][2][1][4] + 8*B[4][2][3][0] - 64*B[4][2][3][1] + 64*B[4][2][3][3] - 8*B[4][2][3][4] - B[4][2][4][0] + 
     8*B[4][2][4][1] - 8*B[4][2][4][3] + B[4][2][4][4] + 8*B[4][3][0][2] - 128*B[4][3][1][2] - 8*B[4][3][2][0] + 128*B[4][3][2][1] + 128*B[4][3][2][3] - 8*B[4][3][2][4] - 128*B[4][3][3][2] + 
     8*B[4][3][4][2] - B[4][4][0][2] + 16*B[4][4][1][2] + B[4][4][2][0] - 16*B[4][4][2][1] - 16*B[4][4][2][3] + B[4][4][2][4] + 16*B[4][4][3][2] - B[4][4][4][2])/13824.) ; 
	    val2110i = 1./(DW2*DW*DY)*(B[0][0][0][2] - 8*B[0][0][1][2] + B[0][0][2][0] - 8*B[0][0][2][1] + 8*B[0][0][2][3] - B[0][0][2][4] + 8*B[0][0][3][2] - B[0][0][4][2] - 8*B[0][1][0][2] + 64*B[0][1][1][2] - 16*B[0][1][2][0] + 
     128*B[0][1][2][1] - 128*B[0][1][2][3] + 16*B[0][1][2][4] - 64*B[0][1][3][2] + 8*B[0][1][4][2] + 102*B[0][2][2][0] - 816*B[0][2][2][1] + 816*B[0][2][2][3] - 102*B[0][2][2][4] + 
     8*B[0][3][0][2] - 64*B[0][3][1][2] - 16*B[0][3][2][0] + 128*B[0][3][2][1] - 128*B[0][3][2][3] + 16*B[0][3][2][4] + 64*B[0][3][3][2] - 8*B[0][3][4][2] - B[0][4][0][2] + 8*B[0][4][1][2] + 
     B[0][4][2][0] - 8*B[0][4][2][1] + 8*B[0][4][2][3] - B[0][4][2][4] - 8*B[0][4][3][2] + B[0][4][4][2] - 16*B[1][0][0][2] + 128*B[1][0][1][2] - 8*B[1][0][2][0] + 64*B[1][0][2][1] - 
     64*B[1][0][2][3] + 8*B[1][0][2][4] - 128*B[1][0][3][2] + 16*B[1][0][4][2] + 128*B[1][1][0][2] - 1024*B[1][1][1][2] + 128*B[1][1][2][0] - 1024*B[1][1][2][1] + 1024*B[1][1][2][3] - 
     128*B[1][1][2][4] + 1024*B[1][1][3][2] - 128*B[1][1][4][2] - 384*B[1][2][2][0] + 3072*B[1][2][2][1] - 3072*B[1][2][2][3] + 384*B[1][2][2][4] - 128*B[1][3][0][2] + 1024*B[1][3][1][2] + 
     128*B[1][3][2][0] - 1024*B[1][3][2][1] + 1024*B[1][3][2][3] - 128*B[1][3][2][4] - 1024*B[1][3][3][2] + 128*B[1][3][4][2] + 16*B[1][4][0][2] - 128*B[1][4][1][2] - 8*B[1][4][2][0] + 
     64*B[1][4][2][1] - 64*B[1][4][2][3] + 8*B[1][4][2][4] + 128*B[1][4][3][2] - 16*B[1][4][4][2] + 102*B[2][0][0][2] - 816*B[2][0][1][2] + 816*B[2][0][3][2] - 102*B[2][0][4][2] - 
     384*B[2][1][0][2] + 3072*B[2][1][1][2] - 3072*B[2][1][3][2] + 384*B[2][1][4][2] + 384*B[2][3][0][2] - 3072*B[2][3][1][2] + 3072*B[2][3][3][2] - 384*B[2][3][4][2] - 102*B[2][4][0][2] + 
     816*B[2][4][1][2] - 816*B[2][4][3][2] + 102*B[2][4][4][2] - 16*B[3][0][0][2] + 128*B[3][0][1][2] + 8*B[3][0][2][0] - 64*B[3][0][2][1] + 64*B[3][0][2][3] - 8*B[3][0][2][4] - 
     128*B[3][0][3][2] + 16*B[3][0][4][2] + 128*B[3][1][0][2] - 1024*B[3][1][1][2] - 128*B[3][1][2][0] + 1024*B[3][1][2][1] - 1024*B[3][1][2][3] + 128*B[3][1][2][4] + 1024*B[3][1][3][2] - 
     128*B[3][1][4][2] + 384*B[3][2][2][0] - 3072*B[3][2][2][1] + 3072*B[3][2][2][3] - 384*B[3][2][2][4] - 128*B[3][3][0][2] + 1024*B[3][3][1][2] - 128*B[3][3][2][0] + 1024*B[3][3][2][1] - 
     1024*B[3][3][2][3] + 128*B[3][3][2][4] - 1024*B[3][3][3][2] + 128*B[3][3][4][2] + 16*B[3][4][0][2] - 128*B[3][4][1][2] + 8*B[3][4][2][0] - 64*B[3][4][2][1] + 64*B[3][4][2][3] - 
     8*B[3][4][2][4] + 128*B[3][4][3][2] - 16*B[3][4][4][2] + B[4][0][0][2] - 8*B[4][0][1][2] - B[4][0][2][0] + 8*B[4][0][2][1] - 8*B[4][0][2][3] + B[4][0][2][4] + 8*B[4][0][3][2] - 
     B[4][0][4][2] - 8*B[4][1][0][2] + 64*B[4][1][1][2] + 16*B[4][1][2][0] - 128*B[4][1][2][1] + 128*B[4][1][2][3] - 16*B[4][1][2][4] - 64*B[4][1][3][2] + 8*B[4][1][4][2] - 
     102*B[4][2][2][0] + 816*B[4][2][2][1] - 816*B[4][2][2][3] + 102*B[4][2][2][4] + 8*B[4][3][0][2] - 64*B[4][3][1][2] + 16*B[4][3][2][0] - 128*B[4][3][2][1] + 128*B[4][3][2][3] - 
     16*B[4][3][2][4] + 64*B[4][3][3][2] - 8*B[4][3][4][2] - B[4][4][0][2] + 8*B[4][4][1][2] - B[4][4][2][0] + 8*B[4][4][2][1] - 8*B[4][4][2][3] + B[4][4][2][4] - 8*B[4][4][3][2] + B[4][4][4][2])
    /27648. ; 
	    val2101i = 1./(DW2*DW*DY)*(B[0][0][0][2] - 8*B[0][0][1][2] - B[0][0][2][0] + 8*B[0][0][2][1] - 8*B[0][0][2][3] + B[0][0][2][4] + 8*B[0][0][3][2] - B[0][0][4][2] - 8*B[0][1][0][2] + 64*B[0][1][1][2] + 16*B[0][1][2][0] - 
     128*B[0][1][2][1] + 128*B[0][1][2][3] - 16*B[0][1][2][4] - 64*B[0][1][3][2] + 8*B[0][1][4][2] - 102*B[0][2][2][0] + 816*B[0][2][2][1] - 816*B[0][2][2][3] + 102*B[0][2][2][4] + 
     8*B[0][3][0][2] - 64*B[0][3][1][2] + 16*B[0][3][2][0] - 128*B[0][3][2][1] + 128*B[0][3][2][3] - 16*B[0][3][2][4] + 64*B[0][3][3][2] - 8*B[0][3][4][2] - B[0][4][0][2] + 8*B[0][4][1][2] - 
     B[0][4][2][0] + 8*B[0][4][2][1] - 8*B[0][4][2][3] + B[0][4][2][4] - 8*B[0][4][3][2] + B[0][4][4][2] - 16*B[1][0][0][2] + 128*B[1][0][1][2] + 8*B[1][0][2][0] - 64*B[1][0][2][1] + 
     64*B[1][0][2][3] - 8*B[1][0][2][4] - 128*B[1][0][3][2] + 16*B[1][0][4][2] + 128*B[1][1][0][2] - 1024*B[1][1][1][2] - 128*B[1][1][2][0] + 1024*B[1][1][2][1] - 1024*B[1][1][2][3] + 
     128*B[1][1][2][4] + 1024*B[1][1][3][2] - 128*B[1][1][4][2] + 384*B[1][2][2][0] - 3072*B[1][2][2][1] + 3072*B[1][2][2][3] - 384*B[1][2][2][4] - 128*B[1][3][0][2] + 1024*B[1][3][1][2] - 
     128*B[1][3][2][0] + 1024*B[1][3][2][1] - 1024*B[1][3][2][3] + 128*B[1][3][2][4] - 1024*B[1][3][3][2] + 128*B[1][3][4][2] + 16*B[1][4][0][2] - 128*B[1][4][1][2] + 8*B[1][4][2][0] - 
     64*B[1][4][2][1] + 64*B[1][4][2][3] - 8*B[1][4][2][4] + 128*B[1][4][3][2] - 16*B[1][4][4][2] + 102*B[2][0][0][2] - 816*B[2][0][1][2] + 816*B[2][0][3][2] - 102*B[2][0][4][2] - 
     384*B[2][1][0][2] + 3072*B[2][1][1][2] - 3072*B[2][1][3][2] + 384*B[2][1][4][2] + 384*B[2][3][0][2] - 3072*B[2][3][1][2] + 3072*B[2][3][3][2] - 384*B[2][3][4][2] - 102*B[2][4][0][2] + 
     816*B[2][4][1][2] - 816*B[2][4][3][2] + 102*B[2][4][4][2] - 16*B[3][0][0][2] + 128*B[3][0][1][2] - 8*B[3][0][2][0] + 64*B[3][0][2][1] - 64*B[3][0][2][3] + 8*B[3][0][2][4] - 
     128*B[3][0][3][2] + 16*B[3][0][4][2] + 128*B[3][1][0][2] - 1024*B[3][1][1][2] + 128*B[3][1][2][0] - 1024*B[3][1][2][1] + 1024*B[3][1][2][3] - 128*B[3][1][2][4] + 1024*B[3][1][3][2] - 
     128*B[3][1][4][2] - 384*B[3][2][2][0] + 3072*B[3][2][2][1] - 3072*B[3][2][2][3] + 384*B[3][2][2][4] - 128*B[3][3][0][2] + 1024*B[3][3][1][2] + 128*B[3][3][2][0] - 1024*B[3][3][2][1] + 
     1024*B[3][3][2][3] - 128*B[3][3][2][4] - 1024*B[3][3][3][2] + 128*B[3][3][4][2] + 16*B[3][4][0][2] - 128*B[3][4][1][2] - 8*B[3][4][2][0] + 64*B[3][4][2][1] - 64*B[3][4][2][3] + 
     8*B[3][4][2][4] + 128*B[3][4][3][2] - 16*B[3][4][4][2] + B[4][0][0][2] - 8*B[4][0][1][2] + B[4][0][2][0] - 8*B[4][0][2][1] + 8*B[4][0][2][3] - B[4][0][2][4] + 8*B[4][0][3][2] - 
     B[4][0][4][2] - 8*B[4][1][0][2] + 64*B[4][1][1][2] - 16*B[4][1][2][0] + 128*B[4][1][2][1] - 128*B[4][1][2][3] + 16*B[4][1][2][4] - 64*B[4][1][3][2] + 8*B[4][1][4][2] + 
     102*B[4][2][2][0] - 816*B[4][2][2][1] + 816*B[4][2][2][3] - 102*B[4][2][2][4] + 8*B[4][3][0][2] - 64*B[4][3][1][2] - 16*B[4][3][2][0] + 128*B[4][3][2][1] - 128*B[4][3][2][3] + 
     16*B[4][3][2][4] + 64*B[4][3][3][2] - 8*B[4][3][4][2] - B[4][4][0][2] + 8*B[4][4][1][2] + B[4][4][2][0] - 8*B[4][4][2][1] + 8*B[4][4][2][3] - B[4][4][2][4] - 8*B[4][4][3][2] + B[4][4][4][2])
    /27648. ; 
	    val1021i = 1./(DW*DY2*DY)*(B[0][2][0][0] - 8*B[0][2][0][1] + 8*B[0][2][0][3] - B[0][2][0][4] - 16*B[0][2][1][0] + 128*B[0][2][1][1] - 128*B[0][2][1][3] + 16*B[0][2][1][4] + 102*B[0][2][2][0] - 384*B[0][2][2][1] + 
     384*B[0][2][2][3] - 102*B[0][2][2][4] - 16*B[0][2][3][0] + 128*B[0][2][3][1] - 128*B[0][2][3][3] + 16*B[0][2][3][4] + B[0][2][4][0] - 8*B[0][2][4][1] + 8*B[0][2][4][3] - B[0][2][4][4] - 
     8*B[1][2][0][0] + 64*B[1][2][0][1] - 64*B[1][2][0][3] + 8*B[1][2][0][4] + 128*B[1][2][1][0] - 1024*B[1][2][1][1] + 1024*B[1][2][1][3] - 128*B[1][2][1][4] - 816*B[1][2][2][0] + 
     3072*B[1][2][2][1] - 3072*B[1][2][2][3] + 816*B[1][2][2][4] + 128*B[1][2][3][0] - 1024*B[1][2][3][1] + 1024*B[1][2][3][3] - 128*B[1][2][3][4] - 8*B[1][2][4][0] + 64*B[1][2][4][1] - 
     64*B[1][2][4][3] + 8*B[1][2][4][4] + B[2][0][0][0] - 16*B[2][0][0][1] + 102*B[2][0][0][2] - 16*B[2][0][0][3] + B[2][0][0][4] - 8*B[2][0][1][0] + 128*B[2][0][1][1] - 384*B[2][0][1][2] + 
     128*B[2][0][1][3] - 8*B[2][0][1][4] + 8*B[2][0][3][0] - 128*B[2][0][3][1] + 384*B[2][0][3][2] - 128*B[2][0][3][3] + 8*B[2][0][3][4] - B[2][0][4][0] + 16*B[2][0][4][1] - 
     102*B[2][0][4][2] + 16*B[2][0][4][3] - B[2][0][4][4] - 8*B[2][1][0][0] + 128*B[2][1][0][1] - 816*B[2][1][0][2] + 128*B[2][1][0][3] - 8*B[2][1][0][4] + 64*B[2][1][1][0] - 
     1024*B[2][1][1][1] + 3072*B[2][1][1][2] - 1024*B[2][1][1][3] + 64*B[2][1][1][4] - 64*B[2][1][3][0] + 1024*B[2][1][3][1] - 3072*B[2][1][3][2] + 1024*B[2][1][3][3] - 64*B[2][1][3][4] + 
     8*B[2][1][4][0] - 128*B[2][1][4][1] + 816*B[2][1][4][2] - 128*B[2][1][4][3] + 8*B[2][1][4][4] + 8*B[2][3][0][0] - 128*B[2][3][0][1] + 816*B[2][3][0][2] - 128*B[2][3][0][3] + 
     8*B[2][3][0][4] - 64*B[2][3][1][0] + 1024*B[2][3][1][1] - 3072*B[2][3][1][2] + 1024*B[2][3][1][3] - 64*B[2][3][1][4] + 64*B[2][3][3][0] - 1024*B[2][3][3][1] + 3072*B[2][3][3][2] - 
     1024*B[2][3][3][3] + 64*B[2][3][3][4] - 8*B[2][3][4][0] + 128*B[2][3][4][1] - 816*B[2][3][4][2] + 128*B[2][3][4][3] - 8*B[2][3][4][4] - B[2][4][0][0] + 16*B[2][4][0][1] - 
     102*B[2][4][0][2] + 16*B[2][4][0][3] - B[2][4][0][4] + 8*B[2][4][1][0] - 128*B[2][4][1][1] + 384*B[2][4][1][2] - 128*B[2][4][1][3] + 8*B[2][4][1][4] - 8*B[2][4][3][0] + 
     128*B[2][4][3][1] - 384*B[2][4][3][2] + 128*B[2][4][3][3] - 8*B[2][4][3][4] + B[2][4][4][0] - 16*B[2][4][4][1] + 102*B[2][4][4][2] - 16*B[2][4][4][3] + B[2][4][4][4] + 8*B[3][2][0][0] - 
     64*B[3][2][0][1] + 64*B[3][2][0][3] - 8*B[3][2][0][4] - 128*B[3][2][1][0] + 1024*B[3][2][1][1] - 1024*B[3][2][1][3] + 128*B[3][2][1][4] + 816*B[3][2][2][0] - 3072*B[3][2][2][1] + 
     3072*B[3][2][2][3] - 816*B[3][2][2][4] - 128*B[3][2][3][0] + 1024*B[3][2][3][1] - 1024*B[3][2][3][3] + 128*B[3][2][3][4] + 8*B[3][2][4][0] - 64*B[3][2][4][1] + 64*B[3][2][4][3] - 
     8*B[3][2][4][4] - B[4][2][0][0] + 8*B[4][2][0][1] - 8*B[4][2][0][3] + B[4][2][0][4] + 16*B[4][2][1][0] - 128*B[4][2][1][1] + 128*B[4][2][1][3] - 16*B[4][2][1][4] - 102*B[4][2][2][0] + 
     384*B[4][2][2][1] - 384*B[4][2][2][3] + 102*B[4][2][2][4] + 16*B[4][2][3][0] - 128*B[4][2][3][1] + 128*B[4][2][3][3] - 16*B[4][2][3][4] - B[4][2][4][0] + 8*B[4][2][4][1] - 
     8*B[4][2][4][3] + B[4][2][4][4])/27648. ; 
	    val0121i = 1./(DW*DY2*DY)*(B[0][2][0][0] - 8*B[0][2][0][1] + 8*B[0][2][0][3] - B[0][2][0][4] - 16*B[0][2][1][0] + 128*B[0][2][1][1] - 128*B[0][2][1][3] + 16*B[0][2][1][4] + 102*B[0][2][2][0] - 384*B[0][2][2][1] + 
     384*B[0][2][2][3] - 102*B[0][2][2][4] - 16*B[0][2][3][0] + 128*B[0][2][3][1] - 128*B[0][2][3][3] + 16*B[0][2][3][4] + B[0][2][4][0] - 8*B[0][2][4][1] + 8*B[0][2][4][3] - B[0][2][4][4] - 
     8*B[1][2][0][0] + 64*B[1][2][0][1] - 64*B[1][2][0][3] + 8*B[1][2][0][4] + 128*B[1][2][1][0] - 1024*B[1][2][1][1] + 1024*B[1][2][1][3] - 128*B[1][2][1][4] - 816*B[1][2][2][0] + 
     3072*B[1][2][2][1] - 3072*B[1][2][2][3] + 816*B[1][2][2][4] + 128*B[1][2][3][0] - 1024*B[1][2][3][1] + 1024*B[1][2][3][3] - 128*B[1][2][3][4] - 8*B[1][2][4][0] + 64*B[1][2][4][1] - 
     64*B[1][2][4][3] + 8*B[1][2][4][4] - B[2][0][0][0] + 16*B[2][0][0][1] - 102*B[2][0][0][2] + 16*B[2][0][0][3] - B[2][0][0][4] + 8*B[2][0][1][0] - 128*B[2][0][1][1] + 384*B[2][0][1][2] - 
     128*B[2][0][1][3] + 8*B[2][0][1][4] - 8*B[2][0][3][0] + 128*B[2][0][3][1] - 384*B[2][0][3][2] + 128*B[2][0][3][3] - 8*B[2][0][3][4] + B[2][0][4][0] - 16*B[2][0][4][1] + 
     102*B[2][0][4][2] - 16*B[2][0][4][3] + B[2][0][4][4] + 8*B[2][1][0][0] - 128*B[2][1][0][1] + 816*B[2][1][0][2] - 128*B[2][1][0][3] + 8*B[2][1][0][4] - 64*B[2][1][1][0] + 
     1024*B[2][1][1][1] - 3072*B[2][1][1][2] + 1024*B[2][1][1][3] - 64*B[2][1][1][4] + 64*B[2][1][3][0] - 1024*B[2][1][3][1] + 3072*B[2][1][3][2] - 1024*B[2][1][3][3] + 64*B[2][1][3][4] - 
     8*B[2][1][4][0] + 128*B[2][1][4][1] - 816*B[2][1][4][2] + 128*B[2][1][4][3] - 8*B[2][1][4][4] - 8*B[2][3][0][0] + 128*B[2][3][0][1] - 816*B[2][3][0][2] + 128*B[2][3][0][3] - 
     8*B[2][3][0][4] + 64*B[2][3][1][0] - 1024*B[2][3][1][1] + 3072*B[2][3][1][2] - 1024*B[2][3][1][3] + 64*B[2][3][1][4] - 64*B[2][3][3][0] + 1024*B[2][3][3][1] - 3072*B[2][3][3][2] + 
     1024*B[2][3][3][3] - 64*B[2][3][3][4] + 8*B[2][3][4][0] - 128*B[2][3][4][1] + 816*B[2][3][4][2] - 128*B[2][3][4][3] + 8*B[2][3][4][4] + B[2][4][0][0] - 16*B[2][4][0][1] + 
     102*B[2][4][0][2] - 16*B[2][4][0][3] + B[2][4][0][4] - 8*B[2][4][1][0] + 128*B[2][4][1][1] - 384*B[2][4][1][2] + 128*B[2][4][1][3] - 8*B[2][4][1][4] + 8*B[2][4][3][0] - 
     128*B[2][4][3][1] + 384*B[2][4][3][2] - 128*B[2][4][3][3] + 8*B[2][4][3][4] - B[2][4][4][0] + 16*B[2][4][4][1] - 102*B[2][4][4][2] + 16*B[2][4][4][3] - B[2][4][4][4] + 8*B[3][2][0][0] - 
     64*B[3][2][0][1] + 64*B[3][2][0][3] - 8*B[3][2][0][4] - 128*B[3][2][1][0] + 1024*B[3][2][1][1] - 1024*B[3][2][1][3] + 128*B[3][2][1][4] + 816*B[3][2][2][0] - 3072*B[3][2][2][1] + 
     3072*B[3][2][2][3] - 816*B[3][2][2][4] - 128*B[3][2][3][0] + 1024*B[3][2][3][1] - 1024*B[3][2][3][3] + 128*B[3][2][3][4] + 8*B[3][2][4][0] - 64*B[3][2][4][1] + 64*B[3][2][4][3] - 
     8*B[3][2][4][4] - B[4][2][0][0] + 8*B[4][2][0][1] - 8*B[4][2][0][3] + B[4][2][0][4] + 16*B[4][2][1][0] - 128*B[4][2][1][1] + 128*B[4][2][1][3] - 16*B[4][2][1][4] - 102*B[4][2][2][0] + 
     384*B[4][2][2][1] - 384*B[4][2][2][3] + 102*B[4][2][2][4] + 16*B[4][2][3][0] - 128*B[4][2][3][1] + 128*B[4][2][3][3] - 16*B[4][2][3][4] - B[4][2][4][0] + 8*B[4][2][4][1] - 
     8*B[4][2][4][3] + B[4][2][4][4])/27648. ; 
	    val2011i = 1./(DW2*DY2)*(B[0][0][0][2] - 16*B[0][0][1][2] + B[0][0][2][0] - 16*B[0][0][2][1] + 60*B[0][0][2][2] - 16*B[0][0][2][3] + B[0][0][2][4] - 16*B[0][0][3][2] + B[0][0][4][2] - 8*B[0][1][0][2] + 
     128*B[0][1][1][2] - 8*B[0][1][2][0] + 128*B[0][1][2][1] - 480*B[0][1][2][2] + 128*B[0][1][2][3] - 8*B[0][1][2][4] + 128*B[0][1][3][2] - 8*B[0][1][4][2] + 8*B[0][3][0][2] - 
     128*B[0][3][1][2] + 8*B[0][3][2][0] - 128*B[0][3][2][1] + 480*B[0][3][2][2] - 128*B[0][3][2][3] + 8*B[0][3][2][4] - 128*B[0][3][3][2] + 8*B[0][3][4][2] - B[0][4][0][2] + 
     16*B[0][4][1][2] - B[0][4][2][0] + 16*B[0][4][2][1] - 60*B[0][4][2][2] + 16*B[0][4][2][3] - B[0][4][2][4] + 16*B[0][4][3][2] - B[0][4][4][2] - 8*B[1][0][0][2] + 128*B[1][0][1][2] - 
     8*B[1][0][2][0] + 128*B[1][0][2][1] - 480*B[1][0][2][2] + 128*B[1][0][2][3] - 8*B[1][0][2][4] + 128*B[1][0][3][2] - 8*B[1][0][4][2] + 64*B[1][1][0][2] - 1024*B[1][1][1][2] + 
     64*B[1][1][2][0] - 1024*B[1][1][2][1] + 3840*B[1][1][2][2] - 1024*B[1][1][2][3] + 64*B[1][1][2][4] - 1024*B[1][1][3][2] + 64*B[1][1][4][2] - 64*B[1][3][0][2] + 1024*B[1][3][1][2] - 
     64*B[1][3][2][0] + 1024*B[1][3][2][1] - 3840*B[1][3][2][2] + 1024*B[1][3][2][3] - 64*B[1][3][2][4] + 1024*B[1][3][3][2] - 64*B[1][3][4][2] + 8*B[1][4][0][2] - 128*B[1][4][1][2] + 
     8*B[1][4][2][0] - 128*B[1][4][2][1] + 480*B[1][4][2][2] - 128*B[1][4][2][3] + 8*B[1][4][2][4] - 128*B[1][4][3][2] + 8*B[1][4][4][2] + 8*B[3][0][0][2] - 128*B[3][0][1][2] + 
     8*B[3][0][2][0] - 128*B[3][0][2][1] + 480*B[3][0][2][2] - 128*B[3][0][2][3] + 8*B[3][0][2][4] - 128*B[3][0][3][2] + 8*B[3][0][4][2] - 64*B[3][1][0][2] + 1024*B[3][1][1][2] - 
     64*B[3][1][2][0] + 1024*B[3][1][2][1] - 3840*B[3][1][2][2] + 1024*B[3][1][2][3] - 64*B[3][1][2][4] + 1024*B[3][1][3][2] - 64*B[3][1][4][2] + 64*B[3][3][0][2] - 1024*B[3][3][1][2] + 
     64*B[3][3][2][0] - 1024*B[3][3][2][1] + 3840*B[3][3][2][2] - 1024*B[3][3][2][3] + 64*B[3][3][2][4] - 1024*B[3][3][3][2] + 64*B[3][3][4][2] - 8*B[3][4][0][2] + 128*B[3][4][1][2] - 
     8*B[3][4][2][0] + 128*B[3][4][2][1] - 480*B[3][4][2][2] + 128*B[3][4][2][3] - 8*B[3][4][2][4] + 128*B[3][4][3][2] - 8*B[3][4][4][2] - B[4][0][0][2] + 16*B[4][0][1][2] - B[4][0][2][0] + 
     16*B[4][0][2][1] - 60*B[4][0][2][2] + 16*B[4][0][2][3] - B[4][0][2][4] + 16*B[4][0][3][2] - B[4][0][4][2] + 8*B[4][1][0][2] - 128*B[4][1][1][2] + 8*B[4][1][2][0] - 128*B[4][1][2][1] + 
     480*B[4][1][2][2] - 128*B[4][1][2][3] + 8*B[4][1][2][4] - 128*B[4][1][3][2] + 8*B[4][1][4][2] - 8*B[4][3][0][2] + 128*B[4][3][1][2] - 8*B[4][3][2][0] + 128*B[4][3][2][1] - 
     480*B[4][3][2][2] + 128*B[4][3][2][3] - 8*B[4][3][2][4] + 128*B[4][3][3][2] - 8*B[4][3][4][2] + B[4][4][0][2] - 16*B[4][4][1][2] + B[4][4][2][0] - 16*B[4][4][2][1] + 60*B[4][4][2][2] - 
     16*B[4][4][2][3] + B[4][4][2][4] - 16*B[4][4][3][2] + B[4][4][4][2])/13824. ; 
	    val1120i = 1./(DW2*DY2)*(B[0][2][0][0] - 8*B[0][2][0][1] + 8*B[0][2][0][3] - B[0][2][0][4] - 8*B[0][2][1][0] + 64*B[0][2][1][1] - 64*B[0][2][1][3] + 8*B[0][2][1][4] + 8*B[0][2][3][0] - 64*B[0][2][3][1] + 
     64*B[0][2][3][3] - 8*B[0][2][3][4] - B[0][2][4][0] + 8*B[0][2][4][1] - 8*B[0][2][4][3] + B[0][2][4][4] - 16*B[1][2][0][0] + 128*B[1][2][0][1] - 128*B[1][2][0][3] + 16*B[1][2][0][4] + 
     128*B[1][2][1][0] - 1024*B[1][2][1][1] + 1024*B[1][2][1][3] - 128*B[1][2][1][4] - 128*B[1][2][3][0] + 1024*B[1][2][3][1] - 1024*B[1][2][3][3] + 128*B[1][2][3][4] + 16*B[1][2][4][0] - 
     128*B[1][2][4][1] + 128*B[1][2][4][3] - 16*B[1][2][4][4] + B[2][0][0][0] - 8*B[2][0][0][1] + 8*B[2][0][0][3] - B[2][0][0][4] - 8*B[2][0][1][0] + 64*B[2][0][1][1] - 64*B[2][0][1][3] + 
     8*B[2][0][1][4] + 8*B[2][0][3][0] - 64*B[2][0][3][1] + 64*B[2][0][3][3] - 8*B[2][0][3][4] - B[2][0][4][0] + 8*B[2][0][4][1] - 8*B[2][0][4][3] + B[2][0][4][4] - 16*B[2][1][0][0] + 
     128*B[2][1][0][1] - 128*B[2][1][0][3] + 16*B[2][1][0][4] + 128*B[2][1][1][0] - 1024*B[2][1][1][1] + 1024*B[2][1][1][3] - 128*B[2][1][1][4] - 128*B[2][1][3][0] + 1024*B[2][1][3][1] - 
     1024*B[2][1][3][3] + 128*B[2][1][3][4] + 16*B[2][1][4][0] - 128*B[2][1][4][1] + 128*B[2][1][4][3] - 16*B[2][1][4][4] + 60*B[2][2][0][0] - 480*B[2][2][0][1] + 480*B[2][2][0][3] - 
     60*B[2][2][0][4] - 480*B[2][2][1][0] + 3840*B[2][2][1][1] - 3840*B[2][2][1][3] + 480*B[2][2][1][4] + 480*B[2][2][3][0] - 3840*B[2][2][3][1] + 3840*B[2][2][3][3] - 480*B[2][2][3][4] - 
     60*B[2][2][4][0] + 480*B[2][2][4][1] - 480*B[2][2][4][3] + 60*B[2][2][4][4] - 16*B[2][3][0][0] + 128*B[2][3][0][1] - 128*B[2][3][0][3] + 16*B[2][3][0][4] + 128*B[2][3][1][0] - 
     1024*B[2][3][1][1] + 1024*B[2][3][1][3] - 128*B[2][3][1][4] - 128*B[2][3][3][0] + 1024*B[2][3][3][1] - 1024*B[2][3][3][3] + 128*B[2][3][3][4] + 16*B[2][3][4][0] - 128*B[2][3][4][1] + 
     128*B[2][3][4][3] - 16*B[2][3][4][4] + B[2][4][0][0] - 8*B[2][4][0][1] + 8*B[2][4][0][3] - B[2][4][0][4] - 8*B[2][4][1][0] + 64*B[2][4][1][1] - 64*B[2][4][1][3] + 8*B[2][4][1][4] + 
     8*B[2][4][3][0] - 64*B[2][4][3][1] + 64*B[2][4][3][3] - 8*B[2][4][3][4] - B[2][4][4][0] + 8*B[2][4][4][1] - 8*B[2][4][4][3] + B[2][4][4][4] - 16*B[3][2][0][0] + 128*B[3][2][0][1] - 
     128*B[3][2][0][3] + 16*B[3][2][0][4] + 128*B[3][2][1][0] - 1024*B[3][2][1][1] + 1024*B[3][2][1][3] - 128*B[3][2][1][4] - 128*B[3][2][3][0] + 1024*B[3][2][3][1] - 1024*B[3][2][3][3] + 
     128*B[3][2][3][4] + 16*B[3][2][4][0] - 128*B[3][2][4][1] + 128*B[3][2][4][3] - 16*B[3][2][4][4] + B[4][2][0][0] - 8*B[4][2][0][1] + 8*B[4][2][0][3] - B[4][2][0][4] - 8*B[4][2][1][0] + 
     64*B[4][2][1][1] - 64*B[4][2][1][3] + 8*B[4][2][1][4] + 8*B[4][2][3][0] - 64*B[4][2][3][1] + 64*B[4][2][3][3] - 8*B[4][2][3][4] - B[4][2][4][0] + 8*B[4][2][4][1] - 8*B[4][2][4][3] + 
     B[4][2][4][4])/13824. ; 
	    val1111i = 0. ;

	  }


	  K1100 = complex<double>(val1100r,val1100i) ; 
	  K0011 = complex<double>(val0011r,val0011i) ; 
	  K0110 = complex<double>(val0110r,val0110i) ; 
	  K1011 = complex<double>(val1011r,val1011i) ; 
	  K1110 = complex<double>(val1110r,val1110i) ; 
	  K1002 = complex<double>(val1002r,val1002i) ; 
	  K0012 = complex<double>(val0012r,val0012i) ; 
	  K2001 = complex<double>(val2001r,val2001i) ; 
	  K2100 = complex<double>(val2100r,val2100i) ;
	  K3001 = complex<double>(val3001r,val3001i) ; 
	  K3100 = complex<double>(val3100r,val3100i) ; 
	  K1003 = complex<double>(val1003r,val1003i) ; 
	  K0031 = complex<double>(val0031r,val0031i) ; 
	  K2200 = complex<double>(val2200r,val2200i) ; 
	  K0022 = complex<double>(val0022r,val0022i) ; 
	  K0220 = complex<double>(val0220r,val0220i) ; 
	  K2110 = complex<double>(val2110r,val2110i) ; 
	  K2101 = complex<double>(val2101r,val2101i) ; 
	  K1021 = complex<double>(val1021r,val1021i) ; 
	  K0121 = complex<double>(val0121r,val0121i) ; 
	  K2011 = complex<double>(val2011r,val2011i) ; 
	  K1120 = complex<double>(val1120r,val1120i) ; 
	  K1111 = complex<double>(val1111r,val1111i) ;

	  K1100c = conj(K1100) ;
	  K0011c = conj(K0011) ;
	  K0110c = conj(K0110) ;
	  K1011c = conj(K1011) ;
	  K1110c = conj(K1110) ;
	  K1002c = conj(K1002) ;
	  K0012c = conj(K0012) ;
	  K2001c = conj(K2001) ;
	  K2100c = conj(K2100) ;
	  K3001c = conj(K3001) ;
	  K3100c = conj(K3100) ;
	  K1003c = conj(K1003) ;
	  K0031c = conj(K0031) ;
	  K2200c = conj(K2200) ;
	  K0022c = conj(K0022) ;
	  K0220c = conj(K0220) ;
	  K2110c = conj(K2110) ;
	  K2101c = conj(K2101) ;
	  K1021c = conj(K1021) ;
	  K0121c = conj(K0121) ;
	  K2011c = conj(K2011) ;
	  K1120c = conj(K1120) ;
	  K1111c = conj(K1111) ;



	  R2dww = 2.*( K2100*K2100c - K1100*K2200 )/pow(K1100,3) ;
	  R2dyy = 2.*( K0012*K0012c - K0011*K0022 )/pow(K0011,3) ;



	  Rwwww = K0110*(K1011*K1110c - K0110c*K1111 - K1011c*K2001 + K0011*K2101) + K0011*(K2001*K2001c - K1011*K2100c + K0110c*K2101c - K0011*K2200) ;

	  Rwwwy = K0011*(-(K2001c*K2100) + K1110*K2100c - K1100*K2101c) + K0110*(-(K1110*K1110c) + K1100*K1111 + K1011c*K2100 + K0011*K2200) - K2101*pow(K0110,2) ;

	  Rwwyw = -(K1100*(K1011*K1110c - K0110c*K1111 - K1011c*K2001 + K0011*K2101)) + K0110c*(-(K2001*K2001c) + K1011*K2100c - K0110c*K2101c + K0011*K2200) ;

	  Rwwyy = K1100*(K1110*K1110c - K1011c*K2100 + K0110*K2101 + K0110c*K2101c) - K0110c*(-(K2001c*K2100) + K1110*K2100c + K0110*K2200) - K1111*pow(K1100,2) ;


	  Rwyww = K0110*(-(K0110c*K0121c) + K0011*K0220c + K1002*K1011 - K0012*K2001) + K0011*(-(K1011*K1110c) + K0110c*K1111 + K1011c*K2001 - K0011*K2101) ;

	  Rwywy = K0011*(K1110*K1110c - K1100*K1111 - K1011c*K2100) + K0110*(K0121c*K1100 - K1002*K1110 + K0012*K2100 + K0011*K2101) - K0220c*pow(K0110,2) ;

	  Rwyyw = -(K1100*(-(K0110c*K0121c) + K0011*K0220c + K1002*K1011 - K0012*K2001)) + K0110c*(K1011*K1110c - K0110c*K1111 - K1011c*K2001 + K0011*K2101) ;

	  Rwyyy = -(K1100*(-(K0110*K0220c) + K0121c*K1100 - K1002*K1110 + K0012*K2100)) + K0110c*(-(K1110*K1110c) + K1100*K1111 + K1011c*K2100 - K0110*K2101) ;


	  Rywww = K0110*(-(K0110c*K0121) - K1011*K1011c + K0012c*K1110c + K0011*K1111) + K0011*(K0110c*K0220 + K1011*K2001c - K0012c*K2100c - K0011*K2101c) ;

	  Rywwy = -(K0011*(K0220*K1100 + K1110*K2001c - K1002c*K2100c)) + K0110*(K0121*K1100 + K1011c*K1110 - K1002c*K1110c + K0011*K2101c) - K1111*pow(K0110,2) ;

	  Rywyw = K1100*(K0110c*K0121 + K1011*K1011c - K0012c*K1110c - K0011*K1111) + K0110c*(-(K0110c*K0220) - K1011*K2001c + K0012c*K2100c + K0011*K2101c) ;

	  Rywyy = -(K1100*(K0121*K1100 + K1011c*K1110 - K1002c*K1110c - K0110*K1111)) + K0110c*(K0220*K1100 + K1110*K2001c - K1002c*K2100c - K0110*K2101c) ;


	  Ryyww = K0110*(-(K0022*K0110c) + K0011*K0121c + K0012c*K1002 - K0012*K1011) - K0011*(-(K0110c*K0121) - K1011*K1011c + K0012c*K1110c + K0011*K1111) ;

	  Ryywy = -(K0011*(K0121*K1100 + K1011c*K1110 - K1002c*K1110c)) + K0110*(-(K1002*K1002c) + K0022*K1100 + K0012*K1110 + K0011*K1111) - K0121c*pow(K0110,2) ;

	  Ryyyw = (K0022*K0110c - K0011*K0121c - K0012c*K1002 + K0012*K1011)*K1100 + K0110c*(-(K0110c*K0121) - K1011*K1011c + K0012c*K1110c + K0011*K1111) ;

	  Ryyyy = -(K1100*(-(K0110*K0121c) - K1002*K1002c + K0022*K1100 + K0012*K1110)) + K0110c*(K0121*K1100 + K1011c*K1110 - K1002c*K1110c - K0110*K1111) ; 




	  Kretch = 4.*(Rwwww*Rwwww + Rwwwy*Rwyww + Rwwyw*Rywww + Rwwyy*Ryyww + Rwyww*Rwwwy + Rwywy*Rwywy + Rwyyw*Rywwy + Rwyyy*Ryywy + Rywww*Rwwyw + Rywwy*Rwyyw + Rywyw*Rywyw + Rywyy*Ryyyw + Ryyww*Rwwyy + Ryywy*Rwyyy + Ryyyw*Rywyy + Ryyyy*Ryyyy) ;



	  Kretch *= (1/pow(rootdetg,4)) ;


	  valarr[0] = Kretch.real() ;
	  valarr[1] = R2dyy.real()  ;
	  valarr[2] = R2dww.real()  ;

}



void calcKderiv2point(int z1rein, int z1imin, int z2rein, int z2imin)
{
  int z1re, z1im, z2re, z2im ;

  double val1100r, val0011r, val0110r, val1011r, val1110r, val1002r, val0012r, val2001r, val2100r ;
  double val1100i, val0011i, val0110i, val1011i, val1110i, val1002i, val0012i, val2001i, val2100i ;

  double val3001r, val3100r, val1003r, val0031r, val2200r, val0022r, val0220r, val2110r, val2101r, val1021r, val0121r, val2011r, val1120r, val1111r ;
  double val3001i, val3100i, val1003i, val0031i, val2200i, val0022i, val0220i, val2110i, val2101i, val1021i, val0121i, val2011i, val1120i, val1111i ;

  double DZ2 = DZ*DZ, DZ3 = DZ*DZ*DZ, DZ4 = DZ*DZ*DZ*DZ ;

  complex<double> K1100, K0011, K0110, K1011, K1110, K1002, K0012, K2001, K2100 ;
  complex<double> K1100c, K0011c, K0110c, K1011c, K1110c, K1002c, K0012c, K2001c, K2100c ;
  complex<double> K3001, K3100, K1003, K0031, K2200, K0022, K0220, K2110, K2101, K1021, K0121, K2011, K1120, K1111 ;
  complex<double> K3001c, K3100c, K1003c, K0031c, K2200c, K0022c, K0220c, K2110c, K2101c, K1021c, K0121c, K2011c, K1120c, K1111c ;

  complex<double> Rww, Ryy, Rwy ;

  complex<double> Rwwww, Rwwwy, Rwwyw, Rwwyy, Rwyww, Rwywy, Rwyyw, Rwyyy, Rywww, Rywwy, Rywyw, Rywyy, Ryyww, Ryywy, Ryyyw, Ryyyy ;

  complex<double> R2dzz ;

  complex<double> Kretch ;

  int i1,i2,i3,i4 ;


  z1re = z1rein ; z1im = z1imin ; z2re = z2rein ; z2im = z2imin ;
  reflectZ(&z1re,&z1im,&z2re,&z2im) ;

	  if( ( pow(abs(coord_z1(z1re,z1im)),2) + pow(abs(coord_z2(z2re,z2im)),2) ) < MINSIG )  {
	    
	    val1100r = 0. ; 
	    val0011r = 0. ; 
	    val0110r = 0. ; 
	    val1011r = 0. ; 
	    val1110r = 0. ; 
	    val1002r = 0. ; 
	    val0012r = 0. ; 
	    val2001r = 0. ; 
	    val2100r = 0. ;
	    val3001r = 0. ; 
	    val3100r = 0. ; 
	    val1003r = 0. ; 
	    val0031r = 0. ; 
	    val2200r = 0. ; 
	    val0022r = 0. ; 
	    val0220r = 0. ; 
	    val2110r = 0. ; 
	    val2101r = 0. ; 
	    val1021r = 0. ; 
	    val0121r = 0. ; 
	    val2011r = 0. ; 
	    val1120r = 0. ; 
	    val1111r = 0. ;

	    val1100i = 0. ; 
	    val0011i = 0. ; 
	    val0110i = 0. ; 
	    val1011i = 0. ; 
	    val1110i = 0. ; 
	    val1002i = 0. ; 
	    val0012i = 0. ; 
	    val2001i = 0. ; 
	    val2100i = 0. ;
	    val3001i = 0. ; 
	    val3100i = 0. ; 
	    val1003i = 0. ; 
	    val0031i = 0. ; 
	    val2200i = 0. ; 
	    val0022i = 0. ; 
	    val0220i = 0. ; 
	    val2110i = 0. ; 
	    val2101i = 0. ; 
	    val1021i = 0. ; 
	    val0121i = 0. ; 
	    val2011i = 0. ; 
	    val1120i = 0. ; 
	    val1111i = 0. ;

	  } else {

	    for(i1=0;i1<5;i1++) {
	      for(i2=0;i2<5;i2++) {
		for(i3=0;i3<5;i3++) {
		  for(i4=0;i4<5;i4++) {
		
		    B[i1][i2][i3][i4] = getK2(z1re+i1-2,z1im+i2-2,z2re+i3-2,z2im+i4-2) ;
    
		  }
		}
	      }
	    }

	    val1100r = 1./(DZ2)*(-B[0][2][2][2] + 16*B[1][2][2][2] - B[2][0][2][2] + 16*B[2][1][2][2] - 60*B[2][2][2][2] + 16*B[2][3][2][2] - B[2][4][2][2] + 16*B[3][2][2][2] - B[4][2][2][2])/48. ; 
	    val0011r = 1./(DZ2)*(-B[2][2][0][2] + 16*B[2][2][1][2] - B[2][2][2][0] + 16*B[2][2][2][1] - 60*B[2][2][2][2] + 16*B[2][2][2][3] - B[2][2][2][4] + 16*B[2][2][3][2] - B[2][2][4][2])/48. ; 
	    val0110r = 1./(DZ2)*(B[0][2][0][2] - 8*B[0][2][1][2] + 8*B[0][2][3][2] - B[0][2][4][2] - 8*B[1][2][0][2] + 64*B[1][2][1][2] - 64*B[1][2][3][2] + 8*B[1][2][4][2] + B[2][0][2][0] - 8*B[2][0][2][1] + 8*B[2][0][2][3] - 
     B[2][0][2][4] - 8*B[2][1][2][0] + 64*B[2][1][2][1] - 64*B[2][1][2][3] + 8*B[2][1][2][4] + 8*B[2][3][2][0] - 64*B[2][3][2][1] + 64*B[2][3][2][3] - 8*B[2][3][2][4] - B[2][4][2][0] + 
     8*B[2][4][2][1] - 8*B[2][4][2][3] + B[2][4][2][4] + 8*B[3][2][0][2] - 64*B[3][2][1][2] + 64*B[3][2][3][2] - 8*B[3][2][4][2] - B[4][2][0][2] + 8*B[4][2][1][2] - 8*B[4][2][3][2] + 
     B[4][2][4][2])/576. ; 
	    val1011r = 1./(DZ3)*(-B[0][2][0][2] + 16*B[0][2][1][2] - B[0][2][2][0] + 16*B[0][2][2][1] - 60*B[0][2][2][2] + 16*B[0][2][2][3] - B[0][2][2][4] + 16*B[0][2][3][2] - B[0][2][4][2] + 8*B[1][2][0][2] - 
     128*B[1][2][1][2] + 8*B[1][2][2][0] - 128*B[1][2][2][1] + 480*B[1][2][2][2] - 128*B[1][2][2][3] + 8*B[1][2][2][4] - 128*B[1][2][3][2] + 8*B[1][2][4][2] - 8*B[3][2][0][2] + 
     128*B[3][2][1][2] - 8*B[3][2][2][0] + 128*B[3][2][2][1] - 480*B[3][2][2][2] + 128*B[3][2][2][3] - 8*B[3][2][2][4] + 128*B[3][2][3][2] - 8*B[3][2][4][2] + B[4][2][0][2] - 
     16*B[4][2][1][2] + B[4][2][2][0] - 16*B[4][2][2][1] + 60*B[4][2][2][2] - 16*B[4][2][2][3] + B[4][2][2][4] - 16*B[4][2][3][2] + B[4][2][4][2])/1152. ; 
	    val1110r = 1./(DZ3)*(-B[0][2][0][2] + 8*B[0][2][1][2] - 8*B[0][2][3][2] + B[0][2][4][2] + 16*B[1][2][0][2] - 128*B[1][2][1][2] + 128*B[1][2][3][2] - 16*B[1][2][4][2] - B[2][0][0][2] + 8*B[2][0][1][2] - 
     8*B[2][0][3][2] + B[2][0][4][2] + 16*B[2][1][0][2] - 128*B[2][1][1][2] + 128*B[2][1][3][2] - 16*B[2][1][4][2] - 60*B[2][2][0][2] + 480*B[2][2][1][2] - 480*B[2][2][3][2] + 
     60*B[2][2][4][2] + 16*B[2][3][0][2] - 128*B[2][3][1][2] + 128*B[2][3][3][2] - 16*B[2][3][4][2] - B[2][4][0][2] + 8*B[2][4][1][2] - 8*B[2][4][3][2] + B[2][4][4][2] + 16*B[3][2][0][2] - 
     128*B[3][2][1][2] + 128*B[3][2][3][2] - 16*B[3][2][4][2] - B[4][2][0][2] + 8*B[4][2][1][2] - 8*B[4][2][3][2] + B[4][2][4][2])/1152. ; 
	    val1002r = 1./(DZ3)*(-6*B[0][2][0][2] + 96*B[0][2][1][2] + 6*B[0][2][2][0] - 96*B[0][2][2][1] - 96*B[0][2][2][3] + 6*B[0][2][2][4] + 96*B[0][2][3][2] - 6*B[0][2][4][2] + 48*B[1][2][0][2] - 768*B[1][2][1][2] - 
     48*B[1][2][2][0] + 768*B[1][2][2][1] + 768*B[1][2][2][3] - 48*B[1][2][2][4] - 768*B[1][2][3][2] + 48*B[1][2][4][2] + B[2][0][0][0] - 8*B[2][0][0][1] + 8*B[2][0][0][3] - B[2][0][0][4] - 
     8*B[2][0][1][0] + 64*B[2][0][1][1] - 64*B[2][0][1][3] + 8*B[2][0][1][4] + 8*B[2][0][3][0] - 64*B[2][0][3][1] + 64*B[2][0][3][3] - 8*B[2][0][3][4] - B[2][0][4][0] + 8*B[2][0][4][1] - 
     8*B[2][0][4][3] + B[2][0][4][4] - 8*B[2][1][0][0] + 64*B[2][1][0][1] - 64*B[2][1][0][3] + 8*B[2][1][0][4] + 64*B[2][1][1][0] - 512*B[2][1][1][1] + 512*B[2][1][1][3] - 64*B[2][1][1][4] - 
     64*B[2][1][3][0] + 512*B[2][1][3][1] - 512*B[2][1][3][3] + 64*B[2][1][3][4] + 8*B[2][1][4][0] - 64*B[2][1][4][1] + 64*B[2][1][4][3] - 8*B[2][1][4][4] + 8*B[2][3][0][0] - 
     64*B[2][3][0][1] + 64*B[2][3][0][3] - 8*B[2][3][0][4] - 64*B[2][3][1][0] + 512*B[2][3][1][1] - 512*B[2][3][1][3] + 64*B[2][3][1][4] + 64*B[2][3][3][0] - 512*B[2][3][3][1] + 
     512*B[2][3][3][3] - 64*B[2][3][3][4] - 8*B[2][3][4][0] + 64*B[2][3][4][1] - 64*B[2][3][4][3] + 8*B[2][3][4][4] - B[2][4][0][0] + 8*B[2][4][0][1] - 8*B[2][4][0][3] + B[2][4][0][4] + 
     8*B[2][4][1][0] - 64*B[2][4][1][1] + 64*B[2][4][1][3] - 8*B[2][4][1][4] - 8*B[2][4][3][0] + 64*B[2][4][3][1] - 64*B[2][4][3][3] + 8*B[2][4][3][4] + B[2][4][4][0] - 8*B[2][4][4][1] + 
     8*B[2][4][4][3] - B[2][4][4][4] - 6*(8*B[3][2][0][2] - 128*B[3][2][1][2] - 8*B[3][2][2][0] + 128*B[3][2][2][1] + 128*B[3][2][2][3] - 8*B[3][2][2][4] - 128*B[3][2][3][2] + 
        8*B[3][2][4][2] - B[4][2][0][2] + 16*B[4][2][1][2] + B[4][2][2][0] - 16*B[4][2][2][1] - 16*B[4][2][2][3] + B[4][2][2][4] + 16*B[4][2][3][2] - B[4][2][4][2]))/6912. ; 
	    val0012r = 1./(DZ3)*(-B[2][2][0][0] + 16*B[2][2][0][1] - 102*B[2][2][0][2] + 16*B[2][2][0][3] - B[2][2][0][4] + 8*B[2][2][1][0] - 128*B[2][2][1][1] + 384*B[2][2][1][2] - 128*B[2][2][1][3] + 8*B[2][2][1][4] - 
     8*B[2][2][3][0] + 128*B[2][2][3][1] - 384*B[2][2][3][2] + 128*B[2][2][3][3] - 8*B[2][2][3][4] + B[2][2][4][0] - 16*B[2][2][4][1] + 102*B[2][2][4][2] - 16*B[2][2][4][3] + B[2][2][4][4])/
   1152. ; 
	    val2001r = 1./(DZ3)*(B[0][0][2][0] - 8*B[0][0][2][1] + 8*B[0][0][2][3] - B[0][0][2][4] - 8*B[0][1][2][0] + 64*B[0][1][2][1] - 64*B[0][1][2][3] + 8*B[0][1][2][4] - 6*B[0][2][0][2] + 48*B[0][2][1][2] - 
     48*B[0][2][3][2] + 6*B[0][2][4][2] + 8*B[0][3][2][0] - 64*B[0][3][2][1] + 64*B[0][3][2][3] - 8*B[0][3][2][4] - B[0][4][2][0] + 8*B[0][4][2][1] - 8*B[0][4][2][3] + B[0][4][2][4] - 
     8*B[1][0][2][0] + 64*B[1][0][2][1] - 64*B[1][0][2][3] + 8*B[1][0][2][4] + 64*B[1][1][2][0] - 512*B[1][1][2][1] + 512*B[1][1][2][3] - 64*B[1][1][2][4] + 96*B[1][2][0][2] - 
     768*B[1][2][1][2] + 768*B[1][2][3][2] - 96*B[1][2][4][2] - 64*B[1][3][2][0] + 512*B[1][3][2][1] - 512*B[1][3][2][3] + 64*B[1][3][2][4] + 8*B[1][4][2][0] - 64*B[1][4][2][1] + 
     64*B[1][4][2][3] - 8*B[1][4][2][4] + 6*B[2][0][0][2] - 48*B[2][0][1][2] + 48*B[2][0][3][2] - 6*B[2][0][4][2] - 96*B[2][1][0][2] + 768*B[2][1][1][2] - 768*B[2][1][3][2] + 
     96*B[2][1][4][2] - 96*B[2][3][0][2] + 768*B[2][3][1][2] - 768*B[2][3][3][2] + 96*B[2][3][4][2] + 6*B[2][4][0][2] - 48*B[2][4][1][2] + 48*B[2][4][3][2] - 6*B[2][4][4][2] + 
     8*B[3][0][2][0] - 64*B[3][0][2][1] + 64*B[3][0][2][3] - 8*B[3][0][2][4] - 64*B[3][1][2][0] + 512*B[3][1][2][1] - 512*B[3][1][2][3] + 64*B[3][1][2][4] + 96*B[3][2][0][2] - 
     768*B[3][2][1][2] + 768*B[3][2][3][2] - 96*B[3][2][4][2] + 64*B[3][3][2][0] - 512*B[3][3][2][1] + 512*B[3][3][2][3] - 64*B[3][3][2][4] - 8*B[3][4][2][0] + 64*B[3][4][2][1] - 
     64*B[3][4][2][3] + 8*B[3][4][2][4] - B[4][0][2][0] + 8*B[4][0][2][1] - 8*B[4][0][2][3] + B[4][0][2][4] + 8*B[4][1][2][0] - 64*B[4][1][2][1] + 64*B[4][1][2][3] - 8*B[4][1][2][4] - 
     6*B[4][2][0][2] + 48*B[4][2][1][2] - 48*B[4][2][3][2] + 6*B[4][2][4][2] - 8*B[4][3][2][0] + 64*B[4][3][2][1] - 64*B[4][3][2][3] + 8*B[4][3][2][4] + B[4][4][2][0] - 8*B[4][4][2][1] + 
     8*B[4][4][2][3] - B[4][4][2][4])/6912. ; 
	    val2100r = 1./(DZ3)*(-B[0][0][2][2] + 16*B[0][1][2][2] - 102*B[0][2][2][2] + 16*B[0][3][2][2] - B[0][4][2][2] + 8*B[1][0][2][2] - 128*B[1][1][2][2] + 384*B[1][2][2][2] - 128*B[1][3][2][2] + 8*B[1][4][2][2] - 
     8*B[3][0][2][2] + 128*B[3][1][2][2] - 384*B[3][2][2][2] + 128*B[3][3][2][2] - 8*B[3][4][2][2] + B[4][0][2][2] - 16*B[4][1][2][2] + 102*B[4][2][2][2] - 16*B[4][3][2][2] + B[4][4][2][2])/
   1152. ;
	    val3001r = 1./(DZ4)*(B[0][0][0][2] - 8*B[0][0][1][2] - B[0][0][2][0] + 8*B[0][0][2][1] - 8*B[0][0][2][3] + B[0][0][2][4] + 8*B[0][0][3][2] - B[0][0][4][2] - 16*B[0][1][0][2] + 128*B[0][1][1][2] + 8*B[0][1][2][0] - 
     64*B[0][1][2][1] + 64*B[0][1][2][3] - 8*B[0][1][2][4] - 128*B[0][1][3][2] + 16*B[0][1][4][2] + 6*B[0][2][0][2] - 48*B[0][2][1][2] + 48*B[0][2][3][2] - 6*B[0][2][4][2] - 
     16*B[0][3][0][2] + 128*B[0][3][1][2] - 8*B[0][3][2][0] + 64*B[0][3][2][1] - 64*B[0][3][2][3] + 8*B[0][3][2][4] - 128*B[0][3][3][2] + 16*B[0][3][4][2] + B[0][4][0][2] - 8*B[0][4][1][2] + 
     B[0][4][2][0] - 8*B[0][4][2][1] + 8*B[0][4][2][3] - B[0][4][2][4] + 8*B[0][4][3][2] - B[0][4][4][2] - 8*B[1][0][0][2] + 64*B[1][0][1][2] + 16*B[1][0][2][0] - 128*B[1][0][2][1] + 
     128*B[1][0][2][3] - 16*B[1][0][2][4] - 64*B[1][0][3][2] + 8*B[1][0][4][2] + 128*B[1][1][0][2] - 1024*B[1][1][1][2] - 128*B[1][1][2][0] + 1024*B[1][1][2][1] - 1024*B[1][1][2][3] + 
     128*B[1][1][2][4] + 1024*B[1][1][3][2] - 128*B[1][1][4][2] - 192*B[1][2][0][2] + 1536*B[1][2][1][2] - 1536*B[1][2][3][2] + 192*B[1][2][4][2] + 128*B[1][3][0][2] - 1024*B[1][3][1][2] + 
     128*B[1][3][2][0] - 1024*B[1][3][2][1] + 1024*B[1][3][2][3] - 128*B[1][3][2][4] + 1024*B[1][3][3][2] - 128*B[1][3][4][2] - 8*B[1][4][0][2] + 64*B[1][4][1][2] - 16*B[1][4][2][0] + 
     128*B[1][4][2][1] - 128*B[1][4][2][3] + 16*B[1][4][2][4] - 64*B[1][4][3][2] + 8*B[1][4][4][2] - 6*B[2][0][2][0] + 48*B[2][0][2][1] - 48*B[2][0][2][3] + 6*B[2][0][2][4] + 
     192*B[2][1][2][0] - 1536*B[2][1][2][1] + 1536*B[2][1][2][3] - 192*B[2][1][2][4] - 192*B[2][3][2][0] + 1536*B[2][3][2][1] - 1536*B[2][3][2][3] + 192*B[2][3][2][4] + 6*B[2][4][2][0] - 
     48*B[2][4][2][1] + 48*B[2][4][2][3] - 6*B[2][4][2][4] + 8*B[3][0][0][2] - 64*B[3][0][1][2] + 16*B[3][0][2][0] - 128*B[3][0][2][1] + 128*B[3][0][2][3] - 16*B[3][0][2][4] + 
     64*B[3][0][3][2] - 8*B[3][0][4][2] - 128*B[3][1][0][2] + 1024*B[3][1][1][2] - 128*B[3][1][2][0] + 1024*B[3][1][2][1] - 1024*B[3][1][2][3] + 128*B[3][1][2][4] - 1024*B[3][1][3][2] + 
     128*B[3][1][4][2] + 192*B[3][2][0][2] - 1536*B[3][2][1][2] + 1536*B[3][2][3][2] - 192*B[3][2][4][2] - 128*B[3][3][0][2] + 1024*B[3][3][1][2] + 128*B[3][3][2][0] - 1024*B[3][3][2][1] + 
     1024*B[3][3][2][3] - 128*B[3][3][2][4] - 1024*B[3][3][3][2] + 128*B[3][3][4][2] + 8*B[3][4][0][2] - 64*B[3][4][1][2] - 16*B[3][4][2][0] + 128*B[3][4][2][1] - 128*B[3][4][2][3] + 
     16*B[3][4][2][4] + 64*B[3][4][3][2] - 8*B[3][4][4][2] - B[4][0][0][2] + 8*B[4][0][1][2] - B[4][0][2][0] + 8*B[4][0][2][1] - 8*B[4][0][2][3] + B[4][0][2][4] - 8*B[4][0][3][2] + 
     B[4][0][4][2] + 16*B[4][1][0][2] - 128*B[4][1][1][2] + 8*B[4][1][2][0] - 64*B[4][1][2][1] + 64*B[4][1][2][3] - 8*B[4][1][2][4] + 128*B[4][1][3][2] - 16*B[4][1][4][2] - 6*B[4][2][0][2] + 
     48*B[4][2][1][2] - 48*B[4][2][3][2] + 6*B[4][2][4][2] + 16*B[4][3][0][2] - 128*B[4][3][1][2] - 8*B[4][3][2][0] + 64*B[4][3][2][1] - 64*B[4][3][2][3] + 8*B[4][3][2][4] + 
     128*B[4][3][3][2] - 16*B[4][3][4][2] - B[4][4][0][2] + 8*B[4][4][1][2] + B[4][4][2][0] - 8*B[4][4][2][1] + 8*B[4][4][2][3] - B[4][4][2][4] - 8*B[4][4][3][2] + B[4][4][4][2])/9216. ; 
	    val3100r = 1./(DZ4)*(B[0][2][2][2] - 4*B[1][2][2][2] - B[2][0][2][2] + 4*B[2][1][2][2] + 4*B[2][3][2][2] - B[2][4][2][2] - 4*B[3][2][2][2] + B[4][2][2][2])/16. ; 
	    val1003r = 1./(DZ4)*(B[0][2][0][0] - 16*B[0][2][0][1] + 6*B[0][2][0][2] - 16*B[0][2][0][3] + B[0][2][0][4] - 8*B[0][2][1][0] + 128*B[0][2][1][1] - 192*B[0][2][1][2] + 128*B[0][2][1][3] - 8*B[0][2][1][4] + 
     8*B[0][2][3][0] - 128*B[0][2][3][1] + 192*B[0][2][3][2] - 128*B[0][2][3][3] + 8*B[0][2][3][4] - B[0][2][4][0] + 16*B[0][2][4][1] - 6*B[0][2][4][2] + 16*B[0][2][4][3] - B[0][2][4][4] - 
     8*B[1][2][0][0] + 128*B[1][2][0][1] - 48*B[1][2][0][2] + 128*B[1][2][0][3] - 8*B[1][2][0][4] + 64*B[1][2][1][0] - 1024*B[1][2][1][1] + 1536*B[1][2][1][2] - 1024*B[1][2][1][3] + 
     64*B[1][2][1][4] - 64*B[1][2][3][0] + 1024*B[1][2][3][1] - 1536*B[1][2][3][2] + 1024*B[1][2][3][3] - 64*B[1][2][3][4] + 8*B[1][2][4][0] - 128*B[1][2][4][1] + 48*B[1][2][4][2] - 
     128*B[1][2][4][3] + 8*B[1][2][4][4] - B[2][0][0][0] + 8*B[2][0][0][1] - 8*B[2][0][0][3] + B[2][0][0][4] + 16*B[2][0][1][0] - 128*B[2][0][1][1] + 128*B[2][0][1][3] - 16*B[2][0][1][4] - 
     6*B[2][0][2][0] + 192*B[2][0][2][1] - 192*B[2][0][2][3] + 6*B[2][0][2][4] + 16*B[2][0][3][0] - 128*B[2][0][3][1] + 128*B[2][0][3][3] - 16*B[2][0][3][4] - B[2][0][4][0] + 
     8*B[2][0][4][1] - 8*B[2][0][4][3] + B[2][0][4][4] + 8*B[2][1][0][0] - 64*B[2][1][0][1] + 64*B[2][1][0][3] - 8*B[2][1][0][4] - 128*B[2][1][1][0] + 1024*B[2][1][1][1] - 
     1024*B[2][1][1][3] + 128*B[2][1][1][4] + 48*B[2][1][2][0] - 1536*B[2][1][2][1] + 1536*B[2][1][2][3] - 48*B[2][1][2][4] - 128*B[2][1][3][0] + 1024*B[2][1][3][1] - 1024*B[2][1][3][3] + 
     128*B[2][1][3][4] + 8*B[2][1][4][0] - 64*B[2][1][4][1] + 64*B[2][1][4][3] - 8*B[2][1][4][4] - 8*B[2][3][0][0] + 64*B[2][3][0][1] - 64*B[2][3][0][3] + 8*B[2][3][0][4] + 
     128*B[2][3][1][0] - 1024*B[2][3][1][1] + 1024*B[2][3][1][3] - 128*B[2][3][1][4] - 48*B[2][3][2][0] + 1536*B[2][3][2][1] - 1536*B[2][3][2][3] + 48*B[2][3][2][4] + 128*B[2][3][3][0] - 
     1024*B[2][3][3][1] + 1024*B[2][3][3][3] - 128*B[2][3][3][4] - 8*B[2][3][4][0] + 64*B[2][3][4][1] - 64*B[2][3][4][3] + 8*B[2][3][4][4] + B[2][4][0][0] - 8*B[2][4][0][1] + 
     8*B[2][4][0][3] - B[2][4][0][4] - 16*B[2][4][1][0] + 128*B[2][4][1][1] - 128*B[2][4][1][3] + 16*B[2][4][1][4] + 6*B[2][4][2][0] - 192*B[2][4][2][1] + 192*B[2][4][2][3] - 
     6*B[2][4][2][4] - 16*B[2][4][3][0] + 128*B[2][4][3][1] - 128*B[2][4][3][3] + 16*B[2][4][3][4] + B[2][4][4][0] - 8*B[2][4][4][1] + 8*B[2][4][4][3] - B[2][4][4][4] + 8*B[3][2][0][0] - 
     128*B[3][2][0][1] + 48*B[3][2][0][2] - 128*B[3][2][0][3] + 8*B[3][2][0][4] - 64*B[3][2][1][0] + 1024*B[3][2][1][1] - 1536*B[3][2][1][2] + 1024*B[3][2][1][3] - 64*B[3][2][1][4] + 
     64*B[3][2][3][0] - 1024*B[3][2][3][1] + 1536*B[3][2][3][2] - 1024*B[3][2][3][3] + 64*B[3][2][3][4] - 8*B[3][2][4][0] + 128*B[3][2][4][1] - 48*B[3][2][4][2] + 128*B[3][2][4][3] - 
     8*B[3][2][4][4] - B[4][2][0][0] + 16*B[4][2][0][1] - 6*B[4][2][0][2] + 16*B[4][2][0][3] - B[4][2][0][4] + 8*B[4][2][1][0] - 128*B[4][2][1][1] + 192*B[4][2][1][2] - 128*B[4][2][1][3] + 
     8*B[4][2][1][4] - 8*B[4][2][3][0] + 128*B[4][2][3][1] - 192*B[4][2][3][2] + 128*B[4][2][3][3] - 8*B[4][2][3][4] + B[4][2][4][0] - 16*B[4][2][4][1] + 6*B[4][2][4][2] - 16*B[4][2][4][3] + 
     B[4][2][4][4])/9216. ; 
	    val0031r = 1./(DZ4)*(B[2][2][0][2] - 4*B[2][2][1][2] - B[2][2][2][0] + 4*B[2][2][2][1] + 4*B[2][2][2][3] - B[2][2][2][4] - 4*B[2][2][3][2] + B[2][2][4][2])/16. ; 
	    val2200r = 1./(DZ4)*(B[0][0][2][2] - 16*B[0][1][2][2] + 102*B[0][2][2][2] - 16*B[0][3][2][2] + B[0][4][2][2] - 16*B[1][0][2][2] + 256*B[1][1][2][2] - 768*B[1][2][2][2] + 256*B[1][3][2][2] - 16*B[1][4][2][2] + 
     102*B[2][0][2][2] - 768*B[2][1][2][2] + 1764*B[2][2][2][2] - 768*B[2][3][2][2] + 102*B[2][4][2][2] - 16*B[3][0][2][2] + 256*B[3][1][2][2] - 768*B[3][2][2][2] + 256*B[3][3][2][2] - 
     16*B[3][4][2][2] + B[4][0][2][2] - 16*B[4][1][2][2] + 102*B[4][2][2][2] - 16*B[4][3][2][2] + B[4][4][2][2])/1152. ; 
	    val0022r = 1./(DZ4)*(B[2][2][0][0] - 16*B[2][2][0][1] + 102*B[2][2][0][2] - 16*B[2][2][0][3] + B[2][2][0][4] - 16*B[2][2][1][0] + 256*B[2][2][1][1] - 768*B[2][2][1][2] + 256*B[2][2][1][3] - 16*B[2][2][1][4] + 
     102*B[2][2][2][0] - 768*B[2][2][2][1] + 1764*B[2][2][2][2] - 768*B[2][2][2][3] + 102*B[2][2][2][4] - 16*B[2][2][3][0] + 256*B[2][2][3][1] - 768*B[2][2][3][2] + 256*B[2][2][3][3] - 
     16*B[2][2][3][4] + B[2][2][4][0] - 16*B[2][2][4][1] + 102*B[2][2][4][2] - 16*B[2][2][4][3] + B[2][2][4][4])/1152. ; 
	    val0220r = 1./(DZ4)*((B[0][0][0][0] - 8*B[0][0][0][1] + 8*B[0][0][0][3] - B[0][0][0][4] - 8*B[0][0][1][0] + 64*B[0][0][1][1] - 64*B[0][0][1][3] + 8*B[0][0][1][4] + 8*B[0][0][3][0] - 64*B[0][0][3][1] + 
     64*B[0][0][3][3] - 8*B[0][0][3][4] - B[0][0][4][0] + 8*B[0][0][4][1] - 8*B[0][0][4][3] + B[0][0][4][4] - 8*B[0][1][0][0] + 64*B[0][1][0][1] - 64*B[0][1][0][3] + 8*B[0][1][0][4] + 
     64*B[0][1][1][0] - 512*B[0][1][1][1] + 512*B[0][1][1][3] - 64*B[0][1][1][4] - 64*B[0][1][3][0] + 512*B[0][1][3][1] - 512*B[0][1][3][3] + 64*B[0][1][3][4] + 8*B[0][1][4][0] - 
     64*B[0][1][4][1] + 64*B[0][1][4][3] - 8*B[0][1][4][4] + 36*B[0][2][0][2] - 576*B[0][2][1][2] - 36*B[0][2][2][0] + 576*B[0][2][2][1] + 576*B[0][2][2][3] - 36*B[0][2][2][4] - 
     576*B[0][2][3][2] + 36*B[0][2][4][2] + 8*B[0][3][0][0] - 64*B[0][3][0][1] + 64*B[0][3][0][3] - 8*B[0][3][0][4] - 64*B[0][3][1][0] + 512*B[0][3][1][1] - 512*B[0][3][1][3] + 
     64*B[0][3][1][4] + 64*B[0][3][3][0] - 512*B[0][3][3][1] + 512*B[0][3][3][3] - 64*B[0][3][3][4] - 8*B[0][3][4][0] + 64*B[0][3][4][1] - 64*B[0][3][4][3] + 8*B[0][3][4][4] - B[0][4][0][0] + 
     8*B[0][4][0][1] - 8*B[0][4][0][3] + B[0][4][0][4] + 8*B[0][4][1][0] - 64*B[0][4][1][1] + 64*B[0][4][1][3] - 8*B[0][4][1][4] - 8*B[0][4][3][0] + 64*B[0][4][3][1] - 64*B[0][4][3][3] + 
     8*B[0][4][3][4] + B[0][4][4][0] - 8*B[0][4][4][1] + 8*B[0][4][4][3] - B[0][4][4][4] - 8*B[1][0][0][0] + 64*B[1][0][0][1] - 64*B[1][0][0][3] + 8*B[1][0][0][4] + 64*B[1][0][1][0] - 
     512*B[1][0][1][1] + 512*B[1][0][1][3] - 64*B[1][0][1][4] - 64*B[1][0][3][0] + 512*B[1][0][3][1] - 512*B[1][0][3][3] + 64*B[1][0][3][4] + 8*B[1][0][4][0] - 64*B[1][0][4][1] + 
     64*B[1][0][4][3] - 8*B[1][0][4][4] + 64*B[1][1][0][0] - 512*B[1][1][0][1] + 512*B[1][1][0][3] - 64*B[1][1][0][4] - 512*B[1][1][1][0] + 4096*B[1][1][1][1] - 4096*B[1][1][1][3] + 
     512*B[1][1][1][4] + 512*B[1][1][3][0] - 4096*B[1][1][3][1] + 4096*B[1][1][3][3] - 512*B[1][1][3][4] - 64*B[1][1][4][0] + 512*B[1][1][4][1] - 512*B[1][1][4][3] + 64*B[1][1][4][4] - 
     576*B[1][2][0][2] + 9216*B[1][2][1][2] + 576*B[1][2][2][0] - 9216*B[1][2][2][1] - 9216*B[1][2][2][3] + 576*B[1][2][2][4] + 9216*B[1][2][3][2] - 576*B[1][2][4][2] - 64*B[1][3][0][0] + 
     512*B[1][3][0][1] - 512*B[1][3][0][3] + 64*B[1][3][0][4] + 512*B[1][3][1][0] - 4096*B[1][3][1][1] + 4096*B[1][3][1][3] - 512*B[1][3][1][4] - 512*B[1][3][3][0] + 4096*B[1][3][3][1] - 
     4096*B[1][3][3][3] + 512*B[1][3][3][4] + 64*B[1][3][4][0] - 512*B[1][3][4][1] + 512*B[1][3][4][3] - 64*B[1][3][4][4] + 8*B[1][4][0][0] - 64*B[1][4][0][1] + 64*B[1][4][0][3] - 
     8*B[1][4][0][4] - 64*B[1][4][1][0] + 512*B[1][4][1][1] - 512*B[1][4][1][3] + 64*B[1][4][1][4] + 64*B[1][4][3][0] - 512*B[1][4][3][1] + 512*B[1][4][3][3] - 64*B[1][4][3][4] - 
     8*B[1][4][4][0] + 64*B[1][4][4][1] - 64*B[1][4][4][3] + 8*B[1][4][4][4] - 36*B[2][0][0][2] + 576*B[2][0][1][2] + 36*B[2][0][2][0] - 576*B[2][0][2][1] - 576*B[2][0][2][3] + 
     36*B[2][0][2][4] + 576*B[2][0][3][2] - 36*B[2][0][4][2] + 576*B[2][1][0][2] - 9216*B[2][1][1][2] - 576*B[2][1][2][0] + 9216*B[2][1][2][1] + 9216*B[2][1][2][3] - 576*B[2][1][2][4] - 
     9216*B[2][1][3][2] + 576*B[2][1][4][2] + 576*B[2][3][0][2] - 9216*B[2][3][1][2] - 576*B[2][3][2][0] + 9216*B[2][3][2][1] + 9216*B[2][3][2][3] - 576*B[2][3][2][4] - 
     9216*B[2][3][3][2] + 576*B[2][3][4][2] - 36*B[2][4][0][2] + 576*B[2][4][1][2] + 36*B[2][4][2][0] - 576*B[2][4][2][1] - 576*B[2][4][2][3] + 36*B[2][4][2][4] + 576*B[2][4][3][2] - 
     36*B[2][4][4][2] + 8*B[3][0][0][0] - 64*B[3][0][0][1] + 64*B[3][0][0][3] - 8*B[3][0][0][4] - 64*B[3][0][1][0] + 512*B[3][0][1][1] - 512*B[3][0][1][3] + 64*B[3][0][1][4] + 
     64*B[3][0][3][0] - 512*B[3][0][3][1] + 512*B[3][0][3][3] - 64*B[3][0][3][4] - 8*B[3][0][4][0] + 64*B[3][0][4][1] - 64*B[3][0][4][3] + 8*B[3][0][4][4] - 64*B[3][1][0][0] + 
     512*B[3][1][0][1] - 512*B[3][1][0][3] + 64*B[3][1][0][4] + 512*B[3][1][1][0] - 4096*B[3][1][1][1] + 4096*B[3][1][1][3] - 512*B[3][1][1][4] - 512*B[3][1][3][0] + 4096*B[3][1][3][1] - 
     4096*B[3][1][3][3] + 512*B[3][1][3][4] + 64*B[3][1][4][0] - 512*B[3][1][4][1] + 512*B[3][1][4][3] - 64*B[3][1][4][4] - 576*B[3][2][0][2] + 9216*B[3][2][1][2] + 576*B[3][2][2][0] - 
     9216*B[3][2][2][1] - 9216*B[3][2][2][3] + 576*B[3][2][2][4] + 9216*B[3][2][3][2] - 576*B[3][2][4][2] + 64*B[3][3][0][0] - 512*B[3][3][0][1] + 512*B[3][3][0][3] - 64*B[3][3][0][4] - 
     512*B[3][3][1][0] + 4096*B[3][3][1][1] - 4096*B[3][3][1][3] + 512*B[3][3][1][4] + 512*B[3][3][3][0] - 4096*B[3][3][3][1] + 4096*B[3][3][3][3] - 512*B[3][3][3][4] - 64*B[3][3][4][0] + 
     512*B[3][3][4][1] - 512*B[3][3][4][3] + 64*B[3][3][4][4] - 8*B[3][4][0][0] + 64*B[3][4][0][1] - 64*B[3][4][0][3] + 8*B[3][4][0][4] + 64*B[3][4][1][0] - 512*B[3][4][1][1] + 
     512*B[3][4][1][3] - 64*B[3][4][1][4] - 64*B[3][4][3][0] + 512*B[3][4][3][1] - 512*B[3][4][3][3] + 64*B[3][4][3][4] + 8*B[3][4][4][0] - 64*B[3][4][4][1] + 64*B[3][4][4][3] - 
     8*B[3][4][4][4] - B[4][0][0][0] + 8*B[4][0][0][1] - 8*B[4][0][0][3] + B[4][0][0][4] + 8*B[4][0][1][0] - 64*B[4][0][1][1] + 64*B[4][0][1][3] - 8*B[4][0][1][4] - 8*B[4][0][3][0] + 
     64*B[4][0][3][1] - 64*B[4][0][3][3] + 8*B[4][0][3][4] + B[4][0][4][0] - 8*B[4][0][4][1] + 8*B[4][0][4][3] - B[4][0][4][4] + 8*B[4][1][0][0] - 64*B[4][1][0][1] + 64*B[4][1][0][3] - 
     8*B[4][1][0][4] - 64*B[4][1][1][0] + 512*B[4][1][1][1] - 512*B[4][1][1][3] + 64*B[4][1][1][4] + 64*B[4][1][3][0] - 512*B[4][1][3][1] + 512*B[4][1][3][3] - 64*B[4][1][3][4] - 
     8*B[4][1][4][0] + 64*B[4][1][4][1] - 64*B[4][1][4][3] + 8*B[4][1][4][4] + 36*B[4][2][0][2] - 576*B[4][2][1][2] - 36*B[4][2][2][0] + 576*B[4][2][2][1] + 576*B[4][2][2][3] - 
     36*B[4][2][2][4] - 576*B[4][2][3][2] + 36*B[4][2][4][2] - 8*B[4][3][0][0] + 64*B[4][3][0][1] - 64*B[4][3][0][3] + 8*B[4][3][0][4] + 64*B[4][3][1][0] - 512*B[4][3][1][1] + 
     512*B[4][3][1][3] - 64*B[4][3][1][4] - 64*B[4][3][3][0] + 512*B[4][3][3][1] - 512*B[4][3][3][3] + 64*B[4][3][3][4] + 8*B[4][3][4][0] - 64*B[4][3][4][1] + 64*B[4][3][4][3] - 
     8*B[4][3][4][4] + B[4][4][0][0] - 8*B[4][4][0][1] + 8*B[4][4][0][3] - B[4][4][0][4] - 8*B[4][4][1][0] + 64*B[4][4][1][1] - 64*B[4][4][1][3] + 8*B[4][4][1][4] + 8*B[4][4][3][0] - 
     64*B[4][4][3][1] + 64*B[4][4][3][3] - 8*B[4][4][3][4] - B[4][4][4][0] + 8*B[4][4][4][1] - 8*B[4][4][4][3] + B[4][4][4][4])/82944.) ; 
	    val2110r = 1./(DZ4)*(-B[0][0][0][2] + 8*B[0][0][1][2] + B[0][0][2][0] - 8*B[0][0][2][1] + 8*B[0][0][2][3] - B[0][0][2][4] - 8*B[0][0][3][2] + B[0][0][4][2] + 16*B[0][1][0][2] - 128*B[0][1][1][2] - 8*B[0][1][2][0] + 
     64*B[0][1][2][1] - 64*B[0][1][2][3] + 8*B[0][1][2][4] + 128*B[0][1][3][2] - 16*B[0][1][4][2] - 102*B[0][2][0][2] + 816*B[0][2][1][2] - 816*B[0][2][3][2] + 102*B[0][2][4][2] + 
     16*B[0][3][0][2] - 128*B[0][3][1][2] + 8*B[0][3][2][0] - 64*B[0][3][2][1] + 64*B[0][3][2][3] - 8*B[0][3][2][4] + 128*B[0][3][3][2] - 16*B[0][3][4][2] - B[0][4][0][2] + 8*B[0][4][1][2] - 
     B[0][4][2][0] + 8*B[0][4][2][1] - 8*B[0][4][2][3] + B[0][4][2][4] - 8*B[0][4][3][2] + B[0][4][4][2] + 8*B[1][0][0][2] - 64*B[1][0][1][2] - 16*B[1][0][2][0] + 128*B[1][0][2][1] - 
     128*B[1][0][2][3] + 16*B[1][0][2][4] + 64*B[1][0][3][2] - 8*B[1][0][4][2] - 128*B[1][1][0][2] + 1024*B[1][1][1][2] + 128*B[1][1][2][0] - 1024*B[1][1][2][1] + 1024*B[1][1][2][3] - 
     128*B[1][1][2][4] - 1024*B[1][1][3][2] + 128*B[1][1][4][2] + 384*B[1][2][0][2] - 3072*B[1][2][1][2] + 3072*B[1][2][3][2] - 384*B[1][2][4][2] - 128*B[1][3][0][2] + 1024*B[1][3][1][2] - 
     128*B[1][3][2][0] + 1024*B[1][3][2][1] - 1024*B[1][3][2][3] + 128*B[1][3][2][4] - 1024*B[1][3][3][2] + 128*B[1][3][4][2] + 8*B[1][4][0][2] - 64*B[1][4][1][2] + 16*B[1][4][2][0] - 
     128*B[1][4][2][1] + 128*B[1][4][2][3] - 16*B[1][4][2][4] + 64*B[1][4][3][2] - 8*B[1][4][4][2] + 102*B[2][0][2][0] - 816*B[2][0][2][1] + 816*B[2][0][2][3] - 102*B[2][0][2][4] - 
     384*B[2][1][2][0] + 3072*B[2][1][2][1] - 3072*B[2][1][2][3] + 384*B[2][1][2][4] + 384*B[2][3][2][0] - 3072*B[2][3][2][1] + 3072*B[2][3][2][3] - 384*B[2][3][2][4] - 102*B[2][4][2][0] + 
     816*B[2][4][2][1] - 816*B[2][4][2][3] + 102*B[2][4][2][4] - 8*B[3][0][0][2] + 64*B[3][0][1][2] - 16*B[3][0][2][0] + 128*B[3][0][2][1] - 128*B[3][0][2][3] + 16*B[3][0][2][4] - 
     64*B[3][0][3][2] + 8*B[3][0][4][2] + 128*B[3][1][0][2] - 1024*B[3][1][1][2] + 128*B[3][1][2][0] - 1024*B[3][1][2][1] + 1024*B[3][1][2][3] - 128*B[3][1][2][4] + 1024*B[3][1][3][2] - 
     128*B[3][1][4][2] - 384*B[3][2][0][2] + 3072*B[3][2][1][2] - 3072*B[3][2][3][2] + 384*B[3][2][4][2] + 128*B[3][3][0][2] - 1024*B[3][3][1][2] - 128*B[3][3][2][0] + 1024*B[3][3][2][1] - 
     1024*B[3][3][2][3] + 128*B[3][3][2][4] + 1024*B[3][3][3][2] - 128*B[3][3][4][2] - 8*B[3][4][0][2] + 64*B[3][4][1][2] + 16*B[3][4][2][0] - 128*B[3][4][2][1] + 128*B[3][4][2][3] - 
     16*B[3][4][2][4] - 64*B[3][4][3][2] + 8*B[3][4][4][2] + B[4][0][0][2] - 8*B[4][0][1][2] + B[4][0][2][0] - 8*B[4][0][2][1] + 8*B[4][0][2][3] - B[4][0][2][4] + 8*B[4][0][3][2] - 
     B[4][0][4][2] - 16*B[4][1][0][2] + 128*B[4][1][1][2] - 8*B[4][1][2][0] + 64*B[4][1][2][1] - 64*B[4][1][2][3] + 8*B[4][1][2][4] - 128*B[4][1][3][2] + 16*B[4][1][4][2] + 
     102*B[4][2][0][2] - 816*B[4][2][1][2] + 816*B[4][2][3][2] - 102*B[4][2][4][2] - 16*B[4][3][0][2] + 128*B[4][3][1][2] + 8*B[4][3][2][0] - 64*B[4][3][2][1] + 64*B[4][3][2][3] - 
     8*B[4][3][2][4] - 128*B[4][3][3][2] + 16*B[4][3][4][2] + B[4][4][0][2] - 8*B[4][4][1][2] - B[4][4][2][0] + 8*B[4][4][2][1] - 8*B[4][4][2][3] + B[4][4][2][4] + 8*B[4][4][3][2] - B[4][4][4][2]
     )/27648. ; 
	    val2101r = 1./(DZ4)*(-B[0][0][0][2] + 8*B[0][0][1][2] - B[0][0][2][0] + 8*B[0][0][2][1] - 8*B[0][0][2][3] + B[0][0][2][4] - 8*B[0][0][3][2] + B[0][0][4][2] + 16*B[0][1][0][2] - 128*B[0][1][1][2] + 8*B[0][1][2][0] - 
     64*B[0][1][2][1] + 64*B[0][1][2][3] - 8*B[0][1][2][4] + 128*B[0][1][3][2] - 16*B[0][1][4][2] - 102*B[0][2][0][2] + 816*B[0][2][1][2] - 816*B[0][2][3][2] + 102*B[0][2][4][2] + 
     16*B[0][3][0][2] - 128*B[0][3][1][2] - 8*B[0][3][2][0] + 64*B[0][3][2][1] - 64*B[0][3][2][3] + 8*B[0][3][2][4] + 128*B[0][3][3][2] - 16*B[0][3][4][2] - B[0][4][0][2] + 8*B[0][4][1][2] + 
     B[0][4][2][0] - 8*B[0][4][2][1] + 8*B[0][4][2][3] - B[0][4][2][4] - 8*B[0][4][3][2] + B[0][4][4][2] + 8*B[1][0][0][2] - 64*B[1][0][1][2] + 16*B[1][0][2][0] - 128*B[1][0][2][1] + 
     128*B[1][0][2][3] - 16*B[1][0][2][4] + 64*B[1][0][3][2] - 8*B[1][0][4][2] - 128*B[1][1][0][2] + 1024*B[1][1][1][2] - 128*B[1][1][2][0] + 1024*B[1][1][2][1] - 1024*B[1][1][2][3] + 
     128*B[1][1][2][4] - 1024*B[1][1][3][2] + 128*B[1][1][4][2] + 384*B[1][2][0][2] - 3072*B[1][2][1][2] + 3072*B[1][2][3][2] - 384*B[1][2][4][2] - 128*B[1][3][0][2] + 1024*B[1][3][1][2] + 
     128*B[1][3][2][0] - 1024*B[1][3][2][1] + 1024*B[1][3][2][3] - 128*B[1][3][2][4] - 1024*B[1][3][3][2] + 128*B[1][3][4][2] + 8*B[1][4][0][2] - 64*B[1][4][1][2] - 16*B[1][4][2][0] + 
     128*B[1][4][2][1] - 128*B[1][4][2][3] + 16*B[1][4][2][4] + 64*B[1][4][3][2] - 8*B[1][4][4][2] - 102*B[2][0][2][0] + 816*B[2][0][2][1] - 816*B[2][0][2][3] + 102*B[2][0][2][4] + 
     384*B[2][1][2][0] - 3072*B[2][1][2][1] + 3072*B[2][1][2][3] - 384*B[2][1][2][4] - 384*B[2][3][2][0] + 3072*B[2][3][2][1] - 3072*B[2][3][2][3] + 384*B[2][3][2][4] + 102*B[2][4][2][0] - 
     816*B[2][4][2][1] + 816*B[2][4][2][3] - 102*B[2][4][2][4] - 8*B[3][0][0][2] + 64*B[3][0][1][2] + 16*B[3][0][2][0] - 128*B[3][0][2][1] + 128*B[3][0][2][3] - 16*B[3][0][2][4] - 
     64*B[3][0][3][2] + 8*B[3][0][4][2] + 128*B[3][1][0][2] - 1024*B[3][1][1][2] - 128*B[3][1][2][0] + 1024*B[3][1][2][1] - 1024*B[3][1][2][3] + 128*B[3][1][2][4] + 1024*B[3][1][3][2] - 
     128*B[3][1][4][2] - 384*B[3][2][0][2] + 3072*B[3][2][1][2] - 3072*B[3][2][3][2] + 384*B[3][2][4][2] + 128*B[3][3][0][2] - 1024*B[3][3][1][2] + 128*B[3][3][2][0] - 1024*B[3][3][2][1] + 
     1024*B[3][3][2][3] - 128*B[3][3][2][4] + 1024*B[3][3][3][2] - 128*B[3][3][4][2] - 8*B[3][4][0][2] + 64*B[3][4][1][2] - 16*B[3][4][2][0] + 128*B[3][4][2][1] - 128*B[3][4][2][3] + 
     16*B[3][4][2][4] - 64*B[3][4][3][2] + 8*B[3][4][4][2] + B[4][0][0][2] - 8*B[4][0][1][2] - B[4][0][2][0] + 8*B[4][0][2][1] - 8*B[4][0][2][3] + B[4][0][2][4] + 8*B[4][0][3][2] - 
     B[4][0][4][2] - 16*B[4][1][0][2] + 128*B[4][1][1][2] + 8*B[4][1][2][0] - 64*B[4][1][2][1] + 64*B[4][1][2][3] - 8*B[4][1][2][4] - 128*B[4][1][3][2] + 16*B[4][1][4][2] + 
     102*B[4][2][0][2] - 816*B[4][2][1][2] + 816*B[4][2][3][2] - 102*B[4][2][4][2] - 16*B[4][3][0][2] + 128*B[4][3][1][2] - 8*B[4][3][2][0] + 64*B[4][3][2][1] - 64*B[4][3][2][3] + 
     8*B[4][3][2][4] - 128*B[4][3][3][2] + 16*B[4][3][4][2] + B[4][4][0][2] - 8*B[4][4][1][2] + B[4][4][2][0] - 8*B[4][4][2][1] + 8*B[4][4][2][3] - B[4][4][2][4] + 8*B[4][4][3][2] - B[4][4][4][2]
     )/27648. ; 
	    val1021r = 1./(DZ4)*(-B[0][2][0][0] + 16*B[0][2][0][1] - 102*B[0][2][0][2] + 16*B[0][2][0][3] - B[0][2][0][4] + 8*B[0][2][1][0] - 128*B[0][2][1][1] + 384*B[0][2][1][2] - 128*B[0][2][1][3] + 8*B[0][2][1][4] - 
     8*B[0][2][3][0] + 128*B[0][2][3][1] - 384*B[0][2][3][2] + 128*B[0][2][3][3] - 8*B[0][2][3][4] + B[0][2][4][0] - 16*B[0][2][4][1] + 102*B[0][2][4][2] - 16*B[0][2][4][3] + B[0][2][4][4] + 
     8*B[1][2][0][0] - 128*B[1][2][0][1] + 816*B[1][2][0][2] - 128*B[1][2][0][3] + 8*B[1][2][0][4] - 64*B[1][2][1][0] + 1024*B[1][2][1][1] - 3072*B[1][2][1][2] + 1024*B[1][2][1][3] - 
     64*B[1][2][1][4] + 64*B[1][2][3][0] - 1024*B[1][2][3][1] + 3072*B[1][2][3][2] - 1024*B[1][2][3][3] + 64*B[1][2][3][4] - 8*B[1][2][4][0] + 128*B[1][2][4][1] - 816*B[1][2][4][2] + 
     128*B[1][2][4][3] - 8*B[1][2][4][4] + B[2][0][0][0] - 8*B[2][0][0][1] + 8*B[2][0][0][3] - B[2][0][0][4] - 16*B[2][0][1][0] + 128*B[2][0][1][1] - 128*B[2][0][1][3] + 16*B[2][0][1][4] + 
     102*B[2][0][2][0] - 384*B[2][0][2][1] + 384*B[2][0][2][3] - 102*B[2][0][2][4] - 16*B[2][0][3][0] + 128*B[2][0][3][1] - 128*B[2][0][3][3] + 16*B[2][0][3][4] + B[2][0][4][0] - 
     8*B[2][0][4][1] + 8*B[2][0][4][3] - B[2][0][4][4] - 8*B[2][1][0][0] + 64*B[2][1][0][1] - 64*B[2][1][0][3] + 8*B[2][1][0][4] + 128*B[2][1][1][0] - 1024*B[2][1][1][1] + 
     1024*B[2][1][1][3] - 128*B[2][1][1][4] - 816*B[2][1][2][0] + 3072*B[2][1][2][1] - 3072*B[2][1][2][3] + 816*B[2][1][2][4] + 128*B[2][1][3][0] - 1024*B[2][1][3][1] + 
     1024*B[2][1][3][3] - 128*B[2][1][3][4] - 8*B[2][1][4][0] + 64*B[2][1][4][1] - 64*B[2][1][4][3] + 8*B[2][1][4][4] + 8*B[2][3][0][0] - 64*B[2][3][0][1] + 64*B[2][3][0][3] - 
     8*B[2][3][0][4] - 128*B[2][3][1][0] + 1024*B[2][3][1][1] - 1024*B[2][3][1][3] + 128*B[2][3][1][4] + 816*B[2][3][2][0] - 3072*B[2][3][2][1] + 3072*B[2][3][2][3] - 816*B[2][3][2][4] - 
     128*B[2][3][3][0] + 1024*B[2][3][3][1] - 1024*B[2][3][3][3] + 128*B[2][3][3][4] + 8*B[2][3][4][0] - 64*B[2][3][4][1] + 64*B[2][3][4][3] - 8*B[2][3][4][4] - B[2][4][0][0] + 
     8*B[2][4][0][1] - 8*B[2][4][0][3] + B[2][4][0][4] + 16*B[2][4][1][0] - 128*B[2][4][1][1] + 128*B[2][4][1][3] - 16*B[2][4][1][4] - 102*B[2][4][2][0] + 384*B[2][4][2][1] - 
     384*B[2][4][2][3] + 102*B[2][4][2][4] + 16*B[2][4][3][0] - 128*B[2][4][3][1] + 128*B[2][4][3][3] - 16*B[2][4][3][4] - B[2][4][4][0] + 8*B[2][4][4][1] - 8*B[2][4][4][3] + B[2][4][4][4] - 
     8*B[3][2][0][0] + 128*B[3][2][0][1] - 816*B[3][2][0][2] + 128*B[3][2][0][3] - 8*B[3][2][0][4] + 64*B[3][2][1][0] - 1024*B[3][2][1][1] + 3072*B[3][2][1][2] - 1024*B[3][2][1][3] + 
     64*B[3][2][1][4] - 64*B[3][2][3][0] + 1024*B[3][2][3][1] - 3072*B[3][2][3][2] + 1024*B[3][2][3][3] - 64*B[3][2][3][4] + 8*B[3][2][4][0] - 128*B[3][2][4][1] + 816*B[3][2][4][2] - 
     128*B[3][2][4][3] + 8*B[3][2][4][4] + B[4][2][0][0] - 16*B[4][2][0][1] + 102*B[4][2][0][2] - 16*B[4][2][0][3] + B[4][2][0][4] - 8*B[4][2][1][0] + 128*B[4][2][1][1] - 384*B[4][2][1][2] + 
     128*B[4][2][1][3] - 8*B[4][2][1][4] + 8*B[4][2][3][0] - 128*B[4][2][3][1] + 384*B[4][2][3][2] - 128*B[4][2][3][3] + 8*B[4][2][3][4] - B[4][2][4][0] + 16*B[4][2][4][1] - 
     102*B[4][2][4][2] + 16*B[4][2][4][3] - B[4][2][4][4])/27648. ; 
	    val0121r = 1./(DZ4)*((-B[0][2][0][0] + 16*B[0][2][0][1] - 102*B[0][2][0][2] + 16*B[0][2][0][3] - B[0][2][0][4] + 8*B[0][2][1][0] - 128*B[0][2][1][1] + 384*B[0][2][1][2] - 128*B[0][2][1][3] + 8*B[0][2][1][4] - 
     8*B[0][2][3][0] + 128*B[0][2][3][1] - 384*B[0][2][3][2] + 128*B[0][2][3][3] - 8*B[0][2][3][4] + B[0][2][4][0] - 16*B[0][2][4][1] + 102*B[0][2][4][2] - 16*B[0][2][4][3] + B[0][2][4][4] + 
     8*B[1][2][0][0] - 128*B[1][2][0][1] + 816*B[1][2][0][2] - 128*B[1][2][0][3] + 8*B[1][2][0][4] - 64*B[1][2][1][0] + 1024*B[1][2][1][1] - 3072*B[1][2][1][2] + 1024*B[1][2][1][3] - 
     64*B[1][2][1][4] + 64*B[1][2][3][0] - 1024*B[1][2][3][1] + 3072*B[1][2][3][2] - 1024*B[1][2][3][3] + 64*B[1][2][3][4] - 8*B[1][2][4][0] + 128*B[1][2][4][1] - 816*B[1][2][4][2] + 
     128*B[1][2][4][3] - 8*B[1][2][4][4] - B[2][0][0][0] + 8*B[2][0][0][1] - 8*B[2][0][0][3] + B[2][0][0][4] + 16*B[2][0][1][0] - 128*B[2][0][1][1] + 128*B[2][0][1][3] - 16*B[2][0][1][4] - 
     102*B[2][0][2][0] + 384*B[2][0][2][1] - 384*B[2][0][2][3] + 102*B[2][0][2][4] + 16*B[2][0][3][0] - 128*B[2][0][3][1] + 128*B[2][0][3][3] - 16*B[2][0][3][4] - B[2][0][4][0] + 
     8*B[2][0][4][1] - 8*B[2][0][4][3] + B[2][0][4][4] + 8*B[2][1][0][0] - 64*B[2][1][0][1] + 64*B[2][1][0][3] - 8*B[2][1][0][4] - 128*B[2][1][1][0] + 1024*B[2][1][1][1] - 
     1024*B[2][1][1][3] + 128*B[2][1][1][4] + 816*B[2][1][2][0] - 3072*B[2][1][2][1] + 3072*B[2][1][2][3] - 816*B[2][1][2][4] - 128*B[2][1][3][0] + 1024*B[2][1][3][1] - 
     1024*B[2][1][3][3] + 128*B[2][1][3][4] + 8*B[2][1][4][0] - 64*B[2][1][4][1] + 64*B[2][1][4][3] - 8*B[2][1][4][4] - 8*B[2][3][0][0] + 64*B[2][3][0][1] - 64*B[2][3][0][3] + 
     8*B[2][3][0][4] + 128*B[2][3][1][0] - 1024*B[2][3][1][1] + 1024*B[2][3][1][3] - 128*B[2][3][1][4] - 816*B[2][3][2][0] + 3072*B[2][3][2][1] - 3072*B[2][3][2][3] + 816*B[2][3][2][4] + 
     128*B[2][3][3][0] - 1024*B[2][3][3][1] + 1024*B[2][3][3][3] - 128*B[2][3][3][4] - 8*B[2][3][4][0] + 64*B[2][3][4][1] - 64*B[2][3][4][3] + 8*B[2][3][4][4] + B[2][4][0][0] - 
     8*B[2][4][0][1] + 8*B[2][4][0][3] - B[2][4][0][4] - 16*B[2][4][1][0] + 128*B[2][4][1][1] - 128*B[2][4][1][3] + 16*B[2][4][1][4] + 102*B[2][4][2][0] - 384*B[2][4][2][1] + 
     384*B[2][4][2][3] - 102*B[2][4][2][4] - 16*B[2][4][3][0] + 128*B[2][4][3][1] - 128*B[2][4][3][3] + 16*B[2][4][3][4] + B[2][4][4][0] - 8*B[2][4][4][1] + 8*B[2][4][4][3] - B[2][4][4][4] - 
     8*B[3][2][0][0] + 128*B[3][2][0][1] - 816*B[3][2][0][2] + 128*B[3][2][0][3] - 8*B[3][2][0][4] + 64*B[3][2][1][0] - 1024*B[3][2][1][1] + 3072*B[3][2][1][2] - 1024*B[3][2][1][3] + 
     64*B[3][2][1][4] - 64*B[3][2][3][0] + 1024*B[3][2][3][1] - 3072*B[3][2][3][2] + 1024*B[3][2][3][3] - 64*B[3][2][3][4] + 8*B[3][2][4][0] - 128*B[3][2][4][1] + 816*B[3][2][4][2] - 
     128*B[3][2][4][3] + 8*B[3][2][4][4] + B[4][2][0][0] - 16*B[4][2][0][1] + 102*B[4][2][0][2] - 16*B[4][2][0][3] + B[4][2][0][4] - 8*B[4][2][1][0] + 128*B[4][2][1][1] - 384*B[4][2][1][2] + 
     128*B[4][2][1][3] - 8*B[4][2][1][4] + 8*B[4][2][3][0] - 128*B[4][2][3][1] + 384*B[4][2][3][2] - 128*B[4][2][3][3] + 8*B[4][2][3][4] - B[4][2][4][0] + 16*B[4][2][4][1] - 
     102*B[4][2][4][2] + 16*B[4][2][4][3] - B[4][2][4][4])/27648.) ; 
	    val2011r = 1./(DZ4)*(B[0][2][0][2] - 16*B[0][2][1][2] + B[0][2][2][0] - 16*B[0][2][2][1] + 60*B[0][2][2][2] - 16*B[0][2][2][3] + B[0][2][2][4] - 16*B[0][2][3][2] + B[0][2][4][2] - 16*B[1][2][0][2] + 
     256*B[1][2][1][2] - 16*B[1][2][2][0] + 256*B[1][2][2][1] - 960*B[1][2][2][2] + 256*B[1][2][2][3] - 16*B[1][2][2][4] + 256*B[1][2][3][2] - 16*B[1][2][4][2] - B[2][0][0][2] + 
     16*B[2][0][1][2] - B[2][0][2][0] + 16*B[2][0][2][1] - 60*B[2][0][2][2] + 16*B[2][0][2][3] - B[2][0][2][4] + 16*B[2][0][3][2] - B[2][0][4][2] + 16*B[2][1][0][2] - 256*B[2][1][1][2] + 
     16*B[2][1][2][0] - 256*B[2][1][2][1] + 960*B[2][1][2][2] - 256*B[2][1][2][3] + 16*B[2][1][2][4] - 256*B[2][1][3][2] + 16*B[2][1][4][2] + 16*B[2][3][0][2] - 256*B[2][3][1][2] + 
     16*B[2][3][2][0] - 256*B[2][3][2][1] + 960*B[2][3][2][2] - 256*B[2][3][2][3] + 16*B[2][3][2][4] - 256*B[2][3][3][2] + 16*B[2][3][4][2] - B[2][4][0][2] + 16*B[2][4][1][2] - 
     B[2][4][2][0] + 16*B[2][4][2][1] - 60*B[2][4][2][2] + 16*B[2][4][2][3] - B[2][4][2][4] + 16*B[2][4][3][2] - B[2][4][4][2] - 16*B[3][2][0][2] + 256*B[3][2][1][2] - 16*B[3][2][2][0] + 
     256*B[3][2][2][1] - 960*B[3][2][2][2] + 256*B[3][2][2][3] - 16*B[3][2][2][4] + 256*B[3][2][3][2] - 16*B[3][2][4][2] + B[4][2][0][2] - 16*B[4][2][1][2] + B[4][2][2][0] - 
     16*B[4][2][2][1] + 60*B[4][2][2][2] - 16*B[4][2][2][3] + B[4][2][2][4] - 16*B[4][2][3][2] + B[4][2][4][2])/2304. ; 
	    val1120r = 1./(DZ4)*(B[0][2][0][2] - 16*B[0][2][1][2] - B[0][2][2][0] + 16*B[0][2][2][1] + 16*B[0][2][2][3] - B[0][2][2][4] - 16*B[0][2][3][2] + B[0][2][4][2] - 16*B[1][2][0][2] + 256*B[1][2][1][2] + 
     16*B[1][2][2][0] - 256*B[1][2][2][1] - 256*B[1][2][2][3] + 16*B[1][2][2][4] + 256*B[1][2][3][2] - 16*B[1][2][4][2] + B[2][0][0][2] - 16*B[2][0][1][2] - B[2][0][2][0] + 16*B[2][0][2][1] + 
     16*B[2][0][2][3] - B[2][0][2][4] - 16*B[2][0][3][2] + B[2][0][4][2] - 16*B[2][1][0][2] + 256*B[2][1][1][2] + 16*B[2][1][2][0] - 256*B[2][1][2][1] - 256*B[2][1][2][3] + 16*B[2][1][2][4] + 
     256*B[2][1][3][2] - 16*B[2][1][4][2] + 60*B[2][2][0][2] - 960*B[2][2][1][2] - 60*B[2][2][2][0] + 960*B[2][2][2][1] + 960*B[2][2][2][3] - 60*B[2][2][2][4] - 960*B[2][2][3][2] + 
     60*B[2][2][4][2] - 16*B[2][3][0][2] + 256*B[2][3][1][2] + 16*B[2][3][2][0] - 256*B[2][3][2][1] - 256*B[2][3][2][3] + 16*B[2][3][2][4] + 256*B[2][3][3][2] - 16*B[2][3][4][2] + 
     B[2][4][0][2] - 16*B[2][4][1][2] - B[2][4][2][0] + 16*B[2][4][2][1] + 16*B[2][4][2][3] - B[2][4][2][4] - 16*B[2][4][3][2] + B[2][4][4][2] - 16*B[3][2][0][2] + 256*B[3][2][1][2] + 
     16*B[3][2][2][0] - 256*B[3][2][2][1] - 256*B[3][2][2][3] + 16*B[3][2][2][4] + 256*B[3][2][3][2] - 16*B[3][2][4][2] + B[4][2][0][2] - 16*B[4][2][1][2] - B[4][2][2][0] + 16*B[4][2][2][1] + 
     16*B[4][2][2][3] - B[4][2][2][4] - 16*B[4][2][3][2] + B[4][2][4][2])/2304. ; 
	    val1111r = 1./(DZ4)*(B[0][2][0][2] - 16*B[0][2][1][2] + B[0][2][2][0] - 16*B[0][2][2][1] + 60*B[0][2][2][2] - 16*B[0][2][2][3] + B[0][2][2][4] - 16*B[0][2][3][2] + B[0][2][4][2] - 16*B[1][2][0][2] + 
     256*B[1][2][1][2] - 16*B[1][2][2][0] + 256*B[1][2][2][1] - 960*B[1][2][2][2] + 256*B[1][2][2][3] - 16*B[1][2][2][4] + 256*B[1][2][3][2] - 16*B[1][2][4][2] + B[2][0][0][2] - 
     16*B[2][0][1][2] + B[2][0][2][0] - 16*B[2][0][2][1] + 60*B[2][0][2][2] - 16*B[2][0][2][3] + B[2][0][2][4] - 16*B[2][0][3][2] + B[2][0][4][2] - 16*B[2][1][0][2] + 256*B[2][1][1][2] - 
     16*B[2][1][2][0] + 256*B[2][1][2][1] - 960*B[2][1][2][2] + 256*B[2][1][2][3] - 16*B[2][1][2][4] + 256*B[2][1][3][2] - 16*B[2][1][4][2] + 60*B[2][2][0][2] - 960*B[2][2][1][2] + 
     60*B[2][2][2][0] - 960*B[2][2][2][1] + 3600*B[2][2][2][2] - 960*B[2][2][2][3] + 60*B[2][2][2][4] - 960*B[2][2][3][2] + 60*B[2][2][4][2] - 16*B[2][3][0][2] + 256*B[2][3][1][2] - 
     16*B[2][3][2][0] + 256*B[2][3][2][1] - 960*B[2][3][2][2] + 256*B[2][3][2][3] - 16*B[2][3][2][4] + 256*B[2][3][3][2] - 16*B[2][3][4][2] + B[2][4][0][2] - 16*B[2][4][1][2] + 
     B[2][4][2][0] - 16*B[2][4][2][1] + 60*B[2][4][2][2] - 16*B[2][4][2][3] + B[2][4][2][4] - 16*B[2][4][3][2] + B[2][4][4][2] - 16*B[3][2][0][2] + 256*B[3][2][1][2] - 16*B[3][2][2][0] + 
     256*B[3][2][2][1] - 960*B[3][2][2][2] + 256*B[3][2][2][3] - 16*B[3][2][2][4] + 256*B[3][2][3][2] - 16*B[3][2][4][2] + B[4][2][0][2] - 16*B[4][2][1][2] + B[4][2][2][0] - 
     16*B[4][2][2][1] + 60*B[4][2][2][2] - 16*B[4][2][2][3] + B[4][2][2][4] - 16*B[4][2][3][2] + B[4][2][4][2])/2304. ;

	    val1100i = 0. ; 
	    val0011i = 0. ; 
	    val0110i = 1./(DZ2)*(-B[0][2][2][0] + 8*B[0][2][2][1] - 8*B[0][2][2][3] + B[0][2][2][4] + 8*B[1][2][2][0] - 64*B[1][2][2][1] + 64*B[1][2][2][3] - 8*B[1][2][2][4] + B[2][0][0][2] - 8*B[2][0][1][2] + 
     8*B[2][0][3][2] - B[2][0][4][2] - 8*B[2][1][0][2] + 64*B[2][1][1][2] - 64*B[2][1][3][2] + 8*B[2][1][4][2] + 8*B[2][3][0][2] - 64*B[2][3][1][2] + 64*B[2][3][3][2] - 8*B[2][3][4][2] - 
     B[2][4][0][2] + 8*B[2][4][1][2] - 8*B[2][4][3][2] + B[2][4][4][2] - 8*B[3][2][2][0] + 64*B[3][2][2][1] - 64*B[3][2][2][3] + 8*B[3][2][2][4] + B[4][2][2][0] - 8*B[4][2][2][1] + 
     8*B[4][2][2][3] - B[4][2][2][4])/576. ; 
	    val1011i = 1./(DZ3)*(B[2][0][0][2] - 16*B[2][0][1][2] + B[2][0][2][0] - 16*B[2][0][2][1] + 60*B[2][0][2][2] - 16*B[2][0][2][3] + B[2][0][2][4] - 16*B[2][0][3][2] + B[2][0][4][2] - 8*B[2][1][0][2] + 
     128*B[2][1][1][2] - 8*B[2][1][2][0] + 128*B[2][1][2][1] - 480*B[2][1][2][2] + 128*B[2][1][2][3] - 8*B[2][1][2][4] + 128*B[2][1][3][2] - 8*B[2][1][4][2] + 8*B[2][3][0][2] - 
     128*B[2][3][1][2] + 8*B[2][3][2][0] - 128*B[2][3][2][1] + 480*B[2][3][2][2] - 128*B[2][3][2][3] + 8*B[2][3][2][4] - 128*B[2][3][3][2] + 8*B[2][3][4][2] - B[2][4][0][2] + 
     16*B[2][4][1][2] - B[2][4][2][0] + 16*B[2][4][2][1] - 60*B[2][4][2][2] + 16*B[2][4][2][3] - B[2][4][2][4] + 16*B[2][4][3][2] - B[2][4][4][2])/1152. ; 
	    val1110i = 1./(DZ3)*(B[0][2][2][0] - 8*B[0][2][2][1] + 8*B[0][2][2][3] - B[0][2][2][4] - 16*B[1][2][2][0] + 128*B[1][2][2][1] - 128*B[1][2][2][3] + 16*B[1][2][2][4] + B[2][0][2][0] - 8*B[2][0][2][1] + 
     8*B[2][0][2][3] - B[2][0][2][4] - 16*B[2][1][2][0] + 128*B[2][1][2][1] - 128*B[2][1][2][3] + 16*B[2][1][2][4] + 60*B[2][2][2][0] - 480*B[2][2][2][1] + 480*B[2][2][2][3] - 
     60*B[2][2][2][4] - 16*B[2][3][2][0] + 128*B[2][3][2][1] - 128*B[2][3][2][3] + 16*B[2][3][2][4] + B[2][4][2][0] - 8*B[2][4][2][1] + 8*B[2][4][2][3] - B[2][4][2][4] - 16*B[3][2][2][0] + 
     128*B[3][2][2][1] - 128*B[3][2][2][3] + 16*B[3][2][2][4] + B[4][2][2][0] - 8*B[4][2][2][1] + 8*B[4][2][2][3] - B[4][2][2][4])/1152. ; 
	    val1002i = 1./(DZ3)*(B[0][2][0][0] - 8*B[0][2][0][1] + 8*B[0][2][0][3] - B[0][2][0][4] - 8*B[0][2][1][0] + 64*B[0][2][1][1] - 64*B[0][2][1][3] + 8*B[0][2][1][4] + 8*B[0][2][3][0] - 64*B[0][2][3][1] + 
     64*B[0][2][3][3] - 8*B[0][2][3][4] - B[0][2][4][0] + 8*B[0][2][4][1] - 8*B[0][2][4][3] + B[0][2][4][4] - 8*B[1][2][0][0] + 64*B[1][2][0][1] - 64*B[1][2][0][3] + 8*B[1][2][0][4] + 
     64*B[1][2][1][0] - 512*B[1][2][1][1] + 512*B[1][2][1][3] - 64*B[1][2][1][4] - 64*B[1][2][3][0] + 512*B[1][2][3][1] - 512*B[1][2][3][3] + 64*B[1][2][3][4] + 8*B[1][2][4][0] - 
     64*B[1][2][4][1] + 64*B[1][2][4][3] - 8*B[1][2][4][4] + 6*B[2][0][0][2] - 96*B[2][0][1][2] - 6*B[2][0][2][0] + 96*B[2][0][2][1] + 96*B[2][0][2][3] - 6*B[2][0][2][4] - 96*B[2][0][3][2] + 
     6*B[2][0][4][2] - 48*B[2][1][0][2] + 768*B[2][1][1][2] + 48*B[2][1][2][0] - 768*B[2][1][2][1] - 768*B[2][1][2][3] + 48*B[2][1][2][4] + 768*B[2][1][3][2] - 48*B[2][1][4][2] + 
     48*B[2][3][0][2] - 768*B[2][3][1][2] - 48*B[2][3][2][0] + 768*B[2][3][2][1] + 768*B[2][3][2][3] - 48*B[2][3][2][4] - 768*B[2][3][3][2] + 48*B[2][3][4][2] - 6*B[2][4][0][2] + 
     96*B[2][4][1][2] + 6*B[2][4][2][0] - 96*B[2][4][2][1] - 96*B[2][4][2][3] + 6*B[2][4][2][4] + 96*B[2][4][3][2] - 6*B[2][4][4][2] + 8*B[3][2][0][0] - 64*B[3][2][0][1] + 64*B[3][2][0][3] - 
     8*B[3][2][0][4] - 64*B[3][2][1][0] + 512*B[3][2][1][1] - 512*B[3][2][1][3] + 64*B[3][2][1][4] + 64*B[3][2][3][0] - 512*B[3][2][3][1] + 512*B[3][2][3][3] - 64*B[3][2][3][4] - 
     8*B[3][2][4][0] + 64*B[3][2][4][1] - 64*B[3][2][4][3] + 8*B[3][2][4][4] - B[4][2][0][0] + 8*B[4][2][0][1] - 8*B[4][2][0][3] + B[4][2][0][4] + 8*B[4][2][1][0] - 64*B[4][2][1][1] + 
     64*B[4][2][1][3] - 8*B[4][2][1][4] - 8*B[4][2][3][0] + 64*B[4][2][3][1] - 64*B[4][2][3][3] + 8*B[4][2][3][4] + B[4][2][4][0] - 8*B[4][2][4][1] + 8*B[4][2][4][3] - B[4][2][4][4])/6912. ; 
	    val0012i = 1./(DZ3)*(-B[2][2][0][0] + 8*B[2][2][0][1] - 8*B[2][2][0][3] + B[2][2][0][4] + 16*B[2][2][1][0] - 128*B[2][2][1][1] + 128*B[2][2][1][3] - 16*B[2][2][1][4] - 102*B[2][2][2][0] + 384*B[2][2][2][1] - 
     384*B[2][2][2][3] + 102*B[2][2][2][4] + 16*B[2][2][3][0] - 128*B[2][2][3][1] + 128*B[2][2][3][3] - 16*B[2][2][3][4] - B[2][2][4][0] + 8*B[2][2][4][1] - 8*B[2][2][4][3] + B[2][2][4][4])/
   1152. ; 
	    val2001i = 1./(DZ3)*(-B[0][0][0][2] + 8*B[0][0][1][2] - 8*B[0][0][3][2] + B[0][0][4][2] + 8*B[0][1][0][2] - 64*B[0][1][1][2] + 64*B[0][1][3][2] - 8*B[0][1][4][2] - 6*B[0][2][2][0] + 48*B[0][2][2][1] - 
     48*B[0][2][2][3] + 6*B[0][2][2][4] - 8*B[0][3][0][2] + 64*B[0][3][1][2] - 64*B[0][3][3][2] + 8*B[0][3][4][2] + B[0][4][0][2] - 8*B[0][4][1][2] + 8*B[0][4][3][2] - B[0][4][4][2] + 
     8*B[1][0][0][2] - 64*B[1][0][1][2] + 64*B[1][0][3][2] - 8*B[1][0][4][2] - 64*B[1][1][0][2] + 512*B[1][1][1][2] - 512*B[1][1][3][2] + 64*B[1][1][4][2] + 96*B[1][2][2][0] - 
     768*B[1][2][2][1] + 768*B[1][2][2][3] - 96*B[1][2][2][4] + 64*B[1][3][0][2] - 512*B[1][3][1][2] + 512*B[1][3][3][2] - 64*B[1][3][4][2] - 8*B[1][4][0][2] + 64*B[1][4][1][2] - 
     64*B[1][4][3][2] + 8*B[1][4][4][2] + 6*B[2][0][2][0] - 48*B[2][0][2][1] + 48*B[2][0][2][3] - 6*B[2][0][2][4] - 96*B[2][1][2][0] + 768*B[2][1][2][1] - 768*B[2][1][2][3] + 
     96*B[2][1][2][4] - 96*B[2][3][2][0] + 768*B[2][3][2][1] - 768*B[2][3][2][3] + 96*B[2][3][2][4] + 6*B[2][4][2][0] - 48*B[2][4][2][1] + 48*B[2][4][2][3] - 6*B[2][4][2][4] - 
     8*B[3][0][0][2] + 64*B[3][0][1][2] - 64*B[3][0][3][2] + 8*B[3][0][4][2] + 64*B[3][1][0][2] - 512*B[3][1][1][2] + 512*B[3][1][3][2] - 64*B[3][1][4][2] + 96*B[3][2][2][0] - 
     768*B[3][2][2][1] + 768*B[3][2][2][3] - 96*B[3][2][2][4] - 64*B[3][3][0][2] + 512*B[3][3][1][2] - 512*B[3][3][3][2] + 64*B[3][3][4][2] + 8*B[3][4][0][2] - 64*B[3][4][1][2] + 
     64*B[3][4][3][2] - 8*B[3][4][4][2] + B[4][0][0][2] - 8*B[4][0][1][2] + 8*B[4][0][3][2] - B[4][0][4][2] - 8*B[4][1][0][2] + 64*B[4][1][1][2] - 64*B[4][1][3][2] + 8*B[4][1][4][2] - 
     6*B[4][2][2][0] + 48*B[4][2][2][1] - 48*B[4][2][2][3] + 6*B[4][2][2][4] + 8*B[4][3][0][2] - 64*B[4][3][1][2] + 64*B[4][3][3][2] - 8*B[4][3][4][2] - B[4][4][0][2] + 8*B[4][4][1][2] - 
     8*B[4][4][3][2] + B[4][4][4][2])/6912. ; 
	    val2100i = 1./(DZ3)*(B[0][0][2][2] - 8*B[0][1][2][2] + 8*B[0][3][2][2] - B[0][4][2][2] - 16*B[1][0][2][2] + 128*B[1][1][2][2] - 128*B[1][3][2][2] + 16*B[1][4][2][2] + 102*B[2][0][2][2] - 384*B[2][1][2][2] + 
     384*B[2][3][2][2] - 102*B[2][4][2][2] - 16*B[3][0][2][2] + 128*B[3][1][2][2] - 128*B[3][3][2][2] + 16*B[3][4][2][2] + B[4][0][2][2] - 8*B[4][1][2][2] + 8*B[4][3][2][2] - B[4][4][2][2])/
   1152. ;
	    val3001i = 1./(DZ4)*(B[0][0][0][2] - 8*B[0][0][1][2] + B[0][0][2][0] - 8*B[0][0][2][1] + 8*B[0][0][2][3] - B[0][0][2][4] + 8*B[0][0][3][2] - B[0][0][4][2] - 8*B[0][1][0][2] + 64*B[0][1][1][2] - 16*B[0][1][2][0] + 
     128*B[0][1][2][1] - 128*B[0][1][2][3] + 16*B[0][1][2][4] - 64*B[0][1][3][2] + 8*B[0][1][4][2] + 6*B[0][2][2][0] - 48*B[0][2][2][1] + 48*B[0][2][2][3] - 6*B[0][2][2][4] + 
     8*B[0][3][0][2] - 64*B[0][3][1][2] - 16*B[0][3][2][0] + 128*B[0][3][2][1] - 128*B[0][3][2][3] + 16*B[0][3][2][4] + 64*B[0][3][3][2] - 8*B[0][3][4][2] - B[0][4][0][2] + 8*B[0][4][1][2] + 
     B[0][4][2][0] - 8*B[0][4][2][1] + 8*B[0][4][2][3] - B[0][4][2][4] - 8*B[0][4][3][2] + B[0][4][4][2] - 16*B[1][0][0][2] + 128*B[1][0][1][2] - 8*B[1][0][2][0] + 64*B[1][0][2][1] - 
     64*B[1][0][2][3] + 8*B[1][0][2][4] - 128*B[1][0][3][2] + 16*B[1][0][4][2] + 128*B[1][1][0][2] - 1024*B[1][1][1][2] + 128*B[1][1][2][0] - 1024*B[1][1][2][1] + 1024*B[1][1][2][3] - 
     128*B[1][1][2][4] + 1024*B[1][1][3][2] - 128*B[1][1][4][2] - 192*B[1][2][2][0] + 1536*B[1][2][2][1] - 1536*B[1][2][2][3] + 192*B[1][2][2][4] - 128*B[1][3][0][2] + 1024*B[1][3][1][2] + 
     128*B[1][3][2][0] - 1024*B[1][3][2][1] + 1024*B[1][3][2][3] - 128*B[1][3][2][4] - 1024*B[1][3][3][2] + 128*B[1][3][4][2] + 16*B[1][4][0][2] - 128*B[1][4][1][2] - 8*B[1][4][2][0] + 
     64*B[1][4][2][1] - 64*B[1][4][2][3] + 8*B[1][4][2][4] + 128*B[1][4][3][2] - 16*B[1][4][4][2] + 6*B[2][0][0][2] - 48*B[2][0][1][2] + 48*B[2][0][3][2] - 6*B[2][0][4][2] - 
     192*B[2][1][0][2] + 1536*B[2][1][1][2] - 1536*B[2][1][3][2] + 192*B[2][1][4][2] + 192*B[2][3][0][2] - 1536*B[2][3][1][2] + 1536*B[2][3][3][2] - 192*B[2][3][4][2] - 6*B[2][4][0][2] + 
     48*B[2][4][1][2] - 48*B[2][4][3][2] + 6*B[2][4][4][2] - 16*B[3][0][0][2] + 128*B[3][0][1][2] + 8*B[3][0][2][0] - 64*B[3][0][2][1] + 64*B[3][0][2][3] - 8*B[3][0][2][4] - 
     128*B[3][0][3][2] + 16*B[3][0][4][2] + 128*B[3][1][0][2] - 1024*B[3][1][1][2] - 128*B[3][1][2][0] + 1024*B[3][1][2][1] - 1024*B[3][1][2][3] + 128*B[3][1][2][4] + 1024*B[3][1][3][2] - 
     128*B[3][1][4][2] + 192*B[3][2][2][0] - 1536*B[3][2][2][1] + 1536*B[3][2][2][3] - 192*B[3][2][2][4] - 128*B[3][3][0][2] + 1024*B[3][3][1][2] - 128*B[3][3][2][0] + 1024*B[3][3][2][1] - 
     1024*B[3][3][2][3] + 128*B[3][3][2][4] - 1024*B[3][3][3][2] + 128*B[3][3][4][2] + 16*B[3][4][0][2] - 128*B[3][4][1][2] + 8*B[3][4][2][0] - 64*B[3][4][2][1] + 64*B[3][4][2][3] - 
     8*B[3][4][2][4] + 128*B[3][4][3][2] - 16*B[3][4][4][2] + B[4][0][0][2] - 8*B[4][0][1][2] - B[4][0][2][0] + 8*B[4][0][2][1] - 8*B[4][0][2][3] + B[4][0][2][4] + 8*B[4][0][3][2] - 
     B[4][0][4][2] - 8*B[4][1][0][2] + 64*B[4][1][1][2] + 16*B[4][1][2][0] - 128*B[4][1][2][1] + 128*B[4][1][2][3] - 16*B[4][1][2][4] - 64*B[4][1][3][2] + 8*B[4][1][4][2] - 6*B[4][2][2][0] + 
     48*B[4][2][2][1] - 48*B[4][2][2][3] + 6*B[4][2][2][4] + 8*B[4][3][0][2] - 64*B[4][3][1][2] + 16*B[4][3][2][0] - 128*B[4][3][2][1] + 128*B[4][3][2][3] - 16*B[4][3][2][4] + 
     64*B[4][3][3][2] - 8*B[4][3][4][2] - B[4][4][0][2] + 8*B[4][4][1][2] - B[4][4][2][0] + 8*B[4][4][2][1] - 8*B[4][4][2][3] + B[4][4][2][4] - 8*B[4][4][3][2] + B[4][4][4][2])/9216. ; 
	    val3100i = 1./(DZ4)*(B[0][0][2][2] - 5*B[0][1][2][2] + 5*B[0][3][2][2] - B[0][4][2][2] - 5*B[1][0][2][2] + 16*B[1][1][2][2] - 16*B[1][3][2][2] + 5*B[1][4][2][2] + 5*B[3][0][2][2] - 16*B[3][1][2][2] + 
     16*B[3][3][2][2] - 5*B[3][4][2][2] - B[4][0][2][2] + 5*B[4][1][2][2] - 5*B[4][3][2][2] + B[4][4][2][2])/96. ; 
	    val1003i = 1./(DZ4)*(-B[0][2][0][0] + 8*B[0][2][0][1] - 8*B[0][2][0][3] + B[0][2][0][4] + 16*B[0][2][1][0] - 128*B[0][2][1][1] + 128*B[0][2][1][3] - 16*B[0][2][1][4] - 6*B[0][2][2][0] + 192*B[0][2][2][1] - 
     192*B[0][2][2][3] + 6*B[0][2][2][4] + 16*B[0][2][3][0] - 128*B[0][2][3][1] + 128*B[0][2][3][3] - 16*B[0][2][3][4] - B[0][2][4][0] + 8*B[0][2][4][1] - 8*B[0][2][4][3] + B[0][2][4][4] + 
     8*B[1][2][0][0] - 64*B[1][2][0][1] + 64*B[1][2][0][3] - 8*B[1][2][0][4] - 128*B[1][2][1][0] + 1024*B[1][2][1][1] - 1024*B[1][2][1][3] + 128*B[1][2][1][4] + 48*B[1][2][2][0] - 
     1536*B[1][2][2][1] + 1536*B[1][2][2][3] - 48*B[1][2][2][4] - 128*B[1][2][3][0] + 1024*B[1][2][3][1] - 1024*B[1][2][3][3] + 128*B[1][2][3][4] + 8*B[1][2][4][0] - 64*B[1][2][4][1] + 
     64*B[1][2][4][3] - 8*B[1][2][4][4] - B[2][0][0][0] + 16*B[2][0][0][1] - 6*B[2][0][0][2] + 16*B[2][0][0][3] - B[2][0][0][4] + 8*B[2][0][1][0] - 128*B[2][0][1][1] + 192*B[2][0][1][2] - 
     128*B[2][0][1][3] + 8*B[2][0][1][4] - 8*B[2][0][3][0] + 128*B[2][0][3][1] - 192*B[2][0][3][2] + 128*B[2][0][3][3] - 8*B[2][0][3][4] + B[2][0][4][0] - 16*B[2][0][4][1] + 6*B[2][0][4][2] - 
     16*B[2][0][4][3] + B[2][0][4][4] + 8*B[2][1][0][0] - 128*B[2][1][0][1] + 48*B[2][1][0][2] - 128*B[2][1][0][3] + 8*B[2][1][0][4] - 64*B[2][1][1][0] + 1024*B[2][1][1][1] - 
     1536*B[2][1][1][2] + 1024*B[2][1][1][3] - 64*B[2][1][1][4] + 64*B[2][1][3][0] - 1024*B[2][1][3][1] + 1536*B[2][1][3][2] - 1024*B[2][1][3][3] + 64*B[2][1][3][4] - 8*B[2][1][4][0] + 
     128*B[2][1][4][1] - 48*B[2][1][4][2] + 128*B[2][1][4][3] - 8*B[2][1][4][4] - 8*B[2][3][0][0] + 128*B[2][3][0][1] - 48*B[2][3][0][2] + 128*B[2][3][0][3] - 8*B[2][3][0][4] + 
     64*B[2][3][1][0] - 1024*B[2][3][1][1] + 1536*B[2][3][1][2] - 1024*B[2][3][1][3] + 64*B[2][3][1][4] - 64*B[2][3][3][0] + 1024*B[2][3][3][1] - 1536*B[2][3][3][2] + 1024*B[2][3][3][3] - 
     64*B[2][3][3][4] + 8*B[2][3][4][0] - 128*B[2][3][4][1] + 48*B[2][3][4][2] - 128*B[2][3][4][3] + 8*B[2][3][4][4] + B[2][4][0][0] - 16*B[2][4][0][1] + 6*B[2][4][0][2] - 16*B[2][4][0][3] + 
     B[2][4][0][4] - 8*B[2][4][1][0] + 128*B[2][4][1][1] - 192*B[2][4][1][2] + 128*B[2][4][1][3] - 8*B[2][4][1][4] + 8*B[2][4][3][0] - 128*B[2][4][3][1] + 192*B[2][4][3][2] - 
     128*B[2][4][3][3] + 8*B[2][4][3][4] - B[2][4][4][0] + 16*B[2][4][4][1] - 6*B[2][4][4][2] + 16*B[2][4][4][3] - B[2][4][4][4] - 8*B[3][2][0][0] + 64*B[3][2][0][1] - 64*B[3][2][0][3] + 
     8*B[3][2][0][4] + 128*B[3][2][1][0] - 1024*B[3][2][1][1] + 1024*B[3][2][1][3] - 128*B[3][2][1][4] - 48*B[3][2][2][0] + 1536*B[3][2][2][1] - 1536*B[3][2][2][3] + 48*B[3][2][2][4] + 
     128*B[3][2][3][0] - 1024*B[3][2][3][1] + 1024*B[3][2][3][3] - 128*B[3][2][3][4] - 8*B[3][2][4][0] + 64*B[3][2][4][1] - 64*B[3][2][4][3] + 8*B[3][2][4][4] + B[4][2][0][0] - 
     8*B[4][2][0][1] + 8*B[4][2][0][3] - B[4][2][0][4] - 16*B[4][2][1][0] + 128*B[4][2][1][1] - 128*B[4][2][1][3] + 16*B[4][2][1][4] + 6*B[4][2][2][0] - 192*B[4][2][2][1] + 
     192*B[4][2][2][3] - 6*B[4][2][2][4] - 16*B[4][2][3][0] + 128*B[4][2][3][1] - 128*B[4][2][3][3] + 16*B[4][2][3][4] + B[4][2][4][0] - 8*B[4][2][4][1] + 8*B[4][2][4][3] - B[4][2][4][4])/
   9216. ; 
	    val0031i = 1./(DZ4)*(B[2][2][0][0] - 5*B[2][2][0][1] + 5*B[2][2][0][3] - B[2][2][0][4] - 5*B[2][2][1][0] + 16*B[2][2][1][1] - 16*B[2][2][1][3] + 5*B[2][2][1][4] + 5*B[2][2][3][0] - 16*B[2][2][3][1] + 
     16*B[2][2][3][3] - 5*B[2][2][3][4] - B[2][2][4][0] + 5*B[2][2][4][1] - 5*B[2][2][4][3] + B[2][2][4][4])/96. ; 
	    val2200i = 0. ; 
	    val0022i = 0. ; 
	    val0220i = 1./(DZ4)*((-B[0][0][0][2] + 16*B[0][0][1][2] + B[0][0][2][0] - 16*B[0][0][2][1] - 16*B[0][0][2][3] + B[0][0][2][4] + 16*B[0][0][3][2] - B[0][0][4][2] + 8*B[0][1][0][2] - 128*B[0][1][1][2] - 
     8*B[0][1][2][0] + 128*B[0][1][2][1] + 128*B[0][1][2][3] - 8*B[0][1][2][4] - 128*B[0][1][3][2] + 8*B[0][1][4][2] + B[0][2][0][0] - 8*B[0][2][0][1] + 8*B[0][2][0][3] - B[0][2][0][4] - 
     8*B[0][2][1][0] + 64*B[0][2][1][1] - 64*B[0][2][1][3] + 8*B[0][2][1][4] + 8*B[0][2][3][0] - 64*B[0][2][3][1] + 64*B[0][2][3][3] - 8*B[0][2][3][4] - B[0][2][4][0] + 8*B[0][2][4][1] - 
     8*B[0][2][4][3] + B[0][2][4][4] - 8*B[0][3][0][2] + 128*B[0][3][1][2] + 8*B[0][3][2][0] - 128*B[0][3][2][1] - 128*B[0][3][2][3] + 8*B[0][3][2][4] + 128*B[0][3][3][2] - 8*B[0][3][4][2] + 
     B[0][4][0][2] - 16*B[0][4][1][2] - B[0][4][2][0] + 16*B[0][4][2][1] + 16*B[0][4][2][3] - B[0][4][2][4] - 16*B[0][4][3][2] + B[0][4][4][2] + 8*B[1][0][0][2] - 128*B[1][0][1][2] - 
     8*B[1][0][2][0] + 128*B[1][0][2][1] + 128*B[1][0][2][3] - 8*B[1][0][2][4] - 128*B[1][0][3][2] + 8*B[1][0][4][2] - 64*B[1][1][0][2] + 1024*B[1][1][1][2] + 64*B[1][1][2][0] - 
     1024*B[1][1][2][1] - 1024*B[1][1][2][3] + 64*B[1][1][2][4] + 1024*B[1][1][3][2] - 64*B[1][1][4][2] - 16*B[1][2][0][0] + 128*B[1][2][0][1] - 128*B[1][2][0][3] + 16*B[1][2][0][4] + 
     128*B[1][2][1][0] - 1024*B[1][2][1][1] + 1024*B[1][2][1][3] - 128*B[1][2][1][4] - 128*B[1][2][3][0] + 1024*B[1][2][3][1] - 1024*B[1][2][3][3] + 128*B[1][2][3][4] + 16*B[1][2][4][0] - 
     128*B[1][2][4][1] + 128*B[1][2][4][3] - 16*B[1][2][4][4] + 64*B[1][3][0][2] - 1024*B[1][3][1][2] - 64*B[1][3][2][0] + 1024*B[1][3][2][1] + 1024*B[1][3][2][3] - 64*B[1][3][2][4] - 
     1024*B[1][3][3][2] + 64*B[1][3][4][2] - 8*B[1][4][0][2] + 128*B[1][4][1][2] + 8*B[1][4][2][0] - 128*B[1][4][2][1] - 128*B[1][4][2][3] + 8*B[1][4][2][4] + 128*B[1][4][3][2] - 
     8*B[1][4][4][2] - B[2][0][0][0] + 8*B[2][0][0][1] - 8*B[2][0][0][3] + B[2][0][0][4] + 8*B[2][0][1][0] - 64*B[2][0][1][1] + 64*B[2][0][1][3] - 8*B[2][0][1][4] - 8*B[2][0][3][0] + 
     64*B[2][0][3][1] - 64*B[2][0][3][3] + 8*B[2][0][3][4] + B[2][0][4][0] - 8*B[2][0][4][1] + 8*B[2][0][4][3] - B[2][0][4][4] + 16*B[2][1][0][0] - 128*B[2][1][0][1] + 128*B[2][1][0][3] - 
     16*B[2][1][0][4] - 128*B[2][1][1][0] + 1024*B[2][1][1][1] - 1024*B[2][1][1][3] + 128*B[2][1][1][4] + 128*B[2][1][3][0] - 1024*B[2][1][3][1] + 1024*B[2][1][3][3] - 128*B[2][1][3][4] - 
     16*B[2][1][4][0] + 128*B[2][1][4][1] - 128*B[2][1][4][3] + 16*B[2][1][4][4] + 16*B[2][3][0][0] - 128*B[2][3][0][1] + 128*B[2][3][0][3] - 16*B[2][3][0][4] - 128*B[2][3][1][0] + 
     1024*B[2][3][1][1] - 1024*B[2][3][1][3] + 128*B[2][3][1][4] + 128*B[2][3][3][0] - 1024*B[2][3][3][1] + 1024*B[2][3][3][3] - 128*B[2][3][3][4] - 16*B[2][3][4][0] + 128*B[2][3][4][1] - 
     128*B[2][3][4][3] + 16*B[2][3][4][4] - B[2][4][0][0] + 8*B[2][4][0][1] - 8*B[2][4][0][3] + B[2][4][0][4] + 8*B[2][4][1][0] - 64*B[2][4][1][1] + 64*B[2][4][1][3] - 8*B[2][4][1][4] - 
     8*B[2][4][3][0] + 64*B[2][4][3][1] - 64*B[2][4][3][3] + 8*B[2][4][3][4] + B[2][4][4][0] - 8*B[2][4][4][1] + 8*B[2][4][4][3] - B[2][4][4][4] - 8*B[3][0][0][2] + 128*B[3][0][1][2] + 
     8*B[3][0][2][0] - 128*B[3][0][2][1] - 128*B[3][0][2][3] + 8*B[3][0][2][4] + 128*B[3][0][3][2] - 8*B[3][0][4][2] + 64*B[3][1][0][2] - 1024*B[3][1][1][2] - 64*B[3][1][2][0] + 
     1024*B[3][1][2][1] + 1024*B[3][1][2][3] - 64*B[3][1][2][4] - 1024*B[3][1][3][2] + 64*B[3][1][4][2] - 16*B[3][2][0][0] + 128*B[3][2][0][1] - 128*B[3][2][0][3] + 16*B[3][2][0][4] + 
     128*B[3][2][1][0] - 1024*B[3][2][1][1] + 1024*B[3][2][1][3] - 128*B[3][2][1][4] - 128*B[3][2][3][0] + 1024*B[3][2][3][1] - 1024*B[3][2][3][3] + 128*B[3][2][3][4] + 16*B[3][2][4][0] - 
     128*B[3][2][4][1] + 128*B[3][2][4][3] - 16*B[3][2][4][4] - 64*B[3][3][0][2] + 1024*B[3][3][1][2] + 64*B[3][3][2][0] - 1024*B[3][3][2][1] - 1024*B[3][3][2][3] + 64*B[3][3][2][4] + 
     1024*B[3][3][3][2] - 64*B[3][3][4][2] + 8*B[3][4][0][2] - 128*B[3][4][1][2] - 8*B[3][4][2][0] + 128*B[3][4][2][1] + 128*B[3][4][2][3] - 8*B[3][4][2][4] - 128*B[3][4][3][2] + 
     8*B[3][4][4][2] + B[4][0][0][2] - 16*B[4][0][1][2] - B[4][0][2][0] + 16*B[4][0][2][1] + 16*B[4][0][2][3] - B[4][0][2][4] - 16*B[4][0][3][2] + B[4][0][4][2] - 8*B[4][1][0][2] + 
     128*B[4][1][1][2] + 8*B[4][1][2][0] - 128*B[4][1][2][1] - 128*B[4][1][2][3] + 8*B[4][1][2][4] + 128*B[4][1][3][2] - 8*B[4][1][4][2] + B[4][2][0][0] - 8*B[4][2][0][1] + 8*B[4][2][0][3] - 
     B[4][2][0][4] - 8*B[4][2][1][0] + 64*B[4][2][1][1] - 64*B[4][2][1][3] + 8*B[4][2][1][4] + 8*B[4][2][3][0] - 64*B[4][2][3][1] + 64*B[4][2][3][3] - 8*B[4][2][3][4] - B[4][2][4][0] + 
     8*B[4][2][4][1] - 8*B[4][2][4][3] + B[4][2][4][4] + 8*B[4][3][0][2] - 128*B[4][3][1][2] - 8*B[4][3][2][0] + 128*B[4][3][2][1] + 128*B[4][3][2][3] - 8*B[4][3][2][4] - 128*B[4][3][3][2] + 
     8*B[4][3][4][2] - B[4][4][0][2] + 16*B[4][4][1][2] + B[4][4][2][0] - 16*B[4][4][2][1] - 16*B[4][4][2][3] + B[4][4][2][4] + 16*B[4][4][3][2] - B[4][4][4][2])/13824.) ; 
	    val2110i = 1./(DZ4)*(B[0][0][0][2] - 8*B[0][0][1][2] + B[0][0][2][0] - 8*B[0][0][2][1] + 8*B[0][0][2][3] - B[0][0][2][4] + 8*B[0][0][3][2] - B[0][0][4][2] - 8*B[0][1][0][2] + 64*B[0][1][1][2] - 16*B[0][1][2][0] + 
     128*B[0][1][2][1] - 128*B[0][1][2][3] + 16*B[0][1][2][4] - 64*B[0][1][3][2] + 8*B[0][1][4][2] + 102*B[0][2][2][0] - 816*B[0][2][2][1] + 816*B[0][2][2][3] - 102*B[0][2][2][4] + 
     8*B[0][3][0][2] - 64*B[0][3][1][2] - 16*B[0][3][2][0] + 128*B[0][3][2][1] - 128*B[0][3][2][3] + 16*B[0][3][2][4] + 64*B[0][3][3][2] - 8*B[0][3][4][2] - B[0][4][0][2] + 8*B[0][4][1][2] + 
     B[0][4][2][0] - 8*B[0][4][2][1] + 8*B[0][4][2][3] - B[0][4][2][4] - 8*B[0][4][3][2] + B[0][4][4][2] - 16*B[1][0][0][2] + 128*B[1][0][1][2] - 8*B[1][0][2][0] + 64*B[1][0][2][1] - 
     64*B[1][0][2][3] + 8*B[1][0][2][4] - 128*B[1][0][3][2] + 16*B[1][0][4][2] + 128*B[1][1][0][2] - 1024*B[1][1][1][2] + 128*B[1][1][2][0] - 1024*B[1][1][2][1] + 1024*B[1][1][2][3] - 
     128*B[1][1][2][4] + 1024*B[1][1][3][2] - 128*B[1][1][4][2] - 384*B[1][2][2][0] + 3072*B[1][2][2][1] - 3072*B[1][2][2][3] + 384*B[1][2][2][4] - 128*B[1][3][0][2] + 1024*B[1][3][1][2] + 
     128*B[1][3][2][0] - 1024*B[1][3][2][1] + 1024*B[1][3][2][3] - 128*B[1][3][2][4] - 1024*B[1][3][3][2] + 128*B[1][3][4][2] + 16*B[1][4][0][2] - 128*B[1][4][1][2] - 8*B[1][4][2][0] + 
     64*B[1][4][2][1] - 64*B[1][4][2][3] + 8*B[1][4][2][4] + 128*B[1][4][3][2] - 16*B[1][4][4][2] + 102*B[2][0][0][2] - 816*B[2][0][1][2] + 816*B[2][0][3][2] - 102*B[2][0][4][2] - 
     384*B[2][1][0][2] + 3072*B[2][1][1][2] - 3072*B[2][1][3][2] + 384*B[2][1][4][2] + 384*B[2][3][0][2] - 3072*B[2][3][1][2] + 3072*B[2][3][3][2] - 384*B[2][3][4][2] - 102*B[2][4][0][2] + 
     816*B[2][4][1][2] - 816*B[2][4][3][2] + 102*B[2][4][4][2] - 16*B[3][0][0][2] + 128*B[3][0][1][2] + 8*B[3][0][2][0] - 64*B[3][0][2][1] + 64*B[3][0][2][3] - 8*B[3][0][2][4] - 
     128*B[3][0][3][2] + 16*B[3][0][4][2] + 128*B[3][1][0][2] - 1024*B[3][1][1][2] - 128*B[3][1][2][0] + 1024*B[3][1][2][1] - 1024*B[3][1][2][3] + 128*B[3][1][2][4] + 1024*B[3][1][3][2] - 
     128*B[3][1][4][2] + 384*B[3][2][2][0] - 3072*B[3][2][2][1] + 3072*B[3][2][2][3] - 384*B[3][2][2][4] - 128*B[3][3][0][2] + 1024*B[3][3][1][2] - 128*B[3][3][2][0] + 1024*B[3][3][2][1] - 
     1024*B[3][3][2][3] + 128*B[3][3][2][4] - 1024*B[3][3][3][2] + 128*B[3][3][4][2] + 16*B[3][4][0][2] - 128*B[3][4][1][2] + 8*B[3][4][2][0] - 64*B[3][4][2][1] + 64*B[3][4][2][3] - 
     8*B[3][4][2][4] + 128*B[3][4][3][2] - 16*B[3][4][4][2] + B[4][0][0][2] - 8*B[4][0][1][2] - B[4][0][2][0] + 8*B[4][0][2][1] - 8*B[4][0][2][3] + B[4][0][2][4] + 8*B[4][0][3][2] - 
     B[4][0][4][2] - 8*B[4][1][0][2] + 64*B[4][1][1][2] + 16*B[4][1][2][0] - 128*B[4][1][2][1] + 128*B[4][1][2][3] - 16*B[4][1][2][4] - 64*B[4][1][3][2] + 8*B[4][1][4][2] - 
     102*B[4][2][2][0] + 816*B[4][2][2][1] - 816*B[4][2][2][3] + 102*B[4][2][2][4] + 8*B[4][3][0][2] - 64*B[4][3][1][2] + 16*B[4][3][2][0] - 128*B[4][3][2][1] + 128*B[4][3][2][3] - 
     16*B[4][3][2][4] + 64*B[4][3][3][2] - 8*B[4][3][4][2] - B[4][4][0][2] + 8*B[4][4][1][2] - B[4][4][2][0] + 8*B[4][4][2][1] - 8*B[4][4][2][3] + B[4][4][2][4] - 8*B[4][4][3][2] + B[4][4][4][2])
    /27648. ; 
	    val2101i = 1./(DZ4)*(B[0][0][0][2] - 8*B[0][0][1][2] - B[0][0][2][0] + 8*B[0][0][2][1] - 8*B[0][0][2][3] + B[0][0][2][4] + 8*B[0][0][3][2] - B[0][0][4][2] - 8*B[0][1][0][2] + 64*B[0][1][1][2] + 16*B[0][1][2][0] - 
     128*B[0][1][2][1] + 128*B[0][1][2][3] - 16*B[0][1][2][4] - 64*B[0][1][3][2] + 8*B[0][1][4][2] - 102*B[0][2][2][0] + 816*B[0][2][2][1] - 816*B[0][2][2][3] + 102*B[0][2][2][4] + 
     8*B[0][3][0][2] - 64*B[0][3][1][2] + 16*B[0][3][2][0] - 128*B[0][3][2][1] + 128*B[0][3][2][3] - 16*B[0][3][2][4] + 64*B[0][3][3][2] - 8*B[0][3][4][2] - B[0][4][0][2] + 8*B[0][4][1][2] - 
     B[0][4][2][0] + 8*B[0][4][2][1] - 8*B[0][4][2][3] + B[0][4][2][4] - 8*B[0][4][3][2] + B[0][4][4][2] - 16*B[1][0][0][2] + 128*B[1][0][1][2] + 8*B[1][0][2][0] - 64*B[1][0][2][1] + 
     64*B[1][0][2][3] - 8*B[1][0][2][4] - 128*B[1][0][3][2] + 16*B[1][0][4][2] + 128*B[1][1][0][2] - 1024*B[1][1][1][2] - 128*B[1][1][2][0] + 1024*B[1][1][2][1] - 1024*B[1][1][2][3] + 
     128*B[1][1][2][4] + 1024*B[1][1][3][2] - 128*B[1][1][4][2] + 384*B[1][2][2][0] - 3072*B[1][2][2][1] + 3072*B[1][2][2][3] - 384*B[1][2][2][4] - 128*B[1][3][0][2] + 1024*B[1][3][1][2] - 
     128*B[1][3][2][0] + 1024*B[1][3][2][1] - 1024*B[1][3][2][3] + 128*B[1][3][2][4] - 1024*B[1][3][3][2] + 128*B[1][3][4][2] + 16*B[1][4][0][2] - 128*B[1][4][1][2] + 8*B[1][4][2][0] - 
     64*B[1][4][2][1] + 64*B[1][4][2][3] - 8*B[1][4][2][4] + 128*B[1][4][3][2] - 16*B[1][4][4][2] + 102*B[2][0][0][2] - 816*B[2][0][1][2] + 816*B[2][0][3][2] - 102*B[2][0][4][2] - 
     384*B[2][1][0][2] + 3072*B[2][1][1][2] - 3072*B[2][1][3][2] + 384*B[2][1][4][2] + 384*B[2][3][0][2] - 3072*B[2][3][1][2] + 3072*B[2][3][3][2] - 384*B[2][3][4][2] - 102*B[2][4][0][2] + 
     816*B[2][4][1][2] - 816*B[2][4][3][2] + 102*B[2][4][4][2] - 16*B[3][0][0][2] + 128*B[3][0][1][2] - 8*B[3][0][2][0] + 64*B[3][0][2][1] - 64*B[3][0][2][3] + 8*B[3][0][2][4] - 
     128*B[3][0][3][2] + 16*B[3][0][4][2] + 128*B[3][1][0][2] - 1024*B[3][1][1][2] + 128*B[3][1][2][0] - 1024*B[3][1][2][1] + 1024*B[3][1][2][3] - 128*B[3][1][2][4] + 1024*B[3][1][3][2] - 
     128*B[3][1][4][2] - 384*B[3][2][2][0] + 3072*B[3][2][2][1] - 3072*B[3][2][2][3] + 384*B[3][2][2][4] - 128*B[3][3][0][2] + 1024*B[3][3][1][2] + 128*B[3][3][2][0] - 1024*B[3][3][2][1] + 
     1024*B[3][3][2][3] - 128*B[3][3][2][4] - 1024*B[3][3][3][2] + 128*B[3][3][4][2] + 16*B[3][4][0][2] - 128*B[3][4][1][2] - 8*B[3][4][2][0] + 64*B[3][4][2][1] - 64*B[3][4][2][3] + 
     8*B[3][4][2][4] + 128*B[3][4][3][2] - 16*B[3][4][4][2] + B[4][0][0][2] - 8*B[4][0][1][2] + B[4][0][2][0] - 8*B[4][0][2][1] + 8*B[4][0][2][3] - B[4][0][2][4] + 8*B[4][0][3][2] - 
     B[4][0][4][2] - 8*B[4][1][0][2] + 64*B[4][1][1][2] - 16*B[4][1][2][0] + 128*B[4][1][2][1] - 128*B[4][1][2][3] + 16*B[4][1][2][4] - 64*B[4][1][3][2] + 8*B[4][1][4][2] + 
     102*B[4][2][2][0] - 816*B[4][2][2][1] + 816*B[4][2][2][3] - 102*B[4][2][2][4] + 8*B[4][3][0][2] - 64*B[4][3][1][2] - 16*B[4][3][2][0] + 128*B[4][3][2][1] - 128*B[4][3][2][3] + 
     16*B[4][3][2][4] + 64*B[4][3][3][2] - 8*B[4][3][4][2] - B[4][4][0][2] + 8*B[4][4][1][2] + B[4][4][2][0] - 8*B[4][4][2][1] + 8*B[4][4][2][3] - B[4][4][2][4] - 8*B[4][4][3][2] + B[4][4][4][2])
    /27648. ; 
	    val1021i = 1./(DZ4)*(B[0][2][0][0] - 8*B[0][2][0][1] + 8*B[0][2][0][3] - B[0][2][0][4] - 16*B[0][2][1][0] + 128*B[0][2][1][1] - 128*B[0][2][1][3] + 16*B[0][2][1][4] + 102*B[0][2][2][0] - 384*B[0][2][2][1] + 
     384*B[0][2][2][3] - 102*B[0][2][2][4] - 16*B[0][2][3][0] + 128*B[0][2][3][1] - 128*B[0][2][3][3] + 16*B[0][2][3][4] + B[0][2][4][0] - 8*B[0][2][4][1] + 8*B[0][2][4][3] - B[0][2][4][4] - 
     8*B[1][2][0][0] + 64*B[1][2][0][1] - 64*B[1][2][0][3] + 8*B[1][2][0][4] + 128*B[1][2][1][0] - 1024*B[1][2][1][1] + 1024*B[1][2][1][3] - 128*B[1][2][1][4] - 816*B[1][2][2][0] + 
     3072*B[1][2][2][1] - 3072*B[1][2][2][3] + 816*B[1][2][2][4] + 128*B[1][2][3][0] - 1024*B[1][2][3][1] + 1024*B[1][2][3][3] - 128*B[1][2][3][4] - 8*B[1][2][4][0] + 64*B[1][2][4][1] - 
     64*B[1][2][4][3] + 8*B[1][2][4][4] + B[2][0][0][0] - 16*B[2][0][0][1] + 102*B[2][0][0][2] - 16*B[2][0][0][3] + B[2][0][0][4] - 8*B[2][0][1][0] + 128*B[2][0][1][1] - 384*B[2][0][1][2] + 
     128*B[2][0][1][3] - 8*B[2][0][1][4] + 8*B[2][0][3][0] - 128*B[2][0][3][1] + 384*B[2][0][3][2] - 128*B[2][0][3][3] + 8*B[2][0][3][4] - B[2][0][4][0] + 16*B[2][0][4][1] - 
     102*B[2][0][4][2] + 16*B[2][0][4][3] - B[2][0][4][4] - 8*B[2][1][0][0] + 128*B[2][1][0][1] - 816*B[2][1][0][2] + 128*B[2][1][0][3] - 8*B[2][1][0][4] + 64*B[2][1][1][0] - 
     1024*B[2][1][1][1] + 3072*B[2][1][1][2] - 1024*B[2][1][1][3] + 64*B[2][1][1][4] - 64*B[2][1][3][0] + 1024*B[2][1][3][1] - 3072*B[2][1][3][2] + 1024*B[2][1][3][3] - 64*B[2][1][3][4] + 
     8*B[2][1][4][0] - 128*B[2][1][4][1] + 816*B[2][1][4][2] - 128*B[2][1][4][3] + 8*B[2][1][4][4] + 8*B[2][3][0][0] - 128*B[2][3][0][1] + 816*B[2][3][0][2] - 128*B[2][3][0][3] + 
     8*B[2][3][0][4] - 64*B[2][3][1][0] + 1024*B[2][3][1][1] - 3072*B[2][3][1][2] + 1024*B[2][3][1][3] - 64*B[2][3][1][4] + 64*B[2][3][3][0] - 1024*B[2][3][3][1] + 3072*B[2][3][3][2] - 
     1024*B[2][3][3][3] + 64*B[2][3][3][4] - 8*B[2][3][4][0] + 128*B[2][3][4][1] - 816*B[2][3][4][2] + 128*B[2][3][4][3] - 8*B[2][3][4][4] - B[2][4][0][0] + 16*B[2][4][0][1] - 
     102*B[2][4][0][2] + 16*B[2][4][0][3] - B[2][4][0][4] + 8*B[2][4][1][0] - 128*B[2][4][1][1] + 384*B[2][4][1][2] - 128*B[2][4][1][3] + 8*B[2][4][1][4] - 8*B[2][4][3][0] + 
     128*B[2][4][3][1] - 384*B[2][4][3][2] + 128*B[2][4][3][3] - 8*B[2][4][3][4] + B[2][4][4][0] - 16*B[2][4][4][1] + 102*B[2][4][4][2] - 16*B[2][4][4][3] + B[2][4][4][4] + 8*B[3][2][0][0] - 
     64*B[3][2][0][1] + 64*B[3][2][0][3] - 8*B[3][2][0][4] - 128*B[3][2][1][0] + 1024*B[3][2][1][1] - 1024*B[3][2][1][3] + 128*B[3][2][1][4] + 816*B[3][2][2][0] - 3072*B[3][2][2][1] + 
     3072*B[3][2][2][3] - 816*B[3][2][2][4] - 128*B[3][2][3][0] + 1024*B[3][2][3][1] - 1024*B[3][2][3][3] + 128*B[3][2][3][4] + 8*B[3][2][4][0] - 64*B[3][2][4][1] + 64*B[3][2][4][3] - 
     8*B[3][2][4][4] - B[4][2][0][0] + 8*B[4][2][0][1] - 8*B[4][2][0][3] + B[4][2][0][4] + 16*B[4][2][1][0] - 128*B[4][2][1][1] + 128*B[4][2][1][3] - 16*B[4][2][1][4] - 102*B[4][2][2][0] + 
     384*B[4][2][2][1] - 384*B[4][2][2][3] + 102*B[4][2][2][4] + 16*B[4][2][3][0] - 128*B[4][2][3][1] + 128*B[4][2][3][3] - 16*B[4][2][3][4] - B[4][2][4][0] + 8*B[4][2][4][1] - 
     8*B[4][2][4][3] + B[4][2][4][4])/27648. ; 
	    val0121i = 1./(DZ4)*(B[0][2][0][0] - 8*B[0][2][0][1] + 8*B[0][2][0][3] - B[0][2][0][4] - 16*B[0][2][1][0] + 128*B[0][2][1][1] - 128*B[0][2][1][3] + 16*B[0][2][1][4] + 102*B[0][2][2][0] - 384*B[0][2][2][1] + 
     384*B[0][2][2][3] - 102*B[0][2][2][4] - 16*B[0][2][3][0] + 128*B[0][2][3][1] - 128*B[0][2][3][3] + 16*B[0][2][3][4] + B[0][2][4][0] - 8*B[0][2][4][1] + 8*B[0][2][4][3] - B[0][2][4][4] - 
     8*B[1][2][0][0] + 64*B[1][2][0][1] - 64*B[1][2][0][3] + 8*B[1][2][0][4] + 128*B[1][2][1][0] - 1024*B[1][2][1][1] + 1024*B[1][2][1][3] - 128*B[1][2][1][4] - 816*B[1][2][2][0] + 
     3072*B[1][2][2][1] - 3072*B[1][2][2][3] + 816*B[1][2][2][4] + 128*B[1][2][3][0] - 1024*B[1][2][3][1] + 1024*B[1][2][3][3] - 128*B[1][2][3][4] - 8*B[1][2][4][0] + 64*B[1][2][4][1] - 
     64*B[1][2][4][3] + 8*B[1][2][4][4] - B[2][0][0][0] + 16*B[2][0][0][1] - 102*B[2][0][0][2] + 16*B[2][0][0][3] - B[2][0][0][4] + 8*B[2][0][1][0] - 128*B[2][0][1][1] + 384*B[2][0][1][2] - 
     128*B[2][0][1][3] + 8*B[2][0][1][4] - 8*B[2][0][3][0] + 128*B[2][0][3][1] - 384*B[2][0][3][2] + 128*B[2][0][3][3] - 8*B[2][0][3][4] + B[2][0][4][0] - 16*B[2][0][4][1] + 
     102*B[2][0][4][2] - 16*B[2][0][4][3] + B[2][0][4][4] + 8*B[2][1][0][0] - 128*B[2][1][0][1] + 816*B[2][1][0][2] - 128*B[2][1][0][3] + 8*B[2][1][0][4] - 64*B[2][1][1][0] + 
     1024*B[2][1][1][1] - 3072*B[2][1][1][2] + 1024*B[2][1][1][3] - 64*B[2][1][1][4] + 64*B[2][1][3][0] - 1024*B[2][1][3][1] + 3072*B[2][1][3][2] - 1024*B[2][1][3][3] + 64*B[2][1][3][4] - 
     8*B[2][1][4][0] + 128*B[2][1][4][1] - 816*B[2][1][4][2] + 128*B[2][1][4][3] - 8*B[2][1][4][4] - 8*B[2][3][0][0] + 128*B[2][3][0][1] - 816*B[2][3][0][2] + 128*B[2][3][0][3] - 
     8*B[2][3][0][4] + 64*B[2][3][1][0] - 1024*B[2][3][1][1] + 3072*B[2][3][1][2] - 1024*B[2][3][1][3] + 64*B[2][3][1][4] - 64*B[2][3][3][0] + 1024*B[2][3][3][1] - 3072*B[2][3][3][2] + 
     1024*B[2][3][3][3] - 64*B[2][3][3][4] + 8*B[2][3][4][0] - 128*B[2][3][4][1] + 816*B[2][3][4][2] - 128*B[2][3][4][3] + 8*B[2][3][4][4] + B[2][4][0][0] - 16*B[2][4][0][1] + 
     102*B[2][4][0][2] - 16*B[2][4][0][3] + B[2][4][0][4] - 8*B[2][4][1][0] + 128*B[2][4][1][1] - 384*B[2][4][1][2] + 128*B[2][4][1][3] - 8*B[2][4][1][4] + 8*B[2][4][3][0] - 
     128*B[2][4][3][1] + 384*B[2][4][3][2] - 128*B[2][4][3][3] + 8*B[2][4][3][4] - B[2][4][4][0] + 16*B[2][4][4][1] - 102*B[2][4][4][2] + 16*B[2][4][4][3] - B[2][4][4][4] + 8*B[3][2][0][0] - 
     64*B[3][2][0][1] + 64*B[3][2][0][3] - 8*B[3][2][0][4] - 128*B[3][2][1][0] + 1024*B[3][2][1][1] - 1024*B[3][2][1][3] + 128*B[3][2][1][4] + 816*B[3][2][2][0] - 3072*B[3][2][2][1] + 
     3072*B[3][2][2][3] - 816*B[3][2][2][4] - 128*B[3][2][3][0] + 1024*B[3][2][3][1] - 1024*B[3][2][3][3] + 128*B[3][2][3][4] + 8*B[3][2][4][0] - 64*B[3][2][4][1] + 64*B[3][2][4][3] - 
     8*B[3][2][4][4] - B[4][2][0][0] + 8*B[4][2][0][1] - 8*B[4][2][0][3] + B[4][2][0][4] + 16*B[4][2][1][0] - 128*B[4][2][1][1] + 128*B[4][2][1][3] - 16*B[4][2][1][4] - 102*B[4][2][2][0] + 
     384*B[4][2][2][1] - 384*B[4][2][2][3] + 102*B[4][2][2][4] + 16*B[4][2][3][0] - 128*B[4][2][3][1] + 128*B[4][2][3][3] - 16*B[4][2][3][4] - B[4][2][4][0] + 8*B[4][2][4][1] - 
     8*B[4][2][4][3] + B[4][2][4][4])/27648. ; 
	    val2011i = 1./(DZ4)*(B[0][0][0][2] - 16*B[0][0][1][2] + B[0][0][2][0] - 16*B[0][0][2][1] + 60*B[0][0][2][2] - 16*B[0][0][2][3] + B[0][0][2][4] - 16*B[0][0][3][2] + B[0][0][4][2] - 8*B[0][1][0][2] + 
     128*B[0][1][1][2] - 8*B[0][1][2][0] + 128*B[0][1][2][1] - 480*B[0][1][2][2] + 128*B[0][1][2][3] - 8*B[0][1][2][4] + 128*B[0][1][3][2] - 8*B[0][1][4][2] + 8*B[0][3][0][2] - 
     128*B[0][3][1][2] + 8*B[0][3][2][0] - 128*B[0][3][2][1] + 480*B[0][3][2][2] - 128*B[0][3][2][3] + 8*B[0][3][2][4] - 128*B[0][3][3][2] + 8*B[0][3][4][2] - B[0][4][0][2] + 
     16*B[0][4][1][2] - B[0][4][2][0] + 16*B[0][4][2][1] - 60*B[0][4][2][2] + 16*B[0][4][2][3] - B[0][4][2][4] + 16*B[0][4][3][2] - B[0][4][4][2] - 8*B[1][0][0][2] + 128*B[1][0][1][2] - 
     8*B[1][0][2][0] + 128*B[1][0][2][1] - 480*B[1][0][2][2] + 128*B[1][0][2][3] - 8*B[1][0][2][4] + 128*B[1][0][3][2] - 8*B[1][0][4][2] + 64*B[1][1][0][2] - 1024*B[1][1][1][2] + 
     64*B[1][1][2][0] - 1024*B[1][1][2][1] + 3840*B[1][1][2][2] - 1024*B[1][1][2][3] + 64*B[1][1][2][4] - 1024*B[1][1][3][2] + 64*B[1][1][4][2] - 64*B[1][3][0][2] + 1024*B[1][3][1][2] - 
     64*B[1][3][2][0] + 1024*B[1][3][2][1] - 3840*B[1][3][2][2] + 1024*B[1][3][2][3] - 64*B[1][3][2][4] + 1024*B[1][3][3][2] - 64*B[1][3][4][2] + 8*B[1][4][0][2] - 128*B[1][4][1][2] + 
     8*B[1][4][2][0] - 128*B[1][4][2][1] + 480*B[1][4][2][2] - 128*B[1][4][2][3] + 8*B[1][4][2][4] - 128*B[1][4][3][2] + 8*B[1][4][4][2] + 8*B[3][0][0][2] - 128*B[3][0][1][2] + 
     8*B[3][0][2][0] - 128*B[3][0][2][1] + 480*B[3][0][2][2] - 128*B[3][0][2][3] + 8*B[3][0][2][4] - 128*B[3][0][3][2] + 8*B[3][0][4][2] - 64*B[3][1][0][2] + 1024*B[3][1][1][2] - 
     64*B[3][1][2][0] + 1024*B[3][1][2][1] - 3840*B[3][1][2][2] + 1024*B[3][1][2][3] - 64*B[3][1][2][4] + 1024*B[3][1][3][2] - 64*B[3][1][4][2] + 64*B[3][3][0][2] - 1024*B[3][3][1][2] + 
     64*B[3][3][2][0] - 1024*B[3][3][2][1] + 3840*B[3][3][2][2] - 1024*B[3][3][2][3] + 64*B[3][3][2][4] - 1024*B[3][3][3][2] + 64*B[3][3][4][2] - 8*B[3][4][0][2] + 128*B[3][4][1][2] - 
     8*B[3][4][2][0] + 128*B[3][4][2][1] - 480*B[3][4][2][2] + 128*B[3][4][2][3] - 8*B[3][4][2][4] + 128*B[3][4][3][2] - 8*B[3][4][4][2] - B[4][0][0][2] + 16*B[4][0][1][2] - B[4][0][2][0] + 
     16*B[4][0][2][1] - 60*B[4][0][2][2] + 16*B[4][0][2][3] - B[4][0][2][4] + 16*B[4][0][3][2] - B[4][0][4][2] + 8*B[4][1][0][2] - 128*B[4][1][1][2] + 8*B[4][1][2][0] - 128*B[4][1][2][1] + 
     480*B[4][1][2][2] - 128*B[4][1][2][3] + 8*B[4][1][2][4] - 128*B[4][1][3][2] + 8*B[4][1][4][2] - 8*B[4][3][0][2] + 128*B[4][3][1][2] - 8*B[4][3][2][0] + 128*B[4][3][2][1] - 
     480*B[4][3][2][2] + 128*B[4][3][2][3] - 8*B[4][3][2][4] + 128*B[4][3][3][2] - 8*B[4][3][4][2] + B[4][4][0][2] - 16*B[4][4][1][2] + B[4][4][2][0] - 16*B[4][4][2][1] + 60*B[4][4][2][2] - 
     16*B[4][4][2][3] + B[4][4][2][4] - 16*B[4][4][3][2] + B[4][4][4][2])/13824. ; 
	    val1120i = 1./(DZ4)*(B[0][2][0][0] - 8*B[0][2][0][1] + 8*B[0][2][0][3] - B[0][2][0][4] - 8*B[0][2][1][0] + 64*B[0][2][1][1] - 64*B[0][2][1][3] + 8*B[0][2][1][4] + 8*B[0][2][3][0] - 64*B[0][2][3][1] + 
     64*B[0][2][3][3] - 8*B[0][2][3][4] - B[0][2][4][0] + 8*B[0][2][4][1] - 8*B[0][2][4][3] + B[0][2][4][4] - 16*B[1][2][0][0] + 128*B[1][2][0][1] - 128*B[1][2][0][3] + 16*B[1][2][0][4] + 
     128*B[1][2][1][0] - 1024*B[1][2][1][1] + 1024*B[1][2][1][3] - 128*B[1][2][1][4] - 128*B[1][2][3][0] + 1024*B[1][2][3][1] - 1024*B[1][2][3][3] + 128*B[1][2][3][4] + 16*B[1][2][4][0] - 
     128*B[1][2][4][1] + 128*B[1][2][4][3] - 16*B[1][2][4][4] + B[2][0][0][0] - 8*B[2][0][0][1] + 8*B[2][0][0][3] - B[2][0][0][4] - 8*B[2][0][1][0] + 64*B[2][0][1][1] - 64*B[2][0][1][3] + 
     8*B[2][0][1][4] + 8*B[2][0][3][0] - 64*B[2][0][3][1] + 64*B[2][0][3][3] - 8*B[2][0][3][4] - B[2][0][4][0] + 8*B[2][0][4][1] - 8*B[2][0][4][3] + B[2][0][4][4] - 16*B[2][1][0][0] + 
     128*B[2][1][0][1] - 128*B[2][1][0][3] + 16*B[2][1][0][4] + 128*B[2][1][1][0] - 1024*B[2][1][1][1] + 1024*B[2][1][1][3] - 128*B[2][1][1][4] - 128*B[2][1][3][0] + 1024*B[2][1][3][1] - 
     1024*B[2][1][3][3] + 128*B[2][1][3][4] + 16*B[2][1][4][0] - 128*B[2][1][4][1] + 128*B[2][1][4][3] - 16*B[2][1][4][4] + 60*B[2][2][0][0] - 480*B[2][2][0][1] + 480*B[2][2][0][3] - 
     60*B[2][2][0][4] - 480*B[2][2][1][0] + 3840*B[2][2][1][1] - 3840*B[2][2][1][3] + 480*B[2][2][1][4] + 480*B[2][2][3][0] - 3840*B[2][2][3][1] + 3840*B[2][2][3][3] - 480*B[2][2][3][4] - 
     60*B[2][2][4][0] + 480*B[2][2][4][1] - 480*B[2][2][4][3] + 60*B[2][2][4][4] - 16*B[2][3][0][0] + 128*B[2][3][0][1] - 128*B[2][3][0][3] + 16*B[2][3][0][4] + 128*B[2][3][1][0] - 
     1024*B[2][3][1][1] + 1024*B[2][3][1][3] - 128*B[2][3][1][4] - 128*B[2][3][3][0] + 1024*B[2][3][3][1] - 1024*B[2][3][3][3] + 128*B[2][3][3][4] + 16*B[2][3][4][0] - 128*B[2][3][4][1] + 
     128*B[2][3][4][3] - 16*B[2][3][4][4] + B[2][4][0][0] - 8*B[2][4][0][1] + 8*B[2][4][0][3] - B[2][4][0][4] - 8*B[2][4][1][0] + 64*B[2][4][1][1] - 64*B[2][4][1][3] + 8*B[2][4][1][4] + 
     8*B[2][4][3][0] - 64*B[2][4][3][1] + 64*B[2][4][3][3] - 8*B[2][4][3][4] - B[2][4][4][0] + 8*B[2][4][4][1] - 8*B[2][4][4][3] + B[2][4][4][4] - 16*B[3][2][0][0] + 128*B[3][2][0][1] - 
     128*B[3][2][0][3] + 16*B[3][2][0][4] + 128*B[3][2][1][0] - 1024*B[3][2][1][1] + 1024*B[3][2][1][3] - 128*B[3][2][1][4] - 128*B[3][2][3][0] + 1024*B[3][2][3][1] - 1024*B[3][2][3][3] + 
     128*B[3][2][3][4] + 16*B[3][2][4][0] - 128*B[3][2][4][1] + 128*B[3][2][4][3] - 16*B[3][2][4][4] + B[4][2][0][0] - 8*B[4][2][0][1] + 8*B[4][2][0][3] - B[4][2][0][4] - 8*B[4][2][1][0] + 
     64*B[4][2][1][1] - 64*B[4][2][1][3] + 8*B[4][2][1][4] + 8*B[4][2][3][0] - 64*B[4][2][3][1] + 64*B[4][2][3][3] - 8*B[4][2][3][4] - B[4][2][4][0] + 8*B[4][2][4][1] - 8*B[4][2][4][3] + 
     B[4][2][4][4])/13824. ; 
	    val1111i = 0. ;

	  }


	  K1100 = complex<double>(val1100r,val1100i) ; 
	  K0011 = complex<double>(val0011r,val0011i) ; 
	  K0110 = complex<double>(val0110r,val0110i) ; 
	  K1011 = complex<double>(val1011r,val1011i) ; 
	  K1110 = complex<double>(val1110r,val1110i) ; 
	  K1002 = complex<double>(val1002r,val1002i) ; 
	  K0012 = complex<double>(val0012r,val0012i) ; 
	  K2001 = complex<double>(val2001r,val2001i) ; 
	  K2100 = complex<double>(val2100r,val2100i) ;
	  K3001 = complex<double>(val3001r,val3001i) ; 
	  K3100 = complex<double>(val3100r,val3100i) ; 
	  K1003 = complex<double>(val1003r,val1003i) ; 
	  K0031 = complex<double>(val0031r,val0031i) ; 
	  K2200 = complex<double>(val2200r,val2200i) ; 
	  K0022 = complex<double>(val0022r,val0022i) ; 
	  K0220 = complex<double>(val0220r,val0220i) ; 
	  K2110 = complex<double>(val2110r,val2110i) ; 
	  K2101 = complex<double>(val2101r,val2101i) ; 
	  K1021 = complex<double>(val1021r,val1021i) ; 
	  K0121 = complex<double>(val0121r,val0121i) ; 
	  K2011 = complex<double>(val2011r,val2011i) ; 
	  K1120 = complex<double>(val1120r,val1120i) ; 
	  K1111 = complex<double>(val1111r,val1111i) ;

	  K1100c = conj(K1100) ;
	  K0011c = conj(K0011) ;
	  K0110c = conj(K0110) ;
	  K1011c = conj(K1011) ;
	  K1110c = conj(K1110) ;
	  K1002c = conj(K1002) ;
	  K0012c = conj(K0012) ;
	  K2001c = conj(K2001) ;
	  K2100c = conj(K2100) ;
	  K3001c = conj(K3001) ;
	  K3100c = conj(K3100) ;
	  K1003c = conj(K1003) ;
	  K0031c = conj(K0031) ;
	  K2200c = conj(K2200) ;
	  K0022c = conj(K0022) ;
	  K0220c = conj(K0220) ;
	  K2110c = conj(K2110) ;
	  K2101c = conj(K2101) ;
	  K1021c = conj(K1021) ;
	  K0121c = conj(K0121) ;
	  K2011c = conj(K2011) ;
	  K1120c = conj(K1120) ;
	  K1111c = conj(K1111) ;



	  R2dzz = 2.*( K2100*K2100c - K1100*K2200 )/pow(K1100,3) ;



	  Rww = -((K0110*K0110c - K0011*K1100)*(K1110*K1110c - K1100*K1111 + K2001*K2001c - K1011c*K2100 - K1011*K2100c + K0110*K2101 + K0110c*K2101c - K0011*K2200)) ;

	  Ryy = -((K0110*K0110c - K0011*K1100)*(K0110*K0220c - K0121c*K1100 + K1002*K1110 - K1011*K1110c + K0110c*K1111 + K1011c*K2001 - K0012*K2100 - K0011*K2101)) ;

	  Rwy = -((K0110*K0110c - K0011*K1100)*(K0110c*K0121 + K0110*K0121c + K1002*K1002c + K1011*K1011c - K0022*K1100 - K0012*K1110 - K0012c*K1110c - K0011*K1111)) ;
	  


	  Rwwww = K0110*(K1011*K1110c - K0110c*K1111 - K1011c*K2001 + K0011*K2101) + K0011*(K2001*K2001c - K1011*K2100c + K0110c*K2101c - K0011*K2200) ;

	  Rwwwy = K0011*(-(K2001c*K2100) + K1110*K2100c - K1100*K2101c) + K0110*(-(K1110*K1110c) + K1100*K1111 + K1011c*K2100 + K0011*K2200) - K2101*pow(K0110,2) ;

	  Rwwyw = -(K1100*(K1011*K1110c - K0110c*K1111 - K1011c*K2001 + K0011*K2101)) + K0110c*(-(K2001*K2001c) + K1011*K2100c - K0110c*K2101c + K0011*K2200) ;

	  Rwwyy = K1100*(K1110*K1110c - K1011c*K2100 + K0110*K2101 + K0110c*K2101c) - K0110c*(-(K2001c*K2100) + K1110*K2100c + K0110*K2200) - K1111*pow(K1100,2) ;


	  Rwyww = K0110*(-(K0110c*K0121c) + K0011*K0220c + K1002*K1011 - K0012*K2001) + K0011*(-(K1011*K1110c) + K0110c*K1111 + K1011c*K2001 - K0011*K2101) ;

	  Rwywy = K0011*(K1110*K1110c - K1100*K1111 - K1011c*K2100) + K0110*(K0121c*K1100 - K1002*K1110 + K0012*K2100 + K0011*K2101) - K0220c*pow(K0110,2) ;

	  Rwyyw = -(K1100*(-(K0110c*K0121c) + K0011*K0220c + K1002*K1011 - K0012*K2001)) + K0110c*(K1011*K1110c - K0110c*K1111 - K1011c*K2001 + K0011*K2101) ;

	  Rwyyy = -(K1100*(-(K0110*K0220c) + K0121c*K1100 - K1002*K1110 + K0012*K2100)) + K0110c*(-(K1110*K1110c) + K1100*K1111 + K1011c*K2100 - K0110*K2101) ;


	  Rywww = K0110*(-(K0110c*K0121) - K1011*K1011c + K0012c*K1110c + K0011*K1111) + K0011*(K0110c*K0220 + K1011*K2001c - K0012c*K2100c - K0011*K2101c) ;

	  Rywwy = -(K0011*(K0220*K1100 + K1110*K2001c - K1002c*K2100c)) + K0110*(K0121*K1100 + K1011c*K1110 - K1002c*K1110c + K0011*K2101c) - K1111*pow(K0110,2) ;

	  Rywyw = K1100*(K0110c*K0121 + K1011*K1011c - K0012c*K1110c - K0011*K1111) + K0110c*(-(K0110c*K0220) - K1011*K2001c + K0012c*K2100c + K0011*K2101c) ;

	  Rywyy = -(K1100*(K0121*K1100 + K1011c*K1110 - K1002c*K1110c - K0110*K1111)) + K0110c*(K0220*K1100 + K1110*K2001c - K1002c*K2100c - K0110*K2101c) ;


	  Ryyww = K0110*(-(K0022*K0110c) + K0011*K0121c + K0012c*K1002 - K0012*K1011) - K0011*(-(K0110c*K0121) - K1011*K1011c + K0012c*K1110c + K0011*K1111) ;

	  Ryywy = -(K0011*(K0121*K1100 + K1011c*K1110 - K1002c*K1110c)) + K0110*(-(K1002*K1002c) + K0022*K1100 + K0012*K1110 + K0011*K1111) - K0121c*pow(K0110,2) ;

	  Ryyyw = (K0022*K0110c - K0011*K0121c - K0012c*K1002 + K0012*K1011)*K1100 + K0110c*(-(K0110c*K0121) - K1011*K1011c + K0012c*K1110c + K0011*K1111) ;

	  Ryyyy = -(K1100*(-(K0110*K0121c) - K1002*K1002c + K0022*K1100 + K0012*K1110)) + K0110c*(K0121*K1100 + K1011c*K1110 - K1002c*K1110c - K0110*K1111) ; 


	  Kretch = 4.*(Rwwww*Rwwww + Rwwwy*Rwyww + Rwwyw*Rywww + Rwwyy*Ryyww + Rwyww*Rwwwy + Rwywy*Rwywy + Rwyyw*Rywwy + Rwyyy*Ryywy + Rywww*Rwwyw + Rywwy*Rwyyw + Rywyw*Rywyw + Rywyy*Ryyyw + Ryyww*Rwwyy + Ryywy*Rwyyy + Ryyyw*Rywyy + Ryyyy*Ryyyy) ;



	  Kretch *= (1/pow(rootdetg,4)) ;


	  valarr[0] = Kretch.real() ;
	  valarr[1] = 0.     ;
	  valarr[2] = R2dzz.real()  ;

	  /* New */

	  valarr[3] = K0011.real()  ;
	  valarr[4] = K1100.real()  ;
	  
}



