(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    912011,      24828]
NotebookOptionsPosition[    895582,      24351]
NotebookOutlinePosition[    896939,      24399]
CellTagsIndexPosition[    896865,      24394]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell["Dynamic AdS/CMT - Superconductor - Spectral", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.507011572545054*^9, 3.460340667971311*^9}, {
   3.5374843541262083`*^9, 3.537484358716886*^9}, 3.537484391202265*^9, {
   3.537484629914453*^9, 3.537484630281348*^9}, {3.5374893532274837`*^9, 
   3.537489358050692*^9}, {3.53749388933057*^9, 3.537493890193932*^9}, {
   3.537578587160997*^9, 3.5375785895997057`*^9}, {3.537578682265374*^9, 
   3.537578682504321*^9}, {3.537578812305402*^9, 3.537578812720454*^9}, 
   3.5388963971621933`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"hmm\"\>"], "Print",
 CellChangeTimes->{3.53880794268043*^9, 3.5388094999351063`*^9, 
  3.538892998666171*^9, 3.53889645098283*^9, 3.538979528949913*^9, 
  3.53898012705364*^9, 3.538981317400914*^9, 3.538981796127643*^9, 
  3.5389820917483377`*^9, 3.538982161211855*^9, 3.539000830464136*^9, 
  3.539019433030471*^9, 3.539020189670974*^9, 3.53902136240936*^9, 
  3.5390216637658653`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
   "gzz"}], "}"}]], "Output",
 CellChangeTimes->{3.538807942880889*^9, 3.538809500119602*^9, 
  3.5388929991734333`*^9, 3.538896451199483*^9, 3.538979529016914*^9, 
  3.538980127123599*^9, 3.538981317485361*^9, 3.538981796216423*^9, 
  3.5389820919321527`*^9, 3.538982161312271*^9, 3.5390008308258047`*^9, 
  3.5390194331458263`*^9, 3.539020189946422*^9, 3.5390213626311083`*^9, 
  3.539021663914132*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gtt", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "grr", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "g\[Theta]\[Theta]", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "g\[Phi]\[Phi]", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "gzz"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807942880889*^9, 3.538809500119602*^9, 
  3.5388929991734333`*^9, 3.538896451199483*^9, 3.538979529016914*^9, 
  3.538980127123599*^9, 3.538981317485361*^9, 3.538981796216423*^9, 
  3.5389820919321527`*^9, 3.538982161312271*^9, 3.5390008308258047`*^9, 
  3.5390194331458263`*^9, 3.539020189946422*^9, 3.5390213626311083`*^9, 
  3.53902166391678*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{3.538807942964953*^9, 3.5388095002033463`*^9, 
  3.538892999259852*^9, 3.5388964512545843`*^9, 3.538979529056551*^9, 
  3.538980127173682*^9, 3.5389813175657997`*^9, 3.538981796412012*^9, 
  3.538982091985169*^9, 3.538982161369693*^9, 3.53900083088561*^9, 
  3.539019433202754*^9, 3.539020189996832*^9, 3.5390213626817493`*^9, 
  3.539021663974633*^9}],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{3.538807942964953*^9, 3.5388095002033463`*^9, 
  3.538892999259852*^9, 3.5388964512545843`*^9, 3.538979529056551*^9, 
  3.538980127173682*^9, 3.5389813175657997`*^9, 3.538981796412012*^9, 
  3.538982091985169*^9, 3.538982161369693*^9, 3.53900083088561*^9, 
  3.539019433202754*^9, 3.539020189996832*^9, 3.5390213626817493`*^9, 
  3.539021663977219*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807943254242*^9, 3.5388095003420277`*^9, 
  3.538893001752389*^9, 3.5388964518555117`*^9, 3.5389795299519033`*^9, 
  3.53898012732451*^9, 3.538981317682467*^9, 3.538981796565856*^9, 
  3.53898209211976*^9, 3.538982161662394*^9, 3.5390008310805807`*^9, 
  3.539019433518054*^9, 3.539020190161743*^9, 3.539021362860845*^9, 
  3.539021664167873*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{3.538807943254242*^9, 3.5388095003420277`*^9, 
  3.538893001752389*^9, 3.5388964518555117`*^9, 3.5389795299519033`*^9, 
  3.53898012732451*^9, 3.538981317682467*^9, 3.538981796565856*^9, 
  3.53898209211976*^9, 3.538982161662394*^9, 3.5390008310805807`*^9, 
  3.539019433518054*^9, 3.539020190161743*^9, 3.539021362860845*^9, 
  3.539021664169334*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"-", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "0", "0"},
       {
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}], "0"},
       {"0", "0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.507011580676421*^9, 3.507011659804162*^9}, {3.507013755598536*^9, 
   3.460392698323369*^9}, {3.4604018613321533`*^9, 3.4604018646719627`*^9}, {
   3.460401965632374*^9, 3.460401968163259*^9}, {3.4604023388162813`*^9, 
   3.4604023558966084`*^9}, {3.460402422665003*^9, 3.460402426690833*^9}, {
   3.460402628586185*^9, 3.4604026419139843`*^9}, {3.460402674350209*^9, 
   3.4604026844332027`*^9}, {3.460512773931822*^9, 3.460512787444798*^9}, {
   3.4605146484667263`*^9, 3.460514650350994*^9}, {3.460514717258254*^9, 
   3.460514724283691*^9}, 3.460514770989304*^9, 3.4605223140457373`*^9, {
   3.4605327188171663`*^9, 3.460532727004561*^9}, {3.460532863547011*^9, 
   3.460532865145266*^9}, {3.460532977769042*^9, 3.4605329860852757`*^9}, {
   3.507275497143169*^9, 3.4603659980232763`*^9}, {3.537484515197036*^9, 
   3.537484572210073*^9}, 3.537484644682625*^9, {3.5374846959240923`*^9, 
   3.537484701892157*^9}, {3.537484976337736*^9, 3.5374849917355137`*^9}, {
   3.537486594817341*^9, 3.537486596777007*^9}, 3.5389801006793118`*^9, {
   3.538981763049244*^9, 3.5389817648798733`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     FractionBox[
      RowBox[{"gzz", "[", 
       RowBox[{"v", ",", "z"}], "]"}], 
      SuperscriptBox["z", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.5388095008098*^9, 
  3.538893002447278*^9, 3.538896452961425*^9, 3.538979530356739*^9, 
  3.538980127808568*^9, 3.538981318120203*^9, 3.538981796980805*^9, 
  3.538982092537773*^9, 3.5389821620802183`*^9, 3.539000831566564*^9, 
  3.5390194341498404`*^9, 3.539020190683815*^9, 3.539021363262617*^9, 
  3.539021664553123*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.5388095008098*^9, 
  3.538893002447278*^9, 3.538896452961425*^9, 3.538979530356739*^9, 
  3.538980127808568*^9, 3.538981318120203*^9, 3.538981796980805*^9, 
  3.538982092537773*^9, 3.5389821620802183`*^9, 3.539000831566564*^9, 
  3.5390194341498404`*^9, 3.539020190683815*^9, 3.539021363262617*^9, 
  3.539021664556816*^9}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.5388095008098*^9, 
  3.538893002447278*^9, 3.538896452961425*^9, 3.538979530356739*^9, 
  3.538980127808568*^9, 3.538981318120203*^9, 3.538981796980805*^9, 
  3.538982092537773*^9, 3.5389821620802183`*^9, 3.539000831566564*^9, 
  3.5390194341498404`*^9, 3.539020190683815*^9, 3.539021363262617*^9, 
  3.539021664559276*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     FractionBox[
      RowBox[{"gzz", "[", 
       RowBox[{"v", ",", "z"}], "]"}], 
      SuperscriptBox["z", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807943934894*^9, 3.538809500888975*^9, 
  3.53889300261425*^9, 3.538896453190695*^9, 3.5389795304059067`*^9, 
  3.538980127858921*^9, 3.538981318156057*^9, 3.538981797086912*^9, 
  3.5389820925869102`*^9, 3.538982162133662*^9, 3.5390008316161537`*^9, 
  3.539019434205138*^9, 3.5390201907337303`*^9, 3.539021363367537*^9, 
  3.539021664648666*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
       RowBox[{
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["z", "2"], 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["z", "2"], 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807944009327*^9, 3.538809500962566*^9, 
  3.538893002689948*^9, 3.5388964532649927`*^9, 3.5389795304695263`*^9, 
  3.53898012791265*^9, 3.538981318206324*^9, 3.5389817971550093`*^9, 
  3.538982092623928*^9, 3.538982162188591*^9, 3.539000831797398*^9, 
  3.5390194342520123`*^9, 3.539020190788684*^9, 3.5390213634133787`*^9, 
  3.539021664690345*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
      RowBox[{
       RowBox[{"gzz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   SuperscriptBox["z", "8"]]}]], "Output",
 CellChangeTimes->{3.538807944075788*^9, 3.538809501123672*^9, 
  3.5388930027566423`*^9, 3.538896453331575*^9, 3.53897953051038*^9, 
  3.538980127963372*^9, 3.538981318256308*^9, 3.538981797223036*^9, 
  3.5389820926693068`*^9, 3.538982162233295*^9, 3.539000831853414*^9, 
  3.539019434305544*^9, 3.5390201909297047`*^9, 3.5390213634631767`*^9, 
  3.539021664724901*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",\

 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",\

 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{"Simplify", "[", "R2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041067188341103`*^9, 3.404106720182616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"GT", "[", 
       RowBox[{"R2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "A", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"A", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"v", ",", "d"}], "}"}], "}"}], ",", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"ST", "[", 
    RowBox[{"A", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"z", ",", "d"}], "}"}], "}"}], ",", 
     RowBox[{"az", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451383976248069*^9, 3.4513840125908737`*^9}, {
  3.451384057147691*^9, 3.451384064689735*^9}, {3.451385762395092*^9, 
  3.451385762480318*^9}, {3.451385800913571*^9, 3.451385805770357*^9}, {
  3.537484677141605*^9, 3.53748468964509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "F", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"F", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"F", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i1", "]"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4041040239360247`*^9, 3.404104073416904*^9}, {
  3.4041057167733383`*^9, 3.4041057183570337`*^9}, {3.4513840707957897`*^9, 
  3.451384164343499*^9}, {3.460366100458836*^9, 3.460366108909464*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"trFF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"trT", "[", 
      RowBox[{
       RowBox[{"outerT", "[", 
        RowBox[{"F", ",", "F"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fsqr", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"trT", "[", 
     RowBox[{"trFF", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.404103126230957*^9, 3.404103206051724*^9}, 
   3.404103788928409*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "Dp", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"Dp", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Dp", "=", 
       RowBox[{"ST", "[", 
        RowBox[{"Dp", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[Phi]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
          RowBox[{"I", " ", 
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], 
           RowBox[{"\[Phi]", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConjDp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"Conjugate", "[", 
       RowBox[{"Dp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DpDp", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"trT", "[", 
       RowBox[{
        RowBox[{"outerT", "[", 
         RowBox[{"ConjDp", ",", "Dp"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Vterm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Phi]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "]"}], 
       RowBox[{"\[Phi]", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513844331121693`*^9, 3.451384521665413*^9}, {
   3.451384560554626*^9, 3.451384642158163*^9}, {3.4513849100950413`*^9, 
   3.451384915054587*^9}, 3.451385051803838*^9, {3.4513851171366262`*^9, 
   3.45138511927711*^9}, {3.451385175930884*^9, 3.451385183167452*^9}, {
   3.451385425505906*^9, 3.45138544324051*^9}, {3.451385490350021*^9, 
   3.451385493946774*^9}, {3.451385568392873*^9, 3.451385601054823*^9}, {
   3.451385813165941*^9, 3.4513858527683163`*^9}, {3.45138608116168*^9, 
   3.451386103913107*^9}, {3.46036707784975*^9, 3.460255762501432*^9}, {
   3.46025580130457*^9, 3.460255801461816*^9}, {3.53748492894665*^9, 
   3.53748495518618*^9}, {3.537485329580826*^9, 3.537485331297533*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DpDp", "=", 
   RowBox[{"(", 
    RowBox[{"DpDp", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", "xx_", "]"}], "\[Rule]", "xx"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", "xx_", "]"}], "\[Rule]", "0"}]}], "}"}]}], ")"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.451385894732107*^9, 3.451385976334114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrtdetg", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Det", "[", 
       RowBox[{"-", "Gd"}], "]"}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041041692972*^9, 3.404104211096949*^9}, 
   3.404105293940057*^9, {3.4513842180130997`*^9, 3.4513842223260803`*^9}, {
   3.4513846617079067`*^9, 3.451384675916638*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"sqrtdetg", 
    RowBox[{"(", 
     RowBox[{"Ricci", "+", "6", "-", 
      RowBox[{
       FractionBox["1", "4"], "Fsqr"}], "-", "DpDp", "-", "Vterm"}], 
     ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.451384367735067*^9, 3.451384393946628*^9}, {
   3.4513849054437723`*^9, 3.4513849068431387`*^9}, {3.451385606138598*^9, 
   3.451385607193993*^9}, 3.460366276193363*^9, {3.4603670917067547`*^9, 
   3.460255829896731*^9}, 3.537493905932642*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.53748653613297*^9, 3.5374865918283*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GHBT", "+=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
     "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460366441552243*^9, 3.460366544772176*^9}, {
  3.4603665879440317`*^9, 3.460366626391823*^9}, {3.537486655723679*^9, 
  3.537486732610427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L", "-", "GHBT"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460366546941235*^9, 3.460366557341961*^9}, 
   3.460366686117609*^9, {3.4603672960654507`*^9, 3.4603672977104673`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"L2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.460366666517003*^9, 3.460366674775579*^9}, {3.537486746662644*^9, 
  3.5374867639666147`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.538809506685401*^9, 
  3.538893008907069*^9, 3.538896459564533*^9, 3.538979534229912*^9, 
  3.5389801303762093`*^9, 3.538981320621297*^9, 3.538981800870338*^9, 
  3.5389820964069853`*^9, 3.538982165936513*^9, 3.5390008355191603`*^9, 
  3.539019438406395*^9, 3.539020194955126*^9, 3.5390213673344*^9, 
  3.5390216683725843`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.538809506685401*^9, 
  3.538893008907069*^9, 3.538896459564533*^9, 3.538979534229912*^9, 
  3.5389801303762093`*^9, 3.538981320621297*^9, 3.538981800870338*^9, 
  3.5389820964069853`*^9, 3.538982165936513*^9, 3.5390008355191603`*^9, 
  3.539019438406395*^9, 3.539020194955126*^9, 3.5390213673344*^9, 
  3.539021668410737*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.538809506685401*^9, 
  3.538893008907069*^9, 3.538896459564533*^9, 3.538979534229912*^9, 
  3.5389801303762093`*^9, 3.538981320621297*^9, 3.538981800870338*^9, 
  3.5389820964069853`*^9, 3.538982165936513*^9, 3.5390008355191603`*^9, 
  3.539019438406395*^9, 3.539020194955126*^9, 3.5390213673344*^9, 
  3.5390216684132557`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.538809506685401*^9, 
  3.538893008907069*^9, 3.538896459564533*^9, 3.538979534229912*^9, 
  3.5389801303762093`*^9, 3.538981320621297*^9, 3.538981800870338*^9, 
  3.5389820964069853`*^9, 3.538982165936513*^9, 3.5390008355191603`*^9, 
  3.539019438406395*^9, 3.539020194955126*^9, 3.5390213673344*^9, 
  3.539021668465786*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"EOM", "[", "fld_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{"D", "[", 
      RowBox[{"L2", ",", "fld"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"tmp2", "=", 
           RowBox[{"D", "[", 
            RowBox[{"fld", ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ")"}], "=!=", "0"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "-=", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"L2", ",", "tmp2"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "tmp"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.4513849546200113`*^9, 3.451385039242148*^9}, {
  3.4603662728020573`*^9, 3.460366273871294*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqp", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"p", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513848144544163`*^9, 3.4513848150159073`*^9}, {
  3.451384869337384*^9, 3.451384875673843*^9}, {3.451384929950244*^9, 
  3.451384930100154*^9}, {3.451385060851385*^9, 3.451385213396349*^9}, {
  3.451385293160893*^9, 3.451385302528058*^9}, {3.4513853749547167`*^9, 
  3.45138537639461*^9}, {3.451385514552088*^9, 3.451385527943191*^9}, {
  3.451385862306609*^9, 3.451385882826736*^9}, {3.451386138230373*^9, 
  3.451386140019012*^9}, {3.451386241895258*^9, 3.4513862693654633`*^9}, {
  3.4603675858592987`*^9, 3.4603675914720583`*^9}, {3.537486779881022*^9, 
  3.537486784922683*^9}, {3.537486894453556*^9, 3.5374869009568243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqav", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"av", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"az", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513855403702793`*^9, 3.451385540823719*^9}, {
  3.4513861532442207`*^9, 3.45138616739637*^9}, {3.451386251199284*^9, 
  3.4513862656960487`*^9}, {3.460367593073217*^9, 3.460367597640524*^9}, {
  3.5374867866028214`*^9, 3.537486788378339*^9}, {3.537486891597521*^9, 
  3.537486937732339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqgvz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gvz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqgzz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gzz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqT", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"T", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqS", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451386275930722*^9, 3.451386303859261*^9}, {
  3.460366711720347*^9, 3.4603667226381903`*^9}, {3.460367599130735*^9, 
  3.460367611985876*^9}, {3.53748678993122*^9, 3.53748680663302*^9}, {
  3.537486911477583*^9, 3.5374869187572203`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"gvz", ",", "gzz", ",", "az"}], "]"}]], "Input",
 CellChangeTimes->{{3.53748694036823*^9, 3.537486945275868*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gvz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gzz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"az", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.460366755240944*^9, 3.460366765921853*^9}, {
   3.460379717667384*^9, 3.460379720321673*^9}, {3.4603938524268913`*^9, 
   3.4603938546559877`*^9}, 3.4603939628549967`*^9, {3.5374868640225983`*^9, 
   3.537486876197587*^9}, {3.537486924492758*^9, 3.537486925572747*^9}, {
   3.537487030062772*^9, 3.537487030117689*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqp2", "=", 
   RowBox[{"Simplify", "[", "eqp", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]2", "=", 
   RowBox[{"Simplify", "[", "eq\[Alpha]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqav2", "=", 
   RowBox[{"Simplify", "[", "eqav", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz2", "=", 
   RowBox[{"Simplify", "[", "eqaz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgvz2", "=", 
   RowBox[{"Simplify", "[", "eqgvz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgzz2", "=", 
   RowBox[{"Simplify", "[", "eqgzz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqT2", "=", 
   RowBox[{"Simplify", "[", "eqT", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"eqS2", "=", 
  RowBox[{"Simplify", "[", "eqS", "]"}]}]}], "Input",
 CellChangeTimes->{{3.460366768598325*^9, 3.4603668525536737`*^9}, {
  3.5374869590367947`*^9, 3.537486972220312*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}]], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"S", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "4"], 
       SuperscriptBox["z", "8"]]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"p", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"av", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["S", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"S", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"\[Alpha]", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["\[Alpha]", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
         
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"T", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["S", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{
              SuperscriptBox["S", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["S", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"S", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["av", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["T", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"T", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{
                 SuperscriptBox["p", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "-", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["p", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"2", " ", "z", " ", 
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460226338*^9, 3.5389795346181173`*^9, 
  3.538980130662692*^9, 3.538981321116317*^9, 3.538981801212451*^9, 
  3.5389820968082867`*^9, 3.538982166263648*^9, 3.539000835880889*^9, 
  3.539019438733288*^9, 3.5390201953149347`*^9, 3.539021367692947*^9, 
  3.53902166874708*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"S", "[", 
    RowBox[{"v", ",", "z"}], "]"}]], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"S", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["av", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460226338*^9, 3.5389795346181173`*^9, 
  3.538980130662692*^9, 3.538981321116317*^9, 3.538981801212451*^9, 
  3.5389820968082867`*^9, 3.538982166263648*^9, 3.539000835880889*^9, 
  3.539019438733288*^9, 3.5390201953149347`*^9, 3.539021367692947*^9, 
  3.5390216688242188`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["av", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["z", "6"], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]]}]]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460226338*^9, 3.5389795346181173`*^9, 
  3.538980130662692*^9, 3.538981321116317*^9, 3.538981801212451*^9, 
  3.5389820968082867`*^9, 3.538982166263648*^9, 3.539000835880889*^9, 
  3.539019438733288*^9, 3.5390201953149347`*^9, 3.539021367692947*^9, 
  3.53902166886534*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "7"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["av", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["z", "14"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"S", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "4"], 
       SuperscriptBox["z", "8"]]}], ")"}], 
    RowBox[{"3", "/", "2"}]]}]]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460226338*^9, 3.5389795346181173`*^9, 
  3.538980130662692*^9, 3.538981321116317*^9, 3.538981801212451*^9, 
  3.5389820968082867`*^9, 3.538982166263648*^9, 3.539000835880889*^9, 
  3.539019438733288*^9, 3.5390201953149347`*^9, 3.539021367692947*^9, 
  3.539021668911446*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "2"]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"\[Alpha]", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["av", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "6"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",\

 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460226338*^9, 3.5389795346181173`*^9, 
  3.538980130662692*^9, 3.538981321116317*^9, 3.538981801212451*^9, 
  3.5389820968082867`*^9, 3.538982166263648*^9, 3.539000835880889*^9, 
  3.539019438733288*^9, 3.5390201953149347`*^9, 3.539021367692947*^9, 
  3.5390216689737787`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "2"]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"av", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"T", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"T", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "6"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"12", "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"p", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["z", "4"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["av", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{"4", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{"z", " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"T", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              SuperscriptBox["T", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460226338*^9, 3.5389795346181173`*^9, 
  3.538980130662692*^9, 3.538981321116317*^9, 3.538981801212451*^9, 
  3.5389820968082867`*^9, 3.538982166263648*^9, 3.539000835880889*^9, 
  3.539019438733288*^9, 3.5390201953149347`*^9, 3.539021367692947*^9, 
  3.5390216692204227`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["z", "6"], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]]}]]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460226338*^9, 3.5389795346181173`*^9, 
  3.538980130662692*^9, 3.538981321116317*^9, 3.538981801212451*^9, 
  3.5389820968082867`*^9, 3.538982166263648*^9, 3.539000835880889*^9, 
  3.539019438733288*^9, 3.5390201953149347`*^9, 3.539021367692947*^9, 
  3.539021669261819*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["z", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "4"], 
        SuperscriptBox["z", "8"]]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "6"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"\[Alpha]", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["av", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"8", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"6", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",\

 CellChangeTimes->{3.5388079500961*^9, 3.538809507136558*^9, 
  3.538893009456334*^9, 3.538896460226338*^9, 3.5389795346181173`*^9, 
  3.538980130662692*^9, 3.538981321116317*^9, 3.538981801212451*^9, 
  3.5389820968082867`*^9, 3.538982166263648*^9, 3.539000835880889*^9, 
  3.539019438733288*^9, 3.5390201953149347`*^9, 3.539021367692947*^9, 
  3.539021669336595*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"\[Alpha]", ",", "p", ",", "av", ",", "T", ",", "S"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4603676469897413`*^9, 3.460367657697607*^9}, {
  3.4603797352914047`*^9, 3.460379735508092*^9}, {3.5374870733721457`*^9, 
  3.537487073532263*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"f", "[", 
    RowBox[{"v", ",", "z"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"h", "[", 
    RowBox[{"v", ",", "z"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"a", "[", 
    RowBox[{"v", ",", "z"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"t", "[", 
    RowBox[{"v", ",", "z"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", " ", 
  RowBox[{"s", "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.537494166786066*^9, 3.537494209239134*^9}, 
   3.5375534855250597`*^9, {3.537578844859714*^9, 3.537578847402349*^9}, {
   3.538982060032983*^9, 3.538982072774283*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Evsol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqgvz2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqS2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqp2", "\[Equal]", "0"}], ",", 
        RowBox[{"eq\[Alpha]2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqaz", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603794747692738`*^9, 3.4603795051117373`*^9}, {
   3.460379770556391*^9, 3.460379778090231*^9}, {3.537487575145343*^9, 
   3.537487601737835*^9}, {3.5374876320607243`*^9, 3.537487632172414*^9}, 
   3.5374876986147537`*^9, {3.537494224185582*^9, 3.537494230128457*^9}, {
   3.537494336674205*^9, 3.537494337210093*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "z"}], " ", 
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"a", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "-", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
             RowBox[{"z", " ", 
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", " ", 
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "2"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], 
       SuperscriptBox["z", "2"]]}], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"8", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], " ", 
        RowBox[{"(", 
         RowBox[{"12", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
          RowBox[{
           SuperscriptBox["z", "4"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["a", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "6"}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{"4", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["t", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"z", " ", 
       SuperscriptBox[
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["z", "3"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["a", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"a", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"h", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                   RowBox[{
                    RowBox[{"f", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "2"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807968763275*^9, 3.53880952562223*^9, 
  3.538893028348871*^9, 3.538896480461392*^9, 3.538979549064433*^9, 
  3.5389801622909737`*^9, 3.5389813360332747`*^9, 3.538981815446114*^9, 
  3.538982099220335*^9, 3.538982168634139*^9, 3.539000838254146*^9, 
  3.5390194413238773`*^9, 3.5390201977223473`*^9, 3.539021370095008*^9, 
  3.5390216711390963`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Momsol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqT2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqgzz", "\[Equal]", "0"}], ",", 
        RowBox[{"eqav", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460379791348405*^9, 3.460379854266864*^9}, {
  3.537487577120059*^9, 3.537487629667873*^9}, {3.5374877038531513`*^9, 
  3.537487709515881*^9}, {3.537494238680642*^9, 3.53749424053545*^9}, {
  3.5374943297700453`*^9, 3.537494330345728*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"2", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"8", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "6"}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"12", "+", 
             RowBox[{"4", " ", 
              SuperscriptBox[
               RowBox[{"f", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox[
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["z", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                RowBox[{"4", " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{"4", " ", "z", " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{"4", " ", "z", " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", "z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", 
     RowBox[{"s", "[", 
      RowBox[{"v", ",", "z"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], 
      SuperscriptBox["z", "2"]], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807992285688*^9, 3.538809549204625*^9, 
  3.538893052647325*^9, 3.538896505678155*^9, 3.538979568435*^9, 
  3.538980164129857*^9, 3.538981356471409*^9, 3.538981834747274*^9, 
  3.538982100402595*^9, 3.538982169687889*^9, 3.539000839294836*^9, 
  3.539019442511128*^9, 3.5390201987813263`*^9, 3.5390213711674128`*^9, 
  3.539021672241765*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqT2", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqav", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"eqgzz", ",", "z"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"Evsol", ",", "v"}], "]"}]}], "/.", "Evsol"}], "/.", "Momsol"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.460379877349128*^9, 3.460379983100644*^9}, {
  3.460380087445326*^9, 3.460380091873478*^9}, {3.537487726936469*^9, 
  3.5374877500015907`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.538809549745694*^9, 
  3.538893053183429*^9, 3.538896506321733*^9, 3.538979568803474*^9, 
  3.5389801649067593`*^9, 3.538981356931897*^9, 3.538981835106082*^9, 
  3.5389821005470953`*^9, 3.538982169889297*^9, 3.539000839426772*^9, 
  3.539019442631242*^9, 3.539020198879475*^9, 3.5390213712886457`*^9, 
  3.539021672379991*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.538809549745694*^9, 
  3.538893053183429*^9, 3.538896506321733*^9, 3.538979568803474*^9, 
  3.5389801649067593`*^9, 3.538981356931897*^9, 3.538981835106082*^9, 
  3.5389821005470953`*^9, 3.538982169889297*^9, 3.539000839426772*^9, 
  3.539019442631242*^9, 3.539020198879475*^9, 3.5390213712886457`*^9, 
  3.539021672439287*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.538809549745694*^9, 
  3.538893053183429*^9, 3.538896506321733*^9, 3.538979568803474*^9, 
  3.5389801649067593`*^9, 3.538981356931897*^9, 3.538981835106082*^9, 
  3.5389821005470953`*^9, 3.538982169889297*^9, 3.539000839426772*^9, 
  3.539019442631242*^9, 3.539020198879475*^9, 3.5390213712886457`*^9, 
  3.539021673328207*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Const1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Const2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Const3", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["s", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["s", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.46031768644937*^9, 3.46031772334064*^9}, {
  3.537487772329159*^9, 3.5374878178010073`*^9}, {3.537494258424617*^9, 
  3.537494262447569*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"s", "[", 
    RowBox[{"v", ",", "z"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388080342469997`*^9, 3.5388095916039963`*^9, 
  3.538893096137225*^9, 3.53889655254184*^9, 3.5389795913623257`*^9, 
  3.538980165826696*^9, 3.538981371484481*^9, 3.538981857622855*^9, 
  3.53898210158407*^9, 3.538982170880622*^9, 3.539000840429224*^9, 
  3.539019443667617*^9, 3.539020199948213*^9, 3.539021372308453*^9, 
  3.539021673399259*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"h", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}], 
    SuperscriptBox["z", "2"]]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], " ", 
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}]}], 
   RowBox[{"s", "[", 
    RowBox[{"v", ",", "z"}], "]"}]], "+", 
  RowBox[{
   SuperscriptBox["a", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388080342469997`*^9, 3.5388095916039963`*^9, 
  3.538893096137225*^9, 3.53889655254184*^9, 3.5389795913623257`*^9, 
  3.538980165826696*^9, 3.538981371484481*^9, 3.538981857622855*^9, 
  3.53898210158407*^9, 3.538982170880622*^9, 3.539000840429224*^9, 
  3.539019443667617*^9, 3.539020199948213*^9, 3.539021372308453*^9, 
  3.539021673402915*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"12", "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["z", "3"], " ", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["a", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
               RowBox[{"4", " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{"4", " ", "z", " ", 
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{"4", " ", "z", " ", 
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
         
         RowBox[{"4", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["t", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"2", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388080342469997`*^9, 3.5388095916039963`*^9, 
  3.538893096137225*^9, 3.53889655254184*^9, 3.5389795913623257`*^9, 
  3.538980165826696*^9, 3.538981371484481*^9, 3.538981857622855*^9, 
  3.53898210158407*^9, 3.538982170880622*^9, 3.539000840429224*^9, 
  3.539019443667617*^9, 3.539020199948213*^9, 3.539021372308453*^9, 
  3.5390216734070053`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Eq1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq3", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq4", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["t", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["t", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.537489066732723*^9, 3.5374891410817547`*^9}, {
  3.537494265681246*^9, 3.537494272120749*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "z"}], " ", 
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "-", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{"z", " ", 
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388965526955137`*^9, 3.5389795914443197`*^9, 
  3.5389801669460506`*^9, 3.538981371623111*^9, 3.5389818577054987`*^9, 
  3.5389821016448917`*^9, 3.538982170934998*^9, 3.5390008404839993`*^9, 
  3.539019443721788*^9, 3.5390202000031033`*^9, 3.5390213723654633`*^9, 
  3.5390216734566593`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"z", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"z", " ", 
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "2"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["h", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388965526955137`*^9, 3.5389795914443197`*^9, 
  3.5389801669460506`*^9, 3.538981371623111*^9, 3.5389818577054987`*^9, 
  3.5389821016448917`*^9, 3.538982170934998*^9, 3.5390008404839993`*^9, 
  3.539019443721788*^9, 3.5390202000031033`*^9, 3.5390213723654633`*^9, 
  3.539021673462881*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], 
   SuperscriptBox["z", "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], " ", 
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}]}], 
   RowBox[{"s", "[", 
    RowBox[{"v", ",", "z"}], "]"}]], "+", 
  RowBox[{
   SuperscriptBox["a", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388965526955137`*^9, 3.5389795914443197`*^9, 
  3.5389801669460506`*^9, 3.538981371623111*^9, 3.5389818577054987`*^9, 
  3.5389821016448917`*^9, 3.538982170934998*^9, 3.5390008404839993`*^9, 
  3.539019443721788*^9, 3.5390202000031033`*^9, 3.5390213723654633`*^9, 
  3.5390216734674997`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{"12", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
         RowBox[{
          SuperscriptBox["z", "4"], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{"4", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388965526955137`*^9, 3.5389795914443197`*^9, 
  3.5389801669460506`*^9, 3.538981371623111*^9, 3.5389818577054987`*^9, 
  3.5389821016448917`*^9, 3.538982170934998*^9, 3.5390008404839993`*^9, 
  3.539019443721788*^9, 3.5390202000031033`*^9, 3.5390213723654633`*^9, 
  3.5390216734710503`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["t", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", " ", 
     SuperscriptBox[
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "2"]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["z", "3"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"a", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"h", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 RowBox[{
                  RowBox[{"f", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"t", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"t", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",\

 CellChangeTimes->{3.5388965526955137`*^9, 3.5389795914443197`*^9, 
  3.5389801669460506`*^9, 3.538981371623111*^9, 3.5389818577054987`*^9, 
  3.5389821016448917`*^9, 3.538982170934998*^9, 3.5390008404839993`*^9, 
  3.539019443721788*^9, 3.5390202000031033`*^9, 3.5390213723654633`*^9, 
  3.5390216734760036`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", "v_", "]"}], ":=", "m"}], ";"}]], "Input",
 CellChangeTimes->{{3.538894616535939*^9, 3.538894621636359*^9}, 
   3.538896479565377*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"f", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"h", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"a", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"s", "[", "z", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"t", "[", "z", "]"}]}]}], "Input",
 CellChangeTimes->{{3.538893220712365*^9, 3.5388932773084*^9}, {
  3.538896496023963*^9, 3.5388965000073137`*^9}, {3.538896659656444*^9, 
  3.538896669399289*^9}, {3.538896722265585*^9, 3.538896726142902*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ell1", "=", 
   RowBox[{"Simplify", "[", "Eq1", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell2", "=", 
   RowBox[{"Simplify", "[", "Eq2", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ellc1", "=", 
   RowBox[{"Simplify", "[", "Eq3", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ellc2", "=", 
   RowBox[{"Simplify", "[", "Eq4", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell3", "=", 
   RowBox[{"Simplify", "[", "Eq5", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell4", "=", 
   RowBox[{"Simplify", "[", "Const1", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ell5", "=", 
   RowBox[{"Simplify", "[", "Const2", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"ellc3", "=", 
  RowBox[{"Simplify", "[", "Const3", "]"}]}]}], "Input",
 CellChangeTimes->{{3.537627679175139*^9, 3.537627742317072*^9}, {
  3.537636876281947*^9, 3.53763687844884*^9}, {3.5376379765369062`*^9, 
  3.537638074206946*^9}, {3.537638144466118*^9, 3.537638162905325*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"f", "[", "z", "]"}], 
    SuperscriptBox["z", "2"]]}], "+", 
  RowBox[{
   RowBox[{"a", "[", "z", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["h", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}], "+", 
     RowBox[{
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "z"]}], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], 
         RowBox[{"s", "[", "z", "]"}]]}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["2", "z"], "-", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], 
            RowBox[{"s", "[", "z", "]"}]]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["f", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728036908*^9, 3.5389795917077007`*^9, 
   3.5389801706974773`*^9, 3.538981371945595*^9, 3.5389818579689713`*^9, 
   3.538982128286708*^9, 3.538982171130128*^9, 3.539000840714726*^9, 
   3.539019443984556*^9, 3.539020200218339*^9, 3.539021372594208*^9, 
   3.539021673692896*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"h", "[", "z", "]"}], " ", 
     RowBox[{"s", "[", "z", "]"}]}], "+", 
    RowBox[{"2", " ", "z", " ", 
     RowBox[{"a", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"z", " ", 
        RowBox[{"s", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"f", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"s", "[", "z", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
      ")"}]}], "+", 
    RowBox[{"z", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"z", " ", 
        RowBox[{"f", "[", "z", "]"}], " ", 
        RowBox[{"s", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["a", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"t", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"s", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["h", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              RowBox[{"t", "[", "z", "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["t", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"t", "[", "z", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "2"], " ", 
    RowBox[{"s", "[", "z", "]"}]}]]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728036908*^9, 3.5389795917077007`*^9, 
   3.5389801706974773`*^9, 3.538981371945595*^9, 3.5389818579689713`*^9, 
   3.538982128286708*^9, 3.538982171130128*^9, 3.539000840714726*^9, 
   3.539019443984556*^9, 3.539020200218339*^9, 3.539021372594208*^9, 
   3.539021673791552*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"h", "[", "z", "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"h", "[", "z", "]"}]}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], ")"}]}], 
  
  SuperscriptBox["z", "2"]]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728036908*^9, 3.5389795917077007`*^9, 
   3.5389801706974773`*^9, 3.538981371945595*^9, 3.5389818579689713`*^9, 
   3.538982128286708*^9, 3.538982171130128*^9, 3.539000840714726*^9, 
   3.539019443984556*^9, 3.539020200218339*^9, 3.539021372594208*^9, 
   3.5390216737944803`*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["z", "2"], " ", 
     RowBox[{"t", "[", "z", "]"}], " ", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
    RowBox[{"4", " ", "z", " ", 
     RowBox[{"s", "[", "z", "]"}], " ", 
     RowBox[{
      SuperscriptBox["s", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        RowBox[{"t", "[", "z", "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["t", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"s", "[", "z", "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"12", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["a", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"t", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "6"}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["h", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"]}], ")"}]}]}], 
         ")"}]}], "+", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["t", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
   RowBox[{"8", " ", 
    SuperscriptBox["z", "2"], " ", 
    RowBox[{"s", "[", "z", "]"}]}]]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728036908*^9, 3.5389795917077007`*^9, 
   3.5389801706974773`*^9, 3.538981371945595*^9, 3.5389818579689713`*^9, 
   3.538982128286708*^9, 3.538982171130128*^9, 3.539000840714726*^9, 
   3.539019443984556*^9, 3.539020200218339*^9, 3.539021372594208*^9, 
   3.53902167379736*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["z", "3"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["a", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{"a", "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"h", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{
               RowBox[{"f", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "-", 
           
           RowBox[{"z", " ", 
            RowBox[{"t", "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["f", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["h", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], "2"]}], ")"}]}], 
           "+", 
           RowBox[{
            SuperscriptBox["t", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{"2", " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
    RowBox[{"z", " ", 
     SuperscriptBox[
      RowBox[{"s", "[", "z", "]"}], "2"]}]]}], "+", 
  RowBox[{
   SuperscriptBox["t", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "z", "]"}]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728036908*^9, 3.5389795917077007`*^9, 
   3.5389801706974773`*^9, 3.538981371945595*^9, 3.5389818579689713`*^9, 
   3.538982128286708*^9, 3.538982171130128*^9, 3.539000840714726*^9, 
   3.539019443984556*^9, 3.539020200218339*^9, 3.539021372594208*^9, 
   3.539021673893364*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"s", "[", "z", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "2"]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "z", "]"}]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728036908*^9, 3.5389795917077007`*^9, 
   3.5389801706974773`*^9, 3.538981371945595*^9, 3.5389818579689713`*^9, 
   3.538982128286708*^9, 3.538982171130128*^9, 3.539000840714726*^9, 
   3.539019443984556*^9, 3.539020200218339*^9, 3.539021372594208*^9, 
   3.539021673896224*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"h", "[", "z", "]"}]}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
   SuperscriptBox["z", "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}], " ", 
    RowBox[{
     SuperscriptBox["s", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}], 
   RowBox[{"s", "[", "z", "]"}]], "+", 
  RowBox[{
   SuperscriptBox["a", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "z", "]"}]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728036908*^9, 3.5389795917077007`*^9, 
   3.5389801706974773`*^9, 3.538981371945595*^9, 3.5389818579689713`*^9, 
   3.538982128286708*^9, 3.538982171130128*^9, 3.539000840714726*^9, 
   3.539019443984556*^9, 3.539020200218339*^9, 3.539021372594208*^9, 
   3.5390216738988237`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox["z", "2"], " ", 
    RowBox[{"s", "[", "z", "]"}]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["z", "2"], " ", 
     SuperscriptBox[
      RowBox[{"a", "[", "z", "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"f", "[", "z", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"h", "[", "z", "]"}], "2"]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"s", "[", "z", "]"}], "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["z", "2"], " ", 
     RowBox[{"a", "[", "z", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"s", "[", "z", "]"}], "2"], " ", 
     RowBox[{"t", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"h", "[", "z", "]"}]}], " ", 
        RowBox[{
         SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"f", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"t", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"t", "[", "z", "]"}], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"s", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           RowBox[{"t", "[", "z", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["t", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"s", "[", "z", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"12", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
          RowBox[{"12", " ", 
           RowBox[{"t", "[", "z", "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["z", "4"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["a", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", "z", "]"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", "z", "]"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["h", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
          RowBox[{"4", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["t", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.538894045821149*^9, 3.538894061917138*^9}, 
   3.538894342991045*^9, 3.5388946233332243`*^9, 3.538896553550412*^9, 
   3.538896674581839*^9, 3.538896728036908*^9, 3.5389795917077007`*^9, 
   3.5389801706974773`*^9, 3.538981371945595*^9, 3.5389818579689713`*^9, 
   3.538982128286708*^9, 3.538982171130128*^9, 3.539000840714726*^9, 
   3.539019443984556*^9, 3.539020200218339*^9, 3.539021372594208*^9, 
   3.539021673901741*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"sols", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "ell1", ",", "ell4", ",", "ell5", ",", "ellc1", ",", "ellc2"}], 
         "}"}], "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"f", "''"}], "[", "z", "]"}], ",", 
         RowBox[{
          RowBox[{"h", "'"}], "[", "z", "]"}], ",", 
         RowBox[{
          RowBox[{"a", "''"}], "[", "z", "]"}], ",", 
         RowBox[{
          RowBox[{"s", "''"}], "[", "z", "]"}], ",", 
         RowBox[{
          RowBox[{"t", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5388933905436563`*^9, 3.5388934127976503`*^9}, {
  3.538893443616728*^9, 3.538893463678727*^9}, {3.538894006097336*^9, 
  3.538894008494485*^9}, {3.538894136848188*^9, 3.5388941669361773`*^9}, {
  3.5388942439526367`*^9, 3.538894301336754*^9}, {3.5388965181369534`*^9, 
  3.538896523583788*^9}, {3.538896622968113*^9, 3.5388966294887323`*^9}, {
  3.5389821219287043`*^9, 3.5389821247208223`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ell1", ",", "ell2", ",", "ell3", ",", "ell4", ",", "ell5"}], 
     "}"}], "/.", 
    RowBox[{"D", "[", 
     RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}]], "Input",
 CellChangeTimes->{{3.538894401365067*^9, 3.538894438420658*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.538894422363475*^9, 3.5388944466122417`*^9}, 
   3.5388946326671247`*^9, 3.538896571211697*^9, 3.5388967403625927`*^9, 
   3.5389795984720507`*^9, 3.538980172654532*^9, 3.53898137852159*^9, 
   3.53898186447821*^9, 3.538982171752872*^9, 3.53900084137768*^9, 
   3.539019444775517*^9, 3.5390202008641567`*^9, 3.5390213732553988`*^9, 
   3.539021674292259*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ellc1", ",", "ellc2", ",", "ellc3"}], "}"}], "/.", 
    RowBox[{"D", "[", 
     RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}]], "Input",
 CellChangeTimes->{{3.538894421190186*^9, 3.538894449542976*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538894452163848*^9, 3.538894633133789*^9, 
  3.538896572204898*^9, 3.538896740861245*^9, 3.538979599107046*^9, 
  3.538980173322782*^9, 3.538981378893681*^9, 3.538981864915441*^9, 
  3.538982171783577*^9, 3.5390008415140963`*^9, 3.539019444826169*^9, 
  3.539020201074151*^9, 3.5390213734098787`*^9, 3.539021674352162*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "f", ",", "h", ",", "a", ",", "t", ",", "s", ",", "fp", ",", "hp", ",", 
   "ap", ",", "tp", ",", "sp"}], "]"}]], "Input",
 CellChangeTimes->{{3.539065298892437*^9, 3.539065308909031*^9}, 
   3.539067352327656*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"met", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"t", "[", "z", "]"}]}], 
       RowBox[{
        RowBox[{"Dt", "[", "v", "]"}], "^", "2"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"Dt", "[", "v", "]"}], 
       RowBox[{"Dt", "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"s", "[", "z", "]"}], "^", "2"}], " ", 
       RowBox[{
        RowBox[{"Dt", "[", "x", "]"}], "^", "2"}]}]}], ")"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5390651557094812`*^9, 3.539065261172967*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"met", "/.", 
     RowBox[{"{", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"z", "+", 
        RowBox[{"\[Lambda]", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}], 
         RowBox[{"g", "[", "z", "]"}]}]}]}], "}"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"tmp", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Dt", "[", "\[CapitalOmega]", "]"}], "\[Rule]", "0"}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Coefficient", "[", 
   RowBox[{
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"tmp2", ",", "1"}], "]"}], ",", 
    RowBox[{
     RowBox[{"Dt", "[", "v", "]"}], 
     RowBox[{"Dt", "[", "z", "]"}]}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.539065266062573*^9, 3.539065412680052*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"Dt", "[", "v", "]"}], " ", 
      RowBox[{"Dt", "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Dt", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Dt", "[", "v", "]"}], "2"], " ", 
      RowBox[{"t", "[", "z", "]"}]}]}], 
    SuperscriptBox["z", "2"]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"Dt", "[", "v", "]"}], " ", 
        RowBox[{"Dt", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{"g", "[", "z", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["g", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Dt", "[", "x", "]"}], "2"], " ", 
        RowBox[{"g", "[", "z", "]"}], " ", 
        RowBox[{"s", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"s", "[", "z", "]"}], "-", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Dt", "[", "v", "]"}], "2"], " ", 
        RowBox[{"g", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{"t", "[", "z", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "\[CapitalOmega]"}], "+", 
             RowBox[{
              SuperscriptBox["t", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
         ")"}]}]}], ")"}], " ", "\[Lambda]"}], 
    SuperscriptBox["z", "3"]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Lambda]", "]"}], "2"],
    SeriesData[$CellContext`\[Lambda], 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Lambda], 
   0, {$CellContext`z^(-2) ((-2) Dt[$CellContext`v] Dt[$CellContext`z] + 
     Dt[$CellContext`x]^2 $CellContext`s[$CellContext`z]^2 - 
     Dt[$CellContext`v]^2 $CellContext`t[$CellContext`z]), -
    E^($CellContext`v $CellContext`\[CapitalOmega]) $CellContext`z^(-3) (
     2 Dt[$CellContext`v] 
      Dt[$CellContext`z] ((-2) $CellContext`g[$CellContext`z] + \
$CellContext`z Derivative[1][$CellContext`g][$CellContext`z]) + 
     2 Dt[$CellContext`x]^2 $CellContext`g[$CellContext`z] \
$CellContext`s[$CellContext`z] ($CellContext`s[$CellContext`z] - \
$CellContext`z Derivative[1][$CellContext`s][$CellContext`z]) + 
     Dt[$CellContext`v]^2 $CellContext`g[$CellContext`z] ((-2) \
$CellContext`t[$CellContext`z] + $CellContext`z (
         2 $CellContext`\[CapitalOmega] + 
         Derivative[1][$CellContext`t][$CellContext`z])))}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5390652889509497`*^9, 3.539065413093459*^9}, 
   3.53906568193797*^9, 3.539067366118129*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"g", "[", "z", "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["g", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
   SuperscriptBox["z", "3"]]}]], "Output",
 CellChangeTimes->{{3.5390652889509497`*^9, 3.539065413093459*^9}, 
   3.53906568193797*^9, 3.539067366145845*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"g", "[", "z", "]"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{
       SuperscriptBox["g", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], "\[Equal]", "0"}], ",",
    "g", ",", "z"}], "]"}]], "Input",
 CellChangeTimes->{{3.539065418994424*^9, 3.539065423495289*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"g", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "z", "}"}], ",", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.5390654239306993`*^9, 3.5390654260820007`*^9}, 
   3.5390656826549177`*^9, 3.539067367272724*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "f", ",", "h", ",", "a", ",", "t", ",", "s", ",", "fp", ",", "hp", ",", 
   "ap", ",", "tp", ",", "sp"}], "]"}]], "Input",
 CellChangeTimes->{{3.539065298892437*^9, 3.539065308909031*^9}, {
  3.539067327847394*^9, 3.539067332567152*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"met", "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"z", "^", "2"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"t", "[", "z", "]"}]}], 
        RowBox[{
         RowBox[{"Dt", "[", "v", "]"}], "^", "2"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"Dt", "[", "v", "]"}], 
        RowBox[{"Dt", "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{
         RowBox[{"s", "[", "z", "]"}], "^", "2"}], " ", 
        RowBox[{
         RowBox[{"Dt", "[", "x", "]"}], "^", "2"}]}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"scal", "=", 
    RowBox[{"f", "[", "z", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gauge", "=", 
   RowBox[{
    RowBox[{"a", "[", "z", "]"}], 
    RowBox[{"Dt", "[", "v", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5390651557094812`*^9, 3.539065261172967*^9}, {
  3.5390656911171007`*^9, 3.539065698612732*^9}, {3.539065735001232*^9, 
  3.539065745664744*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"met", "/.", 
     RowBox[{"{", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"z", "+", 
        RowBox[{"\[Lambda]", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}], 
         RowBox[{"z", "^", "2"}]}]}]}], "}"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"tmp", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Dt", "[", "\[CapitalOmega]", "]"}], "\[Rule]", "0"}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"tmp2", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"tmp3", ",", 
     RowBox[{
      RowBox[{"Dt", "[", "v", "]"}], "^", "2"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"tmp3", ",", 
     RowBox[{
      RowBox[{"Dt", "[", "x", "]"}], "^", "2"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"z", "^", "2"}], 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"v", " ", "\[CapitalOmega]"}]]]}], "tmp3"}], ",", 
      RowBox[{
       RowBox[{"Dt", "[", "v", "]"}], "^", "2"}]}], "]"}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Expand", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"z", "^", "2"}], 
       RowBox[{"2", 
        RowBox[{"s", "[", "z", "]"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"v", " ", "\[CapitalOmega]"}]]}]], "tmp3"}], ",", 
     RowBox[{
      RowBox[{"Dt", "[", "x", "]"}], "^", "2"}]}], "]"}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.539065266062573*^9, 3.539065412680052*^9}, {
  3.539065448819512*^9, 3.5390655186964903`*^9}, {3.5390658266597223`*^9, 
  3.539065864160637*^9}, {3.539066122046733*^9, 3.539066136806368*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"Dt", "[", "v", "]"}], " ", 
      RowBox[{"Dt", "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Dt", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Dt", "[", "v", "]"}], "2"], " ", 
      RowBox[{"t", "[", "z", "]"}]}]}], 
    SuperscriptBox["z", "2"]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Dt", "[", "x", "]"}], "2"], " ", 
        RowBox[{"s", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"s", "[", "z", "]"}], "-", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Dt", "[", "v", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{"t", "[", "z", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "\[CapitalOmega]"}], "+", 
             RowBox[{
              SuperscriptBox["t", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
         ")"}]}]}], ")"}], " ", "\[Lambda]"}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Lambda]", "]"}], "2"],
    SeriesData[$CellContext`\[Lambda], 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Lambda], 
   0, {$CellContext`z^(-2) ((-2) Dt[$CellContext`v] Dt[$CellContext`z] + 
     Dt[$CellContext`x]^2 $CellContext`s[$CellContext`z]^2 - 
     Dt[$CellContext`v]^2 $CellContext`t[$CellContext`z]), -
    E^($CellContext`v $CellContext`\[CapitalOmega]) $CellContext`z^(-1) (
     2 Dt[$CellContext`x]^2 $CellContext`s[$CellContext`z] \
($CellContext`s[$CellContext`z] - $CellContext`z 
       Derivative[1][$CellContext`s][$CellContext`z]) + 
     Dt[$CellContext`v]^2 ((-2) $CellContext`t[$CellContext`z] + \
$CellContext`z (2 $CellContext`\[CapitalOmega] + 
         Derivative[1][$CellContext`t][$CellContext`z])))}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5390654610876703`*^9, 3.539065519267293*^9}, 
   3.539065684709888*^9, {3.53906581553627*^9, 3.5390658646073847`*^9}, {
   3.539066117356133*^9, 3.539066137643989*^9}, 3.539067337662902*^9, 
   3.539067374489739*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"Dt", "[", "x", "]"}], "2"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"s", "[", "z", "]"}], "-", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["s", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Dt", "[", "v", "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"t", "[", "z", "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "\[CapitalOmega]"}], "+", 
            RowBox[{
             SuperscriptBox["t", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
        ")"}]}]}], ")"}]}], "z"]}]], "Output",
 CellChangeTimes->{{3.5390654610876703`*^9, 3.539065519267293*^9}, 
   3.539065684709888*^9, {3.53906581553627*^9, 3.5390658646073847`*^9}, {
   3.539066117356133*^9, 3.539066137643989*^9}, 3.539067337662902*^9, 
   3.53906737449196*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"t", "[", "z", "]"}]}], "-", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{
         SuperscriptBox["t", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], ")"}]}], 
  "z"]], "Output",
 CellChangeTimes->{{3.5390654610876703`*^9, 3.539065519267293*^9}, 
   3.539065684709888*^9, {3.53906581553627*^9, 3.5390658646073847`*^9}, {
   3.539066117356133*^9, 3.539066137643989*^9}, 3.539067337662902*^9, 
   3.539067374493717*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
   RowBox[{"s", "[", "z", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"s", "[", "z", "]"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
  "z"]], "Output",
 CellChangeTimes->{{3.5390654610876703`*^9, 3.539065519267293*^9}, 
   3.539065684709888*^9, {3.53906581553627*^9, 3.5390658646073847`*^9}, {
   3.539066117356133*^9, 3.539066137643989*^9}, 3.539067337662902*^9, 
   3.539067374495414*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["z", "2"], " ", "\[CapitalOmega]"}], "-", 
  RowBox[{"2", " ", "z", " ", 
   RowBox[{"t", "[", "z", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["z", "2"], " ", 
   RowBox[{
    SuperscriptBox["t", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.5390654610876703`*^9, 3.539065519267293*^9}, 
   3.539065684709888*^9, {3.53906581553627*^9, 3.5390658646073847`*^9}, {
   3.539066117356133*^9, 3.539066137643989*^9}, 3.539067337662902*^9, 
   3.539067374497064*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "z"}], " ", 
   RowBox[{"s", "[", "z", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["z", "2"], " ", 
   RowBox[{
    SuperscriptBox["s", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.5390654610876703`*^9, 3.539065519267293*^9}, 
   3.539065684709888*^9, {3.53906581553627*^9, 3.5390658646073847`*^9}, {
   3.539066117356133*^9, 3.539066137643989*^9}, 3.539067337662902*^9, 
   3.539067374498678*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"scal", "/.", 
     RowBox[{"{", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"z", "+", 
        RowBox[{"\[Lambda]", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}], 
         RowBox[{"z", "^", "2"}]}]}]}], "}"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"tmp", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Dt", "[", "\[CapitalOmega]", "]"}], "\[Rule]", "0"}], 
       "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.539065759657011*^9, 3.53906576798454*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"f", "[", "z", "]"}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
    SuperscriptBox["z", "2"], " ", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}], " ", "\[Lambda]"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Lambda]", "]"}], "2"],
    SeriesData[$CellContext`\[Lambda], 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Lambda], 0, {
    $CellContext`f[$CellContext`z], 
    E^($CellContext`v $CellContext`\[CapitalOmega]) $CellContext`z^2 
    Derivative[1][$CellContext`f][$CellContext`z]}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.539065761372724*^9, 3.539065768773141*^9}, 
   3.539065877360962*^9, 3.53906733878547*^9, 3.539067378246745*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"gauge", "/.", 
     RowBox[{"{", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"z", "+", 
        RowBox[{"\[Lambda]", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}], 
         RowBox[{"z", "^", "2"}]}]}]}], "}"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"tmp", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Dt", "[", "\[CapitalOmega]", "]"}], "\[Rule]", "0"}], 
       "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.53906578144808*^9, 3.539065781919344*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "z", "]"}], " ", 
    RowBox[{"Dt", "[", "v", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
    SuperscriptBox["z", "2"], " ", 
    RowBox[{"Dt", "[", "v", "]"}], " ", 
    RowBox[{
     SuperscriptBox["a", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}], " ", "\[Lambda]"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Lambda]", "]"}], "2"],
    SeriesData[$CellContext`\[Lambda], 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Lambda], 
   0, {$CellContext`a[$CellContext`z] Dt[$CellContext`v], 
    E^($CellContext`v $CellContext`\[CapitalOmega]) $CellContext`z^2 
    Dt[$CellContext`v] Derivative[1][$CellContext`a][$CellContext`z]}, 0, 2, 
   1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5390657843494883`*^9, 3.539065878178653*^9, 
  3.539067378862091*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<So the gauge mode is:\n\nfp[z_]:=\!\(\*SuperscriptBox[\(z\), \(2\)]\) \
\!\(\*SuperscriptBox[\"f\", \"\[Prime]\",
MultilineFunction->None]\)[z];\[IndentingNewLine]\[IndentingNewLine]hp[z_]:=\!\
\(\*SuperscriptBox[\(z\), \(2\)]\) \!\(\*SuperscriptBox[\"h\", \"\[Prime]\",
MultilineFunction->None]\)[z];\[IndentingNewLine]\[IndentingNewLine]ap[z_]:=\!\
\(\*SuperscriptBox[\(z\), \(2\)]\) \!\(\*SuperscriptBox[\"a\", \"\[Prime]\",
MultilineFunction->None]\)[z];\[IndentingNewLine]\[IndentingNewLine]tp[z_]:=2 \
\!\(\*SuperscriptBox[\(z\), \(2\)]\) \[CapitalOmega]-2 z \
t[z]+\!\(\*SuperscriptBox[\(z\), \(2\)]\) \!\(\*SuperscriptBox[\"t\", \"\
\[Prime]\",
MultilineFunction->None]\)[z];\[IndentingNewLine]\[IndentingNewLine]sp[z_]:=-\
z s[z]+\!\(\*SuperscriptBox[\(z\), \(2\)]\) \!\(\*SuperscriptBox[\"s\", \"\
\[Prime]\",
MultilineFunction->None]\)[z];\n\n\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.539065903989142*^9, 3.5390659467053413`*^9}, {
  3.539066072370077*^9, 3.539066075905673*^9}, {3.539066143518725*^9, 
  3.539066148183489*^9}, {3.53906622201663*^9, 3.5390662363609657`*^9}}],

Cell[BoxData["\<\"So the gauge mode is:\\n\\nfp[z_]:=\\!\\(\\*SuperscriptBox[\
\\(z\\), \\(2\\)]\\) \\!\\(\\*SuperscriptBox[\\\"f\\\", \
\\\"\[Prime]\\\",\\nMultilineFunction->None]\\)[z];\[IndentingNewLine]\
\[IndentingNewLine]hp[z_]:=\\!\\(\\*SuperscriptBox[\\(z\\), \\(2\\)]\\) \
\\!\\(\\*SuperscriptBox[\\\"h\\\", \
\\\"\[Prime]\\\",\\nMultilineFunction->None]\\)[z];\[IndentingNewLine]\
\[IndentingNewLine]ap[z_]:=\\!\\(\\*SuperscriptBox[\\(z\\), \\(2\\)]\\) \
\\!\\(\\*SuperscriptBox[\\\"a\\\", \
\\\"\[Prime]\\\",\\nMultilineFunction->None]\\)[z];\[IndentingNewLine]\
\[IndentingNewLine]tp[z_]:=2 \\!\\(\\*SuperscriptBox[\\(z\\), \\(2\\)]\\) \
\[CapitalOmega]-2 z t[z]+\\!\\(\\*SuperscriptBox[\\(z\\), \\(2\\)]\\) \
\\!\\(\\*SuperscriptBox[\\\"t\\\", \
\\\"\[Prime]\\\",\\nMultilineFunction->None]\\)[z];\[IndentingNewLine]\
\[IndentingNewLine]sp[z_]:=-z s[z]+\\!\\(\\*SuperscriptBox[\\(z\\), \
\\(2\\)]\\) \\!\\(\\*SuperscriptBox[\\\"s\\\", \
\\\"\[Prime]\\\",\\nMultilineFunction->None]\\)[z];\\n\\n\"\>"], "Print",
 CellChangeTimes->{3.539066236901626*^9, 3.539067379830558*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "f", ",", "h", ",", "a", ",", "t", ",", "s", ",", "fp", ",", "hp", ",", 
   "ap", ",", "tp", ",", "sp"}], "]"}]], "Input",
 CellChangeTimes->{{3.539065298892437*^9, 3.539065308909031*^9}, {
  3.539067327847394*^9, 3.539067332567152*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"met", "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"z", "^", "2"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"t", "[", "z", "]"}]}], 
        RowBox[{
         RowBox[{"Dt", "[", "v", "]"}], "^", "2"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"Dt", "[", "v", "]"}], 
        RowBox[{"Dt", "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{
         RowBox[{"s", "[", "z", "]"}], "^", "2"}], " ", 
        RowBox[{
         RowBox[{"Dt", "[", "x", "]"}], "^", "2"}]}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"scal", "=", 
    RowBox[{"f", "[", "z", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gauge", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "z", "]"}], 
     RowBox[{"Dt", "[", "v", "]"}]}], "+", 
    RowBox[{"Dt", "[", 
     RowBox[{"\[Lambda]", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}], 
      RowBox[{"k", "[", "z", "]"}]}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5390651557094812`*^9, 3.539065261172967*^9}, {
  3.5390656911171007`*^9, 3.539065698612732*^9}, {3.539065735001232*^9, 
  3.539065745664744*^9}, {3.5390680078912487`*^9, 3.539068050073242*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"gauge", "/.", 
     RowBox[{"{", "}"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"tmp", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Dt", "[", "\[CapitalOmega]", "]"}], "\[Rule]", "0"}], 
       "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.53906578144808*^9, 3.539065781919344*^9}, 
   3.539067696313035*^9, 3.539072331762063*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "z", "]"}], " ", 
    RowBox[{"Dt", "[", "v", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[CapitalOmega]", " ", 
       RowBox[{"Dt", "[", "v", "]"}], " ", 
       RowBox[{"k", "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"Dt", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["k", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
    "\[Lambda]"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Lambda]", "]"}], "2"],
    SeriesData[$CellContext`\[Lambda], 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Lambda], 
   0, {$CellContext`a[$CellContext`z] Dt[$CellContext`v], 
    E^($CellContext`v $CellContext`\[CapitalOmega]) ($CellContext`\
\[CapitalOmega] Dt[$CellContext`v] $CellContext`k[$CellContext`z] + 
     Dt[$CellContext`z] Derivative[1][$CellContext`k][$CellContext`z])}, 0, 2,
    1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.5390657843494883`*^9, 3.539065878178653*^9, 3.539067378862091*^9, 
   3.539067696703841*^9, 3.5390680731048393`*^9, 3.539068110593444*^9, {
   3.539072327070636*^9, 3.5390723495134583`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Print", "[", "\"\<Another gauge mode is just the phase rotation;\>\"", 
   "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.539065903989142*^9, 3.5390659467053413`*^9}, {
  3.539066072370077*^9, 3.539066075905673*^9}, {3.539066143518725*^9, 
  3.539066148183489*^9}, {3.53906622201663*^9, 3.5390662363609657`*^9}, {
  3.5390677460605907`*^9, 3.539067754074053*^9}, {3.5390723710508947`*^9, 
  3.539072379697578*^9}}],

Cell[BoxData["\<\"So this gauge mode is NOT allowed\"\>"], "Print",
 CellChangeTimes->{3.539066236901626*^9, 3.539067379830558*^9, 
  3.539067754513947*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "f", ",", "h", ",", "a", ",", "t", ",", "s", ",", "fp", ",", "hp", ",", 
   "ap", ",", "tp", ",", "sp"}], "]"}]], "Input",
 CellChangeTimes->{{3.539065298892437*^9, 3.539065308909031*^9}, 
   3.539067352327656*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"met", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"t", "[", "z", "]"}]}], 
       RowBox[{
        RowBox[{"Dt", "[", "v", "]"}], "^", "2"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"Dt", "[", "v", "]"}], 
       RowBox[{"Dt", "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"s", "[", "z", "]"}], "^", "2"}], " ", 
       RowBox[{
        RowBox[{"Dt", "[", "x", "]"}], "^", "2"}]}]}], ")"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5390651557094812`*^9, 3.539065261172967*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"met", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"v", "\[Rule]", 
        RowBox[{"v", "+", 
         RowBox[{"\[Lambda]", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}], 
          RowBox[{"g", "[", "z", "]"}]}]}]}], ",", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"z", "+", 
         RowBox[{"\[Lambda]", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}], 
          RowBox[{"k", "[", "z", "]"}]}]}]}]}], "}"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"tmp", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Dt", "[", "\[CapitalOmega]", "]"}], "\[Rule]", "0"}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"SeriesCoefficient", "[", 
        RowBox[{"tmp2", ",", "1"}], "]"}], ",", 
       RowBox[{"Dt", "[", "v", "]"}]}], "]"}], ",", 
     RowBox[{"Dt", "[", "z", "]"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Coefficient", "[", 
   RowBox[{
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"tmp2", ",", "1"}], "]"}], ",", 
    RowBox[{
     RowBox[{"Dt", "[", "z", "]"}], "^", "2"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.539065266062573*^9, 3.539065412680052*^9}, {
  3.539067398755477*^9, 3.539067405146044*^9}, {3.539067537839797*^9, 
  3.539067549046666*^9}, {3.5390722397105637`*^9, 3.539072248662921*^9}, {
  3.539072641758436*^9, 3.5390726458366337`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"Dt", "[", "v", "]"}], " ", 
      RowBox[{"Dt", "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Dt", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Dt", "[", "v", "]"}], "2"], " ", 
      RowBox[{"t", "[", "z", "]"}]}]}], 
    SuperscriptBox["z", "2"]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"Dt", "[", "v", "]"}], " ", 
        RowBox[{"Dt", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", " ", "\[CapitalOmega]", " ", 
           RowBox[{"g", "[", "z", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"k", "[", "z", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"t", "[", "z", "]"}], " ", 
           RowBox[{
            SuperscriptBox["g", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["k", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", " ", 
           SuperscriptBox[
            RowBox[{"Dt", "[", "z", "]"}], "2"], " ", 
           RowBox[{
            SuperscriptBox["g", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"Dt", "[", "x", "]"}], "2"], " ", 
           RowBox[{"k", "[", "z", "]"}], " ", 
           RowBox[{"s", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"s", "[", "z", "]"}], "-", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
         ")"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Dt", "[", "v", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "z", " ", "\[CapitalOmega]", " ", 
           RowBox[{"g", "[", "z", "]"}], " ", 
           RowBox[{"t", "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"k", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "z", " ", "\[CapitalOmega]"}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"t", "[", "z", "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["t", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
         ")"}]}]}], ")"}], " ", "\[Lambda]"}], 
    SuperscriptBox["z", "3"]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Lambda]", "]"}], "2"],
    SeriesData[$CellContext`\[Lambda], 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Lambda], 
   0, {$CellContext`z^(-2) ((-2) Dt[$CellContext`v] Dt[$CellContext`z] + 
     Dt[$CellContext`x]^2 $CellContext`s[$CellContext`z]^2 - 
     Dt[$CellContext`v]^2 $CellContext`t[$CellContext`z]), -
    E^($CellContext`v $CellContext`\[CapitalOmega]) $CellContext`z^(-3) (
     2 Dt[$CellContext`v] 
      Dt[$CellContext`z] ($CellContext`z $CellContext`\[CapitalOmega] \
$CellContext`g[$CellContext`z] - 
       2 $CellContext`k[$CellContext`z] + $CellContext`z \
$CellContext`t[$CellContext`z] 
        Derivative[1][$CellContext`g][$CellContext`z] + $CellContext`z 
        Derivative[1][$CellContext`k][$CellContext`z]) + 
     2 ($CellContext`z Dt[$CellContext`z]^2 
        Derivative[1][$CellContext`g][$CellContext`z] + 
       Dt[$CellContext`x]^2 $CellContext`k[$CellContext`z] \
$CellContext`s[$CellContext`z] ($CellContext`s[$CellContext`z] - \
$CellContext`z Derivative[1][$CellContext`s][$CellContext`z])) + 
     Dt[$CellContext`v]^2 (
       2 $CellContext`z $CellContext`\[CapitalOmega] \
$CellContext`g[$CellContext`z] $CellContext`t[$CellContext`z] + \
$CellContext`k[$CellContext`z] (2 $CellContext`z $CellContext`\[CapitalOmega] - 
         2 $CellContext`t[$CellContext`z] + $CellContext`z 
          Derivative[1][$CellContext`t][$CellContext`z])))}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5390652889509497`*^9, 3.539065413093459*^9}, 
   3.53906568193797*^9, 3.539067366118129*^9, 3.539067409924519*^9, {
   3.539067512486582*^9, 3.539067549674774*^9}, 3.539067600920166*^9, {
   3.5390722318985977`*^9, 3.5390722489503527`*^9}, 3.5390726494084682`*^9, 
   3.539072735601165*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", " ", "\[CapitalOmega]", " ", 
       RowBox[{"g", "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"k", "[", "z", "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"t", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["g", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["k", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], ")"}]}], 
   SuperscriptBox["z", "3"]]}]], "Output",
 CellChangeTimes->{{3.5390652889509497`*^9, 3.539065413093459*^9}, 
   3.53906568193797*^9, 3.539067366118129*^9, 3.539067409924519*^9, {
   3.539067512486582*^9, 3.539067549674774*^9}, 3.539067600920166*^9, {
   3.5390722318985977`*^9, 3.5390722489503527`*^9}, 3.5390726494084682`*^9, 
   3.539072735603897*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
    RowBox[{
     SuperscriptBox["g", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}], 
   SuperscriptBox["z", "2"]]}]], "Output",
 CellChangeTimes->{{3.5390652889509497`*^9, 3.539065413093459*^9}, 
   3.53906568193797*^9, 3.539067366118129*^9, 3.539067409924519*^9, {
   3.539067512486582*^9, 3.539067549674774*^9}, 3.539067600920166*^9, {
   3.5390722318985977`*^9, 3.5390722489503527`*^9}, 3.5390726494084682`*^9, 
   3.539072735605599*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"met", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"v", "\[Rule]", 
        RowBox[{"v", "+", 
         RowBox[{"\[Lambda]", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}], ",", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"z", "+", 
         RowBox[{"\[Lambda]", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}], 
          RowBox[{"k", "[", "z", "]"}]}]}]}]}], "}"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"tmp", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Dt", "[", "\[CapitalOmega]", "]"}], "\[Rule]", "0"}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"SeriesCoefficient", "[", 
        RowBox[{"tmp2", ",", "1"}], "]"}], ",", 
       RowBox[{"Dt", "[", "v", "]"}]}], "]"}], ",", 
     RowBox[{"Dt", "[", "z", "]"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Coefficient", "[", 
   RowBox[{
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"tmp2", ",", "1"}], "]"}], ",", 
    RowBox[{
     RowBox[{"Dt", "[", "z", "]"}], "^", "2"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{3.5390726697328787`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"Dt", "[", "v", "]"}], " ", 
      RowBox[{"Dt", "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Dt", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Dt", "[", "v", "]"}], "2"], " ", 
      RowBox[{"t", "[", "z", "]"}]}]}], 
    SuperscriptBox["z", "2"]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"Dt", "[", "v", "]"}], " ", 
        RowBox[{"Dt", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{"k", "[", "z", "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{"\[CapitalOmega]", "+", 
             RowBox[{
              SuperscriptBox["k", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
         ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Dt", "[", "x", "]"}], "2"], " ", 
        RowBox[{"k", "[", "z", "]"}], " ", 
        RowBox[{"s", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"s", "[", "z", "]"}], "-", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Dt", "[", "v", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "z", " ", "\[CapitalOmega]", " ", 
           RowBox[{"t", "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"k", "[", "z", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "z", " ", "\[CapitalOmega]"}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"t", "[", "z", "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["t", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
         ")"}]}]}], ")"}], " ", "\[Lambda]"}], 
    SuperscriptBox["z", "3"]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Lambda]", "]"}], "2"],
    SeriesData[$CellContext`\[Lambda], 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Lambda], 
   0, {$CellContext`z^(-2) ((-2) Dt[$CellContext`v] Dt[$CellContext`z] + 
     Dt[$CellContext`x]^2 $CellContext`s[$CellContext`z]^2 - 
     Dt[$CellContext`v]^2 $CellContext`t[$CellContext`z]), -
    E^($CellContext`v $CellContext`\[CapitalOmega]) $CellContext`z^(-3) (
     2 Dt[$CellContext`v] 
      Dt[$CellContext`z] ((-2) $CellContext`k[$CellContext`z] + \
$CellContext`z ($CellContext`\[CapitalOmega] + 
         Derivative[1][$CellContext`k][$CellContext`z])) + 
     2 Dt[$CellContext`x]^2 $CellContext`k[$CellContext`z] \
$CellContext`s[$CellContext`z] ($CellContext`s[$CellContext`z] - \
$CellContext`z Derivative[1][$CellContext`s][$CellContext`z]) + 
     Dt[$CellContext`v]^2 (
       2 $CellContext`z $CellContext`\[CapitalOmega] \
$CellContext`t[$CellContext`z] + $CellContext`k[$CellContext`z] (
         2 $CellContext`z $CellContext`\[CapitalOmega] - 
         2 $CellContext`t[$CellContext`z] + $CellContext`z 
          Derivative[1][$CellContext`t][$CellContext`z])))}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.539072670821598*^9, 3.53907273643311*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"k", "[", "z", "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{"\[CapitalOmega]", "+", 
         RowBox[{
          SuperscriptBox["k", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], ")"}]}], 
   SuperscriptBox["z", "3"]]}]], "Output",
 CellChangeTimes->{3.539072670821598*^9, 3.539072736435719*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.539072670821598*^9, 3.539072736437261*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"k", "[", "z", "]"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{"\[CapitalOmega]", "+", 
        RowBox[{
         SuperscriptBox["k", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], "\[Equal]", 
    "0"}], ",", 
   RowBox[{"k", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellChangeTimes->{{3.5390727435621777`*^9, 3.5390727623041687`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"k", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"z", " ", "\[CapitalOmega]"}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"C", "[", "1", "]"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.539072751662036*^9, 3.5390727628341017`*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"met", "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"z", "^", "2"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"t", "[", "z", "]"}]}], 
        RowBox[{
         RowBox[{"Dt", "[", "v", "]"}], "^", "2"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"Dt", "[", "v", "]"}], 
        RowBox[{"Dt", "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{
         RowBox[{"s", "[", "z", "]"}], "^", "2"}], " ", 
        RowBox[{
         RowBox[{"Dt", "[", "x", "]"}], "^", "2"}]}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"scal", "=", 
    RowBox[{"f", "[", "z", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gauge", "=", 
   RowBox[{
    RowBox[{"a", "[", "z", "]"}], 
    RowBox[{"Dt", "[", "v", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5390651557094812`*^9, 3.539065261172967*^9}, {
  3.539072849013956*^9, 3.5390728559672422`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"met", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"v", "\[Rule]", 
        RowBox[{"v", "+", 
         RowBox[{"\[Lambda]", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}], ",", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"z", "+", 
         RowBox[{"\[Lambda]", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}], 
          RowBox[{"(", 
           RowBox[{"z", " ", "\[CapitalOmega]"}], ")"}]}]}]}]}], "}"}]}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"tmp", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Dt", "[", "\[CapitalOmega]", "]"}], "\[Rule]", "0"}], 
        "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp3", "=", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"tmp2", ",", "1"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{"tmp3", ",", 
       RowBox[{"Dt", "[", "v", "]"}]}], "]"}], ",", 
     RowBox[{"Dt", "[", "z", "]"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"tmp3", ",", 
     RowBox[{
      RowBox[{"Dt", "[", "z", "]"}], "^", "2"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"z", "^", "2"}], 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"v", " ", "\[CapitalOmega]"}]]]}], "tmp3"}], ",", 
      RowBox[{
       RowBox[{"Dt", "[", "v", "]"}], "^", "2"}]}], "]"}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Expand", "[", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"z", "^", "2"}], 
       RowBox[{"2", 
        RowBox[{"s", "[", "z", "]"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"v", " ", "\[CapitalOmega]"}]]}]], "tmp3"}], ",", 
     RowBox[{
      RowBox[{"Dt", "[", "x", "]"}], "^", "2"}]}], "]"}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.539065266062573*^9, 3.539065412680052*^9}, {
  3.539067398755477*^9, 3.539067405146044*^9}, {3.539067537839797*^9, 
  3.539067549046666*^9}, {3.5390722397105637`*^9, 3.539072248662921*^9}, {
  3.539072641758436*^9, 3.5390726458366337`*^9}, {3.5390727827950077`*^9, 
  3.5390727998894672`*^9}, {3.539072939845669*^9, 3.5390729911672277`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"Dt", "[", "v", "]"}], " ", 
      RowBox[{"Dt", "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Dt", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Dt", "[", "v", "]"}], "2"], " ", 
      RowBox[{"t", "[", "z", "]"}]}]}], 
    SuperscriptBox["z", "2"]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", "\[CapitalOmega]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Dt", "[", "x", "]"}], "2"], " ", 
        RowBox[{"s", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"s", "[", "z", "]"}], "-", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"z", " ", 
        SuperscriptBox[
         RowBox[{"Dt", "[", "v", "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "\[CapitalOmega]"}], "+", 
          RowBox[{
           SuperscriptBox["t", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], ")"}], 
     " ", "\[Lambda]"}], 
    SuperscriptBox["z", "2"]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Lambda]", "]"}], "2"],
    SeriesData[$CellContext`\[Lambda], 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Lambda], 
   0, {$CellContext`z^(-2) ((-2) Dt[$CellContext`v] Dt[$CellContext`z] + 
     Dt[$CellContext`x]^2 $CellContext`s[$CellContext`z]^2 - 
     Dt[$CellContext`v]^2 $CellContext`t[$CellContext`z]), -
    E^($CellContext`v $CellContext`\[CapitalOmega]) $CellContext`z^(-2) \
$CellContext`\[CapitalOmega] (
     2 Dt[$CellContext`x]^2 $CellContext`s[$CellContext`z] \
($CellContext`s[$CellContext`z] - $CellContext`z 
       Derivative[1][$CellContext`s][$CellContext`z]) + $CellContext`z 
      Dt[$CellContext`v]^2 (2 $CellContext`\[CapitalOmega] + 
       Derivative[1][$CellContext`t][$CellContext`z]))}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5390652889509497`*^9, 3.539065413093459*^9}, 
   3.53906568193797*^9, 3.539067366118129*^9, 3.539067409924519*^9, {
   3.539067512486582*^9, 3.539067549674774*^9}, 3.539067600920166*^9, {
   3.5390722318985977`*^9, 3.5390722489503527`*^9}, 3.5390726494084682`*^9, 
   3.539072735601165*^9, 3.539072802472344*^9, 3.5390728592598553`*^9, {
   3.5390729377625027`*^9, 3.539072961626141*^9}, 3.539072997668346*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.5390652889509497`*^9, 3.539065413093459*^9}, 
   3.53906568193797*^9, 3.539067366118129*^9, 3.539067409924519*^9, {
   3.539067512486582*^9, 3.539067549674774*^9}, 3.539067600920166*^9, {
   3.5390722318985977`*^9, 3.5390722489503527`*^9}, 3.5390726494084682`*^9, 
   3.539072735601165*^9, 3.539072802472344*^9, 3.5390728592598553`*^9, {
   3.5390729377625027`*^9, 3.539072961626141*^9}, 3.5390729976707706`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.5390652889509497`*^9, 3.539065413093459*^9}, 
   3.53906568193797*^9, 3.539067366118129*^9, 3.539067409924519*^9, {
   3.539067512486582*^9, 3.539067549674774*^9}, 3.539067600920166*^9, {
   3.5390722318985977`*^9, 3.5390722489503527`*^9}, 3.5390726494084682`*^9, 
   3.539072735601165*^9, 3.539072802472344*^9, 3.5390728592598553`*^9, {
   3.5390729377625027`*^9, 3.539072961626141*^9}, 3.5390729976723003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "z", " ", 
   SuperscriptBox["\[CapitalOmega]", "2"]}], "+", 
  RowBox[{"z", " ", "\[CapitalOmega]", " ", 
   RowBox[{
    SuperscriptBox["t", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.5390652889509497`*^9, 3.539065413093459*^9}, 
   3.53906568193797*^9, 3.539067366118129*^9, 3.539067409924519*^9, {
   3.539067512486582*^9, 3.539067549674774*^9}, 3.539067600920166*^9, {
   3.5390722318985977`*^9, 3.5390722489503527`*^9}, 3.5390726494084682`*^9, 
   3.539072735601165*^9, 3.539072802472344*^9, 3.5390728592598553`*^9, {
   3.5390729377625027`*^9, 3.539072961626141*^9}, 3.539072997673915*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[CapitalOmega]"}], " ", 
   RowBox[{"s", "[", "z", "]"}]}], "+", 
  RowBox[{"z", " ", "\[CapitalOmega]", " ", 
   RowBox[{
    SuperscriptBox["s", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.5390652889509497`*^9, 3.539065413093459*^9}, 
   3.53906568193797*^9, 3.539067366118129*^9, 3.539067409924519*^9, {
   3.539067512486582*^9, 3.539067549674774*^9}, 3.539067600920166*^9, {
   3.5390722318985977`*^9, 3.5390722489503527`*^9}, 3.5390726494084682`*^9, 
   3.539072735601165*^9, 3.539072802472344*^9, 3.5390728592598553`*^9, {
   3.5390729377625027`*^9, 3.539072961626141*^9}, 3.539072997675562*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"scal", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"v", "\[Rule]", 
        RowBox[{"v", "+", 
         RowBox[{"\[Lambda]", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}], ",", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"z", "+", 
         RowBox[{"\[Lambda]", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}], 
          RowBox[{"(", 
           RowBox[{"z", " ", "\[CapitalOmega]"}], ")"}]}]}]}]}], "}"}]}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"tmp", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Dt", "[", "\[CapitalOmega]", "]"}], "\[Rule]", "0"}], 
       "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.539065759657011*^9, 3.53906576798454*^9}, 
   3.539072883408326*^9, {3.539073005262814*^9, 3.539073005404525*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"f", "[", "z", "]"}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", "z", " ", "\[CapitalOmega]",
     " ", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}], " ", "\[Lambda]"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Lambda]", "]"}], "2"],
    SeriesData[$CellContext`\[Lambda], 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Lambda], 0, {
    $CellContext`f[$CellContext`z], 
    E^($CellContext`v $CellContext`\[CapitalOmega]) $CellContext`z \
$CellContext`\[CapitalOmega] Derivative[1][$CellContext`f][$CellContext`z]}, 
   0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.539065761372724*^9, 3.539065768773141*^9}, 
   3.539065877360962*^9, 3.53906733878547*^9, 3.539067378246745*^9, 
   3.5390728870278177`*^9, 3.539073005793358*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"gauge", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"v", "\[Rule]", 
        RowBox[{"v", "+", 
         RowBox[{"\[Lambda]", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}], ",", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"z", "+", 
         RowBox[{"\[Lambda]", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}], 
          RowBox[{"(", 
           RowBox[{"z", " ", "\[CapitalOmega]"}], ")"}]}]}]}]}], "}"}]}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"tmp", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Dt", "[", "\[CapitalOmega]", "]"}], "\[Rule]", "0"}], 
       "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.53906578144808*^9, 3.539065781919344*^9}, 
   3.53907288577567*^9, 3.539073008953184*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "z", "]"}], " ", 
    RowBox[{"Dt", "[", "v", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", "\[CapitalOmega]", " ", 
    RowBox[{"Dt", "[", "v", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", "z", "]"}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
    "\[Lambda]"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Lambda]", "]"}], "2"],
    SeriesData[$CellContext`\[Lambda], 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Lambda], 
   0, {$CellContext`a[$CellContext`z] Dt[$CellContext`v], 
    E^($CellContext`v $CellContext`\[CapitalOmega]) $CellContext`\
\[CapitalOmega] 
    Dt[$CellContext`v] ($CellContext`a[$CellContext`z] + $CellContext`z 
      Derivative[1][$CellContext`a][$CellContext`z])}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5390657843494883`*^9, 3.539065878178653*^9, 
  3.539067378862091*^9, 3.539072889047956*^9, 3.5390730094664593`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Print", "[", 
   "\"\<So the gauge mode is:\n\nfp[z_]:=\!\(\*SuperscriptBox[\(z\), \(2\)]\) \
\!\(\*SuperscriptBox[\"f\", \"\[Prime]\",
MultilineFunction->None]\)[z];\[IndentingNewLine]\[IndentingNewLine]hp[z_]:=\!\
\(\*SuperscriptBox[\(z\), \(2\)]\) \!\(\*SuperscriptBox[\"h\", \"\[Prime]\",
MultilineFunction->None]\)[z];\[IndentingNewLine]\[IndentingNewLine]ap[z_]:=\!\
\(\*SuperscriptBox[\(z\), \(2\)]\) \!\(\*SuperscriptBox[\"a\", \"\[Prime]\",
MultilineFunction->None]\)[z];\[IndentingNewLine]\[IndentingNewLine]tp[z_]:=2 \
cc \!\(\*SuperscriptBox[\(z\), \(2\)]\) \[CapitalOmega]+2 z \
\!\(\*SuperscriptBox[\(\[CapitalOmega]\), \(2\)]\)-2 cc z t[z]+cc \
\!\(\*SuperscriptBox[\(z\), \(2\)]\) \!\(\*SuperscriptBox[\"t\", \
\"\[Prime]\",
MultilineFunction->None]\)[z]+z \[CapitalOmega] \!\(\*SuperscriptBox[\"t\", \
\"\[Prime]\",
MultilineFunction->None]\)[z];\[IndentingNewLine]\[IndentingNewLine]sp[z_]:=-\
cc z s[z]-\[CapitalOmega] s[z]+cc \!\(\*SuperscriptBox[\(z\), \(2\)]\) \
\!\(\*SuperscriptBox[\"s\", \"\[Prime]\",
MultilineFunction->None]\)[z]+z \[CapitalOmega] \!\(\*SuperscriptBox[\"s\", \
\"\[Prime]\",
MultilineFunction->None]\)[z];\n\n\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.539065903989142*^9, 3.5390659467053413`*^9}, {
  3.539066072370077*^9, 3.539066075905673*^9}, {3.539066143518725*^9, 
  3.539066148183489*^9}, {3.53906622201663*^9, 3.5390662363609657`*^9}, {
  3.539072973384035*^9, 3.539072978807679*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"f", "[", "z", "]"}], "+", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"fp", "[", "z", "]"}], " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"h", "[", "z", "]"}], "+", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"hp", "[", "z", "]"}], 
     RowBox[{"Exp", "[", 
      RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"a", "[", "z", "]"}], "+", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"ap", "[", "z", "]"}], 
     RowBox[{"Exp", "[", 
      RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"s", "[", "z", "]"}], "+", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"sp", "[", "z", "]"}], 
     RowBox[{"Exp", "[", 
      RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"t", "[", "z", "]"}], "+", 
   RowBox[{"\[Lambda]", " ", 
    RowBox[{"tp", "[", "z", "]"}], 
    RowBox[{"Exp", "[", 
     RowBox[{"\[CapitalOmega]", " ", "v"}], "]"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.538893220712365*^9, 3.5388932773084*^9}, {
  3.538896496023963*^9, 3.5388965000073137`*^9}, {3.538896659656444*^9, 
  3.538896669399289*^9}, {3.538896722265585*^9, 3.53889675657655*^9}, {
  3.538910797475553*^9, 3.538910812169138*^9}, {3.538910933172551*^9, 
  3.5389109555646267`*^9}, {3.538911003454258*^9, 3.538911007619445*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Pell1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Eq1", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pell2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Eq2", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pellc1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Eq3", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pellc2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Eq4", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pell3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Eq5", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pell4", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Const1", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Pell5", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Series", "[", 
      RowBox[{"Const2", ",", 
       RowBox[{"{", 
        RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pellc3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const3", ",", 
      RowBox[{"{", 
       RowBox[{"\[Lambda]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.537627679175139*^9, 3.537627742317072*^9}, {
  3.537636876281947*^9, 3.53763687844884*^9}, {3.5376379765369062`*^9, 
  3.537638074206946*^9}, {3.537638144466118*^9, 3.537638162905325*^9}, {
  3.53889676419934*^9, 3.5388968130405397`*^9}, {3.53891063130486*^9, 
  3.538910667357551*^9}, {3.538911037688806*^9, 3.538911077439234*^9}, {
  3.538979533169455*^9, 3.538979540401514*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pell1", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pell2", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pell3", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pell4", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pell5", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pellc1", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SeriesCoefficient", "[", 
      RowBox[{"Pellc2", ",", "0"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pellc3", ",", "0"}], "]"}], "/.", 
    RowBox[{"D", "[", 
     RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}]}], "Input",
 CellChangeTimes->{{3.538910635586172*^9, 3.538910678672346*^9}, {
  3.538911084801166*^9, 3.538911099381049*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911099991852*^9, 3.538979619144343*^9, 3.538980176981518*^9, 
   3.5389813987003183`*^9, 3.5389818846961517`*^9, 3.538982115195939*^9, 
   3.538982178601594*^9, 3.539000843905612*^9, 3.539019447140073*^9, 
   3.539020203537736*^9, 3.539021375769611*^9, 3.5390216770555363`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911099991852*^9, 3.538979619144343*^9, 3.538980176981518*^9, 
   3.5389813987003183`*^9, 3.5389818846961517`*^9, 3.538982115195939*^9, 
   3.538982178601594*^9, 3.539000843905612*^9, 3.539019447140073*^9, 
   3.539020203537736*^9, 3.539021375769611*^9, 3.539021677058382*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911099991852*^9, 3.538979619144343*^9, 3.538980176981518*^9, 
   3.5389813987003183`*^9, 3.5389818846961517`*^9, 3.538982115195939*^9, 
   3.538982178601594*^9, 3.539000843905612*^9, 3.539019447140073*^9, 
   3.539020203537736*^9, 3.539021375769611*^9, 3.539021677162074*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911099991852*^9, 3.538979619144343*^9, 3.538980176981518*^9, 
   3.5389813987003183`*^9, 3.5389818846961517`*^9, 3.538982115195939*^9, 
   3.538982178601594*^9, 3.539000843905612*^9, 3.539019447140073*^9, 
   3.539020203537736*^9, 3.539021375769611*^9, 3.53902167716431*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911099991852*^9, 3.538979619144343*^9, 3.538980176981518*^9, 
   3.5389813987003183`*^9, 3.5389818846961517`*^9, 3.538982115195939*^9, 
   3.538982178601594*^9, 3.539000843905612*^9, 3.539019447140073*^9, 
   3.539020203537736*^9, 3.539021375769611*^9, 3.539021677166423*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911099991852*^9, 3.538979619144343*^9, 3.538980176981518*^9, 
   3.5389813987003183`*^9, 3.5389818846961517`*^9, 3.538982115195939*^9, 
   3.538982178601594*^9, 3.539000843905612*^9, 3.539019447140073*^9, 
   3.539020203537736*^9, 3.539021375769611*^9, 3.5390216771684647`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911099991852*^9, 3.538979619144343*^9, 3.538980176981518*^9, 
   3.5389813987003183`*^9, 3.5389818846961517`*^9, 3.538982115195939*^9, 
   3.538982178601594*^9, 3.539000843905612*^9, 3.539019447140073*^9, 
   3.539020203537736*^9, 3.539021375769611*^9, 3.539021677170526*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.538910644152996*^9, 3.5389106796077957`*^9}, 
   3.538910815513175*^9, {3.53891099418469*^9, 3.5389110128995047`*^9}, 
   3.538911099991852*^9, 3.538979619144343*^9, 3.538980176981518*^9, 
   3.5389813987003183`*^9, 3.5389818846961517`*^9, 3.538982115195939*^9, 
   3.538982178601594*^9, 3.539000843905612*^9, 3.539019447140073*^9, 
   3.539020203537736*^9, 3.539021375769611*^9, 3.539021677211092*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Lin1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pell1", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lin2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pell2", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lin3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pell3", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lin4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pell4", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lin5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pell5", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinC1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pellc1", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LinC2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"SeriesCoefficient", "[", 
     RowBox[{"Pellc2", ",", "1"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"LinC3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{"Pellc3", ",", "1"}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.53891068699997*^9, {3.538910874784109*^9, 3.5389108826653137`*^9}, 
   3.538910968039218*^9, {3.538911030185012*^9, 3.538911032974782*^9}, {
   3.538911107200781*^9, 3.5389111365949783`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "2"], " ", 
    SuperscriptBox[
     RowBox[{"s", "[", "z", "]"}], "2"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"fp", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"s", "[", "z", "]"}], "+", 
        RowBox[{"z", " ", "\[CapitalOmega]", " ", 
         RowBox[{"s", "[", "z", "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{"hp", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["a", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"h", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["ap", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", "z", " ", "\[CapitalOmega]", " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"sp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", "z", " ", "\[CapitalOmega]", " ", 
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["fp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["fp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"sp", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["fp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"ap", "[", "z", "]"}], " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{"s", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "+", 
           RowBox[{
            RowBox[{"h", "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"s", "[", "z", "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["s", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["sp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"hp", "[", "z", "]"}], " ", 
            RowBox[{"s", "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"s", "[", "z", "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["s", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
           
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox[
                RowBox[{"s", "[", "z", "]"}], "2"], " ", 
               RowBox[{
                SuperscriptBox["hp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "-", 
              RowBox[{
               RowBox[{"h", "[", "z", "]"}], " ", 
               RowBox[{"sp", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["s", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{
               RowBox[{"h", "[", "z", "]"}], " ", 
               RowBox[{"s", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["sp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{"z", " ", 
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["fp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["t", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"z", " ", 
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["tp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"z", " ", 
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"z", " ", 
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["fp", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911139750238*^9, 3.5389796213156977`*^9, 3.538980178054953*^9, 
   3.5389814007903967`*^9, 3.5389818868891497`*^9, 3.538982115387595*^9, 
   3.5389821816884527`*^9, 3.539000844129184*^9, 3.539019447317028*^9, 
   3.539020203732341*^9, 3.539021375990335*^9, 3.539021677252146*^9}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"], " ", 
     SuperscriptBox[
      RowBox[{"s", "[", "z", "]"}], "2"]}]], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"]}], "+", 
      RowBox[{"2", " ", "z", " ", "\[CapitalOmega]", " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"fp", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["ap", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "z", " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", "z", " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"hp", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"sp", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"ap", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"z", " ", 
          RowBox[{"s", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"s", "[", "z", "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
        ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"a", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"fp", "[", "z", "]"}], " ", 
          RowBox[{"s", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"s", "[", "z", "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"s", "[", "z", "]"}], "2"], " ", 
             RowBox[{
              SuperscriptBox["fp", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "-", 
            RowBox[{
             RowBox[{"f", "[", "z", "]"}], " ", 
             RowBox[{"sp", "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "+", 
            RowBox[{
             RowBox[{"f", "[", "z", "]"}], " ", 
             RowBox[{"s", "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["sp", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
        ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["tp", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"tp", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"s", "[", "z", "]"}], "2"], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["hp", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}]}]], "Output",\

 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911139750238*^9, 3.5389796213156977`*^9, 3.538980178054953*^9, 
   3.5389814007903967`*^9, 3.5389818868891497`*^9, 3.538982115387595*^9, 
   3.5389821816884527`*^9, 3.539000844129184*^9, 3.539019447317028*^9, 
   3.539020203732341*^9, 3.539021375990335*^9, 3.539021677258309*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"z", " ", 
    SuperscriptBox[
     RowBox[{"s", "[", "z", "]"}], "3"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
     RowBox[{
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"tp", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"t", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["sp", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"sp", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"z", " ", "\[CapitalOmega]"}], "-", 
              RowBox[{"t", "[", "z", "]"}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"t", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "\[CapitalOmega]", " ", 
         RowBox[{"sp", "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["sp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["sp", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["z", "3"], " ", 
         RowBox[{
          SuperscriptBox["a", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["ap", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", "\[CapitalOmega]", " ", 
         RowBox[{"fp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"ap", "[", "z", "]"}], " ", 
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"hp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["fp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["fp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"ap", "[", "z", "]"}], " ", 
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"fp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", "\[CapitalOmega]", " ", 
         RowBox[{"hp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["h", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["hp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["hp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["tp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["tp", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911139750238*^9, 3.5389796213156977`*^9, 3.538980178054953*^9, 
   3.5389814007903967`*^9, 3.5389818868891497`*^9, 3.538982115387595*^9, 
   3.5389821816884527`*^9, 3.539000844129184*^9, 3.539019447317028*^9, 
   3.539020203732341*^9, 3.539021375990335*^9, 3.539021677264084*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"sp", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}], "2"]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"s", "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["f", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}], " ", 
           RowBox[{
            SuperscriptBox["fp", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{
            SuperscriptBox["h", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}], " ", 
           RowBox[{
            SuperscriptBox["hp", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["sp", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911139750238*^9, 3.5389796213156977`*^9, 3.538980178054953*^9, 
   3.5389814007903967`*^9, 3.5389818868891497`*^9, 3.538982115387595*^9, 
   3.5389821816884527`*^9, 3.539000844129184*^9, 3.539019447317028*^9, 
   3.539020203732341*^9, 3.539021375990335*^9, 3.539021677268331*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"hp", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["fp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"fp", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["hp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["sp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["z", "2"], " ", 
   SuperscriptBox[
    RowBox[{"s", "[", "z", "]"}], "2"]}]]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911139750238*^9, 3.5389796213156977`*^9, 3.538980178054953*^9, 
   3.5389814007903967`*^9, 3.5389818868891497`*^9, 3.538982115387595*^9, 
   3.5389821816884527`*^9, 3.539000844129184*^9, 3.539019447317028*^9, 
   3.539020203732341*^9, 3.539021375990335*^9, 3.5390216772708883`*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", "\[CapitalOmega]", " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], 
     RowBox[{"s", "[", "z", "]"}]], "+", 
    RowBox[{"\[CapitalOmega]", " ", 
     RowBox[{
      SuperscriptBox["ap", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[CapitalOmega]", " ", 
         RowBox[{"fp", "[", "z", "]"}], " ", 
         RowBox[{"h", "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"ap", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"f", "[", "z", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"]}], ")"}]}], "-", 
        RowBox[{"\[CapitalOmega]", " ", 
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"hp", "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", "z", "]"}], " ", 
            RowBox[{"fp", "[", "z", "]"}]}], "+", 
           RowBox[{
            RowBox[{"h", "[", "z", "]"}], " ", 
            RowBox[{"hp", "[", "z", "]"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"hp", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["fp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"fp", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["hp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
     SuperscriptBox["z", "2"]]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911139750238*^9, 3.5389796213156977`*^9, 3.538980178054953*^9, 
   3.5389814007903967`*^9, 3.5389818868891497`*^9, 3.538982115387595*^9, 
   3.5389821816884527`*^9, 3.539000844129184*^9, 3.539019447317028*^9, 
   3.539020203732341*^9, 3.539021375990335*^9, 3.539021677273505*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox["z", "2"], " ", 
    SuperscriptBox[
     RowBox[{"s", "[", "z", "]"}], "2"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"8", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"fp", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "3"]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"hp", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "3"]}], "+", 
     RowBox[{"12", " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}]}], "-", 
     RowBox[{"16", " ", "z", " ", "\[CapitalOmega]", " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"f", "[", "z", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"h", "[", "z", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}]}], "-", 
     RowBox[{"12", " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}]}], "-", 
     RowBox[{"12", " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "3"], " ", 
      RowBox[{"tp", "[", "z", "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["ap", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "3"], " ", 
      RowBox[{"tp", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "3"], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["fp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "3"], " ", 
      RowBox[{"tp", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "3"], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["hp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"16", " ", "z", " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"tp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"tp", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["sp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"16", " ", "z", " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["sp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["sp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"4", " ", "z", " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["sp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{"4", " ", "z", " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["tp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["tp", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911139750238*^9, 3.5389796213156977`*^9, 3.538980178054953*^9, 
   3.5389814007903967`*^9, 3.5389818868891497`*^9, 3.538982115387595*^9, 
   3.5389821816884527`*^9, 3.539000844129184*^9, 3.539019447317028*^9, 
   3.539020203732341*^9, 3.539021375990335*^9, 3.539021677276978*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    SuperscriptBox["z", "2"], " ", 
    SuperscriptBox[
     RowBox[{"s", "[", "z", "]"}], "2"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"v", " ", "\[CapitalOmega]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", "z", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"fp", "[", "z", "]"}], " ", 
         RowBox[{"s", "[", "z", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"f", "[", "z", "]"}], "2"], " ", 
         RowBox[{"sp", "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"hp", "[", "z", "]"}], " ", 
            RowBox[{"s", "[", "z", "]"}]}], "+", 
           RowBox[{
            RowBox[{"h", "[", "z", "]"}], " ", 
            RowBox[{"sp", "[", "z", "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"a", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"ap", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"f", "[", "z", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"h", "[", "z", "]"}], "2"]}], ")"}], " ", 
         RowBox[{"s", "[", "z", "]"}]}], "-", 
        RowBox[{"2", " ", "\[CapitalOmega]", " ", 
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"hp", "[", "z", "]"}], " ", 
         RowBox[{"s", "[", "z", "]"}]}], "-", 
        RowBox[{
         RowBox[{"hp", "[", "z", "]"}], " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"sp", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["fp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"sp", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"fp", "[", "z", "]"}], " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "\[CapitalOmega]", " ", 
            RowBox[{"h", "[", "z", "]"}]}], "+", 
           RowBox[{
            RowBox[{"t", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["hp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"sp", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", "z", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["s", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[CapitalOmega]"}], " ", 
         RowBox[{"sp", "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"tp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["sp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"12", " ", 
         RowBox[{"tp", "[", "z", "]"}]}], "+", 
        RowBox[{"4", " ", "z", " ", "\[CapitalOmega]", " ", 
         RowBox[{"tp", "[", "z", "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", "z", "]"}], "2"], " ", 
         RowBox[{"tp", "[", "z", "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"h", "[", "z", "]"}], "2"], " ", 
         RowBox[{"tp", "[", "z", "]"}]}], "-", 
        RowBox[{"24", " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{"tp", "[", "z", "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["a", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "4"], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["ap", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
         RowBox[{"fp", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"hp", "[", "z", "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"ap", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"t", "[", "z", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["fp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
         RowBox[{"hp", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["h", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"fp", "[", "z", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"ap", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"t", "[", "z", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["hp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"tp", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["t", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["tp", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"sp", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"t", "[", "z", "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "6"}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["h", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
             ")"}]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "\[CapitalOmega]"}], "+", 
              RowBox[{
               SuperscriptBox["t", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"t", "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"12", "-", 
              RowBox[{"16", " ", "z", " ", "\[CapitalOmega]"}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox[
                RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox[
                RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
              RowBox[{
               SuperscriptBox["z", "4"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["a", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
              RowBox[{"4", " ", "z", " ", 
               RowBox[{
                SuperscriptBox["t", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"tp", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "8"}], " ", 
               RowBox[{"t", "[", "z", "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{"(", 
                RowBox[{"\[CapitalOmega]", "+", 
                 RowBox[{
                  SuperscriptBox["t", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            RowBox[{"t", "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", 
               RowBox[{"t", "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["sp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["sp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["t", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["s", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], " ", 
               RowBox[{
                SuperscriptBox["tp", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.538910687334223*^9, 3.538910819067212*^9, {3.5389108771483107`*^9, 
   3.538910899427073*^9}, {3.538910996569477*^9, 3.538911033913309*^9}, 
   3.538911139750238*^9, 3.5389796213156977`*^9, 3.538980178054953*^9, 
   3.5389814007903967`*^9, 3.5389818868891497`*^9, 3.538982115387595*^9, 
   3.5389821816884527`*^9, 3.539000844129184*^9, 3.539019447317028*^9, 
   3.539020203732341*^9, 3.539021375990335*^9, 3.539021677283679*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<Residual diffeo in z\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.5390725586286793`*^9, 3.539072566309*^9}}],

Cell[BoxData["\<\"Residual diffeo in z\"\>"], "Print",
 CellChangeTimes->{3.539072566850284*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fp", "[", "z_", "]"}], ":=", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["f", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"hp", "[", "z_", "]"}], ":=", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["h", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ap", "[", "z_", "]"}], ":=", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"tp", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", "\[CapitalOmega]"}], "-", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"t", "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["t", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "z"}], " ", 
     RowBox[{"s", "[", "z", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["s", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Lin1", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Lin2", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Lin3", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Lin4", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Lin5", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"LinC1", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"LinC2", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LinC3", "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
    RowBox[{"D", "[", 
     RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}]}], "Input",
 CellChangeTimes->{{3.53906589432929*^9, 3.539065894787127*^9}, {
  3.539065952575613*^9, 3.539066021108136*^9}, {3.539066154098887*^9, 
  3.5390661731805487`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.539065895424651*^9, {3.539065949287653*^9, 3.5390660255457983`*^9}, 
   3.5390660800253887`*^9, {3.53906615085327*^9, 3.5390661737686462`*^9}, 
   3.539066263411482*^9, 3.5390723976106997`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.539065895424651*^9, {3.539065949287653*^9, 3.5390660255457983`*^9}, 
   3.5390660800253887`*^9, {3.53906615085327*^9, 3.5390661737686462`*^9}, 
   3.539066263411482*^9, 3.53907239841053*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.539065895424651*^9, {3.539065949287653*^9, 3.5390660255457983`*^9}, 
   3.5390660800253887`*^9, {3.53906615085327*^9, 3.5390661737686462`*^9}, 
   3.539066263411482*^9, 3.53907240066181*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.539065895424651*^9, {3.539065949287653*^9, 3.5390660255457983`*^9}, 
   3.5390660800253887`*^9, {3.53906615085327*^9, 3.5390661737686462`*^9}, 
   3.539066263411482*^9, 3.5390724007201*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.539065895424651*^9, {3.539065949287653*^9, 3.5390660255457983`*^9}, 
   3.5390660800253887`*^9, {3.53906615085327*^9, 3.5390661737686462`*^9}, 
   3.539066263411482*^9, 3.5390724007959843`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.539065895424651*^9, {3.539065949287653*^9, 3.5390660255457983`*^9}, 
   3.5390660800253887`*^9, {3.53906615085327*^9, 3.5390661737686462`*^9}, 
   3.539066263411482*^9, 3.539072400846977*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.539065895424651*^9, {3.539065949287653*^9, 3.5390660255457983`*^9}, 
   3.5390660800253887`*^9, {3.53906615085327*^9, 3.5390661737686462`*^9}, 
   3.539066263411482*^9, 3.539072401076096*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.539065895424651*^9, {3.539065949287653*^9, 3.5390660255457983`*^9}, 
   3.5390660800253887`*^9, {3.53906615085327*^9, 3.5390661737686462`*^9}, 
   3.539066263411482*^9, 3.539072401446477*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<Residual gauge rotation\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.539072573245997*^9, 3.539072577549027*^9}}],

Cell[BoxData["\<\"Residual gauge rotation\"\>"], "Print",
 CellChangeTimes->{3.539072578005459*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fp", "[", "z_", "]"}], ":=", 
    RowBox[{"h", "[", "z", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"hp", "[", "z_", "]"}], ":=", 
    RowBox[{"-", 
     RowBox[{"f", "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ap", "[", "z_", "]"}], ":=", 
    RowBox[{"-", "\[CapitalOmega]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"tp", "[", "z_", "]"}], ":=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", "z_", "]"}], ":=", "0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.539071451631996*^9, 3.539071454425889*^9}, 
   3.539071501455624*^9, {3.5390715501526613`*^9, 3.539071563511059*^9}, {
   3.5390716708613997`*^9, 3.539071700277362*^9}, {3.539072410347307*^9, 
   3.5390724664663982`*^9}, {3.5390725400788937`*^9, 3.539072544334196*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Lin1", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Lin2", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Lin3", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Lin4", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Lin5", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"LinC1", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"LinC2", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"sols", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LinC3", "/.", 
     RowBox[{"D", "[", 
      RowBox[{"sols", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
    RowBox[{"D", "[", 
     RowBox[{"sols", ",", "z"}], "]"}]}], "/.", "sols"}], "]"}]}], "Input"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.539072445134326*^9, 3.539072467850297*^9}, 
   3.539072546609507*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.539072445134326*^9, 3.539072467850297*^9}, 
   3.539072546675497*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.539072445134326*^9, 3.539072467850297*^9}, 
   3.539072546677144*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.539072445134326*^9, 3.539072467850297*^9}, 
   3.5390725466788073`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.539072445134326*^9, 3.539072467850297*^9}, 
   3.539072546680478*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.539072445134326*^9, 3.539072467850297*^9}, 
   3.5390725466821404`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.539072445134326*^9, 3.539072467850297*^9}, 
   3.539072546683815*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.539072445134326*^9, 3.539072467850297*^9}, 
   3.539072546685508*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"fp", ",", "hp", ",", "ap", ",", "tp", ",", "sp"}], "]"}]], "Input",\

 CellChangeTimes->{{3.539066264482314*^9, 3.53906626953166*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sollin", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lin1", "\[Equal]", "0"}], ",", 
         RowBox[{"Lin4", "\[Equal]", "0"}], ",", 
         RowBox[{"Lin5", "\[Equal]", "0"}], ",", 
         RowBox[{"LinC1", "\[Equal]", "0"}], ",", 
         RowBox[{"LinC2", "\[Equal]", "0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"fp", "''"}], "[", "z", "]"}], ",", 
         RowBox[{
          RowBox[{"ap", "''"}], "[", "z", "]"}], ",", 
         RowBox[{
          RowBox[{"sp", "''"}], "[", "z", "]"}], ",", 
         RowBox[{
          RowBox[{"tp", "'"}], "[", "z", "]"}], ",", 
         RowBox[{
          RowBox[{"hp", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538911161594118*^9, 3.538911221252846*^9}, {
   3.538911418456649*^9, 3.538911421696932*^9}, 3.538979644304429*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"lineqlist", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"fp", "''"}], "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"ap", "''"}], "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"sp", "''"}], "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"tp", "'"}], "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"hp", "'"}], "[", "z", "]"}]}], "}"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"fp", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"ap", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"sp", "''"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"tp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"hp", "'"}], "[", "z", "]"}]}], "}"}], "/.", "sollin"}], 
     ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5389796481978083`*^9, 3.53897969237202*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", "\[CapitalOmega]", "]"}]], "Input",
 CellChangeTimes->{{3.538981341345841*^9, 3.538981343373848*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.538980363048118*^9, 3.538980369887815*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{
      RowBox[{"lineqlist", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"fp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"ap", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"sp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"tp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"hp", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{
      RowBox[{"lineqlist", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"fp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"ap", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"sp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"tp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"hp", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{
      RowBox[{"lineqlist", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"fp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"ap", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"sp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"tp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"hp", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{
      RowBox[{"lineqlist", "[", 
       RowBox[{"[", "4", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"fp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"ap", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"sp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"tp", "'"}], "[", "z", "]"}], ",", 
        RowBox[{
         RowBox[{"hp", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", "[", 
   RowBox[{"[", "5", "]"}], "]"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"lineqlist", "[", 
      RowBox[{"[", "5", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"fp", "'"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"ap", "'"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"sp", "'"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"tp", "'"}], "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"hp", "'"}], "[", "z", "]"}]}], "}"}]}], "]"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.538979694608572*^9, 3.538979699098072*^9}, {
  3.538979826628045*^9, 3.538979872844204*^9}, {3.538980308087015*^9, 
  3.538980332180708*^9}, {3.538980371105117*^9, 3.538980390597684*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "[", "z", "]"}], "-", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["s", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "z", " ", "\[CapitalOmega]"}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"t", "[", "z", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", "z", "]"}], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["f", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["t", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "z", " ", "\[CapitalOmega]"}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"t", "[", "z", "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["t", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
       ")"}]}]}], 
    RowBox[{"z", " ", 
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"s", "[", "z", "]"}], " ", 
     RowBox[{"t", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"s", "[", "z", "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["s", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"s", "[", "z", "]"}], "-", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["z", "3"], " ", "\[CapitalOmega]", " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"h", "[", "z", "]"}], " ", 
            RowBox[{"s", "[", "z", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "3"], " ", 
            RowBox[{"s", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["a", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "+", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"h", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
       ")"}]}]}], 
    RowBox[{"2", " ", 
     RowBox[{"f", "[", "z", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"t", "[", "z", "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "[", "z", "]"}], "-", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["s", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"s", "[", "z", "]"}], "-", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"t", "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "\[CapitalOmega]"}], "+", 
           RowBox[{
            SuperscriptBox["t", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], 
       ")"}]}]}], 
    RowBox[{
     RowBox[{"s", "[", "z", "]"}], " ", 
     RowBox[{"t", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "[", "z", "]"}], "-", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["s", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], ",", "0", 
   ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5389796995539217`*^9, {3.5389798447595997`*^9, 3.538979873405945*^9}, 
   3.538980181982366*^9, {3.538980312351036*^9, 3.5389803326748333`*^9}, {
   3.5389803921572847`*^9, 3.5389803975464973`*^9}, 3.538980869112522*^9, 
   3.538980904746174*^9, 3.5389814266060247`*^9, 3.538981920951893*^9, 
   3.538982187104966*^9, 3.5390008465160303`*^9, 3.539019449520804*^9, 
   3.5390202059693413`*^9, 3.539021378247704*^9, 3.539021679486085*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["\[CapitalOmega]", 
      RowBox[{"t", "[", "z", "]"}]]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], 
     RowBox[{"s", "[", "z", "]"}]]}], ",", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}], 
    RowBox[{"s", "[", "z", "]"}]], ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5389796995539217`*^9, {3.5389798447595997`*^9, 3.538979873405945*^9}, 
   3.538980181982366*^9, {3.538980312351036*^9, 3.5389803326748333`*^9}, {
   3.5389803921572847`*^9, 3.5389803975464973`*^9}, 3.538980869112522*^9, 
   3.538980904746174*^9, 3.5389814266060247`*^9, 3.538981920951893*^9, 
   3.538982187104966*^9, 3.5390008465160303`*^9, 3.539019449520804*^9, 
   3.5390202059693413`*^9, 3.539021378247704*^9, 3.539021679489594*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"s", "[", "z", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"h", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], 
       RowBox[{"f", "[", "z", "]"}]]}], ")"}]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}]}]]}], ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.5389796995539217`*^9, {3.5389798447595997`*^9, 3.538979873405945*^9}, 
   3.538980181982366*^9, {3.538980312351036*^9, 3.5389803326748333`*^9}, {
   3.5389803921572847`*^9, 3.5389803975464973`*^9}, 3.538980869112522*^9, 
   3.538980904746174*^9, 3.5389814266060247`*^9, 3.538981920951893*^9, 
   3.538982187104966*^9, 3.5390008465160303`*^9, 3.539019449520804*^9, 
   3.5390202059693413`*^9, 3.539021378247704*^9, 3.539021679532353*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"z", " ", 
     RowBox[{"s", "[", "z", "]"}], " ", 
     RowBox[{"t", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"h", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "[", "z", "]"}], "-", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["s", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["a", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"\[CapitalOmega]", " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"s", "[", "z", "]"}], "-", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "z", " ", 
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "z", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"t", "[", "z", "]"}]}], "-", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["t", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
    RowBox[{
     RowBox[{"s", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "[", "z", "]"}], "-", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["s", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], ",", "1", 
   ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5389796995539217`*^9, {3.5389798447595997`*^9, 3.538979873405945*^9}, 
   3.538980181982366*^9, {3.538980312351036*^9, 3.5389803326748333`*^9}, {
   3.5389803921572847`*^9, 3.5389803975464973`*^9}, 3.538980869112522*^9, 
   3.538980904746174*^9, 3.5389814266060247`*^9, 3.538981920951893*^9, 
   3.538982187104966*^9, 3.5390008465160303`*^9, 3.539019449520804*^9, 
   3.5390202059693413`*^9, 3.539021378247704*^9, 3.53902167953476*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"h", "[", "z", "]"}], 
     RowBox[{"f", "[", "z", "]"}]]}], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], " ", "\[CapitalOmega]"}], 
    RowBox[{"2", " ", 
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"t", "[", "z", "]"}]}]], ",", "0", ",", "0", ",", "1"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.5389796995539217`*^9, {3.5389798447595997`*^9, 3.538979873405945*^9}, 
   3.538980181982366*^9, {3.538980312351036*^9, 3.5389803326748333`*^9}, {
   3.5389803921572847`*^9, 3.5389803975464973`*^9}, 3.538980869112522*^9, 
   3.538980904746174*^9, 3.5389814266060247`*^9, 3.538981920951893*^9, 
   3.538982187104966*^9, 3.5390008465160303`*^9, 3.539019449520804*^9, 
   3.5390202059693413`*^9, 3.539021378247704*^9, 3.5390216795369062`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat2", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.53898071547444*^9, 3.53898071999198*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat2", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "lineqlist", ")"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"fp", "[", "z", "]"}], ",", 
        RowBox[{"ap", "[", "z", "]"}], ",", 
        RowBox[{"sp", "[", "z", "]"}], ",", 
        RowBox[{"tp", "[", "z", "]"}], ",", 
        RowBox[{"hp", "[", "z", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mat2", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "lineqlist", ")"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"fp", "[", "z", "]"}], ",", 
        RowBox[{"ap", "[", "z", "]"}], ",", 
        RowBox[{"sp", "[", "z", "]"}], ",", 
        RowBox[{"tp", "[", "z", "]"}], ",", 
        RowBox[{"hp", "[", "z", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mat2", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "lineqlist", ")"}], "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"fp", "[", "z", "]"}], ",", 
        RowBox[{"ap", "[", "z", "]"}], ",", 
        RowBox[{"sp", "[", "z", "]"}], ",", 
        RowBox[{"tp", "[", "z", "]"}], ",", 
        RowBox[{"hp", "[", "z", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mat2", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "lineqlist", ")"}], "[", 
       RowBox[{"[", "4", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"fp", "[", "z", "]"}], ",", 
        RowBox[{"ap", "[", "z", "]"}], ",", 
        RowBox[{"sp", "[", "z", "]"}], ",", 
        RowBox[{"tp", "[", "z", "]"}], ",", 
        RowBox[{"hp", "[", "z", "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat2", "[", 
   RowBox[{"[", "5", "]"}], "]"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", "lineqlist", ")"}], "[", 
      RowBox[{"[", "5", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fp", "[", "z", "]"}], ",", 
       RowBox[{"ap", "[", "z", "]"}], ",", 
       RowBox[{"sp", "[", "z", "]"}], ",", 
       RowBox[{"tp", "[", "z", "]"}], ",", 
       RowBox[{"hp", "[", "z", "]"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.538980504103249*^9, 3.53898051083939*^9}, {
  3.538980557616282*^9, 3.5389805727110147`*^9}, {3.5389807123698883`*^9, 
  3.5389807625994673`*^9}, {3.538980888107252*^9, 3.538980911723599*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", "z", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"s", "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"a", "[", "z", "]"}], "2"], " ", 
       RowBox[{"f", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"s", "[", "z", "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["s", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"a", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[CapitalOmega]", " ", 
          RowBox[{"h", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "[", "z", "]"}], "-", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"t", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "[", "z", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"f", "[", "z", "]"}], " ", 
             RowBox[{"s", "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["f", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "-", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
        ")"}]}], "-", 
      RowBox[{
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "z", " ", 
          SuperscriptBox[
           RowBox[{"f", "[", "z", "]"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"s", "[", "z", "]"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          SuperscriptBox[
           RowBox[{"s", "[", "z", "]"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[CapitalOmega]", " ", 
             RowBox[{"h", "[", "z", "]"}]}], "+", 
            RowBox[{
             RowBox[{"t", "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["h", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"f", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "[", "z", "]"}], "-", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "[", "z", "]"}], "+", 
            RowBox[{"z", " ", "\[CapitalOmega]", " ", 
             RowBox[{"s", "[", "z", "]"}]}], "-", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
        ")"}]}]}], ")"}]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"h", "[", "z", "]"}], "2"]}], ")"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"s", "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"f", "[", "z", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"h", "[", "z", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "[", "z", "]"}], "-", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"h", "[", "z", "]"}]}], " ", 
            RowBox[{"s", "[", "z", "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"s", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"h", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
       ")"}]}]}], 
    RowBox[{"z", " ", 
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"s", "[", "z", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"t", "[", "z", "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"s", "[", "z", "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["s", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", "z", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"s", "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "z", " ", 
       RowBox[{"a", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"s", "[", "z", "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["s", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
          RowBox[{"s", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["a", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", "z", "]"}], " ", 
          RowBox[{"h", "[", "z", "]"}], " ", 
          RowBox[{"t", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"f", "[", "z", "]"}], "3"], " ", 
          SuperscriptBox[
           RowBox[{"s", "[", "z", "]"}], "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "4"], " ", "\[CapitalOmega]", " ", 
          SuperscriptBox[
           RowBox[{"s", "[", "z", "]"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["a", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "z", " ", 
             RowBox[{"s", "[", "z", "]"}], " ", 
             RowBox[{"t", "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"t", "[", "z", "]"}], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["s", "\[Prime]",
                MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"s", "[", "z", "]"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{"12", "-", 
               RowBox[{"8", " ", "z", " ", "\[CapitalOmega]"}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"h", "[", "z", "]"}], "2"]}], "-", 
               RowBox[{
                SuperscriptBox["z", "4"], " ", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["a", "\[Prime]",
                   MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"t", "[", "z", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "6"}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                 ")"}]}], "+", 
               RowBox[{"4", " ", "z", " ", 
                RowBox[{
                 SuperscriptBox["t", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "z", " ", 
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"h", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"s", "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"h", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["s", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"s", "[", "z", "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "3"]}], "-", 
              RowBox[{
               RowBox[{
                SuperscriptBox["f", "\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
                ")"}]}], "-", 
              RowBox[{"2", " ", "z", " ", 
               RowBox[{
                SuperscriptBox["f", "\[Prime]\[Prime]",
                 MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}], 
    RowBox[{"2", " ", "z", " ", 
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"s", "[", "z", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"t", "[", "z", "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"s", "[", "z", "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["s", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", "z", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"s", "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", "z", " ", 
       SuperscriptBox[
        RowBox[{"a", "[", "z", "]"}], "2"], " ", 
       RowBox[{"h", "[", "z", "]"}], " ", 
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"s", "[", "z", "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["s", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"a", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"z", " ", 
          RowBox[{"s", "[", "z", "]"}], " ", 
          RowBox[{"t", "[", "z", "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"s", "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"z", " ", 
                RowBox[{"h", "[", "z", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["h", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"s", "[", "z", "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"s", "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"z", " ", "\[CapitalOmega]"}], "-", 
               RowBox[{"t", "[", "z", "]"}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"t", "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
        ")"}]}], "+", 
      RowBox[{
       RowBox[{"s", "[", "z", "]"}], " ", 
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", "z", "]"}], " ", 
          RowBox[{"t", "[", "z", "]"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["f", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["h", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", "z", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"s", "[", "z", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["a", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}]}], "+", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", 
                   RowBox[{"h", "[", "z", "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
                   RowBox[{
                    SuperscriptBox["h", "\[Prime]",
                    MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
              ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["a", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}], " ", 
             RowBox[{
              SuperscriptBox["s", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
        ")"}]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.538980912247896*^9, 3.538981438441393*^9, 
  3.538981925111916*^9, 3.538982188878977*^9, 3.5390008469417667`*^9, 
  3.5390194499613953`*^9, 3.539020206418364*^9, 3.53902137868793*^9, 
  3.5390216799286222`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"f", "[", "z", "]"}]}], "+", 
        RowBox[{"\[CapitalOmega]", " ", 
         RowBox[{"h", "[", "z", "]"}]}]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"t", "[", "z", "]"}]}]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"h", "[", "z", "]"}], "2"]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"t", "[", "z", "]"}]}]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[CapitalOmega]", " ", 
         RowBox[{"s", "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{"t", "[", "z", "]"}]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{"t", "[", "z", "]"}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "\[CapitalOmega]", " ", 
      RowBox[{"f", "[", "z", "]"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"h", "[", "z", "]"}]}]}], 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{"t", "[", "z", "]"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.538980912247896*^9, 3.538981438441393*^9, 
  3.538981925111916*^9, 3.538982188878977*^9, 3.5390008469417667`*^9, 
  3.5390194499613953`*^9, 3.539020206418364*^9, 3.53902137868793*^9, 
  3.539021679937522*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"a", "[", "z", "]"}], " ", 
         RowBox[{"f", "[", "z", "]"}]}], "+", 
        RowBox[{"\[CapitalOmega]", " ", 
         RowBox[{"h", "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"t", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}]}]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"h", "[", "z", "]"}], "2"]}], ")"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}]}]]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], "2"], "+", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
            RowBox[{
             SuperscriptBox["a", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}], 
           RowBox[{
            RowBox[{"f", "[", "z", "]"}], " ", 
            RowBox[{"t", "[", "z", "]"}]}]]}], "+", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], ")"}]}]}], ")"}]}], 
   ",", 
   FractionBox[
    RowBox[{
     RowBox[{"s", "[", "z", "]"}], " ", 
     RowBox[{
      SuperscriptBox["h", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"h", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], "-", 
       RowBox[{
        RowBox[{"f", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}], 
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"t", "[", "z", "]"}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"s", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[CapitalOmega]", " ", 
        RowBox[{"f", "[", "z", "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"a", "[", "z", "]"}], " ", 
        RowBox[{"h", "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"t", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["h", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}], 
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"t", "[", "z", "]"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.538980912247896*^9, 3.538981438441393*^9, 
  3.538981925111916*^9, 3.538982188878977*^9, 3.5390008469417667`*^9, 
  3.5390194499613953`*^9, 3.539020206418364*^9, 3.53902137868793*^9, 
  3.5390216799879093`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"s", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"a", "[", "z", "]"}], " ", 
        RowBox[{"f", "[", "z", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[CapitalOmega]", " ", 
           RowBox[{"h", "[", "z", "]"}]}], "+", 
          RowBox[{
           RowBox[{"t", "[", "z", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h", "\[Prime]",
             MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
      ")"}]}], 
    RowBox[{"z", " ", 
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"s", "[", "z", "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["s", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"h", "[", "z", "]"}], "2"]}], ")"}], " ", 
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"s", "[", "z", "]"}], "-", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox[
       RowBox[{"f", "[", "z", "]"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "4"], " ", "\[CapitalOmega]", " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["a", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "8"}], " ", 
         SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", "z", "]"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["s", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "12"}], "+", 
           RowBox[{"16", " ", "z", " ", "\[CapitalOmega]"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"h", "[", "z", "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "4"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["a", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}], "2"]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"t", "[", "z", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "6"}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["h", "\[Prime]",
                  MultilineFunction->None], "[", "z", "]"}], "2"]}]}], 
             ")"}]}], "-", 
           RowBox[{"4", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["t", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
       ")"}]}]}], 
    RowBox[{"4", " ", "z", " ", 
     RowBox[{"f", "[", "z", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"s", "[", "z", "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"s", "[", "z", "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["s", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"h", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", "z", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"s", "[", "z", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"6", "-", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["f", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["h", "\[Prime]",
               MultilineFunction->None], "[", "z", "]"}], "2"]}]}], ")"}]}], 
        "-", 
        RowBox[{"8", " ", "z", " ", 
         RowBox[{"s", "[", "z", "]"}], " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["s", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "2"]}]}], ")"}]}]}], 
    RowBox[{"2", " ", "z", " ", 
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"s", "[", "z", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"s", "[", "z", "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["s", "\[Prime]",
          MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"s", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"a", "[", "z", "]"}], " ", 
            RowBox[{"h", "[", "z", "]"}]}], "+", 
           RowBox[{
            RowBox[{"t", "[", "z", "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["h", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}], "+", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"h", "[", "z", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
            RowBox[{
             SuperscriptBox["h", "\[Prime]",
              MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]}], 
       ")"}]}], 
     RowBox[{"z", " ", 
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"s", "[", "z", "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["s", "\[Prime]",
           MultilineFunction->None], "[", "z", "]"}]}]}], ")"}]}]]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538980912247896*^9, 3.538981438441393*^9, 
  3.538981925111916*^9, 3.538982188878977*^9, 3.5390008469417667`*^9, 
  3.5390194499613953`*^9, 3.539020206418364*^9, 3.53902137868793*^9, 
  3.539021680063918*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"a", "[", "z", "]"}], " ", 
      RowBox[{"f", "[", "z", "]"}]}], "+", 
     RowBox[{"\[CapitalOmega]", " ", 
      RowBox[{"h", "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"t", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], 
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"t", "[", "z", "]"}]}]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"f", "[", "z", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"h", "[", "z", "]"}], "2"]}], 
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"t", "[", "z", "]"}]}]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], " ", "\[CapitalOmega]", " ", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}], 
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"s", "[", "z", "]"}], " ", 
     RowBox[{"t", "[", "z", "]"}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"h", "[", "z", "]"}]}], " ", 
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], 
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], " ", 
     RowBox[{"t", "[", "z", "]"}]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"\[CapitalOmega]", " ", 
       RowBox[{"f", "[", "z", "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"a", "[", "z", "]"}], " ", 
       RowBox[{"h", "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"t", "[", "z", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}]}], 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], " ", 
      RowBox[{"t", "[", "z", "]"}]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{3.538980912247896*^9, 3.538981438441393*^9, 
  3.538981925111916*^9, 3.538982188878977*^9, 3.5390008469417667`*^9, 
  3.5390194499613953`*^9, 3.539020206418364*^9, 3.53902137868793*^9, 
  3.539021680104579*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Asym", "Subsubtitle",
 CellChangeTimes->{{3.538981626811451*^9, 3.538981641587184*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"replasym", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538981658178071*^9, 3.538981659318812*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"p2", " ", 
       SuperscriptBox["z", "2"]}], "+", 
      RowBox[{"a0", " ", "h2", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "a1", " ", "h2"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a0", "2"], " ", "p2"}]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a0", "3"]}], " ", "h2"}], "-", 
         RowBox[{"2", " ", "a0", " ", "a1", " ", "p2"}], "-", 
         RowBox[{"p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "5"]}], "+", 
      RowBox[{
       FractionBox["1", "60"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "30"}], " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "h2"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "4"], " ", "p2"}], "-", 
         RowBox[{"15", " ", 
          SuperscriptBox["a1", "2"], " ", "p2"}], "+", 
         RowBox[{"14", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}], "-", 
         RowBox[{"35", " ", "a0", " ", "h2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{
       FractionBox["1", "180"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "5"], " ", "h2"}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "69"}], " ", 
             SuperscriptBox["a1", "2"], " ", "h2"}], "+", 
            RowBox[{"60", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"66", " ", "a1", " ", "h2", " ", "T3"}], "+", 
         RowBox[{"99", " ", 
          SuperscriptBox["a0", "2"], " ", "p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"280", " ", 
           SuperscriptBox["a0", "4"], " ", "a1", " ", "h2"}], "-", 
          RowBox[{"315", " ", 
           SuperscriptBox["a1", "3"], " ", "h2"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["a0", "6"], " ", "p2"}], "+", 
          RowBox[{"504", " ", "a1", " ", "h2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["h2", "2"], "+", 
             SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"806", " ", 
              SuperscriptBox["a1", "2"], " ", "p2"}], "-", 
             RowBox[{"860", " ", "p2", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"896", " ", 
           SuperscriptBox["a0", "3"], " ", "h2", " ", "T3"}], "+", 
          RowBox[{"1649", " ", "a0", " ", "a1", " ", "p2", " ", "T3"}], "+", 
          RowBox[{"500", " ", "p2", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "2520"], "+", 
      RowBox[{
       FractionBox["1", "1260"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a0", "7"], " ", "h2"}], "-", 
         RowBox[{"48", " ", 
          SuperscriptBox["a0", "5"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{
          SuperscriptBox["a0", "3"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"235", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"324", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", "a0", " ", "a1", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"33", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"61", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "386"}], " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"110", " ", 
             SuperscriptBox["a0", "4"], " ", "p2"}], "-", 
            RowBox[{"183", " ", 
             SuperscriptBox["a1", "2"], " ", "p2"}], "+", 
            RowBox[{"167", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "+", 
         RowBox[{"535", " ", "a0", " ", "h2", " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "+", 
      RowBox[{
       FractionBox["1", "90720"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1008"}], " ", 
          SuperscriptBox["a0", "6"], " ", "a1", " ", "h2"}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["a0", "8"], " ", "p2"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"469", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"1093", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a0", "4"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1906"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"3641", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"54", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"105", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"298", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"162", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3132", " ", 
             SuperscriptBox["a0", "4"], " ", "h2"}], "+", 
            RowBox[{"17768", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"9", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2756"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"2443", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"26388", " ", "a1", " ", "h2"}], "-", 
            RowBox[{"42517", " ", 
             SuperscriptBox["a0", "2"], " ", "p2"}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "10"]}], "+", 
      RowBox[{
       FractionBox["1", "453600"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"32", " ", 
             SuperscriptBox["a0", "8"], " ", "h2"}], "+", 
            RowBox[{"640", " ", 
             SuperscriptBox["a0", "6"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"38", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "680"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"2129", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["a0", "4"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3506"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"9625", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"8445", " ", 
                SuperscriptBox["a1", "4"]}], "-", 
               RowBox[{"27322", " ", 
                SuperscriptBox["a1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
               RowBox[{"11384", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["h2", "2"], "+", 
                   SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "43168"}], " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"5180", " ", 
             SuperscriptBox["a0", "6"], " ", "p2"}], "+", 
            RowBox[{"12", " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3795", " ", 
                SuperscriptBox["a1", "2"]}], "-", 
               RowBox[{"6062", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a0", "2"], " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "122040"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"132161", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "-", 
         RowBox[{"5", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"31441", " ", 
             SuperscriptBox["a0", "2"], " ", "h2"}], "+", 
            RowBox[{"54768", " ", "a1", " ", "p2"}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"64000", " ", "p2", " ", 
          SuperscriptBox["T3", "3"]}]}], ")"}], " ", 
       SuperscriptBox["z", "11"]}], "+", 
      RowBox[{
       FractionBox["1", "9979200"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6336", " ", 
          SuperscriptBox["a0", "8"], " ", "a1", " ", "h2"}], "-", 
         RowBox[{"256", " ", 
          SuperscriptBox["a0", "10"], " ", "p2"}], "+", 
         RowBox[{"198", " ", "a1", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"105", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"302", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"16", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["a0", "6"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5999"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"24481", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"44", " ", 
          SuperscriptBox["a0", "4"], " ", "a1", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12114"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"52981", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a0", "2"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"261441", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"1083379", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"493120", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"32384", " ", 
             SuperscriptBox["a0", "6"], " ", "h2"}], "+", 
            RowBox[{"372148", " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"44", " ", 
             SuperscriptBox["a0", "2"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "40939"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"57354", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1957536"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"3601319", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "6405487"}], " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"1911860", " ", 
             SuperscriptBox["a0", "4"], " ", "p2"}], "+", 
            RowBox[{"4", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "739971"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"683452", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"3376120", " ", "a0", " ", "h2", " ", 
          SuperscriptBox["T3", "3"]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}]}], "//.", "replasym"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"h2", " ", 
       SuperscriptBox["z", "2"]}], "-", 
      RowBox[{"a0", " ", "p2", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a0", "2"], " ", "h2"}], "-", 
         RowBox[{"3", " ", "a1", " ", "p2"}]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "a0", " ", "a1", " ", "h2"}], "+", 
         RowBox[{
          SuperscriptBox["a0", "3"], " ", "p2"}], "-", 
         RowBox[{"h2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "5"]}], "+", 
      RowBox[{
       FractionBox["1", "60"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "4"], " ", "h2"}], "-", 
         RowBox[{"15", " ", 
          SuperscriptBox["a1", "2"], " ", "h2"}], "+", 
         RowBox[{"30", " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"14", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
         RowBox[{"35", " ", "a0", " ", "p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{
       FractionBox["1", "180"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"48", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "h2"}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "5"], " ", "p2"}], "+", 
         RowBox[{"a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"69", " ", 
             SuperscriptBox["a1", "2"], " ", "p2"}], "-", 
            RowBox[{"60", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"99", " ", 
          SuperscriptBox["a0", "2"], " ", "h2", " ", "T3"}], "+", 
         RowBox[{"66", " ", "a1", " ", "p2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "32"}], " ", 
           SuperscriptBox["a0", "6"], " ", "h2"}], "-", 
          RowBox[{"280", " ", 
           SuperscriptBox["a0", "4"], " ", "a1", " ", "p2"}], "+", 
          RowBox[{"63", " ", "a1", " ", "p2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["a1", "2"]}], "-", 
             RowBox[{"8", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"806", " ", 
              SuperscriptBox["a1", "2"], " ", "h2"}], "-", 
             RowBox[{"860", " ", "h2", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"1649", " ", "a0", " ", "a1", " ", "h2", " ", "T3"}], "-", 
          RowBox[{"896", " ", 
           SuperscriptBox["a0", "3"], " ", "p2", " ", "T3"}], "+", 
          RowBox[{"500", " ", "h2", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "2520"], "+", 
      RowBox[{
       FractionBox["1", "1260"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "48"}], " ", 
          SuperscriptBox["a0", "5"], " ", "a1", " ", "h2"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a0", "7"], " ", "p2"}], "+", 
         RowBox[{"8", " ", "a0", " ", "a1", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"33", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"61", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a0", "3"], " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "235"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"324", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"110", " ", 
             SuperscriptBox["a0", "4"], " ", "h2"}], "-", 
            RowBox[{"183", " ", 
             SuperscriptBox["a1", "2"], " ", "h2"}], "+", 
            RowBox[{"386", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"167", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "-", 
         RowBox[{"535", " ", "a0", " ", "p2", " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "+", 
      RowBox[{
       FractionBox["1", "90720"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"64", " ", 
          SuperscriptBox["a0", "8"], " ", "h2"}], "+", 
         RowBox[{"1008", " ", 
          SuperscriptBox["a0", "6"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["a0", "2"], " ", "a1", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "469"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"1093", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a0", "4"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1906"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"3641", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"54", " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"105", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"298", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"162", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "17768"}], " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"3132", " ", 
             SuperscriptBox["a0", "4"], " ", "p2"}], "+", 
            RowBox[{"9", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2756"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"2443", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"42517", " ", 
             SuperscriptBox["a0", "2"], " ", "h2"}], "+", 
            RowBox[{"26388", " ", "a1", " ", "p2"}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "10"]}], "+", 
      RowBox[{
       FractionBox["1", "453600"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"640", " ", 
             SuperscriptBox["a0", "6"], " ", "a1", " ", "h2"}], "-", 
            RowBox[{"32", " ", 
             SuperscriptBox["a0", "8"], " ", "p2"}], "+", 
            RowBox[{"38", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "680"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"2129", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["a0", "4"], " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3506"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"9625", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"3", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"8445", " ", 
                SuperscriptBox["a1", "4"]}], "-", 
               RowBox[{"27322", " ", 
                SuperscriptBox["a1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
               RowBox[{"11384", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["h2", "2"], "+", 
                   SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5180", " ", 
             SuperscriptBox["a0", "6"], " ", "h2"}], "+", 
            RowBox[{"43168", " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"12", " ", "a1", " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3795"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"6062", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a0", "2"], " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "122040"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"132161", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "+", 
         RowBox[{"5", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "54768"}], " ", "a1", " ", "h2"}], "+", 
            RowBox[{"31441", " ", 
             SuperscriptBox["a0", "2"], " ", "p2"}]}], ")"}], " ", 
          SuperscriptBox["T3", "2"]}], "-", 
         RowBox[{"64000", " ", "h2", " ", 
          SuperscriptBox["T3", "3"]}]}], ")"}], " ", 
       SuperscriptBox["z", "11"]}], "+", 
      RowBox[{
       FractionBox["1", "9979200"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "256"}], " ", 
          SuperscriptBox["a0", "10"], " ", "h2"}], "-", 
         RowBox[{"6336", " ", 
          SuperscriptBox["a0", "8"], " ", "a1", " ", "p2"}], "+", 
         RowBox[{"44", " ", 
          SuperscriptBox["a0", "4"], " ", "a1", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"12114", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"52981", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"198", " ", "a1", " ", "p2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"105", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"302", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"16", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["a0", "6"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5999"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"24481", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a0", "2"], " ", "h2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"261441", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"1083379", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"493120", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"372148", " ", 
             SuperscriptBox["a0", "4"], " ", "a1", " ", "h2"}], "-", 
            RowBox[{"32384", " ", 
             SuperscriptBox["a0", "6"], " ", "p2"}], "-", 
            RowBox[{"44", " ", 
             SuperscriptBox["a0", "2"], " ", "p2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "40939"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"57354", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"a1", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1957536"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"3601319", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", "T3"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1911860", " ", 
             SuperscriptBox["a0", "4"], " ", "h2"}], "+", 
            RowBox[{"6405487", " ", 
             SuperscriptBox["a0", "2"], " ", "a1", " ", "p2"}], "+", 
            RowBox[{"4", " ", "h2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "739971"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"683452", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}], 
          " ", 
          SuperscriptBox["T3", "2"]}], "+", 
         RowBox[{"3376120", " ", "a0", " ", "p2", " ", 
          SuperscriptBox["T3", "3"]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}]}], "//.", "replasym"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"a0", "+", 
      RowBox[{"a1", " ", "z"}], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", "a0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", "a1", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "5"]}], "-", 
      RowBox[{
       FractionBox["1", "45"], " ", 
       SuperscriptBox["a0", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "-", 
      RowBox[{
       FractionBox["5", "126"], " ", "a0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a0", " ", "a1"}], "+", 
         RowBox[{"2", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["a0", "5"]}], "+", 
          RowBox[{"a0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "85"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"127", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"200", " ", "a1", " ", "T3"}]}], ")"}], " ", 
        SuperscriptBox["z", "8"]}], "2520"], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"98", " ", 
           SuperscriptBox["a0", "4"], " ", "a1"}], "+", 
          RowBox[{"9", " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "45"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"139", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"448", " ", 
           SuperscriptBox["a0", "3"], " ", "T3"}]}], ")"}], " ", 
        SuperscriptBox["z", "9"]}], "22680"], "-", 
      FractionBox[
       RowBox[{"a0", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["a0", "6"]}], "+", 
          RowBox[{
           SuperscriptBox["a0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "905"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"2224", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"4250", " ", "a0", " ", "a1", " ", "T3"}], "-", 
          RowBox[{"5480", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "10"]}], "113400"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a0", "2"], " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"162", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"5735", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"23903", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"a0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"1314", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"25115", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"36858", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
          "-", 
          RowBox[{"30410", " ", "a1", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "11"]}], "623700"], "+", 
      RowBox[{
       FractionBox["1", "14968800"], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"32", " ", 
          SuperscriptBox["a0", "9"]}], "+", 
         RowBox[{
          SuperscriptBox["a0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "11756"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"58132", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"9", " ", "a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10845", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"55822", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"33662", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"90872", " ", 
          SuperscriptBox["a0", "4"], " ", "a1", " ", "T3"}], "+", 
         RowBox[{"72", " ", "a1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4905", " ", 
             SuperscriptBox["a1", "2"]}], "-", 
            RowBox[{"13168", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}], 
         "-", 
         RowBox[{"247250", " ", 
          SuperscriptBox["a0", "3"], " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}]}], "//.", "replasym"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"t", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"T3", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{
       FractionBox["1", "12"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["a1", "2"]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       SuperscriptBox["a0", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{
       FractionBox["1", "9"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "a0", " ", "a1"}], "+", "T3"}], ")"}], " ", 
       SuperscriptBox["z", "7"]}], "-", 
      RowBox[{
       FractionBox["1", "630"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"14", " ", 
          SuperscriptBox["a0", "4"]}], "-", 
         RowBox[{"75", " ", 
          SuperscriptBox["a1", "2"]}], "+", 
         RowBox[{"38", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "8"]}], "-", 
      RowBox[{
       FractionBox["1", "180"], " ", 
       SuperscriptBox["a0", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", "a0", " ", "a1"}], "+", 
         RowBox[{"16", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "6"]}], "+", 
          RowBox[{
           SuperscriptBox["a0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1385"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"1628", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"2900", " ", "a0", " ", "a1", " ", "T3"}], "-", 
          RowBox[{"860", " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "10"]}], "22680"], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "a0", " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"24", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"195", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"482", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"387", " ", 
              SuperscriptBox["a0", "4"]}], "-", 
             RowBox[{"1335", " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"1096", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}]}], 
         ")"}], " ", 
        SuperscriptBox["z", "11"]}], "18900"], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h2", "2"], "+", 
          SuperscriptBox["p2", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"88", " ", 
           SuperscriptBox["a0", "8"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a0", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4485"}], " ", 
              SuperscriptBox["a1", "2"]}], "+", 
             RowBox[{"9886", " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"9", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2025", " ", 
              SuperscriptBox["a1", "4"]}], "-", 
             RowBox[{"7905", " ", 
              SuperscriptBox["a1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
             RowBox[{"2908", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["h2", "2"], "+", 
                 SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
          RowBox[{"63515", " ", 
           SuperscriptBox["a0", "3"], " ", "a1", " ", "T3"}], "-", 
          RowBox[{"67735", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
        SuperscriptBox["z", "12"]}], "1247400"]}], "//.", "replasym"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["h2", "2"]}], "-", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      SuperscriptBox["z", "4"]}], "+", 
     RowBox[{
      FractionBox["1", "36"], " ", 
      SuperscriptBox["a0", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      SuperscriptBox["z", "6"]}], "+", 
     RowBox[{
      FractionBox["1", "63"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h2", "2"], "+", 
        SuperscriptBox["p2", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a0", " ", "a1"}], "+", 
        RowBox[{"5", " ", "T3"}]}], ")"}], " ", 
      SuperscriptBox["z", "7"]}], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["a0", "4"]}], "-", 
         RowBox[{"45", " ", 
          SuperscriptBox["a1", "2"]}], "+", 
         RowBox[{"111", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h2", "2"], "+", 
            SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", 
       SuperscriptBox["z", "8"]}], "2520"], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a0", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"13", " ", "a0", " ", "a1"}], "+", 
         RowBox[{"74", " ", "T3"}]}], ")"}], " ", 
       SuperscriptBox["z", "9"]}], "3240"], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"18", " ", 
          SuperscriptBox["a0", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "785"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"2519", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"1670", " ", "a0", " ", "a1", " ", "T3"}], "-", 
         RowBox[{"5750", " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "10"]}], "113400"], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a0", " ", "a1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"26", " ", 
             SuperscriptBox["a0", "4"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "85"}], " ", 
                SuperscriptBox["a1", "2"]}], "+", 
               RowBox[{"426", " ", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["h2", "2"], "+", 
                  SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"79", " ", 
             SuperscriptBox["a0", "4"]}], "-", 
            RowBox[{"545", " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"1342", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}], " ", "T3"}]}], 
        ")"}], " ", 
       SuperscriptBox["z", "11"]}], "69300"], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h2", "2"], "+", 
         SuperscriptBox["p2", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"88", " ", 
          SuperscriptBox["a0", "8"]}], "+", 
         RowBox[{
          SuperscriptBox["a0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "15940"}], " ", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"82193", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"27", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1575", " ", 
             SuperscriptBox["a1", "4"]}], "-", 
            RowBox[{"9430", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h2", "2"], "+", 
               SuperscriptBox["p2", "2"]}], ")"}]}], "+", 
            RowBox[{"9886", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["h2", "2"], "+", 
                SuperscriptBox["p2", "2"]}], ")"}], "2"]}]}], ")"}]}], "-", 
         RowBox[{"82660", " ", 
          SuperscriptBox["a0", "3"], " ", "a1", " ", "T3"}], "-", 
         RowBox[{"275950", " ", 
          SuperscriptBox["a0", "2"], " ", 
          SuperscriptBox["T3", "2"]}]}], ")"}], " ", 
       SuperscriptBox["z", "12"]}], "14968800"]}], "//.", "replasym"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.537640798221807*^9, 3.5376408063887777`*^9}, {
  3.538462913984427*^9, 3.53846295871097*^9}, {3.538463135071212*^9, 
  3.538463146908863*^9}, {3.538464374794805*^9, 3.538464392634185*^9}, {
  3.538981622788464*^9, 3.538981673802824*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fp", "[", "z_", "]"}], ":=", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["f", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"hp", "[", "z_", "]"}], ":=", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["h", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ap", "[", "z_", "]"}], ":=", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"tp", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", "\[CapitalOmega]"}], "-", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"t", "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["t", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "z"}], " ", 
     RowBox[{"s", "[", "z", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["s", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"fp", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"hp", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"ap", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"tp", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"sp", "[", "z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.539066381856297*^9, 3.539066422868949*^9}, {
  3.539066503339622*^9, 3.5390665169305763`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"2", " ", "p2", " ", 
    SuperscriptBox["z", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "4"],
    SeriesData[$CellContext`z, 0, {}, 3, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {2 $CellContext`p2}, 3, 4, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.539066509872802*^9, 3.5390665205921164`*^9}, 
   3.5390668457431383`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"2", " ", "h2", " ", 
    SuperscriptBox["z", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "4"],
    SeriesData[$CellContext`z, 0, {}, 3, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {2 $CellContext`h2}, 3, 4, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.539066509872802*^9, 3.5390665205921164`*^9}, 
   3.539066845745064*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"a1", " ", 
    SuperscriptBox["z", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {$CellContext`a1}, 2, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.539066509872802*^9, 3.5390665205921164`*^9}, 
   3.539066845746554*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"2", " ", "z"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {-2}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.539066509872802*^9, 3.5390665205921164`*^9}, 
   3.5390668457480497`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "z"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {-1}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.539066509872802*^9, 3.5390665205921164`*^9}, 
   3.5390668457495327`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"So", " ", 
    RowBox[{"doesn", "'"}], "t", " ", "effect", " ", "p"}], ",", " ", "h", 
   ",", " ", 
   RowBox[{"a", " ", "asym"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"BUT", " ", "does", " ", "effect", " ", "t"}], " ", "&"}], " ", 
    RowBox[{"s", "."}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.539066571841284*^9, 3.539066601577763*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fp", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"+", "fp2"}], " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"fp3", " ", 
      SuperscriptBox["z", "3"]}], "+", 
     RowBox[{"fp4", " ", 
      SuperscriptBox["z", "4"]}], "+", 
     RowBox[{"fp5", " ", 
      SuperscriptBox["z", "5"]}], "+", 
     RowBox[{"fp6", " ", 
      SuperscriptBox["z", "6"]}], "+", 
     RowBox[{"fp7", " ", 
      SuperscriptBox["z", "7"]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"hp", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"+", "hp2"}], " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"hp3", " ", 
      SuperscriptBox["z", "3"]}], "+", 
     RowBox[{"hp4", " ", 
      SuperscriptBox["z", "4"]}], "+", 
     RowBox[{"hp5", " ", 
      SuperscriptBox["z", "5"]}], "+", 
     RowBox[{"hp6", " ", 
      SuperscriptBox["z", "6"]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ap", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"+", "ap1"}], " ", 
      SuperscriptBox["z", "1"]}], "+", 
     RowBox[{"ap2", " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"ap3", " ", 
      SuperscriptBox["z", "3"]}], "+", 
     RowBox[{"ap4", " ", 
      SuperscriptBox["z", "4"]}], "+", 
     RowBox[{"ap5", " ", 
      SuperscriptBox["z", "5"]}], "+", 
     RowBox[{"ap6", " ", 
      SuperscriptBox["z", "6"]}], "+", 
     RowBox[{"ap7", " ", 
      SuperscriptBox["z", "7"]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"tp", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"tp3", " ", 
      SuperscriptBox["z", "3"]}], "+", 
     RowBox[{"tp4", " ", 
      SuperscriptBox["z", "4"]}], "+", 
     RowBox[{"tp5", " ", 
      SuperscriptBox["z", "5"]}], "+", 
     RowBox[{"tp6", " ", 
      SuperscriptBox["z", "6"]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"sp3", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"sp4", " ", 
     SuperscriptBox["z", "4"]}], "+", 
    RowBox[{"sp5", " ", 
     SuperscriptBox["z", "5"]}], "+", 
    RowBox[{"sp6", " ", 
     SuperscriptBox["z", "6"]}], "+", 
    RowBox[{"sp7", " ", 
     SuperscriptBox["z", "7"]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538982267092062*^9, 3.538982437025618*^9}, {
  3.538982638687595*^9, 3.538982642022311*^9}, {3.5389828785611353`*^9, 
  3.538982927523243*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538982438673417*^9, 3.5389824398634863`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Series", "[", 
    RowBox[{"lineqlist", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"tmp", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"ap1", ",", "sp1", ",", "tp1", ",", "ap2", ",", "sp2"}], 
       "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", 
     RowBox[{"sol", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538981702070169*^9, 3.538981708876315*^9}, {
  3.538982219214478*^9, 3.538982258170023*^9}, {3.5389824180258007`*^9, 
  3.538982496090857*^9}, {3.538982699691133*^9, 3.538982712563756*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"a0", " ", "ap1", " ", "\[CapitalOmega]"}], "p2"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "1"],
      SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     0, {$CellContext`a0 $CellContext`ap1 $CellContext`p2^(-1) $CellContext`\
\[CapitalOmega]}, 0, 1, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "ap2"}], "-", 
       RowBox[{"ap1", " ", "\[CapitalOmega]"}]}], ")"}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "1"],
      SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     2 $CellContext`ap2 - $CellContext`ap1 $CellContext`\[CapitalOmega]}, 0, 
     1, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 1, 1, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 2, 2, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"ap1", " ", "\[CapitalOmega]"}], 
      RowBox[{"2", " ", "p2"}]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "1"],
      SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Rational[1, 
        2] $CellContext`ap1 $CellContext`p2^(-1) \
$CellContext`\[CapitalOmega]}, 0, 1, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{{3.538981700077217*^9, 3.5389817093655663`*^9}, 
   3.538981930557785*^9, {3.538982217199771*^9, 3.5389822215826473`*^9}, {
   3.5389822542343493`*^9, 3.538982258727352*^9}, {3.5389824189319143`*^9, 
   3.5389824215898523`*^9}, {3.538982467138691*^9, 3.538982496542632*^9}, {
   3.5389826600532017`*^9, 3.538982680101767*^9}, 3.5389827131319447`*^9, 
   3.53898278489923*^9, 3.538982929846406*^9, 3.5390213793795357`*^9, 
   3.539021680597468*^9, 3.5390668498906593`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "svars"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.538982491567897*^9, 3.538982496544286*^9}, {
   3.5389826600549726`*^9, 3.538982680103385*^9}, 3.5389827131337347`*^9, 
   3.5389827849020653`*^9, 3.5389829298493*^9, 3.539021379431918*^9, 
   3.539021680639078*^9, 3.5390668498927727`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ap1", "\[Rule]", "0"}], ",", 
    RowBox[{"ap2", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.538981700077217*^9, 3.5389817093655663`*^9}, 
   3.538981930557785*^9, {3.538982217199771*^9, 3.5389822215826473`*^9}, {
   3.5389822542343493`*^9, 3.538982258727352*^9}, {3.5389824189319143`*^9, 
   3.5389824215898523`*^9}, {3.538982467138691*^9, 3.538982496542632*^9}, {
   3.5389826600532017`*^9, 3.538982680101767*^9}, 3.5389827131319447`*^9, 
   3.53898278489923*^9, 3.538982929846406*^9, 3.5390213793795357`*^9, 
   3.539021680597468*^9, 3.539066849894669*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"lineqlist", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"tmp", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"fp3", ",", "ap3", ",", "sp3"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", 
     RowBox[{"sol2", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.53898271906*^9, 3.538982781897258*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "fp3"}], "-", 
        RowBox[{"2", " ", "a0", " ", "hp2"}], "-", 
        RowBox[{"2", " ", "fp2", " ", "\[CapitalOmega]"}]}], ")"}], " ", 
      "z"}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "2"],
      SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     2 $CellContext`fp3 - 2 $CellContext`a0 $CellContext`hp2 - 
      2 $CellContext`fp2 $CellContext`\[CapitalOmega]}, 1, 2, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{"6", " ", "ap3", " ", "z"}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "2"],
      SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {6 $CellContext`ap3}, 1, 2, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{"6", " ", "sp3", " ", "z"}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "2"],
      SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {6 $CellContext`sp3}, 1, 2, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 2, 2, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 2, 2, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{{3.538982720800088*^9, 3.538982729102274*^9}, {
   3.538982763452735*^9, 3.5389827855828857`*^9}, 3.538982930518126*^9, 
   3.539021379703272*^9, 3.5390216809077873`*^9, 3.539066851876833*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"fp3", "\[Rule]", 
     RowBox[{
      RowBox[{"a0", " ", "hp2"}], "+", 
      RowBox[{"fp2", " ", "\[CapitalOmega]"}]}]}], ",", 
    RowBox[{"ap3", "\[Rule]", "0"}], ",", 
    RowBox[{"sp3", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.538982720800088*^9, 3.538982729102274*^9}, {
   3.538982763452735*^9, 3.5389827855828857`*^9}, 3.538982930518126*^9, 
   3.539021379703272*^9, 3.5390216809077873`*^9, 3.539066851879017*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"lineqlist", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"tmp", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"fp4", ",", "ap4", ",", "sp4", ",", "hp3"}], "}"}]}], "]"}], 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", 
     RowBox[{"sol3", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538982771066326*^9, 3.538982837746153*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a0", "2"], " ", "fp2"}], "+", 
        RowBox[{"6", " ", "fp4"}], "-", 
        RowBox[{"3", " ", "a1", " ", "hp2"}], "-", 
        RowBox[{"4", " ", "fp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}], "-", 
        RowBox[{"2", " ", "a0", " ", 
         RowBox[{"(", 
          RowBox[{"hp3", "+", 
           RowBox[{"3", " ", "hp2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
       ")"}], " ", 
      SuperscriptBox["z", "2"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "3"],
      SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     2 $CellContext`a0^2 $CellContext`fp2 + 6 $CellContext`fp4 - 
      3 $CellContext`a1 $CellContext`hp2 - 
      4 $CellContext`fp2 $CellContext`\[CapitalOmega]^2 - 
      2 $CellContext`a0 ($CellContext`hp3 + 
       3 $CellContext`hp2 $CellContext`\[CapitalOmega])}, 2, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", "ap4"}], "-", 
        RowBox[{"2", " ", "a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "-", 
        RowBox[{"fp2", " ", "h2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"hp2", " ", "p2", " ", "\[CapitalOmega]"}]}], ")"}], " ", 
      SuperscriptBox["z", "2"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "3"],
      SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     2 (6 $CellContext`ap4 - 
       2 $CellContext`a0 ($CellContext`h2 $CellContext`hp2 + $CellContext`fp2 \
$CellContext`p2) - $CellContext`fp2 $CellContext`h2 $CellContext`\
\[CapitalOmega] + $CellContext`hp2 $CellContext`p2 $CellContext`\
\[CapitalOmega])}, 2, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"h2", " ", "hp2"}], "+", 
        RowBox[{"fp2", " ", "p2"}], "+", 
        RowBox[{"3", " ", "sp4"}]}], ")"}], " ", 
      SuperscriptBox["z", "2"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "3"],
      SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     4 ($CellContext`h2 $CellContext`hp2 + $CellContext`fp2 $CellContext`p2 + 
       3 $CellContext`sp4)}, 2, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 3, 3, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a0", " ", "fp2"}], "+", "hp3", "-", 
        RowBox[{"hp2", " ", "\[CapitalOmega]"}]}], ")"}], " ", 
      SuperscriptBox["z", "2"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "3"],
      SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     0, {$CellContext`a0 $CellContext`fp2 + $CellContext`hp3 - \
$CellContext`hp2 $CellContext`\[CapitalOmega]}, 2, 3, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{{3.538982773859337*^9, 3.538982789592474*^9}, {
   3.5389828280675383`*^9, 3.538982838260544*^9}, 3.5389829314283657`*^9, 
   3.539021380280609*^9, 3.539021681474168*^9, 3.539066853169631*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"fp4", "\[Rule]", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox["a0", "2"], " ", "fp2"}], "+", 
        RowBox[{"3", " ", "a1", " ", "hp2"}], "+", 
        RowBox[{"8", " ", "a0", " ", "hp2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"4", " ", "fp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}]}], ",", 
    RowBox[{"ap4", "\[Rule]", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a0", " ", "h2", " ", "hp2"}], "+", 
        RowBox[{"2", " ", "a0", " ", "fp2", " ", "p2"}], "+", 
        RowBox[{"fp2", " ", "h2", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"hp2", " ", "p2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], ",", 
    
    RowBox[{"sp4", "\[Rule]", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "h2"}], " ", "hp2"}], "-", 
        RowBox[{"fp2", " ", "p2"}]}], ")"}]}]}], ",", 
    RowBox[{"hp3", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "a0"}], " ", "fp2"}], "+", 
      RowBox[{"hp2", " ", "\[CapitalOmega]"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.538982773859337*^9, 3.538982789592474*^9}, {
   3.5389828280675383`*^9, 3.538982838260544*^9}, 3.5389829314283657`*^9, 
   3.539021380280609*^9, 3.539021681474168*^9, 3.5390668531968603`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"lineqlist", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"tmp", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"fp5", ",", "ap5", ",", "sp5", ",", "hp4", ",", "tp4"}], 
       "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", 
     RowBox[{"sol4", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538982842321054*^9, 3.5389828684310703`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"7", " ", "a0", " ", "a1", " ", "fp2"}], "+", 
        RowBox[{"12", " ", "fp5"}], "+", 
        FractionBox[
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "3"], " ", "hp2"}], "3"], "-", 
        RowBox[{"2", " ", "a0", " ", "hp4"}], "+", 
        RowBox[{"4", " ", "fp2", " ", "T3"}], "+", 
        RowBox[{"4", " ", "p2", " ", "tp3"}], "+", 
        RowBox[{
         FractionBox["28", "3"], " ", 
         SuperscriptBox["a0", "2"], " ", "fp2", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"8", " ", "a1", " ", "hp2", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{
         FractionBox["32", "3"], " ", "a0", " ", "hp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}], "-", 
        RowBox[{"4", " ", "fp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}], " ", 
      SuperscriptBox["z", "3"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "4"],
      SeriesData[$CellContext`z, 0, {}, 3, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     7 $CellContext`a0 $CellContext`a1 $CellContext`fp2 + 12 $CellContext`fp5 + 
      Rational[8, 3] $CellContext`a0^3 $CellContext`hp2 - 
      2 $CellContext`a0 $CellContext`hp4 + 4 $CellContext`fp2 $CellContext`T3 + 
      4 $CellContext`p2 $CellContext`tp3 + 
      Rational[28, 
         3] $CellContext`a0^2 $CellContext`fp2 $CellContext`\[CapitalOmega] - 
      8 $CellContext`a1 $CellContext`hp2 $CellContext`\[CapitalOmega] + 
      Rational[-32, 
         3] $CellContext`a0 $CellContext`hp2 $CellContext`\[CapitalOmega]^2 - 
      4 $CellContext`fp2 $CellContext`\[CapitalOmega]^3}, 3, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       FractionBox["4", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "15"}], " ", "ap5"}], "+", 
         RowBox[{"5", " ", "a1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"h2", " ", "hp2"}], "+", 
            RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "\[CapitalOmega]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "a0", " ", "h2", " ", "hp2"}], "+", 
            RowBox[{"2", " ", "a0", " ", "fp2", " ", "p2"}], "+", 
            RowBox[{"fp2", " ", "h2", " ", "\[CapitalOmega]"}], "-", 
            RowBox[{"hp2", " ", "p2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
        ")"}], " ", 
       SuperscriptBox["z", "3"]}]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "4"],
      SeriesData[$CellContext`z, 0, {}, 3, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Rational[-4, 3] ((-15) $CellContext`ap5 + 
       5 $CellContext`a1 ($CellContext`h2 $CellContext`hp2 + $CellContext`fp2 \
$CellContext`p2) + 
       2 $CellContext`\[CapitalOmega] (
         2 $CellContext`a0 $CellContext`h2 $CellContext`hp2 + 
         2 $CellContext`a0 $CellContext`fp2 $CellContext`p2 + \
$CellContext`fp2 $CellContext`h2 $CellContext`\[CapitalOmega] - \
$CellContext`hp2 $CellContext`p2 $CellContext`\[CapitalOmega]))}, 3, 4, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"20", " ", "sp5"}], "+", 
        RowBox[{"6", " ", "h2", " ", "hp2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"6", " ", "fp2", " ", "p2", " ", "\[CapitalOmega]"}]}], ")"}],
       " ", 
      SuperscriptBox["z", "3"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "4"],
      SeriesData[$CellContext`z, 0, {}, 3, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     20 $CellContext`sp5 + 
      6 $CellContext`h2 $CellContext`hp2 $CellContext`\[CapitalOmega] + 
      6 $CellContext`fp2 $CellContext`p2 $CellContext`\[CapitalOmega]}, 3, 4, 
     1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", "h2", " ", "hp2"}], "3"], "+", 
        FractionBox[
         RowBox[{"2", " ", "fp2", " ", "p2"}], "3"], "+", "tp4"}], ")"}], " ", 
      SuperscriptBox["z", "3"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "4"],
      SeriesData[$CellContext`z, 0, {}, 3, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Rational[2, 3] $CellContext`h2 $CellContext`hp2 + 
      Rational[2, 3] $CellContext`fp2 $CellContext`p2 + $CellContext`tp4}, 3, 
     4, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "a1", " ", "fp2"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["a0", "2"], " ", "hp2"}], "+", 
        RowBox[{"6", " ", "hp4"}], "+", 
        RowBox[{"8", " ", "a0", " ", "fp2", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"4", " ", "hp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}], " ", 
      SuperscriptBox["z", "3"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "4"],
      SeriesData[$CellContext`z, 0, {}, 3, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Rational[1, 3] (3 $CellContext`a1 $CellContext`fp2 + 
       4 $CellContext`a0^2 $CellContext`hp2 + 6 $CellContext`hp4 + 
       8 $CellContext`a0 $CellContext`fp2 $CellContext`\[CapitalOmega] - 
       4 $CellContext`hp2 $CellContext`\[CapitalOmega]^2)}, 3, 4, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{{3.538982843341105*^9, 3.538982868967992*^9}, 
   3.538982932530488*^9, 3.5390213807619877`*^9, 3.5390216819346857`*^9, 
   3.5390668540614643`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"fp5", "\[Rule]", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "a0", " ", "a1", " ", "fp2"}], "-", 
        RowBox[{
         SuperscriptBox["a0", "3"], " ", "hp2"}], "-", 
        RowBox[{"fp2", " ", "T3"}], "-", 
        RowBox[{"p2", " ", "tp3"}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a0", "2"], " ", "fp2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"2", " ", "a1", " ", "hp2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"3", " ", "a0", " ", "hp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}], "+", 
        RowBox[{"fp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}]}], ",", 
    RowBox[{"ap5", "\[Rule]", 
     RowBox[{
      FractionBox["1", "15"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", "a1", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "\[CapitalOmega]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a0", " ", "h2", " ", "hp2"}], "+", 
           RowBox[{"2", " ", "a0", " ", "fp2", " ", "p2"}], "+", 
           RowBox[{"fp2", " ", "h2", " ", "\[CapitalOmega]"}], "-", 
           RowBox[{"hp2", " ", "p2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
       ")"}]}]}], ",", 
    RowBox[{"sp5", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["3", "10"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"h2", " ", "hp2"}], "+", 
        RowBox[{"fp2", " ", "p2"}]}], ")"}], " ", "\[CapitalOmega]"}]}], ",", 
    
    RowBox[{"hp4", "\[Rule]", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", "a1", " ", "fp2"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a0", "2"], " ", "hp2"}], "-", 
        RowBox[{"8", " ", "a0", " ", "fp2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"4", " ", "hp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}]}], ",", 
    RowBox[{"tp4", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["2", "3"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"h2", " ", "hp2"}], "+", 
        RowBox[{"fp2", " ", "p2"}]}], ")"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.538982843341105*^9, 3.538982868967992*^9}, 
   3.538982932530488*^9, 3.5390213807619877`*^9, 3.5390216819346857`*^9, 
   3.5390668540886393`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"lineqlist", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"tmp", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"fp6", ",", "ap6", ",", "sp6", ",", "hp5", ",", "tp5"}], 
       "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", 
     RowBox[{"sol5", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5389829401686897`*^9, 3.5389829501106367`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "6"}], " ", 
         SuperscriptBox["a0", "4"], " ", "fp2"}], "+", 
        RowBox[{"15", " ", 
         SuperscriptBox["a1", "2"], " ", "fp2"}], "+", 
        RowBox[{"60", " ", "fp6"}], "-", 
        RowBox[{"14", " ", "fp2", " ", 
         SuperscriptBox["h2", "2"]}], "-", 
        RowBox[{"28", " ", "h2", " ", "hp2", " ", "p2"}], "-", 
        RowBox[{"42", " ", "fp2", " ", 
         SuperscriptBox["p2", "2"]}], "+", 
        RowBox[{"26", " ", 
         SuperscriptBox["a0", "3"], " ", "hp2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"35", " ", "fp2", " ", "T3", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"8", " ", "p2", " ", "tp3", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"30", " ", "a1", " ", "hp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}], "-", 
        RowBox[{"8", " ", "fp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"26", " ", "a1", " ", "hp2"}], "+", 
           RowBox[{"42", " ", "fp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6"}], " ", "hp5"}], "+", 
           RowBox[{"33", " ", "hp2", " ", "T3"}], "+", 
           RowBox[{"33", " ", "h2", " ", "tp3"}], "+", 
           RowBox[{"56", " ", "a1", " ", "fp2", " ", "\[CapitalOmega]"}], "-", 
           RowBox[{"30", " ", "hp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}]}], ")"}], " ", 
      SuperscriptBox["z", "4"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "5"],
      SeriesData[$CellContext`z, 0, {}, 4, 5, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Rational[1, 3] ((-6) $CellContext`a0^4 $CellContext`fp2 + 
       15 $CellContext`a1^2 $CellContext`fp2 + 60 $CellContext`fp6 - 
       14 $CellContext`fp2 $CellContext`h2^2 - 
       28 $CellContext`h2 $CellContext`hp2 $CellContext`p2 - 
       42 $CellContext`fp2 $CellContext`p2^2 + 
       26 $CellContext`a0^3 $CellContext`hp2 $CellContext`\[CapitalOmega] + 
       35 $CellContext`fp2 $CellContext`T3 $CellContext`\[CapitalOmega] + 
       8 $CellContext`p2 $CellContext`tp3 $CellContext`\[CapitalOmega] - 
       30 $CellContext`a1 $CellContext`hp2 $CellContext`\[CapitalOmega]^2 - 
       8 $CellContext`fp2 $CellContext`\[CapitalOmega]^4 + $CellContext`a0^2 (
         26 $CellContext`a1 $CellContext`hp2 + 
         42 $CellContext`fp2 $CellContext`\[CapitalOmega]^2) + \
$CellContext`a0 ((-6) $CellContext`hp5 + 33 $CellContext`hp2 $CellContext`T3 + 
         33 $CellContext`h2 $CellContext`tp3 + 
         56 $CellContext`a1 $CellContext`fp2 $CellContext`\[CapitalOmega] - 
         30 $CellContext`hp2 $CellContext`\[CapitalOmega]^3))}, 4, 5, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      FractionBox["2", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"45", " ", "ap6"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a0", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"fp2", " ", "h2"}], "-", 
           RowBox[{"hp2", " ", "p2"}]}], ")"}], " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"7", " ", "a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}], " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}], "-", 
        RowBox[{"3", " ", "\[CapitalOmega]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "a1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h2", " ", "hp2"}], "+", 
              RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"fp2", " ", "h2"}], "-", 
              RowBox[{"hp2", " ", "p2"}]}], ")"}], " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}]}], ")"}], " ", 
      SuperscriptBox["z", "4"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "5"],
      SeriesData[$CellContext`z, 0, {}, 4, 5, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Rational[2, 3] (45 $CellContext`ap6 + 
       2 $CellContext`a0^3 ($CellContext`h2 $CellContext`hp2 + \
$CellContext`fp2 $CellContext`p2) + 
       3 $CellContext`a0^2 ($CellContext`fp2 $CellContext`h2 - \
$CellContext`hp2 $CellContext`p2) $CellContext`\[CapitalOmega] - 
       7 $CellContext`a0 ($CellContext`h2 $CellContext`hp2 + $CellContext`fp2 \
$CellContext`p2) $CellContext`\[CapitalOmega]^2 - 
       3 $CellContext`\[CapitalOmega] (
        4 $CellContext`a1 ($CellContext`h2 $CellContext`hp2 + \
$CellContext`fp2 $CellContext`p2) + ($CellContext`fp2 $CellContext`h2 - \
$CellContext`hp2 $CellContext`p2) $CellContext`\[CapitalOmega]^2))}, 4, 5, 1],
    
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "5"}], " ", 
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
        RowBox[{"a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", "fp2", " ", "h2", " ", 
            "\[CapitalOmega]"}], "+", 
           RowBox[{"5", " ", "hp2", " ", "p2", " ", "\[CapitalOmega]"}]}], 
          ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"45", " ", "sp6"}], "+", 
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h2", " ", "hp2"}], "+", 
              RowBox[{"fp2", " ", "p2"}]}], ")"}], " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}]}], ")"}], " ", 
      SuperscriptBox["z", "4"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "5"],
      SeriesData[$CellContext`z, 0, {}, 4, 5, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Rational[1, 
        3] ((-5) $CellContext`a0^2 ($CellContext`h2 $CellContext`hp2 + \
$CellContext`fp2 $CellContext`p2) + $CellContext`a0 ((-5) $CellContext`fp2 \
$CellContext`h2 $CellContext`\[CapitalOmega] + 
         5 $CellContext`hp2 $CellContext`p2 $CellContext`\[CapitalOmega]) + 
       2 (45 $CellContext`sp6 + 
         8 ($CellContext`h2 $CellContext`hp2 + $CellContext`fp2 \
$CellContext`p2) $CellContext`\[CapitalOmega]^2))}, 4, 5, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      FractionBox["2", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "tp5"}], "+", 
        RowBox[{"h2", " ", "hp2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"fp2", " ", "p2", " ", "\[CapitalOmega]"}]}], ")"}], " ", 
      SuperscriptBox["z", "4"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "5"],
      SeriesData[$CellContext`z, 0, {}, 4, 5, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Rational[2, 3] (
       3 $CellContext`tp5 + $CellContext`h2 $CellContext`hp2 $CellContext`\
\[CapitalOmega] + $CellContext`fp2 $CellContext`p2 $CellContext`\
\[CapitalOmega])}, 4, 5, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a0", "3"]}], " ", "fp2"}], "+", 
        RowBox[{"2", " ", "a0", " ", "a1", " ", "hp2"}], "+", 
        RowBox[{"3", " ", "hp5"}], "+", 
        RowBox[{"hp2", " ", "T3"}], "+", 
        RowBox[{"h2", " ", "tp3"}], "+", 
        RowBox[{"2", " ", "a1", " ", "fp2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a0", "2"], " ", "hp2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"3", " ", "a0", " ", "fp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}], "-", 
        RowBox[{"hp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}], " ", 
      SuperscriptBox["z", "4"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "5"],
      SeriesData[$CellContext`z, 0, {}, 4, 5, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     0, {-$CellContext`a0^3 $CellContext`fp2 + 
      2 $CellContext`a0 $CellContext`a1 $CellContext`hp2 + 
      3 $CellContext`hp5 + $CellContext`hp2 $CellContext`T3 + $CellContext`h2 \
$CellContext`tp3 + 
      2 $CellContext`a1 $CellContext`fp2 $CellContext`\[CapitalOmega] + 
      3 $CellContext`a0^2 $CellContext`hp2 $CellContext`\[CapitalOmega] + 
      3 $CellContext`a0 $CellContext`fp2 $CellContext`\[CapitalOmega]^2 - \
$CellContext`hp2 $CellContext`\[CapitalOmega]^3}, 4, 5, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.538982951340193*^9, 3.539021381995425*^9, 
  3.539021683084262*^9, 3.539066855641876*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"fp6", "\[Rule]", 
     RowBox[{
      FractionBox["1", "60"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox["a0", "4"], " ", "fp2"}], "-", 
        RowBox[{"15", " ", 
         SuperscriptBox["a1", "2"], " ", "fp2"}], "+", 
        RowBox[{"14", " ", "fp2", " ", 
         SuperscriptBox["h2", "2"]}], "+", 
        RowBox[{"28", " ", "h2", " ", "hp2", " ", "p2"}], "+", 
        RowBox[{"42", " ", "fp2", " ", 
         SuperscriptBox["p2", "2"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["a0", "3"], " ", "hp2", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"35", " ", "fp2", " ", "T3", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"8", " ", "p2", " ", "tp3", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"30", " ", "a1", " ", "hp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}], "+", 
        RowBox[{"8", " ", "fp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "4"]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "a1", " ", "hp2"}], "+", 
           RowBox[{"8", " ", "fp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}], "-", 
        RowBox[{"a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"35", " ", "hp2", " ", "T3"}], "+", 
           RowBox[{"35", " ", "h2", " ", "tp3"}], "+", 
           RowBox[{"60", " ", "a1", " ", "fp2", " ", "\[CapitalOmega]"}], "-", 
           RowBox[{"32", " ", "hp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}]}], ")"}]}]}], 
    ",", 
    RowBox[{"ap6", "\[Rule]", 
     RowBox[{
      FractionBox["1", "45"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a0", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
        RowBox[{"7", " ", "a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}], " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "fp2", " ", "h2", " ", 
            "\[CapitalOmega]"}], "+", 
           RowBox[{"3", " ", "hp2", " ", "p2", " ", "\[CapitalOmega]"}]}], 
          ")"}]}], "+", 
        RowBox[{"3", " ", "\[CapitalOmega]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "a1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h2", " ", "hp2"}], "+", 
              RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"fp2", " ", "h2"}], "-", 
              RowBox[{"hp2", " ", "p2"}]}], ")"}], " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}]}], ")"}]}]}], 
    ",", 
    RowBox[{"sp6", "\[Rule]", 
     RowBox[{
      FractionBox["1", "90"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
        RowBox[{"5", " ", "a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"fp2", " ", "h2"}], "-", 
           RowBox[{"hp2", " ", "p2"}]}], ")"}], " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"16", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}], " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}]}], ",", 
    RowBox[{"hp5", "\[Rule]", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a0", "3"], " ", "fp2"}], "-", 
        RowBox[{"2", " ", "a0", " ", "a1", " ", "hp2"}], "-", 
        RowBox[{"hp2", " ", "T3"}], "-", 
        RowBox[{"h2", " ", "tp3"}], "-", 
        RowBox[{"2", " ", "a1", " ", "fp2", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a0", "2"], " ", "hp2", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"3", " ", "a0", " ", "fp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}], "+", 
        RowBox[{"hp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}]}], ",", 
    RowBox[{"tp5", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"h2", " ", "hp2"}], "+", 
        RowBox[{"fp2", " ", "p2"}]}], ")"}], " ", "\[CapitalOmega]"}]}]}], 
   "}"}], "}"}]], "Output",
 CellChangeTimes->{3.538982951340193*^9, 3.539021381995425*^9, 
  3.539021683084262*^9, 3.539066855703044*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"lineqlist", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"tmp", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"fp7", ",", "ap7", ",", "sp7", ",", "hp6", ",", "tp6"}], 
       "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", 
     RowBox[{"sol6", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.538982955006837*^9, 3.538982971372563*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{
     RowBox[{
      FractionBox["1", "30"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "32"}], " ", 
         SuperscriptBox["a0", "5"], " ", "hp2"}], "-", 
        RowBox[{"168", " ", 
         SuperscriptBox["a0", "4"], " ", "fp2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{
         SuperscriptBox["a0", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "210"}], " ", "a1", " ", "fp2"}], "+", 
           RowBox[{"352", " ", "hp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"330", " ", 
            SuperscriptBox["a1", "2"], " ", "hp2"}], "-", 
           RowBox[{"858", " ", 
            SuperscriptBox["h2", "2"], " ", "hp2"}], "-", 
           RowBox[{"60", " ", "hp6"}], "-", 
           RowBox[{"572", " ", "fp2", " ", "h2", " ", "p2"}], "-", 
           RowBox[{"286", " ", "hp2", " ", 
            SuperscriptBox["p2", "2"]}], "+", 
           RowBox[{"955", " ", "hp2", " ", "T3", " ", "\[CapitalOmega]"}], 
           "+", 
           RowBox[{"207", " ", "h2", " ", "tp3", " ", "\[CapitalOmega]"}], 
           "+", 
           RowBox[{"690", " ", "a1", " ", "fp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}], "-", 
           RowBox[{"192", " ", "hp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "460"}], " ", "p2", " ", "tp3"}], "+", 
           RowBox[{"660", " ", "a1", " ", "hp2", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"92", " ", "fp2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", "T3"}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}]}], ")"}]}],
         "+", 
        RowBox[{"5", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"180", " ", "fp7"}], "+", 
           RowBox[{"69", " ", 
            SuperscriptBox["a1", "2"], " ", "fp2", " ", "\[CapitalOmega]"}], 
           "+", 
           RowBox[{"6", " ", "a1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"11", " ", "hp2", " ", "T3"}], "+", 
              RowBox[{"11", " ", "h2", " ", "tp3"}], "-", 
              RowBox[{"8", " ", "hp2", " ", 
               SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}], "-", 
           RowBox[{"\[CapitalOmega]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"66", " ", "h2", " ", "hp2", " ", "p2"}], "-", 
              RowBox[{"8", " ", "p2", " ", "tp3", " ", "\[CapitalOmega]"}], 
              "+", 
              RowBox[{"fp2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"60", " ", 
                  SuperscriptBox["h2", "2"]}], "+", 
                 RowBox[{"126", " ", 
                  SuperscriptBox["p2", "2"]}], "-", 
                 RowBox[{"99", " ", "T3", " ", "\[CapitalOmega]"}], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["\[CapitalOmega]", "4"]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], ")"}], " ", 
      SuperscriptBox["z", "5"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "6"],
      SeriesData[$CellContext`z, 0, {}, 5, 6, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Rational[1, 30] ((-32) $CellContext`a0^5 $CellContext`hp2 - 
       168 $CellContext`a0^4 $CellContext`fp2 $CellContext`\[CapitalOmega] + \
$CellContext`a0^3 ((-210) $CellContext`a1 $CellContext`fp2 + 
         352 $CellContext`hp2 $CellContext`\[CapitalOmega]^2) + \
$CellContext`a0 (330 $CellContext`a1^2 $CellContext`hp2 - 
         858 $CellContext`h2^2 $CellContext`hp2 - 60 $CellContext`hp6 - 
         572 $CellContext`fp2 $CellContext`h2 $CellContext`p2 - 
         286 $CellContext`hp2 $CellContext`p2^2 + 
         955 $CellContext`hp2 $CellContext`T3 $CellContext`\[CapitalOmega] + 
         207 $CellContext`h2 $CellContext`tp3 $CellContext`\[CapitalOmega] + 
         690 $CellContext`a1 $CellContext`fp2 $CellContext`\[CapitalOmega]^2 - 
         192 $CellContext`hp2 $CellContext`\[CapitalOmega]^4) + \
$CellContext`a0^2 ((-460) $CellContext`p2 $CellContext`tp3 + 
         660 $CellContext`a1 $CellContext`hp2 $CellContext`\[CapitalOmega] - 
         92 $CellContext`fp2 (5 $CellContext`T3 - 
          4 $CellContext`\[CapitalOmega]^3)) + 
       5 (180 $CellContext`fp7 + 
         69 $CellContext`a1^2 $CellContext`fp2 $CellContext`\[CapitalOmega] + 
         6 $CellContext`a1 (11 $CellContext`hp2 $CellContext`T3 + 
           11 $CellContext`h2 $CellContext`tp3 - 
           8 $CellContext`hp2 $CellContext`\[CapitalOmega]^3) - $CellContext`\
\[CapitalOmega] (66 $CellContext`h2 $CellContext`hp2 $CellContext`p2 - 
          8 $CellContext`p2 $CellContext`tp3 $CellContext`\[CapitalOmega] + \
$CellContext`fp2 (60 $CellContext`h2^2 + 126 $CellContext`p2^2 - 
            99 $CellContext`T3 $CellContext`\[CapitalOmega] + 
            8 $CellContext`\[CapitalOmega]^4))))}, 5, 6, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      FractionBox["2", "15"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"315", " ", "ap7"}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["a0", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}], " ", "\[CapitalOmega]"}], "+", 
        RowBox[{
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"25", " ", "a1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h2", " ", "hp2"}], "+", 
              RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
           RowBox[{"18", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"fp2", " ", "h2"}], "-", 
              RowBox[{"hp2", " ", "p2"}]}], ")"}], " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"25", " ", 
            SuperscriptBox["h2", "2"], " ", "tp3"}], "+", 
           RowBox[{"p2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"50", " ", "fp2", " ", "T3"}], "+", 
              RowBox[{"25", " ", "p2", " ", "tp3"}], "-", 
              RowBox[{"25", " ", "a1", " ", "hp2", " ", "\[CapitalOmega]"}], 
              "-", 
              RowBox[{"22", " ", "fp2", " ", 
               SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}], "+", 
           RowBox[{"h2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"50", " ", "hp2", " ", "T3"}], "+", 
              RowBox[{"25", " ", "a1", " ", "fp2", " ", "\[CapitalOmega]"}], 
              "-", 
              RowBox[{"22", " ", "hp2", " ", 
               SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}]}], ")"}]}],
         "-", 
        RowBox[{"\[CapitalOmega]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"fp2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "25"}], " ", "h2", " ", "T3"}], "+", 
              RowBox[{"46", " ", "a1", " ", "p2", " ", "\[CapitalOmega]"}], 
              "+", 
              RowBox[{"8", " ", "h2", " ", 
               SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}], "+", 
           RowBox[{"hp2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"25", " ", "p2", " ", "T3"}], "+", 
              RowBox[{"46", " ", "a1", " ", "h2", " ", "\[CapitalOmega]"}], 
              "-", 
              RowBox[{"8", " ", "p2", " ", 
               SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}], " ", 
      SuperscriptBox["z", "5"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "6"],
      SeriesData[$CellContext`z, 0, {}, 5, 6, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Rational[2, 15] (315 $CellContext`ap7 + 
       12 $CellContext`a0^3 ($CellContext`h2 $CellContext`hp2 + \
$CellContext`fp2 $CellContext`p2) $CellContext`\[CapitalOmega] + \
$CellContext`a0^2 (
         25 $CellContext`a1 ($CellContext`h2 $CellContext`hp2 + \
$CellContext`fp2 $CellContext`p2) + 
         18 ($CellContext`fp2 $CellContext`h2 - $CellContext`hp2 \
$CellContext`p2) $CellContext`\[CapitalOmega]^2) + $CellContext`a0 (
         25 $CellContext`h2^2 $CellContext`tp3 + $CellContext`p2 (
           50 $CellContext`fp2 $CellContext`T3 + 
           25 $CellContext`p2 $CellContext`tp3 - 
           25 $CellContext`a1 $CellContext`hp2 $CellContext`\[CapitalOmega] - 
           22 $CellContext`fp2 $CellContext`\[CapitalOmega]^3) + \
$CellContext`h2 (50 $CellContext`hp2 $CellContext`T3 + 
           25 $CellContext`a1 $CellContext`fp2 $CellContext`\[CapitalOmega] - 
           22 $CellContext`hp2 $CellContext`\[CapitalOmega]^3)) - \
$CellContext`\[CapitalOmega] ($CellContext`fp2 ((-25) $CellContext`h2 \
$CellContext`T3 + 
          46 $CellContext`a1 $CellContext`p2 $CellContext`\[CapitalOmega] + 
          8 $CellContext`h2 $CellContext`\[CapitalOmega]^3) + \
$CellContext`hp2 (25 $CellContext`p2 $CellContext`T3 + 
          46 $CellContext`a1 $CellContext`h2 $CellContext`\[CapitalOmega] - 
          8 $CellContext`p2 $CellContext`\[CapitalOmega]^3)))}, 5, 6, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       FractionBox["2", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "63"}], " ", "sp7"}], "+", 
         RowBox[{"10", " ", "h2", " ", "hp2", " ", "T3"}], "+", 
         RowBox[{"10", " ", "fp2", " ", "p2", " ", "T3"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["h2", "2"], " ", "tp3"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["p2", "2"], " ", "tp3"}], "+", 
         RowBox[{"a1", " ", "fp2", " ", "h2", " ", "\[CapitalOmega]"}], "-", 
         RowBox[{"a1", " ", "hp2", " ", "p2", " ", "\[CapitalOmega]"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"h2", " ", "hp2"}], "+", 
            RowBox[{"fp2", " ", "p2"}]}], ")"}], " ", "\[CapitalOmega]"}], 
         "-", 
         RowBox[{"5", " ", "h2", " ", "hp2", " ", 
          SuperscriptBox["\[CapitalOmega]", "3"]}], "-", 
         RowBox[{"5", " ", "fp2", " ", "p2", " ", 
          SuperscriptBox["\[CapitalOmega]", "3"]}], "+", 
         RowBox[{"a0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "a1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"h2", " ", "hp2"}], "+", 
               RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"fp2", " ", "h2"}], "-", 
               RowBox[{"hp2", " ", "p2"}]}], ")"}], " ", 
             SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}]}], ")"}], 
       " ", 
       SuperscriptBox["z", "5"]}]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "6"],
      SeriesData[$CellContext`z, 0, {}, 5, 6, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Rational[-2, 3] ((-63) $CellContext`sp7 + 
       10 $CellContext`h2 $CellContext`hp2 $CellContext`T3 + 
       10 $CellContext`fp2 $CellContext`p2 $CellContext`T3 + 
       5 $CellContext`h2^2 $CellContext`tp3 + 
       5 $CellContext`p2^2 $CellContext`tp3 + $CellContext`a1 \
$CellContext`fp2 $CellContext`h2 $CellContext`\[CapitalOmega] - \
$CellContext`a1 $CellContext`hp2 $CellContext`p2 $CellContext`\[CapitalOmega] + 
       3 $CellContext`a0^2 ($CellContext`h2 $CellContext`hp2 + \
$CellContext`fp2 $CellContext`p2) $CellContext`\[CapitalOmega] - 
       5 $CellContext`h2 $CellContext`hp2 $CellContext`\[CapitalOmega]^3 - 
       5 $CellContext`fp2 $CellContext`p2 $CellContext`\[CapitalOmega]^3 + \
$CellContext`a0 (
         2 $CellContext`a1 ($CellContext`h2 $CellContext`hp2 + \
$CellContext`fp2 $CellContext`p2) + 
         3 ($CellContext`fp2 $CellContext`h2 - $CellContext`hp2 \
$CellContext`p2) $CellContext`\[CapitalOmega]^2))}, 5, 6, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a0", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
        RowBox[{"a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "fp2"}], " ", "h2", " ", "\[CapitalOmega]"}], "+", 
           RowBox[{"hp2", " ", "p2", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
        RowBox[{
         FractionBox["3", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "tp6"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h2", " ", "hp2"}], "+", 
              RowBox[{"fp2", " ", "p2"}]}], ")"}], " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}]}], ")"}], " ", 
      SuperscriptBox["z", "5"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "6"],
      SeriesData[$CellContext`z, 0, {}, 5, 6, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     0, {-$CellContext`a0^2 ($CellContext`h2 $CellContext`hp2 + \
$CellContext`fp2 $CellContext`p2) + $CellContext`a0 (-$CellContext`fp2 \
$CellContext`h2 $CellContext`\[CapitalOmega] + $CellContext`hp2 \
$CellContext`p2 $CellContext`\[CapitalOmega]) + 
      Rational[3, 5] (
        5 $CellContext`tp6 + ($CellContext`h2 $CellContext`hp2 + \
$CellContext`fp2 $CellContext`p2) $CellContext`\[CapitalOmega]^2)}, 5, 6, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      FractionBox["1", "15"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "8"}], " ", 
         SuperscriptBox["a0", "4"], " ", "hp2"}], "+", 
        RowBox[{"15", " ", 
         SuperscriptBox["a1", "2"], " ", "hp2"}], "-", 
        RowBox[{"42", " ", 
         SuperscriptBox["h2", "2"], " ", "hp2"}], "+", 
        RowBox[{"60", " ", "hp6"}], "-", 
        RowBox[{"28", " ", "fp2", " ", "h2", " ", "p2"}], "-", 
        RowBox[{"14", " ", "hp2", " ", 
         SuperscriptBox["p2", "2"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["a0", "3"], " ", "fp2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"35", " ", "hp2", " ", "T3", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"8", " ", "h2", " ", "tp3", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"30", " ", "a1", " ", "fp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}], "-", 
        RowBox[{"8", " ", "hp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "4"]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "a1", " ", "fp2"}], "-", 
           RowBox[{"8", " ", "hp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "35"}], " ", "fp2", " ", "T3"}], "-", 
           RowBox[{"35", " ", "p2", " ", "tp3"}], "+", 
           RowBox[{"60", " ", "a1", " ", "hp2", " ", "\[CapitalOmega]"}], "+", 
           RowBox[{"32", " ", "fp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}]}], ")"}], " ", 
      SuperscriptBox["z", "5"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "6"],
      SeriesData[$CellContext`z, 0, {}, 5, 6, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Rational[1, 15] ((-8) $CellContext`a0^4 $CellContext`hp2 + 
       15 $CellContext`a1^2 $CellContext`hp2 - 
       42 $CellContext`h2^2 $CellContext`hp2 + 60 $CellContext`hp6 - 
       28 $CellContext`fp2 $CellContext`h2 $CellContext`p2 - 
       14 $CellContext`hp2 $CellContext`p2^2 - 
       32 $CellContext`a0^3 $CellContext`fp2 $CellContext`\[CapitalOmega] + 
       35 $CellContext`hp2 $CellContext`T3 $CellContext`\[CapitalOmega] + 
       8 $CellContext`h2 $CellContext`tp3 $CellContext`\[CapitalOmega] + 
       30 $CellContext`a1 $CellContext`fp2 $CellContext`\[CapitalOmega]^2 - 
       8 $CellContext`hp2 $CellContext`\[CapitalOmega]^4 - 
       6 $CellContext`a0^2 (5 $CellContext`a1 $CellContext`fp2 - 
        8 $CellContext`hp2 $CellContext`\[CapitalOmega]^2) + $CellContext`a0 \
((-35) $CellContext`fp2 $CellContext`T3 - 35 $CellContext`p2 $CellContext`tp3 + 
         60 $CellContext`a1 $CellContext`hp2 $CellContext`\[CapitalOmega] + 
         32 $CellContext`fp2 $CellContext`\[CapitalOmega]^3))}, 5, 6, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.538982973428647*^9, 3.5390213836768513`*^9, 
  3.5390216846850357`*^9, 3.539066857435576*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"fp7", "\[Rule]", 
     RowBox[{
      FractionBox["1", "180"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox["a0", "5"], " ", "hp2"}], "+", 
        RowBox[{"40", " ", 
         SuperscriptBox["a0", "4"], " ", "fp2", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"69", " ", 
         SuperscriptBox["a1", "2"], " ", "fp2", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["a0", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "a1", " ", "fp2"}], "-", 
           RowBox[{"5", " ", "hp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"99", " ", "fp2", " ", "T3"}], "+", 
           RowBox[{"99", " ", "p2", " ", "tp3"}], "-", 
           RowBox[{"144", " ", "a1", " ", "hp2", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"80", " ", "fp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}], "-", 
        RowBox[{"6", " ", "a1", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"11", " ", "hp2", " ", "T3"}], "+", 
           RowBox[{"11", " ", "h2", " ", "tp3"}], "-", 
           RowBox[{"8", " ", "hp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "69"}], " ", 
            SuperscriptBox["a1", "2"], " ", "hp2"}], "+", 
           RowBox[{"180", " ", 
            SuperscriptBox["h2", "2"], " ", "hp2"}], "+", 
           RowBox[{"120", " ", "fp2", " ", "h2", " ", "p2"}], "+", 
           RowBox[{"60", " ", "hp2", " ", 
            SuperscriptBox["p2", "2"]}], "-", 
           RowBox[{"198", " ", "hp2", " ", "T3", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"43", " ", "h2", " ", "tp3", " ", "\[CapitalOmega]"}], "-", 
           RowBox[{"144", " ", "a1", " ", "fp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}], "+", 
           RowBox[{"40", " ", "hp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "4"]}]}], ")"}]}], "+", 
        RowBox[{"\[CapitalOmega]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"66", " ", "h2", " ", "hp2", " ", "p2"}], "-", 
           RowBox[{"8", " ", "p2", " ", "tp3", " ", "\[CapitalOmega]"}], "+", 
           
           RowBox[{"fp2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"60", " ", 
               SuperscriptBox["h2", "2"]}], "+", 
              RowBox[{"126", " ", 
               SuperscriptBox["p2", "2"]}], "-", 
              RowBox[{"99", " ", "T3", " ", "\[CapitalOmega]"}], "+", 
              RowBox[{"8", " ", 
               SuperscriptBox["\[CapitalOmega]", "4"]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}], ",", 
    RowBox[{"ap7", "\[Rule]", 
     RowBox[{
      FractionBox["1", "315"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "12"}], " ", 
         SuperscriptBox["a0", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}], " ", "\[CapitalOmega]"}], "-", 
        RowBox[{
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"25", " ", "a1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h2", " ", "hp2"}], "+", 
              RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
           RowBox[{"18", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"fp2", " ", "h2"}], "-", 
              RowBox[{"hp2", " ", "p2"}]}], ")"}], " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}], "-", 
        RowBox[{"a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"25", " ", 
            SuperscriptBox["h2", "2"], " ", "tp3"}], "+", 
           RowBox[{"p2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"50", " ", "fp2", " ", "T3"}], "+", 
              RowBox[{"25", " ", "p2", " ", "tp3"}], "-", 
              RowBox[{"25", " ", "a1", " ", "hp2", " ", "\[CapitalOmega]"}], 
              "-", 
              RowBox[{"22", " ", "fp2", " ", 
               SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}], "+", 
           RowBox[{"h2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"50", " ", "hp2", " ", "T3"}], "+", 
              RowBox[{"25", " ", "a1", " ", "fp2", " ", "\[CapitalOmega]"}], 
              "-", 
              RowBox[{"22", " ", "hp2", " ", 
               SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}]}], ")"}]}],
         "+", 
        RowBox[{"\[CapitalOmega]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"fp2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "25"}], " ", "h2", " ", "T3"}], "+", 
              RowBox[{"46", " ", "a1", " ", "p2", " ", "\[CapitalOmega]"}], 
              "+", 
              RowBox[{"8", " ", "h2", " ", 
               SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}], "+", 
           RowBox[{"hp2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"25", " ", "p2", " ", "T3"}], "+", 
              RowBox[{"46", " ", "a1", " ", "h2", " ", "\[CapitalOmega]"}], 
              "-", 
              RowBox[{"8", " ", "p2", " ", 
               SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}], ",", 
    RowBox[{"sp7", "\[Rule]", 
     RowBox[{
      FractionBox["1", "63"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["h2", "2"], " ", "tp3"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}], " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h2", " ", "hp2"}], "+", 
              RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"fp2", " ", "h2"}], "-", 
              RowBox[{"hp2", " ", "p2"}]}], ")"}], " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"p2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", "fp2", " ", "T3"}], "+", 
           RowBox[{"5", " ", "p2", " ", "tp3"}], "-", 
           RowBox[{"a1", " ", "hp2", " ", "\[CapitalOmega]"}], "-", 
           RowBox[{"5", " ", "fp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}], "+", 
        RowBox[{"h2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", "hp2", " ", "T3"}], "+", 
           RowBox[{"a1", " ", "fp2", " ", "\[CapitalOmega]"}], "-", 
           RowBox[{"5", " ", "hp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}]}], ")"}]}]}], 
    ",", 
    RowBox[{"hp6", "\[Rule]", 
     RowBox[{
      FractionBox["1", "60"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox["a0", "4"], " ", "hp2"}], "-", 
        RowBox[{"15", " ", 
         SuperscriptBox["a1", "2"], " ", "hp2"}], "+", 
        RowBox[{"42", " ", 
         SuperscriptBox["h2", "2"], " ", "hp2"}], "+", 
        RowBox[{"28", " ", "fp2", " ", "h2", " ", "p2"}], "+", 
        RowBox[{"14", " ", "hp2", " ", 
         SuperscriptBox["p2", "2"]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["a0", "3"], " ", "fp2", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"35", " ", "hp2", " ", "T3", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"8", " ", "h2", " ", "tp3", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"30", " ", "a1", " ", "fp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}], "+", 
        RowBox[{"8", " ", "hp2", " ", 
         SuperscriptBox["\[CapitalOmega]", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "a1", " ", "fp2"}], "-", 
           RowBox[{"8", " ", "hp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"35", " ", "fp2", " ", "T3"}], "+", 
           RowBox[{"35", " ", "p2", " ", "tp3"}], "-", 
           RowBox[{"60", " ", "a1", " ", "hp2", " ", "\[CapitalOmega]"}], "-", 
           RowBox[{"32", " ", "fp2", " ", 
            SuperscriptBox["\[CapitalOmega]", "3"]}]}], ")"}]}]}], ")"}]}]}], 
    ",", 
    RowBox[{"tp6", "\[Rule]", 
     RowBox[{
      FractionBox["1", "15"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}]}], "+", 
        RowBox[{"5", " ", "a0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"fp2", " ", "h2"}], "-", 
           RowBox[{"hp2", " ", "p2"}]}], ")"}], " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h2", " ", "hp2"}], "+", 
           RowBox[{"fp2", " ", "p2"}]}], ")"}], " ", 
         SuperscriptBox["\[CapitalOmega]", "2"]}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538982973428647*^9, 3.5390213836768513`*^9, 
  3.5390216846850357`*^9, 3.5390668575636*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"f", ",", "h", ",", "a", ",", "t", ",", "s"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", 
  RowBox[{"fp", ",", "hp", ",", "ap", ",", "tp", ",", "sp"}], "]"}]}], "Input",\

 CellChangeTimes->{{3.5389831508293447`*^9, 3.5389831659125013`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Horiz", "Subsubtitle",
 CellChangeTimes->{{3.538981626811451*^9, 3.538981641587184*^9}, {
  3.538983178207532*^9, 3.538983178670436*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"replhoriz", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538983255176206*^9, 3.538983256108687*^9}, {
  3.5390668864217653`*^9, 3.539066887972536*^9}}],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"f0", "+", 
     RowBox[{"f1", 
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
     RowBox[{"f2", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
     RowBox[{"f3", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
     RowBox[{"f4", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"h", "[", "z_", "]"}]}]}], ":=", 
    RowBox[{
     RowBox[{"h0", "+", 
      RowBox[{"h1", 
       RowBox[{"(", 
        RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
      RowBox[{"h2", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
      RowBox[{"h3", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
      RowBox[{"h4", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"a", "[", "z_", "]"}]}]}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"a1", 
        RowBox[{"(", 
         RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
       RowBox[{"a2", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
       RowBox[{"a3", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
       RowBox[{"a4", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"t", "[", "z_", "]"}]}]}], ":=", 
      RowBox[{
       RowBox[{
        RowBox[{"t1", 
         RowBox[{"(", 
          RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
        RowBox[{"t2", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
        RowBox[{"t3", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
        RowBox[{"t4", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}], "\[IndentingNewLine]",
          "\[IndentingNewLine]", 
         RowBox[{"s", "[", "z_", "]"}]}]}], ":=", 
       RowBox[{"s0", "+", 
        RowBox[{"s1", 
         RowBox[{"(", 
          RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
        RowBox[{"s2", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
        RowBox[{"s3", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
        RowBox[{"s4", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}]}]}]}]}]}]}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.538983350296534*^9, 3.5389834150025806`*^9}, {
  3.5389835682987823`*^9, 3.538983598790477*^9}, {3.539066469199864*^9, 
  3.5390664722757397`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"p0", "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "p0"}], "+", 
          RowBox[{"a1", " ", "h0", " ", 
           SuperscriptBox["z0", "2"]}]}], ")"}]}], 
       RowBox[{"t1", " ", 
        SuperscriptBox["z0", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["p0", "3"]}], "+", 
          RowBox[{"4", " ", "p0", " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["h0", "2"]}], "-", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "-", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"a1", " ", "h0", " ", 
           SuperscriptBox["z0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"28", "-", 
             RowBox[{"8", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["t1", "2"], " ", 
        SuperscriptBox["z0", "4"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"36", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "6"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "24"}], " ", 
          SuperscriptBox["p0", "5"]}], "-", 
         RowBox[{"24", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"3", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
         RowBox[{"3", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "16"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "296"}], "-", 
            RowBox[{"24", " ", 
             SuperscriptBox["h0", "4"]}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"78", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               RowBox[{"t1", " ", "z0"}]}], ")"}]}], "-", 
            RowBox[{"36", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "108"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"11", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"2304", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1152", " ", 
          SuperscriptBox["p0", "7"]}], "+", 
         RowBox[{"1728", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["p0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"85", "+", 
            RowBox[{"18", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"24", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2352", "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["h0", "4"]}], "-", 
            RowBox[{"1728", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"32", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}]}], ")"}]}]}], ")"}]}], 
         "-", 
         RowBox[{"6", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3664"}], "-", 
            RowBox[{"576", " ", 
             SuperscriptBox["h0", "2"]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"21", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"96", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{"40960", "+", 
            RowBox[{"1152", " ", 
             SuperscriptBox["h0", "6"]}], "-", 
            RowBox[{"4608", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"12720", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"3672", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"27", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"192", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}]}], ")"}]}], "-", 
            RowBox[{"3456", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"384", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "148"}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"24", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "-", 
               RowBox[{"1728", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"288", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"23584", "+", 
            RowBox[{"864", " ", 
             SuperscriptBox["h0", "4"]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"5520", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"30", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"432", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"288", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"108", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"3664", "-", 
               RowBox[{"96", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"21", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"96", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"57600", " ", 
         SuperscriptBox["t1", "5"], " ", 
         SuperscriptBox["z0", "10"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"23040", " ", 
          SuperscriptBox["p0", "9"]}], "+", 
         RowBox[{"2304", " ", 
          SuperscriptBox["p0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"193", "+", 
            RowBox[{"40", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
         RowBox[{"96", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "6"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"308", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["p0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"80860", "+", 
            RowBox[{"4320", " ", 
             SuperscriptBox["h0", "4"]}], "-", 
            RowBox[{"51000", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"354", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"75", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"216", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "193"}], "+", 
               RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}]}], ")"}]}], 
         "-", 
         RowBox[{"12", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "44576"}], "+", 
            RowBox[{"14400", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"432", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"24", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2472064", "+", 
            RowBox[{"46080", " ", 
             SuperscriptBox["h0", "6"]}], "+", 
            RowBox[{"1036800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"115200", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"23856", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"6216", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"2235", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"3456", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "193"}], "+", 
               RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"80860", "-", 
               RowBox[{"51000", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"7200", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"354", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"1200", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2352", "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"6", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "413408"}], "-", 
            RowBox[{"19536", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"6614", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"75", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"4800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "44576"}], "+", 
               RowBox[{"14400", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"432", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"100", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3664"}], "+", 
               RowBox[{"96", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"21", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "p0", " ", 
          RowBox[{"(", 
           RowBox[{"1177600", "+", 
            RowBox[{"11520", " ", 
             SuperscriptBox["h0", "8"]}], "-", 
            RowBox[{"253712", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"258312", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"6993", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "193"}], "+", 
               RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"80860", "-", 
               RowBox[{"51000", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"7200", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"354", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"9600", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "148"}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"50", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "40960"}], "+", 
               RowBox[{"12720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3672", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2472064", "+", 
               RowBox[{"1036800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"115200", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"23856", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"6216", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"2235", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"1200", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "-", 
                  RowBox[{"32", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "96"}], " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "44576"}], "+", 
               RowBox[{"14400", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"432", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "511616"}], "-", 
               RowBox[{"240464", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"11520", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1296", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"159", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"5760", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"28", "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"5760", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"108", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"80", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "11792"}], "-", 
                  RowBox[{"2760", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "413408"}], "-", 
               RowBox[{"19536", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"6614", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3664"}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"21", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"4147200", " ", 
         SuperscriptBox["t1", "6"], " ", 
         SuperscriptBox["z0", "12"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1382400", " ", 
          SuperscriptBox["p0", "11"]}], "+", 
         RowBox[{"46080", " ", 
          SuperscriptBox["p0", "9"], " ", 
          RowBox[{"(", 
           RowBox[{"731", "+", 
            RowBox[{"150", " ", 
             SuperscriptBox["h0", "2"]}], "-", 
            RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
         RowBox[{"9216", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "8"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"178", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4608", " ", 
          SuperscriptBox["p0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"60521", "+", 
            RowBox[{"3000", " ", 
             SuperscriptBox["h0", "4"]}], "-", 
            RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"4500", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"383", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"50", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"40", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}]}], ")"}]}], 
         "-", 
         RowBox[{"1152", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "6"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "32684"}], "-", 
            RowBox[{"882", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"45", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"32", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"30", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"288", " ", 
          SuperscriptBox["p0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"3218720", "+", 
            RowBox[{"48000", " ", 
             SuperscriptBox["h0", "6"]}], "+", 
            RowBox[{"1020000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"96000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"64496", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"13756", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"125", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"960", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"60521", "-", 
               RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"383", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"50", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "80860"}], "-", 
               RowBox[{"354", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"36", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "4"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"7514816", "+", 
            RowBox[{"864000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"378208", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"36984", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1785", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1536", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"120", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "44576"}], "-", 
               RowBox[{"432", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32684"}], "-", 
               RowBox[{"882", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"30", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"308", "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"36", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["p0", "2"], " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "18272128"}], "-", 
            RowBox[{"3170720", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"579960", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"16350", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"45", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"96000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1024", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"3000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3664"}], "+", 
               RowBox[{"96", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"21", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"60", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "413408"}], "-", 
               RowBox[{"19536", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"6614", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32684"}], "-", 
               RowBox[{"882", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"30", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"308", "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"7514816", "+", 
               RowBox[{"864000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"378208", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"36984", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1785", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "44576"}], "-", 
                  RowBox[{"432", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["p0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"193580032", "+", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["h0", "8"]}], "-", 
            RowBox[{"41472000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"6178176", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3456000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"4416240", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"677328", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"13725", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"30720", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"2304", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"60521", "-", 
               RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"383", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"50", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"72000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"120", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2472064", "-", 
               RowBox[{"23856", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"6216", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"2235", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3218720"}], "-", 
               RowBox[{"1020000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"96000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"64496", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13756", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"125", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"40", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "80860"}], "-", 
                  RowBox[{"354", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"75", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"3", " ", "a1", " ", "h0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "133539840"}], "-", 
            RowBox[{"110648384", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"1382400", " ", 
             SuperscriptBox["t1", "5"], " ", 
             SuperscriptBox["z0", "5"]}], "-", 
            RowBox[{"1007184", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"319524", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1125", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"864000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"3072", " ", 
             SuperscriptBox["h0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"108", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "11792"}], "-", 
               RowBox[{"2760", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"600", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "511616"}], "-", 
               RowBox[{"240464", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1296", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"159", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"384", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32684"}], "-", 
               RowBox[{"882", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"30", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"308", "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"7514816", "+", 
               RowBox[{"864000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"378208", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"36984", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1785", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "44576"}], "-", 
                  RowBox[{"432", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"18272128", "+", 
               RowBox[{"3170720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"579960", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"16350", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"96000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3664"}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"21", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "413408"}], "-", 
                  RowBox[{"19536", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"6614", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"75", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"2", " ", "p0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"691200", " ", 
             SuperscriptBox["h0", "10"]}], "-", 
            RowBox[{"23040", " ", 
             SuperscriptBox["h0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"2304", " ", 
             SuperscriptBox["h0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"60521", "-", 
               RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"383", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"50", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"144", " ", 
             SuperscriptBox["h0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3218720"}], "-", 
               RowBox[{"1020000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"96000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"64496", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13756", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"125", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"40", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "80860"}], "-", 
                  RowBox[{"354", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"75", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"193580032", "-", 
               RowBox[{"41472000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"6178176", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3456000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"4416240", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"677328", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"13725", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"72000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "-", 
                  RowBox[{"32", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2472064", "-", 
                  RowBox[{"23856", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"6216", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"2235", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "51673600"}], "+", 
               RowBox[{"196512", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1036800", " ", 
                SuperscriptBox["t1", "5"], " ", 
                SuperscriptBox["z0", "5"]}], "+", 
               RowBox[{"19930272", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1292418", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"4095", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"1296000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "8"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"288000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "148"}], "+", 
                  RowBox[{"39", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"2250", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "40960"}], "+", 
                  RowBox[{"12720", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3672", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"27", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}], "-", 
               RowBox[{"90", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1177600"}], "+", 
                  RowBox[{"253712", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"258312", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"6993", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"h0", "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "h0"}], "+", 
          RowBox[{"a1", " ", "p0", " ", 
           SuperscriptBox["z0", "2"]}]}], ")"}]}], 
       RowBox[{"t1", " ", 
        SuperscriptBox["z0", "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["h0", "3"]}], "+", 
          RowBox[{"4", " ", "h0", " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["p0", "2"]}], "-", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "-", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
          RowBox[{"a1", " ", "p0", " ", 
           SuperscriptBox["z0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"28", "-", 
             RowBox[{"8", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox["t1", "2"], " ", 
        SuperscriptBox["z0", "4"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"36", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "6"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "24"}], " ", 
          SuperscriptBox["h0", "5"]}], "-", 
         RowBox[{"24", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"3", " ", "t1", " ", "z0"}]}], ")"}]}], "-", 
         RowBox[{"3", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "16"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"h0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "296"}], "-", 
            RowBox[{"24", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"78", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               RowBox[{"t1", " ", "z0"}]}], ")"}]}], "-", 
            RowBox[{"36", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", "a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"108", "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"11", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"16", "-", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"3", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"2304", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1152", " ", 
          SuperscriptBox["h0", "7"]}], "-", 
         RowBox[{"1728", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"]}], "+", 
         RowBox[{"192", " ", 
          SuperscriptBox["h0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"85", "+", 
            RowBox[{"18", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"24", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2352", "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"1728", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"288", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"32", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{"6", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3664"}], "-", 
            RowBox[{"576", " ", 
             SuperscriptBox["p0", "2"]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"21", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"96", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"h0", " ", 
          RowBox[{"(", 
           RowBox[{"40960", "+", 
            RowBox[{"1152", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"4608", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"12720", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"3672", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"27", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"192", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "85"}], "+", 
               RowBox[{"24", " ", "t1", " ", "z0"}]}], ")"}]}], "-", 
            RowBox[{"3456", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"384", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "148"}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"24", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "-", 
               RowBox[{"1728", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"288", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "864"}], " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3664"}], "+", 
               RowBox[{"96", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"21", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"96", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "11792"}], "+", 
               RowBox[{"576", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"2760", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"216", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"28", "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"144", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"108", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"57600", " ", 
         SuperscriptBox["t1", "5"], " ", 
         SuperscriptBox["z0", "10"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"23040", " ", 
          SuperscriptBox["h0", "9"]}], "+", 
         RowBox[{"2304", " ", 
          SuperscriptBox["h0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"193", "+", 
            RowBox[{"40", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}], "-", 
         RowBox[{"96", " ", "a1", " ", 
          SuperscriptBox["h0", "6"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"308", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["h0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"80860", "+", 
            RowBox[{"4320", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"51000", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"354", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"75", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"216", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "193"}], "+", 
               RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{"12", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "44576"}], "+", 
            RowBox[{"14400", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"432", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"24", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"2472064", "+", 
            RowBox[{"46080", " ", 
             SuperscriptBox["p0", "6"]}], "+", 
            RowBox[{"1036800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"115200", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"23856", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"6216", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"2235", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"3456", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "193"}], "+", 
               RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"80860", "-", 
               RowBox[{"51000", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"7200", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"354", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"1200", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2352", "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"6", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "413408"}], "-", 
            RowBox[{"19536", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"6614", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"75", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"4800", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "44576"}], "+", 
               RowBox[{"14400", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"432", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"100", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3664"}], "+", 
               RowBox[{"96", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"21", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "h0", " ", 
          RowBox[{"(", 
           RowBox[{"1177600", "+", 
            RowBox[{"11520", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"253712", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"258312", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"6993", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"1152", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "193"}], "+", 
               RowBox[{"50", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"80860", "-", 
               RowBox[{"51000", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"7200", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"354", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"9600", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "148"}], "+", 
               RowBox[{"39", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"50", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "40960"}], "+", 
               RowBox[{"12720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3672", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"27", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2472064", "+", 
               RowBox[{"1036800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"115200", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"23856", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"6216", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"2235", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"1200", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "-", 
                  RowBox[{"32", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "44576"}], "+", 
               RowBox[{"14400", " ", "t1", " ", "z0"}], "-", 
               RowBox[{"432", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"511616", "+", 
               RowBox[{"240464", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"11520", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"1296", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"159", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"5760", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"28", "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"5760", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"108", "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"80", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "11792"}], "-", 
                  RowBox[{"2760", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"6", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "413408"}], "-", 
               RowBox[{"19536", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"6614", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"4800", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"100", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3664"}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"21", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"4147200", " ", 
         SuperscriptBox["t1", "6"], " ", 
         SuperscriptBox["z0", "12"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1382400", " ", 
          SuperscriptBox["h0", "11"]}], "+", 
         RowBox[{"46080", " ", 
          SuperscriptBox["h0", "9"], " ", 
          RowBox[{"(", 
           RowBox[{"731", "+", 
            RowBox[{"150", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "-", 
         RowBox[{"9216", " ", "a1", " ", 
          SuperscriptBox["h0", "8"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"178", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4608", " ", 
          SuperscriptBox["h0", "7"], " ", 
          RowBox[{"(", 
           RowBox[{"60521", "+", 
            RowBox[{"3000", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"4500", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"383", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"50", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"40", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{"1152", " ", "a1", " ", 
          SuperscriptBox["h0", "6"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "32684"}], "-", 
            RowBox[{"882", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"45", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"32", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"30", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"308", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"288", " ", 
          SuperscriptBox["h0", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"3218720", "+", 
            RowBox[{"48000", " ", 
             SuperscriptBox["p0", "6"]}], "+", 
            RowBox[{"1020000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"96000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"64496", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"13756", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"125", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"960", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"60521", "-", 
               RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"383", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"50", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "80860"}], "-", 
               RowBox[{"354", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"36", " ", "a1", " ", 
          SuperscriptBox["h0", "4"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"7514816", "+", 
            RowBox[{"864000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"378208", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"36984", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1785", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1536", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"120", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "44576"}], "-", 
               RowBox[{"432", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32684"}], "-", 
               RowBox[{"882", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"30", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"308", "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"36", " ", "a1", " ", 
          SuperscriptBox["h0", "2"], " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "18272128"}], "-", 
            RowBox[{"3170720", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"579960", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"16350", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"45", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"96000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "16"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"1024", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"3000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3664"}], "+", 
               RowBox[{"96", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"21", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"60", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "413408"}], "-", 
               RowBox[{"19536", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"6614", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"75", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32684"}], "-", 
               RowBox[{"882", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"30", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"308", "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"7514816", "+", 
               RowBox[{"864000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"378208", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"36984", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1785", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "44576"}], "-", 
                  RowBox[{"432", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["h0", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"193580032", "+", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"41472000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"6178176", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3456000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"4416240", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"677328", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"13725", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"30720", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"2304", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"60521", "-", 
               RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"383", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"50", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"72000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"2352", "-", 
               RowBox[{"32", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"120", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"2472064", "-", 
               RowBox[{"23856", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"6216", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"2235", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3218720"}], "-", 
               RowBox[{"1020000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"96000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"64496", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13756", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"125", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"40", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "80860"}], "-", 
                  RowBox[{"354", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"75", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"3", " ", "a1", " ", "p0", " ", 
          SuperscriptBox["z0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "133539840"}], "-", 
            RowBox[{"110648384", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"1382400", " ", 
             SuperscriptBox["t1", "5"], " ", 
             SuperscriptBox["z0", "5"]}], "-", 
            RowBox[{"1007184", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"319524", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1125", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"864000", " ", 
             SuperscriptBox["t1", "4"], " ", 
             SuperscriptBox["z0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"28", "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"3072", " ", 
             SuperscriptBox["p0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{"178", "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"1152000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"108", "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "11792"}], "-", 
               RowBox[{"2760", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"600", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "511616"}], "-", 
               RowBox[{"240464", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1296", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"159", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"384", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32684"}], "-", 
               RowBox[{"882", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"30", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"308", "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"7514816", "+", 
               RowBox[{"864000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"378208", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"36984", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1785", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "44576"}], "-", 
                  RowBox[{"432", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"18272128", "+", 
               RowBox[{"3170720", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"579960", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"16350", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"45", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"96000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "16"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"3000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3664"}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"21", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"60", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "413408"}], "-", 
                  RowBox[{"19536", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"6614", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"75", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"2", " ", "h0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"691200", " ", 
             SuperscriptBox["p0", "10"]}], "-", 
            RowBox[{"23040", " ", 
             SuperscriptBox["p0", "8"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "731"}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0"}]}], ")"}]}], "+", 
            RowBox[{"2304", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{"60521", "-", 
               RowBox[{"34740", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"4500", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"383", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"50", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"144", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3218720"}], "-", 
               RowBox[{"1020000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"96000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "-", 
               RowBox[{"64496", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"13756", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"125", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "-", 
               RowBox[{"40", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "80860"}], "-", 
                  RowBox[{"354", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"75", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"193580032", "-", 
               RowBox[{"41472000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"6178176", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3456000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"4416240", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"677328", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"13725", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"72000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"2352", "-", 
                  RowBox[{"32", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
               RowBox[{"120", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"2472064", "-", 
                  RowBox[{"23856", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"6216", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"2235", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "51673600"}], "+", 
               RowBox[{"196512", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1036800", " ", 
                SuperscriptBox["t1", "5"], " ", 
                SuperscriptBox["z0", "5"]}], "+", 
               RowBox[{"19930272", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1292418", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"4095", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"1296000", " ", 
                SuperscriptBox["t1", "4"], " ", 
                SuperscriptBox["z0", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "8"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
               RowBox[{"288000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "148"}], "+", 
                  RowBox[{"39", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"2250", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "40960"}], "+", 
                  RowBox[{"12720", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3672", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"27", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}], "-", 
               RowBox[{"90", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1177600"}], "+", 
                  RowBox[{"253712", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"258312", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"6993", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"a1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}]}], "+", 
      FractionBox[
       RowBox[{"a1", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "12"}], "+", 
          RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
          RowBox[{
           SuperscriptBox["a1", "2"], " ", 
           SuperscriptBox["z0", "4"]}]}], ")"}]}], 
       RowBox[{"4", " ", "t1", " ", 
        SuperscriptBox["z0", "2"]}]], "+", 
      FractionBox[
       RowBox[{"a1", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SuperscriptBox["h0", "4"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["p0", "4"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["h0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"28", "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["p0", "2"]}], "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "12"}], "+", 
              RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}], "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["p0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "28"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"48", " ", 
        SuperscriptBox["t1", "2"], " ", 
        SuperscriptBox["z0", "4"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"192", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "6"]}]], "a1", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "64"}], " ", 
          SuperscriptBox["h0", "6"]}], "-", 
         RowBox[{"64", " ", 
          SuperscriptBox["p0", "6"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"52", "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"12", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "3"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "52"}], "+", 
            RowBox[{"12", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1712", "-", 
            RowBox[{"272", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"24", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "28"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1712", "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["p0", "4"]}], "-", 
            RowBox[{"672", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"272", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"16", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "52"}], "+", 
               RowBox[{"12", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"3840", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}]], "a1", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1280", " ", 
          SuperscriptBox["h0", "8"]}], "+", 
         RowBox[{"1280", " ", 
          SuperscriptBox["p0", "8"]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"704", "+", 
            RowBox[{"160", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"160", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"35", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "4"]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "704"}], "+", 
            RowBox[{"160", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"35", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"34544", "+", 
            RowBox[{"1920", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"3936", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"129", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"320", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "52"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"34544", "+", 
            RowBox[{"1920", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"1920", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"3936", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"129", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"320", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "52"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"24", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "704"}], "+", 
               RowBox[{"160", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "176768"}], "+", 
            RowBox[{"37808", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"2544", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"63", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"960", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "28"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"80", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1712", "-", 
               RowBox[{"272", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"176768", "+", 
            RowBox[{"2560", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"37808", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"2544", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"63", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"960", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "28"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "704"}], "+", 
               RowBox[{"160", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"80", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"1712", "-", 
               RowBox[{"272", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"34544", "+", 
               RowBox[{"1920", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"3936", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"129", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"320", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "52"}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"691200", " ", 
         SuperscriptBox["t1", "5"], " ", 
         SuperscriptBox["z0", "10"]}]], "a1", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "230400"}], " ", 
          SuperscriptBox["h0", "10"]}], "-", 
         RowBox[{"230400", " ", 
          SuperscriptBox["p0", "10"]}], "-", 
         RowBox[{"1536", " ", 
          SuperscriptBox["h0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{"3308", "+", 
            RowBox[{"750", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"750", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"145", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"675", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "5"]}], "+", 
         RowBox[{"1536", " ", 
          SuperscriptBox["p0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3308"}], "+", 
            RowBox[{"750", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"145", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"96", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"436032", "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"42436", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"1185", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"300", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "704"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"96", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"436032", "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"24000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"42436", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"1185", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"300", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "704"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"64", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3308"}], "+", 
               RowBox[{"750", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"145", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "39896512"}], "+", 
            RowBox[{"576000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"6689136", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"428964", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"9225", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"144000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "52"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"900", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"34544", "-", 
               RowBox[{"3936", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"129", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"27742208", "-", 
            RowBox[{"7540032", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"773616", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"38412", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"729", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "28"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"7200", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1712", "-", 
               RowBox[{"272", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"180", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "176768"}], "+", 
               RowBox[{"37808", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"2544", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"63", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"39896512", "+", 
            RowBox[{"576000", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"576000", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"6689136", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"428964", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"9225", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"144000", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "52"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"2304", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3308"}], "+", 
               RowBox[{"750", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"145", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"900", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"34544", "-", 
               RowBox[{"3936", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"129", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"72", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"436032", "+", 
               RowBox[{"24000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"42436", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1185", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "704"}], "+", 
                  RowBox[{"35", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"576000", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"3072", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3308"}], "+", 
               RowBox[{"750", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"145", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"144", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"436032", "+", 
               RowBox[{"24000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"42436", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"1185", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"300", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "704"}], "+", 
                  RowBox[{"35", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "39896512"}], "+", 
               RowBox[{"576000", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"6689136", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"428964", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"9225", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"144000", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "52"}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"900", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"34544", "-", 
                  RowBox[{"3936", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"129", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"27742208", "-", 
               RowBox[{"7540032", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"773616", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "-", 
               RowBox[{"38412", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"729", " ", 
                SuperscriptBox["a1", "8"], " ", 
                SuperscriptBox["z0", "16"]}], "+", 
               RowBox[{"57600", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "28"}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"7200", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"1712", "-", 
                  RowBox[{"272", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"9", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
               RowBox[{"180", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "176768"}], "+", 
                  RowBox[{"37808", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "-", 
                  RowBox[{"2544", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}], "+", 
                  RowBox[{"63", " ", 
                   SuperscriptBox["a1", "6"], " ", 
                   SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"t", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"t1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["t1", "z0"]}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a1", "2"], " ", 
           SuperscriptBox["z0", "2"]}], "2"]}], ")"}]}], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
        RowBox[{"(", 
         RowBox[{"144", "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["h0", "4"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["p0", "2"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["p0", "4"]}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["h0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             SuperscriptBox["p0", "2"]}], ")"}]}], "-", 
          RowBox[{"120", " ", 
           SuperscriptBox["a1", "2"], " ", 
           SuperscriptBox["z0", "4"]}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["a1", "4"], " ", 
           SuperscriptBox["z0", "8"]}]}], ")"}]}], 
       RowBox[{"48", " ", "t1", " ", 
        SuperscriptBox["z0", "4"]}]], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"48", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["h0", "6"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["p0", "6"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"t1", " ", "z0"}], "-", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "9"}], "+", 
            RowBox[{"t1", " ", "z0"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "400"}], "+", 
            RowBox[{"64", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"88", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"12", "-", 
            RowBox[{"4", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"13", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "400"}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"64", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"88", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{"t1", " ", "z0"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"3840", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "8"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1280", " ", 
          SuperscriptBox["h0", "8"]}], "+", 
         RowBox[{"1280", " ", 
          SuperscriptBox["p0", "8"]}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{"67", "+", 
            RowBox[{"20", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"10", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"256", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "67"}], "+", 
            RowBox[{"10", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"604", "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"139", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"20", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"604", "+", 
            RowBox[{"60", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"139", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"20", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"6", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "67"}], "+", 
               RowBox[{"10", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"15", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"16", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "12"}], "+", 
                RowBox[{
                 SuperscriptBox["a1", "2"], " ", 
                 SuperscriptBox["z0", "4"]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"32", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"12", "-", 
               RowBox[{"13", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"37120", "+", 
            RowBox[{"1280", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"18032", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"2824", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"99", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"400", "-", 
               RowBox[{"88", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"37120", "+", 
            RowBox[{"1280", " ", 
             SuperscriptBox["p0", "6"]}], "+", 
            RowBox[{"1280", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "-", 
            RowBox[{"18032", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"2824", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"99", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"192", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "67"}], "+", 
               RowBox[{"10", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"40", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"400", "-", 
               RowBox[{"88", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"64", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"604", "+", 
               RowBox[{"10", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "-", 
               RowBox[{"139", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"20", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "9"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"69120", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "10"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"23040", " ", 
          SuperscriptBox["h0", "10"]}], "+", 
         RowBox[{"23040", " ", 
          SuperscriptBox["p0", "10"]}], "+", 
         RowBox[{"768", " ", 
          SuperscriptBox["h0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{"534", "+", 
            RowBox[{"150", " ", 
             SuperscriptBox["p0", "2"]}], "-", 
            RowBox[{"90", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"35", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"768", " ", 
          SuperscriptBox["p0", "8"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "534"}], "+", 
            RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
            RowBox[{"35", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
         RowBox[{"135", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "12"}], "+", 
             RowBox[{"4", " ", "t1", " ", "z0"}], "+", 
             RowBox[{
              SuperscriptBox["a1", "2"], " ", 
              SuperscriptBox["z0", "4"]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"24", "-", 
            RowBox[{"8", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"38", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["a1", "2"], " ", "t1", " ", 
             SuperscriptBox["z0", "5"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
         RowBox[{"1536", " ", 
          SuperscriptBox["p0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"45", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"9", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "67"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"344", "-", 
               RowBox[{"61", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"1536", " ", 
          SuperscriptBox["h0", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"150", " ", 
             SuperscriptBox["p0", "4"]}], "+", 
            RowBox[{"45", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"]}], "+", 
            RowBox[{"9", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "67"}], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "534"}], "+", 
               RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"344", "-", 
               RowBox[{"61", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["p0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "979712"}], "+", 
            RowBox[{"2880", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"377424", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"41376", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"1431", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"8640", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"864", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"604", "-", 
               RowBox[{"139", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "5474560"}], "+", 
            RowBox[{"46080", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "+", 
            RowBox[{"4248192", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "-", 
            RowBox[{"902976", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "+", 
            RowBox[{"62424", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"1539", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"2160", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"400", "-", 
               RowBox[{"88", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
            RowBox[{"108", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "37120"}], "+", 
               RowBox[{"18032", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"2824", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"99", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["h0", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"979712", "+", 
            RowBox[{"28800", " ", 
             SuperscriptBox["p0", "6"]}], "-", 
            RowBox[{"2880", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"377424", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"41376", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"1431", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "-", 
            RowBox[{"8640", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               RowBox[{
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"576", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "534"}], "+", 
               RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
            RowBox[{"864", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{"604", "-", 
               RowBox[{"139", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"576", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"45", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"9", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "67"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"5", " ", 
                RowBox[{"(", 
                 RowBox[{"344", "-", 
                  RowBox[{"61", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5474560", "+", 
            RowBox[{"57600", " ", 
             SuperscriptBox["p0", "8"]}], "-", 
            RowBox[{"46080", " ", 
             SuperscriptBox["t1", "3"], " ", 
             SuperscriptBox["z0", "3"]}], "-", 
            RowBox[{"4248192", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}], "+", 
            RowBox[{"902976", " ", 
             SuperscriptBox["a1", "4"], " ", 
             SuperscriptBox["z0", "8"]}], "-", 
            RowBox[{"62424", " ", 
             SuperscriptBox["a1", "6"], " ", 
             SuperscriptBox["z0", "12"]}], "+", 
            RowBox[{"1539", " ", 
             SuperscriptBox["a1", "8"], " ", 
             SuperscriptBox["z0", "16"]}], "-", 
            RowBox[{"1536", " ", 
             SuperscriptBox["p0", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "534"}], "+", 
               RowBox[{"90", " ", "t1", " ", "z0"}], "+", 
               RowBox[{"35", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
            RowBox[{"2160", " ", 
             SuperscriptBox["t1", "2"], " ", 
             SuperscriptBox["z0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"400", "-", 
               RowBox[{"88", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
            RowBox[{"108", " ", "t1", " ", "z0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "37120"}], "+", 
               RowBox[{"18032", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"2824", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"99", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
            RowBox[{"2304", " ", 
             SuperscriptBox["p0", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"45", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"]}], "+", 
               RowBox[{"9", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "67"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"5", " ", 
                RowBox[{"(", 
                 RowBox[{"344", "-", 
                  RowBox[{"61", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "979712"}], "+", 
               RowBox[{"2880", " ", 
                SuperscriptBox["t1", "3"], " ", 
                SuperscriptBox["z0", "3"]}], "+", 
               RowBox[{"377424", " ", 
                SuperscriptBox["a1", "2"], " ", 
                SuperscriptBox["z0", "4"]}], "-", 
               RowBox[{"41376", " ", 
                SuperscriptBox["a1", "4"], " ", 
                SuperscriptBox["z0", "8"]}], "+", 
               RowBox[{"1431", " ", 
                SuperscriptBox["a1", "6"], " ", 
                SuperscriptBox["z0", "12"]}], "+", 
               RowBox[{"8640", " ", 
                SuperscriptBox["t1", "2"], " ", 
                SuperscriptBox["z0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "9"}], "+", 
                  RowBox[{
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
               RowBox[{"864", " ", "t1", " ", "z0", " ", 
                RowBox[{"(", 
                 RowBox[{"604", "-", 
                  RowBox[{"139", " ", 
                   SuperscriptBox["a1", "2"], " ", 
                   SuperscriptBox["z0", "4"]}], "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["a1", "4"], " ", 
                   SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"s0", "+", 
     FractionBox[
      RowBox[{"s0", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"12", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "2"]}], "-", 
         RowBox[{"4", " ", "t1", " ", "z0"}], "-", 
         RowBox[{
          SuperscriptBox["a1", "2"], " ", 
          SuperscriptBox["z0", "4"]}]}], ")"}]}], 
      RowBox[{"4", " ", "t1", " ", 
       SuperscriptBox["z0", "2"]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h0", "2"], "+", 
         SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["a1", "2"], " ", 
          SuperscriptBox["z0", "4"]}]}], ")"}]}], 
      RowBox[{"4", " ", 
       SuperscriptBox["t1", "2"], " ", 
       SuperscriptBox["z0", "4"]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h0", "2"], "+", 
         SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "z"}], "+", "z0"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["h0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "20"}], "+", 
            RowBox[{"12", " ", "t1", " ", "z0"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{
             SuperscriptBox["a1", "2"], " ", 
             SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{"48", " ", 
       SuperscriptBox["t1", "3"], " ", 
       SuperscriptBox["z0", "6"]}]], "-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"1152", " ", 
        SuperscriptBox["t1", "4"], " ", 
        SuperscriptBox["z0", "8"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h0", "2"], "+", 
        SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{"3200", "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["h0", "4"]}], "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["p0", "4"]}], "-", 
        RowBox[{"3840", " ", "t1", " ", "z0"}], "+", 
        RowBox[{"1152", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "2"]}], "+", 
        RowBox[{"1872", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["z0", "4"]}], "-", 
        RowBox[{"1536", " ", 
         SuperscriptBox["a1", "2"], " ", "t1", " ", 
         SuperscriptBox["z0", "5"]}], "+", 
        RowBox[{"288", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}], "+", 
        RowBox[{"432", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "-", 
        RowBox[{"144", " ", 
         SuperscriptBox["a1", "4"], " ", "t1", " ", 
         SuperscriptBox["z0", "9"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["z0", "12"]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["p0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "44"}], "+", 
           RowBox[{"16", " ", "t1", " ", "z0"}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           RowBox[{
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}]}], ")"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["h0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"32", " ", 
            SuperscriptBox["p0", "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "44"}], "+", 
              RowBox[{"16", " ", "t1", " ", "z0"}], "-", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
     "+", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"23040", " ", 
        SuperscriptBox["t1", "5"], " ", 
        SuperscriptBox["z0", "10"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h0", "2"], "+", 
        SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], "5"], " ", 
      RowBox[{"(", 
       RowBox[{"110080", "+", 
        RowBox[{"2304", " ", 
         SuperscriptBox["h0", "6"]}], "+", 
        RowBox[{"2304", " ", 
         SuperscriptBox["p0", "6"]}], "-", 
        RowBox[{"192000", " ", "t1", " ", "z0"}], "+", 
        RowBox[{"115200", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "2"]}], "-", 
        RowBox[{"23040", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "3"]}], "+", 
        RowBox[{"90880", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["z0", "4"]}], "-", 
        RowBox[{"112320", " ", 
         SuperscriptBox["a1", "2"], " ", "t1", " ", 
         SuperscriptBox["z0", "5"]}], "+", 
        RowBox[{"46080", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}], "-", 
        RowBox[{"5760", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "7"]}], "+", 
        RowBox[{"35184", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "-", 
        RowBox[{"25920", " ", 
         SuperscriptBox["a1", "4"], " ", "t1", " ", 
         SuperscriptBox["z0", "9"]}], "+", 
        RowBox[{"4320", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "10"]}], "+", 
        RowBox[{"2184", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["z0", "12"]}], "-", 
        RowBox[{"540", " ", 
         SuperscriptBox["a1", "6"], " ", "t1", " ", 
         SuperscriptBox["z0", "13"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["a1", "8"], " ", 
         SuperscriptBox["z0", "16"]}], "-", 
        RowBox[{"48", " ", 
         SuperscriptBox["p0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "816"}], "+", 
           RowBox[{"240", " ", "t1", " ", "z0"}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["h0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"816", "+", 
           RowBox[{"144", " ", 
            SuperscriptBox["p0", "2"]}], "-", 
           RowBox[{"240", " ", "t1", " ", "z0"}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
        RowBox[{"12", " ", 
         SuperscriptBox["p0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "12736"}], "+", 
           RowBox[{"208", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"676", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"45", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "+", 
           RowBox[{"480", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"60", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "176"}], "+", 
              RowBox[{"24", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["h0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"12736", "+", 
           RowBox[{"576", " ", 
            SuperscriptBox["p0", "4"]}], "-", 
           RowBox[{"208", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"676", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "-", 
           RowBox[{"45", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"480", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "816"}], "+", 
              RowBox[{"240", " ", "t1", " ", "z0"}], "+", 
              RowBox[{"12", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "-", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"60", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "176"}], "+", 
              RowBox[{"24", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"345600", " ", 
        SuperscriptBox["t1", "6"], " ", 
        SuperscriptBox["z0", "12"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["h0", "2"], "+", 
        SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "z"}], "+", "z0"}], ")"}], "6"], " ", 
      RowBox[{"(", 
       RowBox[{"3033600", "+", 
        RowBox[{"23040", " ", 
         SuperscriptBox["h0", "8"]}], "+", 
        RowBox[{"23040", " ", 
         SuperscriptBox["p0", "8"]}], "-", 
        RowBox[{"6604800", " ", "t1", " ", "z0"}], "+", 
        RowBox[{"5760000", " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "2"]}], "-", 
        RowBox[{"2304000", " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "3"]}], "+", 
        RowBox[{"3436352", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["z0", "4"]}], "+", 
        RowBox[{"345600", " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "4"]}], "-", 
        RowBox[{"5452800", " ", 
         SuperscriptBox["a1", "2"], " ", "t1", " ", 
         SuperscriptBox["z0", "5"]}], "+", 
        RowBox[{"3369600", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "6"]}], "-", 
        RowBox[{"921600", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "7"]}], "+", 
        RowBox[{"1799472", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "+", 
        RowBox[{"86400", " ", 
         SuperscriptBox["a1", "2"], " ", 
         SuperscriptBox["t1", "4"], " ", 
         SuperscriptBox["z0", "8"]}], "-", 
        RowBox[{"2111040", " ", 
         SuperscriptBox["a1", "4"], " ", "t1", " ", 
         SuperscriptBox["z0", "9"]}], "+", 
        RowBox[{"777600", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "10"]}], "-", 
        RowBox[{"86400", " ", 
         SuperscriptBox["a1", "4"], " ", 
         SuperscriptBox["t1", "3"], " ", 
         SuperscriptBox["z0", "11"]}], "+", 
        RowBox[{"228828", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["z0", "12"]}], "-", 
        RowBox[{"131040", " ", 
         SuperscriptBox["a1", "6"], " ", "t1", " ", 
         SuperscriptBox["z0", "13"]}], "+", 
        RowBox[{"16200", " ", 
         SuperscriptBox["a1", "6"], " ", 
         SuperscriptBox["t1", "2"], " ", 
         SuperscriptBox["z0", "14"]}], "+", 
        RowBox[{"3735", " ", 
         SuperscriptBox["a1", "8"], " ", 
         SuperscriptBox["z0", "16"]}], "-", 
        RowBox[{"540", " ", 
         SuperscriptBox["a1", "8"], " ", "t1", " ", 
         SuperscriptBox["z0", "17"]}], "-", 
        RowBox[{"96", " ", 
         SuperscriptBox["p0", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "5464"}], "+", 
           RowBox[{"1440", " ", "t1", " ", "z0"}], "-", 
           RowBox[{"38", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
        RowBox[{"96", " ", 
         SuperscriptBox["h0", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"5464", "+", 
           RowBox[{"960", " ", 
            SuperscriptBox["p0", "2"]}], "-", 
           RowBox[{"1440", " ", "t1", " ", "z0"}], "+", 
           RowBox[{"38", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["p0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"432320", "+", 
           RowBox[{"43200", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"]}], "+", 
           RowBox[{"9576", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"2658", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"585", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"360", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{"816", "-", 
              RowBox[{"12", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["h0", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"432320", "+", 
           RowBox[{"17280", " ", 
            SuperscriptBox["p0", "4"]}], "+", 
           RowBox[{"43200", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"]}], "+", 
           RowBox[{"9576", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "+", 
           RowBox[{"2658", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "+", 
           RowBox[{"585", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"36", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "5464"}], "+", 
              RowBox[{"1440", " ", "t1", " ", "z0"}], "-", 
              RowBox[{"38", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "-", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
           RowBox[{"360", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{"816", "-", 
              RowBox[{"12", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"7", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["p0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"6998016", "+", 
           RowBox[{"1009984", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"480048", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "-", 
           RowBox[{"90804", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"2205", " ", 
            SuperscriptBox["a1", "8"], " ", 
            SuperscriptBox["z0", "16"]}], "+", 
           RowBox[{"115200", " ", 
            SuperscriptBox["t1", "3"], " ", 
            SuperscriptBox["z0", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"21600", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "176"}], "+", 
              RowBox[{"24", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"720", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "12736"}], "+", 
              RowBox[{"208", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"676", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"45", " ", 
               SuperscriptBox["a1", "6"], " ", 
               SuperscriptBox["z0", "12"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["h0", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"6998016", "+", 
           RowBox[{"92160", " ", 
            SuperscriptBox["p0", "6"]}], "+", 
           RowBox[{"1009984", " ", 
            SuperscriptBox["a1", "2"], " ", 
            SuperscriptBox["z0", "4"]}], "-", 
           RowBox[{"480048", " ", 
            SuperscriptBox["a1", "4"], " ", 
            SuperscriptBox["z0", "8"]}], "-", 
           RowBox[{"90804", " ", 
            SuperscriptBox["a1", "6"], " ", 
            SuperscriptBox["z0", "12"]}], "-", 
           RowBox[{"2205", " ", 
            SuperscriptBox["a1", "8"], " ", 
            SuperscriptBox["z0", "16"]}], "+", 
           RowBox[{"115200", " ", 
            SuperscriptBox["t1", "3"], " ", 
            SuperscriptBox["z0", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}]}], ")"}]}], "-", 
           RowBox[{"288", " ", 
            SuperscriptBox["p0", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "5464"}], "+", 
              RowBox[{"1440", " ", "t1", " ", "z0"}], "-", 
              RowBox[{"38", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "-", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "-", 
           RowBox[{"21600", " ", 
            SuperscriptBox["t1", "2"], " ", 
            SuperscriptBox["z0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "176"}], "+", 
              RowBox[{"24", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}]}], ")"}]}], "+", 
           RowBox[{"720", " ", "t1", " ", "z0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "12736"}], "+", 
              RowBox[{"208", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"676", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"45", " ", 
               SuperscriptBox["a1", "6"], " ", 
               SuperscriptBox["z0", "12"]}]}], ")"}]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["p0", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"432320", "+", 
              RowBox[{"43200", " ", 
               SuperscriptBox["t1", "2"], " ", 
               SuperscriptBox["z0", "2"]}], "+", 
              RowBox[{"9576", " ", 
               SuperscriptBox["a1", "2"], " ", 
               SuperscriptBox["z0", "4"]}], "+", 
              RowBox[{"2658", " ", 
               SuperscriptBox["a1", "4"], " ", 
               SuperscriptBox["z0", "8"]}], "+", 
              RowBox[{"585", " ", 
               SuperscriptBox["a1", "6"], " ", 
               SuperscriptBox["z0", "12"]}], "-", 
              RowBox[{"360", " ", "t1", " ", "z0", " ", 
               RowBox[{"(", 
                RowBox[{"816", "-", 
                 RowBox[{"12", " ", 
                  SuperscriptBox["a1", "2"], " ", 
                  SuperscriptBox["z0", "4"]}], "+", 
                 RowBox[{"7", " ", 
                  SuperscriptBox["a1", "4"], " ", 
                  SuperscriptBox["z0", "8"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}], "//.", "replhoriz"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5384640040309467`*^9, 3.5384640865225697`*^9}, {
  3.538464329491736*^9, 3.538464352894101*^9}, {3.538983230261441*^9, 
  3.5389832457494802`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"z0", "=", "1"}], ";"}]], "Input",
 CellChangeTimes->{{3.5390194684973803`*^9, 3.539019469210075*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fp", "[", "z_", "]"}], ":=", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["f", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"hp", "[", "z_", "]"}], ":=", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["h", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ap", "[", "z_", "]"}], ":=", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["a", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"tp", "[", "z_", "]"}], ":=", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", "\[CapitalOmega]"}], "-", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"t", "[", "z", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["t", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "z"}], " ", 
     RowBox[{"s", "[", "z", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["s", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}]}]}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"fp", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "z0", ",", "0"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"hp", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "z0", ",", "0"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"ap", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "z0", ",", "0"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"tp", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "z0", ",", "0"}], "}"}]}], "]"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"sp", "[", "z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "z0", ",", "0"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.539066381856297*^9, 3.539066422868949*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a1", " ", "h0"}], "+", 
     RowBox[{"2", " ", "p0"}]}], "t1"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`z, 1, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   1, {($CellContext`a1 $CellContext`h0 + 2 $CellContext`p0)/$CellContext`t1},
    0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.539066390199188*^9, 3.539066423339196*^9}, 
   3.539066893117815*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "h0"}], "-", 
     RowBox[{"a1", " ", "p0"}]}], "t1"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`z, 1, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   1, {(2 $CellContext`h0 - $CellContext`a1 $CellContext`p0)/$CellContext`t1},
    0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.539066390199188*^9, 3.539066423339196*^9}, 
   3.5390668931195917`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "a1"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`z, 1, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 1, {-$CellContext`a1}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.539066390199188*^9, 3.539066423339196*^9}, 
   3.539066893120915*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "t1"}], "+", 
     RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`z, 1, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   1, {-$CellContext`t1 + 2 $CellContext`\[CapitalOmega]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.539066390199188*^9, 3.539066423339196*^9}, 
   3.539066893122425*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a1", "2"], "-", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", 
          SuperscriptBox["h0", "2"], "+", 
          SuperscriptBox["p0", "2"]}], ")"}]}]}], ")"}], " ", "s0"}], 
    RowBox[{"4", " ", "t1"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`z, 1, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 1, {
   Rational[1, 4] ($CellContext`a1^2 - 
     4 (3 + $CellContext`h0^2 + $CellContext`p0^2)) \
$CellContext`s0/$CellContext`t1}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.539066390199188*^9, 3.539066423339196*^9}, 
   3.53906689312399*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"fp", ",", "hp", ",", "ap", ",", "tp", ",", "sp"}], "]"}]], "Input",\

 CellChangeTimes->{{3.539066461241226*^9, 3.539066466435452*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fp", "[", "z_", "]"}], ":=", 
   RowBox[{"fp0", "+", 
    RowBox[{"fp1", 
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
    RowBox[{"fp2", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"fp3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"fp4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hp", "[", "z_", "]"}], ":=", 
   RowBox[{"hp0", "+", 
    RowBox[{"hp1", 
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
    RowBox[{"hp2", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"hp3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"hp4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ap", "[", "z_", "]"}], ":=", 
   RowBox[{"ap0", "+", 
    RowBox[{"ap1", 
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
    RowBox[{"ap2", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"ap3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"ap4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tp", "[", "z_", "]"}], ":=", 
   RowBox[{"tp0", "+", 
    RowBox[{"tp1", 
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
    RowBox[{"tp2", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"tp3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"tp4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sp", "[", "z_", "]"}], ":=", 
  RowBox[{"sp0", "+", 
   RowBox[{"sp1", 
    RowBox[{"(", 
     RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
   RowBox[{"sp2", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
   RowBox[{"sp3", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
   RowBox[{"sp4", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.538983350296534*^9, 3.5389834150025806`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5389834368860693`*^9, 3.538983438850547*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"lineqlist", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "z0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"tmp", "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"tp0", ",", "hp0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"repl", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"repl", ",", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.538983291323738*^9, 3.5389833271999598`*^9}, {
  3.5389834353492203`*^9, 3.538983441948398*^9}, {3.5389836311997013`*^9, 
  3.5389836587886457`*^9}, {3.538984073658342*^9, 3.5389840739061193`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"4", " ", "s0", " ", 
        SuperscriptBox["t1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"z", "-", "1"}], ")"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "ap0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["h0", "3"]}], "+", 
           RowBox[{"4", " ", "a1", " ", "p0"}], "+", 
           RowBox[{"h0", " ", 
            RowBox[{"(", 
             RowBox[{"4", "-", 
              SuperscriptBox["a1", "2"], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["p0", "2"]}]}], ")"}]}]}], ")"}], " ", "s0", 
         " ", "t1"}], "+", 
        RowBox[{"4", " ", "ap1", " ", "h0", " ", "s0", " ", 
         SuperscriptBox["t1", "2"]}], "-", 
        RowBox[{"4", " ", "a1", " ", "hp0", " ", "s0", " ", 
         SuperscriptBox["t1", "2"]}], "+", 
        RowBox[{"4", " ", "fp1", " ", "s0", " ", 
         SuperscriptBox["t1", "3"]}], "-", 
        RowBox[{"4", " ", "a1", " ", "h0", " ", "s0", " ", "tp0"}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a1", "3"], " ", "h0", " ", "s0", " ", "tp0"}], "+", 
        RowBox[{"8", " ", "a1", " ", 
         SuperscriptBox["h0", "3"], " ", "s0", " ", "tp0"}], "+", 
        RowBox[{"16", " ", "p0", " ", "s0", " ", "tp0"}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["h0", "2"], " ", "p0", " ", "s0", " ", "tp0"}], "+", 
        RowBox[{"8", " ", "a1", " ", "h0", " ", 
         SuperscriptBox["p0", "2"], " ", "s0", " ", "tp0"}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["p0", "3"], " ", "s0", " ", "tp0"}], "+", 
        RowBox[{"8", " ", "a1", " ", "h0", " ", "s0", " ", "t1", " ", "tp0"}],
         "+", 
        RowBox[{"16", " ", "p0", " ", "s0", " ", "t1", " ", "tp0"}], "+", 
        RowBox[{
        "8", " ", "a1", " ", "h0", " ", "sp0", " ", "t1", " ", 
         "\[CapitalOmega]"}], "+", 
        RowBox[{
        "16", " ", "p0", " ", "sp0", " ", "t1", " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"8", " ", "fp1", " ", "s0", " ", 
         SuperscriptBox["t1", "2"], " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"2", " ", "fp0", " ", "s0", " ", "t1", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "t1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["a1", "2"]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{"3", "+", 
                 SuperscriptBox["h0", "2"], "+", 
                 SuperscriptBox["p0", "2"]}], ")"}]}]}], ")"}], " ", 
            "\[CapitalOmega]"}]}], ")"}]}], "-", 
        FractionBox[
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a1", "3"], "-", 
            RowBox[{"4", " ", "a1", " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["h0", "2"]}]}], ")"}]}], "-", 
            RowBox[{"8", " ", "h0", " ", "p0"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["a1", "2"], " ", "h0", " ", "p0"}]}], ")"}], " ", 
          
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "ap0", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h0", "2"], "+", 
               SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", "t1"}], 
            "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"ap1", "+", 
               RowBox[{"2", " ", "fp0", " ", "h0"}], "-", 
               RowBox[{"2", " ", "hp0", " ", "p0"}]}], ")"}], " ", "s0", " ", 
             "t1", " ", "\[CapitalOmega]"}], "+", 
            RowBox[{"2", " ", "a1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["h0", "2"], " ", "s0", " ", "tp0"}], "+", 
               RowBox[{
                SuperscriptBox["p0", "2"], " ", "s0", " ", "tp0"}], "+", 
               RowBox[{"sp0", " ", "t1", " ", "\[CapitalOmega]"}]}], 
              ")"}]}]}], ")"}]}], 
         RowBox[{"p0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a1", "2"]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", 
               SuperscriptBox["h0", "2"], "+", 
               SuperscriptBox["p0", "2"]}], ")"}]}]}], ")"}]}]], "+", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a1", "2"], "-", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", 
               SuperscriptBox["h0", "2"], "+", 
               SuperscriptBox["p0", "2"]}], ")"}]}]}], ")"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a1", " ", "h0"}], "+", 
            RowBox[{"2", " ", "p0"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", "a1", " ", "ap1", " ", "s0", " ", 
             SuperscriptBox["t1", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a1", "4"], " ", "s0", " ", "tp0"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["a1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "s0", " ", 
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["h0", "2"]}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["p0", "2"]}], "+", "t1"}], ")"}], " ", 
                "tp0"}], "+", 
               RowBox[{"sp0", " ", "t1", " ", 
                RowBox[{"(", 
                 RowBox[{"t1", "-", 
                  RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}],
             "-", 
            RowBox[{"16", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "h0", " ", "hp0", " ", "s0", " ", 
                SuperscriptBox["t1", "2"]}], "+", 
               RowBox[{"2", " ", "fp0", " ", "p0", " ", "s0", " ", 
                SuperscriptBox["t1", "2"]}], "+", 
               RowBox[{"3", " ", "sp0", " ", 
                SuperscriptBox["t1", "2"]}], "+", 
               RowBox[{
                SuperscriptBox["p0", "2"], " ", "sp0", " ", 
                SuperscriptBox["t1", "2"]}], "-", 
               RowBox[{"sp0", " ", 
                SuperscriptBox["t1", "3"]}], "+", 
               RowBox[{"sp1", " ", 
                SuperscriptBox["t1", "3"]}], "-", 
               RowBox[{"9", " ", "s0", " ", "tp0"}], "-", 
               RowBox[{
                SuperscriptBox["h0", "4"], " ", "s0", " ", "tp0"}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["p0", "2"], " ", "s0", " ", "tp0"}], "-", 
               RowBox[{
                SuperscriptBox["p0", "4"], " ", "s0", " ", "tp0"}], "-", 
               RowBox[{"6", " ", "s0", " ", "t1", " ", "tp0"}], "-", 
               RowBox[{"2", " ", 
                SuperscriptBox["p0", "2"], " ", "s0", " ", "t1", " ", "tp0"}],
                "+", 
               RowBox[{
                SuperscriptBox["h0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", "s0", " ", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", 
                    SuperscriptBox["p0", "2"], "+", "t1"}], ")"}], " ", 
                   "tp0"}], "+", 
                  RowBox[{"sp0", " ", "t1", " ", 
                   RowBox[{"(", 
                    RowBox[{"t1", "-", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
                 ")"}]}], "-", 
               RowBox[{"6", " ", "sp0", " ", "t1", " ", "\[CapitalOmega]"}], 
               "-", 
               RowBox[{"2", " ", 
                SuperscriptBox["p0", "2"], " ", "sp0", " ", "t1", " ", 
                "\[CapitalOmega]"}], "-", 
               RowBox[{"2", " ", "sp0", " ", 
                SuperscriptBox["t1", "2"], " ", "\[CapitalOmega]"}], "+", 
               RowBox[{"2", " ", "sp1", " ", 
                SuperscriptBox["t1", "2"], " ", "\[CapitalOmega]"}]}], 
              ")"}]}]}], ")"}]}]}]}], ")"}]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"z", "-", "1"}], "]"}], "0"],
      SeriesData[$CellContext`z, 1, {}, -1, 0, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 1, {
     Rational[1, 
        4] $CellContext`s0^(-1) $CellContext`t1^(-3) ((-2) $CellContext`ap0 (
         4 $CellContext`h0^3 + 
         4 $CellContext`a1 $CellContext`p0 + $CellContext`h0 (
           4 - $CellContext`a1^2 + 
           4 $CellContext`p0^2)) $CellContext`s0 $CellContext`t1 + 
       4 $CellContext`ap1 $CellContext`h0 $CellContext`s0 $CellContext`t1^2 - 
       4 $CellContext`a1 $CellContext`hp0 $CellContext`s0 $CellContext`t1^2 + 
       4 $CellContext`fp1 $CellContext`s0 $CellContext`t1^3 - 
       4 $CellContext`a1 $CellContext`h0 $CellContext`s0 $CellContext`tp0 - 
       3 $CellContext`a1^3 $CellContext`h0 $CellContext`s0 $CellContext`tp0 + 
       8 $CellContext`a1 $CellContext`h0^3 $CellContext`s0 $CellContext`tp0 + 
       16 $CellContext`p0 $CellContext`s0 $CellContext`tp0 + 
       8 $CellContext`h0^2 $CellContext`p0 $CellContext`s0 $CellContext`tp0 + 
       8 $CellContext`a1 $CellContext`h0 $CellContext`p0^2 $CellContext`s0 \
$CellContext`tp0 + 8 $CellContext`p0^3 $CellContext`s0 $CellContext`tp0 + 
       8 $CellContext`a1 $CellContext`h0 $CellContext`s0 $CellContext`t1 \
$CellContext`tp0 + 
       16 $CellContext`p0 $CellContext`s0 $CellContext`t1 $CellContext`tp0 + 
       8 $CellContext`a1 $CellContext`h0 $CellContext`sp0 $CellContext`t1 \
$CellContext`\[CapitalOmega] + 
       16 $CellContext`p0 $CellContext`sp0 $CellContext`t1 $CellContext`\
\[CapitalOmega] + 
       8 $CellContext`fp1 $CellContext`s0 $CellContext`t1^2 $CellContext`\
\[CapitalOmega] - 
       2 $CellContext`fp0 $CellContext`s0 $CellContext`t1 (
        4 $CellContext`t1 + (-$CellContext`a1^2 + 
          4 (3 + $CellContext`h0^2 + $CellContext`p0^2)) $CellContext`\
\[CapitalOmega]) - 
       4 $CellContext`p0^(-1) ($CellContext`a1^3 - 
        4 $CellContext`a1 (3 + 2 $CellContext`h0^2) - 
        8 $CellContext`h0 $CellContext`p0 + 
        2 $CellContext`a1^2 $CellContext`h0 $CellContext`p0) \
(-$CellContext`a1^2 + 
         4 (3 + $CellContext`h0^2 + $CellContext`p0^2))^(-1) ((-2) \
$CellContext`ap0 ($CellContext`h0^2 + $CellContext`p0^2) $CellContext`s0 \
$CellContext`t1 - ($CellContext`ap1 + 2 $CellContext`fp0 $CellContext`h0 - 
         2 $CellContext`hp0 $CellContext`p0) $CellContext`s0 $CellContext`t1 \
$CellContext`\[CapitalOmega] + 
        2 $CellContext`a1 ($CellContext`h0^2 $CellContext`s0 $CellContext`tp0 + \
$CellContext`p0^2 $CellContext`s0 $CellContext`tp0 + $CellContext`sp0 \
$CellContext`t1 $CellContext`\[CapitalOmega])) + ($CellContext`a1 \
$CellContext`h0 + 
         2 $CellContext`p0) ($CellContext`a1^2 - 
          4 (3 + $CellContext`h0^2 + $CellContext`p0^2))^(-1) ((-8) \
$CellContext`a1 $CellContext`ap1 $CellContext`s0 $CellContext`t1^2 + \
$CellContext`a1^4 $CellContext`s0 $CellContext`tp0 + 
         4 $CellContext`a1^2 ((-2) $CellContext`s0 (3 + 2 $CellContext`h0^2 + 
             2 $CellContext`p0^2 + $CellContext`t1) $CellContext`tp0 + \
$CellContext`sp0 $CellContext`t1 ($CellContext`t1 - 
             2 $CellContext`\[CapitalOmega])) - 
         16 (2 $CellContext`h0 $CellContext`hp0 $CellContext`s0 \
$CellContext`t1^2 + 
          2 $CellContext`fp0 $CellContext`p0 $CellContext`s0 \
$CellContext`t1^2 + 
          3 $CellContext`sp0 $CellContext`t1^2 + $CellContext`p0^2 \
$CellContext`sp0 $CellContext`t1^2 - $CellContext`sp0 $CellContext`t1^3 + \
$CellContext`sp1 $CellContext`t1^3 - 
          9 $CellContext`s0 $CellContext`tp0 - $CellContext`h0^4 \
$CellContext`s0 $CellContext`tp0 - 
          4 $CellContext`p0^2 $CellContext`s0 $CellContext`tp0 - \
$CellContext`p0^4 $CellContext`s0 $CellContext`tp0 - 
          6 $CellContext`s0 $CellContext`t1 $CellContext`tp0 - 
          2 $CellContext`p0^2 $CellContext`s0 $CellContext`t1 \
$CellContext`tp0 + $CellContext`h0^2 ((-2) $CellContext`s0 (
              2 + $CellContext`p0^2 + $CellContext`t1) $CellContext`tp0 + \
$CellContext`sp0 $CellContext`t1 ($CellContext`t1 - 
              2 $CellContext`\[CapitalOmega])) - 
          6 $CellContext`sp0 $CellContext`t1 $CellContext`\[CapitalOmega] - 
          2 $CellContext`p0^2 $CellContext`sp0 $CellContext`t1 $CellContext`\
\[CapitalOmega] - 
          2 $CellContext`sp0 $CellContext`t1^2 $CellContext`\[CapitalOmega] + 
          2 $CellContext`sp1 $CellContext`t1^2 \
$CellContext`\[CapitalOmega])))}, -1, 0, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "ap0", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["h0", "2"], "+", 
          SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", "t1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"ap1", "+", 
          RowBox[{"2", " ", "fp0", " ", "h0"}], "-", 
          RowBox[{"2", " ", "hp0", " ", "p0"}]}], ")"}], " ", "s0", " ", "t1",
         " ", "\[CapitalOmega]"}], "-", 
       RowBox[{"2", " ", "a1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["h0", "2"], " ", "s0", " ", "tp0"}], "+", 
          RowBox[{
           SuperscriptBox["p0", "2"], " ", "s0", " ", "tp0"}], "+", 
          RowBox[{"sp0", " ", "t1", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
      RowBox[{"s0", " ", 
       SuperscriptBox["t1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}]}]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"z", "-", "1"}], "]"}], "0"],
      SeriesData[$CellContext`z, 1, {}, -1, 0, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     1, {$CellContext`s0^(-1) $CellContext`t1^(-2) (
       2 $CellContext`ap0 ($CellContext`h0^2 + $CellContext`p0^2) \
$CellContext`s0 $CellContext`t1 + ($CellContext`ap1 + 
         2 $CellContext`fp0 $CellContext`h0 - 
         2 $CellContext`hp0 $CellContext`p0) $CellContext`s0 $CellContext`t1 \
$CellContext`\[CapitalOmega] - 
       2 $CellContext`a1 ($CellContext`h0^2 $CellContext`s0 $CellContext`tp0 + \
$CellContext`p0^2 $CellContext`s0 $CellContext`tp0 + $CellContext`sp0 \
$CellContext`t1 $CellContext`\[CapitalOmega]))}, -1, 0, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "h0"}], "-", 
         RowBox[{"a1", " ", "p0"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "ap0", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["h0", "2"], "+", 
            SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", "t1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"ap1", "+", 
            RowBox[{"2", " ", "fp0", " ", "h0"}], "-", 
            RowBox[{"2", " ", "hp0", " ", "p0"}]}], ")"}], " ", "s0", " ", 
          "t1", " ", "\[CapitalOmega]"}], "-", 
         RowBox[{"2", " ", "a1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["h0", "2"], " ", "s0", " ", "tp0"}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", "s0", " ", "tp0"}], "+", 
            RowBox[{"sp0", " ", "t1", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
        ")"}]}], 
      RowBox[{"2", " ", "p0", " ", 
       SuperscriptBox["t1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}]}]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"z", "-", "1"}], "]"}], "0"],
      SeriesData[$CellContext`z, 1, {}, -1, 0, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 1, {
     Rational[1, 2] $CellContext`p0^(-1) (
       2 $CellContext`h0 - $CellContext`a1 $CellContext`p0) \
$CellContext`t1^(-3) (
       2 $CellContext`ap0 ($CellContext`h0^2 + $CellContext`p0^2) \
$CellContext`s0 $CellContext`t1 + ($CellContext`ap1 + 
         2 $CellContext`fp0 $CellContext`h0 - 
         2 $CellContext`hp0 $CellContext`p0) $CellContext`s0 $CellContext`t1 \
$CellContext`\[CapitalOmega] - 
       2 $CellContext`a1 ($CellContext`h0^2 $CellContext`s0 $CellContext`tp0 + \
$CellContext`p0^2 $CellContext`s0 $CellContext`tp0 + $CellContext`sp0 \
$CellContext`t1 $CellContext`\[CapitalOmega]))}, -1, 0, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "0"],
    SeriesData[$CellContext`z, 1, {}, 0, 0, 1],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"2", " ", "ap0", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["h0", "2"], "+", 
           SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", "t1"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"ap1", "+", 
           RowBox[{"2", " ", "fp0", " ", "h0"}], "-", 
           RowBox[{"2", " ", "hp0", " ", "p0"}]}], ")"}], " ", "s0", " ", 
         "t1", " ", "\[CapitalOmega]"}], "-", 
        RowBox[{"2", " ", "a1", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["h0", "2"], " ", "s0", " ", "tp0"}], "+", 
           RowBox[{
            SuperscriptBox["p0", "2"], " ", "s0", " ", "tp0"}], "+", 
           RowBox[{"sp0", " ", "t1", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"p0", " ", "s0", " ", 
          SuperscriptBox["t1", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"z", "-", "1"}], ")"}]}]]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"z", "-", "1"}], "]"}], "0"],
      SeriesData[$CellContext`z, 1, {}, -1, 0, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 1, {
     Rational[-1, 
        2] $CellContext`p0^(-1) $CellContext`s0^(-1) $CellContext`t1^(-2) (
       2 $CellContext`ap0 ($CellContext`h0^2 + $CellContext`p0^2) \
$CellContext`s0 $CellContext`t1 + ($CellContext`ap1 + 
         2 $CellContext`fp0 $CellContext`h0 - 
         2 $CellContext`hp0 $CellContext`p0) $CellContext`s0 $CellContext`t1 \
$CellContext`\[CapitalOmega] - 
       2 $CellContext`a1 ($CellContext`h0^2 $CellContext`s0 $CellContext`tp0 + \
$CellContext`p0^2 $CellContext`s0 $CellContext`tp0 + $CellContext`sp0 \
$CellContext`t1 $CellContext`\[CapitalOmega]))}, -1, 0, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{{3.538983285825459*^9, 3.538983330354681*^9}, {
   3.538983427315576*^9, 3.538983446139784*^9}, 3.538983605454783*^9, {
   3.5389836381128597`*^9, 3.538983662474482*^9}, 3.53898391543221*^9, 
   3.538984080125003*^9, 3.5390008520781107`*^9, 3.53901948831287*^9, 
   3.539019766748941*^9, 3.5390202239289427`*^9, 3.539021388329019*^9, 
   3.539021696645713*^9, 3.5390237317361393`*^9, 3.539066903192676*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"tp0", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"t1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a1", "4"], " ", "\[CapitalOmega]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ap0", " ", "h0", " ", "p0", " ", "s0"}], "+", 
             RowBox[{"2", " ", "sp0", " ", "t1"}], "+", 
             RowBox[{"fp0", " ", "p0", " ", "s0", " ", "\[CapitalOmega]"}]}], 
            ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ap1", " ", "s0"}], "+", 
                RowBox[{"2", " ", "fp0", " ", "h0", " ", "s0"}], "-", 
                RowBox[{"2", " ", "h0", " ", "p0", " ", "sp0"}]}], ")"}], " ",
               "t1", " ", "\[CapitalOmega]"}], "+", 
             RowBox[{"2", " ", "ap0", " ", "s0", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["h0", "2"], " ", "t1"}], "+", 
                RowBox[{
                 SuperscriptBox["p0", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"t1", "+", 
                   RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a1", "2"], " ", "\[CapitalOmega]", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "ap0", " ", "h0", " ", "p0", " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                SuperscriptBox["h0", "2"], "+", 
                SuperscriptBox["p0", "2"]}], ")"}], " ", "s0"}], "+", 
             RowBox[{"2", " ", "fp0", " ", "p0", " ", "s0", " ", 
              RowBox[{"(", 
               RowBox[{"t1", "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   SuperscriptBox["h0", "2"], "+", 
                   SuperscriptBox["p0", "2"]}], ")"}], " ", 
                 "\[CapitalOmega]"}]}], ")"}]}], "+", 
             RowBox[{"t1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ap1", " ", "h0", " ", "p0", " ", "s0"}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"6", "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["h0", "2"]}], "+", 
                   SuperscriptBox["p0", "2"]}], ")"}], " ", "sp0"}], "-", 
                RowBox[{"fp1", " ", "p0", " ", "s0", " ", 
                 RowBox[{"(", 
                  RowBox[{"t1", "+", 
                   RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}], "+", 
          RowBox[{"8", " ", "p0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "ap0", " ", "h0", " ", "s0", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 SuperscriptBox["p0", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"t1", "-", 
                   RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
                RowBox[{"3", " ", "\[CapitalOmega]"}], "+", 
                RowBox[{
                 SuperscriptBox["h0", "4"], " ", "\[CapitalOmega]"}], "+", 
                RowBox[{
                 SuperscriptBox["p0", "4"], " ", "\[CapitalOmega]"}], "+", 
                RowBox[{
                 SuperscriptBox["h0", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", "t1"}], "+", 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    SuperscriptBox["p0", "2"]}], ")"}], " ", 
                    "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"\[CapitalOmega]", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "fp0", " ", "s0", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    SuperscriptBox["h0", "2"], "+", 
                    SuperscriptBox["p0", "2"]}], ")"}]}], " ", "t1"}], "+", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    SuperscriptBox["h0", "2"], "+", 
                    SuperscriptBox["p0", "2"]}], ")"}], "2"], " ", 
                    "\[CapitalOmega]"}]}], ")"}]}], "-", 
                RowBox[{"t1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"ap1", " ", "h0", " ", 
                    RowBox[{"(", 
                    RowBox[{"5", "+", 
                    SuperscriptBox["h0", "2"], "+", 
                    SuperscriptBox["p0", "2"]}], ")"}], " ", "s0"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["p0", "3"], " ", "sp0"}], "+", 
                   RowBox[{"fp1", " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    SuperscriptBox["h0", "2"]}], ")"}], " ", "s0", " ", 
                    RowBox[{"(", 
                    RowBox[{"t1", "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
                   RowBox[{"fp1", " ", 
                    SuperscriptBox["p0", "2"], " ", "s0", " ", 
                    RowBox[{"(", 
                    RowBox[{"t1", "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
                   RowBox[{"2", " ", "p0", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"sp0", " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    SuperscriptBox["h0", "2"], "-", "t1", "-", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
                    RowBox[{"sp1", " ", 
                    RowBox[{"(", 
                    RowBox[{"t1", "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{"4", " ", "a1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "ap0", " ", "s0", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["h0", "4"], " ", "t1"}], "-", 
                RowBox[{
                 SuperscriptBox["p0", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   SuperscriptBox["p0", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"t1", "+", 
                   RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["h0", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "t1"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["p0", "2"], " ", "\[CapitalOmega]"}]}], 
                  ")"}]}]}], ")"}]}], "+", 
             RowBox[{"t1", " ", "\[CapitalOmega]", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ap1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "3"}], "+", 
                   SuperscriptBox["h0", "2"], "+", 
                   SuperscriptBox["p0", "2"]}], ")"}], " ", "s0"}], "+", 
                RowBox[{"2", " ", "h0", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"fp0", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    SuperscriptBox["h0", "2"], "+", 
                    SuperscriptBox["p0", "2"]}], ")"}], " ", "s0"}], "+", 
                   RowBox[{"p0", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"sp0", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    SuperscriptBox["h0", "2"], "+", 
                    SuperscriptBox["p0", "2"], "-", "t1", "-", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
                    RowBox[{"sp1", " ", 
                    RowBox[{"(", 
                    RowBox[{"t1", "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"s0", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a1", "5"], " ", "h0", " ", "p0", " ", 
           "\[CapitalOmega]"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["p0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "3"}], "+", 
             SuperscriptBox["h0", "2"], "+", 
             SuperscriptBox["p0", "2"]}], ")"}], " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a1", "3"], " ", "h0", " ", "p0", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             SuperscriptBox["h0", "2"], "+", 
             SuperscriptBox["p0", "2"]}], ")"}], " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{
           SuperscriptBox["a1", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["h0", "2"], " ", "t1"}], "+", 
             RowBox[{
              SuperscriptBox["p0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "t1"}], "+", "\[CapitalOmega]"}], ")"}]}]}],
             ")"}]}], "+", 
          RowBox[{"8", " ", "a1", " ", "h0", " ", "p0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "12"}], " ", "\[CapitalOmega]"}], "+", 
             RowBox[{
              SuperscriptBox["h0", "4"], " ", "\[CapitalOmega]"}], "+", 
             RowBox[{
              SuperscriptBox["p0", "4"], " ", "\[CapitalOmega]"}], "+", 
             RowBox[{
              SuperscriptBox["p0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "4"}], " ", "t1"}], "+", "\[CapitalOmega]"}], 
               ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["h0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "4"}], " ", "t1"}], "+", "\[CapitalOmega]", "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["p0", "2"], " ", "\[CapitalOmega]"}]}], 
               ")"}]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["h0", "4"], " ", "t1"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["h0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "t1"}], "+", 
                RowBox[{
                 SuperscriptBox["p0", "2"], " ", "\[CapitalOmega]"}]}], 
               ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["p0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   SuperscriptBox["p0", "2"]}], ")"}], " ", "t1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"4", "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["p0", "2"]}]}], ")"}], " ", 
                 "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}]}]}], ",", 
    RowBox[{"hp0", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a1", "6"], " ", "h0", " ", "sp0", " ", 
         "\[CapitalOmega]"}], "+", 
        RowBox[{
         SuperscriptBox["a1", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ap1", " ", "h0", " ", "s0"}], "+", 
           RowBox[{"2", " ", "p0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "fp0"}], " ", "p0", " ", "s0"}], "+", "sp0"}], 
             ")"}]}]}], ")"}], " ", "\[CapitalOmega]"}], "+", 
        RowBox[{"16", " ", "p0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           SuperscriptBox["h0", "2"], "+", 
           SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "ap0", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["h0", "2"], "+", 
              SuperscriptBox["p0", "2"]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"ap1", "+", 
              RowBox[{"2", " ", "fp0", " ", "h0"}]}], ")"}], " ", 
            "\[CapitalOmega]"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", "ap0", " ", "p0", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["h0", "2"], "+", 
              SuperscriptBox["p0", "2"]}], ")"}], " ", "s0"}], "-", 
           RowBox[{"ap1", " ", "p0", " ", "s0", " ", "\[CapitalOmega]"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["h0", "3"], " ", "sp0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "t1"}], "+", "\[CapitalOmega]"}], ")"}]}], "+", 
           RowBox[{"h0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "fp0", " ", "p0", " ", "s0", " ", 
               "\[CapitalOmega]"}], "+", 
              RowBox[{"8", " ", "sp0", " ", "\[CapitalOmega]"}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["p0", "2"], " ", "sp0", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "t1"}], "+", "\[CapitalOmega]"}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", "ap0", " ", "h0", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["h0", "4"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["h0", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox["p0", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["p0", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 SuperscriptBox["p0", "2"]}], ")"}]}]}], ")"}], " ", "s0"}], 
           "+", 
           RowBox[{"2", " ", "ap1", " ", 
            SuperscriptBox["h0", "3"], " ", "s0", " ", "t1"}], "+", 
           RowBox[{"2", " ", "ap1", " ", "h0", " ", 
            SuperscriptBox["p0", "2"], " ", "s0", " ", "t1"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["h0", "2"], " ", "p0", " ", "sp0", " ", "t1"}], 
           "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["p0", "3"], " ", "sp0", " ", "t1"}], "-", 
           RowBox[{"2", " ", "fp1", " ", 
            SuperscriptBox["h0", "2"], " ", "s0", " ", 
            SuperscriptBox["t1", "2"]}], "-", 
           RowBox[{"2", " ", "fp1", " ", 
            SuperscriptBox["p0", "2"], " ", "s0", " ", 
            SuperscriptBox["t1", "2"]}], "-", 
           RowBox[{
           "2", " ", "ap1", " ", "h0", " ", "s0", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"ap1", " ", 
            SuperscriptBox["h0", "3"], " ", "s0", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"ap1", " ", "h0", " ", 
            SuperscriptBox["p0", "2"], " ", "s0", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"16", " ", "p0", " ", "sp0", " ", "\[CapitalOmega]"}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["h0", "2"], " ", "p0", " ", "sp0", " ", 
            "\[CapitalOmega]"}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["p0", "3"], " ", "sp0", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"4", " ", "fp1", " ", 
            SuperscriptBox["h0", "2"], " ", "s0", " ", "t1", " ", 
            "\[CapitalOmega]"}], "-", 
           RowBox[{"4", " ", "fp1", " ", 
            SuperscriptBox["p0", "2"], " ", "s0", " ", "t1", " ", 
            "\[CapitalOmega]"}], "+", 
           RowBox[{"2", " ", "fp0", " ", "s0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["h0", "4"], " ", "\[CapitalOmega]"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["p0", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"t1", "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    SuperscriptBox["p0", "2"]}], ")"}], " ", 
                  "\[CapitalOmega]"}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["h0", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "t1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"10", "+", 
                    RowBox[{"7", " ", 
                    SuperscriptBox["p0", "2"]}]}], ")"}], " ", 
                  "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"8", " ", "a1", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "ap0", " ", "h0", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["h0", "6"], "+", 
              RowBox[{
               SuperscriptBox["h0", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"7", "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p0", "2"]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["p0", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"18", "+", 
                 RowBox[{"7", " ", 
                  SuperscriptBox["p0", "2"]}], "+", 
                 SuperscriptBox["p0", "4"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["h0", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"18", "+", 
                 RowBox[{"14", " ", 
                  SuperscriptBox["p0", "2"]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p0", "4"]}]}], ")"}]}]}], ")"}], " ", 
            "s0"}], "-", 
           RowBox[{"6", " ", "ap1", " ", 
            SuperscriptBox["h0", "3"], " ", "s0", " ", "t1"}], "-", 
           RowBox[{"2", " ", "ap1", " ", 
            SuperscriptBox["h0", "5"], " ", "s0", " ", "t1"}], "-", 
           RowBox[{"6", " ", "ap1", " ", "h0", " ", 
            SuperscriptBox["p0", "2"], " ", "s0", " ", "t1"}], "-", 
           RowBox[{"4", " ", "ap1", " ", 
            SuperscriptBox["h0", "3"], " ", 
            SuperscriptBox["p0", "2"], " ", "s0", " ", "t1"}], "-", 
           RowBox[{"2", " ", "ap1", " ", "h0", " ", 
            SuperscriptBox["p0", "4"], " ", "s0", " ", "t1"}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["h0", "2"], " ", "p0", " ", "sp0", " ", "t1"}], 
           "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["h0", "4"], " ", "p0", " ", "sp0", " ", "t1"}], 
           "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["p0", "3"], " ", "sp0", " ", "t1"}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["h0", "2"], " ", 
            SuperscriptBox["p0", "3"], " ", "sp0", " ", "t1"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["p0", "5"], " ", "sp0", " ", "t1"}], "-", 
           RowBox[{"6", " ", "fp1", " ", 
            SuperscriptBox["h0", "2"], " ", "s0", " ", 
            SuperscriptBox["t1", "2"]}], "-", 
           RowBox[{"2", " ", "fp1", " ", 
            SuperscriptBox["h0", "4"], " ", "s0", " ", 
            SuperscriptBox["t1", "2"]}], "-", 
           RowBox[{"6", " ", "fp1", " ", 
            SuperscriptBox["p0", "2"], " ", "s0", " ", 
            SuperscriptBox["t1", "2"]}], "-", 
           RowBox[{"4", " ", "fp1", " ", 
            SuperscriptBox["h0", "2"], " ", 
            SuperscriptBox["p0", "2"], " ", "s0", " ", 
            SuperscriptBox["t1", "2"]}], "-", 
           RowBox[{"2", " ", "fp1", " ", 
            SuperscriptBox["p0", "4"], " ", "s0", " ", 
            SuperscriptBox["t1", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["h0", "2"], " ", "p0", " ", "sp0", " ", 
            SuperscriptBox["t1", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["p0", "3"], " ", "sp0", " ", 
            SuperscriptBox["t1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["h0", "2"], " ", "p0", " ", "sp1", " ", 
            SuperscriptBox["t1", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["p0", "3"], " ", "sp1", " ", 
            SuperscriptBox["t1", "2"]}], "+", 
           RowBox[{
           "12", " ", "ap1", " ", "h0", " ", "s0", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"ap1", " ", 
            SuperscriptBox["h0", "3"], " ", "s0", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"ap1", " ", 
            SuperscriptBox["h0", "5"], " ", "s0", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"ap1", " ", "h0", " ", 
            SuperscriptBox["p0", "2"], " ", "s0", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"2", " ", "ap1", " ", 
            SuperscriptBox["h0", "3"], " ", 
            SuperscriptBox["p0", "2"], " ", "s0", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"ap1", " ", "h0", " ", 
            SuperscriptBox["p0", "4"], " ", "s0", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"12", " ", "p0", " ", "sp0", " ", "\[CapitalOmega]"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["h0", "2"], " ", "p0", " ", "sp0", " ", 
            "\[CapitalOmega]"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["p0", "3"], " ", "sp0", " ", "\[CapitalOmega]"}], 
           "-", 
           RowBox[{"12", " ", "fp1", " ", 
            SuperscriptBox["h0", "2"], " ", "s0", " ", "t1", " ", 
            "\[CapitalOmega]"}], "-", 
           RowBox[{"4", " ", "fp1", " ", 
            SuperscriptBox["h0", "4"], " ", "s0", " ", "t1", " ", 
            "\[CapitalOmega]"}], "-", 
           RowBox[{"12", " ", "fp1", " ", 
            SuperscriptBox["p0", "2"], " ", "s0", " ", "t1", " ", 
            "\[CapitalOmega]"}], "-", 
           RowBox[{"8", " ", "fp1", " ", 
            SuperscriptBox["h0", "2"], " ", 
            SuperscriptBox["p0", "2"], " ", "s0", " ", "t1", " ", 
            "\[CapitalOmega]"}], "-", 
           RowBox[{"4", " ", "fp1", " ", 
            SuperscriptBox["p0", "4"], " ", "s0", " ", "t1", " ", 
            "\[CapitalOmega]"}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["h0", "2"], " ", "p0", " ", "sp0", " ", "t1", " ", 
            "\[CapitalOmega]"}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["p0", "3"], " ", "sp0", " ", "t1", " ", 
            "\[CapitalOmega]"}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["h0", "2"], " ", "p0", " ", "sp1", " ", "t1", " ", 
            "\[CapitalOmega]"}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["p0", "3"], " ", "sp1", " ", "t1", " ", 
            "\[CapitalOmega]"}], "+", 
           RowBox[{"2", " ", "fp0", " ", "s0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["h0", "6"], " ", "\[CapitalOmega]"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["p0", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    SuperscriptBox["p0", "2"]}], ")"}]}], " ", "t1"}], "+", 
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"3", "+", 
                    SuperscriptBox["p0", "2"]}], ")"}], "2"], " ", 
                  "\[CapitalOmega]"}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["h0", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "t1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"11", "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["p0", "2"]}]}], ")"}], " ", 
                  "\[CapitalOmega]"}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["h0", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", "t1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"30", "+", 
                    RowBox[{"23", " ", 
                    SuperscriptBox["p0", "2"]}], "+", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["p0", "4"]}]}], ")"}], " ", 
                  "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "ap0", " ", "p0", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["h0", "4"], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["h0", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 SuperscriptBox["p0", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["p0", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"8", "+", 
                 SuperscriptBox["p0", "2"]}], ")"}]}]}], ")"}], " ", "s0"}], 
           "-", 
           RowBox[{"ap1", " ", "p0", " ", "s0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", "\[CapitalOmega]"}], "+", 
              RowBox[{
               SuperscriptBox["h0", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", "t1"}], "+", 
                 RowBox[{"3", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["p0", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", "t1"}], "+", 
                 RowBox[{"3", " ", "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}], 
           "-", 
           RowBox[{"2", " ", "h0", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"fp0", " ", "p0", " ", "s0", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", "\[CapitalOmega]"}], "+", 
                 RowBox[{
                  SuperscriptBox["h0", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", "t1"}], "+", 
                    RowBox[{"3", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p0", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", "t1"}], "+", 
                    RowBox[{"3", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["h0", "4"], " ", "sp0", " ", 
                  RowBox[{"(", 
                   RowBox[{"t1", "-", "\[CapitalOmega]"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p0", "4"], " ", "sp0", " ", 
                  RowBox[{"(", 
                   RowBox[{"t1", "-", "\[CapitalOmega]"}], ")"}]}], "+", 
                 RowBox[{"12", " ", "sp0", " ", "\[CapitalOmega]"}], "+", 
                 RowBox[{
                  SuperscriptBox["p0", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"sp1", " ", "t1", " ", 
                    RowBox[{"(", 
                    RowBox[{"t1", "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "-", 
                    RowBox[{"sp0", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "3"}], " ", "t1"}], "+", 
                    SuperscriptBox["t1", "2"], "+", "\[CapitalOmega]", "+", 
                    RowBox[{"2", " ", "t1", " ", "\[CapitalOmega]"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["h0", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"sp1", " ", "t1", " ", 
                    RowBox[{"(", 
                    RowBox[{"t1", "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "-", 
                    RowBox[{"sp0", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["t1", "2"], "+", "\[CapitalOmega]", "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["p0", "2"], " ", "\[CapitalOmega]"}], "+", 
                    
                    RowBox[{"t1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["p0", "2"]}], "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", " ", "s0", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a1", "5"], " ", "h0", " ", "p0", " ", 
           "\[CapitalOmega]"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["p0", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "3"}], "+", 
             SuperscriptBox["h0", "2"], "+", 
             SuperscriptBox["p0", "2"]}], ")"}], " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a1", "3"], " ", "h0", " ", "p0", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             SuperscriptBox["h0", "2"], "+", 
             SuperscriptBox["p0", "2"]}], ")"}], " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{
           SuperscriptBox["a1", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["h0", "2"], " ", "t1"}], "+", 
             RowBox[{
              SuperscriptBox["p0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "t1"}], "+", "\[CapitalOmega]"}], ")"}]}]}],
             ")"}]}], "+", 
          RowBox[{"8", " ", "a1", " ", "h0", " ", "p0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "12"}], " ", "\[CapitalOmega]"}], "+", 
             RowBox[{
              SuperscriptBox["h0", "4"], " ", "\[CapitalOmega]"}], "+", 
             RowBox[{
              SuperscriptBox["p0", "4"], " ", "\[CapitalOmega]"}], "+", 
             RowBox[{
              SuperscriptBox["p0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "4"}], " ", "t1"}], "+", "\[CapitalOmega]"}], 
               ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["h0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "4"}], " ", "t1"}], "+", "\[CapitalOmega]", "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["p0", "2"], " ", "\[CapitalOmega]"}]}], 
               ")"}]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["a1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["h0", "4"], " ", "t1"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["h0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "t1"}], "+", 
                RowBox[{
                 SuperscriptBox["p0", "2"], " ", "\[CapitalOmega]"}]}], 
               ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["p0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   SuperscriptBox["p0", "2"]}], ")"}], " ", "t1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"4", "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["p0", "2"]}]}], ")"}], " ", 
                 "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.538983285825459*^9, 3.538983330354681*^9}, {
   3.538983427315576*^9, 3.538983446139784*^9}, 3.538983605454783*^9, {
   3.5389836381128597`*^9, 3.538983662474482*^9}, 3.53898391543221*^9, 
   3.538984080125003*^9, 3.5390008520781107`*^9, 3.53901948831287*^9, 
   3.539019766748941*^9, 3.5390202239289427`*^9, 3.539021388329019*^9, 
   3.539021696645713*^9, 3.5390237317361393`*^9, 3.539066904438278*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"tp0", "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"t1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a1", "4"], " ", "\[CapitalOmega]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"ap0", " ", "h0", " ", "p0", " ", "s0"}], "+", 
            RowBox[{"2", " ", "sp0", " ", "t1"}], "+", 
            RowBox[{"fp0", " ", "p0", " ", "s0", " ", "\[CapitalOmega]"}]}], 
           ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a1", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"ap1", " ", "s0"}], "+", 
               RowBox[{"2", " ", "fp0", " ", "h0", " ", "s0"}], "-", 
               RowBox[{"2", " ", "h0", " ", "p0", " ", "sp0"}]}], ")"}], " ", 
             "t1", " ", "\[CapitalOmega]"}], "+", 
            RowBox[{"2", " ", "ap0", " ", "s0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["h0", "2"], " ", "t1"}], "+", 
               RowBox[{
                SuperscriptBox["p0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"t1", "+", 
                  RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a1", "2"], " ", "\[CapitalOmega]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "ap0", " ", "h0", " ", "p0", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               SuperscriptBox["h0", "2"], "+", 
               SuperscriptBox["p0", "2"]}], ")"}], " ", "s0"}], "+", 
            RowBox[{"2", " ", "fp0", " ", "p0", " ", "s0", " ", 
             RowBox[{"(", 
              RowBox[{"t1", "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  SuperscriptBox["h0", "2"], "+", 
                  SuperscriptBox["p0", "2"]}], ")"}], " ", 
                "\[CapitalOmega]"}]}], ")"}]}], "+", 
            RowBox[{"t1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"ap1", " ", "h0", " ", "p0", " ", "s0"}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"6", "-", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["h0", "2"]}], "+", 
                  SuperscriptBox["p0", "2"]}], ")"}], " ", "sp0"}], "-", 
               RowBox[{"fp1", " ", "p0", " ", "s0", " ", 
                RowBox[{"(", 
                 RowBox[{"t1", "+", 
                  RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", "p0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "ap0", " ", "h0", " ", "s0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["p0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"t1", "-", 
                  RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
               RowBox[{"3", " ", "\[CapitalOmega]"}], "+", 
               RowBox[{
                SuperscriptBox["h0", "4"], " ", "\[CapitalOmega]"}], "+", 
               RowBox[{
                SuperscriptBox["p0", "4"], " ", "\[CapitalOmega]"}], "+", 
               RowBox[{
                SuperscriptBox["h0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", "t1"}], "+", 
                  RowBox[{"2", " ", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", 
                    SuperscriptBox["p0", "2"]}], ")"}], " ", 
                   "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"\[CapitalOmega]", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "fp0", " ", "s0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    SuperscriptBox["h0", "2"], "+", 
                    SuperscriptBox["p0", "2"]}], ")"}]}], " ", "t1"}], "+", 
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    SuperscriptBox["h0", "2"], "+", 
                    SuperscriptBox["p0", "2"]}], ")"}], "2"], " ", 
                   "\[CapitalOmega]"}]}], ")"}]}], "-", 
               RowBox[{"t1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"ap1", " ", "h0", " ", 
                   RowBox[{"(", 
                    RowBox[{"5", "+", 
                    SuperscriptBox["h0", "2"], "+", 
                    SuperscriptBox["p0", "2"]}], ")"}], " ", "s0"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["p0", "3"], " ", "sp0"}], "+", 
                  RowBox[{"fp1", " ", 
                   RowBox[{"(", 
                    RowBox[{"3", "+", 
                    SuperscriptBox["h0", "2"]}], ")"}], " ", "s0", " ", 
                   RowBox[{"(", 
                    RowBox[{"t1", "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
                  RowBox[{"fp1", " ", 
                   SuperscriptBox["p0", "2"], " ", "s0", " ", 
                   RowBox[{"(", 
                    RowBox[{"t1", "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
                  RowBox[{"2", " ", "p0", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"sp0", " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    SuperscriptBox["h0", "2"], "-", "t1", "-", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
                    RowBox[{"sp1", " ", 
                    RowBox[{"(", 
                    RowBox[{"t1", "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{"4", " ", "a1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "ap0", " ", "s0", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["h0", "4"], " ", "t1"}], "-", 
               RowBox[{
                SuperscriptBox["p0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  SuperscriptBox["p0", "2"]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"t1", "+", 
                  RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "-", 
               RowBox[{
                SuperscriptBox["h0", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"3", " ", "t1"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["p0", "2"], " ", "\[CapitalOmega]"}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{"t1", " ", "\[CapitalOmega]", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"ap1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "+", 
                  SuperscriptBox["h0", "2"], "+", 
                  SuperscriptBox["p0", "2"]}], ")"}], " ", "s0"}], "+", 
               RowBox[{"2", " ", "h0", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"fp0", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    SuperscriptBox["h0", "2"], "+", 
                    SuperscriptBox["p0", "2"]}], ")"}], " ", "s0"}], "+", 
                  RowBox[{"p0", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"sp0", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    SuperscriptBox["h0", "2"], "+", 
                    SuperscriptBox["p0", "2"], "-", "t1", "-", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
                    RowBox[{"sp1", " ", 
                    RowBox[{"(", 
                    RowBox[{"t1", "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"s0", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a1", "5"], " ", "h0", " ", "p0", " ", 
          "\[CapitalOmega]"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", 
            SuperscriptBox["h0", "2"], "+", 
            SuperscriptBox["p0", "2"]}], ")"}], " ", "\[CapitalOmega]"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a1", "3"], " ", "h0", " ", "p0", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            SuperscriptBox["h0", "2"], "+", 
            SuperscriptBox["p0", "2"]}], ")"}], " ", "\[CapitalOmega]"}], "-", 
         RowBox[{
          SuperscriptBox["a1", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["h0", "2"], " ", "t1"}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "t1"}], "+", "\[CapitalOmega]"}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"8", " ", "a1", " ", "h0", " ", "p0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12"}], " ", "\[CapitalOmega]"}], "+", 
            RowBox[{
             SuperscriptBox["h0", "4"], " ", "\[CapitalOmega]"}], "+", 
            RowBox[{
             SuperscriptBox["p0", "4"], " ", "\[CapitalOmega]"}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", "t1"}], "+", "\[CapitalOmega]"}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", "t1"}], "+", "\[CapitalOmega]", "+", 
               
               RowBox[{"2", " ", 
                SuperscriptBox["p0", "2"], " ", "\[CapitalOmega]"}]}], 
              ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["h0", "4"], " ", "t1"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "t1"}], "+", 
               RowBox[{
                SuperscriptBox["p0", "2"], " ", "\[CapitalOmega]"}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  SuperscriptBox["p0", "2"]}], ")"}], " ", "t1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4", "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["p0", "2"]}]}], ")"}], " ", 
                "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      ")"}]}]}], ",", 
   RowBox[{"hp0", "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["a1", "6"], " ", "h0", " ", "sp0", " ", 
        "\[CapitalOmega]"}], "+", 
       RowBox[{
        SuperscriptBox["a1", "5"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ap1", " ", "h0", " ", "s0"}], "+", 
          RowBox[{"2", " ", "p0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "fp0"}], " ", "p0", " ", "s0"}], "+", "sp0"}], 
            ")"}]}]}], ")"}], " ", "\[CapitalOmega]"}], "+", 
       RowBox[{"16", " ", "p0", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SuperscriptBox["h0", "2"], "+", 
          SuperscriptBox["p0", "2"]}], ")"}], " ", "s0", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "ap0", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["h0", "2"], "+", 
             SuperscriptBox["p0", "2"]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"ap1", "+", 
             RowBox[{"2", " ", "fp0", " ", "h0"}]}], ")"}], " ", 
           "\[CapitalOmega]"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["a1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", "ap0", " ", "p0", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["h0", "2"], "+", 
             SuperscriptBox["p0", "2"]}], ")"}], " ", "s0"}], "-", 
          RowBox[{"ap1", " ", "p0", " ", "s0", " ", "\[CapitalOmega]"}], "+", 
          
          RowBox[{"4", " ", 
           SuperscriptBox["h0", "3"], " ", "sp0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "t1"}], "+", "\[CapitalOmega]"}], ")"}]}], "+", 
          RowBox[{"h0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "fp0", " ", "p0", " ", "s0", " ", 
              "\[CapitalOmega]"}], "+", 
             RowBox[{"8", " ", "sp0", " ", "\[CapitalOmega]"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["p0", "2"], " ", "sp0", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "t1"}], "+", "\[CapitalOmega]"}], ")"}]}]}], 
            ")"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", "ap0", " ", "h0", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["h0", "4"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["h0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SuperscriptBox["p0", "2"]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["p0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                SuperscriptBox["p0", "2"]}], ")"}]}]}], ")"}], " ", "s0"}], 
          "+", 
          RowBox[{"2", " ", "ap1", " ", 
           SuperscriptBox["h0", "3"], " ", "s0", " ", "t1"}], "+", 
          RowBox[{"2", " ", "ap1", " ", "h0", " ", 
           SuperscriptBox["p0", "2"], " ", "s0", " ", "t1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["h0", "2"], " ", "p0", " ", "sp0", " ", "t1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["p0", "3"], " ", "sp0", " ", "t1"}], "-", 
          RowBox[{"2", " ", "fp1", " ", 
           SuperscriptBox["h0", "2"], " ", "s0", " ", 
           SuperscriptBox["t1", "2"]}], "-", 
          RowBox[{"2", " ", "fp1", " ", 
           SuperscriptBox["p0", "2"], " ", "s0", " ", 
           SuperscriptBox["t1", "2"]}], "-", 
          RowBox[{
          "2", " ", "ap1", " ", "h0", " ", "s0", " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"ap1", " ", 
           SuperscriptBox["h0", "3"], " ", "s0", " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"ap1", " ", "h0", " ", 
           SuperscriptBox["p0", "2"], " ", "s0", " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"16", " ", "p0", " ", "sp0", " ", "\[CapitalOmega]"}], "-", 
          
          RowBox[{"12", " ", 
           SuperscriptBox["h0", "2"], " ", "p0", " ", "sp0", " ", 
           "\[CapitalOmega]"}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["p0", "3"], " ", "sp0", " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"4", " ", "fp1", " ", 
           SuperscriptBox["h0", "2"], " ", "s0", " ", "t1", " ", 
           "\[CapitalOmega]"}], "-", 
          RowBox[{"4", " ", "fp1", " ", 
           SuperscriptBox["p0", "2"], " ", "s0", " ", "t1", " ", 
           "\[CapitalOmega]"}], "+", 
          RowBox[{"2", " ", "fp0", " ", "s0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["h0", "4"], " ", "\[CapitalOmega]"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["p0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"t1", "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"3", "+", 
                   SuperscriptBox["p0", "2"]}], ")"}], " ", 
                 "\[CapitalOmega]"}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["h0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "t1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"10", "+", 
                   RowBox[{"7", " ", 
                    SuperscriptBox["p0", "2"]}]}], ")"}], " ", 
                 "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"8", " ", "a1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "ap0", " ", "h0", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["h0", "6"], "+", 
             RowBox[{
              SuperscriptBox["h0", "4"], " ", 
              RowBox[{"(", 
               RowBox[{"7", "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["p0", "2"]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["p0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"18", "+", 
                RowBox[{"7", " ", 
                 SuperscriptBox["p0", "2"]}], "+", 
                SuperscriptBox["p0", "4"]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["h0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"18", "+", 
                RowBox[{"14", " ", 
                 SuperscriptBox["p0", "2"]}], "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["p0", "4"]}]}], ")"}]}]}], ")"}], " ", "s0"}],
           "-", 
          RowBox[{"6", " ", "ap1", " ", 
           SuperscriptBox["h0", "3"], " ", "s0", " ", "t1"}], "-", 
          RowBox[{"2", " ", "ap1", " ", 
           SuperscriptBox["h0", "5"], " ", "s0", " ", "t1"}], "-", 
          RowBox[{"6", " ", "ap1", " ", "h0", " ", 
           SuperscriptBox["p0", "2"], " ", "s0", " ", "t1"}], "-", 
          RowBox[{"4", " ", "ap1", " ", 
           SuperscriptBox["h0", "3"], " ", 
           SuperscriptBox["p0", "2"], " ", "s0", " ", "t1"}], "-", 
          RowBox[{"2", " ", "ap1", " ", "h0", " ", 
           SuperscriptBox["p0", "4"], " ", "s0", " ", "t1"}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["h0", "2"], " ", "p0", " ", "sp0", " ", "t1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["h0", "4"], " ", "p0", " ", "sp0", " ", "t1"}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["p0", "3"], " ", "sp0", " ", "t1"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["h0", "2"], " ", 
           SuperscriptBox["p0", "3"], " ", "sp0", " ", "t1"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["p0", "5"], " ", "sp0", " ", "t1"}], "-", 
          RowBox[{"6", " ", "fp1", " ", 
           SuperscriptBox["h0", "2"], " ", "s0", " ", 
           SuperscriptBox["t1", "2"]}], "-", 
          RowBox[{"2", " ", "fp1", " ", 
           SuperscriptBox["h0", "4"], " ", "s0", " ", 
           SuperscriptBox["t1", "2"]}], "-", 
          RowBox[{"6", " ", "fp1", " ", 
           SuperscriptBox["p0", "2"], " ", "s0", " ", 
           SuperscriptBox["t1", "2"]}], "-", 
          RowBox[{"4", " ", "fp1", " ", 
           SuperscriptBox["h0", "2"], " ", 
           SuperscriptBox["p0", "2"], " ", "s0", " ", 
           SuperscriptBox["t1", "2"]}], "-", 
          RowBox[{"2", " ", "fp1", " ", 
           SuperscriptBox["p0", "4"], " ", "s0", " ", 
           SuperscriptBox["t1", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["h0", "2"], " ", "p0", " ", "sp0", " ", 
           SuperscriptBox["t1", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["p0", "3"], " ", "sp0", " ", 
           SuperscriptBox["t1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["h0", "2"], " ", "p0", " ", "sp1", " ", 
           SuperscriptBox["t1", "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["p0", "3"], " ", "sp1", " ", 
           SuperscriptBox["t1", "2"]}], "+", 
          RowBox[{
          "12", " ", "ap1", " ", "h0", " ", "s0", " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"ap1", " ", 
           SuperscriptBox["h0", "3"], " ", "s0", " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"ap1", " ", 
           SuperscriptBox["h0", "5"], " ", "s0", " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"ap1", " ", "h0", " ", 
           SuperscriptBox["p0", "2"], " ", "s0", " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"2", " ", "ap1", " ", 
           SuperscriptBox["h0", "3"], " ", 
           SuperscriptBox["p0", "2"], " ", "s0", " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"ap1", " ", "h0", " ", 
           SuperscriptBox["p0", "4"], " ", "s0", " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"12", " ", "p0", " ", "sp0", " ", "\[CapitalOmega]"}], "+", 
          
          RowBox[{"4", " ", 
           SuperscriptBox["h0", "2"], " ", "p0", " ", "sp0", " ", 
           "\[CapitalOmega]"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["p0", "3"], " ", "sp0", " ", "\[CapitalOmega]"}], 
          "-", 
          RowBox[{"12", " ", "fp1", " ", 
           SuperscriptBox["h0", "2"], " ", "s0", " ", "t1", " ", 
           "\[CapitalOmega]"}], "-", 
          RowBox[{"4", " ", "fp1", " ", 
           SuperscriptBox["h0", "4"], " ", "s0", " ", "t1", " ", 
           "\[CapitalOmega]"}], "-", 
          RowBox[{"12", " ", "fp1", " ", 
           SuperscriptBox["p0", "2"], " ", "s0", " ", "t1", " ", 
           "\[CapitalOmega]"}], "-", 
          RowBox[{"8", " ", "fp1", " ", 
           SuperscriptBox["h0", "2"], " ", 
           SuperscriptBox["p0", "2"], " ", "s0", " ", "t1", " ", 
           "\[CapitalOmega]"}], "-", 
          RowBox[{"4", " ", "fp1", " ", 
           SuperscriptBox["p0", "4"], " ", "s0", " ", "t1", " ", 
           "\[CapitalOmega]"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["h0", "2"], " ", "p0", " ", "sp0", " ", "t1", " ", 
           "\[CapitalOmega]"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["p0", "3"], " ", "sp0", " ", "t1", " ", 
           "\[CapitalOmega]"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["h0", "2"], " ", "p0", " ", "sp1", " ", "t1", " ", 
           "\[CapitalOmega]"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["p0", "3"], " ", "sp1", " ", "t1", " ", 
           "\[CapitalOmega]"}], "+", 
          RowBox[{"2", " ", "fp0", " ", "s0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["h0", "6"], " ", "\[CapitalOmega]"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["p0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    SuperscriptBox["p0", "2"]}], ")"}]}], " ", "t1"}], "+", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    SuperscriptBox["p0", "2"]}], ")"}], "2"], " ", 
                 "\[CapitalOmega]"}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["h0", "4"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "t1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"11", "+", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["p0", "2"]}]}], ")"}], " ", 
                 "\[CapitalOmega]"}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["h0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"6", " ", "t1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"30", "+", 
                   RowBox[{"23", " ", 
                    SuperscriptBox["p0", "2"]}], "+", 
                   RowBox[{"5", " ", 
                    SuperscriptBox["p0", "4"]}]}], ")"}], " ", 
                 "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["a1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "ap0", " ", "p0", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["h0", "4"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["h0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"4", "+", 
                SuperscriptBox["p0", "2"]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["p0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"8", "+", 
                SuperscriptBox["p0", "2"]}], ")"}]}]}], ")"}], " ", "s0"}], 
          "-", 
          RowBox[{"ap1", " ", "p0", " ", "s0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "\[CapitalOmega]"}], "+", 
             RowBox[{
              SuperscriptBox["h0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "t1"}], "+", 
                RowBox[{"3", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["p0", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "t1"}], "+", 
                RowBox[{"3", " ", "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}], 
          "-", 
          RowBox[{"2", " ", "h0", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"fp0", " ", "p0", " ", "s0", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", "\[CapitalOmega]"}], "+", 
                RowBox[{
                 SuperscriptBox["h0", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", "t1"}], "+", 
                   RowBox[{"3", " ", "\[CapitalOmega]"}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["p0", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", "t1"}], "+", 
                   RowBox[{"3", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["h0", "4"], " ", "sp0", " ", 
                 RowBox[{"(", 
                  RowBox[{"t1", "-", "\[CapitalOmega]"}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["p0", "4"], " ", "sp0", " ", 
                 RowBox[{"(", 
                  RowBox[{"t1", "-", "\[CapitalOmega]"}], ")"}]}], "+", 
                RowBox[{"12", " ", "sp0", " ", "\[CapitalOmega]"}], "+", 
                RowBox[{
                 SuperscriptBox["p0", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"sp1", " ", "t1", " ", 
                    RowBox[{"(", 
                    RowBox[{"t1", "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "-", 
                   RowBox[{"sp0", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "3"}], " ", "t1"}], "+", 
                    SuperscriptBox["t1", "2"], "+", "\[CapitalOmega]", "+", 
                    RowBox[{"2", " ", "t1", " ", "\[CapitalOmega]"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["h0", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"sp1", " ", "t1", " ", 
                    RowBox[{"(", 
                    RowBox[{"t1", "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}], "-", 
                   RowBox[{"sp0", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["t1", "2"], "+", "\[CapitalOmega]", "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["p0", "2"], " ", "\[CapitalOmega]"}], "+", 
                    
                    RowBox[{"t1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["p0", "2"]}], "+", 
                    RowBox[{"2", " ", "\[CapitalOmega]"}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
      ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", "s0", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a1", "5"], " ", "h0", " ", "p0", " ", 
          "\[CapitalOmega]"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["p0", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", 
            SuperscriptBox["h0", "2"], "+", 
            SuperscriptBox["p0", "2"]}], ")"}], " ", "\[CapitalOmega]"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a1", "3"], " ", "h0", " ", "p0", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            SuperscriptBox["h0", "2"], "+", 
            SuperscriptBox["p0", "2"]}], ")"}], " ", "\[CapitalOmega]"}], "-", 
         RowBox[{
          SuperscriptBox["a1", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["h0", "2"], " ", "t1"}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "t1"}], "+", "\[CapitalOmega]"}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"8", " ", "a1", " ", "h0", " ", "p0", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "12"}], " ", "\[CapitalOmega]"}], "+", 
            RowBox[{
             SuperscriptBox["h0", "4"], " ", "\[CapitalOmega]"}], "+", 
            RowBox[{
             SuperscriptBox["p0", "4"], " ", "\[CapitalOmega]"}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", "t1"}], "+", "\[CapitalOmega]"}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", "t1"}], "+", "\[CapitalOmega]", "+", 
               
               RowBox[{"2", " ", 
                SuperscriptBox["p0", "2"], " ", "\[CapitalOmega]"}]}], 
              ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["h0", "4"], " ", "t1"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["h0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "t1"}], "+", 
               RowBox[{
                SuperscriptBox["p0", "2"], " ", "\[CapitalOmega]"}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p0", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  SuperscriptBox["p0", "2"]}], ")"}], " ", "t1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4", "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["p0", "2"]}]}], ")"}], " ", 
                "\[CapitalOmega]"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.538983285825459*^9, 3.538983330354681*^9}, {
   3.538983427315576*^9, 3.538983446139784*^9}, 3.538983605454783*^9, {
   3.5389836381128597`*^9, 3.538983662474482*^9}, 3.53898391543221*^9, 
   3.538984080125003*^9, 3.5390008520781107`*^9, 3.53901948831287*^9, 
   3.539019766748941*^9, 3.5390202239289427`*^9, 3.539021388329019*^9, 
   3.539021696645713*^9, 3.5390237317361393`*^9, 3.5390669044558353`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"lineqlist", "/.", "repl"}], ")"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "z0", ",", "0"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538983445715035*^9, 3.53898349705972*^9}, {
  3.538983643471723*^9, 3.538983680961594*^9}, {3.538983731299613*^9, 
  3.5389837316271152`*^9}, {3.538983921007619*^9, 3.538983955662051*^9}, {
  3.5390197366264687`*^9, 3.539019737756143*^9}, {3.539019776315653*^9, 
  3.539019827758791*^9}, {3.539020149255721*^9, 3.5390201516463223`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sol2", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"tmp", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"tp1", ",", "hp1", ",", "sp2", ",", "fp2", ",", "ap2"}], 
      "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538983743202793*^9, 3.53898374952921*^9}, {
  3.538983968597934*^9, 3.538983984747086*^9}, {3.538984053852223*^9, 
  3.5389840620352087`*^9}, {3.5389840983117247`*^9, 3.538984101135662*^9}, {
  3.539021112320141*^9, 3.5390211182712927`*^9}, {3.539021156606632*^9, 
  3.539021169742022*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sol2", "=", 
   RowBox[{"Simplify", "[", "sol2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.539021120388197*^9, 3.539021120750493*^9}, {
  3.539021172757578*^9, 3.539021177393846*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"repl", ",", 
     RowBox[{"sol2", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.539021312078965*^9, 3.539021315502746*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"lineqlist", "/.", "repl"}], ")"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "z0", ",", "0"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.538983998132537*^9, 3.5389840503007383`*^9}, {
  3.539021322641045*^9, 3.539021328886691*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`z, 1, {}, 1, 1, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`z, 1, {}, 1, 1, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`z, 1, {}, 1, 1, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`z, 1, {}, 1, 1, 1],
    Editable->False], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "1"],
    SeriesData[$CellContext`z, 1, {}, 1, 1, 1],
    Editable->False]}], "}"}]], "Output",
 CellChangeTimes->{{3.538984003531003*^9, 3.538984050731885*^9}, {
   3.53902098204729*^9, 3.539020987765522*^9}, 3.539021342518043*^9, 
   3.5390218651222477`*^9, 3.539023793937821*^9, 3.539066963427924*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Save", ":"}]], "Input",
 CellChangeTimes->{{3.539066955418416*^9, 3.539066957703476*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fp", "[", "z_", "]"}], ":=", 
   RowBox[{"fp0", "+", 
    RowBox[{"fp1", 
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
    RowBox[{"fp2", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"fp3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"fp4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hp", "[", "z_", "]"}], ":=", 
   RowBox[{"hp0", "+", 
    RowBox[{"hp1", 
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
    RowBox[{"hp2", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"hp3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"hp4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ap", "[", "z_", "]"}], ":=", 
   RowBox[{"ap0", "+", 
    RowBox[{"ap1", 
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
    RowBox[{"ap2", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"ap3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"ap4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tp", "[", "z_", "]"}], ":=", 
   RowBox[{"tp0", "+", 
    RowBox[{"tp1", 
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
    RowBox[{"tp2", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
    RowBox[{"tp3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
    RowBox[{"tp4", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sp", "[", "z_", "]"}], ":=", 
  RowBox[{"sp0", "+", 
   RowBox[{"sp1", 
    RowBox[{"(", 
     RowBox[{"z", "-", "z0"}], ")"}]}], "+", 
   RowBox[{"sp2", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}], "^", "2"}]}], "+", 
   RowBox[{"sp3", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}], "^", "3"}]}], "+", 
   RowBox[{"sp4", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "z0"}], ")"}], "^", "4"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.539066971726493*^9, 3.5390669900643272`*^9}}],

Cell[BoxData["lineqlist"], "Input",
 CellChangeTimes->{{3.539066958987541*^9, 3.539066960343287*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1468, 935},
WindowMargins->{{35, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "calcgeom"->{
  Cell[41507, 1106, 308, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[41818, 1118, 293, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[42114, 1130, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[42381, 1141, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[42648, 1152, 3569, 101, 139, "Input",
   CellTags->"calcgeom"],
  Cell[46220, 1255, 157, 5, 27, "Input",
   CellTags->"calcgeom"],
  Cell[46584, 1268, 5599, 153, 178, "Input",
   CellTags->"calcgeom"],
  Cell[52186, 1423, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[52331, 1429, 1615, 48, 88, "Input",
   CellTags->"calcgeom"],
  Cell[53949, 1479, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[54094, 1485, 633, 22, 27, "Input",
   CellTags->"calcgeom"],
  Cell[54730, 1509, 1648, 51, 113, "Input",
   CellTags->"calcgeom"],
  Cell[56381, 1562, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[56526, 1568, 145, 4, 27, "Input",
   CellTags->"calcgeom"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"calcgeom", 895887, 24362}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 26, 0, 27, "Input"],
Cell[CellGroupData[{
Cell[596, 24, 822, 11, 46, "Subtitle"],
Cell[CellGroupData[{
Cell[1443, 39, 68, 1, 27, "Input"],
Cell[1514, 42, 404, 6, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1955, 53, 111, 1, 26, "Subsubtitle"],
Cell[2069, 56, 95, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[2189, 62, 279, 8, 58, "Input"],
Cell[2471, 72, 519, 10, 70, "Output"],
Cell[2993, 84, 918, 21, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3948, 110, 266, 9, 58, "Input"],
Cell[4217, 121, 402, 6, 70, "Output"],
Cell[4622, 129, 402, 6, 70, "Output"]
}, Open  ]],
Cell[5039, 138, 407, 13, 27, "Input"],
Cell[5449, 153, 37, 0, 27, "Input"],
Cell[CellGroupData[{
Cell[5511, 157, 257, 8, 58, "Input"],
Cell[5771, 167, 489, 9, 70, "Output"],
Cell[6263, 178, 399, 6, 70, "Output"]
}, Open  ]],
Cell[6677, 187, 2028, 63, 103, "Input"],
Cell[8708, 252, 26, 0, 27, "Input"],
Cell[8737, 254, 841, 25, 43, "Input"],
Cell[9581, 281, 1026, 31, 58, "Input"],
Cell[10610, 314, 227, 8, 86, "Text"],
Cell[10840, 324, 4015, 95, 238, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[14892, 424, 111, 3, 26, "Subsubtitle"],
Cell[15006, 429, 128, 4, 26, "Text"],
Cell[15137, 435, 6139, 139, 718, "Input"],
Cell[21279, 576, 68, 1, 26, "Text"],
Cell[21350, 579, 3727, 84, 523, "Input"],
Cell[25080, 665, 824, 18, 208, "Input"],
Cell[25907, 685, 4051, 89, 583, "Input"],
Cell[29961, 776, 99, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[30097, 783, 34, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[30156, 787, 3296, 67, 173, "Input"],
Cell[33455, 856, 1551, 45, 50, "Output"],
Cell[35009, 903, 464, 8, 27, "Output"],
Cell[35476, 913, 397, 6, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35910, 924, 28, 0, 27, "Input"],
Cell[35941, 926, 1554, 45, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37532, 976, 28, 0, 27, "Input"],
Cell[37563, 978, 2834, 87, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40434, 1070, 119, 3, 27, "Input"],
Cell[40556, 1075, 867, 23, 52, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41472, 1104, 32, 0, 26, "Subsubtitle"],
Cell[41507, 1106, 308, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[41818, 1118, 293, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[42114, 1130, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[42381, 1141, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[42648, 1152, 3569, 101, 139, "Input",
 CellTags->"calcgeom"],
Cell[46220, 1255, 157, 5, 27, "Input",
 CellTags->"calcgeom"],
Cell[46380, 1262, 201, 4, 27, "Input"],
Cell[46584, 1268, 5599, 153, 178, "Input",
 CellTags->"calcgeom"],
Cell[52186, 1423, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[52331, 1429, 1615, 48, 88, "Input",
 CellTags->"calcgeom"],
Cell[53949, 1479, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[54094, 1485, 633, 22, 27, "Input",
 CellTags->"calcgeom"],
Cell[54730, 1509, 1648, 51, 113, "Input",
 CellTags->"calcgeom"],
Cell[56381, 1562, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[56526, 1568, 145, 4, 27, "Input",
 CellTags->"calcgeom"]
}, Closed]],
Cell[CellGroupData[{
Cell[56708, 1577, 41, 0, 26, "Subsubtitle"],
Cell[56752, 1579, 173, 4, 27, "Input"],
Cell[56928, 1585, 645, 21, 27, "Input"],
Cell[57576, 1608, 1146, 34, 118, "Input"],
Cell[58725, 1644, 1792, 51, 118, "Input"],
Cell[60520, 1697, 710, 23, 58, "Input"],
Cell[61233, 1722, 3424, 95, 238, "Input"],
Cell[64660, 1819, 388, 12, 27, "Input"],
Cell[65051, 1833, 434, 10, 27, "Input"],
Cell[65488, 1845, 508, 12, 46, "Input"],
Cell[65999, 1859, 4135, 133, 141, "Input"],
Cell[70137, 1994, 6843, 214, 199, "Input"],
Cell[76983, 2210, 237, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[77245, 2219, 3999, 129, 141, "Input"],
Cell[81247, 2350, 454, 8, 27, "Output"],
Cell[81704, 2360, 452, 8, 27, "Output"],
Cell[82159, 2370, 454, 8, 27, "Output"],
Cell[82616, 2380, 452, 8, 27, "Output"]
}, Open  ]],
Cell[83083, 2391, 1262, 33, 148, "Input"],
Cell[84348, 2426, 1027, 21, 58, "Input"],
Cell[85378, 2449, 677, 17, 58, "Input"],
Cell[86058, 2468, 1027, 30, 118, "Input"],
Cell[87088, 2500, 161, 3, 27, "Input"],
Cell[87252, 2505, 745, 18, 88, "Input"],
Cell[CellGroupData[{
Cell[88022, 2527, 1146, 32, 238, "Input"],
Cell[89171, 2561, 6940, 196, 130, "Output"],
Cell[96114, 2759, 6446, 192, 90, "Output"],
Cell[102563, 2953, 2505, 78, 77, "Output"],
Cell[105071, 3033, 3955, 120, 68, "Output"],
Cell[109029, 3155, 5485, 170, 90, "Output"],
Cell[114517, 3327, 12226, 364, 130, "Output"],
Cell[126746, 3693, 1738, 54, 77, "Output"],
Cell[128487, 3749, 7357, 222, 107, "Output"]
}, Open  ]],
Cell[135859, 3974, 292, 6, 27, "Input"],
Cell[136154, 3982, 2860, 59, 148, "Input"],
Cell[CellGroupData[{
Cell[139039, 4045, 2122, 60, 33, "Input"],
Cell[141164, 4107, 27584, 804, 324, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[168785, 4916, 1438, 41, 33, "Input"],
Cell[170226, 4959, 14479, 423, 152, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[184742, 5387, 1074, 32, 88, "Input"],
Cell[185819, 5421, 401, 6, 27, "Output"],
Cell[186223, 5429, 401, 6, 27, "Output"],
Cell[186627, 5437, 401, 6, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187065, 5448, 1910, 67, 105, "Input"],
Cell[188978, 5517, 1262, 39, 46, "Output"],
Cell[190243, 5558, 1862, 61, 51, "Output"],
Cell[192108, 5621, 11573, 334, 112, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[203718, 5960, 3045, 110, 177, "Input"],
Cell[206766, 6072, 6333, 186, 72, "Output"],
Cell[213102, 6260, 5914, 173, 72, "Output"],
Cell[219019, 6435, 3069, 99, 53, "Output"],
Cell[222091, 6536, 5213, 157, 72, "Output"],
Cell[227307, 6695, 7066, 207, 92, "Output"]
}, Open  ]],
Cell[234388, 6905, 190, 5, 27, "Input"],
Cell[234581, 6912, 1044, 31, 148, "Input"],
Cell[CellGroupData[{
Cell[235650, 6947, 1224, 33, 238, "Input"],
Cell[236877, 6982, 2319, 67, 49, "Output"],
Cell[239199, 7051, 2805, 76, 50, "Output"],
Cell[242007, 7129, 1329, 36, 52, "Output"],
Cell[243339, 7167, 2651, 73, 54, "Output"],
Cell[245993, 7242, 3039, 82, 55, "Output"],
Cell[249035, 7326, 986, 24, 46, "Output"],
Cell[250024, 7352, 1356, 36, 49, "Output"],
Cell[251383, 7390, 3978, 109, 72, "Output"]
}, Open  ]],
Cell[255376, 7502, 1199, 30, 27, "Input"],
Cell[CellGroupData[{
Cell[256600, 7536, 340, 9, 27, "Input"],
Cell[256943, 7547, 484, 8, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[257464, 7560, 311, 8, 27, "Input"],
Cell[257778, 7570, 427, 7, 27, "Output"]
}, Open  ]],
Cell[258220, 7580, 265, 6, 27, "Input"],
Cell[258488, 7588, 663, 22, 46, "Input"],
Cell[CellGroupData[{
Cell[259176, 7614, 1148, 34, 88, "Input"],
Cell[260327, 7650, 3402, 89, 52, "Output"],
Cell[263732, 7741, 585, 17, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[264354, 7763, 425, 13, 27, "Input"],
Cell[264782, 7778, 402, 11, 33, "Output"]
}, Open  ]],
Cell[265199, 7792, 288, 6, 27, "Input"],
Cell[265490, 7800, 1113, 35, 109, "Input"],
Cell[CellGroupData[{
Cell[266628, 7839, 2570, 76, 256, "Input"],
Cell[269201, 7917, 2759, 72, 52, "Output"],
Cell[271963, 7991, 1346, 38, 51, "Output"],
Cell[273312, 8031, 729, 20, 49, "Output"],
Cell[274044, 8053, 669, 18, 49, "Output"],
Cell[274716, 8073, 573, 14, 30, "Output"],
Cell[275292, 8089, 500, 13, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[275829, 8107, 815, 25, 58, "Input"],
Cell[276647, 8134, 894, 22, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[277578, 8161, 816, 25, 58, "Input"],
Cell[278397, 8188, 988, 26, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[279422, 8219, 1157, 20, 238, "Input"],
Cell[280582, 8241, 1088, 16, 221, "Print"]
}, Open  ]],
Cell[281685, 8260, 288, 6, 27, "Input"],
Cell[281976, 8268, 1366, 41, 109, "Input"],
Cell[CellGroupData[{
Cell[283367, 8313, 644, 20, 58, "Input"],
Cell[284014, 8335, 1348, 35, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[285399, 8375, 451, 9, 27, "Input"],
Cell[285853, 8386, 156, 2, 20, "Print"]
}, Open  ]],
Cell[286024, 8391, 265, 6, 27, "Input"],
Cell[286292, 8399, 663, 22, 46, "Input"],
Cell[CellGroupData[{
Cell[286980, 8425, 1957, 54, 118, "Input"],
Cell[288940, 8481, 4841, 119, 93, "Output"],
Cell[293784, 8602, 1096, 28, 50, "Output"],
Cell[294883, 8632, 613, 14, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[295533, 8651, 1697, 50, 118, "Input"],
Cell[297233, 8703, 3729, 96, 52, "Output"],
Cell[300965, 8801, 611, 18, 50, "Output"],
Cell[301579, 8821, 92, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[301708, 8827, 534, 16, 27, "Input"],
Cell[302245, 8845, 352, 10, 33, "Output"]
}, Open  ]],
Cell[302612, 8858, 1064, 34, 109, "Input"],
Cell[CellGroupData[{
Cell[303701, 8896, 3043, 87, 256, "Input"],
Cell[306747, 8985, 2794, 69, 52, "Output"],
Cell[309544, 9056, 463, 6, 27, "Output"],
Cell[310010, 9064, 463, 6, 27, "Output"],
Cell[310476, 9072, 694, 13, 30, "Output"],
Cell[311173, 9087, 707, 14, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[311917, 9106, 1152, 33, 58, "Input"],
Cell[313072, 9141, 975, 24, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[314084, 9170, 1128, 33, 58, "Input"],
Cell[315215, 9205, 1213, 31, 30, "Output"]
}, Open  ]],
Cell[316443, 9239, 1483, 26, 238, "Input"],
Cell[317929, 9267, 2034, 58, 148, "Input"],
Cell[319966, 9327, 2694, 77, 238, "Input"],
Cell[CellGroupData[{
Cell[322685, 9408, 2426, 72, 238, "Input"],
Cell[325114, 9482, 455, 6, 27, "Output"],
Cell[325572, 9490, 453, 6, 27, "Output"],
Cell[326028, 9498, 453, 6, 27, "Output"],
Cell[326484, 9506, 452, 6, 27, "Output"],
Cell[326939, 9514, 453, 6, 27, "Output"],
Cell[327395, 9522, 455, 6, 27, "Output"],
Cell[327853, 9530, 453, 6, 27, "Output"],
Cell[328309, 9538, 453, 6, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[328799, 9549, 1813, 50, 238, "Input"],
Cell[330615, 9601, 7947, 203, 108, "Output"],
Cell[338565, 9806, 8034, 213, 90, "Output"],
Cell[346602, 10021, 7348, 188, 92, "Output"],
Cell[353953, 10211, 1883, 50, 46, "Output"],
Cell[355839, 10263, 2994, 80, 55, "Output"],
Cell[358836, 10345, 3422, 88, 99, "Output"],
Cell[362261, 10435, 8252, 223, 128, "Output"],
Cell[370516, 10660, 14689, 381, 172, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[385242, 11046, 150, 2, 27, "Input"],
Cell[385395, 11050, 96, 1, 20, "Print"]
}, Open  ]],
Cell[385506, 11054, 1702, 57, 167, "Input"],
Cell[CellGroupData[{
Cell[387233, 11115, 3065, 97, 238, "Input"],
Cell[390301, 11214, 246, 4, 27, "Output"],
Cell[390550, 11220, 243, 4, 27, "Output"],
Cell[390796, 11226, 243, 4, 27, "Output"],
Cell[391042, 11232, 242, 4, 27, "Output"],
Cell[391287, 11238, 246, 4, 27, "Output"],
Cell[391536, 11244, 244, 4, 27, "Output"],
Cell[391783, 11250, 244, 4, 27, "Output"],
Cell[392030, 11256, 244, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[392311, 11265, 154, 2, 27, "Input"],
Cell[392468, 11269, 99, 1, 20, "Print"]
}, Open  ]],
Cell[392582, 11273, 1072, 31, 148, "Input"],
Cell[CellGroupData[{
Cell[393679, 11308, 2900, 94, 238, "Input"],
Cell[396582, 11404, 120, 2, 27, "Output"],
Cell[396705, 11408, 120, 2, 27, "Output"],
Cell[396828, 11412, 120, 2, 27, "Output"],
Cell[396951, 11416, 122, 2, 27, "Output"],
Cell[397076, 11420, 120, 2, 27, "Output"],
Cell[397199, 11424, 122, 2, 27, "Output"],
Cell[397324, 11428, 120, 2, 27, "Output"],
Cell[397447, 11432, 120, 2, 27, "Output"]
}, Open  ]],
Cell[397582, 11437, 183, 4, 27, "Input"],
Cell[397768, 11443, 1053, 28, 27, "Input"],
Cell[398824, 11473, 981, 31, 27, "Input"],
Cell[399808, 11506, 138, 2, 27, "Input"],
Cell[399949, 11510, 217, 6, 27, "Input"],
Cell[CellGroupData[{
Cell[400191, 11520, 3657, 112, 148, "Input"],
Cell[403851, 11634, 6956, 195, 99, "Output"],
Cell[410810, 11831, 1034, 25, 49, "Output"],
Cell[411847, 11858, 1363, 35, 51, "Output"],
Cell[413213, 11895, 3084, 88, 51, "Output"],
Cell[416300, 11985, 858, 20, 51, "Output"]
}, Open  ]],
Cell[417173, 12008, 216, 6, 27, "Input"],
Cell[CellGroupData[{
Cell[417414, 12018, 3182, 91, 148, "Input"],
Cell[420599, 12111, 20840, 567, 292, "Output"],
Cell[441442, 12680, 2453, 75, 55, "Output"],
Cell[443898, 12757, 3812, 114, 54, "Output"],
Cell[447713, 12873, 8915, 259, 143, "Output"],
Cell[456631, 13134, 2368, 72, 51, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[459048, 13212, 93, 1, 26, "Subsubtitle"],
Cell[459144, 13215, 159, 4, 27, "Input"],
Cell[459306, 13221, 53329, 1452, 1209, "Input"],
Cell[512638, 14675, 1702, 57, 167, "Input"],
Cell[CellGroupData[{
Cell[514365, 14736, 1349, 40, 148, "Input"],
Cell[515717, 14778, 460, 13, 30, "Output"],
Cell[516180, 14793, 458, 13, 30, "Output"],
Cell[516641, 14808, 446, 13, 30, "Output"],
Cell[517090, 14823, 428, 13, 30, "Output"],
Cell[517521, 14838, 403, 12, 30, "Output"]
}, Open  ]],
Cell[517939, 14853, 505, 12, 88, "Input"],
Cell[518447, 14867, 2693, 88, 167, "Input"],
Cell[521143, 14957, 157, 4, 27, "Input"],
Cell[CellGroupData[{
Cell[521325, 14965, 951, 26, 88, "Input"],
Cell[522279, 14993, 2287, 62, 49, "Output"],
Cell[524569, 15057, 662, 12, 23, "Message"],
Cell[525234, 15071, 652, 12, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[525923, 15088, 842, 25, 88, "Input"],
Cell[526768, 15115, 1897, 53, 33, "Output"],
Cell[528668, 15170, 517, 12, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[529222, 15187, 860, 25, 88, "Input"],
Cell[530085, 15214, 3726, 100, 33, "Output"],
Cell[533814, 15316, 1547, 41, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[535398, 15362, 880, 26, 88, "Input"],
Cell[536281, 15390, 5984, 149, 127, "Output"],
Cell[542268, 15541, 2651, 71, 84, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[544956, 15617, 882, 26, 88, "Input"],
Cell[545841, 15645, 9631, 232, 178, "Output"],
Cell[555475, 15879, 5067, 133, 121, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[560579, 16017, 878, 26, 88, "Input"],
Cell[561460, 16045, 17559, 400, 262, "Output"],
Cell[579022, 16447, 9967, 250, 235, "Output"]
}, Open  ]],
Cell[589004, 16700, 342, 8, 58, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[589383, 16713, 143, 2, 26, "Subsubtitle"],
Cell[589529, 16717, 211, 5, 27, "Input"],
Cell[589743, 16724, 3249, 99, 208, "Input"],
Cell[592995, 16825, 197464, 4849, 3464, "Input"],
Cell[790462, 21676, 136, 3, 27, "Input"],
Cell[790601, 21681, 1702, 57, 167, "Input"],
Cell[CellGroupData[{
Cell[792328, 21742, 1303, 39, 148, "Input"],
Cell[793634, 21783, 585, 18, 46, "Output"],
Cell[794222, 21803, 587, 18, 46, "Output"],
Cell[794812, 21823, 441, 13, 30, "Output"],
Cell[795256, 21838, 569, 17, 30, "Output"],
Cell[795828, 21857, 850, 26, 51, "Output"]
}, Open  ]],
Cell[796693, 21886, 184, 4, 27, "Input"],
Cell[796880, 21892, 2838, 99, 148, "Input"],
Cell[799721, 21993, 157, 4, 27, "Input"],
Cell[CellGroupData[{
Cell[799903, 22001, 989, 27, 88, "Input"],
Cell[800895, 22030, 19618, 448, 343, "Output"],
Cell[820516, 22480, 34728, 831, 392, "Output"],
Cell[855247, 23313, 33957, 828, 412, "Output"]
}, Open  ]],
Cell[889219, 24144, 616, 13, 27, "Input"],
Cell[889838, 24159, 576, 13, 27, "Input"],
Cell[890417, 24174, 224, 5, 27, "Input"],
Cell[890644, 24181, 257, 7, 27, "Input"],
Cell[CellGroupData[{
Cell[890926, 24192, 360, 9, 27, "Input"],
Cell[891289, 24203, 1192, 35, 33, "Output"]
}, Open  ]],
Cell[892496, 24241, 113, 2, 27, "Input"],
Cell[892612, 24245, 2838, 99, 148, "Input"],
Cell[895453, 24346, 101, 1, 27, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
