(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     34155,        666]
NotebookOptionsPosition[     33307,        631]
NotebookOutlinePosition[     33662,        647]
CellTagsIndexPosition[     33619,        644]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"pfn", "=", 
   RowBox[{"amp2", "*", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "w"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"v", "-", "v0"}], ")"}], "^", "2"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.543901834331881*^9, 3.543901868023095*^9}, {
   3.54390197177392*^9, 3.5439019936361837`*^9}, {3.5439850602687263`*^9, 
   3.5439850736015778`*^9}, {3.544273945485096*^9, 3.544273945611615*^9}, {
   3.5442748901750517`*^9, 3.544274911428752*^9}, {3.544283423856588*^9, 
   3.5442834265275593`*^9}, 3.544340633119605*^9, {3.5443424172775793`*^9, 
   3.5443424173493633`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dpfn", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"pfn", ",", "v"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ddpfn", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"pfn", ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.543901916277363*^9, 3.543901937933576*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp1", "=", 
  RowBox[{"CForm", "[", 
   RowBox[{"pfn", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
       RowBox[{"exp", "[", "x", "]"}]}], ",", 
      RowBox[{
       RowBox[{"Power", "[", 
        RowBox[{"x_", ",", "n_"}], "]"}], "\[Rule]", 
       RowBox[{"power", "[", 
        RowBox[{"x", ",", "n"}], "]"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.54390186940044*^9, 3.5439019053278503`*^9}, {
  3.544340656718481*^9, 3.54434065785329*^9}}],

Cell["amp2*exp(-(w*power(v - v0,2)))", "Output",
 CellChangeTimes->{{3.543901885386456*^9, 3.5439019057058973`*^9}, 
   3.543901943952736*^9, 3.5439019955653763`*^9, {3.543985062924209*^9, 
   3.543985075364295*^9}, 3.544273948122262*^9, {3.544274892563508*^9, 
   3.544274913057428*^9}, 3.544283428914639*^9, {3.544340634882333*^9, 
   3.5443406583614264`*^9}, {3.544342419270084*^9, 3.544342431386704*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp2", "=", 
  RowBox[{"CForm", "[", 
   RowBox[{"dpfn", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
       RowBox[{"exp", "[", "x", "]"}]}], ",", 
      RowBox[{
       RowBox[{"Power", "[", 
        RowBox[{"x_", ",", "n_"}], "]"}], "\[Rule]", 
       RowBox[{"power", "[", 
        RowBox[{"x", ",", "n"}], "]"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.543901948406432*^9, {3.544340659117461*^9, 3.544340659573092*^9}}],

Cell["-2*amp2*(v - v0)*w*exp(-(w*power(v - v0,2)))", "Output",
 CellChangeTimes->{
  3.5439019505772448`*^9, 3.5439019962163267`*^9, {3.543985063642034*^9, 
   3.5439850759488*^9}, 3.544273948720685*^9, {3.54427489311406*^9, 
   3.544274913538115*^9}, 3.5442834296469927`*^9, {3.544340635449418*^9, 
   3.544340660064966*^9}, {3.54434241987282*^9, 3.544342431926774*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp3", "=", 
  RowBox[{"CForm", "[", 
   RowBox[{"ddpfn", "//.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", "x_", "]"}], "\[Rule]", 
       RowBox[{"exp", "[", "x", "]"}]}], ",", 
      RowBox[{
       RowBox[{"Power", "[", 
        RowBox[{"x_", ",", "n_"}], "]"}], "\[Rule]", 
       RowBox[{"power", "[", 
        RowBox[{"x", ",", "n"}], "]"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5439019495335407`*^9, 3.543901949725443*^9}, {
  3.544340660725635*^9, 3.544340661253285*^9}}],

Cell["\<\
2*amp2*w*exp(-(w*power(v - v0,2)))*(-1 - 4*v*v0*w + 2*w*power(v,2) + \
2*w*power(v0,2))\
\>", "Output",
 CellChangeTimes->{
  3.543901951211647*^9, 3.543901997035331*^9, {3.543985064344914*^9, 
   3.5439850765675163`*^9}, 3.544273949347768*^9, {3.544274893665555*^9, 
   3.54427491409247*^9}, 3.544283430264969*^9, {3.544340636034582*^9, 
   3.544340661760343*^9}, {3.544342420487844*^9, 3.544342432527997*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"pfn", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"amp2", "\[Rule]", "1"}], ",", 
      RowBox[{"w", "\[Rule]", "30"}], ",", 
      RowBox[{"v0", "\[Rule]", "1"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.54390197509076*^9, 3.543901986778469*^9}, 
   3.543985068050795*^9, {3.544283434663292*^9, 3.544283450591001*^9}, {
   3.54428350145332*^9, 3.544283514388657*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c8198XNipS2RFJUklWvojI+x4zkpndkGRkz0KJkFFmNpGMhOw9smfZ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 2}, {0., 0.9999992891703616}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.5439019875274267`*^9, 3.543901997685913*^9}, {
   3.5439850655324907`*^9, 3.543985077186042*^9}, 3.544273950303146*^9, {
   3.544274894283231*^9, 3.544274914592299*^9}, {3.544283431352194*^9, 
   3.544283453076893*^9}, {3.544283503347686*^9, 3.544283514875812*^9}, {
   3.544340636689093*^9, 3.544340663682283*^9}, {3.544342421081615*^9, 
   3.544342433171768*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<\\n*p = \>\"", "<>", 
  RowBox[{"ToString", "[", "tmp1", "]"}], "<>", "\"\< ;\\n*pv = \>\"", "<>", 
  RowBox[{"ToString", "[", "tmp2", "]"}], "<>", "\"\< ;\\n*pvv = \>\"", "<>", 
  
  RowBox[{"ToString", "[", "tmp3", "]"}], "<>", "\"\< ;\\n\>\""}]], "Input",
 CellChangeTimes->{{3.544340665908399*^9, 3.544340715315832*^9}, {
  3.5443407583089647`*^9, 3.544340773442754*^9}}],

Cell[BoxData["\<\"\\n*p = amp2*exp(-(w*power(v - v0,2))) ;\\n*pv = -2*amp2*(v \
- v0)*w*exp(-(w*power(v - v0,2))) ;\\n*pvv = 2*amp2*w*exp(-(w*power(v - \
v0,2)))*(-1 - 4*v*v0*w + 2*w*power(v,2) + 2*w*power(v0,2)) ;\\n\"\>"], \
"Output",
 CellChangeTimes->{{3.544340668347755*^9, 3.5443407156080112`*^9}, {
  3.544340767491213*^9, 3.544340773719681*^9}, {3.544342421973425*^9, 
  3.544342433813047*^9}}]
}, Open  ]]
},
WindowSize->{1089, 804},
WindowMargins->{{Automatic, 1}, {Automatic, 39}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 661, 16, 27, "Input"],
Cell[1221, 38, 496, 15, 58, "Input"],
Cell[CellGroupData[{
Cell[1742, 57, 549, 15, 27, "Input"],
Cell[2294, 74, 408, 5, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2739, 84, 526, 15, 27, "Input"],
Cell[3268, 101, 371, 5, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3676, 111, 553, 15, 27, "Input"],
Cell[4232, 128, 421, 8, 39, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4690, 141, 517, 13, 27, "Input"],
Cell[5210, 156, 27236, 452, 243, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32483, 613, 403, 7, 27, "Input"],
Cell[32889, 622, 402, 6, 88, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
