(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    885434,      23794]
NotebookOptionsPosition[    873420,      23429]
NotebookOutlinePosition[    874777,      23477]
CellTagsIndexPosition[    874703,      23472]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Dynamic AdS/CMT - Superconductor - Spectral - Numerial Ansatz III

Perturb both Re and Im scalar\
\>", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.507011572545054*^9, 3.460340667971311*^9}, {
   3.5374843541262083`*^9, 3.537484358716886*^9}, 3.537484391202265*^9, {
   3.537484629914453*^9, 3.537484630281348*^9}, {3.5374893532274837`*^9, 
   3.537489358050692*^9}, {3.53749388933057*^9, 3.537493890193932*^9}, {
   3.537578587160997*^9, 3.5375785895997057`*^9}, {3.537578682265374*^9, 
   3.537578682504321*^9}, {3.537578812305402*^9, 3.537578812720454*^9}, {
   3.544806283808758*^9, 3.544806292054955*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"hmm\"\>"], "Print",
 CellChangeTimes->{3.53880794268043*^9, 3.54386945932994*^9, 
  3.544342627214196*^9, 3.5443443860028276`*^9, 3.5443535776805277`*^9, 
  3.544459104318214*^9, 3.544806310285573*^9, 3.54480882144156*^9, 
  3.544809247491901*^9, 3.54480943980269*^9, 3.544809657278253*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
   "gzz"}], "}"}]], "Output",
 CellChangeTimes->{3.538807942880889*^9, 3.54386945943898*^9, 
  3.5443426274794292`*^9, 3.5443443862976*^9, 3.544353577883421*^9, 
  3.5444591045019493`*^9, 3.54480631035143*^9, 3.544808821591486*^9, 
  3.5448092476580343`*^9, 3.544809439871038*^9, 3.5448096574599037`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gtt", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "grr", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "g\[Theta]\[Theta]", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "g\[Phi]\[Phi]", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "gzz"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807942880889*^9, 3.54386945943898*^9, 
  3.5443426274794292`*^9, 3.5443443862976*^9, 3.544353577883421*^9, 
  3.5444591045019493`*^9, 3.54480631035143*^9, 3.544808821591486*^9, 
  3.5448092476580343`*^9, 3.544809439871038*^9, 3.5448096574615803`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{3.538807942964953*^9, 3.543869459599666*^9, 
  3.5443426275436497`*^9, 3.544344386336905*^9, 3.544353577964192*^9, 
  3.544459104545328*^9, 3.544806310503228*^9, 3.544808821651659*^9, 
  3.5448092477418222`*^9, 3.544809439923482*^9, 3.544809657502386*^9}],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{3.538807942964953*^9, 3.543869459599666*^9, 
  3.5443426275436497`*^9, 3.544344386336905*^9, 3.544353577964192*^9, 
  3.544459104545328*^9, 3.544806310503228*^9, 3.544808821651659*^9, 
  3.5448092477418222`*^9, 3.544809439923482*^9, 3.544809657503888*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807943254242*^9, 3.54386945993823*^9, 
  3.5443426279009666`*^9, 3.544344386597836*^9, 3.544353578270753*^9, 
  3.544459104839386*^9, 3.544806310625499*^9, 3.5448088228933287`*^9, 
  3.5448092479252663`*^9, 3.544809440171104*^9, 3.544809657626337*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{3.538807943254242*^9, 3.54386945993823*^9, 
  3.5443426279009666`*^9, 3.544344386597836*^9, 3.544353578270753*^9, 
  3.544459104839386*^9, 3.544806310625499*^9, 3.5448088228933287`*^9, 
  3.5448092479252663`*^9, 3.544809440171104*^9, 3.5448096576278353`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"-", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "0", "0"},
       {
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}], "0"},
       {"0", "0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.507011580676421*^9, 3.507011659804162*^9}, {3.507013755598536*^9, 
   3.460392698323369*^9}, {3.4604018613321533`*^9, 3.4604018646719627`*^9}, {
   3.460401965632374*^9, 3.460401968163259*^9}, {3.4604023388162813`*^9, 
   3.4604023558966084`*^9}, {3.460402422665003*^9, 3.460402426690833*^9}, {
   3.460402628586185*^9, 3.4604026419139843`*^9}, {3.460402674350209*^9, 
   3.4604026844332027`*^9}, {3.460512773931822*^9, 3.460512787444798*^9}, {
   3.4605146484667263`*^9, 3.460514650350994*^9}, {3.460514717258254*^9, 
   3.460514724283691*^9}, 3.460514770989304*^9, 3.4605223140457373`*^9, {
   3.4605327188171663`*^9, 3.460532727004561*^9}, {3.460532863547011*^9, 
   3.460532865145266*^9}, {3.460532977769042*^9, 3.4605329860852757`*^9}, {
   3.507275497143169*^9, 3.4603659980232763`*^9}, {3.537484515197036*^9, 
   3.537484572210073*^9}, 3.537484644682625*^9, {3.5374846959240923`*^9, 
   3.537484701892157*^9}, {3.537484976337736*^9, 3.5374849917355137`*^9}, {
   3.537486594817341*^9, 3.537486596777007*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     FractionBox[
      RowBox[{"gzz", "[", 
       RowBox[{"v", ",", "z"}], "]"}], 
      SuperscriptBox["z", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.543869460369071*^9, 
  3.544342628431478*^9, 3.5443443871821747`*^9, 3.544353578853538*^9, 
  3.544459105324402*^9, 3.5448063110915623`*^9, 3.544808823590951*^9, 
  3.5448092484162197`*^9, 3.54480944059111*^9, 3.5448096581792717`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.543869460369071*^9, 
  3.544342628431478*^9, 3.5443443871821747`*^9, 3.544353578853538*^9, 
  3.544459105324402*^9, 3.5448063110915623`*^9, 3.544808823590951*^9, 
  3.5448092484162197`*^9, 3.54480944059111*^9, 3.544809658182171*^9}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.543869460369071*^9, 
  3.544342628431478*^9, 3.5443443871821747`*^9, 3.544353578853538*^9, 
  3.544459105324402*^9, 3.5448063110915623`*^9, 3.544808823590951*^9, 
  3.5448092484162197`*^9, 3.54480944059111*^9, 3.544809658184122*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     FractionBox[
      RowBox[{"gzz", "[", 
       RowBox[{"v", ",", "z"}], "]"}], 
      SuperscriptBox["z", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807943934894*^9, 3.5438694604482927`*^9, 
  3.54434262849561*^9, 3.544344387245637*^9, 3.5443535789502773`*^9, 
  3.544459105502936*^9, 3.5448063111295633`*^9, 3.544808823693492*^9, 
  3.54480924845751*^9, 3.54480944063028*^9, 3.544809658218964*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
       RowBox[{
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["z", "2"], 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["z", "2"], 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807944009327*^9, 3.543869460487749*^9, 
  3.544342628531184*^9, 3.54434438727798*^9, 3.544353579009232*^9, 
  3.54445910556271*^9, 3.54480631117802*^9, 3.544808823736609*^9, 
  3.544809248499475*^9, 3.544809440672947*^9, 3.5448096582656193`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
      RowBox[{
       RowBox[{"gzz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   SuperscriptBox["z", "8"]]}]], "Output",
 CellChangeTimes->{3.538807944075788*^9, 3.5438694606321898`*^9, 
  3.544342628566908*^9, 3.5443443873252087`*^9, 3.54435357905252*^9, 
  3.5444591055959873`*^9, 3.5448063112078047`*^9, 3.5448088237858543`*^9, 
  3.544809248550033*^9, 3.5448094407251*^9, 3.54480965832548*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{"Simplify", "[", "R2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041067188341103`*^9, 3.404106720182616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"GT", "[", 
       RowBox[{"R2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "A", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"A", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"v", ",", "d"}], "}"}], "}"}], ",", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"ST", "[", 
    RowBox[{"A", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"z", ",", "d"}], "}"}], "}"}], ",", 
     RowBox[{"az", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451383976248069*^9, 3.4513840125908737`*^9}, {
  3.451384057147691*^9, 3.451384064689735*^9}, {3.451385762395092*^9, 
  3.451385762480318*^9}, {3.451385800913571*^9, 3.451385805770357*^9}, {
  3.537484677141605*^9, 3.53748468964509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "F", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"F", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"F", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i1", "]"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4041040239360247`*^9, 3.404104073416904*^9}, {
  3.4041057167733383`*^9, 3.4041057183570337`*^9}, {3.4513840707957897`*^9, 
  3.451384164343499*^9}, {3.460366100458836*^9, 3.460366108909464*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"trFF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"trT", "[", 
      RowBox[{
       RowBox[{"outerT", "[", 
        RowBox[{"F", ",", "F"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fsqr", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"trT", "[", 
     RowBox[{"trFF", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.404103126230957*^9, 3.404103206051724*^9}, 
   3.404103788928409*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "Dp", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"Dp", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Dp", "=", 
       RowBox[{"ST", "[", 
        RowBox[{"Dp", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[Phi]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
          RowBox[{"2", "I", " ", 
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], 
           RowBox[{"\[Phi]", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConjDp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"Conjugate", "[", 
       RowBox[{"Dp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DpDp", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"trT", "[", 
       RowBox[{
        RowBox[{"outerT", "[", 
         RowBox[{"ConjDp", ",", "Dp"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Vterm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Phi]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "]"}], 
       RowBox[{"\[Phi]", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513844331121693`*^9, 3.451384521665413*^9}, {
   3.451384560554626*^9, 3.451384642158163*^9}, {3.4513849100950413`*^9, 
   3.451384915054587*^9}, 3.451385051803838*^9, {3.4513851171366262`*^9, 
   3.45138511927711*^9}, {3.451385175930884*^9, 3.451385183167452*^9}, {
   3.451385425505906*^9, 3.45138544324051*^9}, {3.451385490350021*^9, 
   3.451385493946774*^9}, {3.451385568392873*^9, 3.451385601054823*^9}, {
   3.451385813165941*^9, 3.4513858527683163`*^9}, {3.45138608116168*^9, 
   3.451386103913107*^9}, {3.46036707784975*^9, 3.460255762501432*^9}, {
   3.46025580130457*^9, 3.460255801461816*^9}, {3.53748492894665*^9, 
   3.53748495518618*^9}, {3.537485329580826*^9, 3.537485331297533*^9}, 
   3.543869463106576*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DpDp", "=", 
   RowBox[{"(", 
    RowBox[{"DpDp", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", "xx_", "]"}], "\[Rule]", "xx"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", "xx_", "]"}], "\[Rule]", "0"}]}], "}"}]}], ")"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.451385894732107*^9, 3.451385976334114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrtdetg", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"-", 
       RowBox[{"Det", "[", "Gd", "]"}]}], "]"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.4041041692972*^9, 3.404104211096949*^9}, 
   3.404105293940057*^9, {3.4513842180130997`*^9, 3.4513842223260803`*^9}, {
   3.4513846617079067`*^9, 3.451384675916638*^9}, {3.544809452628047*^9, 
   3.54480945934698*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"sqrtdetg", 
    RowBox[{"(", 
     RowBox[{"Ricci", "+", "6", "-", 
      RowBox[{
       FractionBox["1", "4"], "Fsqr"}], "-", "DpDp", "-", "Vterm"}], 
     ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.451384367735067*^9, 3.451384393946628*^9}, {
   3.4513849054437723`*^9, 3.4513849068431387`*^9}, {3.451385606138598*^9, 
   3.451385607193993*^9}, 3.460366276193363*^9, {3.4603670917067547`*^9, 
   3.460255829896731*^9}, 3.537493905932642*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.53748653613297*^9, 3.5374865918283*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GHBT", "+=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
     "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460366441552243*^9, 3.460366544772176*^9}, {
  3.4603665879440317`*^9, 3.460366626391823*^9}, {3.537486655723679*^9, 
  3.537486732610427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L", "-", "GHBT"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460366546941235*^9, 3.460366557341961*^9}, 
   3.460366686117609*^9, {3.4603672960654507`*^9, 3.4603672977104673`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"L2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.460366666517003*^9, 3.460366674775579*^9}, {3.537486746662644*^9, 
  3.5374867639666147`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.543869500041778*^9, 
  3.544342632498914*^9, 3.5443443914021807`*^9, 3.544353582854992*^9, 
  3.544459109409883*^9, 3.5448063149261293`*^9, 3.544808827669531*^9, 
  3.544809252335195*^9, 3.544809467437072*^9, 3.544809662150537*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.543869500041778*^9, 
  3.544342632498914*^9, 3.5443443914021807`*^9, 3.544353582854992*^9, 
  3.544459109409883*^9, 3.5448063149261293`*^9, 3.544808827669531*^9, 
  3.544809252335195*^9, 3.544809467437072*^9, 3.544809662153013*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.543869500041778*^9, 
  3.544342632498914*^9, 3.5443443914021807`*^9, 3.544353582854992*^9, 
  3.544459109409883*^9, 3.5448063149261293`*^9, 3.544808827669531*^9, 
  3.544809252335195*^9, 3.544809467437072*^9, 3.544809662188561*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.543869500041778*^9, 
  3.544342632498914*^9, 3.5443443914021807`*^9, 3.544353582854992*^9, 
  3.544459109409883*^9, 3.5448063149261293`*^9, 3.544808827669531*^9, 
  3.544809252335195*^9, 3.544809467437072*^9, 3.544809662245364*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"EOM", "[", "fld_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{"D", "[", 
      RowBox[{"L2", ",", "fld"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"tmp2", "=", 
           RowBox[{"D", "[", 
            RowBox[{"fld", ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ")"}], "=!=", "0"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "-=", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"L2", ",", "tmp2"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "tmp"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.4513849546200113`*^9, 3.451385039242148*^9}, {
  3.4603662728020573`*^9, 3.460366273871294*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqp", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"p", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513848144544163`*^9, 3.4513848150159073`*^9}, {
  3.451384869337384*^9, 3.451384875673843*^9}, {3.451384929950244*^9, 
  3.451384930100154*^9}, {3.451385060851385*^9, 3.451385213396349*^9}, {
  3.451385293160893*^9, 3.451385302528058*^9}, {3.4513853749547167`*^9, 
  3.45138537639461*^9}, {3.451385514552088*^9, 3.451385527943191*^9}, {
  3.451385862306609*^9, 3.451385882826736*^9}, {3.451386138230373*^9, 
  3.451386140019012*^9}, {3.451386241895258*^9, 3.4513862693654633`*^9}, {
  3.4603675858592987`*^9, 3.4603675914720583`*^9}, {3.537486779881022*^9, 
  3.537486784922683*^9}, {3.537486894453556*^9, 3.5374869009568243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqav", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"av", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"az", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513855403702793`*^9, 3.451385540823719*^9}, {
  3.4513861532442207`*^9, 3.45138616739637*^9}, {3.451386251199284*^9, 
  3.4513862656960487`*^9}, {3.460367593073217*^9, 3.460367597640524*^9}, {
  3.5374867866028214`*^9, 3.537486788378339*^9}, {3.537486891597521*^9, 
  3.537486937732339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqgvz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gvz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqgzz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gzz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqT", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"T", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqS", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451386275930722*^9, 3.451386303859261*^9}, {
  3.460366711720347*^9, 3.4603667226381903`*^9}, {3.460367599130735*^9, 
  3.460367611985876*^9}, {3.53748678993122*^9, 3.53748680663302*^9}, {
  3.537486911477583*^9, 3.5374869187572203`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"gvz", ",", "gzz", ",", "az"}], "]"}]], "Input",
 CellChangeTimes->{{3.53748694036823*^9, 3.537486945275868*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gvz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gzz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"az", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.460366755240944*^9, 3.460366765921853*^9}, {
   3.460379717667384*^9, 3.460379720321673*^9}, {3.4603938524268913`*^9, 
   3.4603938546559877`*^9}, 3.4603939628549967`*^9, {3.5374868640225983`*^9, 
   3.537486876197587*^9}, {3.537486924492758*^9, 3.537486925572747*^9}, {
   3.537487030062772*^9, 3.537487030117689*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"eqp", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"S", "[", 
         RowBox[{"v", ",", "z"}], "]"}], ">", "0"}], ",", 
       RowBox[{"z", ">", "0"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"eq\[Alpha]", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"S", "[", 
         RowBox[{"v", ",", "z"}], "]"}], ">", "0"}], ",", 
       RowBox[{"z", ">", "0"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqav2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"eqav", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"S", "[", 
         RowBox[{"v", ",", "z"}], "]"}], ">", "0"}], ",", 
       RowBox[{"z", ">", "0"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"eqaz", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"S", "[", 
         RowBox[{"v", ",", "z"}], "]"}], ">", "0"}], ",", 
       RowBox[{"z", ">", "0"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgvz2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"eqgvz", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"S", "[", 
         RowBox[{"v", ",", "z"}], "]"}], ">", "0"}], ",", 
       RowBox[{"z", ">", "0"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgzz2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"eqgzz", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"S", "[", 
         RowBox[{"v", ",", "z"}], "]"}], ">", "0"}], ",", 
       RowBox[{"z", ">", "0"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqT2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"eqT", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"S", "[", 
         RowBox[{"v", ",", "z"}], "]"}], ">", "0"}], ",", 
       RowBox[{"z", ">", "0"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"eqS2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"eqS", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ">", "0"}], ",", 
      RowBox[{"z", ">", "0"}]}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.460366768598325*^9, 3.4603668525536737`*^9}, {
  3.5374869590367947`*^9, 3.537486972220312*^9}, {3.544809259836875*^9, 
  3.54480930243851*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SuperscriptBox["z", "4"]], 
  RowBox[{"2", " ", 
   RowBox[{"S", "[", 
    RowBox[{"v", ",", "z"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"p", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "z"}], " ", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"S", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Alpha]", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "-", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "z", " ", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["av", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{
                SuperscriptBox["p", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["p", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.5388079500961*^9, 3.5438695004606524`*^9, 3.544342632883522*^9, 
   3.544344391825632*^9, 3.544353583285541*^9, 3.544459109827507*^9, 
   3.5448063153443327`*^9, 3.5448088281027203`*^9, {3.544809252845022*^9, 
   3.544809303158217*^9}, 3.544809472475254*^9, 3.5448096625501347`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SuperscriptBox["z", "4"]], 
  RowBox[{"2", " ", 
   RowBox[{"S", "[", 
    RowBox[{"v", ",", "z"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"S", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["av", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.5388079500961*^9, 3.5438695004606524`*^9, 3.544342632883522*^9, 
   3.544344391825632*^9, 3.544353583285541*^9, 3.544459109827507*^9, 
   3.5448063153443327`*^9, 3.5448088281027203`*^9, {3.544809252845022*^9, 
   3.544809303158217*^9}, 3.544809472475254*^9, 3.544809662621827*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["av", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"\[Alpha]", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["p", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"p", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["\[Alpha]", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{
           SuperscriptBox["av", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
   SuperscriptBox["z", "2"]]}]], "Output",
 CellChangeTimes->{
  3.5388079500961*^9, 3.5438695004606524`*^9, 3.544342632883522*^9, 
   3.544344391825632*^9, 3.544353583285541*^9, 3.544459109827507*^9, 
   3.5448063153443327`*^9, 3.5448088281027203`*^9, {3.544809252845022*^9, 
   3.544809303158217*^9}, 3.544809472475254*^9, 3.5448096626563272`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SuperscriptBox["z", "2"]], 
  RowBox[{
   RowBox[{"S", "[", 
    RowBox[{"v", ",", "z"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"8", " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["av", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.5388079500961*^9, 3.5438695004606524`*^9, 3.544342632883522*^9, 
   3.544344391825632*^9, 3.544353583285541*^9, 3.544459109827507*^9, 
   3.5448063153443327`*^9, 3.5448088281027203`*^9, {3.544809252845022*^9, 
   3.544809303158217*^9}, 3.544809472475254*^9, 3.5448096626912403`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "4"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"12", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "6"}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
    "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["z", "2"], " ", 
     RowBox[{
      SuperscriptBox["S", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
    RowBox[{"4", " ", "z", " ", 
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.5388079500961*^9, 3.5438695004606524`*^9, 3.544342632883522*^9, 
   3.544344391825632*^9, 3.544353583285541*^9, 3.544459109827507*^9, 
   3.5448063153443327`*^9, 3.5448088281027203`*^9, {3.544809252845022*^9, 
   3.544809303158217*^9}, 3.544809472475254*^9, 3.544809662747837*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox["z", "4"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"16", " ", 
     SuperscriptBox["z", "2"], " ", 
     SuperscriptBox[
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"p", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"\[Alpha]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["z", "2"], " ", 
     RowBox[{"T", "[", 
      RowBox[{"v", ",", "z"}], "]"}], " ", 
     RowBox[{
      SuperscriptBox["S", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["z", "2"], " ", 
     RowBox[{"av", "[", 
      RowBox[{"v", ",", "z"}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Alpha]", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["p", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"p", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Alpha]", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"\[Alpha]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["p", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"p", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Alpha]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "6"}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"12", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
          RowBox[{
           SuperscriptBox["z", "4"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["av", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
          RowBox[{"4", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{
            SuperscriptBox["p", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["p", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{
            SuperscriptBox["\[Alpha]", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Alpha]", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["T", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"z", " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
    "-", 
    RowBox[{"4", " ", "z", " ", 
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SuperscriptBox[
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], " ", 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"2", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.5388079500961*^9, 3.5438695004606524`*^9, 3.544342632883522*^9, 
   3.544344391825632*^9, 3.544353583285541*^9, 3.544459109827507*^9, 
   3.5448063153443327`*^9, 3.5448088281027203`*^9, {3.544809252845022*^9, 
   3.544809303158217*^9}, 3.544809472475254*^9, 3.544809662968677*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["p", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["\[Alpha]", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   SuperscriptBox["z", "2"]]}]], "Output",
 CellChangeTimes->{
  3.5388079500961*^9, 3.5438695004606524`*^9, 3.544342632883522*^9, 
   3.544344391825632*^9, 3.544353583285541*^9, 3.544459109827507*^9, 
   3.5448063153443327`*^9, 3.5448088281027203`*^9, {3.544809252845022*^9, 
   3.544809303158217*^9}, 3.544809472475254*^9, 3.544809663009821*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SuperscriptBox["z", "4"]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{"12", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"av", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Alpha]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["p", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"8", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"av", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"p", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Alpha]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["p", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["p", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Alpha]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Alpha]", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
    RowBox[{"4", " ", "z", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.5388079500961*^9, 3.5438695004606524`*^9, 3.544342632883522*^9, 
   3.544344391825632*^9, 3.544353583285541*^9, 3.544459109827507*^9, 
   3.5448063153443327`*^9, 3.5448088281027203`*^9, {3.544809252845022*^9, 
   3.544809303158217*^9}, 3.544809472475254*^9, 3.544809663075429*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"z", "^", "3"}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", "eqp2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eq\[Alpha]2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqav2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqaz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgvz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgzz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqT2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "eqS2", "]"}]}], "Input",
 CellChangeTimes->{{3.507012905387106*^9, 3.507012910083256*^9}, {
  3.5070145245498*^9, 3.4603669411156473`*^9}, {3.5374870758129187`*^9, 
  3.5374870842285547`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110577895*^9, 3.544806316096909*^9, 3.544808828872163*^9, 
  3.544809308493793*^9, 3.54480947599644*^9, 3.5448096632544622`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110577895*^9, 3.544806316096909*^9, 3.544808828872163*^9, 
  3.544809308493793*^9, 3.54480947599644*^9, 3.5448096632564907`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110577895*^9, 3.544806316096909*^9, 3.544808828872163*^9, 
  3.544809308493793*^9, 3.54480947599644*^9, 3.544809663258061*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110577895*^9, 3.544806316096909*^9, 3.544808828872163*^9, 
  3.544809308493793*^9, 3.54480947599644*^9, 3.544809663259643*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110577895*^9, 3.544806316096909*^9, 3.544808828872163*^9, 
  3.544809308493793*^9, 3.54480947599644*^9, 3.544809663261169*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110577895*^9, 3.544806316096909*^9, 3.544808828872163*^9, 
  3.544809308493793*^9, 3.54480947599644*^9, 3.544809663262776*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110577895*^9, 3.544806316096909*^9, 3.544808828872163*^9, 
  3.544809308493793*^9, 3.54480947599644*^9, 3.544809663264392*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110577895*^9, 3.544806316096909*^9, 3.544808828872163*^9, 
  3.544809308493793*^9, 3.54480947599644*^9, 3.544809663265929*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"\[Alpha]", ",", "p", ",", "av", ",", "T", ",", "S"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4603676469897413`*^9, 3.460367657697607*^9}, {
  3.4603797352914047`*^9, 3.460379735508092*^9}, {3.5374870733721457`*^9, 
  3.537487073532263*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"f", ",", "h", ",", "a", ",", "t", ",", "s"}], "]"}]], "Input",
 CellChangeTimes->{{3.544345286443597*^9, 3.544345291880872*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
      RowBox[{"h", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"m", "+", 
    RowBox[{"a", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], ")"}]}], "+", " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"z", "^", "2"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], ")"}]}], " ", "+", 
      " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.537494166786066*^9, 3.537494209239134*^9}, 
   3.5375534855250597`*^9, {3.537578844859714*^9, 3.537578847402349*^9}, {
   3.5443428580700827`*^9, 3.5443428681588907`*^9}, {3.5443429100928164`*^9, 
   3.544342936702117*^9}, {3.544342967726297*^9, 3.5443429679008636`*^9}, {
   3.5443430411547203`*^9, 3.544343095121284*^9}, {3.544344387437715*^9, 
   3.5443443888695498`*^9}, {3.5448063261777983`*^9, 3.544806358323498*^9}, 
   3.544809624568368*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Evsol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"eqgvz2", "\[Equal]", "0"}], ",", 
         RowBox[{"eqS2", "\[Equal]", "0"}], ",", 
         RowBox[{"eqp2", "\[Equal]", "0"}], ",", 
         RowBox[{"eq\[Alpha]2", "\[Equal]", "0"}], ",", 
         RowBox[{"eqaz", "\[Equal]", "0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
         RowBox[{
          SuperscriptBox["a", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
         RowBox[{
          SuperscriptBox["t", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"{", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603794747692738`*^9, 3.4603795051117373`*^9}, {
   3.460379770556391*^9, 3.460379778090231*^9}, {3.537487575145343*^9, 
   3.537487601737835*^9}, {3.5374876320607243`*^9, 3.537487632172414*^9}, 
   3.5374876986147537`*^9, {3.537494224185582*^9, 3.537494230128457*^9}, {
   3.537494336674205*^9, 3.537494337210093*^9}, {3.54434458250847*^9, 
   3.544344629440035*^9}, 3.54434527412516*^9, {3.5443453145885363`*^9, 
   3.5443453363637247`*^9}, {3.544806385648988*^9, 3.544806389071024*^9}, {
   3.544809320574235*^9, 3.544809321228403*^9}, {3.5448096855286903`*^9, 
   3.5448096859845324`*^9}}],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{
  3.538807968763275*^9, 3.543869515253158*^9, 3.54434302242673*^9, 
   3.544343146940154*^9, 3.544344448960503*^9, 3.544344483170897*^9, {
   3.544344589109618*^9, 3.544344611194873*^9}, 3.54434467663202*^9, {
   3.544345279044548*^9, 3.5443453268668823`*^9}, 3.5443453833168488`*^9, 
   3.544353629445764*^9, 3.544459155167541*^9, 3.54480647746581*^9, 
   3.5448089111766577`*^9, 3.544809317317203*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Momsol", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqT2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqgzz", "\[Equal]", "0"}], ",", 
        RowBox[{"eqav", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460379791348405*^9, 3.460379854266864*^9}, {
  3.537487577120059*^9, 3.537487629667873*^9}, {3.5374877038531513`*^9, 
  3.537487709515881*^9}, {3.537494238680642*^9, 3.53749424053545*^9}, {
  3.5374943297700453`*^9, 3.537494330345728*^9}, {3.544344638534939*^9, 
  3.5443446432887497`*^9}, {3.5443446950372257`*^9, 3.544344697257845*^9}, {
  3.544344739498117*^9, 3.544344740065184*^9}, {3.544344844739172*^9, 
  3.544344845210968*^9}, {3.5448067624079323`*^9, 3.544806766544833*^9}, {
  3.544806916305894*^9, 3.544806924287718*^9}, {3.544807790458424*^9, 
  3.544807795320266*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"2", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}]], "Input",
 CellChangeTimes->{{3.544808915428605*^9, 3.544808971552553*^9}, {
  3.5448090102956553`*^9, 3.544809018220602*^9}, {3.544809056462654*^9, 
  3.544809063886075*^9}, {3.544809100765689*^9, 3.544809105792042*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "11"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox["z", "20"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}], ")"}], 
          RowBox[{"5", "/", "2"}]]}]], "+", 
       FractionBox[
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "7"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox["z", "12"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}], ")"}], 
          RowBox[{"3", "/", "2"}]]}]], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["z", "4"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"]}], 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
           ")"}]}]}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "3"]}], 
        RowBox[{
         SuperscriptBox["z", "6"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]], "+", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}]}], 
        RowBox[{
         SuperscriptBox["z", "6"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]], "+", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "3"], " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{
         SuperscriptBox["z", "5"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
          ")"}]}]}], ")"}], "2"]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["z", "12"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "4"], 
         SuperscriptBox["z", "8"]]}], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "4"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], 
         RowBox[{
          SuperscriptBox["z", "8"], " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]]}]]}], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"f", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}], "2"]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "4"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], 
        RowBox[{
         SuperscriptBox["z", "8"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]], "+", 
       FractionBox[
        RowBox[{"12", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "11"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox["z", "22"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}], ")"}], 
          RowBox[{"5", "/", "2"}]]}]], "+", 
       FractionBox[
        RowBox[{"12", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "7"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox["z", "14"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}], ")"}], 
          RowBox[{"3", "/", "2"}]]}]], "+", 
       FractionBox[
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox["z", "6"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]], "+", 
       FractionBox[
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox["z", "8"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]], "+", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}],
          " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"]}], 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
           ")"}]}]}]], "+", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "7"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Sigma]i", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}], "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Sigma]r", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}], "2"]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Sigma]i", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Sigma]r", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "12"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}], ")"}], 
          RowBox[{"3", "/", "2"}]]}]], "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "4"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "4"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["z", "4"], " ", 
        SqrtBox[
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                ")"}]}]}], ")"}], "4"], 
           SuperscriptBox["z", "8"]]}]], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
            ")"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["a", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
       FractionBox[
        RowBox[{"24", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "11"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{
         SuperscriptBox["z", "21"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}], ")"}], 
          RowBox[{"5", "/", "2"}]]}]], "+", 
       FractionBox[
        RowBox[{"24", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "7"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{
         SuperscriptBox["z", "13"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}], ")"}], 
          RowBox[{"3", "/", "2"}]]}]], "+", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{
         SuperscriptBox["z", "5"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]], "+", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox["z", "3"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
           ")"}]}]}]], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"12", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "11"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "23"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"5", "/", "2"}]]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "7"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "15"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "7"], " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]]}], ")"}]}], "-", 
       FractionBox[
        RowBox[{"14", " ", "z", " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
           ")"}]}]}]], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "10"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "22"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"5", "/", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "6"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "14"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "+", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox["z", "6"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}]}], ")"}], "2"]], "-", 
       FractionBox[
        RowBox[{"7", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "8"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["t", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
        RowBox[{
         SuperscriptBox["z", "15"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}], ")"}], 
          RowBox[{"3", "/", "2"}]]}]], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "11"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "22"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"5", "/", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"10", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "7"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "14"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "3"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "6"], " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "4"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "8"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"8", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"]}], 
             SuperscriptBox["z", "9"]], "-", 
            FractionBox[
             RowBox[{"4", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "3"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "z", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
             SuperscriptBox["z", "8"]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "14"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"5", "/", "2"}]]}], ")"}]}], "+", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "8"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "14"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}], ")"}], 
          RowBox[{"3", "/", "2"}]]}]], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}], "-", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
         ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"6", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "-", 
               RowBox[{"z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"6", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "-", 
               RowBox[{"z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "2"]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"6", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "-", 
               RowBox[{"z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "8"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"4", " ", "z", " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "2"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "14"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "4"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "-", 
               RowBox[{"4", " ", "z", " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "-", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
         ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "7"], " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]]}], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", "z", " ", 
        SqrtBox[
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                ")"}]}]}], ")"}], "4"], 
           SuperscriptBox["z", "8"]]}]], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
            ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"5", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{"4", " ", "z", " ", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "2"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                ")"}]}]}], ")"}], "4"], 
           SuperscriptBox["z", "8"]]}]], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
            ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "12"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"6", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "z", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}], "-", 
                RowBox[{"4", " ", "z", " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "11"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{"4", " ", "z", " ", 
                   RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "23"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"5", "/", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox[
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                ")"}]}]}], ")"}], "4"], 
           SuperscriptBox["z", "8"]]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "24"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                ")"}]}]}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "z", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{
                SuperscriptBox["t", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "z", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}], "+", 
                RowBox[{"4", " ", "z", " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "7"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"z", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{"4", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "15"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "4"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{"m", "+", 
               RowBox[{"a", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"h", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"f", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
                  RowBox[{"z", " ", 
                   RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
               RowBox[{"z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"f", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"h", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
                  RowBox[{"z", " ", 
                   RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
            "+", 
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"f", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[Sigma]r", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}], "+", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["\[Sigma]i", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}], "+", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], ")"}], 
        "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "6"], " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]]}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        SqrtBox[
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                ")"}]}]}], ")"}], "4"], 
           SuperscriptBox["z", "8"]]}]], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
            ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{"m", "+", 
             RowBox[{"a", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["\[Sigma]r", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}], "+", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["\[Sigma]i", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}], "+", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        SqrtBox[
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                ")"}]}]}], ")"}], "4"], 
           SuperscriptBox["z", "8"]]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"m", "+", 
              RowBox[{"a", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"h", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}], "2"]}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"f", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}], "2"]}]}], 
            ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[Sigma]r", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}], "+", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[Sigma]i", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}], "+", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{"m", "+", 
             RowBox[{"a", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["\[Sigma]r", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}], "+", 
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["\[Sigma]i", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}], "+", 
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}], "-", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "7"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["\[Sigma]i", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["\[Sigma]r", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], 
        RowBox[{
         SuperscriptBox["z", "13"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}], ")"}], 
          RowBox[{"3", "/", "2"}]]}]], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["z", "3"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["\[Sigma]i", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["\[Sigma]r", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
           ")"}]}]}]], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"12", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "6"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]i", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]r", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "12"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "7"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]i", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]r", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "12"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "+", 
       FractionBox[
        RowBox[{"12", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "10"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]i", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]r", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox["z", "18"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}], ")"}], 
          RowBox[{"5", "/", "2"}]]}]], "+", 
       FractionBox[
        RowBox[{"14", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "6"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]i", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]r", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}], "2"]}], 
        RowBox[{
         SuperscriptBox["z", "10"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}], ")"}], 
          RowBox[{"3", "/", "2"}]]}]], "-", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["z", "6"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]i", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]r", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}], "2"]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}]}], ")"}], "2"]], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"12", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "9"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]i", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]r", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "z"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], ")"}], 
        "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "21"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"5", "/", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"12", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]i", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]r", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "z"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], ")"}], 
        "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "13"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]i", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]r", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "-", 
                  RowBox[{"z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["z", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], ")"}], 
        "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "6"], " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             FractionBox["1", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]i", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]r", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "-", 
                  RowBox[{"z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["z", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], ")"}], 
        "/", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}]}], ")"}], "3"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"30", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], ")"}], 
        "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "16"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"12", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "5"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], ")"}], 
        "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "15"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"8", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"]}], 
             SuperscriptBox["z", "9"]], "-", 
            FractionBox[
             RowBox[{"4", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "3"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "z", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
             SuperscriptBox["z", "8"]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], ")"}], 
        "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "15"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"5", "/", "2"}]]}], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["z", "3"], " ", 
        SqrtBox[
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                ")"}]}]}], ")"}], "4"], 
           SuperscriptBox["z", "8"]]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["\[Sigma]i", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["\[Sigma]r", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "7"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]i", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["\[Sigma]r", "\[Prime]",
                  MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["t", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "12"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "-", 
                  RowBox[{"z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", 
                SuperscriptBox["z", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "3"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}]}], ")"}], "3"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"8", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"]}], 
             SuperscriptBox["z", "9"]], "-", 
            FractionBox[
             RowBox[{"4", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "3"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "z", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
             SuperscriptBox["z", "8"]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "-", 
                  RowBox[{"z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", 
                SuperscriptBox["z", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "3"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "2"], " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "7"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "14"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"12", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "10"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["z", "2"]}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
               RowBox[{"z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "23"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"5", "/", "2"}]]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3"}], " ", 
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "7"], " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"8", " ", "z", " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3"}], " ", 
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}]}], ")"}], "2"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "7"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "z"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", 
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
               RowBox[{"4", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "15"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "4"], 
              SuperscriptBox["z", "8"]]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["t", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "z"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "6"}], " ", 
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                  RowBox[{"4", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "2"]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["t", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["t", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
            RowBox[{"4", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
         ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "2"]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", " ", 
          SqrtBox[
           RowBox[{"-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "4"], 
             SuperscriptBox["z", "8"]]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"6", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "-", 
               RowBox[{"z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                FractionBox["1", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                SuperscriptBox["t", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
            RowBox[{"4", " ", "z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"6", " ", 
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   FractionBox["1", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{
                   SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
               RowBox[{"z", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "z", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]i", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["\[Sigma]r", "\[Prime]",
                    MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "2"]}], ")"}]}]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
          ")"}]}]}], ")"}], "7"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.5448089170958557`*^9, 3.544808929313105*^9}, 
   3.5448089722385693`*^9, 3.544809021132236*^9, {3.544809097108151*^9, 
   3.5448091065015373`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqT2", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqav", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"eqgzz", ",", "z"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"Evsol", ",", "v"}], "]"}]}], "/.", "Evsol"}], "/.", "Momsol"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.460379877349128*^9, 3.460379983100644*^9}, {
  3.460380087445326*^9, 3.460380091873478*^9}, {3.537487726936469*^9, 
  3.5374877500015907`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.543869535315189*^9, 
  3.5443432909583673`*^9, 3.544459192535948*^9, 3.544807801213522*^9}],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.543869535315189*^9, 
  3.5443432909583673`*^9, 3.544459192535948*^9, 3.544807801252376*^9}],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.543869535315189*^9, 
  3.5443432909583673`*^9, 3.544459192535948*^9, 3.5448078031432333`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Const1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Const2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Const3", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["s", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["s", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.46031768644937*^9, 3.46031772334064*^9}, {
  3.537487772329159*^9, 3.5374878178010073`*^9}, {3.537494258424617*^9, 
  3.537494262447569*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["z", "4"], " ", 
     SqrtBox[
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{
               FractionBox["1", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}]}]}], ")"}], "4"], 
        SuperscriptBox["z", "8"]]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}],
          " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "3"]}], 
        RowBox[{
         SuperscriptBox["z", "6"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]], "+", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}]}], 
        RowBox[{
         SuperscriptBox["z", "6"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]], "+", 
       FractionBox[
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "3"], " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{
         SuperscriptBox["z", "5"], " ", 
         SqrtBox[
          RowBox[{"-", 
           FractionBox[
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"], 
            SuperscriptBox["z", "8"]]}]]}]]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox[
                RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
          ")"}]}]}], ")"}], "3"]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.544344881326605*^9, 3.544353665555982*^9, 
  3.544459275660297*^9, 3.544806930353098*^9, 3.544807807090665*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["z", "3"], " ", 
       SqrtBox[
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "4"], 
          SuperscriptBox["z", "8"]]}]], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SqrtBox[
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{
                 FractionBox["1", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
               ")"}]}]}], ")"}], "4"], 
          SuperscriptBox["z", "8"]]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "4"]}], 
           SuperscriptBox["z", "9"]], "-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                 ")"}]}]}], ")"}], "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "z", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
           SuperscriptBox["z", "8"]]}], ")"}]}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{
                  FractionBox["1", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                ")"}]}]}], ")"}], "4"], 
           SuperscriptBox["z", "8"]]}]]}]]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["z", "4"], " ", 
      SqrtBox[
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{
                FractionBox["1", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
              ")"}]}]}], ")"}], "4"], 
         SuperscriptBox["z", "8"]]}]]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["a", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.544344881326605*^9, 3.544353665555982*^9, 
  3.544459275660297*^9, 3.544806930353098*^9, 3.544807807100013*^9}],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   PanelBox[GridBox[{
      {
       StyleBox[
        StyleBox[
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
           StandardForm],
          ImageSizeCache->{278., {2., 8.}}],
         StripOnInput->False,
         DynamicUpdating->True], "Panel",
        StripOnInput->False,
        Background->None]},
      {
       ItemBox[
        TagBox[
         RowBox[{
          RowBox[{"-", 
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               FractionBox[
                RowBox[{"6", " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    ")"}]}]}], ")"}]}]}], ")"}], "11"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    "2"]}], ")"}]}]}], ")"}]}]}], ")"}], "2"]}], 
                RowBox[{
                 SuperscriptBox["z", "20"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"-", 
                    FractionBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}]}], 
                    ")"}], "4"], 
                    SuperscriptBox["z", "8"]]}], ")"}], 
                  RowBox[{"5", "/", "2"}]]}]], "+", 
               FractionBox[
                RowBox[{"6", " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                   ")"}], "7"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                   ")"}], "2"]}], 
                RowBox[{
                 SuperscriptBox["z", "12"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"-", 
                    FractionBox[
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}]]}], 
                   ")"}], 
                  RowBox[{"3", "/", "2"}]]}]], "+", 
               FractionBox[
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], "3"], 
                 " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}]}], 
                   ")"}], "2"]}], 
                RowBox[{
                 SuperscriptBox["z", "4"], " ", 
                 SqrtBox[
                  RowBox[{"-", 
                   FractionBox[
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    RowBox[{
                    "\[LeftSkeleton]", "1", "\[RightSkeleton]"}]]}]]}]], "+", 
               FractionBox[
                RowBox[{"2", " ", 
                 SuperscriptBox["z", "4"], " ", 
                 SqrtBox[
                  RowBox[{"-", 
                   FractionBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}]}], 
                    ")"}], "4"], 
                    SuperscriptBox["z", "8"]]}]], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    ")"}]}]}], ")"}], "2"]}], 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}]}]]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], ")"}]}], 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "2"]}]]}], "+", 
          FractionBox[
           RowBox[{
            SuperscriptBox["z", "12"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", 
               FractionBox[
                RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}]]}], 
              ")"}], 
             RowBox[{"3", "/", "2"}]], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{"3", " ", 
                 SuperscriptBox[
                  RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], "4"], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    "2"]}], "-", 
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}], 
                RowBox[{
                 SuperscriptBox["z", "8"], " ", 
                 SqrtBox[
                  RowBox[{"-", 
                   FractionBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    ")"}], "4"], 
                    SuperscriptBox["z", "8"]]}]]}]]}], "-", 
              FractionBox[
               RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
               RowBox[{
                RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}]}]], "+", 
              RowBox[{"\[LeftSkeleton]", "100", "\[RightSkeleton]"}]}], 
             ")"}]}], 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "+", 
                  RowBox[{
                   FractionBox["1", "4"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox[
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    "2"]}], "-", 
                    SuperscriptBox[
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    "2"]}], ")"}]}]}], ")"}]}]}], ")"}], "7"]}]], "+", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"2", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}],
         Short[#, 5]& ],
        Background->GrayLevel[1],
        BaseStyle->{Deployed -> False},
        Frame->True,
        FrameStyle->GrayLevel[0, 0.2],
        StripOnInput->False]},
      {
       RowBox[{
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
             StandardForm],
            ImageSizeCache->{49., {1., 8.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>OutputSizeLimit`ButtonFunction[
          Identity, 156, 23231266224693333430, 5/2],
         Enabled->True,
         Evaluator->Automatic,
         Method->"Queued"], "\[ThinSpace]", 
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
             StandardForm],
            ImageSizeCache->{52., {1., 8.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>OutputSizeLimit`ButtonFunction[
          Identity, 156, 23231266224693333430, 5 2],
         Enabled->True,
         Evaluator->Automatic,
         Method->"Queued"], "\[ThinSpace]", 
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
             StandardForm],
            ImageSizeCache->{82., {2., 8.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>OutputSizeLimit`ButtonFunction[
          Identity, 156, 23231266224693333430, Infinity],
         Enabled->True,
         Evaluator->Automatic,
         Method->"Queued"], "\[ThinSpace]", 
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
             StandardForm],
            ImageSizeCache->{74., {1., 8.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetOptions[
            FrontEnd`$FrontEnd, 
             FrontEnd`PreferencesSettings -> {"Page" -> "Evaluation"}], 
            FrontEnd`FrontEndToken["PreferencesDialog"]}],
         Evaluator->None,
         Method->"Preemptive"]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[1.2]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    DefaultBaseStyle->{},
    FrameMargins->5],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  Out[156]]], "Output",
 CellChangeTimes->{3.544344881326605*^9, 3.544353665555982*^9, 
  3.544459275660297*^9, 3.544806930353098*^9, 3.5448078071366777`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Eq1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq3", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Expand", "[", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}], "]"}], 
     "]"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq4", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["t", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["t", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.537489066732723*^9, 3.5374891410817547`*^9}, {
  3.537494265681246*^9, 3.537494272120749*^9}, {3.544345475134297*^9, 
  3.54434553247793*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]r", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", 
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"h", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}]}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
             RowBox[{"4", " ", "z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"4", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}]], "-", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "-", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Sigma]r", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], "+", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
              RowBox[{"2", " ", "z", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
              RowBox[{"2", " ", "z", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[Sigma]r", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}], "+", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["\[Sigma]i", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["\[Sigma]r", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], ")"}],
        "/", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
        ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.538808034338485*^9, 3.5438695583201303`*^9, 3.5443434189455633`*^9, 
   3.544344881635076*^9, {3.544345477350584*^9, 3.544345497103199*^9}, 
   3.544345533360471*^9, 3.544353665886816*^9, 3.544459279463934*^9, 
   3.544806934475675*^9, 3.544807863905834*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}]}], "-", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]i", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"f", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}]}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"4", " ", "z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"4", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}]], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "-", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Sigma]i", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], "+", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
              RowBox[{"2", " ", "z", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
              RowBox[{"2", " ", "z", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[Sigma]i", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}], "+", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["\[Sigma]i", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["\[Sigma]r", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], ")"}],
        "/", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
        ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["h", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.538808034338485*^9, 3.5438695583201303`*^9, 3.5443434189455633`*^9, 
   3.544344881635076*^9, {3.544345477350584*^9, 3.544345497103199*^9}, 
   3.544345533360471*^9, 3.544353665886816*^9, 3.544459279463934*^9, 
   3.544806934475675*^9, 3.544807863914187*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"16", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{"16", " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{"16", " ", "m", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"4", " ", "m", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "4"]}], "+", 
       RowBox[{"16", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{"16", " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{"16", " ", "m", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"8", " ", "m", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"4", " ", "m", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "4"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
         ")"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
         ")"}]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]i", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]i", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]i", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]i", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]r", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]r", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]r", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]r", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]i", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]r", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "5"], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "4"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "3"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "4"], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"6", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "4"], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"6", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "4"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "5"], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           RowBox[{"(", 
            RowBox[{"m", "+", 
             RowBox[{"a", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
           RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["\[Sigma]r", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", 
           RowBox[{"(", 
            RowBox[{"m", "+", 
             RowBox[{"a", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
           RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]i", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], ")"}]}]}], 
            ")"}], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"4", "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}]}], 
  "+", 
  RowBox[{
   SuperscriptBox["a", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.538808034338485*^9, 3.5438695583201303`*^9, 3.5443434189455633`*^9, 
   3.544344881635076*^9, {3.544345477350584*^9, 3.544345497103199*^9}, 
   3.544345533360471*^9, 3.544353665886816*^9, 3.544459279463934*^9, 
   3.544806934475675*^9, 3.544807865811656*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox["z", "4"]}]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "-", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
        ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"12", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
               SuperscriptBox[
                RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
           ")"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "6"}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], ")"}]}], 
      "-", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             SuperscriptBox[
              RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       RowBox[{"4", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}]], "+", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "-", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       RowBox[{"4", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}]], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"32", " ", 
         SuperscriptBox["z", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           SuperscriptBox[
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
           SuperscriptBox[
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox["1", "4"], " ", "z", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
              RowBox[{"2", " ", "z", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["\[Sigma]i", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "+", 
              RowBox[{
               RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["\[Sigma]r", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], ")"}],
        "/", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
        "2"]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.538808034338485*^9, 3.5438695583201303`*^9, 3.5443434189455633`*^9, 
   3.544344881635076*^9, {3.544345477350584*^9, 3.544345497103199*^9}, 
   3.544345533360471*^9, 3.544353665886816*^9, 3.544459279463934*^9, 
   3.544806934475675*^9, 3.544807865814557*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     SuperscriptBox[
      RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], 
    SuperscriptBox["z", "2"]]}], "+", 
  FractionBox[
   RowBox[{"8", " ", 
    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
    RowBox[{
     SuperscriptBox["\[Sigma]i", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}]}], 
   RowBox[{"z", " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}]}]], 
  "+", 
  FractionBox[
   RowBox[{"8", " ", 
    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
    RowBox[{
     SuperscriptBox["\[Sigma]r", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}]}], 
   RowBox[{"z", " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}]}]], 
  "-", 
  SuperscriptBox[
   RowBox[{
    SuperscriptBox["a", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"h", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "z"], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"h", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "z"], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "4"]}]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "6"}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
         RowBox[{"2", " ", 
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}]}]}], 
     ")"}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "4"]}]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"6", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
         RowBox[{"2", " ", 
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}]}]}], 
     ")"}]}]}], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       SuperscriptBox[
        RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
    "2"]], "-", 
  FractionBox[
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      SuperscriptBox[
       RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
      SuperscriptBox[
       RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["z", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}]}]], 
  "-", 
  FractionBox[
   RowBox[{"16", " ", "z", " ", 
    RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
    RowBox[{
     SuperscriptBox["\[Sigma]i", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      SuperscriptBox[
       RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
      SuperscriptBox[
       RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
    "2"]], "-", 
  FractionBox[
   RowBox[{"16", " ", "z", " ", 
    RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
    RowBox[{
     SuperscriptBox["\[Sigma]r", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      SuperscriptBox[
       RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "-", 
      SuperscriptBox[
       RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
    "2"]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["t", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}]}], "z"], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"4", " ", 
     RowBox[{"t", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "-", 
       RowBox[{"z", " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], 
   SuperscriptBox["z", "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      SuperscriptBox[
       RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "+", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["z", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}]}]], 
  "+", 
  RowBox[{
   SuperscriptBox["t", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Sigma]r", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], "+", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "z"], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"h", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Sigma]i", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], "+", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "z"], "-", 
  FractionBox[
   RowBox[{"16", " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], "-", 
         RowBox[{"4", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}]}], 
   RowBox[{"z", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
     "2"]}]]}]], "Output",
 CellChangeTimes->{
  3.538808034338485*^9, 3.5438695583201303`*^9, 3.5443434189455633`*^9, 
   3.544344881635076*^9, {3.544345477350584*^9, 3.544345497103199*^9}, 
   3.544345533360471*^9, 3.544353665886816*^9, 3.544459279463934*^9, 
   3.544806934475675*^9, 3.54480786582411*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "deriv", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"deriv", "[", "X_", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"X", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "X"}], ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<v\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<z\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"X", "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], ",", "z"}], 
        "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<vz\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"v", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<vv\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<zz\>\""}], "]"}]}]}],
      "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"deriv", "[", "j", "]"}]}], "Input",
 CellChangeTimes->{{3.537488129955064*^9, 3.537488303539091*^9}, 
   3.537565624076147*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"j", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "j"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jv"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jz"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jvz"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"2", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jvv"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jzz"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5388080344525146`*^9, 3.543869558400304*^9, 
  3.5443434200927963`*^9, 3.544344881867298*^9, 3.544345537939296*^9, 
  3.544459312325859*^9, 3.544806938444901*^9, 3.544807866445284*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Sigma]r", "[", "v", "]"}], "\[Rule]", "p"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Sigma]r", "'"}], "[", "v", "]"}], "\[Rule]", "pv"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Sigma]r", "''"}], "[", "v", "]"}], "\[Rule]", "pvv"}], 
       ",", 
       RowBox[{
        RowBox[{"\[Sigma]i", "[", "v", "]"}], "\[Rule]", "k"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Sigma]i", "'"}], "[", "v", "]"}], "\[Rule]", "kv"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Sigma]i", "''"}], "[", "v", "]"}], "\[Rule]", "kvv"}]}], 
      "}"}], ",", 
     RowBox[{"deriv", "[", "f", "]"}], ",", 
     RowBox[{"deriv", "[", "a", "]"}], ",", 
     RowBox[{"deriv", "[", "h", "]"}], ",", 
     RowBox[{"deriv", "[", "t", "]"}], ",", 
     RowBox[{"deriv", "[", "s", "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460533850988061*^9, 3.460317762594681*^9}, {
  3.460317899777432*^9, 3.460317913876012*^9}, {3.4603179946260138`*^9, 
  3.460317994880909*^9}, {3.460318028461433*^9, 3.4603180359232483`*^9}, {
  3.5374878304982758`*^9, 3.537487855625393*^9}, {3.53748801305739*^9, 
  3.537488044943592*^9}, {3.537488108469489*^9, 3.537488111403976*^9}, {
  3.5374883167609386`*^9, 3.537488354940011*^9}, {3.537494360528582*^9, 
  3.537494365432303*^9}, {3.5374953043244743`*^9, 3.5374953101843863`*^9}, {
  3.544343338667395*^9, 3.544343351547291*^9}, {3.544806574159322*^9, 
  3.5448065983496*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eq1str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Eq1", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537489304806736*^9, 3.537489309341483*^9}, {
   3.5374972785438137`*^9, 3.537497285903635*^9}, {3.537540737136909*^9, 
   3.537540745480649*^9}, 3.5375407900484257`*^9, {3.537541358740419*^9, 
   3.537541372163848*^9}, {3.5375414874019747`*^9, 3.537541501177627*^9}, {
   3.537541543216469*^9, 3.537541545224094*^9}, {3.544343536409142*^9, 
   3.5443435403469353`*^9}}],

Cell[BoxData["\<\"fvz - (pow(z,-2)*(2*(f + p) - 2*fv*z - 2*pv*z + 2*(fv + \
pv)*z - 2*az*(h + k)*pow(z,2) - (f + p + fz*z)*(-2*t - tz*z + pow(k,2) + \
pow(p,2))*pow(z,2) + ((-2*(f + p) + fzz*pow(z,2))*(2 + 2*t*pow(z,2) - \
(pow(k,2) + pow(p,2))*pow(z,2)))/2. + 4*(a + m)*(-4*hz + z*(-4*(h + k)*sz*z - \
(2*(h + k) + hz*z)*(4*s - pow(k,2) - pow(p,2))))*pow(z,2)*pow(4 + \
4*s*pow(z,2) - (pow(k,2) + pow(p,2))*pow(z,2),-1) + 2*pow(z,2)*(2*(k*kv + \
p*pv - 2*sv)*z*(f + p + fz*z) - 2*(fv + pv)*z*(4*s + 2*sz*z - pow(k,2) - \
pow(p,2)) + (f + p + fz*z)*(4*s + 2*sz*z - pow(k,2) - pow(p,2))*(2 + \
2*t*pow(z,2) - (pow(k,2) + pow(p,2))*pow(z,2)))*pow(4 + 4*s*pow(z,2) - \
(pow(k,2) + pow(p,2))*pow(z,2),-1)))/2.\"\>"], "Output",
 CellChangeTimes->{
  3.538808034531695*^9, 3.543869558473194*^9, 3.544343433628708*^9, {
   3.544343540880823*^9, 3.544343544469836*^9}, 3.5443448822682734`*^9, 
   3.544345539155551*^9, 3.544459316716411*^9, 3.544806939898883*^9, 
   3.544807867828623*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eq2str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Eq2", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537551719171803*^9, 3.537551720666493*^9}, {
  3.544343529881132*^9, 3.544343533033296*^9}}],

Cell[BoxData["\<\"hvz - (pow(z,-2)*(4*(h + k) - 4*hv*z - 4*kv*z + 4*(hv + \
kv)*z + 4*az*(f + p)*pow(z,2) - 2*(h + k + hz*z)*(-2*t - tz*z + pow(k,2) + \
pow(p,2))*pow(z,2) + (-2*(h + k) + hzz*pow(z,2))*(2 + 2*t*pow(z,2) - \
(pow(k,2) + pow(p,2))*pow(z,2)) + 8*(a + m)*(4*fz + z*(4*(f + p)*sz*z + (2*(f \
+ p) + fz*z)*(4*s - pow(k,2) - pow(p,2))))*pow(z,2)*pow(4 + 4*s*pow(z,2) - \
(pow(k,2) + pow(p,2))*pow(z,2),-1) + 4*pow(z,2)*(2*(k*kv + p*pv - 2*sv)*z*(h \
+ k + hz*z) - 2*(hv + kv)*z*(4*s + 2*sz*z - pow(k,2) - pow(p,2)) + (h + k + \
hz*z)*(4*s + 2*sz*z - pow(k,2) - pow(p,2))*(2 + 2*t*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2)))*pow(4 + 4*s*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2),-1)))/4.\"\>"], "Output",
 CellChangeTimes->{
  3.538808034586948*^9, 3.543869558517671*^9, 3.5443434347617702`*^9, {
   3.544343533515728*^9, 3.5443435449897118`*^9}, 3.544344882484976*^9, 
   3.544345539736843*^9, 3.544459317785119*^9, 3.5448069407681923`*^9, 
   3.544807868486825*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eq3str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Eq3", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537551722346656*^9, 3.537551723954479*^9}, {
  3.544343509887916*^9, 3.5443435262530212`*^9}}],

Cell[BoxData["\<\"avz + 2*(8*fv*k - 8*fz*k - 8*hv*p + 8*hz*p - 8*kv*p + \
8*k*pv + 16*a*pow(k,2) + 16*m*pow(k,2) + 16*a*pow(p,2) + 16*m*pow(p,2) - \
2*az*k*kv*pow(z,2) - 2*az*p*pv*pow(z,2) + 8*fv*k*s*pow(z,2) - \
8*fz*k*s*pow(z,2) - 8*hv*p*s*pow(z,2) + 8*hz*p*s*pow(z,2) - 8*kv*p*s*pow(z,2) \
+ 8*k*pv*s*pow(z,2) + 4*az*sv*pow(z,2) - 8*fz*k*t*pow(z,2) + \
8*hz*p*t*pow(z,2) + 2*hv*p*pow(k,2)*pow(z,2) - 6*hz*p*pow(k,2)*pow(z,2) + \
2*kv*p*pow(k,2)*pow(z,2) + 16*a*s*pow(k,2)*pow(z,2) + \
16*m*s*pow(k,2)*pow(z,2) - 2*fv*pow(k,3)*pow(z,2) + 6*fz*pow(k,3)*pow(z,2) - \
2*pv*pow(k,3)*pow(z,2) - 4*a*pow(k,4)*pow(z,2) - 4*m*pow(k,4)*pow(z,2) - \
2*fv*k*pow(p,2)*pow(z,2) + 6*fz*k*pow(p,2)*pow(z,2) - \
2*k*pv*pow(p,2)*pow(z,2) + 16*a*s*pow(p,2)*pow(z,2) + \
16*m*s*pow(p,2)*pow(z,2) - 8*a*pow(k,2)*pow(p,2)*pow(z,2) - \
8*m*pow(k,2)*pow(p,2)*pow(z,2) + 2*hv*pow(p,3)*pow(z,2) - \
6*hz*pow(p,3)*pow(z,2) + 2*kv*pow(p,3)*pow(z,2) - 4*a*pow(p,4)*pow(z,2) - \
4*m*pow(p,4)*pow(z,2) + 4*(a + m)*pow(f,2)*(4 + 4*s*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2)) + 4*(a + m)*pow(h,2)*(4 + 4*s*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2)) - f*(4 + 4*s*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2))*(2*hv + 2*kv - 8*(a + m)*p + hz*pow(p,2)*pow(z,2) + \
hz*(-2 + (-2*t + pow(k,2))*pow(z,2))) + h*(4 + 4*s*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2))*(8*k*(a + m) + fz*(pow(k,2) + pow(p,2))*pow(z,2) + 2*(fv \
+ pv - fz*(1 + t*pow(z,2)))) - 8*fz*k*s*t*pow(z,4) + 8*hz*p*s*t*pow(z,4) - \
4*hz*p*s*pow(k,2)*pow(z,4) - 2*hz*p*t*pow(k,2)*pow(z,4) + \
4*fz*s*pow(k,3)*pow(z,4) + 2*fz*t*pow(k,3)*pow(z,4) + hz*p*pow(k,4)*pow(z,4) \
- fz*pow(k,5)*pow(z,4) + 4*fz*k*s*pow(p,2)*pow(z,4) + \
2*fz*k*t*pow(p,2)*pow(z,4) - 2*fz*pow(k,3)*pow(p,2)*pow(z,4) - \
4*hz*s*pow(p,3)*pow(z,4) - 2*hz*t*pow(p,3)*pow(z,4) + \
2*hz*pow(k,2)*pow(p,3)*pow(z,4) - fz*k*pow(p,4)*pow(z,4) + \
hz*pow(p,5)*pow(z,4))*pow(4 + 4*s*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2),-1)\"\>"], "Output",
 CellChangeTimes->{
  3.538808034636338*^9, 3.543869558577878*^9, 3.544343435846356*^9, {
   3.544343526842533*^9, 3.5443435454877462`*^9}, 3.5443448827025747`*^9, 
   3.544345540393375*^9, 3.544459318569562*^9, 3.544806941731748*^9, 
   3.544807869063025*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eq4str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Eq4", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537551725538599*^9, 3.537551726962449*^9}, {
  3.544343511752201*^9, 3.5443435187274647`*^9}}],

Cell[BoxData["\<\"svz + (pow(z,-4)*(s*pow(z,2) + (4 - (pow(k,2) + \
pow(p,2))*pow(z,2))/4.)*(12 + 4*pow(h + k,2)*pow(z,2) + 4*(2*t + tz*z - \
pow(k,2) - pow(p,2))*pow(z,2) + 4*pow(f + p,2)*pow(z,2) - pow(az,2)*pow(z,4) \
+ 2*(t*pow(z,2) + (2 - (pow(k,2) + pow(p,2))*pow(z,2))/2.)*(-6 + \
pow(z,2)*pow(f + p + fz*z,2) + pow(z,2)*pow(h + k + hz*z,2)) - 32*(4*s + \
2*sz*z - pow(k,2) - pow(p,2))*((k*kv + p*pv - 2*sv)*pow(z,2) + (z*(4*s + \
2*sz*z - pow(k,2) - pow(p,2))*(2 + 2*t*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2)))/4.)*pow(z,3)*pow(4 + 4*s*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2),-2) - 16*(4*s + 2*sz*z - pow(k,2) - pow(p,2))*pow(z,2)*(-2 \
+ (-2*t + pow(k,2) + pow(p,2))*pow(z,2))*pow(4 + 4*s*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2),-1) + 8*(4*s + 2*sz*z - pow(k,2) - pow(p,2))*(-2*t - tz*z \
+ pow(k,2) + pow(p,2))*pow(z,4)*pow(4 + 4*s*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2),-1)))/8.\"\>"], "Output",
 CellChangeTimes->{{3.544343519171138*^9, 3.5443435459914227`*^9}, 
   3.544344882921999*^9, 3.544345541056335*^9, 3.544459319404332*^9, 
   3.544806942687049*^9, 3.544807869850092*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eq5str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Eq5", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5375517285546923`*^9, 3.537551730078916*^9}, {
  3.544343502593671*^9, 3.544343520310988*^9}}],

Cell[BoxData["\<\"tzz - pow(az,2) - (-2*t + pow(k,2) + pow(p,2))*pow(z,-2) - \
(4*t - 2*(-(tz*z) + pow(k,2) + pow(p,2)))*pow(z,-2) + 4*tz*pow(z,-1) - 4*(h + \
k)*(a + m)*(f + p + fz*z)*pow(z,-1) - 2*(fv + pv)*(f + p + fz*z)*pow(z,-1) - \
2*(hv + kv)*(h + k + hz*z)*pow(z,-1) + 4*(a + m)*(f + p)*(h + k + \
hz*z)*pow(z,-1) + (pow(z,-4)*(2 + 2*t*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2))*(-6 + pow(z,2)*(2*f*(p + fz*z) + pow(f,2) + pow(p + \
fz*z,2) + pow(h + k + hz*z,2))))/2. + (pow(z,-4)*(2 + 2*t*pow(z,2) - \
(pow(k,2) + pow(p,2))*pow(z,2))*(6 + pow(z,2)*(2*f*(p + fz*z) + pow(f,2) + \
pow(p + fz*z,2) + pow(h + k + hz*z,2))))/2. - 16*k*kv*z*(4*s + 2*sz*z - \
pow(k,2) - pow(p,2))*pow(4 + 4*s*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2),-2) - 16*p*pv*z*(4*s + 2*sz*z - pow(k,2) - pow(p,2))*pow(4 \
+ 4*s*pow(z,2) - (pow(k,2) + pow(p,2))*pow(z,2),-2) - 4*(2 + 2*t*pow(z,2) - \
(pow(k,2) + pow(p,2))*pow(z,2))*pow(-4*s - 2*sz*z + pow(k,2) + \
pow(p,2),2)*pow(4 + 4*s*pow(z,2) - (pow(k,2) + pow(p,2))*pow(z,2),-2) + \
8*k*kv*pow(z,-1)*pow(4 + 4*s*pow(z,2) - (pow(k,2) + pow(p,2))*pow(z,2),-1) + \
8*p*pv*pow(z,-1)*pow(4 + 4*s*pow(z,2) - (pow(k,2) + pow(p,2))*pow(z,2),-1) - \
8*(4*s + 2*sz*z - pow(k,2) - pow(p,2))*pow(z,-2)*(-2 + (-2*t + pow(k,2) + \
pow(p,2))*pow(z,2))*pow(4 + 4*s*pow(z,2) - (pow(k,2) + pow(p,2))*pow(z,2),-1) \
- 2*pow(z,-2)*(-4*s + 4*sz*z + pow(k,2) + pow(p,2) + 2*szz*pow(z,2))*(-2 + \
(-2*t + pow(k,2) + pow(p,2))*pow(z,2))*pow(4 + 4*s*pow(z,2) - (pow(k,2) + \
pow(p,2))*pow(z,2),-1) - 16*sv*pow(z,-1)*(4 + (-4*s - 4*sz*z + pow(k,2) + \
pow(p,2))*pow(z,2))*pow(-4 + (-4*s + pow(k,2) + pow(p,2))*pow(z,2),-2)\"\>"], \
"Output",
 CellChangeTimes->{
  3.538807898663368*^9, 3.538808034774719*^9, 3.543869558680262*^9, 
   3.544343438198242*^9, {3.544343520744734*^9, 3.5443435466242523`*^9}, 
   3.544344883137394*^9, 3.5443455416316843`*^9, 3.5444593202709417`*^9, 
   3.544806943587412*^9, 3.5448078705832767`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C1str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Const1", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537489304806736*^9, 3.537489309341483*^9}, {
   3.5374972785438137`*^9, 3.537497285903635*^9}, {3.537540737136909*^9, 
   3.537540745480649*^9}, 3.5375407900484257`*^9, {3.537541358740419*^9, 
   3.537541372163848*^9}, {3.5375414874019747`*^9, 3.537541501177627*^9}, {
   3.537541543216469*^9, 3.537541545224094*^9}, {3.538807876854679*^9, 
   3.538807885102872*^9}, {3.544343481770335*^9, 3.5443434923038397`*^9}}],

Cell[BoxData["\<\"szz + (pow(z,4)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-3)*(4*(s + (-pow(k,2) - pow(p,2))/4.)*pow(z,-6)*pow(1 \
+ (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2),3)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-0.5) + 8*sz*pow(z,-5)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),3)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-0.5) + pow(z,-6)*(pow(f + p + \
fz*z,2) + pow(h + k + hz*z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5))/2.\"\>"], "Output",
 CellChangeTimes->{3.5443434980781097`*^9, 3.544343547174124*^9, 
  3.544344883352786*^9, 3.5444593218750153`*^9, 3.544806944925991*^9, 
  3.544807871608561*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C2str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Const2", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5388078907580767`*^9, 3.538807892116951*^9}, {
  3.544343472184718*^9, 3.544343490679863*^9}}],

Cell[BoxData["\<\"azz - pow(z,-4)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5)*(-(az*pow(z,4)*(-4*pow(z,-8)*(2*z*(s + \
(-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),3) + 8*pow(z,-9)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5))/2. + 4*((h + k)*z*(f + p + fz*z) - (f + \
p)*z*(h + k + hz*z))*pow(z,2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5) - 4*az*pow(z,3)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),0.5))\"\>"], "Output",
 CellChangeTimes->{3.54434349612337*^9, 3.544343547692355*^9, 
  3.54434488356933*^9, 3.5444593226766653`*^9, 3.5448078723535233`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C3str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Const3", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.538807893564623*^9, 3.538807895276726*^9}, {
  3.544343460216667*^9, 3.544343489311842*^9}}],

Cell[BoxData["\<\"svv - (pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-2)*(4*(s + (-pow(k,2) - pow(p,2))/4.)*pow(z,-6)*pow(1 \
+ (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2),3)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-0.5) + 8*sz*pow(z,-5)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),3)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-0.5) + pow(z,-6)*(pow(f + p + \
fz*z,2) + pow(h + k + hz*z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5))*(6*pow(z,-20)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),11)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-2.5) + 6*pow(z,-12)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),7)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5) + 2*pow(z,-4)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),3)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5) + 2*pow(z,4)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-1)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5)))/4. + (pow(z,12)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-7)*((-3*pow(z,-14)*(2*z*(t + (-pow(k,2) - \
pow(p,2))/2.) + tz*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(-4*pow(z,-8)*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*pow(1 + (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2),3) + \
8*pow(z,-9)*pow(1 + (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2),4))*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),8)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-2.5))/4. + 12*((-2*k*kv - 2*p*pv)/4. \
+ sv)*pow(z,-21)*(-(z*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*(1 \
+ (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))) + 2*((-2*k*kv - 2*p*pv)/4. + sv)*(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*pow(z,3))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),9)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-2.5) + 12*pow((-2*k*kv - 2*p*pv)/4. + \
sv,2)*pow(z,-18)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),10)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-2.5) - 12*pow(z,-23)*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*((1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2))*(-(((-2*k*kv - 2*p*pv)/4. + sv)*pow(z,2)) + \
z*(2*((-2*k*kv - 2*p*pv)/4. + sv)*z + svz*pow(z,2))) + ((-2*k*kv - 2*p*pv)/4. \
+ sv)*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*pow(z,3))*pow(1 + \
(s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2),10)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-2.5) + 6*pow(z,-22)*(2*z*(s + \
(-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*(2*z*(t + (-pow(k,2) - \
pow(p,2))/2.) + tz*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),11)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-2.5) - (3*pow(z,-23)*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(-4*z*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + tz*pow(z,2)) + (1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(4*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) \
+ tz*pow(z,2)) - 2*z*(4*tz*z + 2*(t + (-pow(k,2) - pow(p,2))/2.) + \
tzz*pow(z,2))))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),11)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-2.5))/4. + 6*pow(z,-22)*pow(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2),2)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),10)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-2.5) + 12*(s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,-22)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),11)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-2.5) + 24*sz*pow(z,-21)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),11)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-2.5) - 12*pow(z,-23)*(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),11)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-2.5) - 3*pow(z,-15)*(-4*pow(z,-8)*(2*z*(s + \
(-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),3) + 8*pow(z,-9)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),6)*(-(((-2*k*kv - 2*p*pv)/4. + sv)*(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(z,3)) + z*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*(1 + (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*pow(1 + (t + \
(-pow(k,2) - pow(p,2))/2.)*pow(z,2),2))*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-2.5) + 12*((-2*k*kv - 2*p*pv)/4. + \
sv)*pow(z,-13)*(-(z*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*(1 + \
(s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))) + 2*((-2*k*kv - 2*p*pv)/4. + sv)*(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*pow(z,3))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),5)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5) + 14*pow((-2*k*kv - 2*p*pv)/4. + \
sv,2)*pow(z,-10)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),6)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5) - 12*((-2*k*kv - 2*p*pv)/4. + \
sv)*pow(z,-12)*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*(1 + (t + \
(-pow(k,2) - pow(p,2))/2.)*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),6)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5) + ((-2*k*kvv - 2*p*pvv - 2*pow(kv,2) - \
2*pow(pv,2))*pow(z,-12)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),7)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5))/2. - 2*((-2*k*kv - 2*p*pv)/2. + \
tv)*pow(z,-12)*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*pow(1 + (s \
+ (-pow(k,2) - pow(p,2))/4.)*pow(z,2),7)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-1.5) - 2*((-2*k*kv - 2*p*pv)/4. + \
sv)*pow(z,-12)*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + tz*pow(z,2))*pow(1 + (s \
+ (-pow(k,2) - pow(p,2))/4.)*pow(z,2),7)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-1.5) - 2*((-2*k*kv - 2*p*pv)/4. + \
sv)*pow(z,-13)*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2))*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),7)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-1.5) - 4*pow(z,-14)*(2*((-2*k*kv - \
2*p*pv)/4. + sv)*z + svz*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),7)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5) + 10*pow(z,-14)*(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2))*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + \
tz*pow(z,2))*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2))*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),7)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-1.5) - 2*pow(z,-15)*((1 + (t + \
(-pow(k,2) - pow(p,2))/2.)*pow(z,2))*(-4*((-2*k*kv - 2*p*pv)/4. + \
sv)*pow(z,2) + 4*z*(2*((-2*k*kv - 2*p*pv)/4. + sv)*z + svz*pow(z,2))) - \
z*(((-2*k*kv - 2*p*pv)/2. + tv)*pow(z,2)*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) \
+ sz*pow(z,2)) + ((-2*k*kv - 2*p*pv)/4. + sv)*pow(z,2)*(2*z*(t + (-pow(k,2) - \
pow(p,2))/2.) + tz*pow(z,2))))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),7)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5) - (pow(z,-15)*(-4*z*(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2))*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + \
tz*pow(z,2))*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2)) + (1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*((1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(4*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + \
tz*pow(z,2)) - 2*z*(4*tz*z + 2*(t + (-pow(k,2) - pow(p,2))/2.) + \
tzz*pow(z,2))) + z*pow(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + \
tz*pow(z,2),2)))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),7)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5))/2. - 7*pow(z,-15)*(2*z*(t + (-pow(k,2) - \
pow(p,2))/2.) + tz*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),8)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5) + (pow(z,-14)*(4*tz*z + 2*(t + (-pow(k,2) - \
pow(p,2))/2.) + tzz*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),8)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5))/2. + (pow(z,-14)*pow(2*z*(t + (-pow(k,2) - \
pow(p,2))/2.) + tz*pow(z,2),2)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),8)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5))/2. + 6*pow(z,-14)*pow(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2),2)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),6)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5) + 12*(s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,-14)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),7)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5) + 24*sz*pow(z,-13)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),7)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5) - 6*pow(z,-15)*(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),7)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-1.5) + 12*pow(z,-15)*(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),5)*(-(((-2*k*kv - 2*p*pv)/4. + sv)*(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(z,3)) + z*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*(1 + (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*pow(1 + (t + \
(-pow(k,2) - pow(p,2))/2.)*pow(z,2),2))*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-1.5) - 30*pow(z,-16)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),6)*(-(((-2*k*kv - 2*p*pv)/4. + sv)*(1 + \
(s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(z,3)) + z*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*(1 + (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*pow(1 + (t + \
(-pow(k,2) - pow(p,2))/2.)*pow(z,2),2))*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-1.5) - 2*pow(z,-7)*(1 + (t + \
(-pow(k,2) - pow(p,2))/2.)*pow(z,2))*((1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2))*(-3*((-2*k*kv - 2*p*pv)/4. + sv)*pow(z,2) + \
2*z*(2*((-2*k*kv - 2*p*pv)/4. + sv)*z + svz*pow(z,2))) + ((-2*k*kv - \
2*p*pv)/4. + sv)*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*pow(z,3))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5) + ((-2*k*kv - 2*p*pv)/4. + sv)*pow(z,-6)*(1 \
+ (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(8*((-2*k*kv - 2*p*pv)/4. + \
sv)*(1 + (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*pow(z,4) + z*(-4*z*(2*z*(s \
+ (-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2))*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2)) + \
(-(z*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + tz*pow(z,2))) + 6*(1 + (t + \
(-pow(k,2) - pow(p,2))/2.)*pow(z,2)))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),2)))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5) + 2*pow(z,-6)*(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2))*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + \
tz*pow(z,2))*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2))*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),3)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-0.5) - 3*pow(z,-8)*(1 + (t + \
(-pow(k,2) - pow(p,2))/2.)*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5) - (pow(az,2)*pow(z,-4)*(1 + (t + (-pow(k,2) \
- pow(p,2))/2.)*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5))/4. - pow(z,-8)*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(pow(h + k,2)*pow(z,2) + pow(f + p,2)*pow(z,2))*pow(1 \
+ (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-0.5) - (pow(z,-7)*(1 + (t + \
(-pow(k,2) - pow(p,2))/2.)*pow(z,2))*(6*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) \
+ tz*pow(z,2)) + z*(-4*tz*z - 2*(t + (-pow(k,2) - pow(p,2))/2.) - \
tzz*pow(z,2)))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5))/2. - (pow(z,-6)*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(2*(fv + pv)*z*(f + p + fz*z) + 2*(hv + kv)*z*(h + k \
+ hz*z) + 4*(a + m)*((h + k)*z*(f + p + fz*z) - (f + p)*z*(h + k + hz*z)) - \
(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2))*pow(f + p + fz*z,2) - (1 + (t \
+ (-pow(k,2) - pow(p,2))/2.)*pow(z,2))*pow(h + k + hz*z,2))*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),-0.5))/2. - (pow(1 + (s + (-pow(k,2) \
- pow(p,2))/4.)*pow(z,2),-2)*(z*(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(4*z*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2)) - (1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(-(z*(2*z*(t + (-pow(k,2) - \
pow(p,2))/2.) + tz*pow(z,2))) + 6*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2)))) + z*(-4*((-2*k*kv - 2*p*pv)/4. + sv)*(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(z,3) + ((-2*k*kv - 2*p*pv)/2. + \
tv)*pow(z,3)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),2)))*(-4*pow(z,-8)*(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),3) + 8*pow(z,-9)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5))/4. + pow(z,-6)*pow(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2),2)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),2)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5) + 4*(s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,-6)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),3)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5) + 8*sz*pow(z,-5)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),3)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5) - 6*pow(z,-7)*(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),3)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5) + 6*pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),-0.5) + (z*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(5*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + \
tz*pow(z,2)) - z*(4*tz*z + 2*(t + (-pow(k,2) - pow(p,2))/2.) + \
tzz*pow(z,2)))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5))/2. + pow(z,2)*(pow(hv + kv,2)*pow(z,2) + \
pow(fv + pv,2)*pow(z,2) + 4*(a + m)*(-((hv + kv)*(f + p)*pow(z,2)) + (h + \
k)*(fv + pv)*pow(z,2)) + 4*pow(a + m,2)*(pow(h + k,2)*pow(z,2) + pow(f + \
p,2)*pow(z,2)))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5) - 2*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(-12*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2)) + \
z*(6*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + tz*pow(z,2)) + z*(-4*tz*z - 2*(t \
+ (-pow(k,2) - pow(p,2))/2.) - tzz*pow(z,2))))*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),0.5) - (((-2*k*kv - 2*p*pv)/2. + \
tv)*pow(z,3)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5))/2. - (pow(az,2)*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(z,4)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5))/2. - pow(z,2)*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(2*(fv + pv)*z*(f + p + fz*z) + 2*(hv + kv)*z*(h + k \
+ hz*z) + 4*(a + m)*((h + k)*z*(f + p + fz*z) - (f + p)*z*(h + k + hz*z)) - \
(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2))*pow(f + p + fz*z,2) - (1 + (t \
+ (-pow(k,2) - pow(p,2))/2.)*pow(z,2))*pow(h + k + \
hz*z,2))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5) - (z*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2))*(4*z*(2*z*(s + \
(-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2)) - (1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2))*(-(z*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + \
tz*pow(z,2))) + 6*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2))))*pow(1 + (s \
+ (-pow(k,2) - pow(p,2))/4.)*pow(z,2),-2)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),0.5))/2. - 8*z*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*((1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2))*(-3*((-2*k*kv - 2*p*pv)/4. + sv)*pow(z,2) + \
2*z*(2*((-2*k*kv - 2*p*pv)/4. + sv)*z + svz*pow(z,2))) + ((-2*k*kv - \
2*p*pv)/4. + sv)*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*pow(z,3))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5) - 2*pow((-2*k*kv - 2*p*pv)/4. + \
sv,2)*pow(z,6)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5) + 4*pow(z,2)*(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2))*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + \
tz*pow(z,2))*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2))*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),-1)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),0.5) + (z*(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(-(z*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + \
tz*pow(z,2))) + 6*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2)))*pow(1 + (s \
+ (-pow(k,2) - pow(p,2))/4.)*pow(z,2),-1)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),0.5))/2. - (z*(2*z*(t + (-pow(k,2) - \
pow(p,2))/2.) + tz*pow(z,2))*(4*z*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2)) - (1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(-(z*(2*z*(t + (-pow(k,2) - \
pow(p,2))/2.) + tz*pow(z,2))) + 6*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-1)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5))/2. - ((1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(4*z*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2)) - (1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(-(z*(2*z*(t + (-pow(k,2) - \
pow(p,2))/2.) + tz*pow(z,2))) + 6*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-1)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5))/2. + 2*((-2*k*kv - 2*p*pv)/4. + sv)*(1 + (t \
+ (-pow(k,2) - pow(p,2))/2.)*pow(z,2))*pow(z,3)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-1)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5) + (z*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-2)*(4*(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2))*((1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(-6*((-2*k*kv - 2*p*pv)/4. + sv)*pow(z,2) + \
4*z*(2*((-2*k*kv - 2*p*pv)/4. + sv)*z + svz*pow(z,2))) - z*(((-2*k*kv - \
2*p*pv)/2. + tv)*pow(z,2)*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2)) \
+ ((-2*k*kv - 2*p*pv)/4. + sv)*pow(z,2)*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) \
+ tz*pow(z,2)))) + 8*((-2*k*kv - 2*p*pv)/4. + sv)*(2*z*(s + (-pow(k,2) - \
pow(p,2))/4.) + sz*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(z,3) + 6*((-2*k*kv - 2*p*pv)/2. + \
tv)*pow(z,2)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),2))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5))/2. - (z*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-2)*(-4*((-2*k*kv - 2*p*pv)/4. + sv)*pow(z,2)*(1 + (s \
+ (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2)) - 4*z*(2*((-2*k*kv - 2*p*pv)/4. + sv)*z + \
svz*pow(z,2))*(1 + (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(1 + (t + \
(-pow(k,2) - pow(p,2))/2.)*pow(z,2)) + 2*((-2*k*kv - 2*p*pv)/2. + tv)*(2*z*(s \
+ (-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2))*pow(z,3) - 4*((-2*k*kv - 2*p*pv)/4. + sv)*(2*z*(t + \
(-pow(k,2) - pow(p,2))/2.) + tz*pow(z,2))*(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2))*pow(z,3) - 4*((-2*k*kv - 2*p*pv)/4. + sv)*(2*z*(s + \
(-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(z,3) + ((-2*k*kv - 2*p*pv)/2. + \
tv)*pow(z,2)*pow(1 + (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2),2) + \
z*(2*((-2*k*kv - 2*p*pv)/2. + tv)*z + tvz*pow(z,2))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),2))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5))/2. - (z*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-2)*(-4*z*(2*((-2*k*kv - 2*p*pv)/4. + sv)*z + \
svz*pow(z,2))*(1 + (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(1 + (t + \
(-pow(k,2) - pow(p,2))/2.)*pow(z,2)) + 2*((-2*k*kv - 2*p*pv)/4. + \
sv)*pow(z,2)*(1 + (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(-(z*(2*z*(t + \
(-pow(k,2) - pow(p,2))/2.) + tz*pow(z,2))) + 6*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))) - 4*((-2*k*kv - 2*p*pv)/2. + tv)*(2*z*(s + \
(-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2))*pow(z,3) - 4*((-2*k*kv - 2*p*pv)/4. + sv)*(2*z*(s + \
(-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(z,3) + (6*((-2*k*kv - 2*p*pv)/2. + tv)*pow(z,2) - \
z*(2*((-2*k*kv - 2*p*pv)/2. + tv)*z + tvz*pow(z,2)))*pow(1 + (s + (-pow(k,2) \
- pow(p,2))/4.)*pow(z,2),2))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5))/2. + ((-2*k*kv - 2*p*pv)/4. + \
sv)*pow(z,2)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-3)*(8*((-2*k*kv - 2*p*pv)/4. + sv)*(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*pow(z,4) + z*(-4*z*(2*z*(s + (-pow(k,2) \
- pow(p,2))/4.) + sz*pow(z,2))*(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2))*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2)) + \
(-(z*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + tz*pow(z,2))) + 6*(1 + (t + \
(-pow(k,2) - pow(p,2))/2.)*pow(z,2)))*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),2)))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5) + (2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*pow(1 + (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2),-3)*(z*(1 + (s \
+ (-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(4*z*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2)) - (1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(-(z*(2*z*(t + (-pow(k,2) - \
pow(p,2))/2.) + tz*pow(z,2))) + 6*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2)))) + z*(-4*((-2*k*kv - 2*p*pv)/4. + sv)*(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2))*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*pow(z,3) + ((-2*k*kv - 2*p*pv)/2. + \
tv)*pow(z,3)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),2)))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5) + ((2*z*(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2))*(3*(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + \
tz*pow(z,2)) - z*(4*tz*z + 2*(t + (-pow(k,2) - pow(p,2))/2.) + tzz*pow(z,2))) \
+ pow(z,2)*pow(2*z*(t + (-pow(k,2) - pow(p,2))/2.) + tz*pow(z,2),2) - \
24*pow(1 + (t + (-pow(k,2) - pow(p,2))/2.)*pow(z,2),2))*pow(-(pow(z,-8)*pow(1 \
+ (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),0.5))/2. + \
2*pow(z,2)*pow(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + sz*pow(z,2),2)*pow(1 + \
(s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2),-2)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5) + 4*(s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),-1)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5) - 14*z*(2*z*(s + (-pow(k,2) - pow(p,2))/4.) + \
sz*pow(z,2))*pow(1 + (s + (-pow(k,2) - pow(p,2))/4.)*pow(z,2),-1)*pow(1 + (t \
+ (-pow(k,2) - pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),4)),0.5) + 8*sz*pow(z,3)*pow(1 + (s + \
(-pow(k,2) - pow(p,2))/4.)*pow(z,2),-1)*pow(1 + (t + (-pow(k,2) - \
pow(p,2))/2.)*pow(z,2),2)*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),0.5))*pow(-(pow(z,-8)*pow(1 + (s + (-pow(k,2) - \
pow(p,2))/4.)*pow(z,2),4)),1.5))/2.\"\>"], "Output",
 CellChangeTimes->{3.54434349421563*^9, 3.544343548244679*^9, 
  3.5443448837929487`*^9, 3.544459323429332*^9, 3.544807873132256*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riccistr", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Simplify", "[", "Ricci", "]"}], "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544459335859148*^9, 3.5444593682255497`*^9}}],

Cell[BoxData["\<\"(pow(1 + ((4*s - pow(k,2) - \
pow(p,2))*pow(z,2))/4.,-2)*(8*(-2*(k*kv + p*pv - 2*sv)*(4*s + 2*sz*z - \
pow(k,2) - pow(p,2))*pow(z,2) + (-(k*kv) - p*pv + 2*sv + 4*svz*z)*(4 + \
4*s*pow(z,2) - pow(k,2)*pow(z,2) - pow(p,2)*pow(z,2)))*pow(z,3) + \
8*pow(z,2)*(4 + 4*s*pow(z,2) - pow(k,2)*pow(z,2) - \
pow(p,2)*pow(z,2))*(-2*sz*z - 2*pow(p,2) - 2*szz*pow(z,2) - 6*sz*t*pow(z,3) + \
3*sz*pow(p,2)*pow(z,3) + tz*pow(p,2)*pow(z,3) + s*(8 - 4*tz*pow(z,3)) - \
2*szz*t*pow(z,4) - 2*sz*tz*pow(z,4) + szz*pow(p,2)*pow(z,4) + pow(k,2)*(-2 + \
3*sz*pow(z,3) + tz*pow(z,3) + szz*pow(z,4))) - 4*(2 + 2*t*pow(z,2) - \
pow(k,2)*pow(z,2) - pow(p,2)*pow(z,2))*pow(z,4)*pow(-4*s - 2*sz*z + pow(k,2) \
+ pow(p,2),2) - (12 + 2*t*pow(z,2) - pow(k,2)*pow(z,2) - pow(p,2)*pow(z,2) - \
2*tz*pow(z,3) + tzz*pow(z,4))*pow(-4 - 4*s*pow(z,2) + pow(k,2)*pow(z,2) + \
pow(p,2)*pow(z,2),2)))/16.\"\>"], "Output",
 CellChangeTimes->{3.544459370653853*^9, 3.544807874473281*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<~/Work/AdSCMTDyn2/C/eqn.text\>\"", ",", 
   RowBox[{
   "\"\<\\n\\neq1 = \>\"", "<>", "Eq1str", "<>", "\"\< ; \\n\\neq2 = \>\"", "<>",
     "Eq2str", "<>", "\"\< ; \\n\\neq3 = \>\"", "<>", "Eq3str", "<>", 
    "\"\< ; \\n\\neq4 = \>\"", "<>", "Eq4str", "<>", 
    "\"\< ; \\n\\neq5 = \>\"", "<>", "Eq5str", "<>", 
    "\"\< ; \\n\\nconst1 = \>\"", "<>", "C1str", "<>", 
    "\"\< ; \\n\\nconst2 = \>\"", "<>", "C2str", "<>", 
    "\"\< ; \\n\\nconst3 = \>\"", "<>", "C3str", "<>", 
    "\"\< ; \\n\\nRicci = \>\"", "<>", "Riccistr", "<>", 
    "\"\< ; \\n\\n\>\""}], ",", "\"\<string\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.537499515937183*^9, 3.5374995738978567`*^9}, 
   3.538808081344832*^9, 3.544343447869833*^9, {3.54434450627693*^9, 
   3.544344529774969*^9}, {3.544459386740196*^9, 3.544459394804756*^9}}],

Cell[BoxData["\<\"~/Work/AdSCMTDyn2/C/eqn.text\"\>"], "Output",
 CellChangeTimes->{3.538808035236641*^9, 3.538808081883874*^9, 
  3.543869559068722*^9, 3.543869597832314*^9, 3.544343549463397*^9, 
  3.544344884049696*^9, 3.544345547402849*^9, 3.544459400631795*^9, 
  3.544807875884927*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"f2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"f3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"f4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"f5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"h2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"h3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"h4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"h5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a1", "[", "v", "]"}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"a2", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"z", "^", "2"}], " ", 
        RowBox[{"a3", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"z", "^", "3"}], " ", 
        RowBox[{"a4", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"z", "^", "4"}], " ", 
        RowBox[{"a5", "[", "v", "]"}]}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"t", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"t3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"t4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"t5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"z", " ", 
     RowBox[{"s3", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], " ", 
     RowBox[{"s4", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", 
     RowBox[{"s5", "[", "v", "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5375807547496643`*^9, 3.5375809546462297`*^9}, {
   3.5375810316510153`*^9, 3.5375810327382927`*^9}, 3.537581219874021*^9, {
   3.537581535999511*^9, 3.537581540295803*^9}, {3.537581711272689*^9, 
   3.537581738881206*^9}, 3.537582147695653*^9, {3.537582192382326*^9, 
   3.5375821924540586`*^9}, {3.5443435559395933`*^9, 
   3.5443435621541433`*^9}, {3.5443448850414677`*^9, 3.544344922769004*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq4", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq5", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Const3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5375809932541857`*^9, 3.537581041069994*^9}, {
  3.5375810809508543`*^9, 3.537581091428672*^9}, {3.537581792470584*^9, 
  3.53758183798702*^9}, {3.5443449419877253`*^9, 3.544344942251436*^9}, {
  3.5443450068491707`*^9, 3.54434500793615*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"f3", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", "m", " ", 
      RowBox[{"h2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"a1", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"\[Sigma]r", "[", "v", "]"}], "3"], "2"], "+", 
     RowBox[{
      SuperscriptBox["f2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {-$CellContext`f3[$CellContext`v] + 
    2 $CellContext`m $CellContext`h2[$CellContext`v] + \
$CellContext`a1[$CellContext`v] $CellContext`\[Sigma]i[$CellContext`v] + 
    Rational[1, 
       2] $CellContext`\[Sigma]i[$CellContext`v]^2 \
$CellContext`\[Sigma]r[$CellContext`v] + 
    Rational[1, 2] $CellContext`\[Sigma]r[$CellContext`v]^3 + 
    Derivative[1][$CellContext`f2][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.5443538040192327`*^9, 3.5448078810362473`*^9, 3.544808667260817*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "m", " ", 
       RowBox[{"f2", "[", "v", "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"h3", "[", "v", "]"}]}], "+", 
      SuperscriptBox[
       RowBox[{"\[Sigma]i", "[", "v", "]"}], "3"], "-", 
      RowBox[{"2", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 2] ((-4) $CellContext`m $CellContext`f2[$CellContext`v] - 
     2 $CellContext`h3[$CellContext`v] + \
$CellContext`\[Sigma]i[$CellContext`v]^3 - 
     2 $CellContext`a1[$CellContext`v] $CellContext`\[Sigma]r[$CellContext`v] + \
$CellContext`\[Sigma]i[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v]^2 + 
     2 Derivative[1][$CellContext`h2][$CellContext`v])}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.5443538040192327`*^9, 3.5448078810362473`*^9, 3.544808667263453*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
     RowBox[{"8", " ", "m", " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
     RowBox[{"8", " ", "m", " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["a1", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]i", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]r", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-4) $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma]i[$CellContext`v] + 
    8 $CellContext`m $CellContext`\[Sigma]i[$CellContext`v]^2 + 
    4 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma]r[$CellContext`v] + 
    8 $CellContext`m $CellContext`\[Sigma]r[$CellContext`v]^2 + 
    Derivative[1][$CellContext`a1][$CellContext`v] - 
    4 $CellContext`\[Sigma]r[$CellContext`v] 
    Derivative[1][$CellContext`\[Sigma]i][$CellContext`v] + 
    4 $CellContext`\[Sigma]i[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]r][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.5443538040192327`*^9, 3.5448078810362473`*^9, 3.544808667265565*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"6", " ", 
      RowBox[{"s3", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}]}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   6 $CellContext`s3[$CellContext`v] + 
    2 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma]i[$CellContext`v] + 
    2 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v]}, -1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.5443538040192327`*^9, 3.5448078810362473`*^9, 3.5448086672674103`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        RowBox[{"s3", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}]}], ")"}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   8 (3 $CellContext`s3[$CellContext`v] + $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma]i[$CellContext`v] + $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v])}, -1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.5443538040192327`*^9, 3.5448078810362473`*^9, 3.544808667269279*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"6", " ", 
      RowBox[{"s3", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}]}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   6 $CellContext`s3[$CellContext`v] + 
    2 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma]i[$CellContext`v] + 
    2 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v]}, -1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.5443538040192327`*^9, 3.5448078810362473`*^9, 3.544808667271143*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"a2", "[", "v", "]"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}]}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   2 $CellContext`a2[$CellContext`v] - 
    4 $CellContext`f2[$CellContext`v] $CellContext`\[Sigma]i[$CellContext`v] + 
    4 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma]r[$CellContext`v]},
    0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.5443538040192327`*^9, 3.5448078810362473`*^9, 3.5448086672729797`*^9}],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.5443538040192327`*^9, 3.5448078810362473`*^9, 3.544808679743867*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"repl1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"a2", "[", "v", "]"}], ",", 
        RowBox[{"f3", "[", "v", "]"}], ",", 
        RowBox[{"h3", "[", "v", "]"}], ",", 
        RowBox[{"s3", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537581094869306*^9, 3.5375811411847267`*^9}, {
  3.537581846545319*^9, 3.5375818604809847`*^9}, {3.5448085577624598`*^9, 
  3.544808567240943*^9}, {3.5448086869986143`*^9, 3.544808691694501*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a1", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"f2", "[", "v", "]"}]}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
       RowBox[{"2", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"h2", "[", "v", "]"}], "+", 
          RowBox[{"2", " ", "m", " ", 
           RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["\[Sigma]i", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]r", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"a2", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{"f3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", "m", " ", 
        RowBox[{"h2", "[", "v", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
       SuperscriptBox[
        RowBox[{"\[Sigma]r", "[", "v", "]"}], "3"], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"h3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", "m", " ", 
        RowBox[{"f2", "[", "v", "]"}]}], "+", 
       SuperscriptBox[
        RowBox[{"\[Sigma]i", "[", "v", "]"}], "3"], "-", 
       RowBox[{"2", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"s3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"h2", "[", "v", "]"}]}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "-", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.543869623767411*^9, 3.5443435671485567`*^9, {3.544344892724921*^9, 
   3.5443449446413383`*^9}, 3.544345010016996*^9, 3.5443538049548693`*^9, {
   3.544808554909465*^9, 3.544808558415277*^9}, 3.54480868766774*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"repl", "=", 
    RowBox[{"Join", "[", " ", 
     RowBox[{"repl1", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl1", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq5", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Const3", "/.", "repl"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537581149514593*^9, 3.5375811704734163`*^9}, {
  3.537581319335538*^9, 3.537581326214385*^9}, {3.53758187837607*^9, 
  3.5375818960440483`*^9}, {3.544345016120763*^9, 3.544345020407825*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       RowBox[{"f4", "[", "v", "]"}]}], "+", 
      RowBox[{"6", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "+", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]i", "[", "v", "]"}], "3"]}], "-", 
      RowBox[{"8", " ", "m", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
      RowBox[{
       RowBox[{"t3", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
      RowBox[{"6", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
      RowBox[{"2", " ", "m", " ", 
       RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["m", "2"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a1", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"16", " ", "m", " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]i", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]i", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]r", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]r", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 2] ((-6) $CellContext`f4[$CellContext`v] + 
     6 $CellContext`a1[$CellContext`v] $CellContext`h2[$CellContext`v] + 
     2 $CellContext`m $CellContext`\[Sigma]i[$CellContext`v]^3 - 
     8 $CellContext`m $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v] - $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v] - 
     6 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma]i[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v] + 
     2 $CellContext`m $CellContext`\[Sigma]i[$CellContext`v] $CellContext`\
\[Sigma]r[$CellContext`v]^2 + $CellContext`f2[$CellContext`v] ((-16) \
$CellContext`m^2 + 11 $CellContext`\[Sigma]i[$CellContext`v]^2 + 
       5 $CellContext`\[Sigma]r[$CellContext`v]^2) + 
     4 $CellContext`\[Sigma]i[$CellContext`v] 
      Derivative[1][$CellContext`a1][$CellContext`v] + 
     16 $CellContext`m Derivative[1][$CellContext`h2][$CellContext`v] + 
     4 $CellContext`a1[$CellContext`v] 
      Derivative[1][$CellContext`\[Sigma]i][$CellContext`v] + 
     3 $CellContext`\[Sigma]i[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v] 
      Derivative[
       1][$CellContext`\[Sigma]i][$CellContext`v] + \
$CellContext`\[Sigma]i[$CellContext`v]^2 
      Derivative[1][$CellContext`\[Sigma]r][$CellContext`v] + 
     4 $CellContext`\[Sigma]r[$CellContext`v]^2 
      Derivative[1][$CellContext`\[Sigma]r][$CellContext`v] + 
     4 Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353805866143*^9, 3.544808572131074*^9, 
  3.544808656944264*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       RowBox[{"h4", "[", "v", "]"}]}], "-", 
      RowBox[{
       RowBox[{"t3", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "-", 
      RowBox[{"6", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
       RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
      RowBox[{"2", " ", "m", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]r", "[", "v", "]"}], "3"]}], "+", 
      RowBox[{
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["m", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "+", 
         RowBox[{"11", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a1", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"16", " ", "m", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]i", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]i", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]r", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"f2", "[", "v", "]"}]}], "+", 
         RowBox[{"4", " ", "m", " ", 
          RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]r", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 
      2] ((-6) $CellContext`h4[$CellContext`v] - \
$CellContext`t3[$CellContext`v] $CellContext`\[Sigma]i[$CellContext`v] - 
     6 $CellContext`f2[$CellContext`v] $CellContext`\[Sigma]i[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v] - 
     2 $CellContext`m $CellContext`\[Sigma]i[$CellContext`v]^2 $CellContext`\
\[Sigma]r[$CellContext`v] - 
     2 $CellContext`m $CellContext`\[Sigma]r[$CellContext`v]^3 + \
$CellContext`h2[$CellContext`v] ((-16) $CellContext`m^2 + 
       5 $CellContext`\[Sigma]i[$CellContext`v]^2 + 
       11 $CellContext`\[Sigma]r[$CellContext`v]^2) - 
     4 $CellContext`\[Sigma]r[$CellContext`v] 
     Derivative[1][$CellContext`a1][$CellContext`v] - 16 $CellContext`m 
     Derivative[1][$CellContext`f2][$CellContext`v] + 
     4 $CellContext`\[Sigma]i[$CellContext`v]^2 
      Derivative[
       1][$CellContext`\[Sigma]i][$CellContext`v] + \
$CellContext`\[Sigma]r[$CellContext`v]^2 
      Derivative[1][$CellContext`\[Sigma]i][$CellContext`v] + 
     3 $CellContext`\[Sigma]i[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v] 
      Derivative[1][$CellContext`\[Sigma]r][$CellContext`v] - 
     2 $CellContext`a1[$CellContext`v] (3 $CellContext`f2[$CellContext`v] + 
      4 $CellContext`m $CellContext`\[Sigma]i[$CellContext`v] + 
      2 Derivative[1][$CellContext`\[Sigma]r][$CellContext`v]) + 
     4 Derivative[2][$CellContext`h2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353805866143*^9, 3.544808572131074*^9, 
  3.544808656947454*^9}],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "z", "]"}], "2"],
  SeriesData[$CellContext`z, 0, {}, 2, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353805866143*^9, 3.544808572131074*^9, 
  3.544808656949417*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "8"]}], " ", 
      SuperscriptBox[
       RowBox[{"a1", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"9", " ", 
         SuperscriptBox[
          RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox[
          RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"48", " ", 
         RowBox[{"s4", "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"t4", "[", "v", "]"}]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "4"]}], "+", 
        RowBox[{"30", " ", "m", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]r", "[", "v", "]"}], "4"]}], "+", 
        RowBox[{"13", " ", 
         RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"13", " ", 
         RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Sigma]i", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"f2", "[", "v", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"15", " ", "m", " ", 
            RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["\[Sigma]r", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], 
       ")"}]}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[-1, 8] $CellContext`a1[$CellContext`v]^2 + 
    Rational[1, 6] (9 $CellContext`f2[$CellContext`v]^2 + 
      9 $CellContext`h2[$CellContext`v]^2 + 
      48 $CellContext`s4[$CellContext`v] + 3 $CellContext`t4[$CellContext`v] + 
      6 $CellContext`\[Sigma]i[$CellContext`v]^4 + 
      30 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v] + 
      12 $CellContext`\[Sigma]i[$CellContext`v]^2 \
$CellContext`\[Sigma]r[$CellContext`v]^2 + 
      6 $CellContext`\[Sigma]r[$CellContext`v]^4 + 
      13 $CellContext`\[Sigma]r[$CellContext`v] 
       Derivative[1][$CellContext`f2][$CellContext`v] + 
      13 $CellContext`\[Sigma]i[$CellContext`v] 
       Derivative[1][$CellContext`h2][$CellContext`v] - 
      2 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`\[Sigma]i][$CellContext`v] - 
      2 $CellContext`f2[$CellContext`v] (
       15 $CellContext`m $CellContext`\[Sigma]i[$CellContext`v] + 
       Derivative[1][$CellContext`\[Sigma]r][$CellContext`v]))}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353805866143*^9, 3.544808572131074*^9, 
  3.544808656951419*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"a1", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"40", " ", 
      RowBox[{"s4", "[", "v", "]"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"t4", "[", "v", "]"}]}], "-", 
     RowBox[{"28", " ", "m", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
     FractionBox[
      RowBox[{"21", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]i", "[", "v", "]"}], "4"]}], "4"], "+", 
     RowBox[{"28", " ", "m", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
     RowBox[{
      FractionBox["21", "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
     FractionBox[
      RowBox[{"21", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]r", "[", "v", "]"}], "4"]}], "4"], "+", 
     RowBox[{
      FractionBox["34", "3"], " ", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f2", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "+", 
     RowBox[{
      FractionBox["34", "3"], " ", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h2", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "-", 
     RowBox[{
      FractionBox["8", "3"], " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]i", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "-", 
     RowBox[{
      FractionBox["8", "3"], " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]r", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {-$CellContext`a1[$CellContext`v]^2 + 
    8 $CellContext`f2[$CellContext`v]^2 + 8 $CellContext`h2[$CellContext`v]^2 + 
    40 $CellContext`s4[$CellContext`v] + 4 $CellContext`t4[$CellContext`v] - 
    28 $CellContext`m $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma]i[$CellContext`v] + 
    Rational[21, 4] $CellContext`\[Sigma]i[$CellContext`v]^4 + 
    28 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v] + 
    Rational[21, 
       2] $CellContext`\[Sigma]i[$CellContext`v]^2 \
$CellContext`\[Sigma]r[$CellContext`v]^2 + 
    Rational[21, 4] $CellContext`\[Sigma]r[$CellContext`v]^4 + 
    Rational[34, 3] $CellContext`\[Sigma]r[$CellContext`v] 
     Derivative[1][$CellContext`f2][$CellContext`v] + 
    Rational[34, 3] $CellContext`\[Sigma]i[$CellContext`v] 
     Derivative[1][$CellContext`h2][$CellContext`v] + 
    Rational[-8, 3] $CellContext`h2[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]i][$CellContext`v] + 
    Rational[-8, 3] $CellContext`f2[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]r][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353805866143*^9, 3.544808572131074*^9, 
  3.544808656953874*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"12", " ", 
      RowBox[{"s4", "[", "v", "]"}]}], "-", 
     RowBox[{"6", " ", "m", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
     FractionBox[
      RowBox[{"11", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]i", "[", "v", "]"}], "4"]}], "8"], "+", 
     RowBox[{"6", " ", "m", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
     RowBox[{
      FractionBox["11", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
     FractionBox[
      RowBox[{"11", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]r", "[", "v", "]"}], "4"]}], "8"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f2", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "+", 
     RowBox[{"3", " ", 
      RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h2", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   2 $CellContext`f2[$CellContext`v]^2 + 2 $CellContext`h2[$CellContext`v]^2 + 
    12 $CellContext`s4[$CellContext`v] - 
    6 $CellContext`m $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma]i[$CellContext`v] + 
    Rational[11, 8] $CellContext`\[Sigma]i[$CellContext`v]^4 + 
    6 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v] + 
    Rational[11, 
       4] $CellContext`\[Sigma]i[$CellContext`v]^2 \
$CellContext`\[Sigma]r[$CellContext`v]^2 + 
    Rational[11, 8] $CellContext`\[Sigma]r[$CellContext`v]^4 + 
    3 $CellContext`\[Sigma]r[$CellContext`v] 
     Derivative[1][$CellContext`f2][$CellContext`v] + 
    3 $CellContext`\[Sigma]i[$CellContext`v] 
     Derivative[1][$CellContext`h2][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353805866143*^9, 3.544808572131074*^9, 
  3.544808656956066*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       RowBox[{"a3", "[", "v", "]"}]}], "-", 
      RowBox[{"16", " ", "m", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "-", 
      RowBox[{"9", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"16", " ", "m", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
      RowBox[{"9", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"8", " ", 
       RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   6 $CellContext`a3[$CellContext`v] - 
    16 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma]i[$CellContext`v] - 
    9 $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma]i[$CellContext`v]^2 - 
    16 $CellContext`m $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v] - 
    9 $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma]r[$CellContext`v]^2 - 
    8 $CellContext`\[Sigma]i[$CellContext`v] 
    Derivative[1][$CellContext`f2][$CellContext`v] + 
    8 $CellContext`\[Sigma]r[$CellContext`v] 
     Derivative[1][$CellContext`h2][$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353805866143*^9, 3.544808572131074*^9, 
  3.544808656958024*^9}],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353805866143*^9, 3.544808572131074*^9, 
  3.544808661021449*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"repl2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"t3", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"a3", "[", "v", "]"}], ",", 
        RowBox[{"t4", "[", "v", "]"}], ",", 
        RowBox[{"s4", "[", "v", "]"}], ",", 
        RowBox[{"h4", "[", "v", "]"}], ",", 
        RowBox[{"f4", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537581176657216*^9, 3.537581176712451*^9}, {
  3.537581208479423*^9, 3.5375812350544767`*^9}, {3.537581285831032*^9, 
  3.537581335172854*^9}, {3.537581579672551*^9, 3.537581582928306*^9}, {
  3.537581907656845*^9, 3.537581928696844*^9}, {3.53758196021669*^9, 
  3.537581962015414*^9}, {3.537582000083522*^9, 3.537582009971553*^9}, {
  3.544808587720956*^9, 3.544808592248575*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "svars"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.5448085887052937`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"16", " ", "m", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "m", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
          RowBox[{
           RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{
           RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"t4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"a1", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]i", "[", "v", "]"}], "4"], "+", 
          RowBox[{"12", " ", "m", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]r", "[", "v", "]"}], "4"], "+", 
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]i", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "m", " ", 
              RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["\[Sigma]r", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"s4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "96"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox[
         RowBox[{"f2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox[
         RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{"48", " ", "m", " ", 
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "-", 
       RowBox[{"11", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "4"]}], "-", 
       RowBox[{"48", " ", "m", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
       RowBox[{"22", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"11", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "4"]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"h4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"t3", "[", "v", "]"}]}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "-", 
       RowBox[{"6", " ", 
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
       RowBox[{"2", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
       RowBox[{"2", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "3"]}], "+", 
       RowBox[{
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["m", "2"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"11", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["a1", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"16", " ", "m", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]i", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]i", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]r", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"f2", "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", "m", " ", 
           RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]r", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"f4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "3"]}], "-", 
       RowBox[{
        RowBox[{"t3", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
       RowBox[{"6", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["m", "2"]}], "+", 
          RowBox[{"11", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["a1", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"16", " ", "m", " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]i", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           RowBox[{"h2", "[", "v", "]"}]}], "-", 
          RowBox[{"8", " ", "m", " ", 
           RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]i", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]r", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]r", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.543869626109274*^9, 3.544343576234599*^9, 
  3.544345024854578*^9, 3.544353806667728*^9, 3.544808588784609*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"repl", "=", 
    RowBox[{"Join", "[", " ", 
     RowBox[{"repl1", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl1", ",", "v"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl1", ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", "repl2", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl2", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq5", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Const3", "//.", "repl"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537581149514593*^9, 3.5375811704734163`*^9}, {
  3.537581319335538*^9, 3.537581326214385*^9}, {3.53758187837607*^9, 
  3.5375818960440483`*^9}, {3.537582027350095*^9, 3.537582048852798*^9}, {
  3.537582117159115*^9, 3.537582123535061*^9}, {3.544345027969656*^9, 
  3.544345029256832*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["21", "4"]}], " ", 
       SuperscriptBox[
        RowBox[{"a1", "[", "v", "]"}], "2"], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"8", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "m", " ", 
          RowBox[{"f2", "[", "v", "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], "+", 
         RowBox[{"m", " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "12"}], " ", 
          RowBox[{"f5", "[", "v", "]"}]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["m", "3"], " ", 
          RowBox[{"h2", "[", "v", "]"}]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"f2", "[", "v", "]"}], " ", 
          RowBox[{"t3", "[", "v", "]"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox[
           RowBox[{"f2", "[", "v", "]"}], "2"], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
         RowBox[{"38", " ", 
          SuperscriptBox[
           RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
         RowBox[{"58", " ", "m", " ", 
          RowBox[{"h2", "[", "v", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["m", "2"], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "5"]}], "-", 
         RowBox[{"48", " ", 
          SuperscriptBox["m", "2"], " ", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"13", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "-", 
         RowBox[{
          RowBox[{"t3", "[", "v", "]"}], " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"f2", "[", "v", "]"}], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}], "2"]}], "+", 
         RowBox[{"24", " ", "m", " ", 
          RowBox[{
           SuperscriptBox["h2", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{
           SuperscriptBox["f2", 
            TagBox[
             RowBox[{"(", "3", ")"}],
             Derivative],
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ")"}], 
    " ", 
    SuperscriptBox["z", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[-21, 
       4] $CellContext`a1[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] - 
    8 $CellContext`a1[$CellContext`v] (
     2 $CellContext`m $CellContext`f2[$CellContext`v] - Derivative[
     1][$CellContext`h2][$CellContext`v] + $CellContext`m 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v]) + 
    Rational[1, 2] ((-12) $CellContext`f5[$CellContext`v] - 
      32 $CellContext`m^3 $CellContext`h2[$CellContext`v] - 
      4 $CellContext`f2[$CellContext`v] $CellContext`t3[$CellContext`v] + 
      6 $CellContext`f2[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] - 
      38 $CellContext`h2[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] + 
      58 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
      128 $CellContext`m^2 $CellContext`\[Sigma][$CellContext`v]^3 + 
      4 $CellContext`\[Sigma][$CellContext`v]^5 - 48 $CellContext`m^2 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
      13 $CellContext`\[Sigma][$CellContext`v]^2 
       Derivative[
        1][$CellContext`f2][$CellContext`v] - $CellContext`t3[$CellContext`v] 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
      4 $CellContext`f2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
       Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
      8 $CellContext`\[Sigma][$CellContext`v] 
       Derivative[1][$CellContext`\[Sigma]][$CellContext`v]^2 + 
      24 $CellContext`m Derivative[2][$CellContext`h2][$CellContext`v] + 
      3 $CellContext`\[Sigma][$CellContext`v]^2 
       Derivative[2][$CellContext`\[Sigma]][$CellContext`v] + 
      4 Derivative[3][$CellContext`f2][$CellContext`v])}, 2, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.544353807609173*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       RowBox[{"h5", "[", "v", "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"t3", "[", "v", "]"}]}], "+", 
      RowBox[{"m", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["m", "3"]}], "+", 
         RowBox[{"11", " ", 
          RowBox[{"h2", "[", "v", "]"}], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
         RowBox[{"4", " ", "m", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox["m", "2"], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"34", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"57", " ", "m", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"12", " ", "m", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", "m", " ", 
          RowBox[{"h2", "[", "v", "]"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["m", "2"], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "-", 
         RowBox[{"8", " ", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["h2", 
         TagBox[
          RowBox[{"(", "3", ")"}],
          Derivative],
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", 
    SuperscriptBox["z", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-6) $CellContext`h5[$CellContext`v] - 
    2 $CellContext`h2[$CellContext`v] $CellContext`t3[$CellContext`v] + \
$CellContext`m $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    2 $CellContext`f2[$CellContext`v] (8 $CellContext`m^3 + 
      11 $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
      4 $CellContext`m $CellContext`\[Sigma][$CellContext`v]^2) - 
    24 $CellContext`m^2 Derivative[1][$CellContext`h2][$CellContext`v] + 
    20 $CellContext`\[Sigma][$CellContext`v]^2 
     Derivative[1][$CellContext`h2][$CellContext`v] + 
    34 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
    57 $CellContext`m $CellContext`\[Sigma][$CellContext`v]^2 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 12 $CellContext`m 
    Derivative[
     2][$CellContext`f2][$CellContext`v] + $CellContext`a1[$CellContext`v] \
((-16) $CellContext`m $CellContext`h2[$CellContext`v] + 
      8 $CellContext`m^2 $CellContext`\[Sigma][$CellContext`v] - 
      9 $CellContext`\[Sigma][$CellContext`v]^3 - 8 
      Derivative[1][$CellContext`f2][$CellContext`v] - 2 
      Derivative[2][$CellContext`\[Sigma]][$CellContext`v]) + 
    2 Derivative[3][$CellContext`h2][$CellContext`v]}, 2, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.544353807721243*^9}],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "z", "]"}], "3"],
  SeriesData[$CellContext`z, 0, {}, 3, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.544353807754524*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"60", " ", 
       RowBox[{"s5", "[", "v", "]"}]}], "+", 
      RowBox[{"6", " ", 
       RowBox[{"t5", "[", "v", "]"}]}], "-", 
      RowBox[{"48", " ", 
       SuperscriptBox["m", "2"], " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"24", " ", "m", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"19", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
      RowBox[{"20", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"20", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"42", " ", "m", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"6", " ", "m", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"9", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 6] (60 $CellContext`s5[$CellContext`v] + 
     6 $CellContext`t5[$CellContext`v] - 
     48 $CellContext`m^2 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] - 
     24 $CellContext`m $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - 
     3 $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
     19 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 + 
     20 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
     20 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     42 $CellContext`m $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] - 
     6 $CellContext`m $CellContext`h2[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     8 $CellContext`\[Sigma][$CellContext`v]^3 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 3 
     Derivative[1][$CellContext`f2][$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     9 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.5443538078774*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"180", " ", 
       RowBox[{"s5", "[", "v", "]"}]}], "+", 
      RowBox[{"30", " ", 
       RowBox[{"t5", "[", "v", "]"}]}], "-", 
      RowBox[{"176", " ", 
       SuperscriptBox["m", "2"], " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
      RowBox[{"12", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"88", " ", "m", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"11", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"61", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
      RowBox[{"64", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"64", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"146", " ", "m", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"30", " ", "m", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"15", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"29", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 3] (180 $CellContext`s5[$CellContext`v] + 
     30 $CellContext`t5[$CellContext`v] - 
     176 $CellContext`m^2 $CellContext`f2[$CellContext`v] $CellContext`\
\[Sigma][$CellContext`v] + 
     12 $CellContext`a1[$CellContext`v] $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] - 
     88 $CellContext`m $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - 
     11 $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
     61 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 + 
     64 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
     64 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     146 $CellContext`m $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] - 
     30 $CellContext`m $CellContext`h2[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     24 $CellContext`\[Sigma][$CellContext`v]^3 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 15 
     Derivative[1][$CellContext`f2][$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     29 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.544353807996064*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"60", " ", 
       RowBox[{"s5", "[", "v", "]"}]}], "-", 
      RowBox[{"6", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"16", " ", "m", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "32"}], " ", 
          SuperscriptBox["m", "2"], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
         RowBox[{"18", " ", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"32", " ", "m", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 3] (60 $CellContext`s5[$CellContext`v] - 
     6 $CellContext`a1[$CellContext`v] $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] - 
     16 $CellContext`m $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - 
     2 $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + $CellContext`f2[$CellContext`v] \
((-32) $CellContext`m^2 $CellContext`\[Sigma][$CellContext`v] + 
       17 $CellContext`\[Sigma][$CellContext`v]^3 + 
       18 Derivative[1][$CellContext`f2][$CellContext`v]) + 
     18 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     32 $CellContext`m $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     8 $CellContext`\[Sigma][$CellContext`v]^3 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     8 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.544353808047286*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "6"}], " ", 
        RowBox[{"a4", "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           RowBox[{"a1", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "m", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"14", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "-", 
          RowBox[{"15", " ", "m", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "+", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", "m", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"a1", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ")"}], 
     " ", 
     SuperscriptBox["z", "2"]}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-2) ((-6) $CellContext`a4[$CellContext`v] + 
     4 $CellContext`m $CellContext`f2[$CellContext`v]^2 + \
$CellContext`f2[$CellContext`v] (
       9 $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] - 2 
       Derivative[1][$CellContext`h2][$CellContext`v]) + 
     2 (2 $CellContext`m $CellContext`h2[$CellContext`v]^2 + 
       8 $CellContext`m^2 $CellContext`h2[$CellContext`v] $CellContext`\
\[Sigma][$CellContext`v] - 
       14 $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 - 
       15 $CellContext`m $CellContext`\[Sigma][$CellContext`v]^4 + \
$CellContext`h2[$CellContext`v] 
        Derivative[1][$CellContext`f2][$CellContext`v] + 
       8 $CellContext`m $CellContext`\[Sigma][$CellContext`v] 
        Derivative[1][$CellContext`f2][$CellContext`v] + 
       2 $CellContext`a1[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]
          Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 
       2 $CellContext`\[Sigma][$CellContext`v] 
       Derivative[2][$CellContext`h2][$CellContext`v]))}, 2, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.54435380808353*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"60", " ", 
       RowBox[{"s5", "[", "v", "]"}]}], "+", 
      RowBox[{"6", " ", 
       RowBox[{"t5", "[", "v", "]"}]}], "-", 
      RowBox[{"48", " ", 
       SuperscriptBox["m", "2"], " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"24", " ", "m", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"19", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
      RowBox[{"20", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"20", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"42", " ", "m", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"6", " ", "m", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"9", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 6] (60 $CellContext`s5[$CellContext`v] + 
     6 $CellContext`t5[$CellContext`v] - 
     48 $CellContext`m^2 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] - 
     24 $CellContext`m $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - 
     3 $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
     19 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 + 
     20 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
     20 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     42 $CellContext`m $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] - 
     6 $CellContext`m $CellContext`h2[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     8 $CellContext`\[Sigma][$CellContext`v]^3 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 3 
     Derivative[1][$CellContext`f2][$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     9 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.5443538084247847`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"repl3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a4", "[", "v", "]"}], ",", 
        RowBox[{"t5", "[", "v", "]"}], ",", 
        RowBox[{"s5", "[", "v", "]"}], ",", 
        RowBox[{"h5", "[", "v", "]"}], ",", 
        RowBox[{"f5", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537581176657216*^9, 3.537581176712451*^9}, {
  3.537581208479423*^9, 3.5375812350544767`*^9}, {3.537581285831032*^9, 
  3.537581335172854*^9}, {3.537581579672551*^9, 3.537581582928306*^9}, {
  3.537581907656845*^9, 3.537581928696844*^9}, {3.53758196021669*^9, 
  3.537581962015414*^9}, {3.537582000083522*^9, 3.537582009971553*^9}, {
  3.537582054866674*^9, 3.537582086618279*^9}, {3.5375821613248863`*^9, 
  3.5375822160917*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           RowBox[{"a1", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "m", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"8", " ", 
              SuperscriptBox["m", "2"], " ", 
              RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
             RowBox[{"14", " ", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
             RowBox[{
              SuperscriptBox["f2", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "15"}], " ", "m", " ", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
             RowBox[{"8", " ", "m", " ", 
              RowBox[{
               SuperscriptBox["f2", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"a1", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["\[Sigma]", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["h2", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"t5", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"t3", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "6"}], " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", "m", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], "-", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"10", " ", "m", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"6", " ", "m", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"s5", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "60"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"32", " ", 
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"17", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "-", 
          RowBox[{"18", " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"t3", "[", "v", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{
           RowBox[{"a1", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              RowBox[{"h2", "[", "v", "]"}]}], "+", 
             RowBox[{"8", " ", "m", " ", 
              RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "-", 
          RowBox[{"9", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"16", " ", "m", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"h5", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"t3", "[", "v", "]"}]}], "+", 
       RowBox[{"m", " ", 
        RowBox[{"t3", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["m", "3"]}], "+", 
          RowBox[{"11", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", "m", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
       RowBox[{"24", " ", 
        SuperscriptBox["m", "2"], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"20", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"34", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"57", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"12", " ", "m", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", "m", " ", 
           RowBox[{"h2", "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"9", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "-", 
          RowBox[{"8", " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["h2", 
          TagBox[
           RowBox[{"(", "3", ")"}],
           Derivative],
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"f5", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "21"}], " ", 
        SuperscriptBox[
         RowBox[{"a1", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
       RowBox[{"32", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "m", " ", 
           RowBox[{"f2", "[", "v", "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["h2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}], "+", 
          RowBox[{"m", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{"t3", "[", "v", "]"}]}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox[
            RowBox[{"f2", "[", "v", "]"}], "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"38", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["m", "2"], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "5"]}], "+", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "32"}], " ", 
              SuperscriptBox["m", "3"]}], "+", 
             RowBox[{"58", " ", "m", " ", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox["m", "2"], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"13", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{
           RowBox[{"t3", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["\[Sigma]", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"24", " ", "m", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["f2", 
             TagBox[
              RowBox[{"(", "3", ")"}],
              Derivative],
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.543869628925858*^9, 3.544343582081397*^9, 
  3.544345033702104*^9, 3.544353808639522*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["repl1"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a1", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h2", "[", "v", "]"}], "+", 
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"a2", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"h2", "[", "v", "]"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"f3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", "m", " ", 
      RowBox[{"h2", "[", "v", "]"}]}], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], "2"], "+", 
     RowBox[{
      SuperscriptBox["f2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"h3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "m", " ", 
      RowBox[{"f2", "[", "v", "]"}]}], "-", 
     RowBox[{
      RowBox[{"a1", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["h2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"s3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "3"]}], " ", 
     RowBox[{"f2", "[", "v", "]"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5443435880758*^9, 3.5443435947842493`*^9}, 
   3.5443450350999317`*^9, 3.5443538095138283`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["repl2"], "Input",
 CellChangeTimes->{{3.543869819536687*^9, 3.543869819687505*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"16", " ", "m", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], ")"}]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "m", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
          RowBox[{
           RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{
           RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"t4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"a1", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]i", "[", "v", "]"}], "4"], "+", 
          RowBox[{"12", " ", "m", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]r", "[", "v", "]"}], "4"], "+", 
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]i", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "m", " ", 
              RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["\[Sigma]r", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"s4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "96"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox[
         RowBox[{"f2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox[
         RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{"48", " ", "m", " ", 
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "-", 
       RowBox[{"11", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "4"]}], "-", 
       RowBox[{"48", " ", "m", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
       RowBox[{"22", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"11", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "4"]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"h4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"t3", "[", "v", "]"}]}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "-", 
       RowBox[{"6", " ", 
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
       RowBox[{"2", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
       RowBox[{"2", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "3"]}], "+", 
       RowBox[{
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["m", "2"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"11", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["a1", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"16", " ", "m", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]i", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]i", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]r", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"f2", "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", "m", " ", 
           RowBox[{"\[Sigma]i", "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]r", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"f4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "3"]}], "-", 
       RowBox[{
        RowBox[{"t3", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "-", 
       RowBox[{"6", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["m", "2"]}], "+", 
          RowBox[{"11", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["a1", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"16", " ", "m", " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"\[Sigma]i", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]r", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]i", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           RowBox[{"h2", "[", "v", "]"}]}], "-", 
          RowBox[{"8", " ", "m", " ", 
           RowBox[{"\[Sigma]r", "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]i", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[Sigma]i", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]r", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]r", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]r", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5438698201278677`*^9, 3.543869829239614*^9}, 
   3.5443436947368526`*^9, 3.5443450562457457`*^9, 3.544353810348523*^9, 
   3.544808646795353*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"bceq2", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "+", 
    RowBox[{"2", "m", " ", 
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{"2", "z", " ", "m", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}]}], "-", 
    RowBox[{"z", " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}]}], "-", " ", 
    RowBox[{"z", " ", 
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "2"}], "}"}]}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.537583454390378*^9, 3.537583584316988*^9}, {
  3.537583627792901*^9, 3.5375836286954517`*^9}, {3.53758367467208*^9, 
  3.537583682998909*^9}, {3.537583741939487*^9, 3.53758374254697*^9}, {
  3.537583789908886*^9, 3.53758380650729*^9}, {3.537583864503531*^9, 
  3.53758392754637*^9}, {3.537584157247345*^9, 3.5375841601333523`*^9}, {
  3.543869890921344*^9, 3.54386989227345*^9}, {3.544343698791573*^9, 
  3.544343703070735*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"bceq2", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "+", 
    RowBox[{"2", " ", "m", " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{"2", "z", " ", "m", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}]}], "-", 
    RowBox[{"z", " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{
      RowBox[{"\[Sigma]", "''"}], "[", "v", "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.537584449977281*^9, 3.537584540147512*^9}, {
  3.543869873209931*^9, 3.5438698836492434`*^9}, {3.544343706622446*^9, 
  3.544343710981886*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"bceq2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5375835627555237`*^9, 3.537583563483652*^9}, {
  3.5375837293866577`*^9, 3.537583730810493*^9}, {3.5375839307205544`*^9, 
  3.537583938135961*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "m", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["t3", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], "+", 
      RowBox[{
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["f2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], "-", 
         RowBox[{
          SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], ")"}], " ",
     "z"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   2 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    4 $CellContext`m^2 $CellContext`\[Sigma][$CellContext`v]^2 + 
    Derivative[
     1][$CellContext`t3][$CellContext`v] + \
$CellContext`\[Sigma][$CellContext`v] (
      Derivative[1][$CellContext`f2][$CellContext`v] - Derivative[
      2][$CellContext`\[Sigma]][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869801272677*^9, {3.543869874772071*^9, 3.5438698971663313`*^9}, 
   3.544343716440422*^9, 3.544345059532452*^9, 3.544353812989098*^9, 
   3.544353989933282*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"tmp", "/.", "repl2"}], "]"}]], "Input",
 CellChangeTimes->{{3.537583943735824*^9, 3.537583946472803*^9}}],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "z", "]"}], "2"],
  SeriesData[$CellContext`z, 0, {}, 2, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869802865644*^9, {3.5438698763090973`*^9, 3.54386989771704*^9}, 
   3.544343717156042*^9, 3.544345060433576*^9, 3.544353813604308*^9, 
   3.544353990984666*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"bceq3", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], ",", "z"}], "]"}],
     "+", 
    RowBox[{"2", " ", "m", " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], "+", 
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], ",", "z"}], 
      "]"}]}], "-", " ", 
    RowBox[{
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{
      RowBox[{"\[Sigma]", "''"}], "[", "v", "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.537584449977281*^9, 3.537584540147512*^9}, {
  3.543869873209931*^9, 3.5438698836492434`*^9}, {3.544343706622446*^9, 
  3.544343710981886*^9}, {3.544354008523074*^9, 3.544354014667173*^9}, {
  3.5443540602132998`*^9, 3.54435410108786*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"bceq3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5375835627555237`*^9, 3.537583563483652*^9}, {
   3.5375837293866577`*^9, 3.537583730810493*^9}, {3.5375839307205544`*^9, 
   3.537583938135961*^9}, {3.544354018849914*^9, 3.544354018937799*^9}, 
   3.544354077853743*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "m", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["m", "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["t3", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}], "+", 
     RowBox[{
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}], "-", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   2 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    4 $CellContext`m^2 $CellContext`\[Sigma][$CellContext`v]^2 + 
    Derivative[
     1][$CellContext`t3][$CellContext`v] + \
$CellContext`\[Sigma][$CellContext`v] (
      Derivative[1][$CellContext`f2][$CellContext`v] - Derivative[
      2][$CellContext`\[Sigma]][$CellContext`v])}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869801272677*^9, {3.543869874772071*^9, 3.5438698971663313`*^9}, 
   3.544343716440422*^9, 3.544345059532452*^9, 3.544353812989098*^9, {
   3.544353989933282*^9, 3.544354019361783*^9}, {3.5443540496198053`*^9, 
   3.544354115366165*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"tmp", "/.", "repl2"}], "]"}]], "Input",
 CellChangeTimes->{{3.537583943735824*^9, 3.537583946472803*^9}}],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "z", "]"}], "1"],
  SeriesData[$CellContext`z, 0, {}, 1, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869802865644*^9, {3.5438698763090973`*^9, 3.54386989771704*^9}, 
   3.544343717156042*^9, 3.544345060433576*^9, 3.544353813604308*^9, 
   3.544353990984666*^9, {3.5443540504351807`*^9, 3.54435408197134*^9}, 
   3.544354115928938*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bceq3", "=", 
  RowBox[{"s", "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544353818900803*^9, 3.54435383359417*^9}, 
   3.544353892208263*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", " ", 
   RowBox[{"s3", "[", "v", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["z", "2"], " ", 
   RowBox[{"s4", "[", "v", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["z", "3"], " ", 
   RowBox[{"s5", "[", "v", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.5443538251273537`*^9, 3.5443538385208263`*^9}, 
   3.5443538927617197`*^9, 3.5443539916370687`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "/.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544353836050331*^9, 3.544353836106229*^9}, {
  3.544353913065431*^9, 3.54435393167244*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"f2", "[", "v", "]"}], " ", "z"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
    $CellContext`f2[$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5443538365595417`*^9, 3.544353839104684*^9}, {
   3.544353894430208*^9, 3.5443539319532423`*^9}, 3.544353992187447*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"h", "[", 
      RowBox[{"v", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "/.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544353836050331*^9, 3.544353836106229*^9}, {
  3.544353913065431*^9, 3.544353935519349*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"h2", "[", "v", "]"}], " ", "z"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
    $CellContext`h2[$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5443538365595417`*^9, 3.544353839104684*^9}, {
   3.544353894430208*^9, 3.5443539358618803`*^9}, 3.544353992758082*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"v", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "/.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544353836050331*^9, 3.544353836106229*^9}, {
  3.544353913065431*^9, 3.544353940127337*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"a1", "[", "v", "]"}], " ", "z"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
    $CellContext`a1[$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5443538365595417`*^9, 3.544353839104684*^9}, {
   3.544353894430208*^9, 3.54435394049443*^9}, 3.5443539933058567`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"s", "[", 
      RowBox[{"v", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "/.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544353836050331*^9, 3.544353836106229*^9}, {
  3.544353913065431*^9, 3.544353922391581*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], " ", "z"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[-1, 
      3] $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5443538365595417`*^9, 3.544353839104684*^9}, {
   3.544353894430208*^9, 3.544353943525366*^9}, 3.544353993840127*^9}],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.544808554107924*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1045, 924},
WindowMargins->{{Automatic, 165}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "calcgeom"->{
  Cell[40244, 1080, 306, 9, 73, "Input",
   CellTags->"calcgeom"],
  Cell[40553, 1091, 293, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[40849, 1103, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[41116, 1114, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[41383, 1125, 3551, 100, 139, "Input",
   CellTags->"calcgeom"],
  Cell[44937, 1227, 155, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[45299, 1239, 5599, 153, 178, "Input",
   CellTags->"calcgeom"],
  Cell[50901, 1394, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[51046, 1400, 1615, 48, 88, "Input",
   CellTags->"calcgeom"],
  Cell[52664, 1450, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[52809, 1456, 633, 22, 27, "Input",
   CellTags->"calcgeom"],
  Cell[53445, 1480, 1648, 51, 113, "Input",
   CellTags->"calcgeom"],
  Cell[55096, 1533, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[55241, 1539, 145, 4, 27, "Input",
   CellTags->"calcgeom"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"calcgeom", 873726, 23440}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 905, 15, 96, "Subtitle"],
Cell[CellGroupData[{
Cell[1509, 41, 68, 1, 27, "Input"],
Cell[1580, 44, 308, 4, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1925, 53, 111, 1, 26, "Subsubtitle"],
Cell[2039, 56, 95, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[2159, 62, 279, 8, 58, "Input"],
Cell[2441, 72, 419, 8, 70, "Output"],
Cell[2863, 82, 819, 19, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3719, 106, 266, 9, 58, "Input"],
Cell[3988, 117, 305, 4, 70, "Output"],
Cell[4296, 123, 305, 4, 70, "Output"]
}, Open  ]],
Cell[4616, 130, 407, 13, 27, "Input"],
Cell[5026, 145, 37, 0, 27, "Input"],
Cell[CellGroupData[{
Cell[5088, 149, 257, 8, 58, "Input"],
Cell[5348, 159, 394, 7, 70, "Output"],
Cell[5745, 168, 306, 4, 70, "Output"]
}, Open  ]],
Cell[6066, 175, 2020, 62, 103, "Input"],
Cell[8089, 239, 26, 0, 27, "Input"],
Cell[8118, 241, 841, 25, 43, "Input"],
Cell[8962, 268, 1026, 31, 58, "Input"],
Cell[9991, 301, 227, 8, 86, "Text"],
Cell[10221, 311, 4015, 95, 238, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[14273, 411, 111, 3, 26, "Subsubtitle"],
Cell[14387, 416, 128, 4, 26, "Text"],
Cell[14518, 422, 6139, 139, 718, "Input"],
Cell[20660, 563, 68, 1, 26, "Text"],
Cell[20731, 566, 3727, 84, 523, "Input"],
Cell[24461, 652, 824, 18, 208, "Input"],
Cell[25288, 672, 4051, 89, 583, "Input"],
Cell[29342, 763, 99, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[29478, 770, 34, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[29537, 774, 3220, 66, 173, "Input"],
Cell[32760, 842, 1462, 43, 50, "Output"],
Cell[34225, 887, 373, 6, 27, "Output"],
Cell[34601, 895, 306, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34944, 904, 28, 0, 27, "Input"],
Cell[34975, 906, 1456, 43, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36468, 954, 28, 0, 27, "Input"],
Cell[36499, 956, 2730, 85, 98, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39266, 1046, 119, 3, 27, "Input"],
Cell[39388, 1051, 772, 21, 52, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40209, 1078, 32, 0, 26, "Subsubtitle"],
Cell[40244, 1080, 306, 9, 73, "Input",
 CellTags->"calcgeom"],
Cell[40553, 1091, 293, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[40849, 1103, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[41116, 1114, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[41383, 1125, 3551, 100, 139, "Input",
 CellTags->"calcgeom"],
Cell[44937, 1227, 155, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[45095, 1233, 201, 4, 27, "Input"],
Cell[45299, 1239, 5599, 153, 178, "Input",
 CellTags->"calcgeom"],
Cell[50901, 1394, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[51046, 1400, 1615, 48, 88, "Input",
 CellTags->"calcgeom"],
Cell[52664, 1450, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[52809, 1456, 633, 22, 27, "Input",
 CellTags->"calcgeom"],
Cell[53445, 1480, 1648, 51, 113, "Input",
 CellTags->"calcgeom"],
Cell[55096, 1533, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[55241, 1539, 145, 4, 27, "Input",
 CellTags->"calcgeom"]
}, Closed]],
Cell[CellGroupData[{
Cell[55423, 1548, 41, 0, 26, "Subsubtitle"],
Cell[55467, 1550, 173, 4, 27, "Input"],
Cell[55643, 1556, 645, 21, 27, "Input"],
Cell[56291, 1579, 1146, 34, 118, "Input"],
Cell[57440, 1615, 1792, 51, 118, "Input"],
Cell[59235, 1668, 710, 23, 58, "Input"],
Cell[59948, 1693, 3455, 96, 238, "Input"],
Cell[63406, 1791, 388, 12, 27, "Input"],
Cell[63797, 1805, 486, 12, 27, "Input"],
Cell[64286, 1819, 508, 12, 46, "Input"],
Cell[64797, 1833, 4135, 133, 141, "Input"],
Cell[68935, 1968, 6843, 214, 199, "Input"],
Cell[75781, 2184, 237, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[76043, 2193, 3999, 129, 141, "Input"],
Cell[80045, 2324, 358, 6, 27, "Output"],
Cell[80406, 2332, 358, 6, 27, "Output"],
Cell[80767, 2340, 358, 6, 27, "Output"],
Cell[81128, 2348, 358, 6, 27, "Output"]
}, Open  ]],
Cell[81501, 2357, 1262, 33, 148, "Input"],
Cell[82766, 2392, 1027, 21, 58, "Input"],
Cell[83796, 2415, 677, 17, 58, "Input"],
Cell[84476, 2434, 1027, 30, 118, "Input"],
Cell[85506, 2466, 161, 3, 27, "Input"],
Cell[85670, 2471, 745, 18, 88, "Input"],
Cell[CellGroupData[{
Cell[86440, 2493, 2771, 89, 238, "Input"],
Cell[89214, 2584, 6527, 187, 89, "Output"],
Cell[95744, 2773, 6240, 185, 89, "Output"],
Cell[101987, 2960, 2298, 69, 52, "Output"],
Cell[104288, 3031, 3617, 109, 69, "Output"],
Cell[107908, 3142, 5012, 158, 89, "Output"],
Cell[112923, 3302, 11532, 352, 149, "Output"],
Cell[124458, 3656, 1504, 45, 52, "Output"],
Cell[125965, 3703, 6711, 206, 89, "Output"]
}, Open  ]],
Cell[132691, 3912, 2631, 55, 169, "Input"],
Cell[CellGroupData[{
Cell[135347, 3971, 975, 25, 238, "Input"],
Cell[136325, 3998, 301, 4, 27, "Output"],
Cell[136629, 4004, 301, 4, 27, "Output"],
Cell[136933, 4010, 299, 4, 27, "Output"],
Cell[137235, 4016, 299, 4, 27, "Output"],
Cell[137537, 4022, 299, 4, 27, "Output"],
Cell[137839, 4028, 299, 4, 27, "Output"],
Cell[138141, 4034, 299, 4, 27, "Output"],
Cell[138443, 4040, 299, 4, 27, "Output"]
}, Open  ]],
Cell[138757, 4047, 292, 6, 27, "Input"],
Cell[139052, 4055, 177, 3, 27, "Input"],
Cell[139232, 4060, 4261, 101, 188, "Input"],
Cell[CellGroupData[{
Cell[143518, 4165, 2493, 66, 67, "Input"],
Cell[146014, 4233, 459, 7, 27, "Output"]
}, Open  ]],
Cell[146488, 4243, 1760, 46, 33, "Input"],
Cell[CellGroupData[{
Cell[148273, 4293, 456, 12, 30, "Input"],
Cell[148732, 4307, 419575, 10986, 11177, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[568344, 15298, 1074, 32, 88, "Input"],
Cell[569421, 15332, 165, 2, 27, "Output"],
Cell[569589, 15336, 172, 2, 27, "Output"],
Cell[569764, 15340, 174, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[569975, 15347, 1910, 67, 105, "Input"],
Cell[571888, 15416, 8866, 253, 339, "Output"],
Cell[580757, 15671, 8827, 250, 340, "Output"],
Cell[589587, 15923, 13709, 354, 308, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[603333, 16282, 3193, 113, 177, "Input"],
Cell[606529, 16397, 12678, 355, 241, "Output"],
Cell[619210, 16754, 12586, 352, 226, "Output"],
Cell[631799, 17108, 29620, 848, 353, "Output"],
Cell[661422, 17958, 12111, 347, 298, "Output"],
Cell[673536, 18307, 20667, 662, 568, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[694240, 18974, 2263, 68, 118, "Input"],
Cell[696506, 19044, 1588, 53, 33, "Output"]
}, Open  ]],
Cell[698109, 19100, 1619, 38, 43, "Input"],
Cell[CellGroupData[{
Cell[699753, 19142, 639, 13, 27, "Input"],
Cell[700395, 19157, 981, 14, 103, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[701413, 19176, 362, 9, 27, "Input"],
Cell[701778, 19187, 980, 14, 103, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[702795, 19206, 364, 9, 27, "Input"],
Cell[703162, 19217, 2204, 33, 253, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[705403, 19255, 364, 9, 27, "Input"],
Cell[705770, 19266, 1109, 15, 133, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[706916, 19286, 364, 9, 27, "Input"],
Cell[707283, 19297, 1939, 27, 223, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[709259, 19329, 687, 13, 27, "Input"],
Cell[709949, 19344, 861, 12, 103, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[710847, 19361, 366, 9, 27, "Input"],
Cell[711216, 19372, 787, 10, 88, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[712040, 19387, 364, 9, 27, "Input"],
Cell[712407, 19398, 26441, 386, 3358, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[738885, 19789, 358, 9, 27, "Input"],
Cell[739246, 19800, 960, 13, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[740243, 19818, 873, 15, 58, "Input"],
Cell[741119, 19835, 290, 4, 27, "Output"]
}, Open  ]],
Cell[741424, 19842, 2939, 91, 148, "Input"],
Cell[CellGroupData[{
Cell[744388, 19937, 2374, 70, 238, "Input"],
Cell[746765, 20009, 1589, 41, 52, "Output"],
Cell[748357, 20052, 1648, 42, 46, "Output"],
Cell[750008, 20096, 2098, 51, 33, "Output"],
Cell[752109, 20149, 1057, 27, 46, "Output"],
Cell[753169, 20178, 1096, 28, 46, "Output"],
Cell[754268, 20208, 1055, 27, 46, "Output"],
Cell[755326, 20237, 1059, 27, 30, "Output"],
Cell[756388, 20266, 269, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[756694, 20275, 899, 22, 27, "Input"],
Cell[757596, 20299, 3586, 102, 108, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[761219, 20406, 2717, 81, 268, "Input"],
Cell[763939, 20489, 4755, 115, 87, "Output"],
Cell[768697, 20606, 4712, 116, 67, "Output"],
Cell[773412, 20724, 327, 8, 30, "Output"],
Cell[773742, 20734, 3655, 91, 80, "Output"],
Cell[777400, 20827, 3589, 91, 95, "Output"],
Cell[780992, 20920, 2609, 67, 72, "Output"],
Cell[783604, 20989, 2134, 55, 33, "Output"],
Cell[785741, 21046, 195, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[785973, 21054, 1130, 26, 27, "Input"],
Cell[787106, 21082, 444, 9, 23, "Message"],
Cell[787553, 21093, 10782, 287, 259, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[798372, 21385, 3044, 89, 268, "Input"],
Cell[801419, 21476, 5900, 143, 114, "Output"],
Cell[807322, 21621, 4614, 114, 53, "Output"],
Cell[811939, 21737, 278, 7, 30, "Output"],
Cell[812220, 21746, 3948, 98, 69, "Output"],
Cell[816171, 21846, 4249, 104, 69, "Output"],
Cell[820423, 21952, 3381, 84, 69, "Output"],
Cell[823807, 22038, 3775, 92, 53, "Output"],
Cell[827585, 22132, 3952, 98, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[831574, 22235, 1109, 25, 27, "Input"],
Cell[832686, 22262, 13739, 365, 301, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[846462, 22632, 31, 0, 27, "Input"],
Cell[846496, 22634, 1746, 52, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[848279, 22691, 97, 1, 27, "Input"],
Cell[848379, 22694, 10817, 288, 259, "Output"]
}, Open  ]],
Cell[859211, 22985, 1750, 49, 27, "Input"],
Cell[860964, 23036, 986, 28, 27, "Input"],
Cell[CellGroupData[{
Cell[861975, 23068, 382, 9, 27, "Input"],
Cell[862360, 23079, 1672, 45, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[864069, 23129, 157, 3, 27, "Input"],
Cell[864229, 23134, 355, 9, 30, "Output"]
}, Open  ]],
Cell[864599, 23146, 1280, 37, 27, "Input"],
Cell[CellGroupData[{
Cell[865904, 23187, 456, 10, 27, "Input"],
Cell[866363, 23199, 1697, 44, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[868097, 23248, 157, 3, 27, "Input"],
Cell[868257, 23253, 428, 10, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[868722, 23268, 196, 5, 27, "Input"],
Cell[868921, 23275, 391, 11, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[869349, 23291, 385, 11, 27, "Input"],
Cell[869737, 23304, 519, 14, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[870293, 23323, 386, 11, 27, "Input"],
Cell[870682, 23336, 519, 14, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[871238, 23355, 386, 11, 27, "Input"],
Cell[871627, 23368, 518, 14, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[872182, 23387, 386, 11, 27, "Input"],
Cell[872571, 23400, 729, 21, 47, "Output"],
Cell[873303, 23423, 77, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
