(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    610215,      17914]
NotebookOptionsPosition[    598349,      17552]
NotebookOutlinePosition[    599706,      17600]
CellTagsIndexPosition[    599632,      17595]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Dynamic AdS/CMT - Superconductor - Spectral - Numerial Ansatz II\
\>", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.507011572545054*^9, 3.460340667971311*^9}, {
   3.5374843541262083`*^9, 3.537484358716886*^9}, 3.537484391202265*^9, {
   3.537484629914453*^9, 3.537484630281348*^9}, {3.5374893532274837`*^9, 
   3.537489358050692*^9}, {3.53749388933057*^9, 3.537493890193932*^9}, {
   3.537578587160997*^9, 3.5375785895997057`*^9}, {3.537578682265374*^9, 
   3.537578682504321*^9}, {3.537578812305402*^9, 3.537578812720454*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"hmm\"\>"], "Print",
 CellChangeTimes->{3.53880794268043*^9, 3.54386945932994*^9, 
  3.544342627214196*^9, 3.5443443860028276`*^9, 3.5443535776805277`*^9, 
  3.544459104318214*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
   "gzz"}], "}"}]], "Output",
 CellChangeTimes->{3.538807942880889*^9, 3.54386945943898*^9, 
  3.5443426274794292`*^9, 3.5443443862976*^9, 3.544353577883421*^9, 
  3.5444591045019493`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gtt", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "grr", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "g\[Theta]\[Theta]", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "g\[Phi]\[Phi]", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "gzz"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807942880889*^9, 3.54386945943898*^9, 
  3.5443426274794292`*^9, 3.5443443862976*^9, 3.544353577883421*^9, 
  3.544459104503503*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{3.538807942964953*^9, 3.543869459599666*^9, 
  3.5443426275436497`*^9, 3.544344386336905*^9, 3.544353577964192*^9, 
  3.544459104545328*^9}],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{3.538807942964953*^9, 3.543869459599666*^9, 
  3.5443426275436497`*^9, 3.544344386336905*^9, 3.544353577964192*^9, 
  3.5444591045467987`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807943254242*^9, 3.54386945993823*^9, 
  3.5443426279009666`*^9, 3.544344386597836*^9, 3.544353578270753*^9, 
  3.544459104839386*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{3.538807943254242*^9, 3.54386945993823*^9, 
  3.5443426279009666`*^9, 3.544344386597836*^9, 3.544353578270753*^9, 
  3.544459104840775*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"-", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "0", "0"},
       {
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}], "0"},
       {"0", "0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.507011580676421*^9, 3.507011659804162*^9}, {3.507013755598536*^9, 
   3.460392698323369*^9}, {3.4604018613321533`*^9, 3.4604018646719627`*^9}, {
   3.460401965632374*^9, 3.460401968163259*^9}, {3.4604023388162813`*^9, 
   3.4604023558966084`*^9}, {3.460402422665003*^9, 3.460402426690833*^9}, {
   3.460402628586185*^9, 3.4604026419139843`*^9}, {3.460402674350209*^9, 
   3.4604026844332027`*^9}, {3.460512773931822*^9, 3.460512787444798*^9}, {
   3.4605146484667263`*^9, 3.460514650350994*^9}, {3.460514717258254*^9, 
   3.460514724283691*^9}, 3.460514770989304*^9, 3.4605223140457373`*^9, {
   3.4605327188171663`*^9, 3.460532727004561*^9}, {3.460532863547011*^9, 
   3.460532865145266*^9}, {3.460532977769042*^9, 3.4605329860852757`*^9}, {
   3.507275497143169*^9, 3.4603659980232763`*^9}, {3.537484515197036*^9, 
   3.537484572210073*^9}, 3.537484644682625*^9, {3.5374846959240923`*^9, 
   3.537484701892157*^9}, {3.537484976337736*^9, 3.5374849917355137`*^9}, {
   3.537486594817341*^9, 3.537486596777007*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     FractionBox[
      RowBox[{"gzz", "[", 
       RowBox[{"v", ",", "z"}], "]"}], 
      SuperscriptBox["z", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.543869460369071*^9, 
  3.544342628431478*^9, 3.5443443871821747`*^9, 3.544353578853538*^9, 
  3.544459105324402*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.543869460369071*^9, 
  3.544342628431478*^9, 3.5443443871821747`*^9, 3.544353578853538*^9, 
  3.54445910532719*^9}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.543869460369071*^9, 
  3.544342628431478*^9, 3.5443443871821747`*^9, 3.544353578853538*^9, 
  3.544459105328951*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     FractionBox[
      RowBox[{"gzz", "[", 
       RowBox[{"v", ",", "z"}], "]"}], 
      SuperscriptBox["z", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807943934894*^9, 3.5438694604482927`*^9, 
  3.54434262849561*^9, 3.544344387245637*^9, 3.5443535789502773`*^9, 
  3.544459105502936*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
       RowBox[{
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["z", "2"], 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["z", "2"], 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807944009327*^9, 3.543869460487749*^9, 
  3.544342628531184*^9, 3.54434438727798*^9, 3.544353579009232*^9, 
  3.54445910556271*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
      RowBox[{
       RowBox[{"gzz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   SuperscriptBox["z", "8"]]}]], "Output",
 CellChangeTimes->{3.538807944075788*^9, 3.5438694606321898`*^9, 
  3.544342628566908*^9, 3.5443443873252087`*^9, 3.54435357905252*^9, 
  3.5444591055959873`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{"Simplify", "[", "R2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041067188341103`*^9, 3.404106720182616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"GT", "[", 
       RowBox[{"R2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "A", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"A", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"v", ",", "d"}], "}"}], "}"}], ",", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"ST", "[", 
    RowBox[{"A", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"z", ",", "d"}], "}"}], "}"}], ",", 
     RowBox[{"az", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451383976248069*^9, 3.4513840125908737`*^9}, {
  3.451384057147691*^9, 3.451384064689735*^9}, {3.451385762395092*^9, 
  3.451385762480318*^9}, {3.451385800913571*^9, 3.451385805770357*^9}, {
  3.537484677141605*^9, 3.53748468964509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "F", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"F", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"F", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i1", "]"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4041040239360247`*^9, 3.404104073416904*^9}, {
  3.4041057167733383`*^9, 3.4041057183570337`*^9}, {3.4513840707957897`*^9, 
  3.451384164343499*^9}, {3.460366100458836*^9, 3.460366108909464*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"trFF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"trT", "[", 
      RowBox[{
       RowBox[{"outerT", "[", 
        RowBox[{"F", ",", "F"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fsqr", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"trT", "[", 
     RowBox[{"trFF", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.404103126230957*^9, 3.404103206051724*^9}, 
   3.404103788928409*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "Dp", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"Dp", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Dp", "=", 
       RowBox[{"ST", "[", 
        RowBox[{"Dp", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[Phi]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
          RowBox[{"2", "I", " ", 
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], 
           RowBox[{"\[Phi]", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConjDp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"Conjugate", "[", 
       RowBox[{"Dp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DpDp", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"trT", "[", 
       RowBox[{
        RowBox[{"outerT", "[", 
         RowBox[{"ConjDp", ",", "Dp"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Vterm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Phi]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "]"}], 
       RowBox[{"\[Phi]", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513844331121693`*^9, 3.451384521665413*^9}, {
   3.451384560554626*^9, 3.451384642158163*^9}, {3.4513849100950413`*^9, 
   3.451384915054587*^9}, 3.451385051803838*^9, {3.4513851171366262`*^9, 
   3.45138511927711*^9}, {3.451385175930884*^9, 3.451385183167452*^9}, {
   3.451385425505906*^9, 3.45138544324051*^9}, {3.451385490350021*^9, 
   3.451385493946774*^9}, {3.451385568392873*^9, 3.451385601054823*^9}, {
   3.451385813165941*^9, 3.4513858527683163`*^9}, {3.45138608116168*^9, 
   3.451386103913107*^9}, {3.46036707784975*^9, 3.460255762501432*^9}, {
   3.46025580130457*^9, 3.460255801461816*^9}, {3.53748492894665*^9, 
   3.53748495518618*^9}, {3.537485329580826*^9, 3.537485331297533*^9}, 
   3.543869463106576*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DpDp", "=", 
   RowBox[{"(", 
    RowBox[{"DpDp", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", "xx_", "]"}], "\[Rule]", "xx"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", "xx_", "]"}], "\[Rule]", "0"}]}], "}"}]}], ")"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.451385894732107*^9, 3.451385976334114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrtdetg", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Det", "[", 
       RowBox[{"-", "Gd"}], "]"}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041041692972*^9, 3.404104211096949*^9}, 
   3.404105293940057*^9, {3.4513842180130997`*^9, 3.4513842223260803`*^9}, {
   3.4513846617079067`*^9, 3.451384675916638*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"sqrtdetg", 
    RowBox[{"(", 
     RowBox[{"Ricci", "+", "6", "-", 
      RowBox[{
       FractionBox["1", "4"], "Fsqr"}], "-", "DpDp", "-", "Vterm"}], 
     ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.451384367735067*^9, 3.451384393946628*^9}, {
   3.4513849054437723`*^9, 3.4513849068431387`*^9}, {3.451385606138598*^9, 
   3.451385607193993*^9}, 3.460366276193363*^9, {3.4603670917067547`*^9, 
   3.460255829896731*^9}, 3.537493905932642*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.53748653613297*^9, 3.5374865918283*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GHBT", "+=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
     "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460366441552243*^9, 3.460366544772176*^9}, {
  3.4603665879440317`*^9, 3.460366626391823*^9}, {3.537486655723679*^9, 
  3.537486732610427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L", "-", "GHBT"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460366546941235*^9, 3.460366557341961*^9}, 
   3.460366686117609*^9, {3.4603672960654507`*^9, 3.4603672977104673`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"L2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.460366666517003*^9, 3.460366674775579*^9}, {3.537486746662644*^9, 
  3.5374867639666147`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.543869500041778*^9, 
  3.544342632498914*^9, 3.5443443914021807`*^9, 3.544353582854992*^9, 
  3.544459109409883*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.543869500041778*^9, 
  3.544342632498914*^9, 3.5443443914021807`*^9, 3.544353582854992*^9, 
  3.544459109412929*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.543869500041778*^9, 
  3.544342632498914*^9, 3.5443443914021807`*^9, 3.544353582854992*^9, 
  3.544459109450382*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.543869500041778*^9, 
  3.544342632498914*^9, 3.5443443914021807`*^9, 3.544353582854992*^9, 
  3.5444591094996557`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"EOM", "[", "fld_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{"D", "[", 
      RowBox[{"L2", ",", "fld"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"tmp2", "=", 
           RowBox[{"D", "[", 
            RowBox[{"fld", ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ")"}], "=!=", "0"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "-=", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"L2", ",", "tmp2"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "tmp"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.4513849546200113`*^9, 3.451385039242148*^9}, {
  3.4603662728020573`*^9, 3.460366273871294*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqp", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"p", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513848144544163`*^9, 3.4513848150159073`*^9}, {
  3.451384869337384*^9, 3.451384875673843*^9}, {3.451384929950244*^9, 
  3.451384930100154*^9}, {3.451385060851385*^9, 3.451385213396349*^9}, {
  3.451385293160893*^9, 3.451385302528058*^9}, {3.4513853749547167`*^9, 
  3.45138537639461*^9}, {3.451385514552088*^9, 3.451385527943191*^9}, {
  3.451385862306609*^9, 3.451385882826736*^9}, {3.451386138230373*^9, 
  3.451386140019012*^9}, {3.451386241895258*^9, 3.4513862693654633`*^9}, {
  3.4603675858592987`*^9, 3.4603675914720583`*^9}, {3.537486779881022*^9, 
  3.537486784922683*^9}, {3.537486894453556*^9, 3.5374869009568243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqav", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"av", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"az", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513855403702793`*^9, 3.451385540823719*^9}, {
  3.4513861532442207`*^9, 3.45138616739637*^9}, {3.451386251199284*^9, 
  3.4513862656960487`*^9}, {3.460367593073217*^9, 3.460367597640524*^9}, {
  3.5374867866028214`*^9, 3.537486788378339*^9}, {3.537486891597521*^9, 
  3.537486937732339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqgvz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gvz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqgzz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gzz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqT", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"T", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqS", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451386275930722*^9, 3.451386303859261*^9}, {
  3.460366711720347*^9, 3.4603667226381903`*^9}, {3.460367599130735*^9, 
  3.460367611985876*^9}, {3.53748678993122*^9, 3.53748680663302*^9}, {
  3.537486911477583*^9, 3.5374869187572203`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"gvz", ",", "gzz", ",", "az"}], "]"}]], "Input",
 CellChangeTimes->{{3.53748694036823*^9, 3.537486945275868*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gvz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gzz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"az", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.460366755240944*^9, 3.460366765921853*^9}, {
   3.460379717667384*^9, 3.460379720321673*^9}, {3.4603938524268913`*^9, 
   3.4603938546559877`*^9}, 3.4603939628549967`*^9, {3.5374868640225983`*^9, 
   3.537486876197587*^9}, {3.537486924492758*^9, 3.537486925572747*^9}, {
   3.537487030062772*^9, 3.537487030117689*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqp2", "=", 
   RowBox[{"Simplify", "[", "eqp", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]2", "=", 
   RowBox[{"Simplify", "[", "eq\[Alpha]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqav2", "=", 
   RowBox[{"Simplify", "[", "eqav", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz2", "=", 
   RowBox[{"Simplify", "[", "eqaz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgvz2", "=", 
   RowBox[{"Simplify", "[", "eqgvz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgzz2", "=", 
   RowBox[{"Simplify", "[", "eqgzz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqT2", "=", 
   RowBox[{"Simplify", "[", "eqT", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"eqS2", "=", 
  RowBox[{"Simplify", "[", "eqS", "]"}]}]}], "Input",
 CellChangeTimes->{{3.460366768598325*^9, 3.4603668525536737`*^9}, {
  3.5374869590367947`*^9, 3.537486972220312*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"S", "[", 
    RowBox[{"v", ",", "z"}], "]"}]], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"p", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "z"}], " ", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"S", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Alpha]", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "-", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "z", " ", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["av", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{
                SuperscriptBox["p", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["p", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.5438695004606524`*^9, 
  3.544342632883522*^9, 3.544344391825632*^9, 3.544353583285541*^9, 
  3.544459109827507*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"S", "[", 
    RowBox[{"v", ",", "z"}], "]"}]], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"S", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["av", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.5438695004606524`*^9, 
  3.544342632883522*^9, 3.544344391825632*^9, 3.544353583285541*^9, 
  3.5444591099053993`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["av", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["z", "6"], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]]}]]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.5438695004606524`*^9, 
  3.544342632883522*^9, 3.544344391825632*^9, 3.544353583285541*^9, 
  3.544459109939968*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["z", "14"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "4"], 
        SuperscriptBox["z", "8"]]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "7"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"8", " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["av", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.5438695004606524`*^9, 
  3.544342632883522*^9, 3.544344391825632*^9, 3.544353583285541*^9, 
  3.544459109983262*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "2"]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"\[Alpha]", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["av", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "6"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.5438695004606524`*^9, 
  3.544342632883522*^9, 3.544344391825632*^9, 3.544353583285541*^9, 
  3.5444591100528717`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "2"]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"16", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"av", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"T", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"T", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "6"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"12", "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"p", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["z", "4"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["av", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{"4", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{"z", " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"T", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              SuperscriptBox["T", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.5438695004606524`*^9, 
  3.544342632883522*^9, 3.544344391825632*^9, 3.544353583285541*^9, 
  3.544459110274952*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["z", "6"], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]]}]]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.5438695004606524`*^9, 
  3.544342632883522*^9, 3.544344391825632*^9, 3.544353583285541*^9, 
  3.544459110317678*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["z", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "4"], 
        SuperscriptBox["z", "8"]]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "6"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"\[Alpha]", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["av", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"8", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"6", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.5438695004606524`*^9, 
  3.544342632883522*^9, 3.544344391825632*^9, 3.544353583285541*^9, 
  3.5444591103978853`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"z", "^", "3"}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", "eqp2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eq\[Alpha]2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqav2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqaz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgvz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgzz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqT2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "eqS2", "]"}]}], "Input",
 CellChangeTimes->{{3.507012905387106*^9, 3.507012910083256*^9}, {
  3.5070145245498*^9, 3.4603669411156473`*^9}, {3.5374870758129187`*^9, 
  3.5374870842285547`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110577895*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110579836*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110581151*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.5444591105824327`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.5444591105837393`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110585021*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110586295*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9, 
  3.544342633687593*^9, 3.544344392612753*^9, 3.5443535840388308`*^9, 
  3.544459110587586*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"\[Alpha]", ",", "p", ",", "av", ",", "T", ",", "S"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4603676469897413`*^9, 3.460367657697607*^9}, {
  3.4603797352914047`*^9, 3.460379735508092*^9}, {3.5374870733721457`*^9, 
  3.537487073532263*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"f", ",", "h", ",", "a", ",", "t", ",", "s"}], "]"}]], "Input",
 CellChangeTimes->{{3.544345286443597*^9, 3.544345291880872*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Sigma]", "[", "v", "]"}], "+", " ", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"h", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"m", "+", 
    RowBox[{"a", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"z", "^", "2"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], " ", "+", " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.537494166786066*^9, 3.537494209239134*^9}, 
   3.5375534855250597`*^9, {3.537578844859714*^9, 3.537578847402349*^9}, {
   3.5443428580700827`*^9, 3.5443428681588907`*^9}, {3.5443429100928164`*^9, 
   3.544342936702117*^9}, {3.544342967726297*^9, 3.5443429679008636`*^9}, {
   3.5443430411547203`*^9, 3.544343095121284*^9}, {3.544344387437715*^9, 
   3.5443443888695498`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Evsol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"eqgvz2", "\[Equal]", "0"}], ",", 
         RowBox[{"eqS2", "\[Equal]", "0"}], ",", 
         RowBox[{"eqp2", "\[Equal]", "0"}], ",", 
         RowBox[{"eq\[Alpha]2", "\[Equal]", "0"}], ",", 
         RowBox[{"eqaz", "\[Equal]", "0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
         RowBox[{
          SuperscriptBox["a", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
         RowBox[{
          SuperscriptBox["t", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"z", ">", "0"}], ",", 
      RowBox[{
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ">", "0"}], ",", 
      RowBox[{
       RowBox[{"\[Sigma]", "[", "v", "]"}], ">", "0"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.4603794747692738`*^9, 3.4603795051117373`*^9}, {
   3.460379770556391*^9, 3.460379778090231*^9}, {3.537487575145343*^9, 
   3.537487601737835*^9}, {3.5374876320607243`*^9, 3.537487632172414*^9}, 
   3.5374876986147537`*^9, {3.537494224185582*^9, 3.537494230128457*^9}, {
   3.537494336674205*^9, 3.537494337210093*^9}, {3.54434458250847*^9, 
   3.544344629440035*^9}, 3.54434527412516*^9, {3.5443453145885363`*^9, 
   3.5443453363637247`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}]}], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", 
           RowBox[{"a", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", 
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  RowBox[{"h", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
              RowBox[{"4", " ", "z", " ", 
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}]], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}], "+", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "-", 
              FractionBox[
               SuperscriptBox[
                RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "4"]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"]}], 
                ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              FractionBox[
               SuperscriptBox[
                RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
              RowBox[{"2", " ", "z", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[Sigma]", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}], "+", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["\[Sigma]", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", 
           RowBox[{"a", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", 
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"f", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
              RowBox[{"4", " ", "z", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"f", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}]], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "-", 
              FractionBox[
               SuperscriptBox[
                RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "4"]}], ")"}]}]}], 
          ")"}]}], 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "-", 
                 FractionBox[
                  SuperscriptBox[
                   RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"]}], 
                ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              FractionBox[
               SuperscriptBox[
                RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "-", 
              RowBox[{"2", " ", "z", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["\[Sigma]", "\[Prime]",
                 MultilineFunction->None], "[", "v", "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       "2"]], 
     RowBox[{"16", " ", "\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "-", 
               FractionBox[
                SuperscriptBox[
                 RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "4"]}], ")"}]}]}],
            ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", 
              RowBox[{"a", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"f", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], "2"]}], 
             ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], 
             ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"f", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[Sigma]", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}], "+", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
        RowBox[{
         FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
         " ", 
         RowBox[{
          SuperscriptBox["a", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Sigma]", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "4"]}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "4"]}], ")"}]}]}], 
        ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"12", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], "2"]}], "-", 
         RowBox[{
          SuperscriptBox["z", "4"], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "-", 
               FractionBox[
                SuperscriptBox[
                 RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"]}], ")"}]}]}],
            ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], 
           ")"}]}], "-", 
         FractionBox[
          RowBox[{"16", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
             RowBox[{"2", " ", "z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}]], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
         FractionBox[
          RowBox[{"8", " ", 
           SuperscriptBox["z", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
             RowBox[{"2", " ", "z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
          RowBox[{"4", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["z", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                   FractionBox[
                    SuperscriptBox[
                    RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"]}], 
                  ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                FractionBox[
                 SuperscriptBox[
                  RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["\[Sigma]", "\[Prime]",
                   MultilineFunction->None], "[", "v", "]"}]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "-", 
                FractionBox[
                 SuperscriptBox[
                  RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "4"]}], 
               ")"}]}]}], ")"}], "2"]]}], ")"}]}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["t", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], 
      SuperscriptBox["z", "2"]], "-", 
     FractionBox[
      RowBox[{"8", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], 
      RowBox[{
       RowBox[{"4", " ", "z"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{
        SuperscriptBox["z", "3"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}]], "+", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "z"], "-", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "z"], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "6"}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"f", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], "+", 
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"f", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], "+", 
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"]}]], "+", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       "2"]], "+", 
     FractionBox[
      RowBox[{"8", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}]}]],
      "+", 
     FractionBox[
      RowBox[{"16", " ", "z", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       "2"]], "-", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{
        SuperscriptBox["t", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "z"], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"4", " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], 
      SuperscriptBox["z", "2"]], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "2"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}]}]],
      "+", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Sigma]", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], "+", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "z"], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "z"], "+", 
     FractionBox[
      RowBox[{"16", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "-", 
            RowBox[{"4", " ", "z", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], 
      RowBox[{"z", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
        "2"]}]]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.538807968763275*^9, 3.543869515253158*^9, 3.54434302242673*^9, 
   3.544343146940154*^9, 3.544344448960503*^9, 3.544344483170897*^9, {
   3.544344589109618*^9, 3.544344611194873*^9}, 3.54434467663202*^9, {
   3.544345279044548*^9, 3.5443453268668823`*^9}, 3.5443453833168488`*^9, 
   3.544353629445764*^9, 3.544459155167541*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Momsol", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"eqT2", "\[Equal]", "0"}], ",", 
         RowBox[{"eqgzz", "\[Equal]", "0"}], ",", 
         RowBox[{"eqav", "\[Equal]", "0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
         RowBox[{
          SuperscriptBox["a", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"z", ">", "0"}], ",", 
      RowBox[{
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ">", "0"}], ",", 
      RowBox[{
       RowBox[{"\[Sigma]", "[", "v", "]"}], ">", "0"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.460379791348405*^9, 3.460379854266864*^9}, {
  3.537487577120059*^9, 3.537487629667873*^9}, {3.5374877038531513`*^9, 
  3.537487709515881*^9}, {3.537494238680642*^9, 3.53749424053545*^9}, {
  3.5374943297700453`*^9, 3.537494330345728*^9}, {3.544344638534939*^9, 
  3.5443446432887497`*^9}, {3.5443446950372257`*^9, 3.544344697257845*^9}, {
  3.544344739498117*^9, 3.544344740065184*^9}, {3.544344844739172*^9, 
  3.544344845210968*^9}}],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   PanelBox[GridBox[{
      {
       StyleBox[
        StyleBox[
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
           StandardForm],
          ImageSizeCache->{278., {2., 8.}}],
         StripOnInput->False,
         DynamicUpdating->True], "Panel",
        StripOnInput->False,
        Background->None]},
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
            RowBox[{"-", 
             FractionBox[
              RowBox[{
               RowBox[{"1024", " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{"512", " ", 
                SuperscriptBox["z", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
               RowBox[{"128", " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{"1280", " ", 
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{"\[LeftSkeleton]", "519", "\[RightSkeleton]"}], "+", 
               RowBox[{"32", " ", 
                SuperscriptBox["z", "6"], " ", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], 
              RowBox[{"64", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], 
                ")"}]}]]}]}], ",", 
           RowBox[{
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
            RowBox[{"-", 
             FractionBox[
              RowBox[{"8", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}]}], 
                 ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", 
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 SuperscriptBox[
                  RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    FractionBox[
                    SuperscriptBox[
                    RowBox[{"\[Sigma]", 
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    "]"}], "2"], "4"]}], ")"}]}]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    ")"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], 
                    ")"}], "2"]}], ")"}]}], "+", 
                 RowBox[{"8", " ", "z", " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"4", "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}], 
                "2"]}]]}]}], ",", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
            RowBox[{"-", 
             FractionBox[
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", 
                  RowBox[{"h", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"f", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"\[LeftSkeleton]", "5", "\[RightSkeleton]"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{
                   SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
              RowBox[{"4", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "-", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}]]}]}]}], "}"}],
         Short[#, 5]& ],
        Background->GrayLevel[1],
        BaseStyle->{Deployed -> False},
        Frame->True,
        FrameStyle->GrayLevel[0, 0.2],
        StripOnInput->False]},
      {
       RowBox[{
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
             StandardForm],
            ImageSizeCache->{49., {1., 8.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>OutputSizeLimit`ButtonFunction[
          Identity, 124, 23228990775144254043, 5/2],
         Enabled->True,
         Evaluator->Automatic,
         Method->"Queued"], "\[ThinSpace]", 
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
             StandardForm],
            ImageSizeCache->{52., {1., 8.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>OutputSizeLimit`ButtonFunction[
          Identity, 124, 23228990775144254043, 5 2],
         Enabled->True,
         Evaluator->Automatic,
         Method->"Queued"], "\[ThinSpace]", 
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
             StandardForm],
            ImageSizeCache->{82., {2., 8.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>OutputSizeLimit`ButtonFunction[
          Identity, 124, 23228990775144254043, Infinity],
         Enabled->True,
         Evaluator->Automatic,
         Method->"Queued"], "\[ThinSpace]", 
        ButtonBox[
         StyleBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
             StandardForm],
            ImageSizeCache->{74., {1., 8.}}],
           StripOnInput->False,
           DynamicUpdating->True], "Panel",
          StripOnInput->False,
          Background->None],
         Appearance->Automatic,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetOptions[
            FrontEnd`$FrontEnd, 
             FrontEnd`PreferencesSettings -> {"Page" -> "Evaluation"}], 
            FrontEnd`FrontEndToken["PreferencesDialog"]}],
         Evaluator->None,
         Method->"Preemptive"]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[1.2]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    DefaultBaseStyle->{},
    FrameMargins->5],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  Out[124]]], "Output",
 CellChangeTimes->{3.538807992285688*^9, 3.5438695349077377`*^9, 
  3.544343264707368*^9, 3.544344579083766*^9, 3.5443446885771723`*^9, 
  3.544344733894693*^9, 3.544344843038731*^9, 3.544344881229087*^9, 
  3.5443536653872423`*^9, 3.5444591912873297`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqT2", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqav", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"eqgzz", ",", "z"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"Evsol", ",", "v"}], "]"}]}], "/.", "Evsol"}], "/.", "Momsol"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.460379877349128*^9, 3.460379983100644*^9}, {
  3.460380087445326*^9, 3.460380091873478*^9}, {3.537487726936469*^9, 
  3.5374877500015907`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.543869535315189*^9, 
  3.5443432909583673`*^9, 3.544459192535948*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.543869535315189*^9, 
  3.5443432909583673`*^9, 3.5444591936302023`*^9}],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.543869535315189*^9, 
  3.5443432909583673`*^9, 3.54445927372395*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Const1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Const2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Const3", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["s", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["s", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.46031768644937*^9, 3.46031772334064*^9}, {
  3.537487772329159*^9, 3.5374878178010073`*^9}, {3.537494258424617*^9, 
  3.537494262447569*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"4", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}], "2"]}]], 
   RowBox[{"8", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "4"]}], ")"}]}]}], 
      ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "4"]}], ")"}]}]}], 
        ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}]}], "+", 
      RowBox[{"8", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.544344881326605*^9, 3.544353665555982*^9, 
  3.544459275660297*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"4", "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}]], 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"z", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{"z", " ", 
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"f", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "+", 
               RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["a", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.544344881326605*^9, 3.544353665555982*^9, 
  3.544459275663858*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"64", " ", 
     SuperscriptBox["z", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"4", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1024", " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"512", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"128", " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"1280", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"384", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"512", " ", 
      SuperscriptBox["m", "2"], " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"1024", " ", "m", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"512", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
     RowBox[{"512", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"1024", " ", 
      SuperscriptBox["m", "2"], " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"2048", " ", "m", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"1024", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"512", " ", 
      SuperscriptBox["m", "2"], " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"1024", " ", "m", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"512", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"384", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"192", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["m", "2"], " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"512", " ", "m", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"192", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["m", "2"], " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"512", " ", "m", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"160", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"104", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"320", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"40", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["m", "2"], " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"]}], "+", 
     RowBox[{"64", " ", "m", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"]}], "+", 
     RowBox[{"112", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"]}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"]}], "+", 
     RowBox[{"56", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"]}], "-", 
     RowBox[{"18", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "8"]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "8"]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "8"]}], "+", 
     RowBox[{
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "10"]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["z", "2"]}], "+", 
        RowBox[{"64", " ", "m", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["z", "2"]}], "+", 
        RowBox[{"64", " ", "m", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}]}], 
       ")"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "-", 
     RowBox[{"384", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "3"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "+", 
     RowBox[{"192", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "+", 
     RowBox[{"96", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "-", 
     RowBox[{"48", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "7"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], "2"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], "2"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], "2"]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"48", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", "z", " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"512", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "9"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"192", " ", 
      SuperscriptBox["z", "3"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"320", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"384", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "9"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "9"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"104", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "9"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"80", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "9"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "9"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"24", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "7"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["z", "9"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "7"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "9"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "7"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "9"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "9"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"192", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"40", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "10"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"96", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"160", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"192", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "10"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "10"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"52", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["z", "10"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"40", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "10"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "10"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "10"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "10"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["z", "10"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "8"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"256", " ", "m", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"512", " ", "m", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"512", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", "m", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", "m", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"512", " ", "m", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"512", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", "m", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", "m", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"384", " ", "m", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"384", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", "m", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", "m", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", "m", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"80", " ", "m", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"80", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", "m", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"16", " ", "m", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"8", " ", "m", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "7"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "7"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "10"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"96", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"160", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"192", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "10"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "10"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"52", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["z", "10"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"40", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "10"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "10"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "10"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "10"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["z", "10"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "8"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"512", " ", "z", " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"768", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"384", " ", 
      SuperscriptBox["z", "3"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"192", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", "z", " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "3"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"96", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", "z", " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "3"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"192", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"40", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "7"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "7"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "7"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"512", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"192", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"40", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"512", " ", "m", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"512", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"1024", " ", "m", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"1024", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"512", " ", "m", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"512", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", "m", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", "m", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"32", " ", "m", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "5"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"192", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"40", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "8"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "8"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "6"], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "4"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"h", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"16", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", 
           RowBox[{"a", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[Sigma]", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", 
           RowBox[{"a", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "4"], " ", 
         RowBox[{"t", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"16", " ", "m", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"16", " ", "z", " ", 
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["m", "2"], " ", 
            SuperscriptBox["z", "2"]}], "+", 
           RowBox[{"16", " ", "m", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"a", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{"a", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "4"], " ", 
            SuperscriptBox[
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}], " ", 
         RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "5"]}], "+", 
        RowBox[{
         SuperscriptBox["z", "5"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "3"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             SuperscriptBox["\[Sigma]", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", "m", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"a", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
            RowBox[{
             SuperscriptBox["\[Sigma]", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", "m", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"a", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", "m", " ", 
            SuperscriptBox["z", "3"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["z", "3"], " ", 
            RowBox[{"a", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "-", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"4", " ", "m", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"4", " ", "z", " ", 
            RowBox[{"a", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{"512", " ", "z", " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "3"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"128", " ", "z", " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"64", " ", 
      SuperscriptBox["z", "5"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "5"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "4"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "-", 
     RowBox[{"128", " ", 
      SuperscriptBox["z", "6"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"32", " ", 
      SuperscriptBox["z", "6"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["t", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"2", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.544344881326605*^9, 3.544353665555982*^9, 
  3.544459275693358*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Eq1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq3", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Expand", "[", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}], "]"}], 
     "]"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq4", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["t", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["t", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.537489066732723*^9, 3.5374891410817547`*^9}, {
  3.537494265681246*^9, 3.537494272120749*^9}, {3.544345475134297*^9, 
  3.54434553247793*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"h", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"4", " ", "z", " ", 
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"4", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}]], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Sigma]", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], "+", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "4"]}], ")"}]}]}], 
         ")"}]}], 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "-", 
                FractionBox[
                 SuperscriptBox[
                  RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"]}], 
               ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
             RowBox[{"2", " ", "z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["\[Sigma]", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}], "+", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["\[Sigma]", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]}], 
     ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.538808034338485*^9, 3.5438695583201303`*^9, 3.5443434189455633`*^9, 
   3.544344881635076*^9, {3.544345477350584*^9, 3.544345497103199*^9}, 
   3.544345533360471*^9, 3.544353665886816*^9, 3.544459279463934*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                SuperscriptBox[
                 RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"f", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                   RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}]}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"4", " ", "z", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"4", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}]], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "4"]}], ")"}]}]}], 
         ")"}]}], 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "-", 
                FractionBox[
                 SuperscriptBox[
                  RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"]}], 
               ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "-", 
             RowBox[{"2", " ", "z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["\[Sigma]", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]}], 
     ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["h", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.538808034338485*^9, 3.5438695583201303`*^9, 3.5443434189455633`*^9, 
   3.544344881635076*^9, {3.544345477350584*^9, 3.544345497103199*^9}, 
   3.544345533360471*^9, 3.544353665886816*^9, 3.544459279471567*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"4", "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}]], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}]}], 
      "+", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               SuperscriptBox[
                RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}],
           " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"a", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"a", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"a", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
         RowBox[{
          SuperscriptBox["z", "4"], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["z", "2"]}], " ", 
             RowBox[{
              SuperscriptBox["\[Sigma]", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}], " ", 
             RowBox[{
              SuperscriptBox["a", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "-", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", 
                    RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["a", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.538808034338485*^9, 3.5438695583201303`*^9, 3.5443434189455633`*^9, 
   3.544344881635076*^9, {3.544345477350584*^9, 3.544345497103199*^9}, 
   3.544345533360471*^9, 3.544353665886816*^9, 3.544459280958365*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox["z", "4"]}]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "-", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "4"]}], ")"}]}]}], 
     ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"12", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "-", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"]}], ")"}]}]}], 
        ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "6"}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], ")"}]}], 
      "-", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}]], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       RowBox[{"4", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}]], "-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "-", 
                FractionBox[
                 SuperscriptBox[
                  RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"]}], 
               ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "2"], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["\[Sigma]", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "-", 
             FractionBox[
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "4"]}], ")"}]}]}], 
         ")"}], "2"]]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.538808034338485*^9, 3.5438695583201303`*^9, 3.5443434189455633`*^9, 
   3.544344881635076*^9, {3.544345477350584*^9, 3.544345497103199*^9}, 
   3.544345533360471*^9, 3.544353665886816*^9, 3.544459280964472*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     SuperscriptBox[
      RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], 
    SuperscriptBox["z", "2"]]}], "+", 
  FractionBox[
   RowBox[{"8", " ", 
    RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
    RowBox[{
     SuperscriptBox["\[Sigma]", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}]}], 
   RowBox[{
    RowBox[{"4", " ", "z"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["z", "3"], " ", 
     RowBox[{"s", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "-", 
    RowBox[{
     SuperscriptBox["z", "3"], " ", 
     SuperscriptBox[
      RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}]], "-", 
  SuperscriptBox[
   RowBox[{
    SuperscriptBox["a", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
    RowBox[{"h", "[", 
     RowBox[{"v", ",", "z"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "z"], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"h", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "z"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "6"}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "4"]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"6", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "4"]}]], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
    "2"]], "-", 
  FractionBox[
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["z", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}]}]], 
  "-", 
  FractionBox[
   RowBox[{"16", " ", "z", " ", 
    RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
    RowBox[{
     SuperscriptBox["\[Sigma]", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
    "2"]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["t", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}]}], "z"], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"4", " ", 
     RowBox[{"t", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
    RowBox[{"2", " ", "z", " ", 
     RowBox[{
      SuperscriptBox["t", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}], 
   SuperscriptBox["z", "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["z", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}]}]], 
  "+", 
  RowBox[{
   SuperscriptBox["t", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], "+", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "z"], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"h", "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}]}], "z"], "-", 
  FractionBox[
   RowBox[{"16", " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], "-", 
         RowBox[{"4", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}]}], 
   RowBox[{"z", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"4", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], ")"}]}]}], ")"}], 
     "2"]}]]}]], "Output",
 CellChangeTimes->{
  3.538808034338485*^9, 3.5438695583201303`*^9, 3.5443434189455633`*^9, 
   3.544344881635076*^9, {3.544345477350584*^9, 3.544345497103199*^9}, 
   3.544345533360471*^9, 3.544353665886816*^9, 3.5444592809686213`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "deriv", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"deriv", "[", "X_", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"X", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "X"}], ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<v\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<z\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"X", "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], ",", "z"}], 
        "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<vz\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"v", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<vv\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<zz\>\""}], "]"}]}]}],
      "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"deriv", "[", "j", "]"}]}], "Input",
 CellChangeTimes->{{3.537488129955064*^9, 3.537488303539091*^9}, 
   3.537565624076147*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"j", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "j"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jv"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jz"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jvz"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"2", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jvv"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jzz"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5388080344525146`*^9, 3.543869558400304*^9, 
  3.5443434200927963`*^9, 3.544344881867298*^9, 3.544345537939296*^9, 
  3.544459312325859*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Sigma]", "[", "v", "]"}], "\[Rule]", "p"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Sigma]", "'"}], "[", "v", "]"}], "\[Rule]", "pv"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Sigma]", "''"}], "[", "v", "]"}], "\[Rule]", "pvv"}]}], 
      "}"}], ",", 
     RowBox[{"deriv", "[", "f", "]"}], ",", 
     RowBox[{"deriv", "[", "a", "]"}], ",", 
     RowBox[{"deriv", "[", "h", "]"}], ",", 
     RowBox[{"deriv", "[", "t", "]"}], ",", 
     RowBox[{"deriv", "[", "s", "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460533850988061*^9, 3.460317762594681*^9}, {
  3.460317899777432*^9, 3.460317913876012*^9}, {3.4603179946260138`*^9, 
  3.460317994880909*^9}, {3.460318028461433*^9, 3.4603180359232483`*^9}, {
  3.5374878304982758`*^9, 3.537487855625393*^9}, {3.53748801305739*^9, 
  3.537488044943592*^9}, {3.537488108469489*^9, 3.537488111403976*^9}, {
  3.5374883167609386`*^9, 3.537488354940011*^9}, {3.537494360528582*^9, 
  3.537494365432303*^9}, {3.5374953043244743`*^9, 3.5374953101843863`*^9}, {
  3.544343338667395*^9, 3.544343351547291*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eq1str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Eq1", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537489304806736*^9, 3.537489309341483*^9}, {
   3.5374972785438137`*^9, 3.537497285903635*^9}, {3.537540737136909*^9, 
   3.537540745480649*^9}, 3.5375407900484257`*^9, {3.537541358740419*^9, 
   3.537541372163848*^9}, {3.5375414874019747`*^9, 3.537541501177627*^9}, {
   3.537541543216469*^9, 3.537541545224094*^9}, {3.544343536409142*^9, 
   3.5443435403469353`*^9}}],

Cell[BoxData["\<\"fvz - (pow(z,-2)*(2*(f + p) - 2*fv*z - 2*pv*z + 2*(fv + \
pv)*z - 2*az*h*pow(z,2) + (f + p + fz*z)*(2*t + tz*z - pow(p,2))*pow(z,2) + \
((-2*(f + p) + fzz*pow(z,2))*(2 + (2*t - pow(p,2))*pow(z,2)))/2. - 4*(a + \
m)*(4*hz + z*(4*h*sz*z + (2*h + hz*z)*(4*s - pow(p,2))))*pow(z,2)*pow(4 + \
(4*s - pow(p,2))*pow(z,2),-1) + pow(z,2)*((p*pv - 2*sv)*z*(f + p + fz*z) - \
(fv + pv)*z*(4*s + 2*sz*z - pow(p,2)) + 2*(f + p + fz*z)*(2*s + sz*z - \
pow(p,2)/2.)*(1 + (t - pow(p,2)/2.)*pow(z,2)))*pow(1 + (s - \
pow(p,2)/4.)*pow(z,2),-1)))/2.\"\>"], "Output",
 CellChangeTimes->{
  3.538808034531695*^9, 3.543869558473194*^9, 3.544343433628708*^9, {
   3.544343540880823*^9, 3.544343544469836*^9}, 3.5443448822682734`*^9, 
   3.544345539155551*^9, 3.544459316716411*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eq2str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Eq2", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537551719171803*^9, 3.537551720666493*^9}, {
  3.544343529881132*^9, 3.544343533033296*^9}}],

Cell[BoxData["\<\"hvz - (pow(z,-2)*(2*h + 2*az*(f + p)*pow(z,2) + (h + \
hz*z)*(2*t + tz*z - pow(p,2))*pow(z,2) + ((-2*h + hzz*pow(z,2))*(2 + (2*t - \
pow(p,2))*pow(z,2)))/2. + 4*(a + m)*(4*fz + z*(4*(f + p)*sz*z + (2*(f + p) + \
fz*z)*(4*s - pow(p,2))))*pow(z,2)*pow(4 + (4*s - pow(p,2))*pow(z,2),-1) + \
pow(z,2)*((p*pv - 2*sv)*z*(h + hz*z) + hv*z*(-4*s - 2*sz*z + pow(p,2)) + 2*(h \
+ hz*z)*(2*s + sz*z - pow(p,2)/2.)*(1 + (t - pow(p,2)/2.)*pow(z,2)))*pow(1 + \
(s - pow(p,2)/4.)*pow(z,2),-1)))/2.\"\>"], "Output",
 CellChangeTimes->{
  3.538808034586948*^9, 3.543869558517671*^9, 3.5443434347617702`*^9, {
   3.544343533515728*^9, 3.5443435449897118`*^9}, 3.544344882484976*^9, 
   3.544345539736843*^9, 3.544459317785119*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eq3str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Eq3", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537551722346656*^9, 3.537551723954479*^9}, {
  3.544343509887916*^9, 3.5443435262530212`*^9}}],

Cell[BoxData["\<\"avz + 2*(4*az*sv*pow(z,2) + 4*(a + m)*pow(f,2)*(4 + (4*s - \
pow(p,2))*pow(z,2)) + 4*(a + m)*pow(h,2)*(4 + (4*s - pow(p,2))*pow(z,2)) - \
f*(-4 + (-4*s + pow(p,2))*pow(z,2))*(-2*hv + 8*(a + m)*p - \
hz*pow(p,2)*pow(z,2) + 2*hz*(1 + t*pow(z,2))) + h*(4 + (4*s - \
pow(p,2))*pow(z,2))*(2*fv + 2*pv + fz*(-2 + (-2*t + pow(p,2))*pow(z,2))) + \
p*(-4*(a + m)*pow(p,3)*pow(z,2) + 16*(a + m)*p*(1 + s*pow(z,2)) + \
2*pow(p,2)*pow(z,2)*(hv - hz*(3 + (2*s + t)*pow(z,2))) + 2*(-(az*pv*pow(z,2)) \
+ 4*(1 + s*pow(z,2))*(-hv + hz*(1 + t*pow(z,2)))) + \
hz*pow(p,4)*pow(z,4)))*pow(4 + (4*s - pow(p,2))*pow(z,2),-1)\"\>"], "Output",
 CellChangeTimes->{
  3.538808034636338*^9, 3.543869558577878*^9, 3.544343435846356*^9, {
   3.544343526842533*^9, 3.5443435454877462`*^9}, 3.5443448827025747`*^9, 
   3.544345540393375*^9, 3.544459318569562*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eq4str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Eq4", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537551725538599*^9, 3.537551726962449*^9}, {
  3.544343511752201*^9, 3.5443435187274647`*^9}}],

Cell[BoxData["\<\"svz + (pow(z,-4)*(1 + (s - pow(p,2)/4.)*pow(z,2))*(12 + \
4*pow(h,2)*pow(z,2) + 4*(2*t + tz*z - pow(p,2))*pow(z,2) + 4*pow(f + \
p,2)*pow(z,2) - pow(az,2)*pow(z,4) + 2*(1 + (t - pow(p,2)/2.)*pow(z,2))*(-6 + \
pow(z,2)*pow(f + p + fz*z,2) + pow(z,2)*pow(h + hz*z,2)) - 8*(4*s + 2*sz*z - \
pow(p,2))*(2*t + tz*z - pow(p,2))*pow(z,4)*pow(4 + (4*s - \
pow(p,2))*pow(z,2),-1) - 4*(2*s + sz*z - pow(p,2)/2.)*((p*pv - 2*sv)*z + (2*s \
+ sz*z - pow(p,2)/2.)*(1 + (t - pow(p,2)/2.)*pow(z,2)))*pow(z,4)*pow(1 + (s - \
pow(p,2)/4.)*pow(z,2),-2) - 16*(4*s + 2*sz*z - pow(p,2))*pow(z,2)*(2 + (2*t - \
pow(p,2))*pow(z,2))*pow(-4 + (-4*s + pow(p,2))*pow(z,2),-1)))/8.\"\>"], \
"Output",
 CellChangeTimes->{{3.544343519171138*^9, 3.5443435459914227`*^9}, 
   3.544344882921999*^9, 3.544345541056335*^9, 3.544459319404332*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eq5str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Eq5", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5375517285546923`*^9, 3.537551730078916*^9}, {
  3.544343502593671*^9, 3.544343520310988*^9}}],

Cell[BoxData["\<\"tzz - pow(az,2) - (4*t + 2*tz*z - 2*pow(p,2))*pow(z,-2) - \
(-2*t + pow(p,2))*pow(z,-2) + 4*tz*pow(z,-1) - 4*h*(a + m)*(f + p + \
fz*z)*pow(z,-1) - 2*(fv + pv)*(f + p + fz*z)*pow(z,-1) - 2*hv*(h + \
hz*z)*pow(z,-1) + 4*(a + m)*(f + p)*(h + hz*z)*pow(z,-1) + (pow(z,-4)*(2 + \
(2*t - pow(p,2))*pow(z,2))*(-6 + pow(z,2)*(2*h*hz*z + pow(h,2) + \
pow(hz,2)*pow(z,2) + pow(f + p + fz*z,2))))/2. + (pow(z,-4)*(2 + (2*t - \
pow(p,2))*pow(z,2))*(6 + pow(z,2)*(2*h*hz*z + pow(h,2) + pow(hz,2)*pow(z,2) + \
pow(f + p + fz*z,2))))/2. - 16*p*pv*z*(4*s + 2*sz*z - pow(p,2))*pow(4 + (4*s \
- pow(p,2))*pow(z,2),-2) - 16*sv*pow(z,-1)*(4 + (-4*s - 4*sz*z + \
pow(p,2))*pow(z,2))*pow(4 + (4*s - pow(p,2))*pow(z,2),-2) - 4*(2 + (2*t - \
pow(p,2))*pow(z,2))*pow(-4*s - 2*sz*z + pow(p,2),2)*pow(4 + (4*s - \
pow(p,2))*pow(z,2),-2) - 8*(4*s + 2*sz*z - pow(p,2))*pow(z,-2)*(-2 + (-2*t + \
pow(p,2))*pow(z,2))*pow(4 + (4*s - pow(p,2))*pow(z,2),-1) - 2*(-4*s + \
2*z*(2*sz + szz*z) + pow(p,2))*pow(z,-2)*(-2 + (-2*t + \
pow(p,2))*pow(z,2))*pow(4 + (4*s - pow(p,2))*pow(z,2),-1) + 8*p*pv*pow(4*z + \
4*s*pow(z,3) - pow(p,2)*pow(z,3),-1)\"\>"], "Output",
 CellChangeTimes->{
  3.538807898663368*^9, 3.538808034774719*^9, 3.543869558680262*^9, 
   3.544343438198242*^9, {3.544343520744734*^9, 3.5443435466242523`*^9}, 
   3.544344883137394*^9, 3.5443455416316843`*^9, 3.5444593202709417`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C1str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Const1", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537489304806736*^9, 3.537489309341483*^9}, {
   3.5374972785438137`*^9, 3.537497285903635*^9}, {3.537540737136909*^9, 
   3.537540745480649*^9}, 3.5375407900484257`*^9, {3.537541358740419*^9, 
   3.537541372163848*^9}, {3.5375414874019747`*^9, 3.537541501177627*^9}, {
   3.537541543216469*^9, 3.537541545224094*^9}, {3.538807876854679*^9, 
   3.538807885102872*^9}, {3.544343481770335*^9, 3.5443434923038397`*^9}}],

Cell[BoxData["\<\"szz + 8*pow(z,-2)*(4*s + 8*sz*z - pow(p,2) + (1 + (s - \
pow(p,2)/4.)*pow(z,2))*(pow(f + p + fz*z,2) + pow(h + hz*z,2)))*pow(1 + (s - \
pow(p,2)/4.)*pow(z,2),2)*pow(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2),-2)\"\>"], \
"Output",
 CellChangeTimes->{3.5443434980781097`*^9, 3.544343547174124*^9, 
  3.544344883352786*^9, 3.5444593218750153`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C2str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Const2", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5388078907580767`*^9, 3.538807892116951*^9}, {
  3.544343472184718*^9, 3.544343490679863*^9}}],

Cell[BoxData["\<\"azz + 4*(-4*fz*h + 4*f*hz + 4*hz*p + 4*s*z*(az + (-(fz*h) + \
hz*(f + p))*z) + z*(-az + fz*h*z - f*hz*z)*pow(p,2) + 2*az*sz*pow(z,2) - \
hz*pow(p,3)*pow(z,2))*pow(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2),-1)\"\>"], \
"Output",
 CellChangeTimes->{3.54434349612337*^9, 3.544343547692355*^9, 
  3.54434488356933*^9, 3.5444593226766653`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C3str", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{"Const3", "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.538807893564623*^9, 3.538807895276726*^9}, {
  3.544343460216667*^9, 3.544343489311842*^9}}],

Cell[BoxData["\<\"svv + (pow(z,-2)*pow(4 + 4*s*pow(z,2) - \
pow(p,2)*pow(z,2),-1)*(1024*s - 128*t - 128*fv*p*z + 128*fz*p*z - 512*sv*z + \
512*sz*z + 128*tv*z + 128*tz*z - 128*fv*fz*pow(z,2) - 128*hv*hz*pow(z,2) - \
512*a*hv*p*pow(z,2) + 256*a*hz*p*pow(z,2) - 512*hv*m*p*pow(z,2) + \
256*hz*m*p*pow(z,2) + 256*fv*pv*pow(z,2) - 128*fz*pv*pow(z,2) - \
128*p*pvv*pow(z,2) + 1280*s*t*pow(z,2) - 32*pow(az,2)*pow(z,2) + \
128*pow(fv,2)*pow(z,2) + 64*pow(fz,2)*pow(z,2) + 128*pow(hv,2)*pow(z,2) + \
64*pow(hz,2)*pow(z,2) + 1024*a*m*pow(p,2)*pow(z,2) - 512*s*pow(p,2)*pow(z,2) \
+ 64*t*pow(p,2)*pow(z,2) + 512*pow(a,2)*pow(p,2)*pow(z,2) + \
512*pow(m,2)*pow(p,2)*pow(z,2) - 64*pow(p,4)*pow(z,2) + 512*pow(s,2)*pow(z,2) \
- 128*pow(t,2)*pow(z,2) - 256*fv*p*s*pow(z,3) + 256*fz*p*s*pow(z,3) - \
256*p*pv*s*pow(z,3) - 128*fv*p*t*pow(z,3) + 256*fz*p*t*pow(z,3) - \
256*sv*t*pow(z,3) + 768*sz*t*pow(z,3) + 128*t*tz*pow(z,3) + \
128*sv*pow(p,2)*pow(z,3) - 384*sz*pow(p,2)*pow(z,3) - 64*tz*pow(p,2)*pow(z,3) \
+ 128*fv*pow(p,3)*pow(z,3) - 192*fz*pow(p,3)*pow(z,3) + \
64*pv*pow(p,3)*pow(z,3) - 256*fv*fz*s*pow(z,4) - 256*hv*hz*s*pow(z,4) - \
1024*a*hv*p*s*pow(z,4) + 512*a*hz*p*s*pow(z,4) - 1024*hv*m*p*s*pow(z,4) + \
512*hz*m*p*s*pow(z,4) + 512*fv*pv*s*pow(z,4) - 256*fz*pv*s*pow(z,4) - \
128*p*pvv*s*pow(z,4) + 256*sv*sz*pow(z,4) - 128*fv*fz*t*pow(z,4) - \
128*hv*hz*t*pow(z,4) + 256*a*hz*p*t*pow(z,4) + 256*hz*m*p*t*pow(z,4) - \
128*fz*pv*t*pow(z,4) - 128*sz*tv*pow(z,4) - 64*p*pv*tz*pow(z,4) + \
128*sv*tz*pow(z,4) - 128*sz*tz*pow(z,4) - 64*s*pow(az,2)*pow(z,4) - \
32*t*pow(az,2)*pow(z,4) + 256*s*pow(fv,2)*pow(z,4) + 128*s*pow(fz,2)*pow(z,4) \
+ 128*t*pow(fz,2)*pow(z,4) + 256*s*pow(hv,2)*pow(z,4) + \
128*s*pow(hz,2)*pow(z,4) + 128*t*pow(hz,2)*pow(z,4) + \
128*fv*fz*pow(p,2)*pow(z,4) + 128*hv*hz*pow(p,2)*pow(z,4) - \
128*fv*pv*pow(p,2)*pow(z,4) + 128*fz*pv*pow(p,2)*pow(z,4) + \
2048*a*m*s*pow(p,2)*pow(z,4) + 64*s*t*pow(p,2)*pow(z,4) + \
1024*s*pow(a,2)*pow(p,2)*pow(z,4) + 32*pow(az,2)*pow(p,2)*pow(z,4) - \
64*pow(fv,2)*pow(p,2)*pow(z,4) - 96*pow(fz,2)*pow(p,2)*pow(z,4) - \
64*pow(hv,2)*pow(p,2)*pow(z,4) - 96*pow(hz,2)*pow(p,2)*pow(z,4) + \
1024*s*pow(m,2)*pow(p,2)*pow(z,4) + 256*a*hv*pow(p,3)*pow(z,4) - \
256*a*hz*pow(p,3)*pow(z,4) + 256*hv*m*pow(p,3)*pow(z,4) - \
256*hz*m*pow(p,3)*pow(z,4) + 32*pvv*pow(p,3)*pow(z,4) - \
512*a*m*pow(p,4)*pow(z,4) - 192*s*pow(p,4)*pow(z,4) - 104*t*pow(p,4)*pow(z,4) \
- 256*pow(a,2)*pow(p,4)*pow(z,4) - 256*pow(m,2)*pow(p,4)*pow(z,4) + \
64*pow(p,6)*pow(z,4) + 128*s*pow(pv,2)*pow(z,4) - \
32*pow(p,2)*pow(pv,2)*pow(z,4) + 384*t*pow(s,2)*pow(z,4) - \
128*pow(sz,2)*pow(z,4) + 256*s*pow(t,2)*pow(z,4) - 256*fv*p*s*t*pow(z,5) + \
512*fz*p*s*t*pow(z,5) - 384*p*pv*s*t*pow(z,5) + 256*s*sv*t*pow(z,5) - \
256*s*sz*t*pow(z,5) - 128*s*sv*pow(p,2)*pow(z,5) + 128*s*sz*pow(p,2)*pow(z,5) \
- 64*sv*t*pow(p,2)*pow(z,5) - 192*sz*t*pow(p,2)*pow(z,5) + \
64*s*tv*pow(p,2)*pow(z,5) + 64*s*tz*pow(p,2)*pow(z,5) + \
192*fv*s*pow(p,3)*pow(z,5) - 320*fz*s*pow(p,3)*pow(z,5) + \
192*pv*s*pow(p,3)*pow(z,5) + 64*fv*t*pow(p,3)*pow(z,5) - \
256*fz*t*pow(p,3)*pow(z,5) + 96*pv*t*pow(p,3)*pow(z,5) + \
32*sv*pow(p,4)*pow(z,5) + 32*sz*pow(p,4)*pow(z,5) - 8*tv*pow(p,4)*pow(z,5) - \
8*tz*pow(p,4)*pow(z,5) - 40*fv*pow(p,5)*pow(z,5) + 104*fz*pow(p,5)*pow(z,5) - \
48*pv*pow(p,5)*pow(z,5) - 128*fv*p*pow(s,2)*pow(z,5) + \
128*fz*p*pow(s,2)*pow(z,5) - 128*tv*pow(s,2)*pow(z,5) - \
128*tz*pow(s,2)*pow(z,5) + 128*fz*p*pow(t,2)*pow(z,5) + \
256*sz*pow(t,2)*pow(z,5) + 128*p*pv*s*sz*pow(z,6) - 256*fv*fz*s*t*pow(z,6) - \
256*hv*hz*s*t*pow(z,6) + 512*a*hz*p*s*t*pow(z,6) + 512*hz*m*p*s*t*pow(z,6) - \
256*fz*pv*s*t*pow(z,6) - 128*p*pv*sz*t*pow(z,6) + 256*sv*sz*t*pow(z,6) - \
128*s*sz*tv*pow(z,6) - 64*p*pv*s*tz*pow(z,6) + 128*s*sv*tz*pow(z,6) - \
128*s*sz*tz*pow(z,6) - 128*sz*t*tz*pow(z,6) - 64*s*t*pow(az,2)*pow(z,6) + \
256*s*t*pow(fz,2)*pow(z,6) + 256*s*t*pow(hz,2)*pow(z,6) + \
192*fv*fz*s*pow(p,2)*pow(z,6) + 192*hv*hz*s*pow(p,2)*pow(z,6) - \
128*fv*pv*s*pow(p,2)*pow(z,6) + 192*fz*pv*s*pow(p,2)*pow(z,6) - \
128*sv*sz*pow(p,2)*pow(z,6) + 64*fv*fz*t*pow(p,2)*pow(z,6) + \
64*hv*hz*t*pow(p,2)*pow(z,6) + 64*fz*pv*t*pow(p,2)*pow(z,6) + \
32*sz*tv*pow(p,2)*pow(z,6) - 32*sv*tz*pow(p,2)*pow(z,6) + \
96*sz*tz*pow(p,2)*pow(z,6) + 48*s*pow(az,2)*pow(p,2)*pow(z,6) + \
16*t*pow(az,2)*pow(p,2)*pow(z,6) - 64*s*pow(fv,2)*pow(p,2)*pow(z,6) - \
160*s*pow(fz,2)*pow(p,2)*pow(z,6) - 128*t*pow(fz,2)*pow(p,2)*pow(z,6) - \
64*s*pow(hv,2)*pow(p,2)*pow(z,6) - 160*s*pow(hz,2)*pow(p,2)*pow(z,6) - \
128*t*pow(hz,2)*pow(p,2)*pow(z,6) + 256*a*hv*s*pow(p,3)*pow(z,6) - \
384*a*hz*s*pow(p,3)*pow(z,6) + 256*hv*m*s*pow(p,3)*pow(z,6) - \
384*hz*m*s*pow(p,3)*pow(z,6) + 32*pv*sz*pow(p,3)*pow(z,6) - \
128*a*hz*t*pow(p,3)*pow(z,6) - 128*hz*m*t*pow(p,3)*pow(z,6) + \
16*pv*tz*pow(p,3)*pow(z,6) - 40*fv*fz*pow(p,4)*pow(z,6) - \
40*hv*hz*pow(p,4)*pow(z,6) + 16*fv*pv*pow(p,4)*pow(z,6) - \
40*fz*pv*pow(p,4)*pow(z,6) - 512*a*m*s*pow(p,4)*pow(z,6) - \
320*s*t*pow(p,4)*pow(z,6) - 256*s*pow(a,2)*pow(p,4)*pow(z,6) - \
10*pow(az,2)*pow(p,4)*pow(z,6) + 8*pow(fv,2)*pow(p,4)*pow(z,6) + \
52*pow(fz,2)*pow(p,4)*pow(z,6) + 8*pow(hv,2)*pow(p,4)*pow(z,6) + \
52*pow(hz,2)*pow(p,4)*pow(z,6) - 256*s*pow(m,2)*pow(p,4)*pow(z,6) - \
32*a*hv*pow(p,5)*pow(z,6) + 80*a*hz*pow(p,5)*pow(z,6) - \
32*hv*m*pow(p,5)*pow(z,6) + 80*hz*m*pow(p,5)*pow(z,6) + \
64*a*m*pow(p,6)*pow(z,6) + 112*s*pow(p,6)*pow(z,6) + 56*t*pow(p,6)*pow(z,6) + \
32*pow(a,2)*pow(p,6)*pow(z,6) + 32*pow(m,2)*pow(p,6)*pow(z,6) - \
18*pow(p,8)*pow(z,6) - 64*s*pow(p,2)*pow(pv,2)*pow(z,6) + \
8*pow(p,4)*pow(pv,2)*pow(z,6) - 128*fv*fz*pow(s,2)*pow(z,6) - \
128*hv*hz*pow(s,2)*pow(z,6) - 512*a*hv*p*pow(s,2)*pow(z,6) + \
256*a*hz*p*pow(s,2)*pow(z,6) - 512*hv*m*p*pow(s,2)*pow(z,6) + \
256*hz*m*p*pow(s,2)*pow(z,6) + 256*fv*pv*pow(s,2)*pow(z,6) - \
128*fz*pv*pow(s,2)*pow(z,6) - 32*pow(az,2)*pow(s,2)*pow(z,6) + \
128*pow(fv,2)*pow(s,2)*pow(z,6) + 64*pow(fz,2)*pow(s,2)*pow(z,6) + \
128*pow(hv,2)*pow(s,2)*pow(z,6) + 64*pow(hz,2)*pow(s,2)*pow(z,6) + \
1024*a*m*pow(p,2)*pow(s,2)*pow(z,6) + 384*t*pow(p,2)*pow(s,2)*pow(z,6) + \
512*pow(a,2)*pow(p,2)*pow(s,2)*pow(z,6) + \
512*pow(m,2)*pow(p,2)*pow(s,2)*pow(z,6) - 160*pow(p,4)*pow(s,2)*pow(z,6) + \
128*pow(pv,2)*pow(s,2)*pow(z,6) - 256*t*pow(sz,2)*pow(z,6) + \
128*pow(p,2)*pow(sz,2)*pow(z,6) + 64*pow(fz,2)*pow(t,2)*pow(z,6) + \
64*pow(hz,2)*pow(t,2)*pow(z,6) + 192*s*pow(p,2)*pow(t,2)*pow(z,6) - \
40*pow(p,4)*pow(t,2)*pow(z,6) - 128*pow(s,2)*pow(t,2)*pow(z,6) + \
256*s*sz*t*pow(p,2)*pow(z,7) + 64*s*t*tz*pow(p,2)*pow(z,7) + \
64*fv*s*t*pow(p,3)*pow(z,7) - 384*fz*s*t*pow(p,3)*pow(z,7) + \
64*pv*s*t*pow(p,3)*pow(z,7) - 64*s*sz*pow(p,4)*pow(z,7) - \
64*sz*t*pow(p,4)*pow(z,7) - 32*s*tz*pow(p,4)*pow(z,7) - \
8*t*tz*pow(p,4)*pow(z,7) - 32*fv*s*pow(p,5)*pow(z,7) + \
128*fz*s*pow(p,5)*pow(z,7) - 32*pv*s*pow(p,5)*pow(z,7) - \
8*fv*t*pow(p,5)*pow(z,7) + 80*fz*t*pow(p,5)*pow(z,7) - \
8*pv*t*pow(p,5)*pow(z,7) + 16*sz*pow(p,6)*pow(z,7) + 4*tz*pow(p,6)*pow(z,7) + \
4*fv*pow(p,7)*pow(z,7) - 24*fz*pow(p,7)*pow(z,7) + 4*pv*pow(p,7)*pow(z,7) - \
128*fv*p*t*pow(s,2)*pow(z,7) + 256*fz*p*t*pow(s,2)*pow(z,7) - \
128*p*pv*t*pow(s,2)*pow(z,7) - 128*t*tz*pow(s,2)*pow(z,7) + \
64*tz*pow(p,2)*pow(s,2)*pow(z,7) + 64*fv*pow(p,3)*pow(s,2)*pow(z,7) - \
128*fz*pow(p,3)*pow(s,2)*pow(z,7) + 64*pv*pow(p,3)*pow(s,2)*pow(z,7) + \
256*fz*p*s*pow(t,2)*pow(z,7) - 256*s*sz*pow(t,2)*pow(z,7) + \
64*sz*pow(p,2)*pow(t,2)*pow(z,7) - 64*fz*pow(p,3)*pow(t,2)*pow(z,7) - \
128*s*sz*t*tz*pow(z,8) + 64*fv*fz*s*t*pow(p,2)*pow(z,8) + \
64*hv*hz*s*t*pow(p,2)*pow(z,8) + 64*fz*pv*s*t*pow(p,2)*pow(z,8) + \
64*s*sz*tz*pow(p,2)*pow(z,8) + 32*sz*t*tz*pow(p,2)*pow(z,8) + \
16*s*t*pow(az,2)*pow(p,2)*pow(z,8) - 192*s*t*pow(fz,2)*pow(p,2)*pow(z,8) - \
192*s*t*pow(hz,2)*pow(p,2)*pow(z,8) - 128*a*hz*s*t*pow(p,3)*pow(z,8) - \
128*hz*m*s*t*pow(p,3)*pow(z,8) - 32*fv*fz*s*pow(p,4)*pow(z,8) - \
32*hv*hz*s*pow(p,4)*pow(z,8) - 32*fz*pv*s*pow(p,4)*pow(z,8) - \
8*fv*fz*t*pow(p,4)*pow(z,8) - 8*hv*hz*t*pow(p,4)*pow(z,8) - \
8*fz*pv*t*pow(p,4)*pow(z,8) - 16*sz*tz*pow(p,4)*pow(z,8) - \
8*s*pow(az,2)*pow(p,4)*pow(z,8) - 2*t*pow(az,2)*pow(p,4)*pow(z,8) + \
64*s*pow(fz,2)*pow(p,4)*pow(z,8) + 40*t*pow(fz,2)*pow(p,4)*pow(z,8) + \
64*s*pow(hz,2)*pow(p,4)*pow(z,8) + 40*t*pow(hz,2)*pow(p,4)*pow(z,8) + \
64*a*hz*s*pow(p,5)*pow(z,8) + 64*hz*m*s*pow(p,5)*pow(z,8) + \
16*a*hz*t*pow(p,5)*pow(z,8) + 16*hz*m*t*pow(p,5)*pow(z,8) + \
4*fv*fz*pow(p,6)*pow(z,8) + 4*hv*hz*pow(p,6)*pow(z,8) + \
4*fz*pv*pow(p,6)*pow(z,8) + 32*s*t*pow(p,6)*pow(z,8) + \
pow(az,2)*pow(p,6)*pow(z,8) - 12*pow(fz,2)*pow(p,6)*pow(z,8) - \
12*pow(hz,2)*pow(p,6)*pow(z,8) - 8*a*hz*pow(p,7)*pow(z,8) - \
8*hz*m*pow(p,7)*pow(z,8) - 8*s*pow(p,8)*pow(z,8) - 4*t*pow(p,8)*pow(z,8) + \
pow(p,10)*pow(z,8) - 128*fv*fz*t*pow(s,2)*pow(z,8) - \
128*hv*hz*t*pow(s,2)*pow(z,8) + 256*a*hz*p*t*pow(s,2)*pow(z,8) + \
256*hz*m*p*t*pow(s,2)*pow(z,8) - 128*fz*pv*t*pow(s,2)*pow(z,8) - \
32*t*pow(az,2)*pow(s,2)*pow(z,8) + 128*t*pow(fz,2)*pow(s,2)*pow(z,8) + \
128*t*pow(hz,2)*pow(s,2)*pow(z,8) + 64*fv*fz*pow(p,2)*pow(s,2)*pow(z,8) + \
64*hv*hz*pow(p,2)*pow(s,2)*pow(z,8) + 64*fz*pv*pow(p,2)*pow(s,2)*pow(z,8) + \
16*pow(az,2)*pow(p,2)*pow(s,2)*pow(z,8) - \
64*pow(fz,2)*pow(p,2)*pow(s,2)*pow(z,8) - \
64*pow(hz,2)*pow(p,2)*pow(s,2)*pow(z,8) - 128*a*hz*pow(p,3)*pow(s,2)*pow(z,8) \
- 128*hz*m*pow(p,3)*pow(s,2)*pow(z,8) - 64*t*pow(p,4)*pow(s,2)*pow(z,8) + \
16*pow(p,6)*pow(s,2)*pow(z,8) + 128*t*pow(p,2)*pow(sz,2)*pow(z,8) - \
32*pow(p,4)*pow(sz,2)*pow(z,8) + 128*s*pow(fz,2)*pow(t,2)*pow(z,8) + \
128*s*pow(hz,2)*pow(t,2)*pow(z,8) - 32*pow(fz,2)*pow(p,2)*pow(t,2)*pow(z,8) - \
32*pow(hz,2)*pow(p,2)*pow(t,2)*pow(z,8) - 32*s*pow(p,4)*pow(t,2)*pow(z,8) + \
4*pow(p,6)*pow(t,2)*pow(z,8) + 64*pow(p,2)*pow(s,2)*pow(t,2)*pow(z,8) - \
128*pow(sz,2)*pow(t,2)*pow(z,8) + 64*fz*s*t*pow(p,5)*pow(z,9) - \
16*fz*s*pow(p,7)*pow(z,9) - 8*fz*t*pow(p,7)*pow(z,9) + 2*fz*pow(p,9)*pow(z,9) \
- 128*fz*t*pow(p,3)*pow(s,2)*pow(z,9) + 32*fz*pow(p,5)*pow(s,2)*pow(z,9) - \
64*fz*s*pow(p,3)*pow(t,2)*pow(z,9) + 8*fz*pow(p,5)*pow(t,2)*pow(z,9) + \
128*fz*p*pow(s,2)*pow(t,2)*pow(z,9) + 32*s*t*pow(fz,2)*pow(p,4)*pow(z,10) + \
32*s*t*pow(hz,2)*pow(p,4)*pow(z,10) - 8*s*pow(fz,2)*pow(p,6)*pow(z,10) - \
4*t*pow(fz,2)*pow(p,6)*pow(z,10) - 8*s*pow(hz,2)*pow(p,6)*pow(z,10) - \
4*t*pow(hz,2)*pow(p,6)*pow(z,10) + pow(fz,2)*pow(p,8)*pow(z,10) + \
pow(hz,2)*pow(p,8)*pow(z,10) - 64*t*pow(fz,2)*pow(p,2)*pow(s,2)*pow(z,10) - \
64*t*pow(hz,2)*pow(p,2)*pow(s,2)*pow(z,10) + \
16*pow(fz,2)*pow(p,4)*pow(s,2)*pow(z,10) + \
16*pow(hz,2)*pow(p,4)*pow(s,2)*pow(z,10) - \
32*s*pow(fz,2)*pow(p,2)*pow(t,2)*pow(z,10) - \
32*s*pow(hz,2)*pow(p,2)*pow(t,2)*pow(z,10) + \
4*pow(fz,2)*pow(p,4)*pow(t,2)*pow(z,10) + \
4*pow(hz,2)*pow(p,4)*pow(t,2)*pow(z,10) + \
64*pow(fz,2)*pow(s,2)*pow(t,2)*pow(z,10) + \
64*pow(hz,2)*pow(s,2)*pow(t,2)*pow(z,10) + pow(f,2)*(12 + 64*a*m*pow(z,2) + \
32*pow(a,2)*pow(z,2) + 32*pow(m,2)*pow(z,2) - 8*pow(p,2)*pow(z,2) - \
4*t*pow(z,2)*(-4 + pow(p,2)*pow(z,2)) + pow(p,4)*pow(z,4) + \
4*pow(t,2)*pow(z,4))*pow(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2),2) + \
pow(h,2)*(12 + 64*a*m*pow(z,2) + 32*pow(a,2)*pow(z,2) + 32*pow(m,2)*pow(z,2) \
- 8*pow(p,2)*pow(z,2) - 4*t*pow(z,2)*(-4 + pow(p,2)*pow(z,2)) + \
pow(p,4)*pow(z,4) + 4*pow(t,2)*pow(z,4))*pow(4 + 4*s*pow(z,2) - \
pow(p,2)*pow(z,2),2) + 2*h*z*(-4*hv + 4*hz + 16*a*fv*z + 16*fv*m*z + 16*(a + \
m)*pv*z - 4*hv*t*pow(z,2) + 8*hz*t*pow(z,2) + 2*hv*pow(p,2)*pow(z,2) - \
4*hz*pow(p,2)*pow(z,2) - 4*fz*(a + m)*z*(2 + 2*t*pow(z,2) - \
pow(p,2)*pow(z,2)) - 4*hz*t*pow(p,2)*pow(z,4) + hz*pow(p,4)*pow(z,4) + \
4*hz*pow(t,2)*pow(z,4))*pow(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2),2) + \
2*f*(-4*pow(p,3)*pow(z,2)*(2 + t*pow(z,2)) - 2*pow(p,2)*(-fv - pv + 2*a*hz*z \
+ 2*hz*m*z + 2*fz*(1 + t*pow(z,2)))*pow(z,3) + pow(p,5)*pow(z,4) + 4*p*(3 + \
16*a*m*pow(z,2) + 4*t*pow(z,2) + 8*pow(a,2)*pow(z,2) + 8*pow(m,2)*pow(z,2) + \
pow(t,2)*pow(z,4)) + fz*pow(p,4)*pow(z,5) + 4*z*(-fv - 4*a*hv*z + 2*a*hz*z - \
4*hv*m*z + 2*hz*m*z - fv*t*pow(z,2) - pv*(1 + t*pow(z,2)) + 2*a*hz*t*pow(z,3) \
+ 2*hz*m*t*pow(z,3) + fz*pow(1 + t*pow(z,2),2)))*pow(4 + 4*s*pow(z,2) - \
pow(p,2)*pow(z,2),2)))/64.\"\>"], "Output",
 CellChangeTimes->{3.54434349421563*^9, 3.544343548244679*^9, 
  3.5443448837929487`*^9, 3.544459323429332*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Riccistr", "=", 
  RowBox[{"ToString", "[", 
   RowBox[{"CForm", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Simplify", "[", "Ricci", "]"}], "//.", "repl"}], "//.", 
     RowBox[{"{", 
      RowBox[{"Power", "\[Rule]", "pow"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544459335859148*^9, 3.5444593682255497`*^9}}],

Cell[BoxData["\<\"(pow(1 + (s - \
pow(p,2)/4.)*pow(z,2),-2)*(8*pow(z,3)*(-2*(3*sv + 2*svz*z)*pow(p,2)*pow(z,2) \
+ 3*pv*pow(p,3)*pow(z,2) - 4*p*pv*(1 + 3*s*pow(z,2) + sz*pow(z,3)) + \
8*(2*svz*z*(1 + s*pow(z,2)) + sv*(1 + 3*s*pow(z,2) + sz*pow(z,3)))) + \
8*pow(z,2)*(4 + 4*s*pow(z,2) - pow(p,2)*pow(z,2))*(s*(8 - 4*tz*pow(z,3)) - \
2*z*(szz*z*(1 + t*pow(z,2)) + sz*(1 + 3*t*pow(z,2) + tz*pow(z,3))) + \
pow(p,2)*(-2 + 3*sz*pow(z,3) + tz*pow(z,3) + szz*pow(z,4))) - 4*(2 + \
2*t*pow(z,2) - pow(p,2)*pow(z,2))*pow(z,4)*pow(-4*s - 2*sz*z + pow(p,2),2) - \
(12 + 2*t*pow(z,2) - pow(p,2)*pow(z,2) - 2*tz*pow(z,3) + tzz*pow(z,4))*pow(4 \
+ 4*s*pow(z,2) - pow(p,2)*pow(z,2),2)))/16.\"\>"], "Output",
 CellChangeTimes->{3.544459370653853*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<~/Work/AdSCMTDyn2/C/eqn.text\>\"", ",", 
   RowBox[{
   "\"\<\\n\\neq1 = \>\"", "<>", "Eq1str", "<>", "\"\< ; \\n\\neq2 = \>\"", "<>",
     "Eq2str", "<>", "\"\< ; \\n\\neq3 = \>\"", "<>", "Eq3str", "<>", 
    "\"\< ; \\n\\neq4 = \>\"", "<>", "Eq4str", "<>", 
    "\"\< ; \\n\\neq5 = \>\"", "<>", "Eq5str", "<>", 
    "\"\< ; \\n\\nconst1 = \>\"", "<>", "C1str", "<>", 
    "\"\< ; \\n\\nconst2 = \>\"", "<>", "C2str", "<>", 
    "\"\< ; \\n\\nconst3 = \>\"", "<>", "C3str", "<>", 
    "\"\< ; \\n\\nRicci = \>\"", "<>", "Riccistr", "<>", 
    "\"\< ; \\n\\n\>\""}], ",", "\"\<string\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.537499515937183*^9, 3.5374995738978567`*^9}, 
   3.538808081344832*^9, 3.544343447869833*^9, {3.54434450627693*^9, 
   3.544344529774969*^9}, {3.544459386740196*^9, 3.544459394804756*^9}}],

Cell[BoxData["\<\"~/Work/AdSCMTDyn2/C/eqn.text\"\>"], "Output",
 CellChangeTimes->{3.538808035236641*^9, 3.538808081883874*^9, 
  3.543869559068722*^9, 3.543869597832314*^9, 3.544343549463397*^9, 
  3.544344884049696*^9, 3.544345547402849*^9, 3.544459400631795*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"f2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"f3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"f4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"f5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"h2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"h3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"h4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"h5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a1", "[", "v", "]"}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"a2", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"z", "^", "2"}], " ", 
        RowBox[{"a3", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"z", "^", "3"}], " ", 
        RowBox[{"a4", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"z", "^", "4"}], " ", 
        RowBox[{"a5", "[", "v", "]"}]}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"t", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"t3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"t4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"t5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"z", " ", 
     RowBox[{"s3", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], " ", 
     RowBox[{"s4", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", 
     RowBox[{"s5", "[", "v", "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5375807547496643`*^9, 3.5375809546462297`*^9}, {
   3.5375810316510153`*^9, 3.5375810327382927`*^9}, 3.537581219874021*^9, {
   3.537581535999511*^9, 3.537581540295803*^9}, {3.537581711272689*^9, 
   3.537581738881206*^9}, 3.537582147695653*^9, {3.537582192382326*^9, 
   3.5375821924540586`*^9}, {3.5443435559395933`*^9, 
   3.5443435621541433`*^9}, {3.5443448850414677`*^9, 3.544344922769004*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq4", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq5", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Const3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5375809932541857`*^9, 3.537581041069994*^9}, {
  3.5375810809508543`*^9, 3.537581091428672*^9}, {3.537581792470584*^9, 
  3.53758183798702*^9}, {3.5443449419877253`*^9, 3.544344942251436*^9}, {
  3.5443450068491707`*^9, 3.54434500793615*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"f3", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", "m", " ", 
      RowBox[{"h2", "[", "v", "]"}]}], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], "2"], "+", 
     RowBox[{
      SuperscriptBox["f2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {-$CellContext`f3[$CellContext`v] + 
    2 $CellContext`m $CellContext`h2[$CellContext`v] + 
    Rational[1, 2] $CellContext`\[Sigma][$CellContext`v]^3 + 
    Derivative[1][$CellContext`f2][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.5443538040192327`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "m", " ", 
      RowBox[{"f2", "[", "v", "]"}]}], "-", 
     RowBox[{"h3", "[", "v", "]"}], "-", 
     RowBox[{
      RowBox[{"a1", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["h2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-2) $CellContext`m $CellContext`f2[$CellContext`v] - \
$CellContext`h3[$CellContext`v] - $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    Derivative[1][$CellContext`h2][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.544353804021186*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     RowBox[{"8", " ", "m", " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["a1", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   4 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] + 
    8 $CellContext`m $CellContext`\[Sigma][$CellContext`v]^2 + 
    Derivative[1][$CellContext`a1][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.544353804022717*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"6", " ", 
      RowBox[{"s3", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   6 $CellContext`s3[$CellContext`v] + 
    2 $CellContext`f2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]}, \
-1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.544353804024211*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"24", " ", 
      RowBox[{"s3", "[", "v", "]"}]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   24 $CellContext`s3[$CellContext`v] + 
    8 $CellContext`f2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]}, \
-1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.544353804025869*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"6", " ", 
      RowBox[{"s3", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   6 $CellContext`s3[$CellContext`v] + 
    2 $CellContext`f2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]}, \
-1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.5443538040274487`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"a2", "[", "v", "]"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   2 $CellContext`a2[$CellContext`v] + 
    4 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]}, 
   0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.5443538040290318`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"6", " ", 
      RowBox[{"s3", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   6 $CellContext`s3[$CellContext`v] + 
    2 $CellContext`f2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]}, \
-1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869616916765*^9, 3.544343564642758*^9, {3.544344890812173*^9, 
   3.544344943758316*^9}, 3.544345008639428*^9, 3.54435366765305*^9, 
   3.5443538040305862`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"repl1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"a2", "[", "v", "]"}], ",", 
        RowBox[{"f3", "[", "v", "]"}], ",", 
        RowBox[{"h3", "[", "v", "]"}], ",", 
        RowBox[{"s3", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537581094869306*^9, 3.5375811411847267`*^9}, {
  3.537581846545319*^9, 3.5375818604809847`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a1", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h2", "[", "v", "]"}], "+", 
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"a2", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"h2", "[", "v", "]"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"f3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", "m", " ", 
      RowBox[{"h2", "[", "v", "]"}]}], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], "2"], "+", 
     RowBox[{
      SuperscriptBox["f2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"h3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "m", " ", 
      RowBox[{"f2", "[", "v", "]"}]}], "-", 
     RowBox[{
      RowBox[{"a1", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["h2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"s3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "3"]}], " ", 
     RowBox[{"f2", "[", "v", "]"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.543869623767411*^9, 3.5443435671485567`*^9, {3.544344892724921*^9, 
   3.5443449446413383`*^9}, 3.544345010016996*^9, 3.5443538049548693`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"repl", "=", 
    RowBox[{"Join", "[", " ", 
     RowBox[{"repl1", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl1", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq5", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Const3", "/.", "repl"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537581149514593*^9, 3.5375811704734163`*^9}, {
  3.537581319335538*^9, 3.537581326214385*^9}, {3.53758187837607*^9, 
  3.5375818960440483`*^9}, {3.544345016120763*^9, 3.544345020407825*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "8"}], " ", 
       SuperscriptBox["m", "2"], " ", 
       RowBox[{"f2", "[", "v", "]"}]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{"f4", "[", "v", "]"}]}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "-", 
      RowBox[{"4", " ", "m", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
      RowBox[{
       FractionBox["5", "2"], " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"8", " ", "m", " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-8) $CellContext`m^2 $CellContext`f2[$CellContext`v] - 
    3 $CellContext`f4[$CellContext`v] + 
    3 $CellContext`a1[$CellContext`v] $CellContext`h2[$CellContext`v] - 
    4 $CellContext`m $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    Rational[-1, 
       2] $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    Rational[5, 
       2] $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
    8 $CellContext`m Derivative[1][$CellContext`h2][$CellContext`v] + 
    2 $CellContext`\[Sigma][$CellContext`v]^2 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
    2 Derivative[2][$CellContext`f2][$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353805866143*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"f2", "[", "v", "]"}]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["m", "2"], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{"h4", "[", "v", "]"}]}], "+", 
      RowBox[{
       FractionBox["11", "2"], " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"m", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a1", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"8", " ", "m", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-3) $CellContext`a1[$CellContext`v] $CellContext`f2[$CellContext`v] - 
    8 $CellContext`m^2 $CellContext`h2[$CellContext`v] - 
    3 $CellContext`h4[$CellContext`v] + 
    Rational[11, 
       2] $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - $CellContext`m \
$CellContext`\[Sigma][$CellContext`v]^3 - 
    2 $CellContext`\[Sigma][$CellContext`v] 
    Derivative[1][$CellContext`a1][$CellContext`v] - 8 $CellContext`m 
    Derivative[1][$CellContext`f2][$CellContext`v] - 
    2 $CellContext`a1[$CellContext`v] 
    Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
    2 Derivative[2][$CellContext`h2][$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353805916149*^9}],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "z", "]"}], "2"],
  SeriesData[$CellContext`z, 0, {}, 2, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353805963043*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "8"]}], " ", 
      SuperscriptBox[
       RowBox[{"a1", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"9", " ", 
         SuperscriptBox[
          RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox[
          RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"48", " ", 
         RowBox[{"s4", "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"t4", "[", "v", "]"}]}], "+", 
        RowBox[{"30", " ", "m", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "+", 
        RowBox[{"13", " ", 
         RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"f2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Sigma]", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ")"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[-1, 8] $CellContext`a1[$CellContext`v]^2 + 
    Rational[1, 6] (9 $CellContext`f2[$CellContext`v]^2 + 
      9 $CellContext`h2[$CellContext`v]^2 + 
      48 $CellContext`s4[$CellContext`v] + 3 $CellContext`t4[$CellContext`v] + 
      30 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
      6 $CellContext`\[Sigma][$CellContext`v]^4 + 
      13 $CellContext`\[Sigma][$CellContext`v] 
       Derivative[1][$CellContext`f2][$CellContext`v] - 
      2 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v])}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353806022991*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"a1", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"40", " ", 
      RowBox[{"s4", "[", "v", "]"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"t4", "[", "v", "]"}]}], "+", 
     RowBox[{"28", " ", "m", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     FractionBox[
      RowBox[{"21", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "4"], "+", 
     RowBox[{
      FractionBox["34", "3"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f2", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "-", 
     RowBox[{
      FractionBox["8", "3"], " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {-$CellContext`a1[$CellContext`v]^2 + 
    8 $CellContext`f2[$CellContext`v]^2 + 8 $CellContext`h2[$CellContext`v]^2 + 
    40 $CellContext`s4[$CellContext`v] + 4 $CellContext`t4[$CellContext`v] + 
    28 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    Rational[21, 4] $CellContext`\[Sigma][$CellContext`v]^4 + 
    Rational[34, 3] $CellContext`\[Sigma][$CellContext`v] 
     Derivative[1][$CellContext`f2][$CellContext`v] + 
    Rational[-8, 3] $CellContext`f2[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353806025443*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"12", " ", 
      RowBox[{"s4", "[", "v", "]"}]}], "+", 
     RowBox[{"6", " ", "m", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     FractionBox[
      RowBox[{"11", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "8"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f2", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   2 $CellContext`f2[$CellContext`v]^2 + 2 $CellContext`h2[$CellContext`v]^2 + 
    12 $CellContext`s4[$CellContext`v] + 
    6 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    Rational[11, 8] $CellContext`\[Sigma][$CellContext`v]^4 + 
    3 $CellContext`\[Sigma][$CellContext`v] 
     Derivative[1][$CellContext`f2][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353806063129*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       RowBox[{"a3", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", "m", " ", 
          RowBox[{"f2", "[", "v", "]"}]}], "-", 
         RowBox[{"9", " ", 
          RowBox[{"a1", "[", "v", "]"}], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{
           SuperscriptBox["h2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ")"}], 
    " ", "z"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   6 $CellContext`a3[$CellContext`v] + $CellContext`\[Sigma][$CellContext`v] \
((-16) $CellContext`m $CellContext`f2[$CellContext`v] - 
      9 $CellContext`a1[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] + 
      8 Derivative[1][$CellContext`h2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.5443538060647697`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "8"]}], " ", 
      SuperscriptBox[
       RowBox[{"a1", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"9", " ", 
         SuperscriptBox[
          RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox[
          RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"48", " ", 
         RowBox[{"s4", "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"t4", "[", "v", "]"}]}], "+", 
        RowBox[{"36", " ", "m", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "+", 
        RowBox[{"16", " ", 
         RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{
          SuperscriptBox["t3", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"f2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Sigma]", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ")"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[-1, 8] $CellContext`a1[$CellContext`v]^2 + 
    Rational[1, 6] (9 $CellContext`f2[$CellContext`v]^2 + 
      9 $CellContext`h2[$CellContext`v]^2 + 
      48 $CellContext`s4[$CellContext`v] + 3 $CellContext`t4[$CellContext`v] + 
      36 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
      12 $CellContext`m^2 $CellContext`\[Sigma][$CellContext`v]^2 + 
      6 $CellContext`\[Sigma][$CellContext`v]^4 + 
      16 $CellContext`\[Sigma][$CellContext`v] 
       Derivative[1][$CellContext`f2][$CellContext`v] + 
      3 Derivative[1][$CellContext`t3][$CellContext`v] - 
      2 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 
      3 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`\[Sigma]][$CellContext`v])}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9, 3.544343572916881*^9, 
  3.544345021452962*^9, 3.544353806217676*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"repl2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"t3", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"a3", "[", "v", "]"}], ",", 
        RowBox[{"t4", "[", "v", "]"}], ",", 
        RowBox[{"s4", "[", "v", "]"}], ",", 
        RowBox[{"h4", "[", "v", "]"}], ",", 
        RowBox[{"f4", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537581176657216*^9, 3.537581176712451*^9}, {
  3.537581208479423*^9, 3.5375812350544767`*^9}, {3.537581285831032*^9, 
  3.537581335172854*^9}, {3.537581579672551*^9, 3.537581582928306*^9}, {
  3.537581907656845*^9, 3.537581928696844*^9}, {3.53758196021669*^9, 
  3.537581962015414*^9}, {3.537582000083522*^9, 3.537582009971553*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t3", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"h2", "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["m", "2"], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], "-", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"a3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"16", " ", "m", " ", 
        RowBox[{"f2", "[", "v", "]"}]}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"t4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"a1", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"12", " ", "m", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], "+", 
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"s4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "96"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox[
         RowBox[{"f2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox[
         RowBox[{"h2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"48", " ", "m", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
       RowBox[{"11", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"h4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["m", "2"]}], "+", 
          RowBox[{"11", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"f2", "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["a1", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", "m", " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"f4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"t3", "[", "v", "]"}]}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           RowBox[{"h2", "[", "v", "]"}]}], "-", 
          RowBox[{"8", " ", "m", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["m", "2"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "+", 
       RowBox[{"16", " ", "m", " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.543869626109274*^9, 3.544343576234599*^9, 
  3.544345024854578*^9, 3.544353806667728*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"repl", "=", 
    RowBox[{"Join", "[", " ", 
     RowBox[{"repl1", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl1", ",", "v"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl1", ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", "repl2", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl2", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq5", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Const3", "//.", "repl"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537581149514593*^9, 3.5375811704734163`*^9}, {
  3.537581319335538*^9, 3.537581326214385*^9}, {3.53758187837607*^9, 
  3.5375818960440483`*^9}, {3.537582027350095*^9, 3.537582048852798*^9}, {
  3.537582117159115*^9, 3.537582123535061*^9}, {3.544345027969656*^9, 
  3.544345029256832*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["21", "4"]}], " ", 
       SuperscriptBox[
        RowBox[{"a1", "[", "v", "]"}], "2"], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"8", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "m", " ", 
          RowBox[{"f2", "[", "v", "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], "+", 
         RowBox[{"m", " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "12"}], " ", 
          RowBox[{"f5", "[", "v", "]"}]}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["m", "3"], " ", 
          RowBox[{"h2", "[", "v", "]"}]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"f2", "[", "v", "]"}], " ", 
          RowBox[{"t3", "[", "v", "]"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox[
           RowBox[{"f2", "[", "v", "]"}], "2"], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
         RowBox[{"38", " ", 
          SuperscriptBox[
           RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
         RowBox[{"58", " ", "m", " ", 
          RowBox[{"h2", "[", "v", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["m", "2"], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "5"]}], "-", 
         RowBox[{"48", " ", 
          SuperscriptBox["m", "2"], " ", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"13", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "-", 
         RowBox[{
          RowBox[{"t3", "[", "v", "]"}], " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"f2", "[", "v", "]"}], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}], "2"]}], "+", 
         RowBox[{"24", " ", "m", " ", 
          RowBox[{
           SuperscriptBox["h2", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{
           SuperscriptBox["f2", 
            TagBox[
             RowBox[{"(", "3", ")"}],
             Derivative],
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ")"}], 
    " ", 
    SuperscriptBox["z", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[-21, 
       4] $CellContext`a1[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] - 
    8 $CellContext`a1[$CellContext`v] (
     2 $CellContext`m $CellContext`f2[$CellContext`v] - Derivative[
     1][$CellContext`h2][$CellContext`v] + $CellContext`m 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v]) + 
    Rational[1, 2] ((-12) $CellContext`f5[$CellContext`v] - 
      32 $CellContext`m^3 $CellContext`h2[$CellContext`v] - 
      4 $CellContext`f2[$CellContext`v] $CellContext`t3[$CellContext`v] + 
      6 $CellContext`f2[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] - 
      38 $CellContext`h2[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] + 
      58 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
      128 $CellContext`m^2 $CellContext`\[Sigma][$CellContext`v]^3 + 
      4 $CellContext`\[Sigma][$CellContext`v]^5 - 48 $CellContext`m^2 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
      13 $CellContext`\[Sigma][$CellContext`v]^2 
       Derivative[
        1][$CellContext`f2][$CellContext`v] - $CellContext`t3[$CellContext`v] 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
      4 $CellContext`f2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
       Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
      8 $CellContext`\[Sigma][$CellContext`v] 
       Derivative[1][$CellContext`\[Sigma]][$CellContext`v]^2 + 
      24 $CellContext`m Derivative[2][$CellContext`h2][$CellContext`v] + 
      3 $CellContext`\[Sigma][$CellContext`v]^2 
       Derivative[2][$CellContext`\[Sigma]][$CellContext`v] + 
      4 Derivative[3][$CellContext`f2][$CellContext`v])}, 2, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.544353807609173*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       RowBox[{"h5", "[", "v", "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"t3", "[", "v", "]"}]}], "+", 
      RowBox[{"m", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["m", "3"]}], "+", 
         RowBox[{"11", " ", 
          RowBox[{"h2", "[", "v", "]"}], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
         RowBox[{"4", " ", "m", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox["m", "2"], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"34", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"57", " ", "m", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"12", " ", "m", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", "m", " ", 
          RowBox[{"h2", "[", "v", "]"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["m", "2"], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "-", 
         RowBox[{"8", " ", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["h2", 
         TagBox[
          RowBox[{"(", "3", ")"}],
          Derivative],
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", 
    SuperscriptBox["z", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-6) $CellContext`h5[$CellContext`v] - 
    2 $CellContext`h2[$CellContext`v] $CellContext`t3[$CellContext`v] + \
$CellContext`m $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    2 $CellContext`f2[$CellContext`v] (8 $CellContext`m^3 + 
      11 $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
      4 $CellContext`m $CellContext`\[Sigma][$CellContext`v]^2) - 
    24 $CellContext`m^2 Derivative[1][$CellContext`h2][$CellContext`v] + 
    20 $CellContext`\[Sigma][$CellContext`v]^2 
     Derivative[1][$CellContext`h2][$CellContext`v] + 
    34 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
    57 $CellContext`m $CellContext`\[Sigma][$CellContext`v]^2 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 12 $CellContext`m 
    Derivative[
     2][$CellContext`f2][$CellContext`v] + $CellContext`a1[$CellContext`v] \
((-16) $CellContext`m $CellContext`h2[$CellContext`v] + 
      8 $CellContext`m^2 $CellContext`\[Sigma][$CellContext`v] - 
      9 $CellContext`\[Sigma][$CellContext`v]^3 - 8 
      Derivative[1][$CellContext`f2][$CellContext`v] - 2 
      Derivative[2][$CellContext`\[Sigma]][$CellContext`v]) + 
    2 Derivative[3][$CellContext`h2][$CellContext`v]}, 2, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.544353807721243*^9}],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "z", "]"}], "3"],
  SeriesData[$CellContext`z, 0, {}, 3, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.544353807754524*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"60", " ", 
       RowBox[{"s5", "[", "v", "]"}]}], "+", 
      RowBox[{"6", " ", 
       RowBox[{"t5", "[", "v", "]"}]}], "-", 
      RowBox[{"48", " ", 
       SuperscriptBox["m", "2"], " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"24", " ", "m", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"19", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
      RowBox[{"20", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"20", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"42", " ", "m", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"6", " ", "m", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"9", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 6] (60 $CellContext`s5[$CellContext`v] + 
     6 $CellContext`t5[$CellContext`v] - 
     48 $CellContext`m^2 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] - 
     24 $CellContext`m $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - 
     3 $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
     19 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 + 
     20 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
     20 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     42 $CellContext`m $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] - 
     6 $CellContext`m $CellContext`h2[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     8 $CellContext`\[Sigma][$CellContext`v]^3 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 3 
     Derivative[1][$CellContext`f2][$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     9 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.5443538078774*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"180", " ", 
       RowBox[{"s5", "[", "v", "]"}]}], "+", 
      RowBox[{"30", " ", 
       RowBox[{"t5", "[", "v", "]"}]}], "-", 
      RowBox[{"176", " ", 
       SuperscriptBox["m", "2"], " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
      RowBox[{"12", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"88", " ", "m", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"11", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"61", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
      RowBox[{"64", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"64", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"146", " ", "m", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"30", " ", "m", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"15", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"29", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 3] (180 $CellContext`s5[$CellContext`v] + 
     30 $CellContext`t5[$CellContext`v] - 
     176 $CellContext`m^2 $CellContext`f2[$CellContext`v] $CellContext`\
\[Sigma][$CellContext`v] + 
     12 $CellContext`a1[$CellContext`v] $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] - 
     88 $CellContext`m $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - 
     11 $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
     61 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 + 
     64 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
     64 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     146 $CellContext`m $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] - 
     30 $CellContext`m $CellContext`h2[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     24 $CellContext`\[Sigma][$CellContext`v]^3 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 15 
     Derivative[1][$CellContext`f2][$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     29 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.544353807996064*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"60", " ", 
       RowBox[{"s5", "[", "v", "]"}]}], "-", 
      RowBox[{"6", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"16", " ", "m", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "32"}], " ", 
          SuperscriptBox["m", "2"], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
         RowBox[{"18", " ", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"32", " ", "m", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 3] (60 $CellContext`s5[$CellContext`v] - 
     6 $CellContext`a1[$CellContext`v] $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] - 
     16 $CellContext`m $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - 
     2 $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + $CellContext`f2[$CellContext`v] \
((-32) $CellContext`m^2 $CellContext`\[Sigma][$CellContext`v] + 
       17 $CellContext`\[Sigma][$CellContext`v]^3 + 
       18 Derivative[1][$CellContext`f2][$CellContext`v]) + 
     18 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     32 $CellContext`m $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     8 $CellContext`\[Sigma][$CellContext`v]^3 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     8 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.544353808047286*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "6"}], " ", 
        RowBox[{"a4", "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           RowBox[{"a1", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "m", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"14", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "-", 
          RowBox[{"15", " ", "m", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "+", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", "m", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"a1", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ")"}], 
     " ", 
     SuperscriptBox["z", "2"]}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-2) ((-6) $CellContext`a4[$CellContext`v] + 
     4 $CellContext`m $CellContext`f2[$CellContext`v]^2 + \
$CellContext`f2[$CellContext`v] (
       9 $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] - 2 
       Derivative[1][$CellContext`h2][$CellContext`v]) + 
     2 (2 $CellContext`m $CellContext`h2[$CellContext`v]^2 + 
       8 $CellContext`m^2 $CellContext`h2[$CellContext`v] $CellContext`\
\[Sigma][$CellContext`v] - 
       14 $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 - 
       15 $CellContext`m $CellContext`\[Sigma][$CellContext`v]^4 + \
$CellContext`h2[$CellContext`v] 
        Derivative[1][$CellContext`f2][$CellContext`v] + 
       8 $CellContext`m $CellContext`\[Sigma][$CellContext`v] 
        Derivative[1][$CellContext`f2][$CellContext`v] + 
       2 $CellContext`a1[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]
          Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 
       2 $CellContext`\[Sigma][$CellContext`v] 
       Derivative[2][$CellContext`h2][$CellContext`v]))}, 2, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.54435380808353*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"60", " ", 
       RowBox[{"s5", "[", "v", "]"}]}], "+", 
      RowBox[{"6", " ", 
       RowBox[{"t5", "[", "v", "]"}]}], "-", 
      RowBox[{"48", " ", 
       SuperscriptBox["m", "2"], " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"24", " ", "m", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"19", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
      RowBox[{"20", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"20", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"42", " ", "m", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"6", " ", "m", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"9", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 6] (60 $CellContext`s5[$CellContext`v] + 
     6 $CellContext`t5[$CellContext`v] - 
     48 $CellContext`m^2 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] - 
     24 $CellContext`m $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - 
     3 $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
     19 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 + 
     20 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
     20 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     42 $CellContext`m $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] - 
     6 $CellContext`m $CellContext`h2[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     8 $CellContext`\[Sigma][$CellContext`v]^3 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 3 
     Derivative[1][$CellContext`f2][$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     9 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9, 3.544343578085034*^9, 
  3.544345030798315*^9, 3.5443538084247847`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"repl3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a4", "[", "v", "]"}], ",", 
        RowBox[{"t5", "[", "v", "]"}], ",", 
        RowBox[{"s5", "[", "v", "]"}], ",", 
        RowBox[{"h5", "[", "v", "]"}], ",", 
        RowBox[{"f5", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537581176657216*^9, 3.537581176712451*^9}, {
  3.537581208479423*^9, 3.5375812350544767`*^9}, {3.537581285831032*^9, 
  3.537581335172854*^9}, {3.537581579672551*^9, 3.537581582928306*^9}, {
  3.537581907656845*^9, 3.537581928696844*^9}, {3.53758196021669*^9, 
  3.537581962015414*^9}, {3.537582000083522*^9, 3.537582009971553*^9}, {
  3.537582054866674*^9, 3.537582086618279*^9}, {3.5375821613248863`*^9, 
  3.5375822160917*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           RowBox[{"a1", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "m", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"8", " ", 
              SuperscriptBox["m", "2"], " ", 
              RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
             RowBox[{"14", " ", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
             RowBox[{
              SuperscriptBox["f2", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "15"}], " ", "m", " ", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
             RowBox[{"8", " ", "m", " ", 
              RowBox[{
               SuperscriptBox["f2", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"a1", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["\[Sigma]", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["h2", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"t5", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"t3", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "6"}], " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", "m", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], "-", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"10", " ", "m", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"6", " ", "m", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"s5", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "60"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"32", " ", 
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"17", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "-", 
          RowBox[{"18", " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"t3", "[", "v", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{
           RowBox[{"a1", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              RowBox[{"h2", "[", "v", "]"}]}], "+", 
             RowBox[{"8", " ", "m", " ", 
              RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "-", 
          RowBox[{"9", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"16", " ", "m", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"h5", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"t3", "[", "v", "]"}]}], "+", 
       RowBox[{"m", " ", 
        RowBox[{"t3", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["m", "3"]}], "+", 
          RowBox[{"11", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", "m", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
       RowBox[{"24", " ", 
        SuperscriptBox["m", "2"], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"20", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"34", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"57", " ", "m", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"12", " ", "m", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", "m", " ", 
           RowBox[{"h2", "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"9", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "-", 
          RowBox[{"8", " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["h2", 
          TagBox[
           RowBox[{"(", "3", ")"}],
           Derivative],
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"f5", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "21"}], " ", 
        SuperscriptBox[
         RowBox[{"a1", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
       RowBox[{"32", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "m", " ", 
           RowBox[{"f2", "[", "v", "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["h2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}], "+", 
          RowBox[{"m", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{"t3", "[", "v", "]"}]}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox[
            RowBox[{"f2", "[", "v", "]"}], "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"38", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["m", "2"], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "5"]}], "+", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "32"}], " ", 
              SuperscriptBox["m", "3"]}], "+", 
             RowBox[{"58", " ", "m", " ", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox["m", "2"], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"13", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{
           RowBox[{"t3", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["\[Sigma]", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"24", " ", "m", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["f2", 
             TagBox[
              RowBox[{"(", "3", ")"}],
              Derivative],
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.543869628925858*^9, 3.544343582081397*^9, 
  3.544345033702104*^9, 3.544353808639522*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["repl1"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a1", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h2", "[", "v", "]"}], "+", 
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"a2", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"h2", "[", "v", "]"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"f3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", "m", " ", 
      RowBox[{"h2", "[", "v", "]"}]}], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], "2"], "+", 
     RowBox[{
      SuperscriptBox["f2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"h3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "m", " ", 
      RowBox[{"f2", "[", "v", "]"}]}], "-", 
     RowBox[{
      RowBox[{"a1", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["h2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"s3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "3"]}], " ", 
     RowBox[{"f2", "[", "v", "]"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5443435880758*^9, 3.5443435947842493`*^9}, 
   3.5443450350999317`*^9, 3.5443538095138283`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["repl2"], "Input",
 CellChangeTimes->{{3.543869819536687*^9, 3.543869819687505*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t3", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"h2", "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["m", "2"], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], "-", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"a3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"16", " ", "m", " ", 
        RowBox[{"f2", "[", "v", "]"}]}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"t4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"a1", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"12", " ", "m", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], "+", 
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"s4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "96"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox[
         RowBox[{"f2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox[
         RowBox[{"h2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"48", " ", "m", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
       RowBox[{"11", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"h4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["m", "2"]}], "+", 
          RowBox[{"11", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"f2", "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["a1", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", "m", " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"f4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"t3", "[", "v", "]"}]}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           RowBox[{"h2", "[", "v", "]"}]}], "-", 
          RowBox[{"8", " ", "m", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["m", "2"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "+", 
       RowBox[{"16", " ", "m", " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5438698201278677`*^9, 3.543869829239614*^9}, 
   3.5443436947368526`*^9, 3.5443450562457457`*^9, 3.544353810348523*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"bceq2", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "+", 
    RowBox[{"2", "m", " ", 
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{"2", "z", " ", "m", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}]}], "-", 
    RowBox[{"z", " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}]}], "-", " ", 
    RowBox[{"z", " ", 
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "2"}], "}"}]}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.537583454390378*^9, 3.537583584316988*^9}, {
  3.537583627792901*^9, 3.5375836286954517`*^9}, {3.53758367467208*^9, 
  3.537583682998909*^9}, {3.537583741939487*^9, 3.53758374254697*^9}, {
  3.537583789908886*^9, 3.53758380650729*^9}, {3.537583864503531*^9, 
  3.53758392754637*^9}, {3.537584157247345*^9, 3.5375841601333523`*^9}, {
  3.543869890921344*^9, 3.54386989227345*^9}, {3.544343698791573*^9, 
  3.544343703070735*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"bceq2", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "+", 
    RowBox[{"2", " ", "m", " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{"2", "z", " ", "m", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}]}], "-", 
    RowBox[{"z", " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{
      RowBox[{"\[Sigma]", "''"}], "[", "v", "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.537584449977281*^9, 3.537584540147512*^9}, {
  3.543869873209931*^9, 3.5438698836492434`*^9}, {3.544343706622446*^9, 
  3.544343710981886*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"bceq2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5375835627555237`*^9, 3.537583563483652*^9}, {
  3.5375837293866577`*^9, 3.537583730810493*^9}, {3.5375839307205544`*^9, 
  3.537583938135961*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "m", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["t3", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], "+", 
      RowBox[{
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["f2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}], "-", 
         RowBox[{
          SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], ")"}], " ",
     "z"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   2 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    4 $CellContext`m^2 $CellContext`\[Sigma][$CellContext`v]^2 + 
    Derivative[
     1][$CellContext`t3][$CellContext`v] + \
$CellContext`\[Sigma][$CellContext`v] (
      Derivative[1][$CellContext`f2][$CellContext`v] - Derivative[
      2][$CellContext`\[Sigma]][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869801272677*^9, {3.543869874772071*^9, 3.5438698971663313`*^9}, 
   3.544343716440422*^9, 3.544345059532452*^9, 3.544353812989098*^9, 
   3.544353989933282*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"tmp", "/.", "repl2"}], "]"}]], "Input",
 CellChangeTimes->{{3.537583943735824*^9, 3.537583946472803*^9}}],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "z", "]"}], "2"],
  SeriesData[$CellContext`z, 0, {}, 2, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869802865644*^9, {3.5438698763090973`*^9, 3.54386989771704*^9}, 
   3.544343717156042*^9, 3.544345060433576*^9, 3.544353813604308*^9, 
   3.544353990984666*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"bceq3", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], ",", "z"}], "]"}],
     "+", 
    RowBox[{"2", " ", "m", " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], "+", 
       RowBox[{"2", " ", "m", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], ",", "z"}], 
      "]"}]}], "-", " ", 
    RowBox[{
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{
      RowBox[{"\[Sigma]", "''"}], "[", "v", "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.537584449977281*^9, 3.537584540147512*^9}, {
  3.543869873209931*^9, 3.5438698836492434`*^9}, {3.544343706622446*^9, 
  3.544343710981886*^9}, {3.544354008523074*^9, 3.544354014667173*^9}, {
  3.5443540602132998`*^9, 3.54435410108786*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"bceq3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5375835627555237`*^9, 3.537583563483652*^9}, {
   3.5375837293866577`*^9, 3.537583730810493*^9}, {3.5375839307205544`*^9, 
   3.537583938135961*^9}, {3.544354018849914*^9, 3.544354018937799*^9}, 
   3.544354077853743*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "m", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["m", "2"], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["t3", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}], "+", 
     RowBox[{
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}], "-", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   2 $CellContext`m $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    4 $CellContext`m^2 $CellContext`\[Sigma][$CellContext`v]^2 + 
    Derivative[
     1][$CellContext`t3][$CellContext`v] + \
$CellContext`\[Sigma][$CellContext`v] (
      Derivative[1][$CellContext`f2][$CellContext`v] - Derivative[
      2][$CellContext`\[Sigma]][$CellContext`v])}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869801272677*^9, {3.543869874772071*^9, 3.5438698971663313`*^9}, 
   3.544343716440422*^9, 3.544345059532452*^9, 3.544353812989098*^9, {
   3.544353989933282*^9, 3.544354019361783*^9}, {3.5443540496198053`*^9, 
   3.544354115366165*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"tmp", "/.", "repl2"}], "]"}]], "Input",
 CellChangeTimes->{{3.537583943735824*^9, 3.537583946472803*^9}}],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "z", "]"}], "1"],
  SeriesData[$CellContext`z, 0, {}, 1, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869802865644*^9, {3.5438698763090973`*^9, 3.54386989771704*^9}, 
   3.544343717156042*^9, 3.544345060433576*^9, 3.544353813604308*^9, 
   3.544353990984666*^9, {3.5443540504351807`*^9, 3.54435408197134*^9}, 
   3.544354115928938*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bceq3", "=", 
  RowBox[{"s", "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544353818900803*^9, 3.54435383359417*^9}, 
   3.544353892208263*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", " ", 
   RowBox[{"s3", "[", "v", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["z", "2"], " ", 
   RowBox[{"s4", "[", "v", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["z", "3"], " ", 
   RowBox[{"s5", "[", "v", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.5443538251273537`*^9, 3.5443538385208263`*^9}, 
   3.5443538927617197`*^9, 3.5443539916370687`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "/.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544353836050331*^9, 3.544353836106229*^9}, {
  3.544353913065431*^9, 3.54435393167244*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"f2", "[", "v", "]"}], " ", "z"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
    $CellContext`f2[$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5443538365595417`*^9, 3.544353839104684*^9}, {
   3.544353894430208*^9, 3.5443539319532423`*^9}, 3.544353992187447*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"h", "[", 
      RowBox[{"v", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "/.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544353836050331*^9, 3.544353836106229*^9}, {
  3.544353913065431*^9, 3.544353935519349*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"h2", "[", "v", "]"}], " ", "z"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
    $CellContext`h2[$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5443538365595417`*^9, 3.544353839104684*^9}, {
   3.544353894430208*^9, 3.5443539358618803`*^9}, 3.544353992758082*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"v", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "/.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544353836050331*^9, 3.544353836106229*^9}, {
  3.544353913065431*^9, 3.544353940127337*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"a1", "[", "v", "]"}], " ", "z"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
    $CellContext`a1[$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5443538365595417`*^9, 3.544353839104684*^9}, {
   3.544353894430208*^9, 3.54435394049443*^9}, 3.5443539933058567`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"s", "[", 
      RowBox[{"v", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "/.", "repl"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.544353836050331*^9, 3.544353836106229*^9}, {
  3.544353913065431*^9, 3.544353922391581*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], ")"}], " ", "z"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[-1, 
      3] $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.5443538365595417`*^9, 3.544353839104684*^9}, {
   3.544353894430208*^9, 3.544353943525366*^9}, 3.544353993840127*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1045, 924},
WindowMargins->{{214, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "calcgeom"->{
  Cell[38661, 1064, 306, 9, 73, "Input",
   CellTags->"calcgeom"],
  Cell[38970, 1075, 293, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[39266, 1087, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[39533, 1098, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[39800, 1109, 3551, 100, 139, "Input",
   CellTags->"calcgeom"],
  Cell[43354, 1211, 155, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[43716, 1223, 5599, 153, 178, "Input",
   CellTags->"calcgeom"],
  Cell[49318, 1378, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[49463, 1384, 1615, 48, 88, "Input",
   CellTags->"calcgeom"],
  Cell[51081, 1434, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[51226, 1440, 633, 22, 27, "Input",
   CellTags->"calcgeom"],
  Cell[51862, 1464, 1648, 51, 113, "Input",
   CellTags->"calcgeom"],
  Cell[53513, 1517, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[53658, 1523, 145, 4, 27, "Input",
   CellTags->"calcgeom"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"calcgeom", 598655, 17563}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 823, 12, 46, "Subtitle"],
Cell[CellGroupData[{
Cell[1427, 38, 68, 1, 27, "Input"],
Cell[1498, 41, 197, 3, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1732, 49, 111, 1, 26, "Subsubtitle"],
Cell[1846, 52, 95, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[1966, 58, 279, 8, 58, "Input"],
Cell[2248, 68, 303, 7, 70, "Output"],
Cell[2554, 77, 701, 18, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3292, 100, 266, 9, 58, "Input"],
Cell[3561, 111, 190, 3, 70, "Output"],
Cell[3754, 116, 192, 3, 70, "Output"]
}, Open  ]],
Cell[3961, 122, 407, 13, 27, "Input"],
Cell[4371, 137, 37, 0, 27, "Input"],
Cell[CellGroupData[{
Cell[4433, 141, 257, 8, 58, "Input"],
Cell[4693, 151, 277, 6, 70, "Output"],
Cell[4973, 159, 187, 3, 70, "Output"]
}, Open  ]],
Cell[5175, 165, 2020, 62, 103, "Input"],
Cell[7198, 229, 26, 0, 27, "Input"],
Cell[7227, 231, 841, 25, 43, "Input"],
Cell[8071, 258, 1026, 31, 58, "Input"],
Cell[9100, 291, 227, 8, 86, "Text"],
Cell[9330, 301, 4015, 95, 238, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[13382, 401, 111, 3, 26, "Subsubtitle"],
Cell[13496, 406, 128, 4, 26, "Text"],
Cell[13627, 412, 6139, 139, 718, "Input"],
Cell[19769, 553, 68, 1, 26, "Text"],
Cell[19840, 556, 3727, 84, 523, "Input"],
Cell[23570, 642, 824, 18, 208, "Input"],
Cell[24397, 662, 4051, 89, 583, "Input"],
Cell[28451, 753, 99, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[28587, 760, 34, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[28646, 764, 3220, 66, 173, "Input"],
Cell[31869, 832, 1344, 42, 50, "Output"],
Cell[33216, 876, 256, 5, 27, "Output"],
Cell[33475, 883, 190, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33702, 891, 28, 0, 27, "Input"],
Cell[33733, 893, 1343, 42, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35113, 940, 28, 0, 27, "Input"],
Cell[35144, 942, 2616, 84, 98, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37797, 1031, 119, 3, 27, "Input"],
Cell[37919, 1036, 658, 20, 52, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38626, 1062, 32, 0, 26, "Subsubtitle"],
Cell[38661, 1064, 306, 9, 73, "Input",
 CellTags->"calcgeom"],
Cell[38970, 1075, 293, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[39266, 1087, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[39533, 1098, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[39800, 1109, 3551, 100, 139, "Input",
 CellTags->"calcgeom"],
Cell[43354, 1211, 155, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[43512, 1217, 201, 4, 27, "Input"],
Cell[43716, 1223, 5599, 153, 178, "Input",
 CellTags->"calcgeom"],
Cell[49318, 1378, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[49463, 1384, 1615, 48, 88, "Input",
 CellTags->"calcgeom"],
Cell[51081, 1434, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[51226, 1440, 633, 22, 27, "Input",
 CellTags->"calcgeom"],
Cell[51862, 1464, 1648, 51, 113, "Input",
 CellTags->"calcgeom"],
Cell[53513, 1517, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[53658, 1523, 145, 4, 27, "Input",
 CellTags->"calcgeom"]
}, Closed]],
Cell[CellGroupData[{
Cell[53840, 1532, 41, 0, 26, "Subsubtitle"],
Cell[53884, 1534, 173, 4, 27, "Input"],
Cell[54060, 1540, 645, 21, 27, "Input"],
Cell[54708, 1563, 1146, 34, 118, "Input"],
Cell[55857, 1599, 1792, 51, 118, "Input"],
Cell[57652, 1652, 710, 23, 58, "Input"],
Cell[58365, 1677, 3455, 96, 238, "Input"],
Cell[61823, 1775, 388, 12, 27, "Input"],
Cell[62214, 1789, 434, 10, 27, "Input"],
Cell[62651, 1801, 508, 12, 46, "Input"],
Cell[63162, 1815, 4135, 133, 141, "Input"],
Cell[67300, 1950, 6843, 214, 199, "Input"],
Cell[74146, 2166, 237, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[74408, 2175, 3999, 129, 141, "Input"],
Cell[78410, 2306, 243, 5, 27, "Output"],
Cell[78656, 2313, 243, 5, 27, "Output"],
Cell[78902, 2320, 243, 5, 27, "Output"],
Cell[79148, 2327, 245, 5, 27, "Output"]
}, Open  ]],
Cell[79408, 2335, 1262, 33, 148, "Input"],
Cell[80673, 2370, 1027, 21, 58, "Input"],
Cell[81703, 2393, 677, 17, 58, "Input"],
Cell[82383, 2412, 1027, 30, 118, "Input"],
Cell[83413, 2444, 161, 3, 27, "Input"],
Cell[83577, 2449, 745, 18, 88, "Input"],
Cell[CellGroupData[{
Cell[84347, 2471, 1146, 32, 238, "Input"],
Cell[85496, 2505, 6528, 191, 110, "Output"],
Cell[92027, 2698, 6245, 189, 110, "Output"],
Cell[98275, 2889, 2295, 75, 77, "Output"],
Cell[100573, 2966, 3773, 118, 87, "Output"],
Cell[104349, 3086, 5272, 166, 110, "Output"],
Cell[109624, 3254, 11984, 360, 170, "Output"],
Cell[121611, 3616, 1527, 51, 77, "Output"],
Cell[123141, 3669, 7146, 218, 127, "Output"]
}, Open  ]],
Cell[130302, 3890, 2631, 55, 169, "Input"],
Cell[CellGroupData[{
Cell[132958, 3949, 975, 25, 238, "Input"],
Cell[133936, 3976, 187, 3, 27, "Output"],
Cell[134126, 3981, 187, 3, 27, "Output"],
Cell[134316, 3986, 187, 3, 27, "Output"],
Cell[134506, 3991, 189, 3, 27, "Output"],
Cell[134698, 3996, 189, 3, 27, "Output"],
Cell[134890, 4001, 187, 3, 27, "Output"],
Cell[135080, 4006, 187, 3, 27, "Output"],
Cell[135270, 4011, 187, 3, 27, "Output"]
}, Open  ]],
Cell[135472, 4017, 292, 6, 27, "Input"],
Cell[135767, 4025, 177, 3, 27, "Input"],
Cell[135947, 4030, 3811, 88, 188, "Input"],
Cell[CellGroupData[{
Cell[139783, 4122, 2571, 72, 87, "Input"],
Cell[142357, 4196, 54934, 1589, 1328, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197328, 5790, 1938, 54, 33, "Input"],
Cell[199269, 5846, 12383, 323, 223, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[211689, 6174, 1074, 32, 88, "Input"],
Cell[212766, 6208, 143, 2, 27, "Output"],
Cell[212912, 6212, 145, 2, 27, "Output"],
Cell[213060, 6216, 149, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[213246, 6223, 1910, 67, 105, "Input"],
Cell[215159, 6292, 3155, 100, 100, "Output"],
Cell[218317, 6394, 5256, 166, 92, "Output"],
Cell[223576, 6562, 173554, 5386, 1836, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[397167, 11953, 3193, 113, 177, "Input"],
Cell[400363, 12068, 10945, 318, 244, "Output"],
Cell[411311, 12388, 9846, 287, 224, "Output"],
Cell[421160, 12677, 10842, 320, 155, "Output"],
Cell[432005, 12999, 9856, 294, 312, "Output"],
Cell[441864, 13295, 15880, 524, 425, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[457781, 13824, 2263, 68, 118, "Input"],
Cell[460047, 13894, 1544, 53, 33, "Output"]
}, Open  ]],
Cell[461606, 13950, 1249, 28, 27, "Input"],
Cell[CellGroupData[{
Cell[462880, 13982, 639, 13, 27, "Input"],
Cell[463522, 13997, 776, 11, 88, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[464335, 14013, 362, 9, 27, "Input"],
Cell[464700, 14024, 730, 10, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[465467, 14039, 364, 9, 27, "Input"],
Cell[465834, 14050, 850, 12, 88, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[466721, 14067, 364, 9, 27, "Input"],
Cell[467088, 14078, 827, 11, 103, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[467952, 14094, 364, 9, 27, "Input"],
Cell[468319, 14105, 1383, 19, 148, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[469739, 14129, 687, 13, 27, "Input"],
Cell[470429, 14144, 357, 5, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[470823, 14154, 366, 9, 27, "Input"],
Cell[471192, 14165, 351, 5, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[471580, 14175, 364, 9, 27, "Input"],
Cell[471947, 14186, 12214, 182, 1558, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[484198, 14373, 358, 9, 27, "Input"],
Cell[484559, 14384, 735, 10, 103, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[485331, 14399, 873, 15, 58, "Input"],
Cell[486207, 14416, 265, 3, 27, "Output"]
}, Open  ]],
Cell[486487, 14422, 2939, 91, 148, "Input"],
Cell[CellGroupData[{
Cell[489451, 14517, 2374, 70, 238, "Input"],
Cell[491828, 14589, 1065, 29, 52, "Output"],
Cell[492896, 14620, 1080, 29, 30, "Output"],
Cell[493979, 14651, 1035, 27, 33, "Output"],
Cell[495017, 14680, 806, 23, 46, "Output"],
Cell[495826, 14705, 808, 23, 46, "Output"],
Cell[496637, 14730, 808, 23, 46, "Output"],
Cell[497448, 14755, 810, 23, 30, "Output"],
Cell[498261, 14780, 808, 23, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[499106, 14808, 800, 21, 27, "Input"],
Cell[499909, 14831, 1795, 53, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[501741, 14889, 2717, 81, 268, "Input"],
Cell[504461, 14972, 2471, 65, 46, "Output"],
Cell[506935, 15039, 2408, 63, 46, "Output"],
Cell[509346, 15104, 280, 7, 30, "Output"],
Cell[509629, 15113, 2291, 60, 47, "Output"],
Cell[511923, 15175, 2127, 55, 52, "Output"],
Cell[514053, 15232, 1519, 40, 52, "Output"],
Cell[515575, 15274, 1317, 35, 30, "Output"],
Cell[516895, 15311, 3048, 77, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[519980, 15393, 1081, 25, 27, "Input"],
Cell[521064, 15420, 6533, 187, 192, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[527634, 15612, 3044, 89, 268, "Input"],
Cell[530681, 15703, 5900, 143, 114, "Output"],
Cell[536584, 15848, 4614, 114, 53, "Output"],
Cell[541201, 15964, 278, 7, 30, "Output"],
Cell[541482, 15973, 3948, 98, 69, "Output"],
Cell[545433, 16073, 4249, 104, 69, "Output"],
Cell[549685, 16179, 3381, 84, 69, "Output"],
Cell[553069, 16265, 3775, 92, 53, "Output"],
Cell[556847, 16359, 3952, 98, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[560836, 16462, 1109, 25, 27, "Input"],
Cell[561948, 16489, 13739, 365, 301, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[575724, 16859, 31, 0, 27, "Input"],
Cell[575758, 16861, 1746, 52, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[577541, 16918, 97, 1, 27, "Input"],
Cell[577641, 16921, 6564, 187, 192, "Output"]
}, Open  ]],
Cell[584220, 17111, 1750, 49, 27, "Input"],
Cell[585973, 17162, 986, 28, 27, "Input"],
Cell[CellGroupData[{
Cell[586984, 17194, 382, 9, 27, "Input"],
Cell[587369, 17205, 1672, 45, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[589078, 17255, 157, 3, 27, "Input"],
Cell[589238, 17260, 355, 9, 30, "Output"]
}, Open  ]],
Cell[589608, 17272, 1280, 37, 27, "Input"],
Cell[CellGroupData[{
Cell[590913, 17313, 456, 10, 27, "Input"],
Cell[591372, 17325, 1697, 44, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[593106, 17374, 157, 3, 27, "Input"],
Cell[593266, 17379, 428, 10, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[593731, 17394, 196, 5, 27, "Input"],
Cell[593930, 17401, 391, 11, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[594358, 17417, 385, 11, 27, "Input"],
Cell[594746, 17430, 519, 14, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[595302, 17449, 386, 11, 27, "Input"],
Cell[595691, 17462, 519, 14, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[596247, 17481, 386, 11, 27, "Input"],
Cell[596636, 17494, 518, 14, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[597191, 17513, 386, 11, 27, "Input"],
Cell[597580, 17526, 729, 21, 47, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
