(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    526261,      14942]
NotebookOptionsPosition[    515188,      14605]
NotebookOutlinePosition[    516545,      14653]
CellTagsIndexPosition[    516471,      14648]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Dynamic AdS/CMT - Superconductor - Spectral - Numerial Ansatz II\
\>", "Subtitle",
 CellChangeTimes->{{3.408796983010241*^9, 3.408796989128707*^9}, {
   3.415942197687789*^9, 3.415942199707787*^9}, {3.428318203595373*^9, 
   3.4283182110266533`*^9}, {3.4318556687961187`*^9, 3.431855668994246*^9}, {
   3.495174647742872*^9, 3.460515504326817*^9}, {3.503996600043788*^9, 
   3.503996603042028*^9}, {3.507011572545054*^9, 3.460340667971311*^9}, {
   3.5374843541262083`*^9, 3.537484358716886*^9}, 3.537484391202265*^9, {
   3.537484629914453*^9, 3.537484630281348*^9}, {3.5374893532274837`*^9, 
   3.537489358050692*^9}, {3.53749388933057*^9, 3.537493890193932*^9}, {
   3.537578587160997*^9, 3.5375785895997057`*^9}, {3.537578682265374*^9, 
   3.537578682504321*^9}, {3.537578812305402*^9, 3.537578812720454*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", "\"\<hmm\>\"", "]"}]], "Input"],

Cell[BoxData["\<\"hmm\"\>"], "Print",
 CellChangeTimes->{3.53880794268043*^9, 3.54386945932994*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRSetup2.nb - modified", "Subsubtitle",
 CellChangeTimes->{{3.478330969800351*^9, 3.478330971159855*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Latest", " ", "Version"}], " ", "*)"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"metric", "=", 
   RowBox[{"{", 
    RowBox[{
    "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
     "gzz"}], "}"}]}], "\n"}], "\n", 
 RowBox[{"Gd", "=", 
  RowBox[{"DiagonalMatrix", "[", "metric", "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "gtt", ",", "grr", ",", "g\[Theta]\[Theta]", ",", "g\[Phi]\[Phi]", ",", 
   "gzz"}], "}"}]], "Output",
 CellChangeTimes->{3.538807942880889*^9, 3.54386945943898*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"gtt", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "grr", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "g\[Theta]\[Theta]", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "g\[Phi]\[Phi]", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "gzz"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807942880889*^9, 3.5438694594419317`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gd", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "grt"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Gd", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", "grt"}]}], "Input"],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{3.538807942964953*^9, 3.543869459599666*^9}],

Cell[BoxData["grt"], "Output",
 CellChangeTimes->{3.538807942964953*^9, 3.543869459601186*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"BuildMetric", ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Gu", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"Inverse", "[", "Gd", "]"}], "]"}]}], ";", 
    RowBox[{"G", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "d"}], "}"}], ",", 
       RowBox[{"IdentityMatrix", "[", "Nind", "]"}]}], "}"}]}], ";"}], 
   ")"}]}]], "Input"],

Cell[BoxData["BuildMetric"], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
    "}"}]}], "\n"}], "\n", 
 RowBox[{"Nind", "=", 
  RowBox[{"Length", "[", "ind", "]"}]}]}], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]", ",", "z"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807943254242*^9, 3.54386945993823*^9}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{3.538807943254242*^9, 3.543869459939768*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"getind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "i1", "]"}], ",", "i1", ",", 
      RowBox[{
       RowBox[{"Position", "[", 
        RowBox[{"ind", ",", "i1"}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lstind", "[", "i1_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"lsttmp2", "=", 
      RowBox[{"{", "}"}]}], ";", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"lsttmp2", ",", 
         RowBox[{"getind", "[", 
          RowBox[{"i1", "[", 
           RowBox[{"[", 
            RowBox[{"lsttmp1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"lsttmp1", ",", "1", ",", 
         RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
     "lsttmp2"}], ")"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"up", "[", 
   RowBox[{"i1_", ",", "i2_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"lsttmp2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"lsttmp2", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"i1", "[", 
            RowBox[{"[", 
             RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "=!=", 
           RowBox[{"i2", "[", 
            RowBox[{"[", "lsttmp1", "]"}], "]"}]}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i1", "[", 
              RowBox[{"[", 
               RowBox[{"lsttmp1", ",", "2"}], "]"}], "]"}], "===", "d"}], ",",
             "d", ",", "u"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"lsttmp1", ",", "1", ",", 
        RowBox[{"Length", "[", "i1", "]"}]}], "}"}]}], "]"}], ";", 
    "lsttmp2"}], ")"}]}]}], "Input",
 Editable->False],

Cell[BoxData[""], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"t1_", ",", "dim_", ",", "indpos_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"MTtmp1", "=", "0"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "indpos", "]"}], "=!=", "dim"}], ",", 
      RowBox[{"Print", "[", "\"\<Error in index position\>\"", "]"}]}], "]"}],
     ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"MTtmp1", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"MTtmp1", ",", 
         RowBox[{"{", 
          RowBox[{"MTtmp3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"MTtmp2", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
    RowBox[{"t1", "=", 
     RowBox[{"{", 
      RowBox[{"indpos", ",", "MTtmp1"}], "}"}]}]}], ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ST", "[", 
    RowBox[{"t1_", ",", "tind_", ",", "val_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"STtmp1", "=", "t1"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"up", "[", 
         RowBox[{"tind", ",", 
          RowBox[{"t1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "=!=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "tind", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Print", "[", "\"\<Error in Index Assignment!!\>\"", "]"}], 
        ";"}]}], "]"}], ";", 
     RowBox[{
      RowBox[{"STtmp1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "=", 
      RowBox[{"ReplacePart", "[", 
       RowBox[{
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", "val", ",", 
        RowBox[{"lstind", "[", "tind", "]"}]}], "]"}]}], ";", "STtmp1"}], 
    ")"}]}], "\n"}]], "Input",
 Editable->False],

Cell["\<\


Edited the expression below as 7.0 seems to complain about Sum[x] whereas 6.0 \
would just return x (ie. if there is no sum index!)

\
\>", "Text",
 CellChangeTimes->{{3.465736646430695*^9, 3.4657366879261303`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GT", "[", 
   RowBox[{"t1_", ",", "tind_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GTtmp2", "=", 
     RowBox[{"up", "[", 
      RowBox[{"tind", ",", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
    RowBox[{"GTtmp3", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp4", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp5", "=", "\"\<\>\""}], ";", 
    RowBox[{"GTtmp6", "=", "t1"}], ";", "\n", "\t\t", 
    RowBox[{"Do", "[", "\n", "\t\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
         RowBox[{"GTtmp2", "[", 
          RowBox[{"[", "GTtmp1", "]"}], "]"}], ",", "\n", "\t\t\t\t", "0", 
         ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}]}],
            ";"}], ")"}], ",", "\n", "\t\t\t\t", "u", ",", "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gu[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}]}], ")"}], ",", "\n", "\t\t\t\t", "d", ",",
          "\n", "\t\t\t\t", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"GTtmp3", "=", 
            RowBox[{"GTtmp3", "<>", "\"\<,\>\"", "<>", "\"\<tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}]}]}], ";", "\n", 
           "\t\t\t\t\t", 
           RowBox[{"GTtmp4", "=", 
            RowBox[{"GTtmp4", "<>", "\"\< Gd[[\>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"getind", "[", 
               RowBox[{"tind", "[", 
                RowBox[{"[", 
                 RowBox[{"GTtmp1", ",", "1"}], "]"}], "]"}], "]"}], "]"}], 
             "<>", "\"\<, tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<]] \>\""}]}], ";", "\n", "\t\t\t\t\t", 
           RowBox[{"GTtmp5", "=", 
            RowBox[{"GTtmp5", "<>", "\"\<,{tmpind\>\"", "<>", 
             RowBox[{"ToString", "[", "GTtmp1", "]"}], "<>", 
             "\"\<,1,Nind}\>\""}]}], ";"}], ")"}]}], "]"}], ";"}], "\n", 
      "\t\t\t", ",", 
      RowBox[{"{", 
       RowBox[{"GTtmp1", ",", "1", ",", 
        RowBox[{"Length", "[", 
         RowBox[{"t1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ";", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"GTtmp4", "===", "\"\<\>\""}], "&&", 
       RowBox[{"GTtmp5", "===", "\"\<\>\""}]}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\""}], 
       "]"}], ",", 
      RowBox[{"ToExpression", "[", 
       RowBox[{
       "\"\<Sum[GTtmp6[[2\>\"", "<>", "GTtmp3", "<>", "\"\<]]\>\"", "<>", 
        "GTtmp4", "<>", "GTtmp5", "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], 
   ")"}]}]], "Input",
 Editable->False,
 CellChangeTimes->{{3.465736640865263*^9, 3.4657366432796392`*^9}, {
  3.465736699767317*^9, 3.4657367470041943`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Trace, Outer Product and Covariant Derivative! - GREinstein.nb\
\>", "Subsubtitle",
 Editable->False],

Cell["\<\
Syntax:   trT[tensor,{{1,4},{2,3}}]   -  ie. contract 1 and 4 plus 2 and 3 \
positions\
\>", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"trT", "[", 
   RowBox[{"t1_", ",", "lst_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "tracetmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"dimt1", "===", "2"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tracetmp", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"GT", "[", 
           RowBox[{"tmpt1", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"s1", ",", "d"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"s1", ",", "u"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MT", "[", 
        RowBox[{"tracetmp", ",", 
         RowBox[{"dimt1", "-", 
          RowBox[{"2", 
           RowBox[{"Length", "[", "lst", "]"}]}]}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{"d", ",", 
           RowBox[{"{", 
            RowBox[{"ii", ",", "1", ",", 
             RowBox[{"dimt1", "-", 
              RowBox[{"2", 
               RowBox[{"Length", "[", "lst", "]"}]}]}]}], "}"}]}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
       RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", "}"}], "===", 
             RowBox[{"Position", "[", 
              RowBox[{"lst", ",", "indno"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"tmpstring1", "=", 
              RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,d},\>\""}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"tmpstring3", "=", 
              RowBox[{"tmpstring3", "<>", "\"\<{i\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,1,Nind},\>\""}]}], ";"}]}], "\[IndentingNewLine]", "]"}],
           ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}],
           ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
       "\n", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tmpstring4", "=", 
           RowBox[{"tmpstring4", "<>", "\"\<{s\>\"", "<>", 
            RowBox[{"ToString", "[", "indno", "]"}], "<>", 
            "\"\<,1,Nind},\>\""}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "1"}], "]"}], "]"}], "]"}]}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"tmpstring2", "=", 
           RowBox[{"StringReplace", "[", 
            RowBox[{"tmpstring2", ",", 
             RowBox[{
              RowBox[{"\"\<i\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", 
                  RowBox[{"indno", ",", "2"}], "]"}], "]"}], "]"}], "<>", 
               "\"\<,d}\>\""}], "->", 
              RowBox[{"\"\<s\>\"", "<>", 
               RowBox[{"ToString", "[", "indno", "]"}], "<>", 
               "\"\<,u}\>\""}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"indno", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tmpeval", "=", 
        RowBox[{"\"\<Do[tracetmp=ST[tracetmp,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring1", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},Sum[GT[tmpt1,{\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring2", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]],\>\"", "<>", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"tmpstring3", ",", 
           RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "tracetmp"}], 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell["Syntax:   outerT[tensor1,tensor2] ", "Text",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"outerT", "[", 
   RowBox[{"t1_", ",", "t2_"}], "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimt1", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    RowBox[{"dimt2", "=", 
     RowBox[{"Length", "[", 
      RowBox[{"Dimensions", "[", 
       RowBox[{"t2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tmpt1", "=", "t1"}], ";", 
    RowBox[{"tmpt2", "=", "t2"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "outertmp", "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"outertmp", ",", 
      RowBox[{"dimt1", "+", "dimt2"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{"d", ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "1", ",", 
          RowBox[{"dimt1", "+", "dimt2"}]}], "}"}]}], "]"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring1", "=", 
        RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring2", "=", 
        RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", 
    RowBox[{"tmpstring4", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", "\n", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"tmpstring3", "=", 
        RowBox[{"tmpstring3", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"tmpstring4", "=", 
        RowBox[{"tmpstring4", "<>", "\"\<{j\>\"", "<>", 
         RowBox[{"ToString", "[", "indno", "]"}], "<>", 
         "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"indno", ",", "1", ",", "dimt2"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"tmpeval", "=", 
     RowBox[{"\"\<Do[outertmp=ST[outertmp,{\>\"", "<>", "tmpstring1", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<},GT[tmpt1,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring1", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]GT[tmpt2,{\>\"", "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring3", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}]],\>\"", "<>", "tmpstring2",
       "<>", 
      RowBox[{"StringDrop", "[", 
       RowBox[{"tmpstring4", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<]\>\""}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "outertmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"scalarDT", "[", "t1_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"MT", "[", 
     RowBox[{"covDTtmp", ",", "1", ",", 
      RowBox[{"{", "d", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
    "tmpeval", "=", 
     "\"\<Do[covDTtmp=ST[covDTtmp,{{i1,d}},D[tmpt1,ind[[i1]]]],{i1,1,Nind}]\>\
\""}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", "\[IndentingNewLine]",
     "\[IndentingNewLine]", "covDTtmp"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", ")"}]}]], "Input",
 Editable->False],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"covDT", "[", "t1_", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dimt1", "=", 
      RowBox[{"Length", "[", 
       RowBox[{"Dimensions", "[", 
        RowBox[{"t1", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tmpt1", "=", "t1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", "covDTtmp", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"MT", "[", 
      RowBox[{"covDTtmp", ",", 
       RowBox[{"dimt1", "+", "1"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"ii", ",", "1", ",", 
           RowBox[{"dimt1", "+", "1"}]}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Build", " ", "expression"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpstring1", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring2", "=", "\"\<\>\""}], ";", 
     RowBox[{"tmpstring3", "=", "\"\<\>\""}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring1", "=", 
         RowBox[{"tmpstring1", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", "\"\<,d},\>\""}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring2", "=", 
         RowBox[{"tmpstring2", "<>", "\"\<{i\>\"", "<>", 
          RowBox[{"ToString", "[", "indno", "]"}], "<>", 
          "\"\<,1,Nind},\>\""}]}], ";"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"tmpstring4", "=", 
         RowBox[{"\"\<-Sum[GT[tmpt1,{\>\"", "<>", 
          RowBox[{"StringDrop", "[", 
           RowBox[{"tmpstring1", ",", 
            RowBox[{"-", "1"}]}], "]"}], "<>", 
          "\"\<}]GT[\[CapitalGamma],{{REPL,d},{s1,d},{s2,u}}],{s2,1,Nind}]\>\"\
"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}], "\[Rule]", " ", 
            "\"\<s2\>\""}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"tmpstring4", "=", 
         RowBox[{"StringReplace", "[", 
          RowBox[{"tmpstring4", ",", 
           RowBox[{"\"\<REPL\>\"", "\[Rule]", 
            RowBox[{"\"\<i\>\"", "<>", 
             RowBox[{"ToString", "[", "indno", "]"}]}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"tmpstring3", "=", 
         RowBox[{"tmpstring3", "<>", "tmpstring4"}]}], ";"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"indno", ",", "1", ",", "dimt1"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tmpeval", "=", 
      RowBox[{
      "\"\<Do[covDTtmp=ST[covDTtmp,{\>\"", "<>", "tmpstring1", "<>", 
       "\"\<{s1,d}},D[GT[tmpt1,{\>\"", "<>", 
       RowBox[{"StringDrop", "[", 
        RowBox[{"tmpstring1", ",", 
         RowBox[{"-", "1"}]}], "]"}], "<>", "\"\<}],ind[[s1]]]\>\"", "<>", 
       "tmpstring3", "<>", "\"\<],\>\"", "<>", "tmpstring2", "<>", 
       "\"\<{s1,1,Nind}]\>\""}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ToExpression", "[", "tmpeval", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "covDTtmp"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}], ";"}]], "Input",
 Editable->False],

Cell[BoxData["."], "Input",
 CellChangeTimes->{3.399009138941909*^9},
 EmphasizeSyntaxErrors->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Buildmetric", "Subsubtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Gd", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "^", "2"}]], 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"-", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "0", "0"},
       {
        RowBox[{"-", 
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}], "0"},
       {"0", "0", "0", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "^", "2"}]}
      }], ")"}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Nind", "=", 
   RowBox[{"Length", "[", "ind", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"BuildMetric", ";"}]}], "Input",
 CellChangeTimes->{{3.408796998476103*^9, 3.408797030516582*^9}, {
   3.408799071597343*^9, 3.408799082644943*^9}, {3.408949739095245*^9, 
   3.408949739644734*^9}, {3.408949841695282*^9, 3.40894984293303*^9}, {
   3.415862083663703*^9, 3.4158620851642113`*^9}, {3.415862334623486*^9, 
   3.415862336021243*^9}, {3.415862388498528*^9, 3.4158623965197372`*^9}, {
   3.4158641082437763`*^9, 3.415864116357332*^9}, {3.415865034672494*^9, 
   3.415865047473855*^9}, {3.415943026431671*^9, 3.415943056090918*^9}, {
   3.42453089354659*^9, 3.424530981705195*^9}, {3.4262330694486513`*^9, 
   3.426233078224708*^9}, {3.42831552177035*^9, 3.428315531925826*^9}, {
   3.482669504390863*^9, 3.482669559589313*^9}, {3.482669593648382*^9, 
   3.4826696108221407`*^9}, {3.4826696421684*^9, 3.460306349771068*^9}, {
   3.460306681872867*^9, 3.4603066892293873`*^9}, {3.460306743915044*^9, 
   3.460306776656151*^9}, {3.4603068906726713`*^9, 3.4603069154556093`*^9}, 
   3.4606109474491568`*^9, {3.5039972414730186`*^9, 3.503997244123049*^9}, {
   3.507011580676421*^9, 3.507011659804162*^9}, {3.507013755598536*^9, 
   3.460392698323369*^9}, {3.4604018613321533`*^9, 3.4604018646719627`*^9}, {
   3.460401965632374*^9, 3.460401968163259*^9}, {3.4604023388162813`*^9, 
   3.4604023558966084`*^9}, {3.460402422665003*^9, 3.460402426690833*^9}, {
   3.460402628586185*^9, 3.4604026419139843`*^9}, {3.460402674350209*^9, 
   3.4604026844332027`*^9}, {3.460512773931822*^9, 3.460512787444798*^9}, {
   3.4605146484667263`*^9, 3.460514650350994*^9}, {3.460514717258254*^9, 
   3.460514724283691*^9}, 3.460514770989304*^9, 3.4605223140457373`*^9, {
   3.4605327188171663`*^9, 3.460532727004561*^9}, {3.460532863547011*^9, 
   3.460532865145266*^9}, {3.460532977769042*^9, 3.4605329860852757`*^9}, {
   3.507275497143169*^9, 3.4603659980232763`*^9}, {3.537484515197036*^9, 
   3.537484572210073*^9}, 3.537484644682625*^9, {3.5374846959240923`*^9, 
   3.537484701892157*^9}, {3.537484976337736*^9, 3.5374849917355137`*^9}, {
   3.537486594817341*^9, 3.537486596777007*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     FractionBox[
      RowBox[{"gzz", "[", 
       RowBox[{"v", ",", "z"}], "]"}], 
      SuperscriptBox["z", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.543869460369071*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"v", ",", "z", ",", "x1", ",", "x2"}], "}"}]], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.543869460372294*^9}],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.5388079438542337`*^9, 3.543869460374483*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gd"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], 
       SuperscriptBox["z", "2"]]}], ",", 
     FractionBox[
      RowBox[{"gzz", "[", 
       RowBox[{"v", ",", "z"}], "]"}], 
      SuperscriptBox["z", "2"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], 
      SuperscriptBox["z", "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807943934894*^9, 3.5438694604482927`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Gu"], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"gvz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{
         RowBox[{"gzz", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]]}], ",", 
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"gvz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
       RowBox[{
        RowBox[{"gzz", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"T", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["z", "2"], 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      SuperscriptBox["z", "2"], 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807944009327*^9, 3.543869460487749*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"detg", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Det", "[", "Gd", "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"gvz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
      RowBox[{
       RowBox[{"gzz", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"T", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
   SuperscriptBox["z", "8"]]}]], "Output",
 CellChangeTimes->{3.538807944075788*^9, 3.5438694606321898`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GRrun2.nb", "Subsubtitle"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\[CapitalGamma]", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[CapitalGamma]", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "u"}], "}"}]}], "]"}], ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R4", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R4", ",", "4", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d", ",", "d", ",", "u"}], "}"}]}], "]"}], 
  ";"}], "\n"}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "R2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"R2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "G2", "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"G2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"\[CapitalGamma]", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"\[CapitalGamma]", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"GT", "[", 
          RowBox[{"G", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "u"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
            "}"}]}], "]"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "+", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"GT", "[", 
              RowBox[{"G", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"ind", "[", 
                    RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], 
                "}"}]}], "]"}], ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ss1", "]"}], "]"}]}], "]"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"FullSimplify", "[", "\[CapitalGamma]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.426232729469757*^9, 3.426232735540435*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", "\n", "\t", 
  RowBox[{
   RowBox[{"R4", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R4", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}], ",", 
      "\n", "\t", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"GT", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ind", "[", 
                RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], "}"}]}],
           "]"}], ",", 
         RowBox[{"ind", "[", 
          RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "+", "\n", "\t\t\t", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i3", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}], 
           RowBox[{"GT", "[", 
            RowBox[{"\[CapitalGamma]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ind", "[", 
                  RowBox[{"[", "i4", "]"}], "]"}], ",", "u"}], "}"}]}], 
              "}"}]}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}]}], "\n", 
     "\t\t", "\n", "\t\t", "]"}]}], "\n", "\t\t", ",", "\n", "\t", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i3", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i4", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R4", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"R2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"R2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"GT", "[", 
         RowBox[{"R4", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], "\n", 
     "\t\t", "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "R2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"R2", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ind", "[", 
            RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"G2", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"G2", ",", "\n", "\t\t\t", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}], ",", 
      "\n", "\t\t\t", 
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"R2", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ind", "[", 
              RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
        "]"}], "-", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"GT", "[", 
         RowBox[{"G", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i1", "]"}], "]"}], ",", "d"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"ind", "[", 
               RowBox[{"[", "i2", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
         "]"}], "Ricci"}]}]}], "]"}]}], "\n", "\t", ",", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "G2", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"FullSimplify", "[", "Ricci", "]"}], " ", "*)"}]], "Input",
 Editable->False,
 CellTags->"calcgeom"]
}, Closed]],

Cell[CellGroupData[{

Cell["Einstein equations", "Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"R2", "=", 
   RowBox[{"Simplify", "[", "R2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041067188341103`*^9, 3.404106720182616*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ricci", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"GT", "[", 
       RowBox[{"R2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "u"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ind", "[", 
             RowBox[{"[", "ss1", "]"}], "]"}], ",", "d"}], "}"}]}], "}"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"ss1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "A", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"A", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "=", 
    RowBox[{"ST", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"v", ",", "d"}], "}"}], "}"}], ",", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"ST", "[", 
    RowBox[{"A", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"z", ",", "d"}], "}"}], "}"}], ",", 
     RowBox[{"az", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451383976248069*^9, 3.4513840125908737`*^9}, {
  3.451384057147691*^9, 3.451384064689735*^9}, {3.451385762395092*^9, 
  3.451385762480318*^9}, {3.451385800913571*^9, 3.451385805770357*^9}, {
  3.537484677141605*^9, 3.53748468964509*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "F", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"F", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "d"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "=", 
      RowBox[{"ST", "[", 
       RowBox[{"F", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i2", ",", "d"}], "}"}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i2", "]"}], "]"}]}], "]"}], "-", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i2", ",", "d"}], "}"}], "}"}]}], "]"}], ",", 
           RowBox[{"ind", "[", 
            RowBox[{"[", "i1", "]"}], "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i2", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4041040239360247`*^9, 3.404104073416904*^9}, {
  3.4041057167733383`*^9, 3.4041057183570337`*^9}, {3.4513840707957897`*^9, 
  3.451384164343499*^9}, {3.460366100458836*^9, 3.460366108909464*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"trFF", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"trT", "[", 
      RowBox[{
       RowBox[{"outerT", "[", 
        RowBox[{"F", ",", "F"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fsqr", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"trT", "[", 
     RowBox[{"trFF", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.404103126230957*^9, 3.404103206051724*^9}, 
   3.404103788928409*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"\[Alpha]", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "Dp", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{"Dp", ",", "1", ",", 
     RowBox[{"{", "d", "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Dp", "=", 
       RowBox[{"ST", "[", 
        RowBox[{"Dp", ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"i1", ",", "d"}], "}"}], "}"}], ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"\[Phi]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "i1", "]"}], "]"}]}], "]"}], "-", 
          RowBox[{"2", "I", " ", 
           RowBox[{"GT", "[", 
            RowBox[{"A", ",", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"i1", ",", "d"}], "}"}], "}"}]}], "]"}], 
           RowBox[{"\[Phi]", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConjDp", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "d", "}"}], ",", 
      RowBox[{"Conjugate", "[", 
       RowBox[{"Dp", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DpDp", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{"trT", "[", 
       RowBox[{
        RowBox[{"outerT", "[", 
         RowBox[{"ConjDp", ",", "Dp"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Vterm", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"\[Phi]", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "]"}], 
       RowBox[{"\[Phi]", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513844331121693`*^9, 3.451384521665413*^9}, {
   3.451384560554626*^9, 3.451384642158163*^9}, {3.4513849100950413`*^9, 
   3.451384915054587*^9}, 3.451385051803838*^9, {3.4513851171366262`*^9, 
   3.45138511927711*^9}, {3.451385175930884*^9, 3.451385183167452*^9}, {
   3.451385425505906*^9, 3.45138544324051*^9}, {3.451385490350021*^9, 
   3.451385493946774*^9}, {3.451385568392873*^9, 3.451385601054823*^9}, {
   3.451385813165941*^9, 3.4513858527683163`*^9}, {3.45138608116168*^9, 
   3.451386103913107*^9}, {3.46036707784975*^9, 3.460255762501432*^9}, {
   3.46025580130457*^9, 3.460255801461816*^9}, {3.53748492894665*^9, 
   3.53748495518618*^9}, {3.537485329580826*^9, 3.537485331297533*^9}, 
   3.543869463106576*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DpDp", "=", 
   RowBox[{"(", 
    RowBox[{"DpDp", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", "xx_", "]"}], "\[Rule]", "xx"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", "xx_", "]"}], "\[Rule]", "0"}]}], "}"}]}], ")"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.451385894732107*^9, 3.451385976334114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sqrtdetg", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"PowerExpand", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Det", "[", 
       RowBox[{"-", "Gd"}], "]"}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4041041692972*^9, 3.404104211096949*^9}, 
   3.404105293940057*^9, {3.4513842180130997`*^9, 3.4513842223260803`*^9}, {
   3.4513846617079067`*^9, 3.451384675916638*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"sqrtdetg", 
    RowBox[{"(", 
     RowBox[{"Ricci", "+", "6", "-", 
      RowBox[{
       FractionBox["1", "4"], "Fsqr"}], "-", "DpDp", "-", "Vterm"}], 
     ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.451384367735067*^9, 3.451384393946628*^9}, {
   3.4513849054437723`*^9, 3.4513849068431387`*^9}, {3.451385606138598*^9, 
   3.451385607193993*^9}, 3.460366276193363*^9, {3.4603670917067547`*^9, 
   3.460255829896731*^9}, 3.537493905932642*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp1", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gvz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp2", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["gzz", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmp3", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"L", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"2", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["S", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.53748653613297*^9, 3.5374865918283*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp1", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gvz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gvz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp2", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["gzz", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["gzz", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GHBT", "+=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
      "+", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"tmp3", ".", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GHBT", "+=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", "0", ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "v"}], "]"}], 
     "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"tmp4", ".", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           SuperscriptBox["S", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], ",", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{
            SuperscriptBox["S", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], "}"}]}], ",", "z"}], "]"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.460366441552243*^9, 3.460366544772176*^9}, {
  3.4603665879440317`*^9, 3.460366626391823*^9}, {3.537486655723679*^9, 
  3.537486732610427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"L2", "=", 
   RowBox[{"L", "-", "GHBT"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460366546941235*^9, 3.460366557341961*^9}, 
   3.460366686117609*^9, {3.4603672960654507`*^9, 3.4603672977104673`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gvz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["gzz", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"L2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Coefficient", "[", 
    RowBox[{"L2", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"2", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{
        SuperscriptBox["S", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.4603663459440107`*^9, 3.4603664394408617`*^9}, {
  3.460366666517003*^9, 3.460366674775579*^9}, {3.537486746662644*^9, 
  3.5374867639666147`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.543869500041778*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.543869500044671*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.543869500079524*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.538807949673905*^9, 3.543869500134577*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"EOM", "[", "fld_", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmp", "=", 
     RowBox[{"D", "[", 
      RowBox[{"L2", ",", "fld"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"tmp2", "=", 
           RowBox[{"D", "[", 
            RowBox[{"fld", ",", 
             RowBox[{"ind", "[", 
              RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ")"}], "=!=", "0"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "-=", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"L2", ",", "tmp2"}], "]"}], ",", 
            RowBox[{"ind", "[", 
             RowBox[{"[", "ii", "]"}], "]"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"ii", ",", "1", ",", "Nind"}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", "tmp"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.4513849546200113`*^9, 3.451385039242148*^9}, {
  3.4603662728020573`*^9, 3.460366273871294*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqp", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"p", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"\[Alpha]", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513848144544163`*^9, 3.4513848150159073`*^9}, {
  3.451384869337384*^9, 3.451384875673843*^9}, {3.451384929950244*^9, 
  3.451384930100154*^9}, {3.451385060851385*^9, 3.451385213396349*^9}, {
  3.451385293160893*^9, 3.451385302528058*^9}, {3.4513853749547167`*^9, 
  3.45138537639461*^9}, {3.451385514552088*^9, 3.451385527943191*^9}, {
  3.451385862306609*^9, 3.451385882826736*^9}, {3.451386138230373*^9, 
  3.451386140019012*^9}, {3.451386241895258*^9, 3.4513862693654633`*^9}, {
  3.4603675858592987`*^9, 3.4603675914720583`*^9}, {3.537486779881022*^9, 
  3.537486784922683*^9}, {3.537486894453556*^9, 3.5374869009568243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqav", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"av", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"az", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4513855403702793`*^9, 3.451385540823719*^9}, {
  3.4513861532442207`*^9, 3.45138616739637*^9}, {3.451386251199284*^9, 
  3.4513862656960487`*^9}, {3.460367593073217*^9, 3.460367597640524*^9}, {
  3.5374867866028214`*^9, 3.537486788378339*^9}, {3.537486891597521*^9, 
  3.537486937732339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eqgvz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gvz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqgzz", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"gzz", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqT", "=", 
    RowBox[{"EOM", "[", 
     RowBox[{"T", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqS", "=", 
   RowBox[{"EOM", "[", 
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.451386275930722*^9, 3.451386303859261*^9}, {
  3.460366711720347*^9, 3.4603667226381903`*^9}, {3.460367599130735*^9, 
  3.460367611985876*^9}, {3.53748678993122*^9, 3.53748680663302*^9}, {
  3.537486911477583*^9, 3.5374869187572203`*^9}}],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"gvz", ",", "gzz", ",", "az"}], "]"}]], "Input",
 CellChangeTimes->{{3.53748694036823*^9, 3.537486945275868*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"gvz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gzz", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"az", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}]}], "Input",
 CellChangeTimes->{{3.460366755240944*^9, 3.460366765921853*^9}, {
   3.460379717667384*^9, 3.460379720321673*^9}, {3.4603938524268913`*^9, 
   3.4603938546559877`*^9}, 3.4603939628549967`*^9, {3.5374868640225983`*^9, 
   3.537486876197587*^9}, {3.537486924492758*^9, 3.537486925572747*^9}, {
   3.537487030062772*^9, 3.537487030117689*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqp2", "=", 
   RowBox[{"Simplify", "[", "eqp", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq\[Alpha]2", "=", 
   RowBox[{"Simplify", "[", "eq\[Alpha]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqav2", "=", 
   RowBox[{"Simplify", "[", "eqav", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqaz2", "=", 
   RowBox[{"Simplify", "[", "eqaz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgvz2", "=", 
   RowBox[{"Simplify", "[", "eqgvz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqgzz2", "=", 
   RowBox[{"Simplify", "[", "eqgzz", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqT2", "=", 
   RowBox[{"Simplify", "[", "eqT", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"eqS2", "=", 
  RowBox[{"Simplify", "[", "eqS", "]"}]}]}], "Input",
 CellChangeTimes->{{3.460366768598325*^9, 3.4603668525536737`*^9}, {
  3.5374869590367947`*^9, 3.537486972220312*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"S", "[", 
    RowBox[{"v", ",", "z"}], "]"}]], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"p", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "z"}], " ", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"S", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Alpha]", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "-", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "z", " ", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["av", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{
                SuperscriptBox["p", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["p", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.5438695004606524`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"S", "[", 
    RowBox[{"v", ",", "z"}], "]"}]], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"S", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["av", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"T", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["\[Alpha]", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "2"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.543869500539345*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["av", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["z", "6"], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]]}]]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.543869500580884*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["z", "14"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "4"], 
        SuperscriptBox["z", "8"]]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "7"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"8", " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["av", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["av", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.543869500635*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "2"]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"\[Alpha]", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["av", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "6"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.543869500689187*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"S", "[", 
      RowBox[{"v", ",", "z"}], "]"}], "2"]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"16", " ", 
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"av", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"T", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"av", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"\[Alpha]", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"p", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"T", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "6"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"12", "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"p", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"\[Alpha]", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["z", "4"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["av", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{"4", " ", "z", " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["p", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["\[Alpha]", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["T", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{"z", " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}]}], ")"}]}], 
     "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox[
          RowBox[{"T", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{
              SuperscriptBox["T", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{
             SuperscriptBox["T", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"2", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.543869500915658*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["S", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["z", "6"], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"S", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "4"], 
      SuperscriptBox["z", "8"]]}]]}]]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.543869500969275*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["z", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"S", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "4"], 
        SuperscriptBox["z", "8"]]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"S", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "6"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"p", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"\[Alpha]", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["z", "4"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["av", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"8", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"av", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"p", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"6", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["p", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["\[Alpha]", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["p", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["z", "2"], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Alpha]", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["T", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["S", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "2"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["S", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.5388079500961*^9, 3.543869501039179*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", "0"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"q", " ", "z"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"z", "^", "3"}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"q", "^", "2"}], " ", 
     RowBox[{"z", "^", "4"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", "1"}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", "eqp2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eq\[Alpha]2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqav2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqaz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgvz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqgzz2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", "eqT2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "eqS2", "]"}]}], "Input",
 CellChangeTimes->{{3.507012905387106*^9, 3.507012910083256*^9}, {
  3.5070145245498*^9, 3.4603669411156473`*^9}, {3.5374870758129187`*^9, 
  3.5374870842285547`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.54386950121074*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.5438695012132998`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.5438695012152653`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.5438695012171907`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.5438695012191563`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.543869501221084*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.543869501223081*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.538807950944631*^9, 3.543869501225114*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"\[Alpha]", ",", "p", ",", "av", ",", "T", ",", "S"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4603676469897413`*^9, 3.460367657697607*^9}, {
  3.4603797352914047`*^9, 3.460379735508092*^9}, {3.5374870733721457`*^9, 
  3.537487073532263*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"f", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"h", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"av", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"m", "[", "v", "]"}], "+", 
    RowBox[{"z", " ", 
     RowBox[{"a", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], " ", 
     RowBox[{"t", "[", 
      RowBox[{"v", ",", "z"}], "]"}]}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S", "[", 
   RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"z", "^", "2"}], " ", 
    RowBox[{"s", "[", 
     RowBox[{"v", ",", "z"}], "]"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.507012851251483*^9, 3.50701290255637*^9}, {
   3.507012980512628*^9, 3.507013071185956*^9}, {3.50701380646482*^9, 
   3.507013808591444*^9}, {3.50701392897845*^9, 3.507014009338502*^9}, {
   3.507014045652314*^9, 3.5070140489415493`*^9}, {3.507014084805723*^9, 
   3.5070140856041527`*^9}, {3.5070141539580584`*^9, 3.507014217035973*^9}, 
   3.507014460216051*^9, {3.507014517553883*^9, 3.507014519521122*^9}, {
   3.507026986030282*^9, 3.507027007021398*^9}, {3.507027070606153*^9, 
   3.507027080174543*^9}, {3.5070273643135653`*^9, 3.507027373246945*^9}, 
   3.5070274403882923`*^9, 3.5070279834807796`*^9, {3.507028075087616*^9, 
   3.5070280889777718`*^9}, {3.507028169096327*^9, 3.507028182040041*^9}, {
   3.507028215371438*^9, 3.507028217825584*^9}, {3.507028437267254*^9, 
   3.507028504540182*^9}, {3.50702863903891*^9, 3.507028654513768*^9}, {
   3.5070286982702312`*^9, 3.46039287528255*^9}, {3.460397966335395*^9, 
   3.460397978314865*^9}, {3.460402248264339*^9, 3.460402248933331*^9}, {
   3.460402414899728*^9, 3.4604024462493258`*^9}, {3.460402479395108*^9, 
   3.460402480589229*^9}, {3.4604025220234127`*^9, 3.4604025824098186`*^9}, 
   3.4605146917556133`*^9, {3.460514753254294*^9, 3.460514758331274*^9}, {
   3.460514795295472*^9, 3.460514803263382*^9}, {3.460514836976565*^9, 
   3.460514841157256*^9}, 3.4605327642625523`*^9, {3.460532958549329*^9, 
   3.460532965277766*^9}, {3.460533012519267*^9, 3.460366754063628*^9}, {
   3.460366868363885*^9, 3.460366894840983*^9}, {3.460379729737464*^9, 
   3.4603797299742203`*^9}, {3.537487062261228*^9, 3.537487094008017*^9}, {
   3.537493957818071*^9, 3.537493959306265*^9}, {3.5374940621890287`*^9, 
   3.537494111418051*^9}, {3.537494166786066*^9, 3.537494209239134*^9}, 
   3.5375534855250597`*^9, {3.537578844859714*^9, 3.537578847402349*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Evsol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqgvz2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqS2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqp2", "\[Equal]", "0"}], ",", 
        RowBox[{"eq\[Alpha]2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqaz", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4603794747692738`*^9, 3.4603795051117373`*^9}, {
   3.460379770556391*^9, 3.460379778090231*^9}, {3.537487575145343*^9, 
   3.537487601737835*^9}, {3.5374876320607243`*^9, 3.537487632172414*^9}, 
   3.5374876986147537`*^9, {3.537494224185582*^9, 3.537494230128457*^9}, {
   3.537494336674205*^9, 3.537494337210093*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "z", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["z", "3"], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["z", "3"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "2"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", "z", " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"4", "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{
                 SuperscriptBox["z", "3"], " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "2"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             RowBox[{"4", " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"8", " ", "z", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "z", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["z", "3"], " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"z", " ", 
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["t", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["z", "3"], " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"4", " ", "z", " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        RowBox[{
         SuperscriptBox["h", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}]], 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], 
          SuperscriptBox["z", "2"]]}], "-", 
        RowBox[{
         RowBox[{"1", "/", 
          SuperscriptBox["z", "2"]}], 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "z", " ", 
             RowBox[{"a", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
               SuperscriptBox[
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"f", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
             RowBox[{"m", "[", "v", "]"}]}], "+", 
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], " ", 
                RowBox[{"m", "[", "v", "]"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "-", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["a", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", 
        SuperscriptBox["z", "4"]}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"12", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
         RowBox[{
          SuperscriptBox["z", "4"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["a", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"f", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"h", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], 
           ")"}]}], "+", 
         FractionBox[
          RowBox[{"16", " ", 
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}]], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["z", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}]], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["z", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
             RowBox[{"2", " ", "z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]]}], 
        ")"}]}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["t", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
          RowBox[{"6", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"a", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{"f", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "-", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
       RowBox[{"z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "z", " ", 
           SuperscriptBox[
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"s", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "z", " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "-", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"6", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["t", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["z", "2"]}], " ", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["a", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["z", "6"]}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["z", "2"], "+", 
                   RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                  ")"}]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", 
                   RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                SuperscriptBox[
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                RowBox[{
                 SuperscriptBox["s", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "+", 
                RowBox[{"z", " ", 
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                   RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["f", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                RowBox[{
                 SuperscriptBox["z", "2"], " ", 
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                   RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
             "+", 
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"t", "[", 
                  RowBox[{"v", ",", "z"}], "]"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"4", "+", 
                   RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"z", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["z", "3"]}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                   RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.538807968763275*^9, 3.543869515253158*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Momsol", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eqT2", "\[Equal]", "0"}], ",", 
        RowBox[{"eqgzz", "\[Equal]", "0"}], ",", 
        RowBox[{"eqav", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], ",", " ", 
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.460379791348405*^9, 3.460379854266864*^9}, {
  3.537487577120059*^9, 3.537487629667873*^9}, {3.5374877038531513`*^9, 
  3.537487709515881*^9}, {3.537494238680642*^9, 3.53749424053545*^9}, {
  3.5374943297700453`*^9, 3.537494330345728*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"2", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "2"], "+", 
          RowBox[{
           SuperscriptBox["z", "4"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"16", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"f", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"h", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"8", " ", 
               SuperscriptBox[
                RowBox[{"m", "[", "v", "]"}], "2"]}], "+", 
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["z", "3"], " ", 
         RowBox[{"a", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox[
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"m", "[", "v", "]"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["a", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"m", "[", "v", "]"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"2", " ", "z", " ", 
               RowBox[{"m", "[", "v", "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
           RowBox[{"4", " ", "z", " ", 
            RowBox[{"m", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "z", " ", 
            SuperscriptBox[
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"8", " ", 
               SuperscriptBox[
                RowBox[{"m", "[", "v", "]"}], "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
              RowBox[{"3", " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"s", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"s", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
               SuperscriptBox[
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "z", " ", 
               RowBox[{"m", "[", "v", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["h", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}], "-", 
              RowBox[{"4", " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["t", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
           RowBox[{"z", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["z", "4"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "4"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], 
                ")"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                ")"}]}], "-", 
              RowBox[{"z", " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "z"}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{"z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                    "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{"16", "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["z", "4"], " ", 
                  SuperscriptBox[
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "z"}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", 
                  SuperscriptBox["z", "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                 "-", 
                 RowBox[{"2", " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "20"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "6"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                 "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                   ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]}], 
   ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}]}], 
        "+", 
        RowBox[{"8", " ", "z", " ", 
         RowBox[{
          SuperscriptBox["s", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"z", "+", 
        RowBox[{
         SuperscriptBox["z", "3"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.538807992285688*^9, 3.5438695349077377`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqT2", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"eqav", ",", "v"}], "]"}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"Evsol", ",", "z"}], "]"}]}], "/.", "Evsol"}], "/.", 
    "Momsol"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"eqgzz", ",", "z"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"Evsol", ",", "v"}], "]"}]}], "/.", "Evsol"}], "/.", "Momsol"}],
   "]"}]}], "Input",
 CellChangeTimes->{{3.460379877349128*^9, 3.460379983100644*^9}, {
  3.460380087445326*^9, 3.460380091873478*^9}, {3.537487726936469*^9, 
  3.5374877500015907`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.543869535315189*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.543869535568344*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.5388079928213377`*^9, 3.543869558195561*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Const1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Const2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Const3", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["s", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["s", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Momsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.46031768644937*^9, 3.46031772334064*^9}, {
  3.537487772329159*^9, 3.5374878178010073`*^9}, {3.537494258424617*^9, 
  3.537494262447569*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         SuperscriptBox[
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"h", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{"z", " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], ")"}]}], "+", 
     RowBox[{"8", " ", "z", " ", 
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388080342469997`*^9, 3.543869558256776*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", "+", 
     RowBox[{
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"s", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}]}]], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "-", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["a", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388080342469997`*^9, 3.5438695582626667`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["z", "2"], "+", 
       RowBox[{
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"f", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "8"}], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"m", "[", "v", "]"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"m", "[", "v", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["a", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"m", "[", "v", "]"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{"4", " ", "z", " ", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"m", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["f", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "z", " ", 
         RowBox[{"m", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "z", " ", 
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"m", "[", "v", "]"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
           RowBox[{"3", " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"s", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"m", "[", "v", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   SuperscriptBox["z", "2"], " ", 
                   RowBox[{"t", "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "-", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"t", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["z", "4"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
              RowBox[{
               SuperscriptBox["z", "4"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["h", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{
                   SuperscriptBox["z", "3"], " ", 
                   RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], 
             ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{"2", " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{"z", " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["z", "3"], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["a", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "z"}], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                 RowBox[{"z", " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                 RowBox[{
                  SuperscriptBox["t", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
                 "+", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
           "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{"16", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "4"], " ", 
               SuperscriptBox[
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["z", "6"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "z"}], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                   ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "3"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                 RowBox[{"2", " ", "z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}], "+", 
                 RowBox[{"4", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["a", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["z", "2"], " ", 
               SuperscriptBox[
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "20"}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "6"], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
                    RowBox[{"2", " ", "z", " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    SuperscriptBox["z", "3"], " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", "z", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                   ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"2", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.5388080342469997`*^9, 3.543869558273497*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Eq1", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq3", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eq4", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["s", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["s", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5", "=", 
  RowBox[{
   RowBox[{
    SuperscriptBox["t", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"v", ",", "z"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["t", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"v", ",", "z"}], "]"}], "/.", "Evsol"}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.537489066732723*^9, 3.5374891410817547`*^9}, {
  3.537494265681246*^9, 3.537494272120749*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"m", "[", "v", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "3"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "2"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", "z", " ", 
             RowBox[{"m", "[", "v", "]"}], " ", 
             RowBox[{
              SuperscriptBox["h", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{"4", "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{
                SuperscriptBox["z", "3"], " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "2"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "-", 
            RowBox[{"4", " ", 
             RowBox[{
              SuperscriptBox["f", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["z", "2"], " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{
             SuperscriptBox["t", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}], "+", 
            RowBox[{"z", " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                RowBox[{"t", "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}], "+", 
               RowBox[{"z", " ", 
                RowBox[{
                 SuperscriptBox["t", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", "z", " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{
           SuperscriptBox["s", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.538808034338485*^9, 3.5438695583201303`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "z", " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["a", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["f", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["z", "3"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "z", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["f", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"v", ",", "z"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["z", "3"], " ", 
             RowBox[{
              SuperscriptBox["s", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["t", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["z", "3"], " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["h", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"v", ",", "z"}], "]"}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{"t", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "2"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"4", " ", "z", " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}], " ", 
       RowBox[{
        SuperscriptBox["h", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}], "-", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["h", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], "+", 
  RowBox[{
   SuperscriptBox["h", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.538808034338485*^9, 3.5438695583318768`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}]], 
    RowBox[{"z", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["a", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], 
         SuperscriptBox["z", "2"]]}], "-", 
       RowBox[{
        RowBox[{"1", "/", 
         SuperscriptBox["z", "2"]}], 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "z", " ", 
            RowBox[{"a", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"f", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              SuperscriptBox[
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"m", "[", "v", "]"}]}], "+", 
           RowBox[{
            RowBox[{"h", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               RowBox[{"h", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"m", "[", "v", "]"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "+", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"1", ",", "0"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["s", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}]}], "+", 
  RowBox[{
   SuperscriptBox["a", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.538808034338485*^9, 3.543869558340809*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox["z", "4"]}]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"s", "[", 
        RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"12", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       SuperscriptBox[
        RowBox[{"h", "[", 
         RowBox[{"v", ",", "z"}], "]"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["z", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["a", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "6"}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"f", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["f", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"h", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["h", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}]}], ")"}]}], 
      "+", 
      FractionBox[
       RowBox[{"16", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"t", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}], "+", 
         RowBox[{"z", " ", 
          RowBox[{
           SuperscriptBox["t", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"0", ",", "1"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}]], "-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["z", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], "+", 
          RowBox[{"z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              SuperscriptBox["z", "2"], " ", 
              RowBox[{"t", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              RowBox[{"s", "[", 
               RowBox[{"v", ",", "z"}], "]"}]}], "+", 
             RowBox[{"z", " ", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "1"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", "z", " ", 
           RowBox[{
            SuperscriptBox["s", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["z", "2"], " ", 
           RowBox[{"s", "[", 
            RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]]}], ")"}]}]}], 
  "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.538808034338485*^9, 3.5438695583483562`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["t", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"v", ",", "z"}], "]"}], "-", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", 
       RowBox[{
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"s", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], " ", 
      SuperscriptBox[
       RowBox[{"a", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
        RowBox[{"6", " ", 
         RowBox[{"s", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"t", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["z", "2"], " ", 
         RowBox[{"t", "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"f", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"2", " ", "z", " ", 
      RowBox[{"f", "[", 
       RowBox[{"v", ",", "z"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"s", "[", 
           RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SuperscriptBox["z", "2"], " ", 
            RowBox[{"t", "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["f", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "+", 
        RowBox[{"2", " ", "z", " ", 
         RowBox[{"m", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["h", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "1"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"v", ",", "z"}], "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["f", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "-", 
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "z", " ", 
         SuperscriptBox[
          RowBox[{"h", "[", 
           RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"t", "[", 
            RowBox[{"v", ",", "z"}], "]"}], "+", 
           RowBox[{
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"s", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["z", "2"], " ", 
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "z", " ", 
            RowBox[{"m", "[", "v", "]"}], " ", 
            RowBox[{
             SuperscriptBox["f", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["h", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "-", 
           RowBox[{
            SuperscriptBox["h", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox["t", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"v", ",", "z"}], "]"}], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["s", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
        RowBox[{"z", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["z", "2"]}], " ", 
            SuperscriptBox[
             RowBox[{
              SuperscriptBox["a", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"s", "[", 
              RowBox[{"v", ",", "z"}], "]"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["z", "6"]}], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["a", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["z", "2"], "+", 
                 RowBox[{
                  SuperscriptBox["z", "6"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], "-", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  SuperscriptBox["z", "2"], " ", 
                  RowBox[{"t", "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}], " ", 
               SuperscriptBox[
                RowBox[{
                 SuperscriptBox["f", 
                  TagBox[
                   RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                   Derivative],
                  MultilineFunction->None], "[", 
                 RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
              SuperscriptBox[
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
              RowBox[{
               SuperscriptBox["s", 
                TagBox[
                 RowBox[{"(", 
                  RowBox[{"0", ",", "2"}], ")"}],
                 Derivative],
                MultilineFunction->None], "[", 
               RowBox[{"v", ",", "z"}], "]"}], "+", 
              RowBox[{"z", " ", 
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "-", 
                    RowBox[{
                    SuperscriptBox["z", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["f", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{
                SuperscriptBox["h", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"1", ",", "0"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "2"], " ", 
               RowBox[{
                SuperscriptBox["s", 
                 TagBox[
                  RowBox[{"(", 
                   RowBox[{"0", ",", "1"}], ")"}],
                  Derivative],
                 MultilineFunction->None], "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["s", 
                   TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                   MultilineFunction->None], "[", 
                  RowBox[{"v", ",", "z"}], "]"}], "-", 
                 RowBox[{"2", " ", 
                  RowBox[{
                   SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                   RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
           "+", 
           RowBox[{"2", " ", 
            RowBox[{"s", "[", 
             RowBox[{"v", ",", "z"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"t", "[", 
                RowBox[{"v", ",", "z"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{
                  SuperscriptBox["z", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"z", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{"z", " ", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"z", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["z", "3"]}], " ", 
                  SuperscriptBox[
                   RowBox[{
                    SuperscriptBox["a", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "2"]}], "+", 
                 RowBox[{"z", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "2"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{
                    SuperscriptBox["f", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "-", 
                    RowBox[{
                    SuperscriptBox["h", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["t", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"0", ",", "1"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}], "+", 
                    RowBox[{
                    SuperscriptBox["s", 
                    TagBox[
                    RowBox[{"(", 
                    RowBox[{"1", ",", "0"}], ")"}],
                    Derivative],
                    MultilineFunction->None], "[", 
                    RowBox[{"v", ",", "z"}], "]"}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.538808034338485*^9, 3.543869558358048*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "deriv", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"deriv", "[", "X_", "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"X", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "X"}], ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<v\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<z\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"X", "[", 
            RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], ",", "z"}], 
        "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<vz\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"v", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<vv\>\""}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"X", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "X", "]"}], "<>", "\"\<zz\>\""}], "]"}]}]}],
      "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"deriv", "[", "j", "]"}]}], "Input",
 CellChangeTimes->{{3.537488129955064*^9, 3.537488303539091*^9}, 
   3.537565624076147*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"j", "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "j"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jv"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jz"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jvz"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"2", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jvv"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["j", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"v", ",", "z"}], "]"}], "\[Rule]", "jzz"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5388080344525146`*^9, 3.543869558400304*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"repl", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"m", "[", "v", "]"}], "\[Rule]", "m"}], "}"}], ",", 
     RowBox[{"deriv", "[", "f", "]"}], ",", 
     RowBox[{"deriv", "[", "a", "]"}], ",", 
     RowBox[{"deriv", "[", "h", "]"}], ",", 
     RowBox[{"deriv", "[", "t", "]"}], ",", 
     RowBox[{"deriv", "[", "s", "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.460533850988061*^9, 3.460317762594681*^9}, {
  3.460317899777432*^9, 3.460317913876012*^9}, {3.4603179946260138`*^9, 
  3.460317994880909*^9}, {3.460318028461433*^9, 3.4603180359232483`*^9}, {
  3.5374878304982758`*^9, 3.537487855625393*^9}, {3.53748801305739*^9, 
  3.537488044943592*^9}, {3.537488108469489*^9, 3.537488111403976*^9}, {
  3.5374883167609386`*^9, 3.537488354940011*^9}, {3.537494360528582*^9, 
  3.537494365432303*^9}, {3.5374953043244743`*^9, 3.5374953101843863`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq1", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq1str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489304806736*^9, 3.537489309341483*^9}, {
   3.5374972785438137`*^9, 3.537497285903635*^9}, {3.537540737136909*^9, 
   3.537540745480649*^9}, 3.5375407900484257`*^9, {3.537541358740419*^9, 
   3.537541372163848*^9}, {3.5375414874019747`*^9, 3.537541501177627*^9}, {
   3.537541543216469*^9, 3.537541545224094*^9}}],

Cell[BoxData["\<\"fvz - (fzz - 4.*hz.*m + 4.*f.*s - 2.*h.*z.*(2.*m.*(2.*s + \
sz.*z) + az.*(1 + s.*power(z,2))) - 2.*a.*(2.*hz.*z.*(1 + s.*power(z,2)) + \
h.*(1 + 5.*s.*power(z,2) + 2.*sz.*power(z,3))) + z.*(2.*fz.*t - 2.*fz.*sv.*z \
- 2.*fv.*sz.*z + 2.*fz.*sz.*z + fzz.*t.*z + fz.*tz.*z + f.*(-2.*sv + tz + \
s.*z.*(4.*t + tz.*z) + 2.*sz.*(1 + t.*power(z,2))) + 2.*fz.*sz.*t.*power(z,3) \
+ s.*(-4.*fv - 4.*hz.*m.*z + fzz.*z.*(1 + t.*power(z,2)) + fz.*(4 + \
6.*t.*power(z,2) + tz.*power(z,3))))).*power(2 + 2.*s.*power(z,2),-1)\"\>"], \
"Output",
 CellChangeTimes->{3.538808034531695*^9, 3.543869558473194*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq2", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq2str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537551719171803*^9, 3.537551720666493*^9}}],

Cell[BoxData["\<\"hvz - (hzz + 4.*fz.*m + 2.*az.*f.*z - 4.*hv.*s.*z + \
4.*hz.*s.*z + 8.*f.*m.*s.*z + 2.*hz.*t.*z + h.*tz.*z - 2.*sv.*z.*(h + hz.*z) \
+ hzz.*s.*power(z,2) + 4.*fz.*m.*s.*power(z,2) - 2.*hv.*sz.*power(z,2) + \
2.*hz.*sz.*power(z,2) + 4.*f.*m.*sz.*power(z,2) + hzz.*t.*power(z,2) + \
hz.*tz.*power(z,2) + 2.*h.*sz.*z.*(1 + t.*power(z,2)) + \
2.*az.*f.*s.*power(z,3) + 6.*hz.*s.*t.*power(z,3) + h.*s.*(4 + \
4.*t.*power(z,2) + tz.*power(z,3)) + 2.*a.*(2.*fz.*z.*(1 + s.*power(z,2)) + \
f.*(1 + 5.*s.*power(z,2) + 2.*sz.*power(z,3))) + hzz.*s.*t.*power(z,4) + \
2.*hz.*sz.*t.*power(z,4) + hz.*s.*tz.*power(z,4)).*power(2 + \
2.*s.*power(z,2),-1)\"\>"], "Output",
 CellChangeTimes->{3.538808034586948*^9, 3.543869558517671*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq3", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq3str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537551722346656*^9, 3.537551723954479*^9}}],

Cell[BoxData["\<\"avz - z.*(-2.*sv.*(a + az.*z) - av.*power(z,-2).*(1 + \
s.*power(z,2)) - 4.*power(z,-2).*(1 + s.*power(z,2)).*(2.*m.*power(f,2) + \
2.*a.*z.*(power(f,2) + power(h,2)) + h.*(fv + 2.*h.*m - fz.*(1 + \
t.*power(z,2))) + f.*(-hv + hz.*(1 + t.*power(z,2))))).*power(1 + \
s.*power(z,2),-1)\"\>"], "Output",
 CellChangeTimes->{3.538808034636338*^9, 3.543869558577878*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq4", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq4str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537551725538599*^9, 3.537551726962449*^9}}],

Cell[BoxData["\<\"svz + (power(z,-4).*(1 + s.*power(z,2)).*(12 + 4.*(2.*t + \
tz.*z).*power(z,2) + 4.*power(f,2).*power(z,2) + 4.*power(h,2).*power(z,2) - \
power(z,4).*power(a + az.*z,2) + 2.*(1 + t.*power(z,2)).*(-6 + \
power(z,2).*power(f + fz.*z,2) + power(z,2).*power(h + hz.*z,2)) - 4.*(2.*s + \
sz.*z).*(-2.*sv.*z + (2.*s + sz.*z).*(1 + \
t.*power(z,2))).*power(z,4).*power(1 + s.*power(z,2),-2) + 16.*(2.*s + \
sz.*z).*power(z,2).*(1 + t.*power(z,2)).*power(1 + s.*power(z,2),-1) - \
4.*(2.*s + sz.*z).*(2.*t + tz.*z).*power(z,4).*power(1 + \
s.*power(z,2),-1)))/8.\"\>"], "Output",
 CellChangeTimes->{3.538808034686864*^9, 3.5438695586296673`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Eq5", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Eq5str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5375517285546923`*^9, 3.537551730078916*^9}}],

Cell[BoxData["\<\"tzz - (-2.*(6.*s - t + power(h,2)) + \
power(a,2).*power(z,2).*power(1 + s.*power(z,2),2) - 2.*power(f,2).*(1 + \
t.*power(z,2)).*power(1 + s.*power(z,2),2) - 2.*f.*z.*(-fv + 2.*hz.*m.*z + \
2.*fz.*(1 + t.*power(z,2))).*power(1 + s.*power(z,2),2) + 2.*a.*(az + \
2.*fz.*h - 2.*f.*hz).*power(z,3).*power(1 + s.*power(z,2),2) - z.*(2.*(-2.*sv \
+ 6.*sz + tz) + 2.*z.*power(h,2).*(t + s.*(2 + s.*power(z,2)).*(1 + \
t.*power(z,2))) + z.*(-(power(az,2).*power(z,2)) + 2.*(-(fv.*fz) - hv.*hz + \
szz + power(hz,2) - sz.*(-2.*sv + sz).*power(z,2) + power(fz,2).*(1 + \
t.*power(z,2)) + t.*z.*(6.*sz + z.*(szz + power(hz,2) - \
power(sz,2).*power(z,2)))) + 2.*s.*(z.*(2.*(sv + sz + tz) + (2.*fz.*(-fv + \
fz) + 2.*hz.*(-hv + hz) + szz).*z - power(az,2).*power(z,3)) + t.*(4 + \
(szz.*z + 2.*(sz + z.*(power(fz,2) + power(hz,2)))).*power(z,3))) + \
power(s,2).*(2.*(2 + (tz + z.*(-(fv.*fz) - hv.*hz + power(fz,2) + \
power(hz,2))).*power(z,3)) - power(az,2).*power(z,6) + 2.*t.*(power(z,2) + \
(power(fz,2) + power(hz,2)).*power(z,6)))) + 2.*h.*(-hv - 2.*fz.*m.*z + \
2.*hz.*(1 + t.*power(z,2))).*power(1 + s.*power(z,2),2))).*power(z + \
s.*power(z,3),-2)\"\>"], "Output",
 CellChangeTimes->{3.538807898663368*^9, 3.538808034774719*^9, 
  3.543869558680262*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Const1", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"C1str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537489304806736*^9, 3.537489309341483*^9}, {
   3.5374972785438137`*^9, 3.537497285903635*^9}, {3.537540737136909*^9, 
   3.537540745480649*^9}, 3.5375407900484257`*^9, {3.537541358740419*^9, 
   3.537541372163848*^9}, {3.5375414874019747`*^9, 3.537541501177627*^9}, {
   3.537541543216469*^9, 3.537541545224094*^9}, {3.538807876854679*^9, 
   3.538807885102872*^9}}],

Cell[BoxData["\<\"szz + (power(z,-2).*(4.*s + 8.*sz.*z + 2.*f.*fz.*z.*(1 + \
s.*power(z,2)) + power(f,2).*(1 + s.*power(z,2)) + (1 + \
s.*power(z,2)).*(power(fz,2).*power(z,2) + power(h + hz.*z,2))))/2.\"\>"], \
"Output",
 CellChangeTimes->{3.53880803482358*^9, 3.54386955872799*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Const2", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"C2str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5388078907580767`*^9, 3.538807892116951*^9}}],

Cell[BoxData["\<\"azz + 2.*(a.*z.*(2.*s + sz.*z) - 2.*(fz.*h - f.*hz).*(1 + \
s.*power(z,2)) + az.*(1 + 3.*s.*power(z,2) + sz.*power(z,3))).*power(z + \
s.*power(z,3),-1)\"\>"], "Output",
 CellChangeTimes->{3.5388080348711023`*^9, 3.5438695587806664`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tmp", "=", 
    RowBox[{"ToString", "[", 
     RowBox[{"CForm", "[", 
      RowBox[{
       RowBox[{"Const3", "//.", "repl"}], "//.", 
       RowBox[{"{", 
        RowBox[{"Power", "\[Rule]", "power"}], "}"}]}], "]"}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"C3str", "=", 
  RowBox[{"StringReplace", "[", 
   RowBox[{"tmp", ",", 
    RowBox[{"\"\<*\>\"", "->", "\"\<.*\>\""}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.538807893564623*^9, 3.538807895276726*^9}}],

Cell[BoxData["\<\"svv + ((-4.*(-8.*s + t) + 6.*power(h,2) + \
power(a,2).*power(z,2).*(-1 + (-t + 16.*(power(f,2) + \
power(h,2))).*power(z,2)).*power(1 + s.*power(z,2),2) - 4.*f.*z.*(4.*hv.*m.*z \
- (1 + t.*power(z,2)).*(-fv + 2.*hz.*m.*z + fz.*(1 + \
t.*power(z,2)))).*power(1 + s.*power(z,2),2) + 2.*power(f,2).*(3 + \
power(z,2).*(8.*power(m,2) + t.*(4 + t.*power(z,2)))).*power(1 + \
s.*power(z,2),2) + 2.*a.*(16.*m.*power(f,2) - az.*(1 + t.*power(z,2)) + \
4.*h.*(2.*fv + 4.*h.*m - fz.*(1 + t.*power(z,2))) + 4.*f.*(-2.*hv + hz.*(1 + \
t.*power(z,2)))).*power(z,3).*power(1 + s.*power(z,2),2) + z.*(4.*(-4.*sv + \
4.*sz + tv + tz) + 4.*h.*(2.*m.*z.*(2.*fv - fz.*(1 + t.*power(z,2))) + (1 + \
t.*power(z,2)).*(-hv + hz.*(1 + t.*power(z,2)))).*power(1 + s.*power(z,2),2) \
+ 2.*z.*power(h,2).*(3.*s.*(2 + s.*power(z,2)) + 4.*t.*power(1 + \
s.*power(z,2),2) + 8.*power(m,2).*power(1 + s.*power(z,2),2) + \
power(t,2).*power(z,2).*power(1 + s.*power(z,2),2)) + z.*(2.*(-2.*fv.*fz - \
2.*hv.*hz + power(fz,2) + 2.*(power(fv,2) + power(hv,2)) + power(hz,2)) - \
(power(az,2) + 4.*(-(sv.*tz) + sz.*(-2.*sv + tv + tz) + \
power(sz,2))).*power(z,2) - t.*z.*(power(az,2).*power(z,3) + 4.*(2.*sv - tz + \
fv.*fz.*z + hv.*hz.*z - z.*power(fz,2) - z.*power(hz,2) + sz.*(-6 + (-2.*sv + \
2.*sz + tz).*power(z,3)))) + power(s,2).*(16 - power(z,3).*(4.*(tv + tz) - \
2.*z.*(-2.*fv.*fz - 2.*hv.*hz + power(fz,2) + 2.*(power(fv,2) + power(hv,2)) \
+ power(hz,2)) + power(az,2).*power(z,3)) + 2.*power(t,2).*power(z,4).*(-2 + \
(power(fz,2) + power(hz,2)).*power(z,4)) - t.*power(z,2).*(4.*(-3 + (tz + \
fv.*fz.*z + (hv - hz).*hz.*z - z.*power(fz,2)).*power(z,3)) + \
power(az,2).*power(z,6))) + s.*(-2.*power(z,2).*(-2.*(-2.*fv.*fz - 2.*hv.*hz \
+ power(fz,2) + 2.*(power(fv,2) + power(hv,2)) + power(hz,2)) + (-2.*sv.*tz + \
2.*sz.*(tv + tz) + power(az,2)).*power(z,2)) + 4.*power(t,2).*power(z,2).*(2 \
+ (-2.*sz + z.*(power(fz,2) + power(hz,2))).*power(z,3)) - 2.*t.*(-20 + \
2.*power(z,3).*(-2.*sv + 2.*fv.*fz.*z + 2.*hv.*hz.*z - 2.*z.*power(fz,2) - \
2.*z.*power(hz,2) + sz.*(2 + tz.*power(z,3))) + power(az,2).*power(z,6))) + \
2.*power(t,2).*(power(fz,2).*power(z,4) + power(hz,2).*power(z,4) - \
2.*power(-1 + sz.*power(z,3),2))))).*power(power(z,2) + s.*power(z,4),-1))/8.\
\"\>"], "Output",
 CellChangeTimes->{
  3.538808034920526*^9, {3.543869558818266*^9, 3.543869572823771*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<~/Work/AdSCMTDyn2/matlab/eqn.text\>\"", ",", 
   RowBox[{
   "\"\<\\n\\neq1 = \>\"", "<>", "Eq1str", "<>", "\"\< ; \\n\\neq2 = \>\"", "<>",
     "Eq2str", "<>", "\"\< ; \\n\\neq3 = \>\"", "<>", "Eq3str", "<>", 
    "\"\< ; \\n\\neq4 = \>\"", "<>", "Eq4str", "<>", 
    "\"\< ; \\n\\neq5 = \>\"", "<>", "Eq5str", "<>", 
    "\"\< ; \\n\\nconst1 = \>\"", "<>", "C1str", "<>", 
    "\"\< ; \\n\\nconst2 = \>\"", "<>", "C2str", "<>", 
    "\"\< ; \\n\\nconst3 = \>\"", "<>", "C3str", "<>", "\"\< ; \\n\\n\>\""}], 
   ",", "\"\<string\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.537499515937183*^9, 3.5374995738978567`*^9}, 
   3.538808081344832*^9}],

Cell[BoxData["\<\"~/Work/AdSCMTDyn2/matlab/eqn.text\"\>"], "Output",
 CellChangeTimes->{3.538808035236641*^9, 3.538808081883874*^9, 
  3.543869559068722*^9, 3.543869597832314*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"\[Sigma]", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"f2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"f3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"f4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"f5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"h2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"h3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"h4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"h5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"a1", "[", "v", "]"}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"a2", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"a3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"a4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{"a5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"t", "[", 
     RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{"t3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"t4", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{"t5", "[", "v", "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"v_", ",", "z_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "4"]}], " ", 
     SuperscriptBox[
      RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], " ", "+", 
    RowBox[{"z", " ", 
     RowBox[{"s3", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "2"}], " ", 
     RowBox[{"s4", "[", "v", "]"}]}], "+", 
    RowBox[{
     RowBox[{"z", "^", "3"}], " ", 
     RowBox[{"s5", "[", "v", "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5375807547496643`*^9, 3.5375809546462297`*^9}, {
   3.5375810316510153`*^9, 3.5375810327382927`*^9}, 3.537581219874021*^9, {
   3.537581535999511*^9, 3.537581540295803*^9}, {3.537581711272689*^9, 
   3.537581738881206*^9}, 3.537582147695653*^9, {3.537582192382326*^9, 
   3.5375821924540586`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq3", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq4", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Eq5", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const1", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{"Const2", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"Const3", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5375809932541857`*^9, 3.537581041069994*^9}, {
  3.5375810809508543`*^9, 3.537581091428672*^9}, {3.537581792470584*^9, 
  3.53758183798702*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"f3", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"m", "[", "v", "]"}]}], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], "2"], "+", 
     RowBox[{
      SuperscriptBox["f2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {-$CellContext`f3[$CellContext`v] + 
    2 $CellContext`h2[$CellContext`v] $CellContext`m[$CellContext`v] + 
    Rational[1, 2] $CellContext`\[Sigma][$CellContext`v]^3 + 
    Derivative[1][$CellContext`f2][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869616916765*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"h3", "[", "v", "]"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"m", "[", "v", "]"}]}], "-", 
     RowBox[{
      RowBox[{"a1", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["h2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {-$CellContext`h3[$CellContext`v] - 
    2 $CellContext`f2[$CellContext`v] $CellContext`m[$CellContext`v] - \
$CellContext`a1[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] + 
    Derivative[1][$CellContext`h2][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696169451714`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{"m", "[", "v", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["a1", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   4 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] + 
    8 $CellContext`m[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]^2 + 
    Derivative[1][$CellContext`a1][$CellContext`v]}, -1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869617037754*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"6", " ", 
      RowBox[{"s3", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   6 $CellContext`s3[$CellContext`v] + 
    2 $CellContext`f2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]}, \
-1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869617073896*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"24", " ", 
      RowBox[{"s3", "[", "v", "]"}]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   24 $CellContext`s3[$CellContext`v] + 
    8 $CellContext`f2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]}, \
-1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696171736937`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"6", " ", 
      RowBox[{"s3", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   6 $CellContext`s3[$CellContext`v] + 
    2 $CellContext`f2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]}, \
-1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869617209673*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"a2", "[", "v", "]"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   2 $CellContext`a2[$CellContext`v] + 
    4 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]}, \
-1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869617211643*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"6", " ", 
      RowBox[{"s3", "[", "v", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], "z"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "0"],
    SeriesData[$CellContext`z, 0, {}, -1, 0, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   6 $CellContext`s3[$CellContext`v] + 
    2 $CellContext`f2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]}, \
-1, 0, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869617369156*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"repl1", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a1", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"a2", "[", "v", "]"}], ",", 
        RowBox[{"f3", "[", "v", "]"}], ",", 
        RowBox[{"h3", "[", "v", "]"}], ",", 
        RowBox[{"s3", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537581094869306*^9, 3.5375811411847267`*^9}, {
  3.537581846545319*^9, 3.5375818604809847`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a1", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h2", "[", "v", "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"a2", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"h2", "[", "v", "]"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"f3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"m", "[", "v", "]"}]}], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], "2"], "+", 
     RowBox[{
      SuperscriptBox["f2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"h3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"m", "[", "v", "]"}]}], "-", 
     RowBox[{
      RowBox[{"a1", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["h2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"s3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "3"]}], " ", 
     RowBox[{"f2", "[", "v", "]"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.543869623767411*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"repl", "=", 
    RowBox[{"Join", "[", " ", 
     RowBox[{"repl1", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl1", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq5", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "/.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Const3", "/.", "repl"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537581149514593*^9, 3.5375811704734163`*^9}, {
  3.537581319335538*^9, 3.537581326214385*^9}, {3.53758187837607*^9, 
  3.5375818960440483`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       RowBox[{"f4", "[", "v", "]"}]}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"h2", "[", "v", "]"}]}], "-", 
      RowBox[{"8", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"m", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
      RowBox[{
       FractionBox["5", "2"], " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"8", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["m", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-3) $CellContext`f4[$CellContext`v] + 
    3 $CellContext`a1[$CellContext`v] $CellContext`h2[$CellContext`v] - 
    8 $CellContext`f2[$CellContext`v] $CellContext`m[$CellContext`v]^2 - 
    4 $CellContext`a1[$CellContext`v] $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    Rational[-1, 
       2] $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    Rational[5, 
       2] $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
    8 $CellContext`m[$CellContext`v] 
     Derivative[1][$CellContext`h2][$CellContext`v] + 
    4 $CellContext`h2[$CellContext`v] 
     Derivative[1][$CellContext`m][$CellContext`v] + 
    2 $CellContext`\[Sigma][$CellContext`v]^2 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
    2 Derivative[2][$CellContext`f2][$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696247551517`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"f2", "[", "v", "]"}]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{"h4", "[", "v", "]"}]}], "-", 
      RowBox[{"8", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"m", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{
       FractionBox["11", "2"], " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{
       RowBox[{"m", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["a1", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"8", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["m", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-3) $CellContext`a1[$CellContext`v] $CellContext`f2[$CellContext`v] - 
    3 $CellContext`h4[$CellContext`v] - 
    8 $CellContext`h2[$CellContext`v] $CellContext`m[$CellContext`v]^2 + 
    Rational[11, 
       2] $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 - 
    2 $CellContext`\[Sigma][$CellContext`v] 
    Derivative[1][$CellContext`a1][$CellContext`v] - 
    8 $CellContext`m[$CellContext`v] 
    Derivative[1][$CellContext`f2][$CellContext`v] - 
    4 $CellContext`f2[$CellContext`v] 
    Derivative[1][$CellContext`m][$CellContext`v] - 
    2 $CellContext`a1[$CellContext`v] 
    Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
    2 Derivative[2][$CellContext`h2][$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869624794153*^9}],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "z", "]"}], "1"],
  SeriesData[$CellContext`z, 0, {}, 1, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869624916916*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "8"]}], " ", 
      SuperscriptBox[
       RowBox[{"a1", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"9", " ", 
         SuperscriptBox[
          RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox[
          RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"48", " ", 
         RowBox[{"s4", "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"t4", "[", "v", "]"}]}], "+", 
        RowBox[{"30", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"m", "[", "v", "]"}], " ", 
         RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "+", 
        RowBox[{"13", " ", 
         RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"f2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Sigma]", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ")"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[-1, 8] $CellContext`a1[$CellContext`v]^2 + 
    Rational[1, 6] (9 $CellContext`f2[$CellContext`v]^2 + 
      9 $CellContext`h2[$CellContext`v]^2 + 
      48 $CellContext`s4[$CellContext`v] + 3 $CellContext`t4[$CellContext`v] + 
      30 $CellContext`h2[$CellContext`v] $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
      6 $CellContext`\[Sigma][$CellContext`v]^4 + 
      13 $CellContext`\[Sigma][$CellContext`v] 
       Derivative[1][$CellContext`f2][$CellContext`v] - 
      2 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v])}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869624961972*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"a1", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"40", " ", 
      RowBox[{"s4", "[", "v", "]"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"t4", "[", "v", "]"}]}], "+", 
     RowBox[{"28", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"m", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     FractionBox[
      RowBox[{"21", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "4"], "+", 
     RowBox[{
      FractionBox["34", "3"], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f2", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}], "-", 
     RowBox[{
      FractionBox["8", "3"], " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["\[Sigma]", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {-$CellContext`a1[$CellContext`v]^2 + 
    8 $CellContext`f2[$CellContext`v]^2 + 8 $CellContext`h2[$CellContext`v]^2 + 
    40 $CellContext`s4[$CellContext`v] + 4 $CellContext`t4[$CellContext`v] + 
    28 $CellContext`h2[$CellContext`v] $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    Rational[21, 4] $CellContext`\[Sigma][$CellContext`v]^4 + 
    Rational[34, 3] $CellContext`\[Sigma][$CellContext`v] 
     Derivative[1][$CellContext`f2][$CellContext`v] + 
    Rational[-8, 3] $CellContext`f2[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869625149252*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{"12", " ", 
      RowBox[{"s4", "[", "v", "]"}]}], "+", 
     RowBox[{"6", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"m", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     FractionBox[
      RowBox[{"11", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "8"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{
       SuperscriptBox["f2", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   2 $CellContext`f2[$CellContext`v]^2 + 2 $CellContext`h2[$CellContext`v]^2 + 
    12 $CellContext`s4[$CellContext`v] + 
    6 $CellContext`h2[$CellContext`v] $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    Rational[11, 8] $CellContext`\[Sigma][$CellContext`v]^4 + 
    3 $CellContext`\[Sigma][$CellContext`v] 
     Derivative[1][$CellContext`f2][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869625191354*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"6", " ", 
      RowBox[{"a3", "[", "v", "]"}]}], "+", 
     RowBox[{
      RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "16"}], " ", 
         RowBox[{"f2", "[", "v", "]"}], " ", 
         RowBox[{"m", "[", "v", "]"}]}], "-", 
        RowBox[{"9", " ", 
         RowBox[{"a1", "[", "v", "]"}], " ", 
         RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
        RowBox[{"8", " ", 
         RowBox[{
          SuperscriptBox["h2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ")"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   6 $CellContext`a3[$CellContext`v] + $CellContext`\[Sigma][$CellContext`v] \
((-16) $CellContext`f2[$CellContext`v] $CellContext`m[$CellContext`v] - 
      9 $CellContext`a1[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] + 
      8 Derivative[1][$CellContext`h2][$CellContext`v])}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696251931667`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "8"]}], " ", 
      SuperscriptBox[
       RowBox[{"a1", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"9", " ", 
         SuperscriptBox[
          RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox[
          RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"48", " ", 
         RowBox[{"s4", "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{"t4", "[", "v", "]"}]}], "+", 
        RowBox[{"36", " ", 
         RowBox[{"h2", "[", "v", "]"}], " ", 
         RowBox[{"m", "[", "v", "]"}], " ", 
         RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox[
          RowBox[{"m", "[", "v", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox[
          RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "+", 
        RowBox[{"16", " ", 
         RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["f2", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "+", 
        RowBox[{"3", " ", 
         RowBox[{
          SuperscriptBox["t3", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"f2", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Sigma]", "\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
         RowBox[{
          SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ")"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[-1, 8] $CellContext`a1[$CellContext`v]^2 + 
    Rational[1, 6] (9 $CellContext`f2[$CellContext`v]^2 + 
      9 $CellContext`h2[$CellContext`v]^2 + 
      48 $CellContext`s4[$CellContext`v] + 3 $CellContext`t4[$CellContext`v] + 
      36 $CellContext`h2[$CellContext`v] $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
      12 $CellContext`m[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v]^2 + 
      6 $CellContext`\[Sigma][$CellContext`v]^4 + 
      16 $CellContext`\[Sigma][$CellContext`v] 
       Derivative[1][$CellContext`f2][$CellContext`v] + 
      3 Derivative[1][$CellContext`t3][$CellContext`v] - 
      2 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 
      3 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`\[Sigma]][$CellContext`v])}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869625484974*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"repl2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"t3", "'"}], "[", "v", "]"}], ",", 
        RowBox[{"a3", "[", "v", "]"}], ",", 
        RowBox[{"t4", "[", "v", "]"}], ",", 
        RowBox[{"s4", "[", "v", "]"}], ",", 
        RowBox[{"h4", "[", "v", "]"}], ",", 
        RowBox[{"f4", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537581176657216*^9, 3.537581176712451*^9}, {
  3.537581208479423*^9, 3.5375812350544767`*^9}, {3.537581285831032*^9, 
  3.537581335172854*^9}, {3.537581579672551*^9, 3.537581582928306*^9}, {
  3.537581907656845*^9, 3.537581928696844*^9}, {3.53758196021669*^9, 
  3.537581962015414*^9}, {3.537582000083522*^9, 3.537582009971553*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t3", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"m", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], "-", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"a3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"16", " ", 
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}]}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"t4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"a1", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"12", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], "+", 
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"s4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "96"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox[
         RowBox[{"f2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox[
         RowBox[{"h2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"48", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
       RowBox[{"11", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"h4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox[
            RowBox[{"m", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"11", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"f2", "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["a1", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], "+", 
             RowBox[{"8", " ", 
              RowBox[{
               SuperscriptBox["f2", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["m", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"f4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"t3", "[", "v", "]"}]}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           RowBox[{"h2", "[", "v", "]"}]}], "-", 
          RowBox[{"8", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox[
            RowBox[{"m", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "+", 
       RowBox[{"16", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["m", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.543869626109274*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"repl", "=", 
    RowBox[{"Join", "[", " ", 
     RowBox[{"repl1", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl1", ",", "v"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl1", ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "2"}], "}"}]}], "]"}], ",", "repl2", ",", 
      RowBox[{"D", "[", 
       RowBox[{"repl2", ",", "v"}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq1", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp2", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq2", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq3", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp4", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq4", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp5", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Eq5", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp6", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const1", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmp7", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"Const2", "//.", "repl"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tmp8", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Const3", "//.", "repl"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.537581149514593*^9, 3.5375811704734163`*^9}, {
  3.537581319335538*^9, 3.537581326214385*^9}, {3.53758187837607*^9, 
  3.5375818960440483`*^9}, {3.537582027350095*^9, 3.537582048852798*^9}, {
  3.537582117159115*^9, 3.537582123535061*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       RowBox[{"f5", "[", "v", "]"}]}], "-", 
      RowBox[{
       FractionBox["21", "4"], " ", 
       SuperscriptBox[
        RowBox[{"a1", "[", "v", "]"}], "2"], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          RowBox[{"f2", "[", "v", "]"}], " ", 
          RowBox[{"m", "[", "v", "]"}]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["h2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{
          RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
          RowBox[{
           SuperscriptBox["m", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"m", "[", "v", "]"}], " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox[
           RowBox[{"f2", "[", "v", "]"}], "2"], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
         RowBox[{"38", " ", 
          SuperscriptBox[
           RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox[
           RowBox[{"m", "[", "v", "]"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "5"]}], "-", 
         RowBox[{"48", " ", 
          SuperscriptBox[
           RowBox[{"m", "[", "v", "]"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"13", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"24", " ", 
          RowBox[{
           SuperscriptBox["h2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}], " ", 
          RowBox[{
           SuperscriptBox["m", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "-", 
         RowBox[{
          RowBox[{"t3", "[", "v", "]"}], " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}], "2"]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"f2", "[", "v", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"t3", "[", "v", "]"}], "+", 
            RowBox[{"12", " ", 
             RowBox[{"m", "[", "v", "]"}], " ", 
             RowBox[{
              SuperscriptBox["m", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}]}], "-", 
            RowBox[{
             RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
             RowBox[{
              SuperscriptBox["\[Sigma]", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"24", " ", 
          RowBox[{"m", "[", "v", "]"}], " ", 
          RowBox[{
           SuperscriptBox["h2", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{
          RowBox[{"h2", "[", "v", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "32"}], " ", 
             SuperscriptBox[
              RowBox[{"m", "[", "v", "]"}], "3"]}], "+", 
            RowBox[{"58", " ", 
             RowBox[{"m", "[", "v", "]"}], " ", 
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
            RowBox[{"8", " ", 
             RowBox[{
              SuperscriptBox["m", "\[Prime]\[Prime]",
               MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{
           SuperscriptBox["f2", 
            TagBox[
             RowBox[{"(", "3", ")"}],
             Derivative],
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ")"}], 
    " ", 
    SuperscriptBox["z", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-6) $CellContext`f5[$CellContext`v] + 
    Rational[-21, 
       4] $CellContext`a1[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] - 
    4 $CellContext`a1[$CellContext`v] (
     4 $CellContext`f2[$CellContext`v] $CellContext`m[$CellContext`v] - 2 
     Derivative[
      1][$CellContext`h2][$CellContext`v] + \
$CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`m][$CellContext`v] + 
     2 $CellContext`m[$CellContext`v] 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v]) + 
    Rational[1, 2] (
      6 $CellContext`f2[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] - 
      38 $CellContext`h2[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] + 
      128 $CellContext`m[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v]^3 + 
      4 $CellContext`\[Sigma][$CellContext`v]^5 - 
      48 $CellContext`m[$CellContext`v]^2 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
      13 $CellContext`\[Sigma][$CellContext`v]^2 
       Derivative[1][$CellContext`f2][$CellContext`v] + 
      24 Derivative[1][$CellContext`h2][$CellContext`v] 
       Derivative[
        1][$CellContext`m][$CellContext`v] - $CellContext`t3[$CellContext`v] 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
      8 $CellContext`\[Sigma][$CellContext`v] 
       Derivative[1][$CellContext`\[Sigma]][$CellContext`v]^2 - 
      4 $CellContext`f2[$CellContext`v] ($CellContext`t3[$CellContext`v] + 
       12 $CellContext`m[$CellContext`v] 
        Derivative[
         1][$CellContext`m][$CellContext`v] - \
$CellContext`\[Sigma][$CellContext`v] 
       Derivative[1][$CellContext`\[Sigma]][$CellContext`v]) + 
      24 $CellContext`m[$CellContext`v] 
       Derivative[
        2][$CellContext`h2][$CellContext`v] + $CellContext`h2[$CellContext`v] \
((-32) $CellContext`m[$CellContext`v]^3 + 
        58 $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
        8 Derivative[2][$CellContext`m][$CellContext`v]) + 
      3 $CellContext`\[Sigma][$CellContext`v]^2 
       Derivative[2][$CellContext`\[Sigma]][$CellContext`v] + 
      4 Derivative[3][$CellContext`f2][$CellContext`v])}, 2, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627226324*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       RowBox[{"h5", "[", "v", "]"}]}], "+", 
      RowBox[{"16", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"m", "[", "v", "]"}], "3"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"t3", "[", "v", "]"}]}], "+", 
      RowBox[{"22", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
      RowBox[{
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox[
        RowBox[{"m", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"24", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["m", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"15", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["m", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"12", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["m", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"34", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"57", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"12", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["m", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          RowBox[{"h2", "[", "v", "]"}], " ", 
          RowBox[{"m", "[", "v", "]"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox[
           RowBox[{"m", "[", "v", "]"}], "2"], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["h2", 
         TagBox[
          RowBox[{"(", "3", ")"}],
          Derivative],
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", 
    SuperscriptBox["z", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 2, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-6) $CellContext`h5[$CellContext`v] + 
    16 $CellContext`f2[$CellContext`v] $CellContext`m[$CellContext`v]^3 - 
    2 $CellContext`h2[$CellContext`v] $CellContext`t3[$CellContext`v] + 
    22 $CellContext`f2[$CellContext`v] $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + $CellContext`m[$CellContext`v] \
$CellContext`t3[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] + 
    8 $CellContext`f2[$CellContext`v] $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - 24 $CellContext`m[$CellContext`v]^2 
    Derivative[1][$CellContext`h2][$CellContext`v] + 
    20 $CellContext`\[Sigma][$CellContext`v]^2 
     Derivative[1][$CellContext`h2][$CellContext`v] - 
    24 $CellContext`h2[$CellContext`v] $CellContext`m[$CellContext`v] 
    Derivative[1][$CellContext`m][$CellContext`v] + 
    15 $CellContext`\[Sigma][$CellContext`v]^3 
     Derivative[1][$CellContext`m][$CellContext`v] - 12 
    Derivative[1][$CellContext`f2][$CellContext`v] 
    Derivative[1][$CellContext`m][$CellContext`v] + 
    34 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
    57 $CellContext`m[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]^2 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 
    12 $CellContext`m[$CellContext`v] 
    Derivative[2][$CellContext`f2][$CellContext`v] - 
    4 $CellContext`f2[$CellContext`v] 
    Derivative[
     2][$CellContext`m][$CellContext`v] - $CellContext`a1[$CellContext`v] (
     16 $CellContext`h2[$CellContext`v] $CellContext`m[$CellContext`v] - 
     8 $CellContext`m[$CellContext`v]^2 $CellContext`\[Sigma][$CellContext`v] + 
     9 $CellContext`\[Sigma][$CellContext`v]^3 + 
     8 Derivative[1][$CellContext`f2][$CellContext`v] + 
     2 Derivative[2][$CellContext`\[Sigma]][$CellContext`v]) + 
    2 Derivative[3][$CellContext`h2][$CellContext`v]}, 2, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627293709*^9}],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "z", "]"}], "2"],
  SeriesData[$CellContext`z, 0, {}, 2, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869627603525*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"60", " ", 
       RowBox[{"s5", "[", "v", "]"}]}], "+", 
      RowBox[{"6", " ", 
       RowBox[{"t5", "[", "v", "]"}]}], "-", 
      RowBox[{"48", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"m", "[", "v", "]"}], "2"], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"24", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"19", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
      RowBox[{"20", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"20", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"42", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["m", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"6", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"9", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 6] (60 $CellContext`s5[$CellContext`v] + 
     6 $CellContext`t5[$CellContext`v] - 
     48 $CellContext`f2[$CellContext`v] $CellContext`m[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] - 
     24 $CellContext`a1[$CellContext`v] $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - 
     3 $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
     19 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 + 
     20 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
     20 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     42 $CellContext`m[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     18 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`m][$CellContext`v] - 
     6 $CellContext`h2[$CellContext`v] $CellContext`m[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     8 $CellContext`\[Sigma][$CellContext`v]^3 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 3 
     Derivative[1][$CellContext`f2][$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     9 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.5438696276903257`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"180", " ", 
       RowBox[{"s5", "[", "v", "]"}]}], "+", 
      RowBox[{"30", " ", 
       RowBox[{"t5", "[", "v", "]"}]}], "+", 
      RowBox[{"12", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"176", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"m", "[", "v", "]"}], "2"], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"88", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"11", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"61", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
      RowBox[{"64", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"64", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"146", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"58", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["m", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"30", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"15", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"29", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 3] (180 $CellContext`s5[$CellContext`v] + 
     30 $CellContext`t5[$CellContext`v] + 
     12 $CellContext`a1[$CellContext`v] $CellContext`h2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] - 
     176 $CellContext`f2[$CellContext`v] $CellContext`m[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] - 
     88 $CellContext`a1[$CellContext`v] $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - 
     11 $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
     61 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 + 
     64 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
     64 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     146 $CellContext`m[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     58 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`m][$CellContext`v] - 
     30 $CellContext`h2[$CellContext`v] $CellContext`m[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     24 $CellContext`\[Sigma][$CellContext`v]^3 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 15 
     Derivative[1][$CellContext`f2][$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     29 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869628055613*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"60", " ", 
       RowBox[{"s5", "[", "v", "]"}]}], "-", 
      RowBox[{"32", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"m", "[", "v", "]"}], "2"], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"17", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"h2", "[", "v", "]"}]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{"m", "[", "v", "]"}], " ", 
          RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"32", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"16", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["m", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 3] (60 $CellContext`s5[$CellContext`v] - 
     32 $CellContext`f2[$CellContext`v] $CellContext`m[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] - 
     2 $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
     17 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 - 
     2 $CellContext`a1[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] (
      3 $CellContext`h2[$CellContext`v] + 
      8 $CellContext`m[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]) + 
     18 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
     18 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     32 $CellContext`m[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     16 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`m][$CellContext`v] + 
     8 $CellContext`\[Sigma][$CellContext`v]^3 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     8 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869628108027*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "6"}], " ", 
        RowBox[{"a4", "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"f2", "[", "v", "]"}], "2"], " ", 
        RowBox[{"m", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           RowBox[{"a1", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["m", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
           RowBox[{"m", "[", "v", "]"}]}], "+", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"8", " ", 
              SuperscriptBox[
               RowBox[{"m", "[", "v", "]"}], "2"], " ", 
              RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
             RowBox[{"14", " ", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
             RowBox[{
              SuperscriptBox["f2", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "15"}], " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
             RowBox[{"8", " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["f2", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"a1", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["\[Sigma]", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["h2", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
         ")"}]}]}], ")"}], " ", "z"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {(-2) ((-6) $CellContext`a4[$CellContext`v] + 
     4 $CellContext`f2[$CellContext`v]^2 $CellContext`m[$CellContext`v] + \
$CellContext`f2[$CellContext`v] (
       9 $CellContext`a1[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] - 2 
       Derivative[1][$CellContext`h2][$CellContext`v] + 
       8 $CellContext`\[Sigma][$CellContext`v] 
        Derivative[1][$CellContext`m][$CellContext`v]) + 
     2 (2 $CellContext`h2[$CellContext`v]^2 $CellContext`m[$CellContext`v] + \
$CellContext`h2[$CellContext`v] (
         8 $CellContext`m[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] - 
         14 $CellContext`\[Sigma][$CellContext`v]^3 + 
         Derivative[
          1][$CellContext`f2][$CellContext`v]) + \
$CellContext`\[Sigma][$CellContext`v] ((-15) $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 + 
         8 $CellContext`m[$CellContext`v] 
          Derivative[1][$CellContext`f2][$CellContext`v] + 
         2 $CellContext`a1[$CellContext`v] 
          Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 2 
         Derivative[2][$CellContext`h2][$CellContext`v])))}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869628164772*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"60", " ", 
       RowBox[{"s5", "[", "v", "]"}]}], "+", 
      RowBox[{"6", " ", 
       RowBox[{"t5", "[", "v", "]"}]}], "-", 
      RowBox[{"48", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"m", "[", "v", "]"}], "2"], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
      RowBox[{"24", " ", 
       RowBox[{"a1", "[", "v", "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{"t3", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{"19", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
      RowBox[{"20", " ", 
       RowBox[{"f2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"20", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"42", " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["h2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["m", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"6", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{"9", " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 6] (60 $CellContext`s5[$CellContext`v] + 
     6 $CellContext`t5[$CellContext`v] - 
     48 $CellContext`f2[$CellContext`v] $CellContext`m[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v] - 
     24 $CellContext`a1[$CellContext`v] $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 - 
     3 $CellContext`t3[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^2 + 
     19 $CellContext`f2[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v]^3 + 
     20 $CellContext`f2[$CellContext`v] 
      Derivative[1][$CellContext`f2][$CellContext`v] + 
     20 $CellContext`h2[$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     42 $CellContext`m[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`h2][$CellContext`v] + 
     18 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] 
      Derivative[1][$CellContext`m][$CellContext`v] - 
     6 $CellContext`h2[$CellContext`v] $CellContext`m[$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     8 $CellContext`\[Sigma][$CellContext`v]^3 
      Derivative[1][$CellContext`\[Sigma]][$CellContext`v] - 3 
     Derivative[1][$CellContext`f2][$CellContext`v] 
     Derivative[1][$CellContext`\[Sigma]][$CellContext`v] + 
     9 $CellContext`\[Sigma][$CellContext`v] 
      Derivative[2][$CellContext`f2][$CellContext`v])}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.543869628702529*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"repl3", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tmp1", ",", "tmp2", ",", "tmp3", ",", "tmp4", ",", "tmp5", ",", 
         "tmp6", ",", "tmp7", ",", "tmp8"}], "}"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a4", "[", "v", "]"}], ",", 
        RowBox[{"t5", "[", "v", "]"}], ",", 
        RowBox[{"s5", "[", "v", "]"}], ",", 
        RowBox[{"h5", "[", "v", "]"}], ",", 
        RowBox[{"f5", "[", "v", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.537581176657216*^9, 3.537581176712451*^9}, {
  3.537581208479423*^9, 3.5375812350544767`*^9}, {3.537581285831032*^9, 
  3.537581335172854*^9}, {3.537581579672551*^9, 3.537581582928306*^9}, {
  3.537581907656845*^9, 3.537581928696844*^9}, {3.53758196021669*^9, 
  3.537581962015414*^9}, {3.537582000083522*^9, 3.537582009971553*^9}, {
  3.537582054866674*^9, 3.537582086618279*^9}, {3.5375821613248863`*^9, 
  3.5375822160917*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"f2", "[", "v", "]"}], "2"], " ", 
        RowBox[{"m", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           RowBox[{"a1", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["m", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
           RowBox[{"m", "[", "v", "]"}]}], "+", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"8", " ", 
              SuperscriptBox[
               RowBox[{"m", "[", "v", "]"}], "2"], " ", 
              RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
             RowBox[{"14", " ", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
             RowBox[{
              SuperscriptBox["f2", "\[Prime]",
               MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "15"}], " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
             RowBox[{"8", " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["f2", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"a1", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["\[Sigma]", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "-", 
             RowBox[{"2", " ", 
              RowBox[{
               SuperscriptBox["h2", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"t5", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"t3", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "6"}], " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox[
            RowBox[{"m", "[", "v", "]"}], "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], "-", 
          RowBox[{
           SuperscriptBox["f2", "\[Prime]",
            MultilineFunction->None], "[", "v", "]"}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"10", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["m", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"6", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"s5", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "60"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"h2", "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"32", " ", 
           SuperscriptBox[
            RowBox[{"m", "[", "v", "]"}], "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"17", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "-", 
          RowBox[{"18", " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"t3", "[", "v", "]"}]}], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"9", " ", 
              RowBox[{
               SuperscriptBox["h2", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "+", 
             RowBox[{"8", " ", 
              RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["m", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["h2", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "+", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
              RowBox[{
               SuperscriptBox["\[Sigma]", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "+", 
             RowBox[{
              SuperscriptBox["f2", "\[Prime]\[Prime]",
               MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"h5", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"t3", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"t3", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
       RowBox[{"24", " ", 
        SuperscriptBox[
         RowBox[{"m", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"20", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["m", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"15", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], " ", 
        RowBox[{
         SuperscriptBox["m", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"12", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["m", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"34", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"57", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "-", 
       RowBox[{"12", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox[
            RowBox[{"m", "[", "v", "]"}], "3"]}], "+", 
          RowBox[{"11", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["m", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"m", "[", "v", "]"}]}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox[
            RowBox[{"m", "[", "v", "]"}], "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
          RowBox[{"8", " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["h2", 
          TagBox[
           RowBox[{"(", "3", ")"}],
           Derivative],
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"f5", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "21"}], " ", 
        SuperscriptBox[
         RowBox[{"a1", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
       RowBox[{"16", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{"m", "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["m", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           SuperscriptBox[
            RowBox[{"f2", "[", "v", "]"}], "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
          RowBox[{"38", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox[
            RowBox[{"m", "[", "v", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "3"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "5"]}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox[
            RowBox[{"m", "[", "v", "]"}], "2"], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"13", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"24", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["m", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{
           RowBox[{"t3", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"8", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["\[Sigma]", "\[Prime]",
              MultilineFunction->None], "[", "v", "]"}], "2"]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"t3", "[", "v", "]"}], "+", 
             RowBox[{"12", " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["m", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}], "-", 
             RowBox[{
              RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
              RowBox[{
               SuperscriptBox["\[Sigma]", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
          RowBox[{"24", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "32"}], " ", 
              SuperscriptBox[
               RowBox[{"m", "[", "v", "]"}], "3"]}], "+", 
             RowBox[{"58", " ", 
              RowBox[{"m", "[", "v", "]"}], " ", 
              SuperscriptBox[
               RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
             RowBox[{"8", " ", 
              RowBox[{
               SuperscriptBox["m", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{
            SuperscriptBox["f2", 
             TagBox[
              RowBox[{"(", "3", ")"}],
              Derivative],
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.543869628925858*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["repl1"], "Input",
 CellChangeTimes->{{3.543869696875413*^9, 3.5438697003191147`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a1", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h2", "[", "v", "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"a2", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     RowBox[{"h2", "[", "v", "]"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"f3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"m", "[", "v", "]"}]}], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], "2"], "+", 
     RowBox[{
      SuperscriptBox["f2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"h3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"f2", "[", "v", "]"}], " ", 
      RowBox[{"m", "[", "v", "]"}]}], "-", 
     RowBox[{
      RowBox[{"a1", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["h2", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"s3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "3"]}], " ", 
     RowBox[{"f2", "[", "v", "]"}], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.54386970075049*^9, 3.543869754337636*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"bceq1", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "+", 
    RowBox[{"4", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"h", "[", 
          RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], "+", 
       RowBox[{"2", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.537582638122479*^9, 3.5375827515296707`*^9}, {
  3.537582794820052*^9, 3.537582800155078*^9}, {3.5375841048066683`*^9, 
  3.537584107478177*^9}, {3.537584358367179*^9, 3.537584371717182*^9}, {
  3.543869763039016*^9, 3.543869787981166*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"bceq1", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5375827543771067`*^9, 3.5375827552168913`*^9}, 
   3.537582807266088*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      RowBox[{"h2", "[", "v", "]"}], " ", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{"m", "[", "v", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["a1", "\[Prime]",
       MultilineFunction->None], "[", "v", "]"}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "1"],
    SeriesData[$CellContext`z, 0, {}, 0, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   4 $CellContext`h2[$CellContext`v] $CellContext`\[Sigma][$CellContext`v] + 
    8 $CellContext`m[$CellContext`v] $CellContext`\[Sigma][$CellContext`v]^2 + 
    Derivative[1][$CellContext`a1][$CellContext`v]}, 0, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869637371038*^9, {3.5438697650123053`*^9, 3.543869789239808*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"tmp", "/.", "repl"}], "]"}]], "Input",
 CellChangeTimes->{{3.537582756209517*^9, 3.53758276104853*^9}}],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "z", "]"}], "1"],
  SeriesData[$CellContext`z, 0, {}, 1, 1, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.5438696443735247`*^9, {3.543869766077435*^9, 3.543869790290406*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["repl2"], "Input",
 CellChangeTimes->{{3.543869819536687*^9, 3.543869819687505*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t3", "\[Prime]",
      MultilineFunction->None], "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"\[Sigma]", "[", "v", "]"}]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"m", "[", "v", "]"}], "2"], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}], "-", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"a3", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"16", " ", 
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}]}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"t4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "12"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"a1", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"f2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"h2", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"12", " ", 
           RowBox[{"h2", "[", "v", "]"}], " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
          SuperscriptBox[
           RowBox[{"\[Sigma]", "[", "v", "]"}], "4"], "+", 
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["f2", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"4", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"s4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "96"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox[
         RowBox[{"f2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox[
         RowBox[{"h2", "[", "v", "]"}], "2"]}], "-", 
       RowBox[{"48", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "-", 
       RowBox[{"11", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "4"]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"h4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox[
            RowBox[{"m", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"11", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           RowBox[{"f2", "[", "v", "]"}]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["\[Sigma]", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["a1", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "+", 
          RowBox[{
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"\[Sigma]", "[", "v", "]"}], "3"], "+", 
             RowBox[{"8", " ", 
              RowBox[{
               SuperscriptBox["f2", "\[Prime]",
                MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"f2", "[", "v", "]"}], " ", 
           RowBox[{
            SuperscriptBox["m", "\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox["h2", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}], 
      ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"f4", "[", "v", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"t3", "[", "v", "]"}]}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
       RowBox[{
        RowBox[{"a1", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", 
           RowBox[{"h2", "[", "v", "]"}]}], "-", 
          RowBox[{"8", " ", 
           RowBox[{"m", "[", "v", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"f2", "[", "v", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox[
            RowBox[{"m", "[", "v", "]"}], "2"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}]}], ")"}]}], "+", 
       RowBox[{"16", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["h2", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"h2", "[", "v", "]"}], " ", 
        RowBox[{
         SuperscriptBox["m", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"\[Sigma]", "[", "v", "]"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["\[Sigma]", "\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         SuperscriptBox["f2", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "v", "]"}]}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5438698201278677`*^9, 3.543869829239614*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"bceq2", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "+", 
    RowBox[{"2", 
     RowBox[{"m", "[", "v", "]"}], 
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{"2", "z", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "z"}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}]}], "-", 
    RowBox[{"z", " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "z"}], "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}]}], "-", " ", 
    RowBox[{"z", " ", 
     RowBox[{"f", "[", 
      RowBox[{"v", ",", "z"}], "]"}], " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "2"}], "}"}]}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.537583454390378*^9, 3.537583584316988*^9}, {
  3.537583627792901*^9, 3.5375836286954517`*^9}, {3.53758367467208*^9, 
  3.537583682998909*^9}, {3.537583741939487*^9, 3.53758374254697*^9}, {
  3.537583789908886*^9, 3.53758380650729*^9}, {3.537583864503531*^9, 
  3.53758392754637*^9}, {3.537584157247345*^9, 3.5375841601333523`*^9}, {
  3.543869890921344*^9, 3.54386989227345*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"bceq2", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"t", "[", 
       RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"m", "[", "v", "]"}], 
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"v", ",", "z"}], "]"}], "+", 
       RowBox[{"2", "z", " ", 
        RowBox[{"m", "[", "v", "]"}], " ", 
        RowBox[{"\[Sigma]", "[", "v", "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"\[Sigma]", "[", "v", "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"v", ",", "z"}], "]"}], ",", "v"}], "]"}]}], "-", 
    RowBox[{"z", " ", 
     RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
     RowBox[{
      RowBox[{"\[Sigma]", "''"}], "[", "v", "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.537584449977281*^9, 3.537584540147512*^9}, {
  3.543869873209931*^9, 3.5438698836492434`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"bceq2", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5375835627555237`*^9, 3.537583563483652*^9}, {
  3.5375837293866577`*^9, 3.537583730810493*^9}, {3.5375839307205544`*^9, 
  3.537583938135961*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"h2", "[", "v", "]"}], " ", 
       RowBox[{"m", "[", "v", "]"}], " ", 
       RowBox[{"\[Sigma]", "[", "v", "]"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"m", "[", "v", "]"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"\[Sigma]", "[", "v", "]"}], "2"]}], "+", 
      RowBox[{
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["f2", "\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["t3", "\[Prime]",
        MultilineFunction->None], "[", "v", "]"}], "-", 
      RowBox[{
       RowBox[{"\[Sigma]", "[", "v", "]"}], " ", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "v", "]"}]}]}], ")"}], " ", "z"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "2"],
    SeriesData[$CellContext`z, 0, {}, 1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   2 $CellContext`h2[$CellContext`v] $CellContext`m[$CellContext`v] \
$CellContext`\[Sigma][$CellContext`v] + 
    4 $CellContext`m[$CellContext`v]^2 \
$CellContext`\[Sigma][$CellContext`v]^2 + \
$CellContext`\[Sigma][$CellContext`v] 
     Derivative[1][$CellContext`f2][$CellContext`v] + 
    Derivative[
     1][$CellContext`t3][$CellContext`v] - \
$CellContext`\[Sigma][$CellContext`v] 
    Derivative[2][$CellContext`\[Sigma]][$CellContext`v]}, 1, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869801272677*^9, {3.543869874772071*^9, 3.5438698971663313`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"tmp", "/.", "repl2"}], "]"}]], "Input",
 CellChangeTimes->{{3.537583943735824*^9, 3.537583946472803*^9}}],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "z", "]"}], "2"],
  SeriesData[$CellContext`z, 0, {}, 2, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.543869802865644*^9, {3.5438698763090973`*^9, 3.54386989771704*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1045, 924},
WindowMargins->{{203, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "calcgeom"->{
  Cell[37420, 1038, 306, 9, 73, "Input",
   CellTags->"calcgeom"],
  Cell[37729, 1049, 293, 10, 73, "Input",
   CellTags->"calcgeom"],
  Cell[38025, 1061, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[38292, 1072, 264, 9, 58, "Input",
   CellTags->"calcgeom"],
  Cell[38559, 1083, 3551, 100, 139, "Input",
   CellTags->"calcgeom"],
  Cell[42113, 1185, 155, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[42475, 1197, 5599, 153, 178, "Input",
   CellTags->"calcgeom"],
  Cell[48077, 1352, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[48222, 1358, 1615, 48, 88, "Input",
   CellTags->"calcgeom"],
  Cell[49840, 1408, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[49985, 1414, 633, 22, 27, "Input",
   CellTags->"calcgeom"],
  Cell[50621, 1438, 1648, 51, 113, "Input",
   CellTags->"calcgeom"],
  Cell[52272, 1491, 142, 4, 27, "Input",
   CellTags->"calcgeom"],
  Cell[52417, 1497, 145, 4, 27, "Input",
   CellTags->"calcgeom"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"calcgeom", 515494, 14616}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 823, 12, 46, "Subtitle"],
Cell[CellGroupData[{
Cell[1427, 38, 68, 1, 27, "Input"],
Cell[1498, 41, 99, 1, 20, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1634, 47, 111, 1, 26, "Subsubtitle"],
Cell[1748, 50, 95, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[1868, 56, 279, 8, 58, "Input"],
Cell[2150, 66, 207, 5, 70, "Output"],
Cell[2360, 73, 610, 16, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3007, 94, 266, 9, 58, "Input"],
Cell[3276, 105, 94, 1, 70, "Output"],
Cell[3373, 108, 94, 1, 70, "Output"]
}, Open  ]],
Cell[3482, 112, 407, 13, 27, "Input"],
Cell[3892, 127, 37, 0, 27, "Input"],
Cell[CellGroupData[{
Cell[3954, 131, 257, 8, 58, "Input"],
Cell[4214, 141, 181, 4, 70, "Output"],
Cell[4398, 147, 92, 1, 70, "Output"]
}, Open  ]],
Cell[4505, 151, 2020, 62, 103, "Input"],
Cell[6528, 215, 26, 0, 27, "Input"],
Cell[6557, 217, 841, 25, 43, "Input"],
Cell[7401, 244, 1026, 31, 58, "Input"],
Cell[8430, 277, 227, 8, 86, "Text"],
Cell[8660, 287, 4015, 95, 238, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[12712, 387, 111, 3, 26, "Subsubtitle"],
Cell[12826, 392, 128, 4, 26, "Text"],
Cell[12957, 398, 6139, 139, 718, "Input"],
Cell[19099, 539, 68, 1, 26, "Text"],
Cell[19170, 542, 3727, 84, 523, "Input"],
Cell[22900, 628, 824, 18, 208, "Input"],
Cell[23727, 648, 4051, 89, 583, "Input"],
Cell[27781, 739, 99, 2, 27, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[27917, 746, 34, 0, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[27976, 750, 3220, 66, 173, "Input"],
Cell[31199, 818, 1248, 40, 50, "Output"],
Cell[32450, 860, 161, 3, 27, "Output"],
Cell[32614, 865, 94, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32745, 871, 28, 0, 27, "Input"],
Cell[32776, 873, 1248, 40, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34061, 918, 28, 0, 27, "Input"],
Cell[34092, 920, 2524, 82, 98, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36653, 1007, 119, 3, 27, "Input"],
Cell[36775, 1012, 561, 18, 52, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37385, 1036, 32, 0, 26, "Subsubtitle"],
Cell[37420, 1038, 306, 9, 73, "Input",
 CellTags->"calcgeom"],
Cell[37729, 1049, 293, 10, 73, "Input",
 CellTags->"calcgeom"],
Cell[38025, 1061, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[38292, 1072, 264, 9, 58, "Input",
 CellTags->"calcgeom"],
Cell[38559, 1083, 3551, 100, 139, "Input",
 CellTags->"calcgeom"],
Cell[42113, 1185, 155, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[42271, 1191, 201, 4, 27, "Input"],
Cell[42475, 1197, 5599, 153, 178, "Input",
 CellTags->"calcgeom"],
Cell[48077, 1352, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[48222, 1358, 1615, 48, 88, "Input",
 CellTags->"calcgeom"],
Cell[49840, 1408, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[49985, 1414, 633, 22, 27, "Input",
 CellTags->"calcgeom"],
Cell[50621, 1438, 1648, 51, 113, "Input",
 CellTags->"calcgeom"],
Cell[52272, 1491, 142, 4, 27, "Input",
 CellTags->"calcgeom"],
Cell[52417, 1497, 145, 4, 27, "Input",
 CellTags->"calcgeom"]
}, Closed]],
Cell[CellGroupData[{
Cell[52599, 1506, 41, 0, 26, "Subsubtitle"],
Cell[52643, 1508, 173, 4, 27, "Input"],
Cell[52819, 1514, 645, 21, 27, "Input"],
Cell[53467, 1537, 1146, 34, 118, "Input"],
Cell[54616, 1573, 1792, 51, 118, "Input"],
Cell[56411, 1626, 710, 23, 58, "Input"],
Cell[57124, 1651, 3455, 96, 238, "Input"],
Cell[60582, 1749, 388, 12, 27, "Input"],
Cell[60973, 1763, 434, 10, 27, "Input"],
Cell[61410, 1775, 508, 12, 46, "Input"],
Cell[61921, 1789, 4135, 133, 141, "Input"],
Cell[66059, 1924, 6843, 214, 199, "Input"],
Cell[72905, 2140, 237, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[73167, 2149, 3999, 129, 141, "Input"],
Cell[77169, 2280, 147, 3, 27, "Output"],
Cell[77319, 2285, 147, 3, 27, "Output"],
Cell[77469, 2290, 147, 3, 27, "Output"],
Cell[77619, 2295, 147, 3, 27, "Output"]
}, Open  ]],
Cell[77781, 2301, 1262, 33, 148, "Input"],
Cell[79046, 2336, 1027, 21, 58, "Input"],
Cell[80076, 2359, 677, 17, 58, "Input"],
Cell[80756, 2378, 1027, 30, 118, "Input"],
Cell[81786, 2410, 161, 3, 27, "Input"],
Cell[81950, 2415, 745, 18, 88, "Input"],
Cell[CellGroupData[{
Cell[82720, 2437, 1146, 32, 238, "Input"],
Cell[83869, 2471, 6434, 189, 110, "Output"],
Cell[90306, 2662, 6147, 187, 110, "Output"],
Cell[96456, 2851, 2199, 73, 77, "Output"],
Cell[98658, 2926, 3674, 116, 87, "Output"],
Cell[102335, 3044, 5174, 164, 110, "Output"],
Cell[107512, 3210, 11888, 358, 170, "Output"],
Cell[119403, 3570, 1431, 49, 77, "Output"],
Cell[120837, 3621, 7048, 216, 127, "Output"]
}, Open  ]],
Cell[127900, 3840, 2631, 55, 169, "Input"],
Cell[CellGroupData[{
Cell[130556, 3899, 975, 25, 238, "Input"],
Cell[131534, 3926, 91, 1, 27, "Output"],
Cell[131628, 3929, 94, 1, 27, "Output"],
Cell[131725, 3932, 94, 1, 27, "Output"],
Cell[131822, 3935, 94, 1, 27, "Output"],
Cell[131919, 3938, 94, 1, 27, "Output"],
Cell[132016, 3941, 92, 1, 27, "Output"],
Cell[132111, 3944, 92, 1, 27, "Output"],
Cell[132206, 3947, 92, 1, 27, "Output"]
}, Open  ]],
Cell[132313, 3951, 292, 6, 27, "Input"],
Cell[132608, 3959, 3095, 69, 148, "Input"],
Cell[CellGroupData[{
Cell[135728, 4032, 2122, 60, 67, "Input"],
Cell[137853, 4094, 63864, 1800, 906, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[201754, 5899, 1438, 41, 33, "Input"],
Cell[203195, 5942, 56322, 1475, 696, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[259554, 7422, 1074, 32, 88, "Input"],
Cell[260631, 7456, 94, 1, 27, "Output"],
Cell[260728, 7459, 94, 1, 27, "Output"],
Cell[260825, 7462, 94, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[260956, 7468, 1910, 67, 105, "Input"],
Cell[262869, 7537, 2702, 89, 70, "Output"],
Cell[265574, 7628, 2892, 94, 72, "Output"],
Cell[268469, 7724, 48342, 1286, 448, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[316848, 9015, 3045, 110, 177, "Input"],
Cell[319896, 9127, 11901, 350, 152, "Output"],
Cell[331800, 9479, 12081, 384, 188, "Output"],
Cell[343884, 9865, 5079, 149, 120, "Output"],
Cell[348966, 10016, 7406, 229, 196, "Output"],
Cell[356375, 10247, 25280, 692, 262, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[381692, 10944, 2263, 68, 118, "Input"],
Cell[383958, 11014, 1448, 51, 33, "Output"]
}, Open  ]],
Cell[385421, 11068, 943, 19, 27, "Input"],
Cell[CellGroupData[{
Cell[386389, 11091, 822, 19, 58, "Input"],
Cell[387214, 11112, 612, 8, 88, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[387863, 11125, 548, 15, 58, "Input"],
Cell[388414, 11142, 739, 10, 88, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[389190, 11157, 548, 15, 58, "Input"],
Cell[389741, 11174, 383, 5, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[390161, 11184, 548, 15, 58, "Input"],
Cell[390712, 11201, 656, 9, 88, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[391405, 11215, 550, 15, 58, "Input"],
Cell[391958, 11232, 1272, 18, 163, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[393267, 11255, 874, 20, 58, "Input"],
Cell[394144, 11277, 283, 4, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[394464, 11286, 552, 15, 58, "Input"],
Cell[395019, 11303, 255, 3, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[395311, 11311, 550, 15, 58, "Input"],
Cell[395864, 11328, 2379, 33, 298, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[398280, 11366, 702, 13, 73, "Input"],
Cell[398985, 11381, 179, 2, 27, "Output"]
}, Open  ]],
Cell[399179, 11386, 3117, 99, 188, "Input"],
Cell[CellGroupData[{
Cell[402321, 11489, 2324, 71, 238, "Input"],
Cell[404648, 11562, 967, 27, 52, "Output"],
Cell[405618, 11591, 987, 27, 30, "Output"],
Cell[406608, 11620, 939, 25, 49, "Output"],
Cell[407550, 11647, 662, 20, 46, "Output"],
Cell[408215, 11669, 666, 20, 46, "Output"],
Cell[408884, 11691, 662, 20, 46, "Output"],
Cell[409549, 11713, 662, 20, 46, "Output"],
Cell[410214, 11735, 662, 20, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[410913, 11760, 800, 21, 27, "Input"],
Cell[411716, 11783, 1768, 54, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[413521, 11842, 2671, 81, 268, "Input"],
Cell[416195, 11925, 2834, 75, 65, "Output"],
Cell[419032, 12002, 2767, 73, 65, "Output"],
Cell[421802, 12077, 209, 6, 30, "Output"],
Cell[422014, 12085, 2271, 60, 47, "Output"],
Cell[424288, 12147, 2104, 55, 52, "Output"],
Cell[426395, 12204, 1496, 40, 52, "Output"],
Cell[427894, 12246, 1254, 34, 30, "Output"],
Cell[429151, 12282, 3082, 79, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[432270, 12366, 1081, 25, 27, "Input"],
Cell[433354, 12393, 7278, 208, 192, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[440669, 12606, 2995, 88, 268, "Input"],
Cell[443667, 12696, 7514, 189, 132, "Output"],
Cell[451184, 12887, 6297, 152, 71, "Output"],
Cell[457484, 13041, 209, 6, 30, "Output"],
Cell[457696, 13049, 4450, 109, 69, "Output"],
Cell[462149, 13160, 4747, 115, 69, "Output"],
Cell[466899, 13277, 3855, 95, 69, "Output"],
Cell[470757, 13374, 4179, 104, 53, "Output"],
Cell[474939, 13480, 4448, 109, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[479424, 13594, 1109, 25, 27, "Input"],
Cell[480536, 13621, 17260, 456, 340, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[497833, 14082, 99, 1, 27, "Input"],
Cell[497935, 14085, 1789, 54, 77, "Output"]
}, Open  ]],
Cell[499739, 14142, 826, 22, 27, "Input"],
Cell[CellGroupData[{
Cell[500590, 14168, 308, 8, 27, "Input"],
Cell[500901, 14178, 990, 26, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[501928, 14209, 155, 3, 27, "Input"],
Cell[502086, 14214, 260, 7, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[502383, 14226, 97, 1, 27, "Input"],
Cell[502483, 14229, 7304, 208, 192, "Output"]
}, Open  ]],
Cell[509802, 14440, 1761, 50, 43, "Input"],
Cell[511566, 14492, 997, 29, 27, "Input"],
Cell[CellGroupData[{
Cell[512588, 14525, 382, 9, 27, "Input"],
Cell[512973, 14536, 1719, 47, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[514729, 14588, 157, 3, 27, "Input"],
Cell[514889, 14593, 259, 7, 30, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
